/* StartPMMail.CMD - hides all accounts but the one given as the commandline  */
/*                   parameter, then starts pmmail                            */
/*                                                                            */
/* needs the following commandline parameters:                                */
/* - the account name of the account you want to display when starting PMMail */
/*   if this name has spaces in it (ie. My Account), be sure to fill the      */
/*   spaces in with the '_' (underscore) character                            */
/*   if you want to view all accounts, make the account name 'ALL'            */
/*                                                                            */
/* example of starting script                                                 */
/*   StartPMMail MyAccountName AnyOtherParametersYou'dPassToPMMail            */
/*                                                                            */
/* example of starting script (this one has a account name of 'My Account'    */
/*   StartPMMail My_Account /F                                                */
/*                                                                            */
/* this script must be run in the same directory as is the PMMAIL.EXE file    */
/* ie. C:\SOUTHSDE\PMMAIL\StartPMMail.CMD                                     */
/*                                                                            */
/* the StartPMMail.CFG file must be deleted if PMMail is moved from it's      */
/* current directory location                                                 */
/*                                                                            */
/* *** WARNING *** Please Read The Following!                                 */
/*                                                                            */
/* if you suddenly 'loose' an account you used to have, simply do this:       */
/*                                                                            */
/* 1. open a commandline session in the \SOUTHSDE\PMMAIL directory            */
/* 2. type 'DIR /AD' to view the directory names within the \PMMAIL directoty */
/*    these names are the account(s) you previously 'lost'                    */
/* 3. type 'ATTRIB -h DirName.ACT' where DirName.ACT is the name(s) of the    */
/*    accounts to bring back                                                  */
/*                                                                            */
/* *** WARNING *** Please Read The Preceeding!                                */

/* register the extended REXX functions                                       */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/* set the jump points for program stoppage                                   */
signal on failure name CLEANUP
signal on halt name ABORTED_MAN
signal on syntax name CLEANUP

/* parse commandline parameter for the account name to open plus 3 more       */
/* commandline parameters if they are specified ie. -F -D                     */
PARSE UPPER ARG AccountToOpen Parameter_1 Paramater_2 Parameter_3 .

/* check to see if the account name is space delimited and if so, remove the  */
/* '_' character and replace it with a proper ' ' space character             */
do Counter = 1 to LENGTH(AccountToOpen)
  if SUBSTR(AccountToOpen, Counter, 1) = '_' then do
    AccountToOpen = DELSTR(AccountToOpen, Counter, 1)
    AccountToOpen = INSERT(' ', AccountToOpen, Counter - 1)
  end
end 

/* hey clear the screen                                                       */
call SysCls

/* determine if we've searched for the PMMail account directory yet, and if   */
/* not, find it and then write the location to the file StartPMMail.CFG       */
StartPMMailCFGFileName = 'StartPMMail.CFG'
OurCurrentDirectory = DIRECTORY()
call SysFileTree StartPMMailCFGFileName, CrapVariable, 'F'
if CrapVariable.0 = 0 then do
  say 'Since this is the first time you''ve run this script, we will now'
  say 'scan your harddrives for the PMMail account directory and then write a'
  say 'configuration file named StartPMMail.CFG with this info in it.'
  say ''
  say 'This may take a few minutes.'
  say ''
  DrivesAvailableString = SysDriveMap('C:', 'USED')
  DriveLetter.0 = WORDS(DrivesAvailableString)
  do Counter = 1 to DriveLetter.0
    DriveToCheck = WORD(DrivesAvailableString, Counter)
    say 'Scanning drive 'DriveToCheck
    call SysFileTree DriveToCheck||'\PMMAIL.EXE', 'PMMailAccountDirectory', 'SF'
    if PMMailAccountDirectory.0 <> 0 then leave
  end
  PMMailAccountDirectory = WORD(LEFT(PMMailAccountDirectory.1,LASTPOS('\',PMMailAccountDirectory.1)), 5)
  call LINEOUT StartPMMailCFGFileName, PMMailAccountDirectory
end
else do
  StartPMMailCFGFileName = SUBWORD(CrapVariable.1,5)
  PMMailAccountDirectory = LINEIN(StartPMMailCFGFileName)
end
say ''
say 'Your accounts are located in 'PMMailAccountDirectory

/* make sure this script is being run in the \SOUTHSDE\PMMAIL directory where */
/* the PMMAIL.EXE binary is located - if not then exit with warning           */
CurrentDirectory = DIRECTORY()
PUSH CurrentDirectory
PULL CurrentDirectory
CurrentDirectory = CurrentDirectory||'\'
if PMMailAccountDirectory <> CurrentDirectory then do
  say ''
  say 'StartPMMail.CMD must be located and run from the same directory where'
  say 'your PMMAIL.EXE file resides. Relocate script file and rerun.'
  signal ABSOLUTE_END
end

/* search the accounts (subdirectories) and find the number of accounts       */
/* plus their true names                                                      */
say ''
call SysFileTree PMMailAccountDirectory||'ACCT.CFG', 'PMMailAccountCFGFilePath', 'SF'
if PMMailAccountCFGFilePath.0 = 0 then do
  say ''
  say 'No accounts were found. Aborting.'
  signal ABSOLUTE_END
end
else do
  do Counter = 1 to PMMailAccountCFGFilePath.0
    PMMailAccountCFGFilePath.Counter = WORD(PMMailAccountCFGFilePath.Counter, 5)
  end
end

/* unhide previously hidden directories (accounts) so we can start fresh      */
call SysFileTree PMMailAccountDirectory, 'Garbage', 'D', '*****', '**-**'

/* check to see if we're to display all accounts                              */
if AccountToOpen = 'ALL' then signal SkipItAll

/* search through the ACCT.CFG file(s) to find the true account names         */
SearchString = 'ACCTNAME'
do Counter_1 = 1 to PMMailAccountCFGFilePath.0
  PMMailAccountCFGFilePath.Counter_1 = PMMailAccountCFGFilePath.Counter_1  
  AccountNameFound = 'FALSE'  
  do until AccountNameFound = 'TRUE'
    rc = CHARIN(PMMailAccountCFGFilePath.Counter_1)
    if rc = SUBSTR(SearchString, 1, 1) then do
      SubStringCounter = 1
      do Counter_2 = 1 to LENGTH(SearchString) - 1
        SubStringCounter = SubStringCounter + 1
        rc = CHARIN(PMMailAccountCFGFilePath.Counter_1)
        if rc <> SUBSTR(SearchString, SubStringCounter, 1) then leave
        if (SubStringCounter = LENGTH(SearchString)) & (Counter_2 = LENGTH(SearchString) - 1) then do
          AccountNameFound = 'TRUE'
          NullCharFound = 'FALSE'
          AccountName.Counter_1 = ''
          rc = CHARIN(PMMailAccountCFGFilePath.Counter_1)
          do until NullCharFound = 'TRUE'
            rc = CHARIN(PMMailAccountCFGFilePath.Counter_1)
            if rc <> '00'x then do
              AccountName.Counter_1 = AccountName.Counter_1 || rc
            end
            else do
              NullCharFound = 'TRUE'
            end
          end
        end
      end
    end
  end
  say 'Account number 'Counter_1' is called '''AccountName.Counter_1''''
  PUSH AccountName.Counter_1
  PULL AccountNameFound.Counter_1
end

/* see if the account given in the commandline parameter matches one of the   */
/* accounts we found                                                          */
/* if one matches, then hide all other account directories                    */
call SysFileTree PMMailAccountDirectory, 'Garbage', 'D', '*****', '**+**'
do Counter = 1 to PMMailAccountCFGFilePath.0
  DirectoryNameToUnHide.Counter = LEFT(PMMailAccountCFGFilePath.Counter, LASTPOS('\', PMMailAccountCFGFilePath.Counter) - 1)
  DirectoryNameToUnHide.Counter = SUBSTR(DirectoryNameToUnHide.Counter, LASTPOS('\', DirectoryNameToUnHide.Counter) + 1)
  if AccountNameFound.Counter = AccountToOpen then do
    call SysFileTree PMMailAccountDirectory||DirectoryNameToUnHide.Counter, 'Garbage', 'D', '*****', '**-**'
  end
end

SkipItAll:

/* now start pmmail                                                           */
call SysSetObjectData PMMailAccountDirectory||'PMMAIL.EXE', 'OPEN = DEFAULT;'

exit

CLEANUP:
  ErrRC = rc
  say 'Error' ErrRC 'at line' sigl ', sourceline:' sourceline(sigl)
exit ErrRC
ABORTED_MAN:
  trace ?r
  nop
ABSOLUTE_END:
exit ErrRC