/*
YDINSTL.CMD v 1.53 by Jerry Levy 13 Mar 97
Comments appreciated: send to jlevy@ibm.net
(Jerry Levy, Marblehead, MA USA)
*/
version = '1.53'

/*
===========History============
See YD.DOC for details.

YARNDIAL.CMD v. 1.53   13 Mar 97
  Some fixes

YARNDIAL.CMD v. 1.52 (GA Release)   04 Mar 97
  Numerous small changes/customization/corrections so runs
  equally well under Object ReXX as well as Classic ReXX

YARNDIAL v. 1.50     25 Jan 97
   Final beta.
   Added: multiple ISP's

YARNDIAL v. 1.42 (several betas)     to 25 Jan 97
   Bug-catching in YARNDIAL.CMD.
   Support for use of VSOUP (VSOUP1.2.5) as alternative to SOUPER.
   Eliminated TIMER.CMD (see README.1ST, YD.DOC).
   Changes in YDINSTL, mostly related to VSoup support.
   Souper and VSoup _xtra_options changed

========ERROR TRAPPING============
We can trap and identify various types of ReXX error
conditions:  Error, Syntax, Failure, Novalue, Halt
and Notready, by setting 
        local_error_trapping = 0

Default is
        local_error_trapping = 0
but if you have problems, briefly setting local_error_trapping = 1
may help you identify source of an error.
==================================
*/
local_error_trapping = 0

/*
================WHAT DO WE DO?================================
YDINSTL.CMD is a Rexx program to install YARNDIAL.

YARNDIAL is a program to automate the use of YARN and SOUPER
It serves as a front end for C.T. Huang's OS/2 Souper and Yarn programs. 

YD.DOC is documentation for both the installer and YARNDIAL.

README.1ST is YD.DOC boiled down to essentials.
 
This installer goes out and fetches parameters required by
YARNDIAL.  Installations can be done for every yarn user you
have set up.  Read YD.DOC to learn more about setting up for
multiple users (A different "user"  a different ID,
an installation for a different internet provider, or a
different internet connection mode for a given ID).

Each different user for which you set up YARN has been assigned
its own home directory and you can (should) do an install with
YDINSTL.CMD for each.  For each installation, separate Desktop
objects are created which are named to uniquely tie them to a
particular installation.  For each installation, a unique
parameter file (YD_PARMS.DAT) is created and stored in the
home directory.

YDINSTL.CMD also creates a suite of useful Rexx .CMD utilities
which are placed in the home directory also.

This YDINSTL.CMD v. 0.94 is distributed with YARNDIAL v1.34

==========COPYRIGHT NOTICE AND DISCLAIMER=============
YDINSTL.CMD is Copyright 1996-7 by Jerry Levy (all rights reserved)
YARNDIAL.CMD is Copyright 1995-7 by Jerry Levy (all rights reserved)

These are provided as-is and without charge, with no warranty expressed
or implied as to merchantability or fitness for any particular purpose.  All
responsibility for any and all incidental and consequential damages is
disclaimed.  These programs and associated text files are freeware.  They
may be distributed without restriction providing: (1) this notice and
disclaimer remain intact, (2) all programs and files are included and
unchanged, and (3) they are distributed either in the original .zip archive
or the archive after being unzipped into a folder or onto a disk or other
medium.  Use of either or both of these programs constitutes acceptance
of these terms by all users.
======================================================
*/

bs = d2c(8)
tab = d2c(9)        /* Backspace */
cr = d2c(13)        /* enter key, as well as carriage return */
crlf = d2c(13) || d2c(10)        /* carriage return + linefeed */
escape = d2c(27)        /* escape character */
X1 = d2c(0)        /* Extended key */
X2 = d2c(224)        /* Extended key */

/* Load RexxUtil if not already loaded */
if RxFuncQuery('SysLoadFuncs') \= 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

candidate = ''
encrypt = 0
connection_type = 0
piggyback = 0
edit_dialup_string_msg = ''

parse arg instr candidate
if translate(instr) = 'ENCRYPT' then
   do
      call SysCls
      say ''
      encrypt = 1
      call encry
      exit
   end

/* Initialize these filenames */
yd_doc = 'YD.DOC'        /* documentation file */
readme_1st = 'README.1ST'        /* shorter one */
ydparms_dat = 'YD_PARMS.DAT'        /* where we will store parameters */
ydaltparms_dat = 'YD_ALT.DAT'        /* where we store alternate parameters */
yd_cmd = 'YARNDIAL.CMD'        /* this is the YarnDial file we are installing for */
ydinstl_cmd = 'YDINSTL.CMD'        /* and this is us, the installer */
yarn_ico = 'YARN.ICO'        /* the Yarn icon (courtesy of C.T. Huang) */
yarnshell_ico = yarn_ico        /* ...which we use more than once */
yarndial_ico = 'YARNDIAL.ICO'        /* the YarnDial icon */
ydfold1_ico = 'YDFOLD1.ICO'        /* for our desktop folder: icon for when it is closed */
ydfold2_ico = 'YDFOLD2.ICO'        /* for our desktop folder: animated icon, folder when open */ 
yarnutil_ico = 'YRNUTIL.ICO'        /* for yarnutil_cmd */ 
logoff_ico = 'LOGOFF.ICO'        /* for logoff_cmd */ 
renewzip_ico = 'RENEWZIP.ICO'        /* for renewzip_cmd */ 
ydinstl_ico = 'YDINSTL.ICO'        /* for ydinstl_cmd */

/*
===========
parse version returns the following for these 
different ReXX's:

REXXSAA
REXX 4.00 (various dates for various distributions)

OBJECT REXX (distributed with Warp 4.0)
OBJREXX 6.00 12 Jul 1996
============
*/ 

os2Obj_Rexx = 'OBJREXX'
os2Classic_Rexx = 'REXXSAA'

parse version rxsystem
rexx_type = translate(rxsystem)

if local_error_trapping then signal on failure
if local_error_trapping then signal on halt
if local_error_trapping then signal on syntax
if local_error_trapping then signal on notready
if local_error_trapping then signal on error
if local_error_trapping then signal on novalue

Trace 'N'

call time 'R'
yd_cmd_v = '2.0'

/*
============================
We use Abandon=1 returned by a subroutine
as a signal to abort.  We abort by making a
conditional call to exit in the caller routine,
example:     if Abandon then signal goodbye()
============================
*/
   Abandon = 0

/* Completed flag will be set to 1 when we are done */
   completed = 0

/* These are set to 1 or cleared for (certain) in-joy errors */
   other_err = 0
   ijparms_err1 = 0
   ijparms_errmsg1 = ''
   ijparms_err2 = 0
   ijparms_errmsg2 = ''

/* We count file-search errors */
   findfile_ErrNum = 0

/* if an error when we try to create objects, we set to  1 */
object_creation_error = 0


Upcase = xrange('A', 'Z')        /* Translation tables we use for going */
Lowcase = xrange('a', 'z')        /* from upper to lower case */

parse source with this_pgm
/* This program including path is last word.  Extract its
path, stripping out a final \ */

this_pgm = word(this_pgm, words(this_pgm)) /* we are last word if more than one */
source_drive = filespec('drive', this_pgm) /* get our drive...*/
source_subdir = filespec('path', this_pgm) /* ...and dir */
source_path = source_drive || source_subdir /* reconstruct path... */
source_path = strip(source_path, 'T', '\')  /* ...removing terminal backslash */
source_path = translate(source_path)        /* Looks prettier in upper case */
x = SetLocal()

'@echo off'        /* do not echo OS/2 commands */
call welcome_to_this_installer        /* big welcome message */
call initialize_variables

/*
=============
Do we use the IAK Dialer, the Dial-Other-
Internet-Providers utility, or a dialup string?
=============
*/
call get_connection_type
call get_ini_paths        /* for dialer.ini and tcpos2.ini */
call find_yarn_home_dir        /* set as an os/2 environment variable? or we can specify it */ 
call find_yarn_dir        /* YARN, set as an os/2 environment variable */

/* read in some assignments from the Yarn CONFIG file */
call get_parms_from_yarn_config

/*
============
If connection_type = 4 or 5 we need to get dialer filename.
Then, depending on dialer we chose, we can get our
parameters from a previously set up SLIPPM entry
or we ask to be prompted for them for keyboard entry.

The get_alt_dialer_exe routine gets the full path to
the dialer, and also strips any options that may have been
entered and then generates (except for slippm)
alt_dialer_exe        fully qualified path and name
alt_dialer_dir        drive and path part with final '\'
alt_dialer_path        drive and path part without final '\'
alt_dialer_name        filename without drive or path
alt_dialer        file part of file.ext

alt_dialer_exe is not likely to be the IAKdialer which
is covered by connection_type 1, nor is it likely to be
PPP.EXE or SLIP.EXE either, both of which are covered by
connection_type 3. 
==================
*/
if pos(connection_type, '45') \= 0 then
   do
      call get_alt_dialer_exe

      select
        when alt_dialer_exe = 'SLIPPM' | alt_dialer_exe = SLIPPM_EXE,
         | alt_dialer = 'SLIPPM' then
        do
           alt_dialer_exe = SLIPPM_EXE
           alt_dialer_name = SLIPPM_EXE
           alt_dialer = 'SLIPPM'
           alt_dialer_path = ''
        end

         when alt_dialer_name \= SLIPPM_EXE,
         & alt_dialer_name \= ILINK2_EXE then
         call should_we_piggyback_on_slippm

         otherwise NOP
      end        /* of Select */
   end
   
if connection_type = 3 then
   call should_we_piggyback_on_slippm

select    /* for different connection types */
   when connection_type = 1 then
      do
         service = 'SLIP'
        /* dialer.ini stores the IAK Dialer parameters... */
         call get_parms_from_advantis_dialerini
         call get_passw_POP3PWD
         PWD = POP_PWD        /* for IBM/IGN/Advantis */
        /* construct the dialup_string */
         dialup_string ='''start' IAKdialer_exe || ''' account login_id.1 pop_pwd.1'
         alt_dialer_exe = translate(IAKdialer_exe)
         alt_dialer_name = 'DIALER.EXE'
         alt_dialer = 'DIALER'
         alt_dialer_path = ''
      end

   when pos(connection_type, '345') \= 0 then
      do
         if piggyback then
        do
           host_app = get_dial_other_providers_app(tcpos2_ini)
           call get_parms_from_tcpos2ini
           if alt_dialer = 'IN-JOY' then call get_injoy_parms
       end
      else
        do
           if alt_dialer = 'IN-JOY' then
        do
           call get_injoy_parms
        end
        if alt_dialer \= 'IN-JOY' & \ijparms_err1 & \ijparms_err2 then
        do
           call get_dialer_app /* argument dialer uses to connect */
           call get_domain
           call get_login_id
           if alt_dialer = 'IN-JOY' then call get_interface_prefix
           call get_comport
        end
/* These get prompted-for for all dialers if piggyback = 0 */
         call get_userID
         call are_we_SLIP_or_PPP
         call get_nameservers
         call get_pop3mail_server
         call get_smtp_server
         call get_news_server
         call get_passw_POP3PWD
         call get_passw_PWD
      end    /* of else clause */
   end        /* of Do, for "when pos(connection_type, '345') \= 0" */

    otherwise NOP
end /* of select, for different connection types */

if connection_type = 3 & service = 'SLIP' then
   do
     alt_dialer_exe = 'SLIP.EXE'
     alt_dialer_name = 'SLIP.EXE'
     alt_dialer_path = ''
     alt_dialer = 'SLIP'
     dialup_string ='''start /c' alt_dialer_name || ''' **FILL IN REMAINDER...**'
   end
if connection_type = 3 & service = 'PPP' then
   do
     alt_dialer_exe = 'PPP.EXE'
     alt_dialer_name = 'PPP.EXE'
     alt_dialer_path = ''
     alt_dialer = 'PPP'
     dialup_string ='''start /c' alt_dialer_name || ''' **FILL IN REMAINDER...**'
   end

if pos(connection_type, '45') \= 0 then 
   select   /* different alt_dialer_name's */
      when alt_dialer_name = SLIPPM_EXE then
         do
            dialup_string ='''start' slippm_exe || ''' host_app'
         end

      when alt_dialer_name = ILINK2_EXE then
         do
            dialup_string = 'do;',
            '''' || alt_dialer_drive || ''';',
            '''cd' alt_dialer_dir || ''';',
            '''start /N' alt_dialer_exe || ''' host_app;',
            'end'
      end

      when alt_dialer_name = 'SLIP.EXE' | alt_dialer_name = 'PPP.EXE' then
         do
            dialup_string ='''start' alt_dialer_name || ''' **FILL IN REMAINDER...**'
         end
      when alt_dialer_name = IAKDialer_exe then
         do
            service = 'SLIP'
        /* dialer.ini stores the IAK Dialer parameters... */
            call get_parms_from_advantis_dialerini
            call get_passw_POP3PWD
            PWD = POP_PWD        /* for IBM/IGN/Advantis */
        /* construct the dialup_string */
            dialup_string ='''start' IAKdialer_exe || ''' account login_id.1 pop_pwd.1'
            alt_dialer_exe = IAKdialer_exe
         end

      when alt_dialer_name = INJOY_EXE then
         do
            dialup_string = 'do;',
            '''' || alt_dialer_drive || ''';',
            '''cd' alt_dialer_dir || ''';',
            '''start /N' alt_dialer_exe || ''' host_app;',
            'end'
         end


      otherwise        /* any other dialer not mentioned */
         dialup_string = 'do;',
           '''' || alt_dialer_drive || ''';',
           '''cd' alt_dialer_dir || ''';',
           '''start /N' alt_dialer_exe || ''' host_app;',
           'end'
   end  /* of select for different alt_dialer_exe's */ 

if alt_dialer_name \= INJOY_EXE then
   do
      interf_prefix = service
      if service = 'SLIP' then interf_prefix = 'SL'
   end

/* What soup transfer program are we using for mail and news? */
call are_we_using_souper_or_vsoup

/* What kind of compression utilities? InfoZip's? PkWare's? others'? */
call whose_zips_are_we_using

/* Do searches for files we need.  Gets full paths */
call search_for_files

/* Tailor how you want souper to run: can modify some command-line options */
call souper_options

/* Choice whether or not to allow connection to remain up after all
transfers are completed (change in main YARNDIAL menu)
and prompt for the alternate characters to use to do it */

call enable_dnk_option
call get_dnk_string

/* How many seconds before dialer times out (for connection_type 1, 2, and 3) */
call get_dialer_timeout_wait

/* Set size of maximized window for yrnshell_cmd runs */
call get_shell_windowsize

/* How deal with phantom interface problem? */
call set_interf_removal

/* Up to this point, no changes have been made.  A chance
to exit the install at this point without making any changes */
call chance_to_quit

/* Create the YD_PARMS.DAT file where all our parameters go.
YARNDIAL.CMD uses this file as a setup file */
call output_dat

/* Copy files over from installation directory to home dir */
call copy_ydfiles

/*
==============
We create a suite of five customized REXX utilities on the HOME directory.

YARNSHELL.CMD:  Runs YARN.EXE from the correct environment for this user

YARNUTIL.CMD:  Run any yarn utility pgm for this user

RENEWZIP.CMD:  Restores the reply_packet .ZIP file (backed up during
   an attempt to export) for a re-try later (RENEWZIP.CMD), again for this user

LOGOFF.CMD:  Provides a convenient way to log off

OBJECTS.CMD:  Restores a folder object and contents (objects for the four
.CMD files above, plus an object for YarnDial.CMD, for this user installation
==============
*/
call create_yarnshell_cmd
call create_yarnutil_cmd
call create_logoff_cmd
call create_renewzip_cmd
call create_yarndial_objects

/* Finally we create a Rexx pgm to recreate objects */
call recreate_objects_cmd
signal goodbye        /* cleanup and exit */
EXIT
/*
==============================================
End of Main Program
==============================================
*/

/*
==============================================
get_connection_type()

Are we installing for a connection to IBM/IGN/Advantis
via the IAK Dialer
   or
a connection via either SLIP or PPP using the
Dial-Other-Internet-Providers Utility?
==============================================
*/
get_connection_type:
edit_dialup_string_msg =  ''        /* initialize to a blank */
call SysCls
say ''
say 'CONNECTION-TYPE SCREEN'
say 'You must select the type of connection you will be making'
say 'to your Internet Service Provider'
say ''
say 'How will you dial in to connect?'
say '  1 With the IAK Internet Dialer to connect to IBM/IGN/Advantis (SLIP)'
say '  2 (Reserved)'
say '  3 With a slip.exe or ppp.exe dialup string'
say '  4 Using SLIPPM (IBM''s Dial-Other-Internet-Providers Utility),'
say '    a SLIPPM replacement dialer (e.g., ILINK/2, IN-JOY, etc.),'
say '    or other dialer'
say '  5 I will try to set up' ydparms_dat 'manually (read' yd_doc || '),'
say '    but help me do a partial setup'
say ''
say ' FOR OPTIONS 3 and in some cases 4: the IBM utility SLIPPM.EXE'
say ' (''Dial-Other-Internet-Providers'') may need to be configured'
say ' properly beforehand even if you will use your own dialup string'
say ' or another dialer to dial up.'
say ' Reason: SLIPPM stores parameters that we need where we can'
say ' get at them.'
say ''
do until pos(connection_type, '1345') \=0
   say ''
   prompt = 'Select 1, or 3-5, or Escape to quit:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   connection_type = SysGetKey('NOECHO')
   if connection_type = escape then signal goodbye
end
say ''

if connection_type = 1 then
   do
      say 'Selected: IBM/IGN/Advantis IAK Dialer.        '
   end     

if connection_type = 3 then
   do
      say 'Selected: Dialup with a ppp.exe or slip.exe dialup string'
      edit_dialup_string_msg = crlf ||,
      'Remember to fill in the dialup_string called',
      'for in' ydparms_dat
   end     

if connection_type = 4 then
   do
      say 'Selected: SLIPPM, a SLIPPM replacement, or other dialer.'
   end     

if connection_type = 5 then
   do
      say 'Selected: Mostly manual configuration (by editing' ydparms_dat || ').'
      edit_dialup_string_msg = crlf ||,
      'Remember to manually revise (edit)' ydparms_dat
   end     

say ''
say 'Press any key to continue'
call SysGetKey'ECHO'
RETURN


/*
==============================================
Determine paths to DIALER.INI and TCPOS2.INI
==============================================
*/
get_ini_paths:
dialerini_exists = 0
tcpos2ini_exists = 0
tcpip_etc_path = value('etc', , 'OS2ENVIRONMENT')
dialer_ini = tcpip_etc_path || '\' || 'dialer.ini'
if stream(dialer_ini, 'c', 'query exists') \= '' then
   do
      dialerini_exists = 1
   end
tcpos2_ini = tcpip_etc_path || '\' || 'tcpos2.ini'
if stream(tcpos2_ini, 'c', 'query exists') \= '' then
   do
      tcpos2ini_exists = 1
   end
RETURN

/*
==============================================
Locate the Yarn HOME directory.  It  set as an
OS/2 environmental variable, but if it isn't, prompt us
for it.  You can install Yarn with separate home directories
for each user.  A lot of other applications set up HOME
as an environmental variable so the home directory in the
OS/2 environment may not be the correct one for this
installation.

To determine if we have the right home directory we look
for Yarn's config file which is located in home's /yarn/
subdirectory.
==============================================
*/
find_yarn_home_dir:
/* Get the Yarn Home Directory */
entry = ''        /* initialize it to a blank */

call SysCls
say ''
say 'YARN''s HOME DIRECTORY SCREEN'

home = value('home', , 'OS2ENVIRONMENT')
home = translate(home)
yarn_config = home || '\yarn\config'
if home = '' then
   do
      say ''
      say 'Unable to find HOME as an OS/2 environment variable.'
      say 'That means you did not include a SET HOME statement in'
      say 'config.sys or you did not reboot after modifying config.sys,'
      say 'neither of which is a problem since you will be able to'
      say 'enter the path for your HOME directory now.'
      say ''
   end
if stream(yarn_config, 'c', 'query exists') \= '' then
   do
      say ''
      say 'We found' home 'as a possible YARN home directory.'
      say ''
      say 'You may have set up Yarn with more than one user'
      say 'and more than one home directory or this '
      say 'another program''s home directory.'
      say ''
      say 'To accept   ' home '   as the home directory press ENTER,'
      say 'or key in the full path of the Yarn HOME directory you wish'
      prompt = 'to do this installation for:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      pull entry
   end 
if entry \= '' then home = entry
home = strip(home, 'B')
yarn_config = home || '\YARN\CONFIG'
do forever
   if stream(yarn_config, 'c', 'query exists') \= '' then
      do
         leave
      end
         say ''
         if home = '' then say 'The home directory is undefined.'
         if home \= '' then
            do
               say ''
               say 'Unable to find' yarn_config '(HOME dir is in error)'
               say translate(home) 'as HOME directory is in error.'
            end
         prompt = 'Enter your Yarn HOME directory path now:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
        col = length(prompt) + 2
         call SysCurPos row, col
         pull entry
         entry = strip(entry, 'T', '\')       /* strip any trailing \ if entered */
         home = entry
         yarn_config = home || '\yarn\CONFIG'
end

yarn_config = home || '\yarn\CONFIG'
yarn_config = translate(yarn_config)
home_drive = filespec('drive', yarn_config)
home_drive = translate(home_drive)
ydparms_dat = home || '\' || ydparms_dat
ydparms_dat = translate(ydparms_dat)

say ''
say 'Installing for' home 'as the Yarn HOME directory.'
say ''
say ''
say 'OK.  Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
Where is the Yarn directory?

We look for yarn in the OS/2 environment.  If we don't
find it we exit install.  All of the yarn files should
be there:
   import.exe
   export.exe
   rebuild.exe
   expire.exe
   yarn.exe      and more
but we search for yarn.exe to verify it is (probably)
a valid YARN directory.
==============================================
*/

find_yarn_dir:
/* Get the Yarn Directory */
entry = ''        /* initialize it to a blank */

call SysCls
say ''
say 'YARN DIRECTORY SCREEN'
say '(Directory where most of the YARN programs are kept)'
say ''

yarn = value('yarn', , 'OS2ENVIRONMENT')
yarn = translate(yarn)
yarn_exe = yarn || '\' || yarn_exe
if yarn = '' then
   do
      say ''
      say 'Unable to find YARN as an OS/2 environment variable.'
      say 'That means you did not include a SET YARN statement in'
      say 'config.sys or you did not reboot after modifying config.sys,'
      say 'neither of which is a problem since you will be able to'
      say 'enter the path for your YARN directory now.'
      say ''
   end
if stream(yarn_exe, 'c', 'query exists') \= '' then
   do
      say ''
      say 'We found' yarn 'as a possible YARN directory.'
      say ''
      say 'You may have set up Yarn with more than one YARN'
      say 'directory or this  a temporary directory'
      say 'you used to install YARN.'
      say ''
      say 'To accept   ' yarn '   as the YARN directory press ENTER,'
      say 'or key in the full path of the YARN directory you wish'
      prompt = 'to do this installation for:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      pull entry
   end 
if entry \= '' then yarn = entry
yarn = strip(yarn, 'B')
yarn_exe = filespec('name', yarn_exe)        /* get back to name only */
yarn_exe = yarn || '\' || yarn_exe        /* reconstruct fully qualified path */

do forever
   if stream(yarn_exe, 'c', 'query exists') \= '' then
      do
         leave
      end
         say ''
         say 'Unable to find' yarn_exe '(YARN dir is in error or undefined)'
         say ''
         if yarn \= '' then
            do
               say translate(yarn) 'as YARN directory is in error'
            end
         prompt = 'Enter correct YARN directory path now:'
         say prompt
        parse value SysCurPos() with row col
        row  = row - 1
        col = length(prompt) + 2
        call SysCurPos row, col
        pull entry
        entry = strip(entry, 'T', '\')        /* strip any trailing \ if entered */
        yarn = entry
        yarn_exe = filespec('name', yarn_exe)        /* get back to name only */
        yarn_exe = yarn || '\' || yarn_exe        /* this is what we look for */
end

yarn_exe = yarn || '\' || yarn_exe        /* this is what we look for */  
yarn_exe = translate(yarn_exe)
yarn_drive = filespec('drive', yarn_exe)
yarn_drive = translate(yarn_drive)
yarn_path = yarn || '\'
home_path = home || '\'
yarn_exe = filespec('name', yarn_exe)  /* OK, again get back to name only */

souper_exe = yarn_path || souper_exe
vsoup_exe = yarn_path || vsoup_exe
yarn_exe = yarn_path || yarn_exe
import_exe = yarn_path || import_exe
export_exe = yarn_path || export_exe
expire_exe = yarn_path || expire_exe
rebuild_exe = yarn_path || rebuild_exe
go_exe = home_path || go_exe
yarn_drive = filespec('drive', import_exe)

say ''
say 'Installing for' yarn 'as the YARN directory.'
say ''
say ''
say 'OK.  Press any key to continue'
call SysGetKey 'NOECHO'
if connection_type = 1 then say 'Password module loading...'
RETURN

/*
==============================================
get_dial_other_providers_app()

If you are making a PPP or SLIP connection using the
Dial-Other-Internet-Providers utility, we will have your
"application" (i.e., the setup you did for your provider
in the tcpos2.ini file.  Here you can select which
application you are installing for.  Be careful, there
are "applications" here that are not related to a
specific provider setup.
==============================================
*/
get_dial_other_providers_app:
arg inifile
call SysCls
say ''
say 'DIAL-OTHER-INTERNET-PROVIDERS SCREEN'
say ''
result = SysIni(inifile, 'ALL:', 'apps')
if result \= 'ERROR:' then
   do j = 1 to apps.0
      say j apps.j
      if j \= 0 & j // 15 = 0 then
         do
        say '   There are more, press any key to continue'
        say '   If one of these is the right one, remember the number!!!'
        call SysGetKey 'NOECHO'
         end
   end
say ''
say '     Select the item above by number which'
say '     is the Dial-Other-Internet-Provider application for'
say '     this installation.'
say ''

do until DataType(DOIP, 'W') & DOIP > 0 & DOIP < j
   prompt = 'Selection:' 
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) +2
      call SysCurPos row, col
   pull DOIP
   if \DataType(DOIP, 'W') | DOIP <1 | DOIP > j-1 then
   do
      say 'Must be 1-' || j-1
   end
end
say ''
say 'Selected Application:' apps.DOIP
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
say 'Please wait while parameters are being loaded...'
RETURN apps.DOIP

/*
==============================================
whose_zips_are_we_using()

You can select which kind of compression and
uncompress utilities you use.  The os/2 InfoZip
ports are recommended.
==============================================
*/
whose_zips_are_we_using:
/* Get path to zip files, also specify which we use */
zip_type = 0
call SysCls
   say ''
   say 'COMPRESSION/UNCOMPRESSION SCREEN'
   say ''
   say 'Select which type of compress and uncompress programs'
   say 'you will use.  You must use them.  Recommended is the OS/2'
   say 'port of InfoZip compression and uncompression programs.  You'
   say 'can also select to use the MS-DOS PkWare programs.'
   say ''
   say 'Select from among:'
   say '1  OS/2 InfoZip series (e.g., from zip201c2.zip and unz512x2.zip'
   say '   archives, or later versions)'
   say '2  MS-DOS PkWare (e.g., from the PKZ204G.ZIP archive)'
   say '3  Any other type, whether OS/2 or MS-DOS based'
   say '(ESC exits install program now)'
do until pos(zip_type, '123') \= 0
   prompt = 'Select 1, 2, or 3:'
   say prompt
   zip_type = SysGetKey('NOECHO')
   select
      when zip_type = Escape then signal goodbye
      when zip_type = 1 then
         do
            say ''
            file_msg1 = 'OS/2 InfoZip' /* This is the default */
            say 'Selected: ' file_msg1
            zip_exe = os2_zip_exe
            zip_options = os2_zip_options
            unzip_exe = os2_unzip_exe
            unzip_options = os2_unzip_options
         end
      when zip_type = 2 then
        do
           say ''
           file_msg1 = 'MS-DOS PkWare'
           say 'Selected: ' file_msg1
           zip_exe = msdos_zip_exe
           zip_options = msdos_zip_options
           unzip_exe = msdos_unzip_exe
           unzip_options = msdos_unzip_options
        end
      when zip_type = 3 then
        do
           zip_exe = ''
           unzip_exe = ''
           say ''
           say 'Selected: (OTHER)'
           say 'You will need to edit the zip_exe and unzip_exe entries'
           say 'in' ydparms_dat 'after installation is complete.'
           say 'Refer to' yd_doc 'for help on how to customize for'
           say 'other compression and uncompression utilities.'
         end
      when pos(zip_type, '123') = 0 then
         do
            say ''
            say ''
            say 'You may only enter 1,2 or 3 (or press ESC to quit)'
            say ''
         end
      otherwise NOP
   end
end
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=====================================      
search_for_files()

We search for various files with calls to the
file_locator() routine.  In the case of the zip and
unzip files, we also attach their option strings.
=====================================      
*/

search_for_files:
/* The flag Abandon is returned = 1 if the file_locator() routine encounters a request to abort */

if zip_type \= 3 then
   do
      zip_exe = file_locator(zip_exe)
      if Abandon then signal goodbye
      unzip_exe = file_locator(unzip_exe)
      if Abandon then signal goodbye
      zip_exe = zip_exe zip_options
      unzip_exe = unzip_exe unzip_options
   end

if stream(alt_dialer_path || killjoy_exe, 'c', 'query exists') \= '' then
   killjoy_exe = stream(alt_dialer_path || killjoy_exe, 'c', 'query exists')

say 'Patience...'  /* sometimes the next step takes a while to load */
RETURN

/*
=====================================================
file_locator()

is a file finder that not only searches all available
local drives for all instances found of that file, but
provides a menu allowing you to select a single instance.
If the filename being searched for has been fed to the
routine with arguments or with a fully qualified path,
the path and all arguments are stripped out so only
the pure filename itself is searched.


Syntax: file_locator(filename)

Returns the fully qualified path of the instance you
select if at least one instance is found, or returns
a blank ('') if none is found.  If only one instance
is found, it is automatically selected (you get no
menu, but you do get a 'found' notice).

=====================================================
*/
file_locator:
parse upper arg filename

escape = d2c(27)         /* escape character */
file_spec = filespec('name', filename)
call SysCls
say ''
say ''
say ''
say ''
say 'Searching for' file_spec
say ''
say 'Search is restricted to local drives only.'
say 'Remove media from local CD-ROM drives and other'
say 'removable-media drives or we will search them, too.'
say ''

map = SysDriveMap( , 'LOCAL')
drives = words(map)
instances = 0
do i = 1 to drives
   drive.i = word(map, i)
   if SysDriveInfo(drive.i) = '' then iterate
   prompt = 'Searching' drive.i
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = 0
      call SysCurPos row, col
   filsp = drive.i || '\' || file_spec        /* filespec with path */
   rc = SysFileTree(filsp, 'file', 'FS')
   do n = 1 to file.0
      instances = instances + 1        /* a counter */
      file_found.instances = file.n
   end
end

/*
==================
If instances=0, that means we found no instance(s)
of the file.  Maybe the file name is changed.  Error
message.  But we continue the install because maybe
the filename can be corrected by editing YD_PARMS.DAT
when we are done
=================
*/
if instances = 0 then
   do
      findfile_ErrNum = findfile_ErrNum +1
      call  beep 262, 200
      say ''
      say ''
      say 'MAJOR ERROR:  we found no instances of' file_spec || '.'
      say 'Maybe the file name has been changed.  We can'
      say 'continue, hoping the error can be corrected by'
      say 'editing the filename in the' ydparms_dat
      say 'file that we create in the specific HOME directory'
      say 'that we are now installing to.'
      say ''
      say 'Or you can Escape and correct now (recommended).'
      say ''
      
/* These next lines are for possible use in an error message
identifying this file which we can't find. */

      unfound_file.findfile_ErrNum = file_spec
      file_spec.instances = ''
      file_spec.instance_number = file_spec

      prompt = 'Escape quits YDINSTL.  Any other key continues'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         if SysGetKey('NOECHO') = escape then Abandon = 1
   end

if instances > 1 | instances = 1 then        /* We list them all */
   do      
      say ''
      prompt = 'Found:  ' instances 'instance(s) of' file_spec
         parse value SysCurPos() with row col
         row  = row -1
         col = 0
         call SysCurPos row, col
      if instances > 1 then say prompt
      do i = 1 to instances
         parse var file_found.i date.i time.i size.i attrib.i file_spec.i
         date.i = right(date.i, 9)
         time.i = right(time.i, 7)
         size.i = right(size.i, 10)
         file_spec.i = strip(file_spec.i, 'B')
         if instances > 1 then say i date.i time.i size.i file_spec.i
         if i \= 0 & i // 15 = 0 & instances > 1 then
         do
        say '   There are more, press any key to continue'
        say '   If one of these is the right one, remember the number!!!'
        call SysGetKey 'NOECHO'
         end
      end       /* of Do i = 1 to instances */
   end        /* if instances > 1 | instances = 1 */

if instances > 1 then        /* We prompt for which one to select */

   do until DataType(instance_number,'W') &,
         instance_number < instances + 1,
         & instance_number > 0
      say 'Which is the correct one of these to use?'
      prompt = 'Enter 1-' || instances || ':' 
      say prompt
      parse value SysCurPos() with row col
         row  = row -1
         col = length(prompt) +2
         call SysCurPos row, col
      if instances > 1 then
         do
        pull instance_number
        if \DataType(instance_number, 'W') then
         do
        say 'Whole number only. Try Again.'
         end
        if instance_number > instances then
         do
        say 'Cannot exceed' instances || '.  Try again.'
         end
        if instance_number = 0 then
         do
        say 'Cannot enter zero.  Try again.'
         end
         end
   end

/* If only one instance, we do not need
to prompt or select the menu number because
instance_number is 1.  */

if instances = 1 then
   do
      instance_number = 1
      say 'Found and selected one instance:'
      say date.1 time.1 size.1 file_spec.1
   end

if instances > 1 then say 'Selected:  ' file_spec.instance_number

if instances = 1 | instances > 1 then
   do
      say ''
      say 'Press any key to continue'
      call SysGetKey 'NOECHO'
      say ''
   end
say ''
say ''
file_selected = file_spec.instance_number
RETURN file_selected

/*
==============================================
get_parms_from_yarn_config()

Read the yarn config file.  Reconstitute lines that
have been continued on to the next line using
the \ continuation character, then pick out lines
with an = sign and that don't begin with the #
comment-out character.  Then set up the USER and
REPLY_PACKET variables.
==============================================
*/
get_parms_from_yarn_config:
n = 1
do while lines(yarn_config) > 0
    data_line = linein(yarn_config)
    line.n = data_line
    if pos('=', data_line) > 0 & \abbrev(line.n, '#') then
       do
        line.n = data_line
        if right(line.n, 1) = '\' then
         do until right(line.n, 1) \= '\'
        line_n_with_right_slash_stripped = strip(right(line.n,1), 'T', '\')
        next_data_line = linein(yarn_config)
        line.n = line_n_with_right_slash_stripped || next_data_line
         end
        n = n + 1
        number_of_reconstituted_lines = n
      end
end

j = 1
do until j = number_of_reconstituted_lines
   parse var line.j first.j '=' last.j
   do until first.j = stripped_F.j & last.j = stripped_L.j
      stripped_F.j = strip(first.j, 'B')
      first.j = strip(stripped_F.j, 'B', tab)
      stripped_L.j = strip(last.j, 'B')
      last.j = strip(stripped_L.j, 'B', tab)
   end

   select
      when abbrev(line.j, '#') then NOP
      when translate(first.j) = 'USER' then user = last.j
      when translate(first.j) = 'HOST' then host = last.j
      when translate(first.j) = 'REPLY-PACKET' then reply_packet = last.j
      otherwise NOP
   end
   j = j +1
end

LOGIN_ID = user
RETURN

/*
==============================================
get_parms_from_advantis_dialerini()

Get selected parameters from dialer.ini (for the
IBM/IGN/Advantis IAK Dialer) for the application "user_user".
Example, my user ID is jlevy so for me user_user
is user_jlevy (all lower case) 
==============================================
*/
get_parms_from_advantis_dialerini:
/* Get parms from dialer.ini file.  The strip is of a final null character that for some reason gets fetched along with the parm */
user_user = 'user_' || user
   Upcase = xrange('A', 'Z')
   Lowcase = xrange('a', 'z')
   user_user = translate(user_user, Lowcase, Upcase) /* dialer.ini expects user_user to be all-lowercase */
account = strip(SysIni(dialer_ini, user_user, 'act'), 'T', X1)
DEFAULT_NEWS = strip(SysIni(dialer_ini, user_user, 'ns'), 'T', X1)
POPSRVR = strip(SysIni(dialer_ini, user_user, 'ps'), 'T', X1)
MAIL_GW = strip(SysIni(dialer_ini, user_user, 'sm'), 'T', X1)
connect_logfile = strip(SysIni(dialer_ini, 'AdvLog', 'Cfn'), 'T', X1)
ask = strip(SysIni(dialer_ini, user_user, 'ask'), 'T', X1)
DEFAULT_GOPHER = strip(SysIni(dialer_ini, user_user, 'gs'), 'T', X1)
DEFAULT_WWW = strip(SysIni(dialer_ini, user_user, 'ws'), 'T', X1)
DNS = strip(SysIni(dialer_ini, user_user, 'dn1'), 'T', X1)
DNS2 = strip(SysIni(dialer_ini, user_user, 'dn2'), 'T', X1)
is1 = strip(SysIni(dialer_ini, user_user, 'is1'), 'T', X1)
is2 = strip(SysIni(dialer_ini, user_user, 'is2'), 'T', X1)
rs1 = strip(SysIni(dialer_ini, user_user, 'rs1'), 'T', X1)
rs2 = strip(SysIni(dialer_ini, user_user, 'rs2'), 'T', X1)
fs1 = strip(SysIni(dialer_ini, user_user, 'fs1'), 'T', X1)
fs2 = strip(SysIni(dialer_ini, user_user, 'fs2'), 'T', X1)
DOMAIN_NAME = strip(SysIni(dialer_ini, user_user, 'md'), 'T', X1)
pin = strip(SysIni(dialer_ini, user_user, 'pin'), 'T', X1)
POP_ID = strip(SysIni(dialer_ini, user_user, 'emI'), 'T', X1)
RETURN

/*
==============================================
get_parms_from_tcpos2ini()

Similarly, get the parameters (all of them) for the
Dial-Other-Internet-Providers "application" you had
selected when the GET_DIAL_OTHER_PROVIDERS_APP()
routine was run.

These are located in the TCPOS2.INI file.  Xi is the
null character.  It is returned with every value and
we strip it out
==============================================
*/
get_parms_from_tcpos2ini:
/* Get parms from tcpos2.ini file in the same way. */
PROVIDER = strip(SysIni(tcpos2_ini, host_app, 'PROVIDER'), 'T', X1)
LOGIN_ID = strip(SysIni(tcpos2_ini, host_app, 'LOGIN_ID'), 'T', X1)
PWD = strip(SysIni(tcpos2_ini, host_app, 'PWD'), 'T', X1)
SAVE_PWD = strip(SysIni(tcpos2_ini, host_app, 'SAVE_PWD'), 'T', X1)
PHONE_NUMBER = strip(SysIni(tcpos2_ini, host_app, 'PHONE_NUMBER'), 'T', X1)
HANGUP = strip(SysIni(tcpos2_ini, host_app, 'HANGUP'), 'T', X1)
SCRIPT = strip(SysIni(tcpos2_ini, host_app, 'SCRIPT'), 'T', X1)
SERVICE = strip(SysIni(tcpos2_ini, host_app, 'SERVICE'), 'T', X1)
YOURIP = strip(SysIni(tcpos2_ini, host_app, 'YOURIP'), 'T', X1)
DESTIP = strip(SysIni(tcpos2_ini, host_app, 'DESTIP'), 'T', X1)
NETMASK = strip(SysIni(tcpos2_ini, host_app, 'NETMASK'), 'T', X1)
MTU_SIZE = strip(SysIni(tcpos2_ini, host_app, 'MTU_SIZE'), 'T', X1)
VJ_COMP = strip(SysIni(tcpos2_ini, host_app, 'VJ_COMP'), 'T', X1)
PRIMARY_INF = strip(SysIni(tcpos2_ini, host_app, 'PRIMARY_INF'), 'T', X1)
HOSTNAME = strip(SysIni(tcpos2_ini, host_app, 'HOSTNAME'), 'T', X1)
DOMAIN_NAME = strip(SysIni(tcpos2_ini, host_app, 'DOMAIN_NAME'), 'T', X1)
DNS = strip(SysIni(tcpos2_ini, host_app, 'DNS'), 'T', X1)
DEFAULT_NEWS = strip(SysIni(tcpos2_ini, host_app, 'DEFAULT_NEWS'), 'T', X1)
DEFAULT_WWW = strip(SysIni(tcpos2_ini, host_app, 'DEFAULT_WWW'), 'T', X1)
DEFAULT_GOPHER = strip(SysIni(tcpos2_ini, host_app, 'DEFAULT_GOPHER'), 'T', X1)
MAIL_GW = strip(SysIni(tcpos2_ini, host_app, 'MAIL_GW'), 'T', X1)
POPSRVR = strip(SysIni(tcpos2_ini, host_app, 'POPSRVR'), 'T', X1)
REPLY_DOMAIN = strip(SysIni(tcpos2_ini, host_app, 'REPLY_DOMAIN'), 'T', X1)
REPLY_ID = strip(SysIni(tcpos2_ini, host_app, 'REPLY_ID'), 'T', X1)
POP_ID = strip(SysIni(tcpos2_ini, host_app, 'POP_ID'), 'T', X1)
POP_PWD = strip(SysIni(tcpos2_ini, host_app, 'POP_PWD'), 'T', X1)
MODEM_TYPE = strip(SysIni(tcpos2_ini, host_app, 'MODEM_TYPE'), 'T', X1)
COMPORT = strip(SysIni(tcpos2_ini, host_app, 'COMPORT'), 'T', X1)
BAUD = strip(SysIni(tcpos2_ini, host_app, 'BAUD'), 'T', X1)
DATABITS = strip(SysIni(tcpos2_ini, host_app, 'DATABITS'), 'T', X1)
PARITY = strip(SysIni(tcpos2_ini, host_app, 'PARITY'), 'T', X1)
DIAL_MODE = strip(SysIni(tcpos2_ini, host_app, 'DIAL_MODE'), 'T', X1)
PREFIX = strip(SysIni(tcpos2_ini, host_app, 'PREFIX'), 'T', X1)
PREFIX_ANS = strip(SysIni(tcpos2_ini, host_app, 'PREFIX_ANS'), 'T', X1)
INIT = strip(SysIni(tcpos2_ini, host_app, 'INIT'), 'T', X1)
INIT2 = strip(SysIni(tcpos2_ini, host_app, 'INIT2'), 'T', X1)
DISABLE = strip(SysIni(tcpos2_ini, host_app, 'DISABLE'), 'T', X1)
DISABLE_SEQ = strip(SysIni(tcpos2_ini, host_app, 'DISABLE_SEQ'), 'T', X1)
DIAL_PREFIX = strip(SysIni(tcpos2_ini, host_app, 'DIAL_PREFIX'), 'T', X1)
AUTOSTART = strip(SysIni(tcpos2_ini, host_app, 'AUTOSTART'), 'T', X1)
TOTAL_CONNECT = strip(SysIni(tcpos2_ini, host_app, 'TOTAL_CONNECT'), 'T', X1)

service = translate(service)

/* If no DNS2 is available, set DNS2 = DNS */
DNS = strip(DNS, 'B')
DNS = strip(DNS, 'B', tab)
if DNS2 = '' then DNS2 = DNS

if (popsrvr = '' | mail_gw = '' | default_news = '' | pop_id = '' | pop_pwd = ''),
    & piggyback then
   do
      call SysCls
      say 'WARNING'
      say 'You are attempting to install YARNDIAL for the' alt_dialer 'dialer'
      say 'and piggybacking parameters from a previous' host_app 'entry in'
      say 'SLIPPM (the Dial-Other-internet-Providers utility).'
      say ''
      say 'The following fields in the setup notebook MUST be filled in'
      say 'for the' host_app 'entry: POP Mail Server, POP Login ID,'
      say 'POP Password, News Server, and Mail Gateway'
      say ''
      say 'The following field or fields are blank:'
      if popsrvr = '' then say '   POP Mail Server'
      if mail_gw = '' then say '   Mail Gateway (SMTP Server)' 
      if default_news = '' then say '   News Server'
      if pop_id = '' then say '   POP Login ID'
      if pop_pwd = '' then say '   POP Password'
      say 'We will exit YDINSTL without completing the installation.'
      say 'Edit the appropriate fields in your SLIPPM setup for' host_app || '.'
      say 'In the unlikely event you have omitted one of these fields'
      say 'intentionally, e.g., because you won''t be using a news server,'
      say 'enter something.  Entering xxx or the word none will do fine.'
      say ''
      prompt = 'Press any key to continue (exits you).'
      say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      call SysGetKey 'NOECHO'
      signal goodbye
   end


RETURN


/*
==============================================
get_alt_dialer_exe()

Prompt for this and verify
==============================================
*/

get_alt_dialer_exe:

call SysCls
say ''
say 'THIS IS THE "IDENTIFY-YOUR-DIALER" SCREEN'
say ''
do until pos(dialer_selection, '1239') \= 0
   say 'Select:'
   say '1  SLIPPM (IBM''s Dial-Other-Internet-Providers Utility)'
   say '2  The ILINK/2 Dialer'
   say '3  The IN-JOY Dialer'
   say '4-8 (Reserved for future use)'
   say '9  Not listed and not a SLIP.EXE or PPP.EXE dialup string,'
   say '     so prompt me to enter the dialer filename'

   say ''
   prompt = 'Enter 1-3 or 9:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   dialer_selection = SysGetKey('ECHO')
   say ''
   if dialer_selection = 1 then
      do
         piggyback = 1  /* get parms from tcpos2.ini */
         say 'Selected:  SLIPPM Dialer'
         alt_dialer_exe = SLIPPM_EXE
         alt_dialer_name = 'SLIPPM'
         alt_dialer = 'SLIPPM'
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
      end

   if dialer_selection = 2 then
      do
         piggyback = 1  /* get parms from tcpos2.ini */
         say 'Selected:  ILINK/2 Dialer'
         alt_dialer_exe = ILINK2_EXE
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
         call locate_alt_dialer_exe
      end
   if dialer_selection = 3 then
      do
         say 'Selected:  IN-JOY Dialer'
         alt_dialer_exe = INJOY_EXE
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
         call locate_alt_dialer_exe
      end

   if pos(dialer_selection, '1239') = 0 then
      say 'Must enter 1-3 or 9.  Try again'
   say ''
end

if dialer_selection = 9 then
   do
      say ''
      say 'You chose to enter the dialer name.'
      alt_dialer_exe = ''
      say 'Enter the name of your dialer executable,'
      say 'complete with filetype.  Omit path.'
      say 'Examples: slippm.exe, ilink2.exe, in-joy.exe, etc.'
      say ''
      info_entered = ''
      match_info_entered = ''
      prompt = 'Dialer filename with extension (no path):'
      call prompt_for_info
      alt_dialer_exe = info_entered
      say 'Dialer is' alt_dialer_exe
      say ''
      say 'Press any key to continue'
      call SysGetKey 'NOECHO'
      call locate_alt_dialer_exe
   end
RETURN

/*
==================
locate_alt_dialer_exe()

Find the alt_dialer_exe, and from that fully qualified path
to it get drive, path, filename stripped of file and path,
and file part of file.exe
==================
*/

locate_alt_dialer_exe:
alt_dialer_exe = file_locator(alt_dialer_exe)
   if Abandon then signal goodbye

/* Strip any path or options and get the file part of alt_dialer_exe */
alt_dialer_exe = translate(alt_dialer_exe)
parse var alt_dialer_exe alt_dialer_name alt_dialer_options
alt_dialer_name = filespec('name', alt_dialer_name)
parse var alt_dialer_name alt_dialer '.' ext

/* Get the drive and path to alt_dialer_exe */
alt_dialer_drive = filespec('drive', alt_dialer_exe)
alt_dialer_path = alt_dialer_drive || filespec('path', alt_dialer_exe)
alt_dialer_dir = strip(alt_dialer_path, 'T', '\') /* path minus final '\' */
RETURN

/*
==============================================
get_userID()

Prompt for this and verify
==============================================
*/

get_userID:

call SysCls
say ''
say 'MAIL AND NEWS USER ID SCREEN'
say ''
say 'Enter UserID part of your e-mail address'
say 'Example: if your e-mail address is jsmith@goodnet.net'
say 'then your UserID is jsmith'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter userID:'
call prompt_for_info
POP_ID = info_entered
say 'userID is' POP_ID
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
get_domain()

Prompt for this and verify
==============================================
*/

get_domain:

call SysCls
say ''
say 'MAIL AND NEWS DOMAIN SCREEN'
say ''
say 'Enter Domain part of your e-mail address'
say 'Example: if your e-mail address is jsmith@goodnet.net'
say 'then your Domain is goodnet.net'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter domain name:'
call prompt_for_info
domain_name = info_entered
say 'domain name is' domain_name
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN


/*
==============================================
get_nameservers()

Prompt for primary and alternate and verify
==============================================
*/

get_nameservers:

/* get primary nameserver address */

call SysCls
say ''
say 'NAMESERVER SCREENS (primary and alternate)'
say ''
say 'Enter primary nameserver address in Decimal Dot'
say 'notation.    Example: 150.203.23.247'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter primary nameserver address:'
call prompt_for_info
DNS = info_entered
say 'Primary nameserver is' DNS
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'

/* Now get alternate nameserver address */

say ''
say ''
say ''
say 'Now enter alternate nameserver address in Decimal Dot'
say 'notation.    Example: 150.203.23.247'
say 'If you do not have an alternate, press ENTER twice'
say 'to bypass this screen, or enter primary again.'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter alternate nameserver address:'
DNS2 = info_entered
say 'Alternate nameserver is' DNS2
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'

/* If no alternate nameserver was entered, set DNS2 = DNS */
DNS = strip(DNS, 'B')
DNS = strip(DNS, 'B', tab)
DNS2 = strip(DNS2, 'B')
DNS2 = strip(DNS2, 'B', tab)
if DNS2 = '' then DNS2 = DNS
RETURN


/*
==============================================
get_pop3mail_server()

Prompt for this and verify
==============================================
*/

get_pop3mail_server:

call SysCls
say ''
say 'POP3 SERVER (Mail Server) SCREEN'
say ''
say 'Example: pop01.us.ny.ibm.net'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter POP3 server:'
call prompt_for_info
popsrvr = info_entered
say 'POP3 Server is' popsrvr
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN


/*
==============================================
call get_smtp_server()

Prompt for this and verify
==============================================
*/

get_smtp_server:

call SysCls
say ''
say 'SMTP MAIL GATEWAY (Mail Server) SCREEN'
say ''
say 'Example: smtp.gw-01.ny.us.ibm.net'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter SMTP server:'
call prompt_for_info
mail_gw = info_entered
say 'SMTP Server is' mail_gw
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN


/*
==============================================
get_news_server()

Prompt for this and verify
==============================================
*/

get_news_server:

call SysCls
say ''
say 'NEWS SERVER (NNTP Server) SCREEN'
say ''
say 'Example: news01.us.ny.ibm.net'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter NNTP server:'
call prompt_for_info
default_news = info_entered
say 'News Server is' default_news
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
get_login_id()

Prompt for this and verify
==============================================
*/

get_login_id:

call SysCls
say ''
say 'LOGIN_ID FOR LOGGING INTO PROVIDER'
say ''
say 'This is the ID you use when you login to your provider.'
say 'It may or may not be the same as your POP3 Mail user ID.'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter LOGIN_ID:'
call prompt_for_info
login_id = info_entered
say 'LOGIN_ID is' login_id
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
get_dialer_app()

Prompt for this and verify
==============================================
*/

get_dialer_app:

call SysCls
say ''
say 'DIALER HOST NAME'
say ''
say 'This is the name you used for the entry name when you'
say 'configured the dialer to your host provider.'
say 'It is Name in a command line of the type shown below'
say '(where slippm.exe is the dialer in this particular example)'
say '     SLIPPM.EXE Name'
say 'This should start up your dialer, connecting to the correct'
say 'host.'
say ''
say 'You can test the validity of ''Name'' by entering this'
say 'command in an OS/2 window, after changing to the directory'
say 'where your dialer .EXE resides.  It should connect you.'
say ''
say 'You may need to reproduce exactly whatever combination of'
say 'combination ofUpper/Lower case letters you used to define'
say 'the Name of the dialer entry'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Name you used as dialer entry:'
call prompt_for_info
host_app = info_entered
say 'Dialer name for entry is' host_app
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=================
get_comport()
=================
*/
get_comport:
call SysCls
say ''
say 'COM PORT'
say ''
say 'Enter COM port used by this installation'
say 'Enter as COM1, COM2, etc.'
say 'There should be NO space between COM and the port number'
say ''
info_entered = ''
match_info_entered = ''
prompt = 'Enter:'
call prompt_for_info
comport = info_entered
comport = translate(comport)
say 'COM port entered is' comport
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
set_interf_removal()

Set the interface_removal assignment.

Prompt for this and verify
==============================================
*/

set_interf_removal:

call SysCls
say ''
say 'INTERFACE REMOVAL:'
say ''
say 'Sometimes, when shutting down the dialer and after disconnecting,'
say 'a phantom router interface that should have been removed is left up.'
say 'This may interfere with subsequent communication programs until'
say 'a reboot is done.'
say ''
say 'For most installations, select 2.  Change to 0 if you have problems.'
say 'Select:'
say '0  (Zero) Don''t try to remove them.'
say '1  Remove interfaces only when left up by IN-JOY dialer'
say '2  Remove interfaces remaining when YarnDial is over and'
say '   we are disconnected.'
say '   (2 is recommended, unless you regularly establish simultaneous'
say '   connections with two or more modems; in that case try 0)'
say ''
do until pos(interface_removal, '012') \= 0
   prompt = 'Enter 0, 1, or 2:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   interface_removal = SysGetKey('NOECHO')
   say ''
   if interface_removal = 0 then
      say 'Selected: not to remove interfaces if left up'
   if interface_removal = 1 then
      say 'Selected: remove interfaces only when left up by IN-JOY dialer'
   if interface_removal = 2 then
      say 'Selected: remove all suspected phantom interfaces.'
   if pos(interface_removal, '012') = 0 then say 'Incorrect.  Try again.'
end
say ''
say 'Press any key to continue'
call SysGetKey('NOECHO')

RETURN

/*
==============================================
get_shell_windowsize()

This is the size of the maximized window when YRNSHELL.CMD runs.

Prompt for this and verify
==============================================
*/

get_shell_windowsize:

call SysCls
say ''
say 'YARN SHELL WINDOW SIZE:'
say ''
say 'This installer creates a utility to run YARN, called' yarnshell_cmd
say 'You can choose to have a larger-than-normal window size when'
say yarnshell_cmd 'runs and the window is maximized.'
say 'Select:'
say '1  80 chars wide x 24 lines (this is a normal OS/2 window)'
say '2  80 chars wide x 40 lines (recommended)'
say '3  90 chars wide x 40 lines'
say ''
do until pos(size, '123') \= 0
   prompt = 'Enter 1, 2 or 3:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   size = SysGetKey('NOECHO')
   say ''
   if size = 1 then
      do
         say 'You have selected 80 chars x 24 lines'
         conmode = 'mode co80,24'
      end
   if size = 2 then
      do
         say 'You have selected 80 chars x 40 lines'
         conmode = 'mode co90,40'
      end
   if size = 3 then
      do
         say 'You have selected 90 chars x 40 lines'
         conmode = 'mode co90,40'
      end
   if pos(size, '123') = 0 then say 'Incorrect.  Try again.'
end
say''
say 'Press any key to continue'
call SysGetKey('NOECHO')

RETURN


/*
==================
get_injoy_parms()

Dissect the IN-JOY HOSTS.DAT file getting
   configuration name
   numerical addresses of main and alternate nameservers
   login ID
   domain name
   comport
==================
*/

get_injoy_parms:
/* locate the IN-JOY HOSTS.DAT file */
call SysCls
say ''
say 'Searching though IN-JOY''s' hosts_dat 'file for'
say 'dialing configurations...'
say '' 
if stream(alt_dialer_path || hosts_dat, 'c', 'query exists') \= '' then
   hosts_dat = stream(alt_dialer_path || hosts_dat, 'c', 'query exists')
else
   do 
      say ''
      say 'ERROR: Cannot find IN-JOY''s HOSTS.DAT file in the directory'   
      say alt_dialer_dir 'where' injoy_exe 'was found.'
      say ''
      say 'Check that all IN-JOY files are together in one single directory'
      say 'and that you configured IN-JOY to connect to your Internet'
      say 'Service Provider.'
      say ''
      say 'This is not fatal (YD_PARMS.DAT can be edited).'
      other_err = 1
      ijparms_err1 = 1
      if ijparms_err1 = 1 then
         ijparms_errmsg1 = 'No IN-JOY HOSTS.DAT file found.'
      say 'Press any key to continue or Escape to exit'
      if SysGetKey('NOECHO') = Escape then signal goodbye
      signal exit_get_ijparms
   end
filesize1 = chars(hosts_dat)
if stream(alt_dialer_patrh || 'default.cfg', 'c', 'query exists') \= '' then
   filesize2 = chars(alt_dialer_path || 'default.cfg') - 10
   else filesize2 = 1167        /* a guess */ 
hosts = trunc((filesize1 / filesize2), 0)
dataunit = trunc((filesize1) / hosts)

call stream hosts_dat, 'c', 'open'
/*  The 'seek' stream command is different under Classic ReXX and Object ReXX
Object ReXX requires the use of the word read or write, whereas Classic Rexx does not */ 
call stream hosts_dat, 'c', 'open'
read_instr = ''
if left(rexx_type, 7) = os2Obj_Rexx then read_instr = 'read'

i = 1
do  hosts
/* offsets from start of HOSTS.DAT */
   offset = dataunit * (i - 1)
   cfgname_lenbyte = offset + 1
   cfgname_pos = offset + 3
   interfname_pos = offset + 71
   ns1_pos = offset + 126
   ns2_pos = offset + 142
   loginid_lenbyte = offset + 282
   loginid_pos = offset + 286
   domain_pos = offset + 419
   comport_pos = offset + 504

/* get the parameters */
   cfgname.i = get_hostsdat_Lparm(cfgname_lenbyte, cfgname_pos)
   interfname.i = get_hostsdat_0parm(interfname_pos)
   ns1.i = get_hostsdat_0parm(ns1_pos)
   ns2.i = get_hostsdat_0parm(ns2_pos)
   loginid.i = get_hostsdat_Lparm(loginid_lenbyte, loginid_pos)
   domain.i = get_hostsdat_0parm(domain_pos)
   comport.i = get_hostsdat_0parm(comport_pos)

   i = i + 1
end

call stream hosts_dat, 'c', 'close'

if i = 1 then
   do
      say 'ERROR:  found no IN-JOY dialing configurations'
      say 'Check if you set up one in IN-JOY and that all'
      say 'IN-JOY files are together in one single directory.'
      say ''
      say 'Another possibility is that IN-JOY HOSTS.DAT file'
      say 'format is different from the one in IN-JOY v 09'
      say 'used as model for retrieving IN-JOY parameters.'
      say 'Please e-mail jlevy@ibm.net (author of YARNDIAL)'
      say 'if assistance is needed.'
      say 'This is not fatal (YD_PARMS.DAT can be edited).'
      other_err = 1
      ijparms_err2 = 1
      if ijparms_err2 = 1 then
         ijparms_errmsg2 = 'No Dialer configurations found in IN-JOY''s HOSTS.DAT'
      say 'Press any key to continue or Escape to abort'
      if SysGetKey('NOECHO') = Escape then signal goodbye
      signal exit_get_ijparms
   end

if i = 2 then
   do
      say 'Found and selected the following dialing configuration:'
      say '   ' cfgname.1
      ij_app = 1
   end

if i > 2 then
   do
      say 'Found the following dialing configurations:'
         do j = 1 to i -1
            say j cfgname.j
            if j \= 0 & j // 15 = 0 then
              do
                 say '   There are more, press any key to continue'
                 say '   If one of these is the right one, remember the number!!!'
                 call SysGetKey 'NOECHO'
              end
         end

         say ''
         say '     Select the item above by number which is what you entered'
         say '     as the configuration name (i.e, HOST ID) when setting up'
         say '     IN-JOY to connect to your Internet Service Provider'
         say ''
            do until DataType(ij_app, 'W') & ij_app > 0 & ij_app < j
               prompt = 'Selection:' 
               say prompt
               parse value SysCurPos() with row col
               row  = row - 1
               col = length(prompt) +2
               call SysCurPos row, col
               pull ij_app
               if \DataType(ij_app, 'W') | ij_app <1 | ij_app > j-1 then
               say 'Must be 1-' || j-1
            end
            say ''
            say 'Selected' cfgname.ij_app 'as the IN-JOY Dialer host ID.'
   end /* DO if i > 2 */

say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'

host_app = cfgname.ij_app
interf_prefix = interfname.ij_app
DNS = ns1.ij_app
DNS2 = ns1.ij_app
login_id =loginid.ij_app
DOMAIN_NAME = domain.ij_app
COMPORT = comport.ij_app

exit_get_ijparms:
RETURN cfgname.ij_app

/*
================
get_hostsdat_Lparm()
get_hostsdat_0parm()

Both called by get_injoy_parms()
These extract parameters from the IN-JOY hosts.dat
file.

get_hostsdat_Lparm() is used where
there is a length byte available.  Input arguments are
offsets from beginning of file as follows:
        lenpos        location of length byte
        parmpos        location of parameter         

get_hostsdat_0parm() is used where
there is no length byte available and where the parameter
is null-delimited.  Sole input argument is offset from beginning
of file for:
        parmpos        location of parameter 
=================
*/
get_hostsdat_Lparm:
arg lenpos, parmpos
call stream hosts_dat, 'c', 'seek =' || lenpos read_instr        /* position to length byte */
parm_length = c2d(charin(hosts_dat))        /* get length */
call stream hosts_dat, 'c', 'seek =' || parmpos read_instr        /* position to parm */
parameter = ''
do parm_length        /* build the parm */
   char = charin(hosts_dat)
   parameter = parameter || char
end
RETURN parameter

get_hostsdat_0parm:
arg parmpos
call stream hosts_dat, 'c', 'seek =' || parmpos read_instr
parameter = ''
do until c2d(char) = 0
   char = charin(hosts_dat)
   if c2d(char) \= 0 then parameter = parameter || char
end
RETURN parameter


/*
==============================================
get_interface_prefix()

Prompt for this and verify
==============================================
*/

get_interface_prefix:

call SysCls
say ''
say 'INTERFACE PREFIX SCREEN'
say ''
do until pos(dialer_selection, '1239') \= 0
   say 'Select (normally select 1 for an IN-JOY ppp connection'
   say '  or 3 for an IN-JOY slip connection):'
   say '1  PPP or ppp'
   say '2  SL or sl'
   say '3  SLIP or slip'
   say '4-8 (Reserved for future use)'
   say '9  Not listed so prompt me'

   say ''
   prompt = 'Enter 1-3 or 9:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   interf_prefix = SysGetKey('ECHO')
   say ''

   select
      when interf_prefix = 1 then
         do
        say 'Selected:  PPP or ppp'
        interf_prefix = 'PPP'
         end
      when interf_prefix = 2 then
         do
        say 'Selected:  SL (regardless of case)'
        interf_prefix = 'SL'
         end
      when interf_prefix = 3 then
         do
        say 'Selected:  SLIP or slip'
        interf_prefix = 'SLIP'
         end
      when interf_prefix = 9 then
         do
        say 'You chose to enter the prefix'
         end
      when pos(interf_prefix, '1239') = 0 then
         say 'Must enter 1-3 or 9.  Try again'
   end         /* of Select */
   say ''
end        /* of Do Until */
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'

if interf_prefix = 9 then
   do
      parse value SysCurPos() with row col
      row  = row - 1
      col = 0
      call SysCurPos row, col

      say 'Enter a prefix.  Maximum 5 characters.'
      say 'Letters preferred, though anything will work.  Read YD.DOC for info.'
      say 'Examples: ppp, sl, lan'
      say ''
      info_entered = ''
      match_info_entered = ''
      prompt = 'Prefix:'
      call prompt_for_info
      interf_prefix = info_entered
      interf_prefix = left(interf_prefix, 5)
      say 'Prefix is' interf_prefix
      say ''
      say 'Press any key to continue'
      call SysGetKey 'NOECHO'
   end
RETURN

/*
==============
prompt_for_info()

Makes you enter it twice to verify
==============
*/
prompt_for_info:
do until match_info_entered = info_entered
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      parse pull info_entered
   if info_entered = '' then info_entered = '(nothing entered)'
   say ''
   prompt = 'Enter it again to verify:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      parse pull match_info_entered
   if match_info_entered = '' then match_info_entered = '(nothing entered)'
   if match_info_entered \== info_entered then
      do
         say ''
         say match_info_entered 'does not match' info_entered
         say 'Try again'
      end
end
RETURN info_entered


/*
=========================
are_we_SLIP_or_PPP()

Which are we?
=========================
*/
are_we_SLIP_or_PPP:
do until pos(serv, 'SP') \= 0
   call SysCls
   say ''
   say 'SLIP OR PPP?'
   say ''
   say 'Will this be a SLIP or PPP connection?'
   prompt = 'Enter S or P:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   serv = translate(SysGetKey('ECHO'))
   say ''
   if serv = 'S' then
      do
         say 'Selected:  SLIP'
         service = 'SLIP'
      end
   if serv = 'P' then
      do
         say 'Selected: PPP'
         service = 'PPP'
      end
   if pos(serv, 'SP') = 0 then say 'Must enter either S or P.  Try again'
   say ''
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=========================
are_we_using_souper_or_vsoup()

Which?
=========================
*/
are_we_using_souper_or_vsoup:
do until pos(souptype, '12') \= 0
   call SysCls
   say ''
   say 'ARE WE USING SOUPER OR VSOUP?'
   say ''
   say 'Which are we using as the program to transfer mail and news from the'
   say 'POP3 and/or NNTP mail and news servers into SOUP packets, and to send'
   say 'mail and posts in SOUP reply packets?'
   say '    1  Souper (as Souper.exe)'
   say 'or  2  VSoup  (as VSoup.exe)'
   prompt = 'Enter 1 or 2:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   souptype = translate(SysGetKey('ECHO'))
   say ''
   if souptype = 1 then
      do
         say 'Selected:  SOUPER'
         vsoup = 0
       end
   if souptype = '2' then
      do
         say 'Selected: VSOUP'
         vsoup = 1
      end
   if pos(souptype, '12') = 0 then say 'Must enter either 1 or 2.  Try again'
   say ''
end

select
   when stream(souper_exe, 'c', 'query exists') \= '',
     & stream(vsoup_exe, 'c', 'query exists') \= '' then
       /* means we found both in the yarn directory as expected
        (the xxxxx _exe names both have yarn dir as part of their filespecs) */
      do
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
      end
   when stream(souper_exe, 'c', 'query exists') = '',
     & stream(vsoup_exe, 'c', 'query exists') \= '',
     & vsoup = 0 then        /* Found vsoup.exe there.  Did not find souper.exe. */
      do
         call beep 1000, 200
         say ''
         say ''
         say 'We did not find SOUPER.EXE in the' yarn 'directory.'
         say 'This is the program you elected to use to get/send mail and posts'
         say 'You can copy it to that directory now.  You do not have to exit'
         say 'this install program to do so. (Of course you copy it later, too.)'
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
      end
   when stream(souper_exe, 'c', 'query exists') \= '',
     & stream(vsoup_exe, 'c', 'query exists') = '',
     & vsoup = 1 then        /* Found souper.exe there.  Did not find vsoup.exe. */
      do
         call beep 1000, 200
         say ''
         say ''
         say 'We did not find VSOUP.EXE in the' yarn 'directory.'
         say 'This is the program you elected to use to get/send mail and posts'
         say 'You can copy it to that directory now.  You do not have to exit'
         say 'this install program to do so. (Of course you copy it later, too.)'
         say ''
        say 'Press any key to continue'
         call SysGetKey 'NOECHO'
      end
   when stream(souper_exe, 'c', 'query exists') = '',
     & stream(vsoup_exe, 'c', 'query exists') = '' then
        /* Did not find either souper.exe or vsoup.exe there. */
      do
         call beep 1000, 200
         say ''
         say ''
         call beep 1000, 200
         if vsoup = 1 then
        say 'We did not find VSOUP.EXE in the' yarn 'directory.'
         if vsoup = 0 then
         say 'We did not find SOUPER.EXE in the' yarn 'directory.'
         say 'This is the program you elected to use to get/send mail and posts'
         say 'You can copy it to that directory now.  You do not have to exit'
         say 'this install program to do so. (Of course you copy it later, too.)'
         say ''
         if vsoup = 1 then
        say 'We did not find SOUPER.EXE either in the' yarn 'directory.'
         if vsoup = 0 then
         say 'We did not find VSOUP.EXE either in the' yarn 'directory.'
         say 'If you have both SOUPER.EXE and VSOUP.EXE, it is desirable'
         say 'to copy both in the' yarn 'directory in the event you might'
         say 'want to switch between them at some future time.'
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
      end
   otherwise
         if vsoup = 1 then
        say 'We successfully found VSOUP.EXE in the' yarn 'directory.'
         if vsoup = 0 then
        say 'We successfully found SOUPER.EXE in the' yarn 'directory.'
         say 'If you have both SOUPER.EXE and VSOUP.EXE, it is desirable'
         say 'to have both into the' yarn 'directory in the event you'
         say 'might want to switch between them at some future time.  Not'
         say 'necessary, but desirable.'
         say ''
         say 'Press any key to continue'
         call SysGetKey 'NOECHO'
   end    /* of SELECT */
RETURN

/*
=========================
should_we_piggyback_on_slippm()

We can draw parms from tcpos2.ini, as stored there
by slippm, or we can be prompted to enter (some) of them.
=========================
*/
should_we_piggyback_on_slippm:
piggyback = 1 /* initialize */
call SysCls
say ''
say 'PARAMETERS FOR DIALER'
say ''
say 'You can either get parameters your dialer needs from'
say 'a previous SLIPPM (Dial-Other-Internet-Providers)'
say 'installation, or you can be prompted for them.  It is'
say 'much easier to get parameters from a previous SLIPPM'
say 'setup.'
say ''
say 'Select:'
say '1  Get parameters from a previous SLIPPM installation'
say '2  Enter parameters from keyboard (prompted)'
say ''
say 'To quit so you can configure SLIPPM.EXE, press Escape.' 

prompt = 'Enter 1 or 2:'
say ''
do until pos(piggy, '12') \= 0
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   piggy = SysGetKey('ECHO')
   say ''
   if piggy = Escape then signal goodbye

   if piggy = 1 then
      do
         say 'We will piggyback parms from a previous SLIPPM installation'
         piggyback = 1
      end

   if piggy = 2 then
      do
         say 'Chose to be prompted for key parameters        '
         piggyback = 0
      end
   if pos(piggy, '12') = 0 then
      say 'Must enter either 1 or 2.  Try again'
   say ''
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN


/*
=========================
enable_dnk_option()

Should we enable the do_not_kil option?

This will allow the connection to be optionally shut down
or not depending on which keys are pressed at the main menu.
=========================
*/
enable_dnk_option:
do_not_kill_connection = 0        /* initialize to don't enable (=1 is enable) */
call SysCls
say ''
say 'DO NOT-KILL-CONNECTION OPTION'
say ''
say 'You can have the connection shut down at the end or not'
say 'depending on which keys are pressed at the main menu.'
say 'Or you can have YARNDIAL ALWAYS shut it down at the end.'
say ''
say 'Select:'
say '0  Always shut down connection, etc., when YARNDIAL transfers are done'
say '1  Give us the option to shut down or not.'

prompt = 'Enter 0 (zero) or 1:'
say ''
do until do_not_kill_connection = 0 | do_not_kill_connection = 1
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   do_not_kill_connection = SysGetKey('ECHO')
   say ''
   if do_not_kill_connection = 1 then
      do
         say 'Can optionally choose at main menu to leave connection up  '
         say 'when transfers are done.'
      end
   if do_not_kill_connection = 0 then
      do
         say 'Connection will always shut down when transfers are done.  '
         say ''
         say 'Even though you selected to always close the connection,'
         say 'you will next be asked for a set of alternate key-presses'
         say 'to use to keep connection up if later you decide to activate'
         say 'the ''do-not-close-connection'' option by editing the file'
         say ydparms_dat || '.'
      end

   if do_not_kill_connection \= 0 & do_not_kill_connection \= 1 then
      say 'Must enter either 0 or 1.  Try again'
   say ''
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=================
get_dnk_string()

Prompt for entry of the alternate characters in place of 1-7
where connection will not be killed when YARNDIAL finishes.
This entry populates the variable DNK_STRING in the YD_PARMS.DAT file
=================
*/
get_dnk_string:
call SysCls
say ''
say 'DNK_STRING  (DO NOT KILL CONNECTION String)'
say '  (You will now enter a 7-character string)'
say ''
say 'When YARNDIAL opens, the main menu has seven choices (1-7).'
say ''
say 'You can specify key-presses to be used in place of 1-7 that leave'
say 'the modem connected to your ISP when YarnDial finishes.  The best'
say 'alternate keys to use are: whatever SHIFT-1 thru SHIFT-7 do'
say 'on your particular national keyboard.  Keyboards will vary from'
say 'country to country.'
say '    [you can enter any 7 characters (printables, no CTRL chars)]'
say ''
do until length(dnk_string) = 7
   dnk_string = ''
   prompt = 'ENTER: (Recommended: SHIFT-1 thru SHIFT-7): '
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   parse pull dnk_string
   if length(dnk_string) \= 7 then
      do
         say ''
         say 'You entered' length(dnk_string) 'characters.'
         say ''
      end 
end
   say ''
   say 'Press any key to continue'
   call SysGetKey 'NOECHO'
RETURN


/*
==============================================
get_passw_PWD()

Prompt for the Provider Access password.
==============================================
*/

get_passw_PWD:

call SysCls
say ''
say 'PROVIDER ACCESS PASSWORD'
say ''
say 'If you press enter instead of entering a password, '
say 'password is not stored and you will be prompted for one.'
say 'This is the password for accessing the provider.  For'
say 'some providers it and the e-mail POP3 password are the'
say 'same and YARNDIAL uses the POP3 password you were'
say 'prompted for and responded to earlier.'
say ''
say 'In most setups, you will bypass this by pressing ENTER'
say 'two times, thus not recording any password.'
say ''
say ''
do until match = some_password
   call pull_password
end
PWD = some_password
RETURN

/*
==============================================
get_passw_POP3PWD()

Prompt for the pop password (e-mail).
==============================================
*/

get_passw_POP3PWD:

call SysCls
say ''
say 'POP (e-mail) PASSWORD SCREEN'
say ''
say 'Enter password used for e-mail.'
say 'This is your POP (or POP3) password.'
say ''
say ''
do until match = some_password
   call pull_password
end
POP_PWD = some_password
RETURN


/*
==============================================
pull_password()
and
get_pw()

The actual keyboard-entry routine get_pw()
is a modification of one from the IBM Rexx Manual
which is copyrighted by IBM and is used here with
permission.

pull_password() simply calls the routine get_pw()
twice:  once to get the password, and again to confirm.
We do this until an entered password can be confirmed.

get_pw() accepts the argument H, h, Hide, hide which
will echo * instead of the character.
==============================================
*/
pull_password:

   prompt = '          Enter password:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      call get_pw 'H'
   some_password = password
   say ''
   prompt = 'Enter it again to verify:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      call get_pw 'H'
      match = password
   if match \== some_password then say 'The two did not match'
   say ''
RETURN



get_pw: procedure expose password 

/* H or h or hide as argument echos chars as *
otherwise chars entered are echoed     */

parse upper arg hide_for_passwording
hide_for_passwording = abbrev(hide_for_passwording, 'H')

bs = d2c(8)
cr = d2c(13)        /* enter key, as well as carriage return */
escape = d2c(27)        /* escape character */
X1 = d2c(0)        /* Extended key */
X2 = d2c(224)        /* Extended key */

Valid = xrange(' ', '~') 
/* same as Valid = ' !"#$%&''()*+,-./0123456789:;',
         '<=>?@''ABCDEFGHIJKLMNOPQRSTUVWXYZ',
         '[\]^_abcdefghijklmnopqrstuvwxyz{|}~'
very nearly every common printable */ 
password = ''
MaxLength = 254

do forever
   ch = SysGetKey('NOECHO')
   select
      when ch = Escape then signal goodbye  /* Escape, so we quit immediately */
      when ch = cr        /* Enter key pressed */
         then do
        say ''        /* Give carriage return */
        leave
         end
      when ch = bs        /* Backspace */
         then if password = ''
        then call  beep 262, 200        /* Tell us no chars to bs over */
         else do        /* Overstrike a blank */
        call charout , bs bs 
        password = left(password, length(password)-1)
         end
 
        /* All other characters */
      when pos(ch, Valid) > 0
         then if length(password) = MaxLength
        then call beep 262, 200
        else do
         if hide_for_passwording = 1 then call charout , '*'
         else call charout , ch
         password = password || ch
        end
      otherwise do         /* Swallow next for Extended */
         if ch = X1 | ch = X2
        then call SysGetKey 'NOECHO'
         call  beep 262, 200
      end
   end
end
RETURN password 

/*
==============================================
get_dialer_timeout_wait()

When we dial in, how long before we let our dialer time out?
==============================================
*/
get_dialer_timeout_wait:
call SysCls
say ''
say 'SET DIALER TIMEOUT'
say ''
say 'Wait how many seconds before IBM/IGN/Advantis IAK dialer times out.'
say 'Default: 120 seconds'
say '(usually allows both main and backup number to be attempted)'
say ''
prompt = 'Press Enter to accept default, or enter wait in seconds:' 
do until DataType(wait,'W')
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      pull wait .
      if wait = '' then
         do
        wait = 120
         end
      if DataType(wait) = 0 then say 'Whole number only. Try Again.'
      else say 'wait =' wait 'seconds'
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
souper_options()

We set some options for souper and/or vsoup
==============================================
*/

souper_options:
call SysCls
souper_getnews_xtra_options = '' /* the defaults */
souper_getmail_xtra_options = ''
vsoup_getnews_xtra_options = ''
vsoup_getmail_xtra_options = ''
vsoup_send_xtra_options = ''

option1 = '-k2048'   /* max souppacket size in KB */
option2 = '-l0'       /* max # of lines in a newsgroup article. 0 is unlimited */
option3 = ''        /* -a, if want to check for new newsgroups */
option4 = '-t4'       /* For VSoup: number of simultaneous threads.  Can be 1-10 */
option5 = '-S1'      /* For VSoup: news-retrieval aggressiveness, can be 0-2 (2 most aggr.) */
option6 = ''        /* For Vsoup: -M option.  Generate VSoup Status Report (stored with
        e-mail) every time instead of only when there are exceptions and
        errors to report.  Can serve as a log and is particularly useful if run
        yarndial from a timer program remotely. */         
call SysCls
say ''
say 'SOUPER (VSOUP) OPTIONS SCREENS'
say 'You can set some of the options for how souper or vsoup run.  These'
say 'can be set, over-ridden or added-to by editing' ydparms_dat
say 'after this install has completed, instead of using this screen.'

do until opts = 9
   say ''
   say 'These three apply to Souper and VSoup:'
   say '  1 Set maximum news packetsize (default is 2048KB [2.048MB])'
   say '  2 Do not retrieve newsgroup articles containing more than a'
   say '    set number of lines in the body (0 is ''no limit'')'
   say '  3 Check for new newsgroups (default is ''don''t check'')'
   say ''
   say 'These next three only come into play when VSOUP is used:'
   say '  4 Number of simultaneous news threads.  Default 4, min 1, max 10'
   say '  5 News receiving strategy (refer VSOUP.INF, YD.DOC).  This is the'
   say '    VSoup -S parameter. 0, 1 or 2: least to most aggressive. 1 is default.'
   say '  6 Generate a VSoup Status Report every time instead of default which'
   say '    generates it only when there are exceptions and errors to report.'
   say '  7   (reserved for future use)'
   say '  8 DEFAULT all of the above.'
   say '  9 WHEN DONE: press 9 to exit this screen'
   do until pos(opts,'12345689') \= 0 & opts < 10
      say ''
      prompt = 'Select 1-6, 8 or 9:'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      opts = SysGetKey('NOECHO')
   end
   
   select
      when opts = 1 then call max_news_packet
      when opts = 2 then call max_news_lines
      when opts = 3 then call check_for_new_newsgrps
      when opts = 4 then call vsoup_newsthreads_to_run 
      when opts = 5 then call news_retrieval_aggressiveness
      when opts = 6 then call vsoup_status_reporting
      when opts = 8 then
         do
        option1 = '-k2048'
        option2 = '-l0'
        option3 = ''
        option4 = '-t4'
        option5 = '-S1'
        option6 = ''
        say ''
        say 'Accepting defaults for all options'
        say ''
        say ''
        say 'Press any key to continue'
        call SysGetKey 'NOECHO'
         end
      otherwise say 'Not a valid choice.  Try again.'
   end /* of Select */
   call SysCls
end        /* of DO UNTIL OPTS=9 */

   souper_getnews_xtra_options = option1 option2
   souper_getnews_xtra_options = strip(souper_getnews_xtra_options, 'B')
   souper_getnews_xtra_options = souper_getnews_xtra_options option3
   souper_getnews_xtra_options = strip(souper_getnews_xtra_options, 'B')

   souper_getmail_xtra_options = ''        /* We don't set souper mail extra options */

   vsoup_getnews_xtra_options = souper_getnews_xtra_options
   vsoup_getnews_xtra_options = vsoup_getnews_xtra_options option4
   vsoup_getnews_xtra_options = strip(vsoup_getnews_xtra_options, 'B')
   vsoup_getnews_xtra_options = vsoup_getnews_xtra_options option5
   vsoup_getnews_xtra_options = strip(vsoup_getnews_xtra_options, 'B')
   vsoup_getnews_xtra_options = vsoup_getnews_xtra_options option6
   vsoup_getnews_xtra_options = strip(vsoup_getnews_xtra_options, 'B')

   vsoup_getmail_xtra_options = vsoup_getmail_xtra_options option6
   vsoup_getmail_xtra_options = strip(vsoup_getmail_xtra_options, 'B')

   vsoup_send_xtra_options = vsoup_send_xtra_options option6
   vsoup_send_xtra_options = strip(vsoup_send_xtra_options, 'B')

call SysCls
say ''
say ''
say ''
say 'Done setting options.'
say 'If you are using Souper.exe, command lines will be:'
say 'GETMAIL:  souper.exe' souper_getmail_std_options souper_getmail_xtra_options
say 'GETNEWS:  souper.exe' souper_getnews_std_options souper_getnews_xtra_options
say 'SENDING:  souper.exe' souper_send_std_options souper_send_xtra_options
say ''
say '...and if you are using VSoup.exe, command-lines will start with'
say 'GETMAIL:  vsoup.exe' vsoup_getmail_std_options vsoup_getmail_xtra_options
say 'GETNEWS:  vsoup.exe' vsoup_getnews_std_options vsoup_getnews_xtra_options
say 'SENDING:  vsoup.exe' vsoup_send_std_options vsoup_send_xtra_options
say ''
say '   Server, access authorization and other information may be additional.'
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN
 
/*
=========================
max_news_packet()

Default is a packet-size of 2048 kB (2.048 Megs)
=========================
*/
max_news_packet:
call SysCls
option1 = 2048
say ''
say 'MAXIMUM NEWS-PACKET SIZE'
say ''
say 'Enter a number in kilobytes for maximum news packet size.'
say '2048 is default. 0 sets packet size to unlimited.'
say ''
do until datatype(option1, 'W')
   prompt = 'Enter number of kilobytes now:'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   pull option1
   call strip option1, 'B'
   call strip option1, 'B', tab
   call strip option1, 'B'
   call strip option1, 'B', tab
   if \DataType(option1, 'W') then say 'Must be whole number or zero.'
end
 
say ''
say 'Maximum packet size for news is set to' option1 'kilobytes'
option1 = '-k' || option1
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=========================
max_news_lines()

Default is no limit.  Because of spamming of
news articles with attached binaries running
to 10,000 lines or more, you can set a limit.
I use 500, myself.
=========================
*/
max_news_lines:
call SysCls
option2 = 0
say ''
say 'MAXIMUM SIZE OF NEWS ARTICLES RETRIEVED'
say ''
say 'Do not retrieve articles with more than this many lines'
say 'in the body of the article.  Enter 0 for unlimited (the'
say 'usual default for souper).'
say ''
   do until datatype(option2, 'W')
      prompt = 'How many lines is the maximum acceptable?'
      say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      pull option2
      call strip option2, 'B'
      call strip option2, 'B', tab
      call strip option2, 'B'
      call strip option2, 'B', tab
      if \DataType(option2, 'W') then say 'Must be whole number or zero.'
  end
say ''
say 'News article not retrieved if over' option2 'lines'
if option2 = 0 then option2 = ''
else option2 = '-l' || option2
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=========================
check_for_new_newsgrps()

'Y' adds new ones to your newsrc file but inactivated
until you remove the 'inactivate' character.  Default
is 'N'
=========================
*/
check_for_new_newsgrps:
call SysCls
option3 = 'N'
say ''
say 'ADD NEW NEWSGROUPS'
say ''
say 'Do you want to check for new news groups and have them added'
say 'to your newsrc file (but set as inactive until you activate them)?'
prompt = 'Enter Y or N:'
say ''
do until pos(option3, 'YyNn') \= 0
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   option3 = SysGetKey('ECHO')
   if pos(option3, 'YyNn') = 0 then say 'Must be Y or N.  Try again.'
end
say ''
if translate(option3) = 'Y' then
   do
      option3 = '-a'
      say 'You elected to add new news groups to your newsrc'
   end
else
   do
      option3 = ''
      say 'You elected not to add new news groups to your newsrc'
   end
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=========================
vsoup_newsthreads_to_run()

VSoup, -t option
=========================
*/
vsoup_newsthreads_to_run:
call SysCls
option4 = 4
say ''
say 'VSOUP NEWS THREADS (the -t option)'
say ''
say 'Number of simultaneous VSoup threads connecting to news'
say 'server.  Min is 0, max is 10.  Higher is faster.'
say '  (4 is safe ground; but 10 is worth trying first)'
say ''
do until datatype(option4, 'W') & option4 > 0 & option4 < 11
   prompt = 'Enter threads (1-10):'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   pull option4
   call strip option4, 'B'
   call strip option4, 'B', tab
   call strip option4, 'B'
   call strip option4, 'B', tab
   if \DataType(option4, 'W') | option4 < 1 | option4 > 10 then say 'Must be 1-10.'
end

say ''
say 'VSoup threads set to' option4
option4 = '-t' || option4
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN


/*
=========================
news_retrieval_aggressiveness()

VSOUP, -S option
=========================
*/
news_retrieval_aggressiveness:
call SysCls
option5 = 1
say ''
say 'VSOUP NEWS-RETRIEVAL AGGRESSIVENESS (the -S option)'
say ''
say '  0  Threads are all fetching articles from a single newsgroup'
say '        at a time.  Least aggressive but best chance of detecting'
say '        and not duplicating cross-posted articles.'
say '  1  Intermediate in aggressive retrieval.'
say '  2  Threads fetch from different groups simultaneously.  Most'
say '        agressive, fastest, but least effective at detecting'
say '        and not duplicating cross-posted articles.'
say ''
say 'Recommended: 2'
say ''
do until pos(option5, '012') \= 0 
   prompt = 'Enter aggressiveness setting (0, 1, or 2):'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   option5 = SysGetKey('ECHO')
   if pos(option5, '012') = 0 then say 'Must be 0, 1, or 2.'
end
say ''
say 'News retrieval aggressiveness set to' option5
option5 = '-S' || option5
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=========================
vsoup_status_reporting()

'Y' adds -M to options.  Default is not to add it.   For Vsoup: -M option
generates VSoup Status Report (stored with e-mail) every time instead of
only when there are exceptions and errors to report.  Can serve as a log
and is particularly useful if run yarndial from a timer program remotely.
=========================
*/
vsoup_status_reporting:
call SysCls
option6 = '1'
say ''
say 'VSOUP STATUS REPORTING'
say ''
say 'Do you want to generate VSoup status reports:'
say '    1  Only for errors and exceptions, and when new news groups'
say '        are reported'
say 'or  2  Every time'
say '     (Note: whichever you choose, any status reports may contain'
say '      password info)'
do until pos(option6, '12') \=0
   prompt = 'Enter 1 or 2:'
   say ''
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   option6 = SysGetKey('ECHO')
   if pos(option6, '12') = 0 then say 'Wrong entry.  Try again'
end
say ''
if option6 = '1' then
   do
      option6 = ''
      say 'You elected to generate VSoup status reports only'
      say 'for errors and exceptions'
   end
if option6 = '2' then
   do
      option6 = '-M'
      say 'You elected to generate VSoup status reports every time'
   end
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
Almost done.  No changes to system yet.  Do
we want to quit before copying files?
==============================================
*/

chance_to_quit:
call SysCls
say ''
say 'WE ARE NOW READY TO COPY FILES...'
say ''
say 'Up till now, no changes have been made to your system.'
say ''
say 'We will complete installation by creating' ydparms_dat ||','
say 'by copying other necessary files to your' home 'directory,'
say 'and by creating some ReXX utility files which we save to'
say 'the' home 'directory.'
say ''
say 'We will create'
say '   A series of sub-directories for mail, news, and outgoing.'
say '   (any that already exist are left unchanged).'
say ''
say '   A Folder Object on the Desktop containing objects for YARNDIAL'
say '   and for several utilities including one for starting up YARN.'
say ''
say 'No other changes are made to your system.'
say ''
say 'To quit without completing installation, press Escape.'
say ''
say 'Otherwise PRESS ANY OTHER KEY TO COMPLETE INSTALLATION.'
if SysGetKey('NOECHO') = Escape then
   do
      call SysCls
      say ''
      say 'Aborting without copying files to' HOME
      say 'or creating' ydparms_dat 'or creating the'
      say 'sub-directory INCOMING.'
      say ''
      say 'No changes were made to your system.'
      signal goodbye
   end
RETURN
 
/*
==============================================
Write the YD_PARMS.DAT file to the yarn home
directory to which we are installing YarnDial.
This has all the data Yarndial needs to be
able to run from (for) that Yarn user
installation.
==============================================
*/
output_dat:
home_drive
'cd' home

o21 = '&\<=>|()! *+"''-/,#$%.0123456789:;?'
o22 = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^'
o23 = '_`abcdefghijklmnopqrstuvwxyz{}~'
e21 = '&\<=>|()u *+"''-/,MI$kUHgW[_A5%w~Fh'
e22 = 't?K^l0jJP{98xBadb1nZimRyY]4}`o'
e23 = 'E;67V@vS:C.sNGzcefQpqTr!2#XDLO3'

/* Encrypt passwords, etc. */
PWD = translate(PWD, o21||o22||o23, e21||e22||e23)
POP_PWD = translate(POP_PWD, o21||o22||o23, e21||e22||e23)
PIN = translate(PIN, o21||o22||o23, e21||e22||e23)

/* if ydparms_dat or ydaltparms_dat exist, back them up */
parse var ydparms_dat dat '.' ext
if stream(ydparms_dat, 'c', 'query exists') \= '' then,
   do
      say 'Backing up old' ydparms_dat
      'copy' ydparms_dat dat || '.bak>nul'
   end

call SysFileDelete ydparms_dat

parse var ydaltparms_dat altdat '.' ext
if stream(ydaltparms_dat, 'c', 'query exists') \= '' then,
   do
      say 'Backing up old' ydaltparms_dat
      'copy' ydaltparms_dat altdat || '.bak>nul'
   end

/* now output data to file YDPARMS_DAT */
do queued(); pull; end        /* First clear out any lines in rxqueue */ 

call data        /* put text to be output into rxqueue */
line = ''
do queued()
  parse pull line        /* get it line-by-line and output it to file */
  call lineout ydparms_dat, line
end

call stream ydparms_dat, 'c', 'close'
yd_parms_dat = translate(ydparms_dat)
say ydparms_dat 'created/updated.'
say ''
RETURN

/*
==============================================
YD_PARMS.DAT data file.

These parameters drive YARNDIAL
==============================================
*/
DATA:
queue '#' ydparms_dat 'created' Date() Time() 'by YDINSTL v.' version
queue '#'
queue '#    Edit with any ASCII text editor such as the OS/2 System Editor'

if connection_type=5 then
   do
      queue '#'
      queue '#    Created by installing YARNDIAL for connection_type = 5'
      queue '#    (May require editing to complete manual configuration)'
      queue '#'
   end

queue '#    The # sign at the very beginning of a line comments out that line'
queue '#'
queue '# These are your Yarn %Home% and %Yarn% directories'
queue 'HOME=' || home
queue 'YARN=' || yarn
queue '#'
queue '# If DO_NOT_KILL_CONNECTION =1 then if one of the 7 keys in DNK_STRING'
queue '# is pressed at the main menu instead of 1-7, YARNDIAL performs the same'
queue '# actions as for 1 thru 7, but the connection is left up when transfers'
queue '# are completed.'
queue '# DNK_STRING defaults to !@#$%^& (shift-1 thru shift-7 on US keyboard).'
queue '# Edit DNK_STRING to whatever 7 keys are convenient for your keyboard.'
queue '#'
queue 'DO_NOT_KILL_CONNECTION=' || do_not_kill_connection
queue 'DNK_STRING=' || dnk_string
queue '#'
queue '# ABOUT OVERRIDE_DNK_DURING_REMOTE'
queue '#   If DO_NOT_KILL_CONNECTION=1 (do not shut down connection), AND'
queue '#   YARNDIAL is being run by a timer program remotely (i.e., unattended)'
queue '#   leaving OVERRIDE_DNK_DURING_REMOTE=1 (the default) overrides the'
queue '#   do-not-kill option then, but allows it during normal (attended) operation.'
queue '#   If you are determined to leave the connection up when running on a timer'
queue '#   program and have selected not to kill the connection, you must set'
queue '#   OVERRIDE_DNK_DURING_REMOTE=0 or the connection will shut down'
queue '#   when YARNDIAL completes.'
queue 'OVERRIDE_DNK_DURING_REMOTE=1'
queue '#'
queue '# ABOUT THE CONNECTION_TYPE CHOICES:'
queue '#   1 Installed for IBM/IGN/Advantis via IAK Dialer.'
queue '#   2 (Reserved)'
queue '#   3 Installed for use of a slip.exe or ppp.exe dialup string.'
queue '#   4 Installed for SLIPPM (IBM''s Dial-Other-Internet-Providers.'
queue '#     Utility) or a SLIPPM replacement such as ILINK/2, IN-JOY, etc.'
queue '#   5 You chose manual configuration: to be prompted for key parameters'
queue '#     followed by manually editing this file as necessary.'
queue '#   6 Pot-Luck:  Tries to use any connection that happens to be'
queue '#     established.  Connection must be made BEFORE you start YarnDial.'
queue '#   7 Like 6, but does not check for a connection, and uses the string'
queue '#     in dialup_string to dial.'
queue '#   Anything but 1 or 3-7 for connection_type is an error condition.'
queue '#'
queue 'connection_type=' || connection_type
queue '#'
queue '# ABOUT DIALUP_STRING:'
queue '#   If you plan to use a ppp.exe or slip.exe or other dialup string'
queue '#   which uses either SLIP.EXE or PPP.EXE to make the connection,'
queue '#   enter it below if it has not automatically been entered.'
queue '#   Read' YD_DOC 'for further information.'
queue '#   YARNDIAL executes dialup_string as the evaluated expression:'
queue '#      interpret dialup_string'
queue '#   What you enter for dialup_string should consist of ''start'''
queue '#   (always required) plus /N (usually) plus the dialer executable'
queue '#   such as ppp.exe, slippm.exe, etc., plus any arguments.'
queue '#'
queue 'dialup_string=' || dialup_string  
queue '#'
queue '# SETTING INTERFACE_REMOVAL:'
queue '#   IN-JOY sometimes leaves behind a phantom router interface after'
queue '#   the connection and IN-JOY are terminated.  You can test for this'
queue '#   by running netstat -r after YARNDIAL (or INJOY) has shut down.'
queue '#   You can wipe out such phantoms if you set interface_removal to'
queue '#   1 or 2.  A setting of 0 is the default and does not do anything.'
queue '#'
queue '# interface_removal=0       Use this if you regularly establish'
queue '#   simultaneous connections via SLIP or PPP through more than one COM'
queue '#   port at a time.  But if phantom routings are left by IN-JOY, you'
queue '#   will have to live with the problem.  Choose this if you never use'
queue '#   IN-JOY.'
queue '# interface_removal=1       Deletes any routing entries left standing'
queue '#   but only if IN-JOY is your dialer and if the interf_prefix in the'
queue '#   routing entry matches IN-JOY''s  Suggestion: set the interface'
queue '#   name in one of the IN-JOY OPTIONS pages to something unique for'
queue '#   your connection to achieve maximum selectivity during operation of'
queue '#   interface_removal = 1 (an IN-JOY interface name up to five letters'
queue '#   long can be used)'
queue '# interface_removal = 2       Whatever the dialer and interf_prefix'
queue '#   deletes all routing entries at shut_down of YARNDIAL.  If you'
queue '#   have a problem with phantom routings using IN-JOY and never expect'
queue '#   to have make simultaneous connections via SLIP or PPP through more'
queue '#   than one COM port at a time,  try setting interface_removal = 2.'  
queue '#'
queue 'interface_removal=' || interface_removal
queue '#'
queue '# ABOUT ZIP/UNZIP UTILITIES:'
queue '# Depending upon what compress and uncompress utilities you use'
queue '# you may need to edit zip_exe= and unzip_exe=  below (use full paths)'
queue '#         Samples:'
queue '#       OS/2 InfoZip compress/uncompress programs:'
queue '#        zip_exe=d:\pk_unpk\zip201c2\zip.exe -0m'
queue '#        unzip_exe=d:\pk_unpk\unz512x2\unzip.exe -o'
queue '#'
queue '#       MS-DOS PkWare compress/uncompress programs:'
queue '#        zip_exe=cmd.exe /c c:\path\pkzip -m -u -o'
queue '#        unzip_exe=cmd.exe /c c:\path\pkunzip -o'
queue '# Using another compress/uncompress set?  Refer to' yd_doc || '.'
queue '# For any MSDOS based ones, you must use  cmd.exe /c  to call them'
queue '# as shown for the PkWare examples'
queue '#'
queue 'zip_exe=' || zip_exe
queue 'unzip_exe=' || unzip_exe
queue '#'
queue '#'
queue '# host (the domain), user (e-mail ID) are from YARN''s CONFIG file.'
queue '# reply_packet holds the value assigned to reply-packet in YARN''s'
queue '# CONFIG file.'
queue '#'
queue 'host=' || host
queue 'user=' || user
queue 'reply_packet=' || reply_packet
queue '#'
queue 'souper_exe=' || souper_exe
queue 'vsoup_exe=' || vsoup_exe 
queue 'yarn_exe=' || yarn_exe 
queue 'import_exe=' || import_exe 
queue 'export_exe=' || export_exe 
queue 'expire_exe=' || expire_exe 
queue 'rebuild_exe=' || rebuild_exe
queue 'go_exe=' || go_exe
queue 'killjoy_exe=' || killjoy_exe
queue 'alt_dialer_exe=' || alt_dialer_exe
queue '#'
queue '# ABOUT INTERF_PREFIX'
queue '# The IN-JOY dialer allows the user during dialer configuration to'
queue '# specify a custom name (up to 5 characters) for the named-interface'
queue '# prefix in place of the more usual ppp or sl or slip or lan prefixes'
queue '# (as examples).  In multi-user YARNDIAL installations using IN-JOY as'
queue '# the dialer, this interface-prefix parameter may be set to be unique'
queue '# for each user and we can use it as an identifier.  For other dialers'
queue '# interf_prefix defaults to PPP, ppp or SL or sl, etc., depending on'
queue '# what is indicated for SERVICE and what is known about the dialer.' 
queue '#'
queue 'interf_prefix=' || interf_prefix
queue '#'
queue '# ABOUT VSOUP'
queue '# vsoup=1 means we are using vsoup.exe; vsoup=0 means souper.exe'
queue '#'
queue 'VSOUP=' || vsoup
queue '#'
queue '# CUSTOMIZING SOUPER AND VSOUP RUN-TIME OPTIONS'
queue '# You can modify the runtime options for souper.exe or vsoup by editing'
queue '# these.  Read over' yd_doc 'and the souper documentation before'
queue '# doing so.  DO NOT change the ones indicated as _std_ .  Especially, DO'
queue '# NOT remove the -i''s because we read our set up variables from this file'
queue '# and not from the TCP-IP settings notebooks when we run the souper'
queue '# program.'
queue '#'
queue '# FOR RUNNING SOUPER.EXE, options below will be used in YARNDIAL strings'
queue '# of the general form:'
queue '#   Souper.exe xxx_std_options xxx_xtra_options'
queue '#       with <server> <userID> <password> tacked on.'
queue '#'
queue 'souper_getmail_std_options=' || souper_getmail_std_options
queue 'souper_getnews_std_options=' || souper_getnews_std_options
queue 'souper_send_std_options=' || souper_send_std_options
queue 'souper_getmail_xtra_options=' || souper_getmail_xtra_options
queue 'souper_getnews_xtra_options=' || souper_getnews_xtra_options
queue 'souper_send_xtra_options=' || souper_send_xtra_options
queue '#'
queue '# FOR RUNNING VSOUP.EXE, options below will be used in YARNDIAL strings'
queue '# of the general form:'
queue '#   VSoup.exe xxx_std_options xxx_xtra_options zzzz://userID:password@server'
queue '# where zzzz will be either pop3, nntp, or smpt; server will be the'
queue '# mail, news or smtp server.'
queue '#'
queue 'vsoup_getmail_std_options=' || vsoup_getmail_std_options
queue 'vsoup_getnews_std_options=' || vsoup_getnews_std_options
queue 'vsoup_send_std_options=' || vsoup_send_std_options
queue 'vsoup_getmail_xtra_options=' || vsoup_getmail_xtra_options
queue 'vsoup_getnews_xtra_options=' || vsoup_getnews_xtra_options
queue 'vsoup_send_xtra_options=' || vsoup_send_xtra_options
queue '#'
queue '#'
queue '# ABOUT GETMAIL_AUTHO, GETNEWS_AUTHO, and SEND_AUTHO'
queue '# Selects how ID and password authorizations are handled on command lines'
queue '# for accessing POP3, NNTP, and SMTP servers, respectively.  These apply to'
queue '# both Souper and VSoup command lines but illustration below of how the xxx_Autho'
queue '# choices affect ID and password and servername selection are for VSoup command'
queue '# lines only.'
queue '# GetNews_Autho.1=1         vsoup.exe vsoup_options nntp://pop_id:pop_pwd@defaut_news'
queue '# GetNews_Autho.1=2         vsoup.exe vsoup_options nntp://login_id:pwd@defaut_news'
queue '# GetNews_Autho.1=3         vsoup.exe vsoup_options nntp://defaut_news'
queue '#    where vsoup_options = the combined _std_ and _xtra_ options above, and'
queue '#    default_news is the nntp server'
queue '# In like fashion, GetMail_Autho applies to the POP3 server and Send_Autho to the SMTP'
queue '# server.  If the default of the particular xxx_autho as 1 doesn''t work, try 3 and then 2'
queue '#    (All of the Getxxx_Autho parameters are near the end of this .DAT file)'
queue '#'
queue '# WAIT is a dialer timeout, in seconds'
queue 'wait=' || wait 
queue '#'
queue '#    The following is the name of the Dial-Other-Internet-Providers'
queue '#    app in TCPOS2.INI, or the host-name argument for the dialer command'
queue 'host_app=' || host_app
queue '#'
queue '#   Parms extracted from the TCPOS2.INI file, from'
queue '#   the IAK DIALER.INI file, combined (where they overlap)'
queue '#   using wherever possible the TCPOS2.INI key names'
queue '#'
queue 'account=' || account
queue 'ASK=' | |ASK
queue 'IS1=' || IS1
queue 'IS2=' || IS2
queue 'RS1=' || RS1
queue 'RS2=' || RS2
queue 'FS1=' || FS1
queue 'FS2=' || FS2
queue 'PIN=' || PIN
queue '#'
queue '#'
queue 'PROVIDER=' || PROVIDER
queue 'SAVE_PWD=' || SAVE_PWD
queue 'PHONE_NUMBER=' || PHONE_NUMBER
queue 'HANGUP=' || HANGUP
queue 'SCRIPT=' || SCRIPT
queue 'SERVICE=' || SERVICE
queue 'YOURIP=' || YOURIP
queue 'DESTIP=' || DESTIP
queue 'NETMASK=' || NETMASK
queue 'MTU_SIZE=' || MTU_SIZE
queue 'VJ_COMP=' || VJ_COMP
queue 'PRIMARY_INF=' || PRIMARY_INF
queue 'HOSTNAME=' || HOSTNAME
queue 'DOMAIN_NAME=' || DOMAIN_NAME
queue 'DNS=' || DNS
queue 'DNS2=' || DNS2
queue 'DEFAULT_WWW=' || DEFAULT_WWW
queue 'DEFAULT_GOPHER=' || DEFAULT_GOPHER
queue 'REPLY_DOMAIN=' || REPLY_DOMAIN
queue 'REPLY_ID=' || REPLY_ID
queue 'MODEM_TYPE=' || MODEM_TYPE
queue 'COMPORT=' || COMPORT
queue 'BAUD=' || BAUD
queue 'DATABITS=' || DATABITS
queue 'PARITY=' || PARITY
queue 'DIAL_MODE=' || DIAL_MODE
queue 'PREFIX=' || PREFIX
queue 'PREFIX_ANS=' || PREFIX_ANS
queue 'INIT=' || INIT
queue 'INIT2=' || INIT2
queue 'DISABLE=' || DISABLE
queue 'DISABLE_SEQ=' || DISABLE_SEQ
queue 'DIAL_PREFIX=' || DIAL_PREFIX
queue 'AUTOSTART=' || AUTOSTART
queue 'TOTAL_CONNECT=' || TOTAL_CONNECT
queue '#'
queue '# ********** Internet Service Provider Fields **********'
queue '# YarnDial can recognize any number of ISP''s.  Space for 3 is provided below.'
queue '#' 
queue '# More ISP''s can be added to this file.  Each can be toggled ON and OFF'
queue '# with their respective ISP_ACTIVE.i switches (1 is ON, 0 is OFF).'
queue '# There is no MAIL_GW or SEND_AUTHO for ISP''s 2 and greater because'
queue '# we always send using parameters of ISP 1.'
queue '#'
queue '# ENCR_PWD and ENCR_POP_PWD fields are for encrypted passwords.'
queue '# If the field for non-encrypted-passwords (PWD or POP_PWD) is filled'
queue '# in, that entry over-rides any entry for its encrypted counterpart.  That'
queue '# allows the user to experiment easily by just editing this file.'
queue '#' 
queue '# TO ENCRYPT PASSWORDS:'
queue '#    From an OS/2 command line, change to a directory in which YDINSTL'
queue '#    resides.  To encrypt MyPassword, type in the following and press ENTER:'
queue '#         YDINSTL.CMD encrypt MyPassword'     
queue '#    Then transfer (type in or copy & paste) the encrypted password into this'
queue '#    file.  This is further discussed in YD.DOC, section 21.00.'
queue '#'
queue '# Your YarnDial installation with YDONSTL.CMD has set up this first ISP.'
queue '# ISP_ACTIVE for it (ISP_ACTIVE.1) must always be =1.'
queue 'ISP_ACTIVE.1=1'
queue 'LOGIN_ID.1=' || LOGIN_ID
queue 'ENCR_PWD.1=' || PWD 
queue 'PWD.1='
queue 'POP_ID.1=' || POP_ID
queue 'ENCR_POP_PWD.1=' || POP_PWD 
queue 'POP_PWD.1=' 
queue 'DEFAULT_NEWS.1=' || DEFAULT_NEWS
queue 'POPSRVR.1=' || POPSRVR
queue 'MAIL_GW.1=' || MAIL_GW
queue 'GETMAIL_AUTHO.1=1'
queue 'GETNEWS_AUTHO.1=1'
queue 'SEND_AUTHO.1=1'
queue '#'
queue 'ISP_ACTIVE.2=0'
queue 'LOGIN_ID.2='
queue 'ENCR_PWD.2='
queue 'PWD.2='
queue 'POP_ID.2='
queue 'ENCR_POP_PWD.2='
queue 'POP_PWD.2='
queue 'DEFAULT_NEWS.2='
queue 'POPSRVR.2='
queue 'GETMAIL_AUTHO.2=1'
queue 'GETNEWS_AUTHO.2=1'
queue '#'
queue 'ISP_ACTIVE.3=0'
queue 'LOGIN_ID.3='
queue 'ENCR_PWD.3='
queue 'PWD.3='
queue 'POP_ID.3='
queue 'ENCR_POP_PWD.3='
queue 'POP_PWD.3='
queue 'DEFAULT_NEWS.3='
queue 'POPSRVR.3='
queue 'GETMAIL_AUTHO.3=1'
queue 'GETNEWS_AUTHO.3=1'
queue '# Add more ISP''s as desired.'
queue '#'
queue '# End of' ydparms_dat
RETURN        

/*
==============================================
copy_ydfiles()

Copy over files from the installation
directory to the home directory.  We expect to find the icon
files in a subdirectory (ICONS) but if you happened to use
PkWare unzip without the -d option they will not be
there so we will look for them in the installer's directory
also to avoid an abortable error.
==============================================
*/
copy_ydfiles:

/*
============================
Create minimum number of incoming subdirectories in the
home directory if not there already, and create an outgoing dir also.
============================
*/
call SysMkDir home || '\yarn'        /* of course this already exists */
call SysMkDir home || '\yarn\in'
call SysMkDir home || '\yarn\in\mail'
call SysMkDir home || '\yarn\in\news'
call SysMkDir home || '\yarn\out'


/* We need to create an ICONS subdirectory in our target
home directory as part of the installation */

call SysMkDir home || '\icons'

/* get down to filename only, strip and path, arguments */
yd_cmd = filespec('name', yd_cmd)
ydinstl_cmd = filespec('name', ydinstl_cmd)
yarn_ico = filespec('name', yarn_ico)
yd_doc = filespec('name', yd_doc)
readme_1st = filespec('name', readme_1st)
go_exe = filespec('name', go_exe)
yarn_ico = filespec('name', yarn_ico)
yarndial_ico = filespec('name', yarndial_ico)
ydfold1_ico = filespec('name', ydfold1_ico)
ydfold2_ico = filespec('name', ydfold2_ico)
yarnshell_ico = yarn_ico
yarnutil_ico = filespec('name', yarnutil_ico)
ydinstl_ico = filespec('name', ydinstl_ico)
logoff_ico = filespec('name', logoff_ico)
renewzip_ico = filespec('name', renewzip_ico)

/*
============================
First copy over icons. If they are not in an icons subdirectory
we look for them in the source directory.  And if they are only in
an icon subdirectory and the source_path is the same as home, we do
nothing as we can't copy something over onto itself

if we try a wildcard copy (copy *.ico) and there are no files to copy, we get an
error, so we need to have at least one file to copy.  Hence these awful multipart
conditionals
============================
*/

if home \= source_path then
   do
      if stream(source_path || '\icons\' || yarn_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || yarndial_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydfold1_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydfold2_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || yarnutil_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydinstl_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || renewzip_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || logoff_ico, 'c', 'query exists') \= '' then
        do
         say 'Copying icon files from' source_path || '\icons to' HOME || '\icons'
         'copy' source_path || '\icons\' || '*.ico' home || '\icons' 
        end
   end

if stream(source_path || '\' || yarn_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || yarndial_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydfold1_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydfold2_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || yarnutil_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydinstl_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || renewzip_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || logoff_ico, 'c', 'query exists') \= '' then
   do
      say 'Copying icon files from' source_path 'to' HOME || '\icons'
      'copy' source_path || '\' || '*.ico' home || '\icons' 
   end


  
/*
============================
Then copy remaining files to complete the installation.  Again, if we are already
installing to the home directory and source_path is the home directory instead of
some other (temporary) one, just exit the routine because files are already where we
want them
============================
*/

if home = source_path then
   do
      nop
   end

else
   do
      say 'Copying rest of files from' source_path 'to' HOME
      home_drive
      'cd' home

      if stream(source_path || '\' || yd_cmd, 'c', 'query exists') \= '' then
         do
        say 'Copying' yd_cmd
        'copy' source_path || '\' || yd_cmd || '>nul'
        if \SysSetIcon(yd_cmd, home || '\icons\' || yarndial_ico) then
         say 'unable to set icon for' yd_cmd '(NON-CRITICAL ERROR)'
         end

      if stream(source_path || '\' || ydinstl_cmd, 'c', 'query exists') \= ''  then
         do
        say 'Copying' ydinstl_cmd
        'copy' source_path || '\' || ydinstl_cmd || '>nul'
        if \SysSetIcon(ydinstl_cmd, home || '\icons\' || ydinstl_ico) then
         say 'unable to set icon for' ydinstl_cmd '(NON-CRITICAL ERROR)'         
         end

   if stream(source_path || '\' || yd_doc, 'c', 'query exists') \= '' then
         do
        say 'Copying' yd_doc
        'copy' source_path || '\' || yd_doc || '>nul'
         end

   if stream(source_path || '\' || readme_1st, 'c', 'query exists') \= '' then
         do
        say 'Copying' readme_1st
        'copy' source_path || '\' || readme_1st || '>nul'
         end

   if stream(source_path || '\' || go_exe, 'c', 'query exists') \= '' then
         do
        say 'Copying' go_exe
        'copy' source_path || '\' || go_exe || '>nul'
         end

end /* of else */

completed = 1
RETURN

/*
=======================================================
We create  a suite of small REXX programs and save them to the HOME
directory we are now installing to.  All of these will run with the OS/2
environment variable, HOME, set using SetLocal() to the unique home
directory chosen for this particular user installation.

First we create a program (YRNSHELL.CMD) which starts
yarn.exe for this particular user installation.
=======================================================
*/ 
create_yarnshell_cmd:
say 'Creating customized .CMD files for the' home 'directory'
home_drive
'cd' home

yarnshell_cmd = filespec('name', yarnshell_cmd)

call SysFileDelete yarnshell_cmd

/* Now create yarnshell_cmd as a .CMD file in the HOME directory */
do queued(); pull; end        /* First clear out any lines in rxqueue */ 

queue '/*' yarnshell_cmd
queue 'Program to start' yarn_exe
queue 'Created by YARNDIAL''s' ydinstl_cmd date() time()
queue 'Sets' HOME 'as the HOME env. variable,'
queue 'sets' yarn 'as the YARN env. variable, sets'
queue 'directory to' yarn 'and sets OS/2 window size.   */'
queue
queue 'x = SetLocal()'
queue '''@echo off'''
queue 'x = value(''home'', ''' || home || ''', ''OS2ENVIRONMENT'')'
queue 'x = value(''yarn'', ''' || yarn || ''', ''OS2ENVIRONMENT'')'
queue home_drive
queue '''cd' home || ''''
queue '''' || conmode || ''''
queue '''' || yarn_exe || ''''
queue 'x = EndLocal()'

line = ''
do queued()        /* output everything in rxqueue to file */
  parse pull line
  call lineout yarnshell_cmd, line
end

call stream yarnshell_cmd, 'c', 'close'
say '  ' yarnshell_cmd 'created/updated.'
if \SysSetIcon(yarnshell_cmd, home || '\icons\' || yarn_ico) then
   say 'unable to set icon for' yarnshell_cmd '(NON-CRITICAL ERROR)'
RETURN


/*
=======================================================
Create a program (YRNUTIL.CMD) to run yarn utilities for
this particular user installation.  It temporarily sets
a variable named home in the the OS/2 environment to the
home directory chosen for this particular user installation,
then prompts for the yarn utility to run, then runs it.
=======================================================
*/ 

create_yarnutil_cmd:
home_drive
'cd' home

yarnutil_cmd = filespec('name', yarnutil_cmd)

call SysFileDelete yarnutil_cmd

/* Now create yarnutil_cmd as a .CMD file in the HOME directory */
do queued(); pull; end        /* First clear out any lines in rxqueue */ 

queue '/* */'
queue 'say ''' || yarnutil_cmd || ''''
queue 'say ''Program to start a yarn executable.'''
queue 'say ''Sets' HOME 'as the HOME env. variable'''
queue 'say ''and sets' yarn 'as the YARN env. variable.'''
queue 'say ''Sets working directory to' yarn || ''''
queue 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || ''''
queue 'say '''''
queue '/* Load RexxUtil if not already loaded */'
queue 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then'
queue '   do'
queue '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs'''
queue '      call SysLoadFuncs'
queue '   end'
queue 'x = SetLocal()'
queue '''@echo off'''
queue 'x = value(''home'', ''' || home || ''', ''OS2ENVIRONMENT'')'
queue 'x = value(''yarn'', ''' || yarn || ''', ''OS2ENVIRONMENT'')'
queue yarn_drive
queue '''cd' yarn || ''''
queue 'say ''What yarn utility do you want to run?'''
queue 'prompt = ''Omit the path. Enter:'''
queue 'say prompt'
queue 'parse value SysCurPos() with row col'
queue 'row  = row - 1'
queue 'col = length(prompt) + 2'
queue 'call SysCurPos row, col'
queue 'parse pull yarn_utility'
queue 'yarn_utility'
queue 'x = EndLocal()'
queue 'say '''''
queue 'say ''Done.  Press any key to exit...'''        
queue 'answer = SysGetKey(''NOECHO'')'

line = ''
do queued()        /* output everything in rxqueue to file */
  parse pull line
  call lineout yarnutil_cmd, line
end

call stream yarnutil_cmd, 'c', 'close'
say '  ' yarnutil_cmd 'created/updated.'
if \SysSetIcon(yarnutil_cmd, home || '\icons\' || yarnutil_ico) then
   say 'unable to set icon for' yarnutil_cmd '(NON-CRITICAL ERROR)'
RETURN

/*
=======================================================
Create a logoff program (LOGOFF.CMD).  It determines if
any of the following are up and running, and if so, closes
them down: SLIP.EXE, PPP.EXE, DIALER.EXE, SLIPPM.EXE.
This will work in any environment but we place a copy
in each home directory we install to (convenient to do so).

I wanted something like this so if for some reason I was
logged on and wanted a sure-fire shut-down freeing up my
phone line, I could do it with one double-click.

This uses go.exe from GO_15.EXE.  go.exe is supplied with
this yarndial/installer package.
=======================================================
*/ 

create_logoff_cmd:
home_drive
'cd' home

logoff_cmd = filespec('name', logoff_cmd)

call SysFileDelete logoff_cmd

/* Now create logoff_cmd as a .CMD file in the HOME directory */
do queued(); pull; end        /* First clear out any lines in rxqueue */ 

queue '/* */'
queue 'say ''' || logoff_cmd || ''''
queue 'say ''Shutdown of IAK Dialer, SLIP, PPP, SLATTACH, SLIPPM, IN-JOY'''
queue 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || ''''
queue
queue 'say '''''
queue '/* --------  you can edit these 3 things -------- */'
queue 'go_exe = ''' || go_exe || '''        /* full path to GO_15''s GO.EXE */'
queue 'killjoy_exe = ''' || killjoy_exe || '''        /* full path to IN-JOY''s KILLJOY.EXE */'
queue 'settle_time = 10  /* seconds,  settle down before rechecking */'
queue
queue
queue '/* Load RexxUtil if not already loaded */'
queue 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then'
queue '   do'
queue '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs'''
queue '      call SysLoadFuncs'
queue '   end'
queue '''@echo off'''
queue 'call is_process_running ''DIALER'''
queue 'call is_process_running ''SLIP'''
queue 'call is_process_running ''PPP'''
queue 'call is_process_running ''SLATTACH'''
queue 'call is_process_running ''SLIPPM'''
queue 'call is_process_running ''ILINK2'''
queue
queue 'if ''' || alt_dialer || ''' \= ''DIALER'','
queue '   & ''' || alt_dialer || ''' \= ''SLIP'','
queue '   & ''' || alt_dialer || ''' \= ''PPP'','
queue '   & ''' || alt_dialer || ''' \= ''SLIPPM'','
queue '   & ''' || alt_dialer || ''' \= ''ILINK2'','
queue '   & ''' || alt_dialer || ''' \= ''IN-JOY'' then'
queue '   call is_process_running ''' || alt_dialer || ''''
queue 'if stream(''' || killjoy_exe || ''', ''c'', ''query exists'') \= '''' then'
queue '   do'
queue '      ''' || killjoy_exe || ''''
queue '      call SysSleep 3 /* settle time */'
queue '   end'
queue 'call is_process_running ''IN-JOY''' 
queue 'say ''Waiting'' settle_time ''secs. before testing them all again...'''
queue 'call SysSleep settle_time'
queue
queue 'call is_process_running ''DIALER'''
queue 'call is_process_running ''SLIP'''
queue 'call is_process_running ''PPP'''
queue 'call is_process_running ''SLATTACH'''
queue 'call is_process_running ''SLIPPM'''
queue 'call is_process_running ''ILINK2'''
queue
queue 'if ''' || alt_dialer || ''' \= ''DIALER'','
queue '   & ''' || alt_dialer || ''' \= ''SLIP'','
queue '   & ''' || alt_dialer || ''' \= ''PPP'','
queue '   & ''' || alt_dialer || ''' \= ''SLIPPM'','
queue '   & ''' || alt_dialer || ''' \= ''ILINK2'','
queue '   & ''' || alt_dialer || ''' \= ''IN-JOY'' then',
queue '   call is_process_running ''' || alt_dialer || ''''
queue 'if stream(''' || killjoy_exe || ''', ''c'', ''query exists'') \= '''' then'
queue '   do'
queue '      ''' || killjoy_exe || ''''
queue '      call SysSleep 3 /* settle time */'
queue '   end'
queue 'call is_process_running ''IN-JOY''' 
queue 'say ''Press any key to exit...'''        
queue 'answer = SysGetKey(''NOECHO'')'
queue 'EXIT'
queue
queue
queue 'is_process_running:'
queue 'parse upper arg process        /* Check if it is */'
queue 'go_exe ''-cp'' process ''>nul''        /* returns RC=1 if process is running, 0 if not */'
queue 'If RC then'
queue '   do'
queue '      say process ''is running'''
queue '      if process = ''DIALER'' then'
queue '         do'
queue '        process ''-c>nul'', /* hope it''s at least v 1.33 */'
queue '        call SysSleep 3 /* settle time, IAK Dialer is funny */'
queue '        say ''   If you lost this window for a few seconds or just heard a beep'''
queue '        say ''   that is normal for closing down certain versions of IAK Dialer'''
queue '         end'
queue '   end'
queue 'else say process ''is not running'''
queue 'go ''-ka'' process ''>nul''  /* do a kill whether running or not */'
queue 'RETURN'

line = ''
do queued()        /* output everything in rxqueue to file */
  parse pull line
  call lineout logoff_cmd, line
end

call stream logoff_cmd, 'c', 'close'
say '  ' logoff_cmd 'created/updated.'
if \SysSetIcon(logoff_cmd, home || '\icons\' || logoff_ico) then
   say 'unable to attach icon for' logoff_cmd '(NON-CRITICAL ERROR)'
RETURN


/*
=======================================================
Create a program (RENEWZIP.CMD) to rename to a .ZIP file
the reply_packet ZIP file for this user that we had backed
up as a *.BAK file when last we exported posts and mail.
If something went wrong with sending/posting, this
renewzip.cmd restores the .ZIP and allows us a second shot.
=======================================================
*/ 

create_renewzip_cmd:
home_drive
'cd' home
renewzip_cmd = filespec('name', renewzip_cmd)
parse var renewzip_cmd renewzip '.' ext
call SysFileDelete renewzip_cmd

reply_packet = translate(reply_packet)

parse var reply_packet reply '.' ext
reply_bak = reply || '.BAK'
reply_asterisk = reply || '.*'

/* Now create renewzip_cmd as a .CMD file in the HOME directory */
do queued(); pull; end        /* First clear out any lines in rxqueue */ 

queue '/* */'
queue 'say ''' || renewzip_cmd || ''''
queue 'say ''Restores' reply_packet 'by renaming the *.BAK to *.ZIP'''
queue 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || ''''
queue 'say ''DIR run below should confirm restoration of the *.ZIP'''
queue 'say '''''
queue '/* Load RexxUtil if not already loaded */'
queue 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then'
queue '   do'
queue '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs'''
queue '      call SysLoadFuncs'
queue '   end'
queue '''@echo off'''
queue 'if stream(''' || reply_bak || ''', ''c'', ''query exists'') \= '''' then'
queue '   do'
queue '      ''copy' reply_bak reply_packet || ''''
queue '      ''dir' reply_asterisk || ''''
queue '   end'
queue 'else say ''no' reply_bak 'to restore'''
queue 'say '''''
queue 'say ''Press any key to exit...'''        
queue 'answer = SysGetKey(''NOECHO'')'

line = ''
do queued()        /* output everything in rxqueue to file */
  parse pull line
  call lineout renewzip_cmd, line
end

call stream renewzip_cmd, 'c', 'close'
say '  ' renewzip_cmd 'created/updated.'
if \SysSetIcon(renewzip_cmd, home || '\icons\' || renewzip_ico) then
   say 'unable to attach icon for' renewzip_cmd '(NON-CRITICAL ERROR)'
RETURN
 
/*
==============================================
create_yarndial_objects()

Create a folder on the desktop uniquely named for
our user installation.  Into it place our objects also named
to identify them with the specific home directory for which
this installation was done.
==============================================
*/
create_yarndial_objects:

say 'Creating Desktop Folder object and its Program objects'

/* First create a Desktop Folder object for our YARNDIAL objects */

home = translate(home, Lowcase, Upcase)   /* to lower case */

classname = 'WPFolder'
folder_fore_title ='YarnDial Suite for' 
title = folder_fore_title || '^' || home
location = '<WP_DESKTOP>'
desktop_folder_object_id = '<' || title || '>'
iconfile = home || '\icons\' || ydfold1_ico        /* Animated folder icon (closed folder) */
iconnfile = home || '\icons\' || ydfold2_ico        /* Animated folder icon (open folder) */
startupdir = home
setup = 'OBJECTID=' || desktop_folder_object_id ||,
         ';ALWAYSSORT=YES' ||,
         ';ICONFILE=' || iconfile ||,
         ';ICONNFILE=1,' iconnfile

signal off error
if \SysCreateObject(classname, title, location, setup, 'U') then
   do
      say 'YARNDIAL FOLDER object creation unsuccessful'
      object_creation_error = 1
   end
else
  do
      say '   YARNDIAL FOLDER object created/updated successfully'

/* Folder created successfully? Then create all the program objects
and place them in the folder */

/* The desktop folder we just created is located at... */
location = desktop_folder_object_id   /* location for the rest is in the folder */

/* Create the object for YarnDial */
   classname = 'WPProgram'
   title = 'YarnDial for^' || home
   exename = home || '\' || yd_cmd
   iconfile = home || '\icons\' || yarndial_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
        ';ICONFILE=' || iconfile ||,
        ';EXENAME=' || exename ||,
        ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '   YARNDIAL object created/updated successfully'
      end
   else
      do
         say 'YARNDIAL object creation unsuccessful'
         object_creation_error = 1
      end

/* and then do all of this until the end of the subroutine... */

/* Create an object for yarnshell_cmd */
   title = 'YARN Program for^' || home 
   exename = home || '\' || yarnshell_cmd
   iconfile = home || '\icons\' || yarn_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
        ';ICONFILE=' || iconfile ||,
        ';EXENAME=' || exename ||,
        ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' YARNSHELL_CMD 'object created/updated successfully'
      end
   else
      do
         say 'YRNSHELL object creation unsuccessful'
         object_creation_error = 1
      end

/* Create an object for yarnutil_cmd */
   title = 'YarnUtil from^' || home
   exename = home || '\' || yarnutil_cmd
   iconfile = home || '\icons\' || yarnutil_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
        ';ICONFILE=' || iconfile ||,
        ';EXENAME=' || exename ||,
        ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' YARNUTIL_CMD 'object created/updated successfully'
      end
   else
      do
         say 'YRNUTIL object creation unsuccessful'
         object_creation_error = 1
      end

/* Create an object for logoff_cmd */
   title = 'Logoff running from^' || home
   exename = home || '\' || logoff_cmd
   iconfile = home || '\icons\' || logoff_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
        ';ICONFILE=' || iconfile ||,
        ';EXENAME=' || exename ||,
        ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' LOGOFF_CMD 'object created/updated successfully'
      end
   else
      do
         say 'LOGOFF object creation unsuccessful'
         object_creation_error = 1
     end

/* Create an object for renewzip_cmd */
   title = 'Reply Zip Restorer for^' || translate(reply_packet, Lowcase, Upcase) /* to lower case */ 
   exename = home || '\' || renewzip_cmd
   iconfile = home || '\icons\' || renewzip_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
        ';ICONFILE=' || iconfile ||,
        ';EXENAME=' || exename ||,
        ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' RENEWZIP_CMD 'object created/updated successfully'
      end
   else
      do
         say 'RENEWZIP object creation unsuccessful'
         object_creation_error = 1
      end
END        /* creating program objects in the Desktop Folder we created */
if local_error_trapping then signal on error
RETURN

/*
=======================================================
recreate_objects_cmd()
Create a program (OBJECTS.CMD) to to be able to recreate the
YarnDial Desktop folder and objects in it.
=======================================================
*/ 


recreate_objects_cmd:
/* Now create objects_cmd as a .CMD file in the HOME directory */
home_drive
'cd' home
call SysFileDelete objects_cmd
say 'Creating a program to be able to recreate the YarnDial'
say 'desktop folder for this installation, and all of its objects'

do queued(); pull; end        /* First clear out any lines in rxqueue */ 

queue '/*' || objects_cmd || '*/'
queue 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || ''''
queue
queue 'say ''Re-creates a Desktop Folder object and its Program objects'''
queue 'say ''for the user whose HOME directory is'' translate(''' || home || ''')'
queue 'say '''''
queue
queue '/* Load RexxUtil if not already loaded */'
queue 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then'
queue '   do'
queue '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs'''
queue '      call SysLoadFuncs'
queue '   end'
queue
queue 'say ''Press any key to continue.  CTRL-C quits.'''
queue 'answer = SysGetKey(''NOECHO'')'
queue
queue 'say '''''
queue
queue '/* First create a Desktop Folder object for our YARNDIAL objects */' 
queue 'Upcase = xrange(''A'', ''Z'')'
queue 'Lowcase = xrange(''a'', ''z'')'
queue
queue 'home = translate(''' || home || ''', Lowcase, Upcase)'
queue
queue 'classname = ''WPFolder'''
queue 'folder_fore_title =''YarnDial Suite for''' 
queue 'title = folder_fore_title || ''^'' || home'
queue 'location = ''<WP_DESKTOP>'''
queue 'desktop_folder_object_id = ''<'' || title || ''>'''
queue 'iconfile = home || ''\icons\' || ydfold1_ico || '''        /* Animated folder icon (closed folder) */'
queue 'iconnfile = home || ''\icons\' || ydfold2_ico || '''        /* Animated folder icon (open folder) */'
queue 'startupdir = home'
queue 'setup = ''OBJECTID='' || desktop_folder_object_id ||,'
queue '         '';ALWAYSSORT=YES'' ||,'
queue '         '';ICONFILE='' || iconfile ||,'
queue '         '';ICONNFILE=1,'' iconnfile'
queue
queue 'if \SysCreateObject(classname, title, location, setup, ''U'') then'
queue '   do'
queue '      say ''YARNDIAL FOLDER object creation unsuccessful'''
queue '   end'
queue 'else'
queue '   do'
queue '      say ''YARNDIAL FOLDER object created/updated successfully'''
queue
queue '/* Folder created successfully? Then create all the program objects'
queue 'and place them in the folder */'
queue
queue '/* The desktop folder we just created is located at... */'
queue 'location = desktop_folder_object_id    /* location for the rest is in the folder */'
queue
queue '/* Create the object for YarnDial */'
queue '   classname = ''WPProgram'''
queue '   title = ''YarnDial for^'' || home'
queue '   exename = home || ''\' || yd_cmd || ''''
queue '   iconfile = home || ''\icons\' || yarndial_ico || ''''
queue '   startupdir = home'
queue
queue '   setup = ''OBJECTID=<'' || title || ''>'' ||,'
queue '        '';ICONFILE='' || iconfile ||,'
queue '        '';EXENAME='' || exename ||,'
queue '        '';STARTUPDIR='' || startupdir'
queue
queue '   if SysCreateObject(classname, title, location, setup, ''U'') then'
queue '      do' 
queue '         say ''YARNDIAL object created/updated successfully'''
queue '      end'
queue '   else'
queue '      do'
queue '         say ''YARNDIAL object creation unsuccessful'''
queue '      end'
queue
queue '/* and then do all of this until the end of the subroutine... */'
queue
queue '/* Create an object for yarnshell_cmd */'
queue '   title = ''YARN Program for^'' || home' 
queue '   exename = home || ''\' || yarnshell_cmd || ''''
queue '   iconfile = home || ''\icons\' || yarn_ico || ''''
queue '   startupdir = home'
queue
queue '   setup = ''OBJECTID=<'' || title || ''>'' ||,'
queue '        '';ICONFILE='' || iconfile ||,'
queue '        '';EXENAME='' || exename ||,'
queue '        '';STARTUPDIR='' || startupdir'
queue
queue '   if SysCreateObject(classname, title, location, setup, ''U'') then'
queue '      do'
queue '         say YARNSHELL_CMD ''object created/updated successfully'''
queue '      end'
queue '   else'
queue '      do'
queue '         say ''YRNSHELL object creation unsuccessful'''
queue '      end'
queue
queue '/* Create an object for yarnutil_cmd */'
queue '   title = ''YarnUtil from^'' || home'
queue '   exename = home || ''\' || yarnutil_cmd || ''''
queue '   iconfile = home || ''\icons\' || yarnutil_ico || ''''
queue '   startupdir = home'
queue
queue '   setup = ''OBJECTID=<'' || title || ''>'' ||,'
queue '        '';ICONFILE='' || iconfile ||,'
queue '        '';EXENAME='' || exename ||,'
queue '        '';STARTUPDIR='' || startupdir'
queue
queue '   if SysCreateObject(classname, title, location, setup, ''U'') then'
queue '      do'
queue '         say YARNUTIL_CMD ''object created/updated successfully'''
queue '      end'
queue '   else'
queue '      do'
queue '         say ''YRNUTIL object creation unsuccessful'''
queue '      end'
queue
queue '/* Create an object for logoff_cmd */'
queue '   title = ''Logoff running from^'' || home'
queue '   exename = home || ''\' || logoff_cmd || ''''
queue '   iconfile = home || ''\icons\' || logoff_ico || ''''
queue '   startupdir = home'
queue
queue '   setup = ''OBJECTID=<'' || title || ''>'' ||,'
queue '        '';ICONFILE='' || iconfile ||,'
queue '        '';EXENAME='' || exename ||,'
queue '        '';STARTUPDIR='' || startupdir'
queue
queue '   if SysCreateObject(classname, title, location, setup, ''U'') then'
queue '      do'
queue '         say LOGOFF_CMD ''object created/updated successfully'''
queue '      end'
queue '   else'
queue '      do'
queue '         say ''LOGOFF object creation unsuccessful'''
queue '     end'
queue
queue '/* Create an object for renewzip_cmd */'
queue '   title = ''Reply Zip Restorer for^'' || translate(''' || reply_packet || ''', Lowcase, Upcase) /* to lower case */' 
queue '   exename = home || ''\' || renewzip_cmd || ''''
queue '   iconfile = home || ''\icons\' || renewzip_ico || ''''
queue '   startupdir = home'
queue
queue '   setup = ''OBJECTID=<'' || title || ''>'' ||,'
queue '        '';ICONFILE='' || iconfile ||,'
queue '        '';EXENAME='' || exename ||,'
queue '        '';STARTUPDIR='' || startupdir'
queue
queue '   if SysCreateObject(classname, title, location, setup, ''U'') then'
queue '      do'
queue '         say RENEWZIP_CMD ''object created/updated successfully'''
queue '      end'
queue '   else'
queue '      do'
queue '         say ''RENEWZIP object creation unsuccessful'''
queue '      end'
queue 'END  /* creating program objects in the Desktop Folder we created */ ' 
queue 'say '''''
queue 'say ''Press any key to exit...'''        
queue 'answer = SysGetKey(''NOECHO'')'

line = ''
do queued()        /* output everything in rxqueue to file */
  parse pull line
  call lineout objects_cmd, line
end

call stream objects_cmd, 'c', 'close'
say '  ' objects_cmd 'created/updated successfully.'

RETURN

/*
=================
encry()

called by command line
        YDINSTL encrypt someword
where someword is encrypted
=================
*/
encry:
o21 = '&\<=>|()! *+"''-/,#$%.0123456789:;?'
o22 = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^'
o23 = '_`abcdefghijklmnopqrstuvwxyz{}~'
e21 = '&\<=>|()u *+"''-/,MI$kUHgW[_A5%w~Fh'
e22 = 't?K^l0jJP{98xBadb1nZimRyY]4}`o'
e23 = 'E;67V@vS:C.sNGzcefQpqTr!2#XDLO3'

candidate = translate(candidate, o21||o22||o23, e21||e22||e23)

if encrypt then
do
   say ''
   our_dir = directory()        /* Where we are executing this pgm from */
   leng = length(candidate)
   call SysFileDelete our_dir || '\word.$$$'
   DL1 = 'encrypted=' || candidate,
   || crlf || 'Encrypted text is the' leng 'character string to the',
   || crlf || 'right of the FIRST equals sign in encrypted=' || crlf,
   || crlf || 'Be careful to select only those those' leng 'characters.',
   || crlf || 'for cutting-and-pasting.' || crlf
   DL2 = 'Do not be concerned if there is more than one equals',
   || crlf || 'sign, since characters may have been legitimately',
   || crlf || 'encoded to equals signs.',
   || crlf || '',
   || crlf || 'Remember to Erase' our_dir || '\word.$$$ when done.' 
   say DL1
   say 'That line is also stored as ASCII text in'
   say our_dir || '\word.$$$ for cutting-and-pasting.'
   say ''
   say DL2
   call lineout our_dir || '\word.$$$', DL1
   call lineout our_dir || '\word.$$$', DL2
   call stream our_dir || '\word.$$$', 'c', 'close'
   RETURN
end



/*
==============================================
HANDLING OF ERROR TRAPS

ReXX Errors (failure, halt, syntax, novalue, error)
that occur with SIGNAL ON XXXXX (XXXXX = failure,
halt, etc.) are diverted (jump) to one of these
where the error and the offending line are identified.
==============================================
*/

   FAILURE:
   say 'Rexx FAILURE condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN


   HALT:
   say 'Rexx HALT condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN


   SYNTAX:
   say 'Rexx SYNTAX error' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN


   NOTREADY:
   say 'Rexx NOTREADY condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN


   ERROR:
   say 'Rexx ERROR condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN


   NOVALUE:
   say 'Rexx NOVALUE condition' rc 'in line' sigl ':' errortext(rc)
   say sourceline(sigl)

   call beep 300, 500
   signal goodbye
   RETURN

/*
==============================================
GOODBYE()

Final "we did it" or "we didn't" message, and exit
==============================================
*/
GOODBYE:
say ''
if completed & findfile_ErrNum = 0 then
   do
      say 'Installation completed successfully'
      if object_creation_error then
         do
        say 'EXCEPT for desktop object creation.  All .CMD files'
        say 'are in the' home 'directory, though.'
         end
   end
if completed & findfile_ErrNum > 0 then
   do
      call SysCls
      say 'Installation completed.'
   end
if \completed | findfile_ErrNum > 0 | other_err then
   do
      say ''
      say '*************'
      say '   WARNING:'
      say 'An error was encountered during the installation'
      say '   or'
      say 'the installation was aborted before completion'
      say '*************'
      say ''
      call beep 262, 200
   end 

if completed then
   do
      say 'You may want to print out and inspect' ydparms_dat
      say 'Changes to it may be made using an ASCII editor such as the'
      say 'OS/2 System Editor without having to re-run' ydinstl_cmd
      say ''
   end

if findfile_ErrNum > 0 then
   do
      if findfile_ErrNum > 0 then
         do
        say 'ERROR(S):'
        do while findfile_ErrNum > 0
         say 'Unable to locate any instance of',  
         unfound_file.findfile_ErrNum
         findfile_ErrNum = findfile_ErrNum - 1
        end
         end
   end
say ''
say ijparms_errmsg1
say ijparms_errmsg2

say edit_dialup_string_msg
say 'YarnDial installation over at' time()
time = time('E')
time = time/60
time = format(time, ,1) 
say 'Elapsed time:' time 'minutes.'
say 'Press any key to exit...'
answer = SysGetKey('NOECHO')
call SysDropFuncs
x = endLocal()
EXIT
RETURN

/*
==============================================
welcome_to_this_installer()

Long welcome message.  Put here for a neater
program, though we call to it near startup.
==============================================
*/
welcome_to_this_installer:
call SysCls
say ''
say 'Welcome! YARNDIAL installer, v.' version 'of' translate(ydinstl_cmd)
say '(c) 1996 Jerry Levy, Marblehead, MA USA (all rights reserved).'
say ''
say 'ABOUT THIS INSTALLER'
say 'This will install YarnDial on your machine, copying files to the'
say 'Yarn Home directory.  It should be very straightforward to use if'
say 'you have Yarn and Souper already up and running and did a pretty'
say 'much by-the-book installation of them.'
say ''
say 'If you have more than one Yarn home directory (Yarn allows separate'
say 'home directories for separate users or providers), you can select a'
say 'default or specify which one(s) to install to.'
say ''
say 'The installer creates a unique' translate(ydparms_dat) 'data file and a suite'
say 'of customized Rexx .CMD programs, all of which get stored in the'
say 'particular home directory you are installing to.  A YarnDial'
say 'Desktop Folder is created to house program objects.'
say ''
say translate(ydparms_dat) 'can be edited after the installation.'
say ''
say '(Continued -- Press any key)'
call SysGetKey 'NOECHO'
call SysCls
say ''
say 'INSTRUCTIONS (cont''d)'
say 'You will be asked what kind of zip and unzip utilities you are using.'
say 'Read' yd_doc 'if you need help.'
say ''
say 'No changes are made to your system until the very end of the'
say 'installation, so you may run through it without risk and escape out'
say 'before the end.'
say ''
say ''
say '' 
say 'Press any key to continue the installation (ESC quits)'
if SysGetKey('NOECHO') = Escape then signal goodbye
RETURN

/*
==============================================
initialize_variables():

We make an early call to this to initialize
variables.  A long list so we put the routine
at the end of the program for neatness sake.
==============================================
*/
initialize_variables:
/* Default filenames and other stuff we need.

These are initialized to something because we want default values */
yarn_exe = 'YARN.EXE'
import_exe = 'IMPORT.EXE'
export_exe = 'EXPORT.EXE'
expire_exe = 'EXPIRE.EXE'
rebuild_exe = 'REBUILD.EXE'
filter_exe = 'FILTER.EXE'
souper_exe = 'SOUPER.EXE'
vsoup_exe = 'VSOUP.EXE'
yarnshell_cmd = 'YRNSHELL.CMD'
yarnutil_cmd = 'YRNUTIL.CMD'
renewzip_cmd = 'RENEWZIP.CMD'
objects_cmd = 'OBJECTS.CMD'
logoff_cmd = 'LOGOFF.CMD'
go_exe = 'GO.EXE'
IAKdialer_exe = 'DIALER.EXE'
slippm_exe = 'SLIPPM.EXE'
ilink2_exe = 'ILINK2.EXE'
injoy_exe = 'IN-JOY.EXE'
killjoy_exe = 'KILLJOY.EXE'
hosts_dat = 'HOSTS.DAT'
alt_dialer_exe = SLIPPM_EXE
os2_zip_exe = 'ZIP.EXE'
os2_unzip_exe = 'UNZIP.EXE'
vsoup = 0
os2_zip_options = '-0m'
os2_unzip_options = '-o'
msdos_zip_exe = 'PKZIP.EXE'
msdos_unzip_exe = 'PKUNZIP.EXE'
msdos_zip_options = '-m -u -o'
msdos_unzip_options = '-o'
msdos_cmd_interp = 'CMD.EXE /C'
souper_getmail_std_options = '-i -n'
souper_getmail_xtra_options = '' 
souper_getnews_std_options = '-i -m' 
souper_getnews_xtra_options = '' 
souper_send_std_options = '-i -s'
souper_send_xtra_options = ''
vsoup_getmail_std_options = '-i -n'
vsoup_getmail_xtra_options = '' 
vsoup_getnews_std_options = '-i -m' 
vsoup_getnews_xtra_options = '' 
vsoup_send_std_options = '-i -s'
vsoup_send_xtra_options = ''


/*
===============
We set most of these remaining variables initially to a blank.
Some settings will be revised in the course of the installation.
We do not want the yarndial data file we create
(YD_PARMS.DAT) to be all cluttered up with error
indications which is what happens if we don't assign
the blanks.
===============
*/
HOME = ''
YARN = ''
connection_type = ''
interface_removal = 0
choose = ''
user = ''
host = ''
account=''
ASK = ''
IS1 = ''
IS2 = ''
RS1 = ''
RS2 = ''
FS1 = ''
FS2 = ''
PIN = ''
wait = '' 
zip_exe = ''
unzip_exe = ''
host_app = ''
dialup_string = ''
do_not_kill = 0
dnk_string = '1234567'
Use_dialup_string = 'NO'
PROVIDER = ''
LOGIN_ID = ''
PWD = ''
SAVE_PWD = ''
PHONE_NUMBER = ''
HANGUP =  ''
SCRIPT = ''
SERVICE = ''
YOURIP = ''
DESTIP = ''
NETMASK = ''
MTU_SIZE = ''
VJ_COMP = ''
PRIMARY_INF = ''
HOSTNAME = ''
DOMAIN_NAME = ''
DNS = ''
DNS2 = ''
DEFAULT_NEWS = ''
DEFAULT_WWW = ''
DEFAULT_GOPHER = ''
MAIL_GW = ''
POPSRVR = ''
REPLY_DOMAIN = ''
REPLY_ID = ''
POP_ID = ''
POP_PWD = ''
MODEM_TYPE = ''
COMPORT = ''
BAUD = ''
DATABITS = ''
PARITY =  ''
DIAL_MODE = ''
PREFIX = ''
PREFIX_ANS = ''
INIT = ''
INIT2 = ''
DISABLE = ''
DISABLE_SEQ = ''
DIAL_PREFIX = ''
AUTOSTART = ''
TOTAL_CONNECT = ''

RETURN



