// ---------------------------------------------------------------------------
//	Scheduling class
//	Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: schedule.h,v 1.9 1999/07/04 08:47:37 cisc Exp $

#ifndef common_schedule_h
#define common_schedule_h

#include "device.h"

class Scheduler
{
public:
	struct Event
	{
		int count;			// Ԏc
		Device* inst;
		Device::TimeFunc func;
		int arg;
		int time;			// 
	};

public:
	Scheduler();
	virtual ~Scheduler();

	bool Init(int maxevents = 16);
	int Proceed(int ticks);

	Event* AddEvent(int count, Device* dev, Device::TimeFunc func, int arg=0, bool repeat=false);
	void SetEvent(Event* ev, int count, Device* dev, Device::TimeFunc func, int arg=0, bool repeat=false);
	bool DelEvent(Device* dev);
	bool DelEvent(Event* ev);

	int GetTime();

private:
	virtual int Execute(int ticks) = 0;
	virtual void Shorten(int ticks) = 0;
	virtual int GetTicks() = 0;

private:
	
	Event* events;
	int evmax;
	int evlast;
	int time;		// ?
	int etime;		// ?
	bool executing;
};

inline int Scheduler::GetTime()
{
	return time + GetTicks();
}


#endif // common_schedule_h
