// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: WinJoy.cpp,v 1.2 1999/04/07 13:44:40 cisc Exp $

// #define  DIRECTINPUT_VERSION     0x0300

#include "headers.h"
#include "WinJoy.h"
#include "pc88/config.h"
#include "status.h"

using namespace PC8801;

#ifdef __OS2__
/* Ƃ肠K */
#define JOY_BUTTON1 (1UL << 0)
#define JOY_BUTTON2 (1UL << 1)
#define JOY_BUTTON3 (1UL << 2)
#define JOY_BUTTON4 (1UL << 3)
#endif

// ---------------------------------------------------------------------------
//  \z/
//
WinJoyPad::WinJoyPad()
: Device(0)
{
    enabled = false;
    button1 = JOY_BUTTON1 | JOY_BUTTON3;
    button2 = JOY_BUTTON2 | JOY_BUTTON4;
}

WinJoyPad::~WinJoyPad()
{

}

// ---------------------------------------------------------------------------
//  
//
#ifdef __OS2__
bool WinJoyPad::Init()
{
    paravalid = false;
    enabled = false;
    return false;
}
#else
bool WinJoyPad::Init()
{
    paravalid = false;
    enabled = false;
    if (!joyGetNumDevs())
    {
        statusdisplay.Show(70, 3000, "WCXeBbN API gpł܂");
        return false;
    }

    JOYINFO joyinfo;
    if (joyGetPos(JOYSTICKID1, &joyinfo) == JOYERR_UNPLUGGED)
    {
        statusdisplay.Show(70, 3000, "WCXeBbNڑĂ܂");
        return false;
    }
    enabled = true;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  
//
uint WinJoyPad::GetDirection(uint)
{
    if (!paravalid)
        Update();
    return data[0];
}

uint WinJoyPad::GetButton(uint)
{
    if (!paravalid)
        Update();
    return data[1];
}

// ---------------------------------------------------------------------------
//  WCXeBbN̏ԂXV
//
#ifdef __OS2__
void WinJoyPad::Update()
{
    data[0] = data[1] = 0xff;
    paravalid = true;
}
#else
void WinJoyPad::Update()
{
    const int threshold = 16384;
    JOYINFO joyinfo;
    if (enabled && joyGetPos(JOYSTICKID1, &joyinfo) == JOYERR_NOERROR)
    {
        data[0] =  (joyinfo.wYpos < (32768-threshold) ? 0 : 1)  // U
                 | (joyinfo.wYpos > (32768+threshold) ? 0 : 2)  // D
                 | (joyinfo.wXpos < (32768-threshold) ? 0 : 4)  // L
                 | (joyinfo.wXpos > (32768+threshold) ? 0 : 8)  // R
                 | 0xf0;
        data[1] =  (joyinfo.wButtons & button1 ? 0 : 1)
                 | (joyinfo.wButtons & button2 ? 0 : 2)
                 | 0xfc;
    }
    else
        data[0] = data[1] = 0xff;
    paravalid = true;
}
#endif

// ---------------------------------------------------------------------------
//  VSync ݂
//
void WinJoyPad::VSync(uint, uint d)
{
    if (d)
        paravalid = false;
}

// ---------------------------------------------------------------------------
//  RtBM[VXV
//
void WinJoyPad::ApplyConfig(const Config* config)
{
    if (config->flags & Config::swappadbuttons)
    {
        button1 = JOY_BUTTON2 | JOY_BUTTON4;
        button2 = JOY_BUTTON1 | JOY_BUTTON3;
    }
    else
    {
        button1 = JOY_BUTTON1 | JOY_BUTTON3;
        button2 = JOY_BUTTON2 | JOY_BUTTON4;
    }
}

// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor WinJoyPad::descriptor = { indef, outdef };

const Device::OutFuncPtr WinJoyPad::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (VSync),
#else
    (Device::OutFuncPtr) (VSync),
#endif
};

const Device::InFuncPtr WinJoyPad::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (GetDirection),
    static_cast<InFuncPtr> (GetButton),
#else
    (Device::InFuncPtr) (GetDirection),
    (Device::InFuncPtr) (GetButton),
#endif
};

