// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: main.cpp,v 1.2 1999/04/06 06:12:36 cisc Exp $

#include "headers.h"
#include "ui.h"

// ---------------------------------------------------------------------------

char m88dir[_MAX_PATH];
char m88ini[_MAX_PATH];

// ---------------------------------------------------------------------------
//  InitPathInfo
//
#ifdef __OS2__
static void InitPathInfo()
{
    getcwd( m88dir, _MAX_PATH );    /* JgpX擾 */
    strcat(m88dir, "\\");

    strcpy(m88ini, m88dir);
    strcat(m88ini, "M88.ini");
}
#else
static void InitPathInfo()
{
    char buf[_MAX_PATH];
    GetModuleFileName(0, buf, _MAX_PATH);

    LPTSTR filepart;
    GetFullPathName(buf, _MAX_PATH, m88dir, &filepart);
    *filepart = 0;

    strcpy(m88ini, m88dir);
    strcat(m88ini, "M88.ini");
}
#endif

// ---------------------------------------------------------------------------
//  WinMain
//
#ifdef __OS2__
INT main(INT argc, CHAR *argv[])
{
    InitPathInfo();
    WinUI ui;
    if (!ui.InitWindow())
        return -1;

    /* R}hC̉ */
    static char cmdline[512];
    cmdline[0] = 0;
    while(--argc > 0) {
        /* Pɂ */
        strcat( cmdline, *++argv );
        strcat( cmdline, " " );
    }

    return ui.Main(cmdline);
}
#else
int WINAPI WinMain(HINSTANCE hinst, HINSTANCE, LPSTR cmdline, int nwinmode)
{
    InitPathInfo();
    InitCommonControls();

    WinUI ui(hinst);
    if (!ui.InitWindow(nwinmode))
        return -1;

    return ui.Main(cmdline);
}
#endif
