// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  DirectSound based driver
// ---------------------------------------------------------------------------
//  $Id: soundds.cpp,v 1.1 1999/06/30 14:07:03 cisc Exp $

#include "headers.h"
#include "soundds.h"

//#define LOGNAME "soundds"
#include "diag.h"

using namespace WinSoundDriver;

#ifdef __OS2__
#define MAX_BUFFER_NUMBER (4)
DriverDS *aaaaa;
MCI_MIX_BUFFER     MixBuffers[MAX_BUFFER_NUMBER];
MCI_MIXSETUP_PARMS MixSetupParms;             /* Mixer parameters        */
MCI_BUFFER_PARMS   BufferParms;               /* Device buffer parms     */
USHORT usDartDeviceID;
#endif

// ---------------------------------------------------------------------------

const uint DriverDS::num_blocks = 8;
const uint DriverDS::timer_resolution = 20;

// ---------------------------------------------------------------------------
//  \zEj ---------------------------------------------------------------

DriverDS::DriverDS()
{
    playing = false;
    mixalways = false;
#ifndef __OS2__
    lpds = 0;
    lpdsb = 0;
    lpdsb_primary = 0;
#else
    aaaaa = this;
#endif
    timerid = 0;
    sending = false;
}

DriverDS::~DriverDS()
{
    Cleanup();
}

// ---------------------------------------------------------------------------
//   -------------------------------------------------------------------

#ifdef __OS2__
bool DriverDS::Init(SoundBuffer* s, HWND hwnd, uint rate, uint ch, uint buflen)
{
    if (playing)
        return false;
    src = s;
    buffer_length = buflen;
    sampleshift = 1 + (ch == 2 ? 1 : 0);

    // vZ
    buffersize = (rate * ch * sizeof(Sample) * buffer_length / 1000) & ~7;


    MCI_AMP_OPEN_PARMS AmpOpenParms;
    MCI_GENERIC_PARMS  GenericParms;
    register ULONG ulIndex;

    memset( &AmpOpenParms, 0, sizeof(MCI_AMP_OPEN_PARMS) );
    AmpOpenParms.usDeviceID    = 0; /* ftHg̃TEhfoCXI */
    AmpOpenParms.pszDeviceType = (PSZ)MCI_DEVTYPE_AUDIO_AMPMIX;
//    if(mciSendCommand( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_TYPE_ID | MCI_OPEN_SHAREABLE, (PVOID)&AmpOpenParms, 0 )) {
    if(mciSendCommand( 0, MCI_OPEN, MCI_WAIT | MCI_OPEN_TYPE_ID, (PVOID)&AmpOpenParms, 0 )) {
        return FALSE;
    }
    usDartDeviceID = AmpOpenParms.usDeviceID;

    memset( &MixSetupParms, 0, sizeof(MCI_MIXSETUP_PARMS) );
    MixSetupParms.ulSamplesPerSec = rate;
    MixSetupParms.ulBitsPerSample = 16;
    MixSetupParms.ulChannels      = ch;
    MixSetupParms.ulFormatTag     = MCI_WAVE_FORMAT_PCM;
    MixSetupParms.ulFormatMode    = MCI_PLAY;
    MixSetupParms.ulDeviceType    = MCI_DEVTYPE_WAVEFORM_AUDIO;
    MixSetupParms.pmixEvent       = DriverDS::TimeProc;

    if(mciSendCommand( usDartDeviceID, MCI_MIXSETUP, MCI_WAIT | MCI_MIXSETUP_INIT, (PVOID)&MixSetupParms, 0 )) {
        mciSendCommand( usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
        return FALSE;
    }

    memset( &BufferParms, 0, sizeof(MCI_BUFFER_PARMS) );
    BufferParms.ulStructLength = sizeof(BufferParms);
    BufferParms.ulNumBuffers = MAX_BUFFER_NUMBER;
    BufferParms.ulBufferSize = buffersize / num_blocks;

    BufferParms.pBufList     = MixBuffers;
    if(mciSendCommand( usDartDeviceID, MCI_BUFFER, MCI_WAIT | MCI_ALLOCATE_MEMORY, (PVOID)&BufferParms, 0 ))
    {
        mciSendCommand( usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
        return FALSE;
    }

    for(ulIndex = 0; ulIndex < BufferParms.ulNumBuffers; ulIndex++)
    {
        memset( MixBuffers[ulIndex].pBuffer, 0, MixBuffers[ulIndex].ulBufferLength );
        MixBuffers[ulIndex].ulFlags    = 0;
        MixBuffers[ulIndex].ulUserParm = 0;
    }

    MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle, MixBuffers, BufferParms.ulNumBuffers );

    playing = true;

    return playing;
}
#else
bool DriverDS::Init(SoundBuffer* s, HWND hwnd, uint rate, uint ch, uint buflen)
{
    if (playing)
        return false;
    src = s;
    buffer_length = buflen;
    sampleshift = 1 + (ch == 2 ? 1 : 0);

    // vZ
    buffersize = (rate * ch * sizeof(Sample) * buffer_length / 1000) & ~7;

    // DirectSound object 쐬
    if (DS_OK != DirectSoundCreate(NULL, &lpds, 0))
        return false;

    // xݒ
    if (DS_OK != lpds->SetCooperativeLevel(hwnd, DSSCL_PRIORITY))
    {
        if (DS_OK != lpds->SetCooperativeLevel(hwnd, DSSCL_NORMAL))
            return false;
    }

    DSBUFFERDESC dsbd;
    memset(&dsbd, 0, sizeof(DSBUFFERDESC));
    dsbd.dwSize = sizeof(DSBUFFERDESC);
    dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;
    dsbd.dwBufferBytes = 0;
    dsbd.lpwfxFormat = 0;
    if (DS_OK != lpds->CreateSoundBuffer(&dsbd, &lpdsb_primary, 0))
        return false;

    // ĐtH[}bgݒ
    WAVEFORMATEX wf;
    memset(&wf, 0, sizeof(WAVEFORMATEX));
    wf.wFormatTag = WAVE_FORMAT_PCM;
    wf.nChannels = ch;
    wf.nSamplesPerSec = rate;
    wf.wBitsPerSample = 16;
    wf.nBlockAlign = wf.nChannels * wf.wBitsPerSample / 8;
    wf.nAvgBytesPerSec = wf.nSamplesPerSec * wf.nBlockAlign;

    lpdsb_primary->SetFormat(&wf);

    // ZJ_obt@쐬
    memset(&dsbd, 0, sizeof(DSBUFFERDESC));
    dsbd.dwSize = sizeof(DSBUFFERDESC);
    dsbd.dwFlags = DSBCAPS_CTRLDEFAULT | DSBCAPS_STICKYFOCUS | DSBCAPS_GETCURRENTPOSITION2;

    dsbd.dwBufferBytes = buffersize;
    dsbd.lpwfxFormat = &wf;

    HRESULT res = lpds->CreateSoundBuffer(&dsbd, &lpdsb, NULL);
    if (DS_OK != res)
        return false;

    // Đ
    lpdsb->Play(0, 0, DSBPLAY_LOOPING);
//  lpdsb_primary->Play(0, 0, DSBPLAY_LOOPING);

    // ^C}[쐬
    timeBeginPeriod(buffer_length / num_blocks);
    timerid = timeSetEvent(buffer_length / num_blocks, timer_resolution,
        TimeProc, reinterpret_cast<DWORD> (this), TIME_PERIODIC);
    nextwrite = 1 << sampleshift;

    if (!timerid)
    {
        timeEndPeriod(buffer_length / num_blocks);
        return false;
    }

    playing = true;
    return true;
}
#endif

// ---------------------------------------------------------------------------
//  Еt -----------------------------------------------------------------

bool DriverDS::Cleanup()
{
    playing = false;
#ifdef __OS2__
    MCI_GENERIC_PARMS GenericParms;

    mciSendCommand( usDartDeviceID, MCI_CLOSE, MCI_WAIT, (PVOID)&GenericParms, 0 );
#else
    if (timerid)
    {
        timeKillEvent(timerid);
        timeEndPeriod(buffer_length / num_blocks);
        timerid = 0;
    }
    if (lpdsb)
    {
        lpdsb->Stop();
        lpdsb->Release(), lpdsb = 0;
    }
    if (lpdsb_primary)
        lpdsb_primary->Release(), lpdsb_primary = 0;
    if (lpds)
        lpds->Release(), lpds = 0;
#endif
    return true;
}

// ---------------------------------------------------------------------------
//  TimeProc  ----------------------------------------------------------------

#ifdef __OS2__
static LONG APIENTRY DriverDS::TimeProc(ULONG ulStatus, PMCI_MIX_BUFFER pBuffer, ULONG  ulFlags)
{
    DosEnterCritSec(); {
        DriverDS* inst = aaaaa;
        if (inst)
        {
            switch( ulFlags )
            {
                case MIX_WRITE_COMPLETE:
                    inst->Send( pBuffer->ulBufferLength, (VOID *)pBuffer->pBuffer );
                    MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle, pBuffer, 1 );
                    break;
               case MIX_STREAM_ERROR | MIX_READ_COMPLETE :  /* error occur in device */
               case MIX_STREAM_ERROR | MIX_WRITE_COMPLETE:  /* error occur in device */
                  if ( ulStatus == ERROR_DEVICE_UNDERRUN) {
                    MixSetupParms.pmixWrite( MixSetupParms.ulMixHandle, pBuffer, 1 );
                  }
                defalut:
                    break;
            }
        }
    } DosExitCritSec();
    return TRUE;
}
#endif

// ---------------------------------------------------------------------------
//  ubN -------------------------------------------------------------

void DriverDS::Send(ULONG ulSize, VOID *pv)
{
#ifdef __OS2__
    if (playing && !sending) {
        // 
        if(!src->IsEmpty()) {
            src->Get((Sample*) pv, ulSize >> sampleshift );
        }
    }
#else
    if (playing && !InterlockedExchange(&sending, true))
    {
        bool restored = false;

        // Buffer Lost ?
        DWORD status;
        lpdsb->GetStatus(&status);
        if (DSBSTATUS_BUFFERLOST & status)
        {
            // restore the buffer
//          lpdsb_primary->Restore();
            if (DS_OK != lpdsb->Restore())
                goto ret;
            nextwrite = 0;
            restored = true;
        }

        // ʒu擾
        DWORD cplay, cwrite;
        lpdsb->GetCurrentPosition(&cplay, &cwrite);

        if (cplay == nextwrite && !restored)
            goto ret;

        // ݃TCYvZ
        int writelength;
        if (cplay < nextwrite)
            writelength = cplay + buffersize - nextwrite;
        else
            writelength = cplay - nextwrite;

        writelength &= -1 << sampleshift;

        if (writelength <= 0)
            goto ret;

        LOG3("play = %5d  write = %5d  length = %5d\n", cplay, nextwrite, writelength);
        {
            void* a1, * a2;
            DWORD al1, al2;
            // Lock
            if (DS_OK != lpdsb->Lock(nextwrite, writelength,
                                     (void**) &a1, &al1, (void**) &a2, &al2, 0))
                goto ret;

            // 

            if (mixalways || !src->IsEmpty())
            {
                if (a1)
                    src->Get((Sample*) a1, al1 >> sampleshift);
                if (a2)
                    src->Get((Sample*) a2, al2 >> sampleshift);
            }

            // Unlock
            lpdsb->Unlock(a1, al1, a2, al2);
        }

        nextwrite += writelength;
        if (nextwrite >= buffersize)
            nextwrite -= buffersize;

        if (restored)
            lpdsb->Play(0, 0, DSBPLAY_LOOPING);

        // I
ret:
        InterlockedExchange(&sending, false);
    }
    return;
#endif
}
