// ---------------------------------------------------------------------------
//  M88 - PC-8801 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  $Id: soundmon.h,v 1.6 1999/06/28 12:08:56 cisc Exp $

#if !defined(win32_soundmon_h)
#define win32_soundmon_h

#include "device.h"
#include "instthnk.h"

// ---------------------------------------------------------------------------

class OPNMonitor
{
public:
    OPNMonitor();
    ~OPNMonitor();

    bool Init(const uint8* reg);
#ifdef __OS2__
    void Show(HWND, bool show);
#else
    void Show(HINSTANCE, HWND, bool show);
#endif
    bool IsOpen() { return !!hwnd; }

private:
    enum
    {
        bkcol = 0x400000,
    };

#ifdef __OS2__
#else
    BOOL DlgProc(HWND, UINT, WPARAM, LPARAM);
    static BOOL _cdecl DlgProcGate(OPNMonitor*, HWND, UINT, WPARAM, LPARAM);
#endif
    void Paint(HWND);
    void Draw(HWND, HDC);
    void DrawMain(HDC);
    void PutLine(const char*, ...);
    void Update();

#ifdef __OS2__
#else
    InstanceThunk dlgproc;
#endif
    HWND hwnd;
    const uint8* regs;

    HDC hdc;
    int y;
    int fontheight;
    int w, h;
};

#endif // !defined(win32_soundmon_h)
