// ---------------------------------------------------------------------------
//  M88 - PC-88 Emulator
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  waveOut based driver
// ---------------------------------------------------------------------------
//  $Id: soundwo.h,v 1.4 1999/07/11 05:30:06 cisc Exp $

#if !defined(win32_soundwo_h)
#define win32_soundwo_h

#include "sounddrv.h"
#include "critsect.h"

// ---------------------------------------------------------------------------

namespace WinSoundDriver
{

class DriverWO : public Driver
{
public:
    DriverWO();
    ~DriverWO();

    bool Init(SoundBuffer* sb, HWND hwnd, uint rate, uint ch, uint buflen);
    bool Cleanup();

private:
    bool SendBlock(WAVEHDR*);
    void BlockDone(WAVEHDR*);
#ifdef __OS2__
#else
    static uint __stdcall ThreadEntry(LPVOID arg);
    static void CALLBACK WOProc(HWAVEOUT hwo, uint umsg, DWORD inst, DWORD p1, DWORD p2);
#endif
    void DeleteBuffers();

#ifdef __OS2__
#else
    HWAVEOUT hwo;
    HANDLE hthread;
#endif
    uint idthread;
    int numblocks;                  // WAVEHDR(PCM ubN)̐
    WAVEHDR* wavehdr;               // WAVEHDR ̔z
    bool dontmix;                   // WAVE 𑗂ۂɉ̍Ȃ
};

}

#endif // win32_soundwo_h
