// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator.
//  Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//  $Id: wincore.h,v 1.16 1999/07/10 10:14:03 cisc Exp $

#if !defined(win32_wincore_h)
#define win32_wincore_h

// ---------------------------------------------------------------------------

#include "types.h"
#include "CritSect.h"
#include "pc88/pc88.h"
#include "pc88/config.h"
#include "calender.h"
#include "winsound.h"
#include "winjoy.h"
#include "winmouse.h"

namespace PC8801
{
class WinKeyIF;
}

// ---------------------------------------------------------------------------

class WinCore
{
public:
    WinCore();
    ~WinCore();
    bool Init(WinUI* ui, HWND hwnd, Draw* draw, PC8801::WinKeyIF* keyb);
    bool Cleanup();

    void Reset();
    void ApplyConfig(PC8801::Config* config);

    long GetExecCount();
    void Wait(bool dowait);
    void SetGUIFlag(bool flag);
    void ActivateMouse(bool flag);

    PC88* GetPC88() { return &pc88; }
    PC8801::WinSound* GetSound() { return &sound; }

private:
    bool ConnectDevices(PC8801::WinKeyIF* keyb);
    void Execute(long clock, long time);
    bool EnablePad(bool enable);
    bool EnableMouse(bool enable);

    uint32 GetTime();

    uint ThreadMain();
#ifdef __OS2__
    static void ThreadEntry(void *arg);
#else
    static uint __stdcall ThreadEntry(LPVOID arg);
#endif

    CriticalSection cs_cpu;
    WinUI* ui;

#ifdef __OS2__
    int hthread;
#else
    HANDLE hthread;
#endif
    uint idthread;

    int clock;
    int execcount;

    volatile bool shouldterminate;
    volatile bool execute;
    bool padenable;
    bool mouseenable;
    int guicount;

    PC88 pc88;
    PC8801::Calender caln;
    PC8801::WinSound sound;
    PC8801::WinJoyPad pad;
    PC8801::WinMouse mouse;
};

// ---------------------------------------------------------------------------
//  }EXgp
//
inline void WinCore::ActivateMouse(bool flag)
{
    mouse.Enable(flag && mouseenable && !guicount);
}


#endif // !defined(win32_wincore_h)
