// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  ʕ`֌W
// ---------------------------------------------------------------------------
//  $Id: windraw.h,v 1.8 1999/04/18 11:21:16 cisc Exp $

#if !defined(win32_windraw_h)
#define win32_windraw_h

#include "types.h"
#include "draw.h"
#include "CritSect.h"

// ---------------------------------------------------------------------------

class WinDrawSub
{
public:
    WinDrawSub() { image = 0; }
    virtual ~WinDrawSub() {}

    virtual bool Init(HWND hwnd) = 0;
    virtual void Resize(uint width, uint height) {}
    virtual bool Cleanup() = 0;
    virtual void SetPalette(PALETTEENTRY* pal) {}
    virtual void QueryNewPalette() {}
    virtual void DrawScreen(int top, int bottom, bool refresh) = 0;

    virtual bool Lock(uint8** pimage, int* pbpl) { return false; }
    virtual bool Unlock() { return true; }

    virtual void SetGUIMode(bool gui) { }

protected:
    uint8* image;
    uint bpl;
};

// ---------------------------------------------------------------------------

class WinDraw : public Draw
{
public:
    enum DisplayType { None, GDI, DDWin, DDFull };
    enum
    {
        width = 640, height = 400,
    };

public:
    WinDraw();
    ~WinDraw();
    bool Init0(HWND hwindow);

// - Draw Common Interface
    bool Init(uint w, uint h, uint bpp);
    bool Cleanup();

    bool Lock(uint8** pimage, int* pbpl);
    bool Unlock();

    void Resize(uint width, uint height);
    void SetPalette(uint index, uint nents, const Palette* pal);
    void DrawScreen(const Region& region);

    bool ReadyToDraw() { return !drawing && active; }

// - Unique Interface
    int GetDrawCount() { int ret = drawcount; drawcount = 0; return ret; }
    void RequestPaint();
    void QueryNewPalette(bool background);
    void Activate(bool f) { active = f; }

    void SetPriorityLow(bool low);
    void SetGUIFlag(bool flag);
    bool ChangeDisplayDriver(DisplayType type, bool force480 = true);
    void Refresh() { refresh = true; }

    bool CaptureScreen(uint8* dest);

private:
    void PaintWindow();
    void SaveScreen(uint8*);
    void LoadScreen(const uint8*);

    uint ThreadMain();
#ifdef __OS2__
    static void ThreadEntry(void *arg);
#else
    static uint __stdcall ThreadEntry(LPVOID arg);
#endif

    uint idthread;
#ifdef __OS2__
    int hthread;
#else
    HANDLE hthread;
#endif
    volatile bool shouldterminate;  // XbhIv

    DisplayType drawtype;

    volatile bool drawing;          // ʂ
    bool palchanged;                // pbgύXtO
    bool drawall;                   // ʑŜ
    bool refresh;
    bool active;
#ifdef __OS2__
    RECTL drawarea;                  // ̈
#else
    RECT drawarea;                  // ̈
#endif
    int drawcount;
    int guicount;

    int screenheight;

    HWND hwnd;
#ifdef __OS2__
    HEV hevredraw;
#else
    HANDLE hevredraw;
#endif
    WinDrawSub* draw;

    CriticalSection csdraw;
    CriticalSection::Lock* lock;

    PALETTEENTRY palette[0x100];
};

#endif // !defined(win32_windraw_h)
