// ZX-Spectrum SCREEN$ viewer
// (c) 2003 Catalin Mihaila <catalin@idgrup.ro>

#ifdef USE_OPENGL
#include <GL/glut.h>
#endif

#ifdef USE_SDL
#include <SDL/SDL.h>
#endif

#ifdef USE_GGI
#include <ggi/ggi.h>
#endif

#ifdef USE_ALLEGRO
#include <allegro.h>
#endif

#ifdef USE_SVGA
#include <vga.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define MAJV 0
#define MINV 2
#define CAPTION "SCREEN$ viewer V%d.%d"

#ifdef USE_SDL
SDL_Surface *scrbuf;
SDL_Event event;
#endif

#ifdef USE_GGI
ggi_visual_t vis;
ggi_mode mo;
ggi_color col;
#endif

#ifdef USE_ALLEGRO
static BITMAP *scrbuf = NULL;
#endif

#define SPSCR argv[1]

#define SCREENWIDTH 256
#define SCREENHEIGHT 192

char zxscr[6144];
char attrs[768];

#ifdef USE_OPENGL
float colour_palette[] = {
    0,0,0,
    0,0,0.75,
    0.75,0,0,
    0.75,0,0.75,
    0,0.75,0,
    0,0.75,0.75,
    0.75,0.75,0,
    0.75,0.75,0.75,
    0,0,0,
    0,0,1,
    1,0,0,
    1,0,1,
    0,1,0,
    0,1,1,
    1,1,0,
    1,1,1
#else
unsigned int colour_palette[] = {
#ifdef USE_GGI
    0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xC000,
    0xC000, 0x0000, 0x0000,
    0xC000, 0x0000, 0xC000,
    0x0000, 0xC000, 0x0000,
    0x0000, 0xC000, 0xC000,
    0xC000, 0xC000, 0x0000,
    0xC000, 0xC000, 0xC000,
    0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0xFFFF,
    0xFFFF, 0x0000, 0x0000,
    0xFFFF, 0x0000, 0xFFFF,
    0x0000, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0x0000,
    0xFFFF, 0xFFFF, 0xFFFF
#else
    0,0,0,
    0,0,192,
    192,0,0,
    192,0,192,
    0,192,0,
    0,192,192,
    192,192,0,
    192,192,192,
    0,0,0,
    0,0,255,
    255,0,0,
    255,0,255,
    0,255,0,
    0,255,255,
    255,255,0,
    255,255,255
#endif
#endif
};

#ifdef USE_OPENGL
void gldisplay (void)
{
    int i;

    glClear( GL_COLOR_BUFFER_BIT );

    glBegin(GL_POINTS);
//    for(i=0;i<SCREENWIDTH;i++) {
//    glColor3f(colour_palette[2], colour_palette[5], colour_palette[12]);
    draw_screen();
//    glVertex2i(i, SCREENHEIGHT-10);
//    }

    glEnd();
    glFinish();
}

static void reshape( int width, int height )
{
    glViewport( 0, 0, width, height );
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glOrtho(0, width, 0, height, -1, 1);
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();
    glFlush();
}
#endif
								

int main (int argc, char *argv[])
{
    int i,d,q;
    int mainloop=1;
    int fisier;
    int octet;
#ifdef USE_OPENGL
    char windowtitle[256];
    sprintf(windowtitle,CAPTION,MAJV,MINV);
#endif

    fisier = open(SPSCR,O_RDONLY);
    if(fisier < 0) { printf("No SCREEN$ file given.\n"); return 1;}

    read(fisier,zxscr,6144);
    read(fisier,attrs,768);
    close(fisier);

#ifdef USE_OPENGL
    glutInit(&argc,argv);
    glutInitWindowSize( SCREENWIDTH, SCREENHEIGHT );
    glutInitWindowPosition( 0, 0 );
    glutInitDisplayMode( GLUT_RGB | GLUT_SINGLE );
    glutCreateWindow(windowtitle);
    glutDisplayFunc( gldisplay );
    glutReshapeFunc( reshape );
    glutMainLoop();
#else

    if(init_graphic_lib()) { printf("ERROR\n"); return 1; }

    if(init_graphic_window()) { printf("ERROR\n"); return 1; }

    draw_screen();
    update_screen();

    while(mainloop){mainloop=readkeys();}
    
    close_graphic_lib();
#endif
    return 0;
}
#ifdef USE_ALLEGRO
END_OF_MAIN();
#endif

int draw_screen(void)
{
    int octetnr;
    int d,i,k;

    for(k=0;k<3;k++)
	{
	    for(d=0;d<8;d++)
		{
		    for(i=0;i<8;i++)
			{
			    for(octetnr=(d*32);octetnr<((d*32)+32);octetnr++)
				{
				    draw_screen_pixels(zxscr[octetnr+(256*i)+(k*2048)],
				    attrs[octetnr+(256*k)],(((8*octetnr)-(256*d))
#ifdef USE_SVGA
				    +32
#endif
				    ),
				    ((i+(8*d)+(k*64))
#ifdef USE_SVGA
				    +24
#endif
				    ));
				}
			}
		}
	}

    return 0;
}

#ifndef USE_OPENGL
int init_graphic_lib (void)
{
    if(
#ifdef USE_SDL
    SDL_Init( SDL_INIT_VIDEO )
#endif
#ifdef USE_GGI
    ggiInit()
#endif
#ifdef USE_ALLEGRO
    allegro_init()
#endif
#ifdef USE_SVGA
    vga_init()
#endif
    < 0 )
	{
	    return 1;
	} else {
	    return 0;
	}
}
#endif

#ifndef USE_OPENGL
int init_graphic_window (void)
{
#ifdef USE_SVGA
    int i;
#else
#ifndef USE_GGI
    char windowtitle[256];
    sprintf(windowtitle,CAPTION,MAJV,MINV);
#endif
#endif

#ifdef USE_SDL
    scrbuf = SDL_SetVideoMode( SCREENWIDTH, SCREENHEIGHT, 16, SDL_SWSURFACE|SDL_ANYFORMAT );
    if( scrbuf == NULL )
	{
	    return(1);
	}
    SDL_WM_SetCaption( windowtitle, "" );
#endif

#ifdef USE_GGI
    vis=ggiOpen(NULL);

    if(vis == NULL)
        {
            printf("unable to open default visual.\n");
            return 1;
        }

    ggiSetFlags(vis, GGIFLAG_ASYNC);

    mo.virt.x = SCREENWIDTH;
    mo.virt.y = SCREENHEIGHT;

    mo.visible.x = GGI_AUTO;
    mo.visible.y = GGI_AUTO;

    mo.frames = GGI_AUTO;
    mo.graphtype = GGI_AUTO;

    mo.dpp.x = 1;
    mo.dpp.y = 1;

    if(ggiCheckMode(vis,&mo) < 0) {return 1;}
    if(ggiSetMode(vis,&mo) < 0) {return 1;}
#endif

#ifdef USE_ALLEGRO
    install_keyboard();
    set_window_title(windowtitle);
    set_color_depth(16);
    set_gfx_mode(GFX_AUTODETECT, SCREENWIDTH, SCREENHEIGHT, 0, 0);
    set_pallete(desktop_pallete);
    scrbuf = create_bitmap(SCREENWIDTH, SCREENHEIGHT);
#endif

#ifdef USE_SVGA
    keyboard_init();
    vga_setmode(G320x240x256);
    for(i=0;i<16;i++)
	{
	    vga_setpalette(i,colour_palette[i*3]>>2,colour_palette[i*3+1]>>2, colour_palette[i*3+2]>>2);
	}
#endif
    return 0;
}
#endif

#ifndef USE_OPENGL
int readkeys (void)
{
#ifdef USE_SDL
    while( SDL_PollEvent(&event))
	{
	    switch( event.type )
		{
		    case SDL_QUIT:
		    case SDL_KEYDOWN:
			return 0;
		    break;

		    default:
		    break;
		}
	}
#endif

#ifdef USE_GGI
    ggi_event ev;
    struct timeval t = {0,0};
    ggi_event_mask mask;
    mask = ggiEventPoll(vis, emAll, &t);
    if (!mask) { return 1; }

    while (ggiEventsQueued(vis, mask))
        {
            ggiEventRead(vis, &ev, mask);
            switch (ev.any.type)
                {
                    case evKeyPress:
                        return 0;
                    break;

                    default:
                    break;
                }
        }
#endif

#ifdef USE_ALLEGRO
    while(keypressed())
        {
            if(readkey()) { return 0; }
        }
#endif

#ifdef USE_SVGA
    vga_waitevent(VGA_KEYEVENT, NULL, NULL, NULL, NULL);
    return 0;
#else
    return 1;
#endif
}
#endif

int draw_screen_pixels (int octet_val, int attr_nr, int pix, int piy)
{
    int binar[8];
    int attrbin[8];
    int *pbin;
    int *abin;
    int i;
    int d = 1;
    int ink,paper,bright;
#ifndef USE_OPENGL
#ifdef USE_SDL
    Uint32 px;
#else
#ifndef USE_GGI
    int px;
#endif
#endif
#ifdef USE_SVGA
    unsigned char linebuf[1];
#endif
#endif

    pbin = binar;
    abin = attrbin;

    for(i=0;i<8;i++)
	{
            if(octet_val&d)
                {
                    *pbin = 1;
                } else {
                    *pbin = 0;
                }
            d=d*2;
            pbin++;
        }

    d = 1;

    for(i=0;i<8;i++)
	{
            if(attr_nr&d)
                {
                    *abin = 1;
                } else {
                    *abin = 0;
                }
            d=d*2;
            abin++;
        }

    ink = (attrbin[0]+(2*attrbin[1])+(4*attrbin[2]));
    paper = (attrbin[3]+(2*attrbin[4])+(4*attrbin[5]));
    bright = attrbin[6];

    if(bright) { ink=ink+8; paper=paper+8; }

    for(i=7;i>-1;i--)
        {
	    if(binar[i])
		{
#ifdef USE_OPENGL
		    glColor3f(colour_palette[3*ink], colour_palette[1+3*ink], colour_palette[2+3*ink]);
#else
#ifdef USE_SDL
		    px=SDL_MapRGB(scrbuf->format, colour_palette[3*ink], colour_palette[1+3*ink], colour_palette[2+3*ink]);
#endif

#ifdef USE_GGI
                    col.r = colour_palette[3*ink];
                    col.g = colour_palette[1+3*ink];
                    col.b = colour_palette[2+3*ink];
#endif

#ifdef USE_ALLEGRO
                    px = makecol(colour_palette[3*ink], colour_palette[(1+(3*ink))], colour_palette[(2+(3*ink))]);
#endif

#ifdef USE_SVGA
		    px = ink;
#endif
#endif

		} else {

#ifdef USE_OPENGL
		    glColor3f(colour_palette[3*paper], colour_palette[1+3*paper], colour_palette[2+3*paper]);
#else
#ifdef USE_SDL
		    px=SDL_MapRGB(scrbuf->format, colour_palette[3*paper], colour_palette[1+3*paper], colour_palette[2+3*paper]);
#endif

#ifdef USE_GGI
		    col.r = colour_palette[3*paper];
                    col.g = colour_palette[1+3*paper];
		    col.b = colour_palette[2+3*paper];
#endif

#ifdef USE_ALLEGRO
		    px = makecol(colour_palette[3*paper], colour_palette[(1+(3*paper))], colour_palette[(2+(3*paper))]);
#endif

#ifdef USE_SVGA
		    px = paper;
#endif
#endif
		}

#ifdef USE_OPENGL
	    glVertex2i(pix, SCREENHEIGHT-piy);
#else
#ifdef USE_GGI
            ggiSetGCForeground(vis,ggiMapColor(vis, &col));
	    ggiDrawPixel(vis,pix,piy);
#else
#ifndef USE_SVGA
	    putpixel(scrbuf,pix,piy,px);
#endif
#endif

#ifdef USE_SVGA
	    linebuf[0] = px;
	    vga_drawscansegment(linebuf,pix,piy,1);
#endif
#endif
	    pix++;
        }
    return 0;
}

#ifndef USE_OPENGL
int update_screen (void)
{
#ifdef USE_SDL
    SDL_UpdateRect(scrbuf,0,0,0,0);
#endif

#ifdef USE_GGI
    ggiFlush(vis);
#endif

#ifdef USE_ALLEGRO
    blit(scrbuf, screen, 0, 0, 0, 0, scrbuf->w, scrbuf->h);
#endif
    return 0;
}
#endif


#ifndef USE_OPENGL
int close_graphic_lib (void)
{
#ifdef USE_SDL
    SDL_Quit();
#endif

#ifdef USE_GGI
    ggiClose(vis);
    ggiExit();
#endif

#ifdef USE_ALLEGRO
    destroy_bitmap(scrbuf);
    scrbuf = NULL;
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_exit();
#endif

#ifdef USE_SVGA
    vga_setmode( TEXT );
#endif
    return 0;
}
#endif

#ifdef USE_SDL
int putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel)
{
    int bpp = surface->format->BytesPerPixel;
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;

    switch(bpp) {
        case 1:
            *p = pixel;
        break;

        case 2:
            *(Uint16 *)p = pixel;
        break;

        case 3:
            if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
                p[0] = (pixel >> 16) & 0xff;
                p[1] = (pixel >> 8) & 0xff;
                p[2] = pixel & 0xff;
            } else {
                p[0] = pixel & 0xff;
                p[1] = (pixel >> 8) & 0xff;
                p[2] = (pixel >> 16) & 0xff;
            }
        break;

	case 4:
            *(Uint32 *)p = pixel;
        break;
    }
    return 0;
}
#endif
