action SetupModemDB is
make ModemDB permanent 
    check FlowControl  in ModemDB
    check Parity  in ModemDB
    check StopBits  in ModemDB
    check DataBits  in ModemDB
    check Baud  in ModemDB
    check ComPort  in ModemDB
 
action QueryModemDB is
copy (checked in group FlowControlRB from ModemDB) to FlowControl
copy (checked in group ParityGroup from ModemDB) to Parity
copy (checked in group StopbitsGroup from ModemDB) to StopBits
copy (checked in group DatabitsGroup from ModemDB) to DataBits
copy (checked in group BaudGroup from ModemDB) to Baud
copy (checked in group ComPortGroup from ModemDB) to ComPort
 
action QueryUploadDB is
copy text of FilenameEF in UploadDB to Filename
copy parameter of (checked in group UploadGroup from UploadDB) in UploadDB to TransferMode

 
action QueryDownloadDB is
copy text of FilenameEF in DownloadDB to Filename
copy parameter of (checked in group DownloadGroup from DownloadDB) in DownloadDB to TransferMode

 
action QueryDialDB is
copy text of PhonenumberEF in DialDB to Phonenumber
 
subroutine PerformSetup() is
   begin guarded
      response to start
         make ModemDB permanent
         action SetupModemDB
         make ModemDB visible
 
      response to Cancel in ModemDB
         make ModemDB temporary 
         make ModemDB invisible 
         leave block
 
      response to OK in ModemDB
         action QueryModemDB
         make ModemDB temporary 
         make ModemDB invisible 
         leave block

      response to ParityEvenRB in ModemDB
         copy checked in group DatabitsGroup from ModemDB to TempString
         if (TempString = Databits8RB) then
            copy ReplyToMessage("Invalid Databits",
                                "If Even or Odd parity is to be used then you must specify 7 Data Bits.",
                                MEssageOK, 1, MessageIconExclamation) to TempString
            check Databits7RB in ModemDB
         end if

      response to ParityOddRB in ModemDB
         copy checked in group DatabitsGroup from ModemDB to TempString
         if (TempString = Databits8RB) then
            copy ReplyToMessage("Invalid Databits",
                                "If Even or Odd parity is to be used then you must specify 7 Data Bits.",
                                MEssageOK, 1, MessageIconExclamation) to TempString
            check Databits7RB in ModemDB
         end if

      response to Databits8RB in ModemDB
         copy checked in group ParityGroup from ModemDB to TempString
         if ((TempString = ParityOddRB) or (TempString = ParityEvenRB)) then
            copy ReplyToMessage("Invalid Parity",
                                "If 8 Data Bits are to be used then you must specify No Parity.",
                                MEssageOK, 1, MessageIconExclamation) to TempString
            check ParityNoneRB in ModemDB
         end if
            

   end

subroutine GetNumber(boolean: Status) is
   begin guarded
      response to start
         make DialDB permanent
         make DialDB visible
 
      response to Cancel in DialDB
         make DialDB temporary 
         make DialDB invisible
         copy false to Status 
         leave block
 
      response to OK in DialDB
         action QueryDialDB
         make DialDB temporary 
         make DialDB invisible 
         copy true to Status
         leave block
   end
subroutine GetUploadInformation(boolean: Status) is
   begin guarded
      response to start
         make UploadDB permanent
         make UploadDB visible
 
      response to Cancel in UploadDB
         make UploadDB temporary 
         make UploadDB invisible
         copy false to Status
         leave block
 
      response to OK in UploadDB
         action QueryUploadDB
         make UploadDB temporary 
         make UploadDB invisible 
         copy true to Status
         leave block
   end

subroutine GetDownloadInformation(boolean: Status) is
   begin guarded
      response to start
         copy "" to TempString
         make DownloadDB permanent
         make DownloadDB visible
 
      response to Cancel in DownloadDB
         make DownloadDB temporary 
         make DownloadDB invisible 
         copy false to Status
         leave block
 
      response to OK in DownloadDB
         action QueryDownloadDB
         make DownloadDB temporary 
         make DownloadDB invisible 
         copy true to Status
         leave block

      response to XModemRB in DownloadDB
         enable FilenameEF in DownloadDB
         change FilenameEF in DownloadDB text to TempString

      response to YModemRB in DownloadDB
         disable FilenameEF in DownloadDB
         copy text of FilenameEF in DownloadDB to TempString
         change FilenameEF in DownloadDB text to ""
   end

subroutine MonitorTransfer(string: Command) is
string ExtractString

   make FileTransferDB permanent
   change FilenameST in FileTransferDB text to Filename
   change TotalPacketsST in FileTransferDB text to " "
   change CurrentPacketST in FileTransferDB text to " "
   change AttemptST in FileTransferDB text to " "
   change LastMessageST in FileTransferDB text to " "
   make FileTransferDB visible
   send Command to Modem
   begin guarded
      response to line "Waiting for remote" from Modem
         change LastMessageST in FileTransferDB text to "Waiting for remote"

      response to line "XY receive: File" from Modem
         extract from input
            skip 17
            take to last ExtractString
         change FilenameST in FileTransferDB text to ExtractString

      response to line "total packets" from Modem
         extract from input
            skip to ":"
            skip 1
            take number ExtractString
         change TotalPacketsST in FileTransferDB text to ExtractString

      response to line "Packet" from Modem
         extract from input
            skip to "Packet"
            skip 7
            take number ExtractString
         change CurrentPacketST in FileTransferDB text to ExtractString
         change AttemptST in FileTransferDB text to " "

      response to line "Attempt" from Modem
         extract from input
            skip to "Attempt"
            skip 8
            take number ExtractString
         change AttemptST in FileTransferDB text to ExtractString

      response to line "Empty File" from Modem
         change LastMessageST in FileTransferDB text to "Empty File"

      response to line "Bad packet" from Modem
         change LastMessageST in FileTransferDB text to "Bad Packet"

      response to line "Out of synch" from Modem
         change LastMessageST in FileTransferDB text to "Out of Sync"

      response to line "Packet timeout" from Modem
         change LastMessageST in FileTransferDB text to "Packet Timeout"

      response to line "Unable to open" from Modem
         change LastMessageST in FileTransferDB text to "File open failed"

      response to line "Startup not acknowledged" from Modem
         change LastMessageST in FileTransferDB text to "Startup failed"

      response to line "Transfer complete" from Modem
         change LastMessageST in FileTransferDB text to "Transfer complete"

      response to line "Batch transfer complete" from Modem
         change LastMessageST in FileTransferDB text to "Transfer complete"

      response to line "END" from Modem
         copy ReplyToMessage("End Transfer", "File Transfer has ended", MessageOK, 1,  
                             MessageIconExclamation) to TempString
         make FileTransferDB invisible
         make FileTransferDB temporary
         leave block
   end



subroutine StartModemAndDial() is
boolean ESLASYNC_OK

   make ModemDB permanent
   copy (parameter of ComPort) " " to TempString
   append (parameter of Baud) " " to TempString
   append (parameter of Parity) " " to TempString
   append (parameter of DataBits) " " to TempString
   append (parameter of StopBits) " " to TempString
   append (parameter of FlowControl) to TempString
   make ModemDB temporary
   start local Modem "ESLASYNC.EXE" TempString
   begin guarded
      response to line "READY"  from Modem
         copy true to ESLASYNC_OK
         leave block

      response to line "ERROR" from Modem
         copy ReplyToMessage("ESLASYNC.EXE", input, MessageOK, 1,  
                             MessageIconExclamation) to TempString
         copy false to ESLASYNC_OK
         leave block

     response to timeout 10
         copy ReplyToMessage("TIMEOUT", "ESLASYNC.EXE not responding", 
                             MessageOK, 1, MessageIconExclamation) to TempString
         copy false to ESLASYNC_OK
         leave block
   end
   if (ESLASYNC_OK) then
      send "T ATDT " Phonenumber "\r\^D" to Modem
      begin guarded
         response to line "CONNECT" from Modem
            copy ReplyToMessage("CONNECT", "Modem connection achieved.", 
                                MessageOK, 1,  MessageIconExclamation) to TempString
            enable item Upload from PrimaryWindowAB in PrimaryWindow
            enable item Download from PrimaryWindowAB in PrimaryWindow
            enable item Disconnect from PrimaryWindowAB in PrimaryWindow
            disable item Dial from PrimaryWindowAB in PrimaryWindow
            leave block

         response to line "BUSY" from Modem
            copy ReplyToMessage("BUSY", "Unable to connect.", 
                                MessageOK, 1,  MessageIconExclamation) to TempString
            leave block

         response to line "NO CARRIER" from Modem
            copy ReplyToMessage("NO CARRIER", "Unable to connect.", 
                                MessageOK, 1,  MessageIconExclamation) to TempString
            leave block

         response to timeout 60
            copy ReplyToMessage("Timeout", "Unable to connect within 60 seconds.", 
                                MessageOK, 1,  MessageIconExclamation) to TempString
            leave block
         
      end
   end if



