#ifndef __RETRIEVER__
#define __RETRIEVER__


#define XPIPE_STDERROR        0x00000002
#define TITLE_VERSION "Marvin's Retriever 0.31"

#define ID_TIMER1 TID_USERMAX-1
#define ID_TIMER2 TID_USERMAX-2
#define ID_TIMER3 TID_USERMAX-3

#define WM_THEEND WM_USER+1

#define WM_FROM WM_USER+2
#define WM_LOCAL WM_USER+3
#define WM_LENGTH WM_USER+4
#define WM_MYERROR WM_USER+5
#define WM_MYSIZE WM_USER+6
#define WM_RATE WM_USER+7

#define WM_CONNECTED WM_USER+8
#define WM_REQUEST_OK WM_USER+9
#define WM_TIMEPAST WM_USER+10
#define WM_FINISHED WM_USER+11
#define WM_MR_DIE WM_USER+12
#define WM_RATE_NOW WM_USER +13
#define WM_TIME_REMAIN WM_USER +14

//analyze thread defines
#define PROT_IT_FINI 1
#define PROT_START 2
#define PROT_LOCAL_FN 4
#define PROT_ERROR 8
#define PROT_CONNECT 16
#define PROT_FTP_CWD 32
#define PROT_FTP_RETR 64
#define PROT_REQUEST 128
#define PROT_LENGTH  256
#define PROT_SIZE    512
#define PROT_AVG_RATE 1024


char *aboutThanks[]={
  "Daniel Caetano - Ideas",
  "Guillaume Gay - offered French Translation",
  "Junio Hamano - wGet Author",
  "Armin Jakob -Ideas & Bugs",
  "Jan-Erik Lrka - offered Swedish Translation",
  "Gordon Matzigkeit - wGet Author",
  "Hrvoje Niksic - original wGet Author",
  "George Nechaev - wGet Author OS/2 Version",
  "Andrea Scagni - Ideas & Bugs",
  "Kyosuke Tokoro - wGet Author OS/2 Version",
  "\0"};

typedef struct
{
int wGetPath;
char wGetExePath[CCHMAXPATH];
char httpProxyServer[128];
int  httpProxyServerPort;
char ftpProxyServer[128];
int  ftpProxyServerPort;
int ftpPassiveMode;
} StaticExecSettings;

typedef struct
{
int autoStart;
long autoStartTime;
int autoClose;
int detail;
int filePath;

} StaticRuntimeSettings;

typedef struct
{
StaticExecSettings staticExecSettings;
StaticRuntimeSettings staticRuntimeSettings;
} StaticSettings;

typedef struct
{
//int cfont;
char retrieverIniFile[CCHMAXPATH+1];
char retrieverPath[CCHMAXPATH+1];

int autoClose;
DATETIME startTime;
char workDir[CCHMAXPATH];


} RuntimeSettings;

typedef struct
{
int cont;
int iterative;
char url[255];      //the url
int urlExists;
char clipUrl[255];
int usedClip;
char workDir[CCHMAXPATH];
char **wgetArgs;
}ExecArgs;

typedef struct
{
int autoClose;
int noAutoClose;
int filePath;
int noFilePath;

} RuntimeArgs;

typedef struct
{
ExecArgs execArgs;
RuntimeArgs runtimeArgs;
} Args;

typedef struct
{
int rcError;
int rcUsercancel;
int rcAllOk;
} RetCode;

typedef struct
{
int isPipe;
HMQ infoPipeHMQ;
char pName[64];
} PIPEDATA;


typedef struct
{
char from[255];     //the local filename
char local[255];    // local filename

long seconds;
char avgRate[32];
char rateNow[32];
long length;

ULONG actSize;
ULONG prevSize;

int endDownload;
int endFile;
int newDownload;


HFILE hpR;
HFILE hpW;

int lastSizeToggle;
int windowDetail;
ULONG asyncPipeMsg;

} RuntimeData;

typedef struct
{
HAB mainHAB;
ULONG idMainPage1;
ULONG idMainPage2;
HWND hwndDlg;
HWND hwndClient;
HWND hwndConDlg;
HWND hwndStatDlg;
HWND noteBookWnd;
HWND hwndFrame;


ULONG wgetPid;
ULONG statUpdateTID;
ULONG analyzeTID;
ULONG infoPipeTID;
int bigFonts;
FILE *logout;

}SystemRuntimeData;


int fetch(int refresh);
int  fetchStr(char *str,int begin,int end,int len,int refresh);
char * getHttpUrl(char *where,char *dest);
char * getFtpUrl(char *where,char *dest);
void toggleNbWindowPos(HWND wnd,int xDiff,int yDiff);
int toggleWindowSize(HWND wnd,int xDiff,int yDiff);
void toggleWindowPos(HWND wnd,int xDiff,int yDiff);
LONG mrNPGetState(HPIPE pHandle);
void infoPipeThread(void);
void commandPipeThread(void);
void statUpdateThread(void);
void analyzeThread(void);
void statSetLength(char* length);
void statSetError(char *str);
void statSetInfo(char *str);
void statRequestOK(void);
void statSetRemainingTime(unsigned long sec);
void statSetFinishedAt(DATETIME elapsedTime,DATETIME startedAt,long remainingSec);
void statSetConnecting(void);
void statSetFromFn(char *fn);
void statSetLocalFn(char *fn);
void statSetPercent(long length,long act);
void doArgs(int argc,char *argv[]);
int startJob(char *wget,char *workdir,int cont);
void statSetSize(long size,int finished);
void statSetRate(double rate,double avg);   //Speed

MRESULT EXPENTRY mainNbPageDlgProc(HWND hwndStatDlg,ULONG msg,MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY retrieverWndProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2);
MRESULT EXPENTRY settingsDialogProc(HWND window,ULONG Message,MPARAM Param1,MPARAM Param2);
MRESULT EXPENTRY aboutDialogProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2);
MRESULT EXPENTRY getUrlDialogProc(HWND Window,ULONG Message,MPARAM Param1,MPARAM Param2);


#endif
