#ifndef BROADCASTER_H
#define BROADCASTER_H

#include <QObject>
#include <QtNetwork>
#include <stdlib.h>

class Broadcaster : public QObject
{
    Q_OBJECT

public:
    explicit Broadcaster(QObject *parent = 0);
    ~Broadcaster();
    void searchAvailableServer(int port);
    void stopSearch();
    void startBroadcast(int port);
    void stopBroadcast();

private:
    QString getLocalAddress();

private:
    QUdpSocket *udpSocket;
    QTimer datagramTimer;
    int serverPort;
    int searchPort;

signals:
    void emitServerLocated(QString);

private slots:
    void processPendingDatagrams();
    void sendBroadcast();

};

#endif // BROADCASTER_H
