#ifndef CONNWINDOW_H
#define CONNWINDOW_H

#include <QDialog>
#include <QDesktopWidget>
#include <QListWidget>
#include <QTranslator>
#include "simplenetwork.h"
#include "broadcaster.h"
#include "optionwindow.h"
#include "infowindow.h"

namespace Ui {
    class ConnWindow;
}
//================[ Connection Window ]========================================
class ConnWindow : public QDialog
{
    Q_OBJECT

public:
    //get-method for simplenetwork-class
    SimpleNetwork* getSimpleNet(){return sNet;}
    //initialize signal slots
    void signalSlots();
    void translate();

public:
    explicit ConnWindow(QDialog *parent = 0);
    ~ConnWindow();

private:
    Ui::ConnWindow *ui;
    SimpleNetwork *sNet;
    OptionWindow *oWin;
    InfoWindow *iWin;
    QTcpServer *server;
    Broadcaster bCast;
    QIntValidator *validator;
    QString wanIp;
    QHttp *http;
    QByteArray *byteArray;
    QBuffer *buffer;

private:
    QString& getWanIp();


protected:
    void closeEvent( QCloseEvent* e );

private slots:
   //push button click events
   void on_pb_help_clicked();
   void on_pb_about_clicked();
   void on_pb_options_clicked();
   void on_rb_ipAddress_clicked();
   void on_rb_nameAddress_clicked();
   void on_lw_serverlist_itemDoubleClicked(QListWidgetItem* item);
   void on_lw_serverlist_itemClicked(QListWidgetItem* item);
   void on_pb_serverlist_clicked();
   void on_pb_close_clicked();
   void on_pb_open_clicked();
   void on_pb_exit_clicked();
   void on_pb_connect_clicked();
   void on_pb_server_clicked();
   // line edit text change events
   void on_le_portS_textChanged(QString );
   void on_le_portC_textChanged(QString );

private slots:
   //connection successfully established
   void successfullyConnected();
   //connection to the server
   void connected();
   //connection failed
   void connectionFailed();
   void serverLocated(QString);
   void restart();
   void httpRequestFinished(int,bool);
};

#endif // CONNWINDOW_H
