/*------------------------------------------------------------------
 * miniftp.cmd :
 *------------------------------------------------------------------
 * 03-16-93 originally by Patrick J. Mueller & Cliff Nadler
 *------------------------------------------------------------------*/

trace off

/*------------------------------------------------------------------
 * load functions, if needed
 *------------------------------------------------------------------*/
if RxFuncQuery("FtpLoadFuncs") then
   do
   rc = RxFuncAdd("FtpLoadFuncs","RxFtp","FtpLoadFuncs")
   rc = FtpLoadFuncs()
   end

if RxFuncQuery("SysLoadFuncs") then
   do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
   end

/*------------------------------------------------------------------
 * set up signal
 *------------------------------------------------------------------*/
signal on halt

parse value SysTextScreenSize() with rows cols

/*------------------------------------------------------------------
 * get parameters
 *------------------------------------------------------------------*/
parse arg host user pass .

/*------------------------------------------------------------------
 * set things
 *------------------------------------------------------------------*/
if (host <> "") & (user <> "") & (pass <> "") then
   rc = FtpSetUser(host,user,pass)
else
   do
   host = ""
   user = ""
   pass = ""
   end

do while (cmd <> "QUIT")

   /*---------------------------------------------------------------
    * print prompt
    *---------------------------------------------------------------*/
   say
   say "Enter FTP command: (use ? for help)"

   /*---------------------------------------------------------------
    * print status
    *---------------------------------------------------------------*/
   parse value SysCurPos(0,0) with row col

   do i = 1 to 4
      call SysCurPos i-1, 0
      say copies(" ",cols)
   end

   if (host <> "") then
      status = "connected to" user"@"host
   else
      status = "not connected to a host"

   junk = FtpPwd('dir')
   if (junk <> 0) then
      dir = "not specified"

   call SysCurPos 0,0

   say d2c(218) || copies(d2c(196),70)
   say d2c(179) || " MiniFtp:" time() status
   say d2c(179) || " directory:" dir
   say d2c(192) || copies(d2c(196),70)

   call SysCurPos row, col

   /*---------------------------------------------------------------
    * get command
    *---------------------------------------------------------------*/
   parse pull cmd cmdargs
   parse var cmdargs file1 file2 rest

   if (file1 = "") then file1 = "*"
   if (file2 = "") then file2 = file1

   /*------------------------------------------------------------------
    * sanity check
    *------------------------------------------------------------------*/
   cmd = translate(cmd)

   if (host="") then
      if (cmd <> "CONNECT") & (cmd <> "?") & (cmd <> "QUIT") then
         do
         say "You have not provided host, userid, and password information."
         say "Use the CONNECT command to provide this information."
         iterate
         end

   /*---------------------------------------------------------------
    * start timer for get/put
    *---------------------------------------------------------------*/
   if (cmd = "GET") | (cmd = "GETB") | (cmd = "PUT") | (cmd = "PUTB") then
      call time "r"

   /*---------------------------------------------------------------
    * run command
    *---------------------------------------------------------------*/
   err = 0
   select
      when (cmd = "QUIT")    then iterate
      when (cmd = "GET")     then err = FtpGet(file1,file2,"ASCII")
      when (cmd = "GETB")    then err = FtpGet(file1,file2,"BINARY")
      when (cmd = "PUT")     then err = FtpPut(file1,file2,"ASCII")
      when (cmd = "PUTB")    then err = FtpPut(file1,file2,"BINARY")
      when (cmd = "UPUT")    then err = FtpPutUnique(file1,file2,"ASCII")
      when (cmd = "UPUTB")   then err = FtpPutUnique(file1,file2,"BINARY")
      when (cmd = "DELETE")  then err = FtpDelete(file1)
      when (cmd = "RENAME")  then err = FtpRename(file1,file2)
      when (cmd = "APPEND")  then err = FtpAppend(file1,file2,"ASCII")
      when (cmd = "APPENDB") then err = FtpAppend(file1,file2,"BINARY")
      when (cmd = "QUOTE")   then err = FtpQuote(cmdargs)
      when (cmd = "SITE")    then err = FtpSite(cmdargs)
      when (cmd = "CD")      then err = FtpChDir(file1)
      when (cmd = "MD")      then err = FtpMkDir(file1)
      when (cmd = "RD")      then err = FtpRmDir(file1)

      when (cmd = "DIR")     then err = FtpDir(file1,"stem.")
      when (cmd = "LS")      then err = FtpLs(file1,"stem.")

      when (cmd = "CONNECT") then
         do
         parse var cmdargs host user pass
         call FtpSetUser host, user, pass
         end

      when (cmd = "CLOSE")   then
         do
         rc = FtpLogoff()
         host = ""
         user = ""
         pass = ""
         end

      when (cmd = "PWD")     then
         do
         junk = FtpPwd('curdir')
         say "Current Remote Directory :" curdir
         end

      when (cmd = "SYS")     then
         do
         junk = FtpSys('sys')
         say "Returned from sys:" sys
         end

      when (cmd = "?")       then call Usage

      otherwise
         say "Invalid command. Use ? for help."
   end

   /*---------------------------------------------------------------
    * stop timer for get/put
    *---------------------------------------------------------------*/
   if (cmd = "GET") | (cmd = "GETB") | (cmd = "PUT") | (cmd = "PUTB") then
      do
      elapsed = strip(format(time("e"),10,2))

      if (cmd = "GET") | (cmd = "GETB") then
         lfile = file2
      else
         lfile = file1

      bytes = stream(lfile,"C","QUERY SIZE")

      bps = strip(format(bytes/elapsed,10,2))
      say "transmitted" bytes "bytes in" elapsed "seconds:" bps "bytes/second."
      end

   /*------------------------------------------------------------------
    * check error
    *------------------------------------------------------------------*/
   if (err <> 0) then
      say "Error from FTP:" FTPERRNO

   /*------------------------------------------------------------------
    * check for dir or ls
    *------------------------------------------------------------------*/
   if (cmd = "LS") | (cmd = "DIR") then
      do i = 1 to stem.0
         say stem.i
      end
end

/*------------------------------------------------------------------
 * quit
 *------------------------------------------------------------------*/
done:
rc = FtpSetUser("X","X","X")
rc = FtpLogoff()
exit

/*------------------------------------------------------------------
 * break condition
 *------------------------------------------------------------------*/
halt:
   say "Terminating ..."
   signal done

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure

   say "usage:"
   say "   command ..."
   say "is used to run ftp commands on a remote host"
   say
   say "where:"
   say "   command can be one of:"
   say "       connect host user password"
   say "       close"
   say "       site site-command"
   say "       dir pattern"
   say "       ls  pattern"
   say "       get remotefile [localfile]"
   say "       getb remotefile [localfile]"
   say "       put localfile [remotefile]"
   say "       putb localfile [remotefile]"
   say "       uput localfile [remotefile]"
   say "       uputb localfile [remotefile]"
   say "       rename oldname newname"
   say "       delete filename"
   say "       append remotefile [localfile]"
   say "       appendb remotefile [localfile]"
   say "       sys"
   say "       md directory"
   say "       cd directory"
   say "       rd directory"
   say "       pwd"
   say "       quit"

   return 0
