/**************************************************************
 *                                                            *
 *                   MainActor Rexx Script                    *
 *                                                            *
 *  Sets the exact representation of a requested fps rate     *
 *                                                            *
 *  Normally you cannot express a specific frames per second  *
 *  rate with a millisecond value. For example 15fps=1000/15  *
 *  =66.666667                                                *
 *  This script solves this problem and always adds the       *
 *  current error to the total error. When the total error    *
 *  gets bigger as 1 millisecond it will be stored out.       *
 *  This way the error is always <= 1 millisecond, which is   *
 *  more than accepteable.                                    *
 *                                                            *
 *  Example: 15 fps would result in a 66, 67, 67 pattern      *
 *                                                            *
 *  Last modified: 10/11/97, Written by: Markus Moenig        *
 *                                                            *
 **************************************************************/

  say "This script sets an exact fps rate to the current picture list".

  IF GetGlobalInfo("LOADEDPROJECTS")= "0" THEN DO     /* Check if there are */
   BEGIN                                              /* any projects loaded */
    say "No picture list loaded! Exiting ..."         /* Failed, exiting ... */
    exit
   END

  IF GetProjectInfo("TYPE") <> "Picture List" THEN DO /* Only works for pictures */
    say "This script needs a picture list! Exiting..."
    exit
   END

  say "Please enter the frames per second (fps) rate ('quit' to exit):"
  pull fps
  IF fps="QUIT" THEN exit

  millisec=1000 / fps                                /* Calc the millisecond rate */
  millisec_int=millisec % 1                          /* Get integer representation */
  millisec_err=millisec - millisec_int               /* Calc the floating point error */
  millisec_totalerr=0                                /* Reset total error */

  i=1                                                /* Init loop variables */
  frames=GetProjectInfo("FRAMES")
  say "Setting timecodes ..."
  DisableFrameContainer()                            /* Disable the Frame Container */
  DO WHILE i <= frames
   BEGIN
     tmp=millisec_int                                /* Set integer timecode */
     millisec_totalerr=millisec_totalerr + millisec_err /* and add the error for this frame */
     IF millisec_totalerr >= 1.0 THEN DO             
      BEGIN                                          /* If total error >= 1 millisecond : */
       millisec_totalerr=millisec_totalerr - 1.0     /* substract one millisecond and add */
       tmp=tmp + 1                                   /* one millisecond to the integer */
      END
     SetLocalTimecode(i,tmp)                         /* Set new timecode */
     i=i+1
    END
  EnableFrameContainer()                             /* Enable the Frame Container again */
  say "Finished !"