WHIRLGIF 3.00                   (August 1998)                 WHIRLGIF 3.00



NAME
     whirlgif - reads a series of GIF87a or GIF89a files, and produces one
     single GIF89a file composed of those images.

SYNOPSIS
     whirlgif [global-options] [file-options {GIFfile|-i incfile

     The global-options are one or more of:
          -v
          -trans {color|index}
          -background index
          -time delay
          -globmap
          -minimize
          -o outfile
          -loop [count]
          -comment comment
          -disp method

     The file-options are one or more of:
          -off x:y-pair
          -trans {color|index}
          -time delay
          -disp method


DESCRIPTION
     Whirlgif reads a series of GIF files and produces one single GIF file
     composed of those images.  The result may be an animated GIF or a
     screen with several pictures loaded one after the other.

     The first file defines the so called screen size and the background
     color of the resulting GIF.  The background color may be changed by an
     option.

     The input files may be in either GIF87a or GIF89a format.  If a GIF
     file contains more than one image, only the first image is read.  To
     help saving bandwith on the internet, there are options for forcing
     all GIFs in the series to use the same color map and to create sub-
     GIFs which only give the difference between a picture and the next.

OPTIONS
     -v   Verbose mode.  Output is written to the error out file.  This is
          a global option and must be given before any GIFfiles.

     -trans index|color
          Set the color identified with index or the color code #xxxxxx,
          where xxxxxx is a hex RGB index to be transparent.  When this
          option is used as a file-option, its setting is valid for all
          subsequent GIFfiles, until it is used again.


     -background index
          Set the color identified with its index to be the background
          color, possibly overriding the background color defined in the
          first GIFfile.

     -time delay
          Defines inter-frame timing in units of 1/100 second.  Whenever a
          value of delay is set by means of the -time option, this value
          will be valid for the following GIFfiles until a new value is
          set.  This is a global option and must be given before any
          GIFfiles.

     -globmap
          Use the color map of the first GIFfile as the global color map
          throughout the outfile.  If the color maps of subsequent GIFfiles
          contain colors that are not in the global color map, the nearest
          colors in a 3 dimensional RGB space will be chosen.  This is a
          global option and must be given before any GIFfiles.

     -minimize
          Only the smallest rectangles covering the difference between two
          GIFfiles will be output.  All GIFfiles must be of the same size
          and have the same offset.  This is tested, and may result in an
          error message.  This is a global option and must be given before
          any GIFfiles.

          As a side effect, the -minimize option forces the same
          (global)color map to be used throughout the outfile.

     -o outfile
          Write the results to outfile This is a global option and must be
          given before any GIFfiles.

     -loop [count]
          Add the Netscape 'loop' extension.  If count is omitted, 0 (zero)
          is assumed.  This is a global option and must be given before any
          GIFfiles.

     -comment comment
          Define a Comment Extension block within the resulting GIF file.
          This block will be written at the end of the file.  A comment
          block can be at most 254 characters long, including line shifts.
          It may be used for copyright notices.  This is a global option
          and must be given before any GIFfiles.

     -disp method
          Sets the image 'disposal' method.  When this option is used as a
          file-option, its setting is valid for all subsequent GIFfiles,
          until it is used again.  The methods may be one of the keywords:

          none No disposal specified.  The default.

          back Restore to background color.  Fill the image's space with
               the background color.

          prev Restore to previous, restores the screen area to what was
               there before.  Netscape has a problem with this option.

          not Do not dispose.  The next image will overlay this one.


     -i incfile
          Read a list of names from incfile

     -off x:y-pair
          Sets the position of the next GIFfile or the set of GIFfiles in
          an incfile.

          The x:y-pair consists of two integers, separated by one character
          which cannot be part of a number.  A colon, ':' is preferred.
          The two integers define the position of the upper left corner of
          the next image within the 'screen' of the resulting GIF.  The
          integers are added to a possible offset within the next GIFfile.
          One or both may be negative.  Negative numbers will re-position
          an image upwards and/or to the left within its own 'screen'.  The
          'screen' of a GIF is the term used in the GIF definitions for the
          area, a GIF covers.

TIPS
     If you don't specify an output file, the GIF will be sent to stdout.
     This is a good thing if you're using whirlgif in a CGI script, but
     could cause problems if you run from a terminal and forget to redirect
     stdout.

     The output file (if any) and the loop option MUST be specified before
     any GIF images.

     You can specify several delay statements on the command line to change
     the delay between images in the middle of an animation, e.g.

whirlgif -time 25 a.gif b.gif c.gif -time 100 d.gif -time 25 e.gif f.gif

     Usually, the bacground color is defined by the first GIFfile, and
     often it is index number zero (0).  If you are animating with a
     transparent color, a good method is usually to use the same color as
     the background.

     It is possible, but may cause problems for some programs, to specify
     several transparency statements on the command line.

     The size of the resulting GIF and the global color map is defined by
     the first GIFfile.  If you have a large background GIF and have
     several smaller GIFs, you may make some kind of a bulletin board by a
     command of the following form:

whirlgif large.gif -off 77:44 small1.gif -off 22:99 small2.giff ...

     You may build in some timing between the small GIFs.

LIMITATIONS
     The loop 'count' is ineffective because Netspcape always loops
     infinitely.

BUGS
     Whirlgif should be able to specify delay and offset in an 'incfile'
     list (see next bug).

     Does not handle filenames starting with a - (hypen), except in
     'incfile'.

TODO
       - Make a graphic interface.  Perhaps by re-implementing the
     algorithms in Java(tm).

       - option for other choices of unification methods for colormaps.
     The nearest point in the 3 dimensional RGB color space may not be the
     best choice.

       - define extension block in order to have frame lists.

       - define single-letter options and use getopt(1) like most UNIX
     programs.


     This program is available from http://www.danbbs.dk/whirlgif/

AUTHORs
     V3.00 Hans Dinsen-Hansen <dino@danbbs.dk>
     Based on Whirlgif V2.02 by Kevin Kadow <kadokev@msg.net>
          & Hans Dinsen-Hansen <dino@danbbs.dk>
     which is again based on 'txtmerge' written by:
     Mark Podlipec <podlipec@wellfleet.com>
     Man Page by Mintak Ng <mintak@hitak.com>
          & Hans Dinsen-Hansen <dino@danbbs.dk>


COPYRIGHT NOTICES
     The Graphics Interchange Format (c) is the Copyright property of
     Compuserve Incorporated.  GIF(sm) is a Service Mark property of
     Compuserve Incorporated.

     See other Copyright notices in the accompanying texts.

WHIRLGIF 3.00                   (August 1998)                 WHIRLGIF 3.00
