head	5.13;
access;
symbols;
locks;
comment	@ * @;


5.13
date	2007.07.15.11.32.08;	author Average;	state Exp;
branches;
next	5.12;

5.12
date	2007.07.14.16.22.47;	author Average;	state Exp;
branches;
next	5.11;

5.11
date	2007.07.11.15.18.49;	author Average;	state Exp;
branches;
next	5.10;

5.10
date	2007.07.07.15.55.15;	author Average;	state Exp;
branches;
next	5.9;

5.9
date	2007.07.07.15.20.21;	author Average;	state Exp;
branches;
next	5.8;

5.8
date	2007.07.07.15.14.36;	author Average;	state Exp;
branches;
next	5.7;

5.7
date	2007.07.07.14.46.15;	author Average;	state Exp;
branches;
next	5.6;

5.6
date	2007.07.07.14.42.18;	author Average;	state Exp;
branches;
next	5.5;

5.5
date	2007.07.05.15.00.48;	author Average;	state Exp;
branches;
next	5.4;

5.4
date	2007.07.05.14.07.46;	author Average;	state Exp;
branches;
next	5.3;

5.3
date	2007.07.04.16.12.06;	author Average;	state Exp;
branches;
next	5.2;

5.2
date	2007.07.04.16.02.43;	author Average;	state Exp;
branches;
next	5.1;

5.1
date	2007.07.04.12.44.23;	author Average;	state Exp;
branches;
next	4.8;

4.8
date	2007.07.02.15.50.33;	author Average;	state Exp;
branches;
next	4.7;

4.7
date	2007.07.01.13.16.23;	author Average;	state Exp;
branches;
next	4.6;

4.6
date	2007.07.01.12.59.41;	author Average;	state Exp;
branches;
next	4.5;

4.5
date	2007.06.27.14.32.59;	author Average;	state Exp;
branches;
next	4.4;

4.4
date	2007.06.26.14.45.58;	author Average;	state Exp;
branches;
next	4.3;

4.3
date	2007.06.26.14.03.08;	author Average;	state Exp;
branches;
next	4.2;

4.2
date	2007.06.25.15.49.58;	author Average;	state Exp;
branches;
next	4.1;

4.1
date	2007.06.25.12.37.11;	author Average;	state Exp;
branches;
next	3.16;

3.16
date	2007.06.23.14.30.59;	author Average;	state Exp;
branches;
next	3.15;

3.15
date	2007.06.21.15.23.37;	author Average;	state Exp;
branches;
next	3.14;

3.14
date	2007.06.21.14.29.36;	author Average;	state Exp;
branches;
next	3.13;

3.13
date	2007.06.20.14.11.33;	author Average;	state Exp;
branches;
next	3.12;

3.12
date	2007.06.20.13.41.21;	author Average;	state Exp;
branches;
next	3.11;

3.11
date	2007.06.19.16.12.12;	author Average;	state Exp;
branches;
next	3.10;

3.10
date	2007.06.19.16.07.42;	author Average;	state Exp;
branches;
next	3.9;

3.9
date	2007.06.19.14.23.47;	author Average;	state Exp;
branches;
next	3.8;

3.8
date	2007.06.18.14.08.54;	author Average;	state Exp;
branches;
next	3.7;

3.7
date	2007.06.18.13.59.33;	author Average;	state Exp;
branches;
next	3.6;

3.6
date	2007.06.17.14.35.06;	author Average;	state Exp;
branches;
next	3.5;

3.5
date	2007.06.17.14.33.38;	author Average;	state Exp;
branches;
next	3.4;

3.4
date	2007.06.17.14.19.41;	author Average;	state Exp;
branches;
next	3.3;

3.3
date	2007.06.17.14.10.09;	author Average;	state Exp;
branches;
next	3.2;

3.2
date	2007.06.17.13.12.39;	author Average;	state Exp;
branches;
next	3.1;

3.1
date	2007.06.17.12.40.01;	author Average;	state Exp;
branches;
next	2.9;

2.9
date	2007.06.16.14.36.41;	author Average;	state Exp;
branches;
next	2.8;

2.8
date	2007.06.16.14.29.41;	author Average;	state Exp;
branches;
next	2.7;

2.7
date	2007.06.16.13.09.05;	author Average;	state Exp;
branches;
next	2.6;

2.6
date	2007.06.16.13.01.52;	author Average;	state Exp;
branches;
next	2.5;

2.5
date	2007.06.15.15.42.10;	author Average;	state Exp;
branches;
next	2.4;

2.4
date	2007.06.15.15.38.49;	author Average;	state Exp;
branches;
next	2.3;

2.3
date	2007.06.14.13.33.13;	author Average;	state Exp;
branches;
next	2.2;

2.2
date	2007.06.14.12.38.49;	author Average;	state Exp;
branches;
next	2.1;

2.1
date	2007.06.14.12.29.35;	author Average;	state Exp;
branches;
next	2.0;

2.0
date	2007.06.13.16.06.57;	author Average;	state Exp;
branches;
next	1.11;

1.11
date	2007.06.13.15.28.36;	author Average;	state Exp;
branches;
next	1.10;

1.10
date	2007.06.13.15.05.31;	author Average;	state Exp;
branches;
next	1.9;

1.9
date	2007.06.12.15.44.57;	author Average;	state Exp;
branches;
next	1.8;

1.8
date	2007.06.12.15.22.03;	author Average;	state Exp;
branches;
next	1.7;

1.7
date	2007.06.09.19.01.04;	author Average;	state Exp;
branches;
next	1.6;

1.6
date	2007.06.09.15.32.20;	author Average;	state Exp;
branches;
next	1.5;

1.5
date	2007.06.09.15.00.58;	author Average;	state Exp;
branches;
next	1.4;

1.4
date	2007.06.09.13.36.04;	author Average;	state Exp;
branches;
next	1.3;

1.3
date	2007.06.09.05.06.59;	author Average;	state Exp;
branches;
next	1.2;

1.2
date	2007.06.07.15.56.48;	author Average;	state Exp;
branches;
next	1.1;

1.1
date	2007.06.06.15.39.17;	author Average;	state Exp;
branches;
next	;


desc
@@


5.13
log
@ Ƃ肠_ỎẽoOC
@
text
@(**$Revision: 5.12 $**)
PROGRAM GSV;
USES
    os2def,os2base,os2pmapi,
    NuCell,GSVUnit,MkBmp,
    uGetOpt,
    xmlcfg,
    VPUtils,Classes,SysUtils;
{$PMTYPE PM}

{$R ground.res}

CONST
    DefaultColum:INTEGER=4;
    PNGWriteName='round.png';
    WM_ENDTHREAD=WM_USER+1;
    WM_SAVESTART=WM_USER+2;
    WM_InitChangeSpin=WM_USER+3;

    MainTimerID:ULong=TID_USERMAX-1;
CONST
    idGraphShow  =  11000;
    ID_Pane      =  11001;
    ID_DRAWPANE  =  11002;
    ID_TOOLBAR   =  11003;

    IDB_LEFT     =  12001;
    IDB_RIGHT    =  12002;
    IDB_UP       =  12003;
    IDB_DOWN     =  12004;
    IDB_FIT      =  12005;
    IDB_EXIT     =  12008;
    IDB_SETTING  =  12012;
    IDB_SHOWDLG  =  12013;

    DLGPanel        =10000;
    IDColorButton   =10001;
    IDDropSpin      =10002;
    IDRoundCheck    =10003;
    IDRoundSpin     =10004;
    IDDropOptSpin   =10005;
//    IDChangeSizeXSpin   =10010;
    IDChangeSizeYSpin   =10011;
    IDChangeSizeCheck   =10012;
    IDRender        =10100;
    IDUndo          =10101;
    IDSaveRender    =10102;
(* Local procedures *)

FUNCTION MainClientProc(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
                                                              cdecl; forward;
FUNCTION DrawPaneClientProc(Window:HWnd;Msg:ULong;Mp1,Mp2:MParam):MResult;
                                                              cdecl;forward;
FUNCTION PaneClientProc(Window:HWnd;Msg:ULong;Mp1,Mp2:MParam):MResult;
                                                              cdecl;forward;

(* Static Variables *)

CONST
    DrawPane    :CellDef =(lType:CELL_WINDOW;
                         pszClass:'BitmapPane';
                         pszName:'';
                         ulStyle:WS_VISIBLE;
                         ulID:ID_DRAWPANE;
                         pPanel1:NIL;
                         pPanel2:NIL;
                         pClassProc:NIL;
                         pClientClassProc:DrawPaneClientProc
                         );

    pane        :CellDef=(lType:CELL_HSPLIT ;
                         pszClass:NIL;
                         pszName:'pane';
                         ulStyle:WS_VISIBLE OR
                                 FCF_vertscroll OR fcf_HorzScroll;
                         ulID:ID_PANE;
                         pPanel1:@@DrawPane;
                         pPanel2:NIL;
                         pClassProc:NIL;
                         pClientClassProc:PaneClientProc
                         );

    mainClient :CellDef=(lType:CELL_HSPLIT ;
                         pszClass:NIL;
                         pszName:'Round Rect ';
                         ulStyle:FCF_TITLEBAR OR FCF_SYSMENU OR
                                 FCF_MINMAX OR FCF_ICON OR FCF_ACCELTABLE OR
                                 FCF_TASKLIST OR FCF_SIZEBORDER ;
                         ulID:idGraphShow;
                         pPanel1:@@Pane;
                         pPanel2:NIL;
                         pClassProc:NIL;          // Frame subclass proc
                         pClientClassProc:MainClientProc
                            );

      mainItems:ARRAY [0..7] OF TBItemData=(
            (NuID:IDB_FIT       ;cText:' Fit Window'),
            (NuID:IDB_UP        ;cText:' Scale Up'),
            (NuID:IDB_DOWN      ;cText:' Scale Down'),
            (NuID:TB_SEPARATOR),
            (NuID:IDB_EXIT      ;cText:' Exit Application '),
            (NuID:TB_SEPARATOR),
            (NuID:IDB_SHOWDLG   ;cText:' Show Setting Dialog'),
            (NuID:0)
      );

    mainTb:TbDef = (lType:TB_VERTICAL OR TB_ATTACHED_BT OR TB_BUBBLE ;
                    ulID:ID_TOOLBAR;
                    tbItems:@@mainItems);


    achDirection : ARRAY[1..3] OF pChar = ( 'Right',   'Left', 'Center');

TYPE
    RoundParamRecord=RECORD
        isMakeRound:BOOLEAN;
        DropBkCol,BkCol:ColorRecord;
        RoundRadian,DropLength:INTEGER;
        isChangeSize:BOOLEAN;
        ChangeSizeWidth,ChangeSizeHeight:INTEGER;
        XYRatio:LONGINT;
    END;

    GraphRounderClass=CLASS(GraphDataClass)
        FrameWindow:hwnd;
        hwndPane:HWnd;
        hwndVScrol,hwndHScrol:hwnd;
        hwndMinMax,hwndTitle,hwndSysMenu:hwnd;
        hwndDlg:hwnd;
        cx,cy:INTEGER;
        xEdge,yEdge:INTEGER;
        pOrgBitmap:pBitmapRecord;
        pChangeSizeBMP:pBitmapRecord;

        DlgParam:RoundParamRecord;

        isAuto:BOOLEAN;//Auto Effect Mode
        isSave:BOOLEAN;
        ThreadID:TID;
        TimerSec:INTEGER;
        constructor Create;
        PROCEDURE SetPaneSize(x,y:INTEGER);
        PROCEDURE CalcFitScale;
        PROCEDURE CreateScroll(window:hwnd);
        PROCEDURE SetScroll;
        FUNCTION CalcEdge:RectL;
        PROCEDURE RedrawMsg;
        FUNCTION isArgEmpty:BOOLEAN;
        FUNCTION GetStatusStr:string;
        PROCEDURE DrawScreen(window:hwnd);
        PROCEDURE CopyToOrg;
        PROCEDURE MakePaneLarge(enLargeSize:INTEGER);
        PROCEDURE CopyFromOrg;
        PROCEDURE MakeRender(DropL,RoundR:INTEGER);
        PROCEDURE LoadFile;OverRide;
        PROCEDURE PushParamList;
        FUNCTION GetAnotherParamIndex:INTEGER;
        FUNCTION isPrevParam:BOOLEAN;
        FUNCTION GetPrevParam:RoundParamRecord;
        FUNCTION GetOrgWidth:INTEGER;
        FUNCTION GetOrgHeight:INTEGER;
        PROCEDURE SetChangeSizeHeader(x,y:INTEGER);
        PROCEDURE CopyFromChangeSize(x,y,r:INTEGER);
    PROTECTED
        ParamList:TList;
        FUNCTION GetBgColorText:string;OverRide;
    END;

CONST
    XMLConfName:string='grcfg.xml';
    isColorDefine='PiNGRound/BkColor/isDefine';
    ColorValue='PiNGround/BkColor/Value';
    ShadowValue='PiNGround/Shadow/Value';
    TimerValue='PiNGround/Timer/msec';
    DropLengthValue='PiNGround/Shadow/Length';
    isChangeSizeDefine='PiNGround/ChangeSize/isChangeSize';
    ChangeSizeWidthValue='PiNGround/ChangeSize/Width';
    ChangeSizeHeightValue='PiNGround/ChangeSize/Height';
    RoundValue='PiNGround/Round/Radian';
    xPosPath='PiNGround/window/x';
    yPosPath='PiNGround/window/y';
    xWidthPath='PiNGround/window/width';
    yHeightPath='PiNGround/window/height';
VAR
    cfg: TXMLConfig;
    xWidth,yHeight,xPos,yPos:INTEGER;

    GSVClass:GraphRounderClass;
    hwndFrame,hwndTB:HWND;

PROCEDURE LoadCfg;
VAR
    St:string;
    aSWP:swp;
    CfgPath:string;
BEGIN
    WinQueryWindowPos(HWND_DESKTOP, aSWP);

    xWidth:=(aSWP.cx div 2) +1;
    yHeight:=(aSWP.cy div 2) ;
    xPos:=(aSWP.x) ;
    yPos:=(aSWP.y+aSWP.cy -yHeight) ;


    cfgPath:=ExtractFilePath(ParamStr(0))+XMLConfName;
    cfg:=TXMLConfig.Create(cfgPath);
    St:=cfg.GetValue(ColorValue,IntToStr($FFFFFF));
    TRY
        GSVClass.DlgParam.BkCol:=UColorToRGB(StrToInt(St));
    EXCEPT
        GSVClass.DlgParam.BkCol:=UColorToRGB($FFFFFF);
    END;
    xPos:=cfg.GetValueInteger(xPosPath,xPos);
    yPos:=cfg.GetValueInteger(yPosPath,yPos);
    xWidth:=cfg.GetValueInteger(xWidthPath,xWidth);
    yHeight:=cfg.GetValueInteger(yHeightPath,yHeight);
    GSVClass.DlgParam.DropBkCol:=
        UColorToRGB(cfg.GetValueInteger(ShadowValue,$808080));
    GSVClass.DlgParam.RoundRadian:=cfg.GetValueInteger(RoundValue,20);
    GSVClass.DlgParam.DropLength:=cfg.GetValueInteger(DropLengthValue,20);
    GSVClass.DlgParam.isChangeSize:=cfg.GetValueBool(isChangeSizeDefine,FALSE);
    GSVClass.DlgParam.ChangeSizeWidth:=cfg.GetValueInteger(ChangeSizeWidthValue,120);
    GSVClass.TimerSec:=cfg.GetValueInteger(TimerValue,500);
    cfg.Free;
END;

PROCEDURE SaveCfg;
VAR
    swap:Swp;
    cfgPath:string;
BEGIN
    IF GSVClass.isAuto THEN BEGIN
        GSVClass.MakeWebPage(DefaultColum)
    END;

    cfgPath:=ExtractFilePath(ParamStr(0))+XMLConfName;
    WinQueryWindowPos(hwndFrame,swap);
    xPos:=swap.x;
    yPos:=swap.y;
    xWidth:=swap.cx;
    yHeight:=swap.cy;

    cfg:=TXMLConfig.Create(cfgPath);
    cfg.SetValue(ColorValue,
                 '$'+IntToHex(RGBToUColor(GSVClass.DlgParam.BkCol),8) );
    cfg.SetValue(ShadowValue,
                 '$'+IntToHex(RGBToUColor(GSVClass.DlgParam.DropBkCol),8));
    cfg.SetValueInteger(RoundValue,GSVClass.DlgParam.RoundRadian);
    cfg.SetValueInteger(DropLengthValue,GSVClass.DlgParam.DropLength);
    cfg.SetValueInteger(xPosPath,xPos);
    cfg.SetValueInteger(yPosPath,yPos);
    cfg.SetValueInteger(xWidthPath,xWidth);
    cfg.SetValueInteger(yHeightPath,yHeight);
    cfg.SetValueBool(isChangeSizeDefine,GSVClass.DlgParam.isChangeSize);
    cfg.SetValueInteger(ChangeSizeWidthValue,
                        GSVClass.DlgParam.ChangeSizeWidth);
    cfg.SetValueInteger(TimerValue,GSVClass.TimerSec);
    cfg.Free;
END;


FUNCTION  LoadToDraw(GsvCls:POINTER ):LONGINT;
VAR
    GSVClass:GraphRounderClass;
    rc:bool;
BEGIN
    GSVClass:=GraphRounderClass(GsvCls);
    GSVClass.LoadFile;
    GSVClass.MakeRender(GSVClass.DlgParam.DropLength,
                        GSVClass.DlgParam.RoundRadian);
    GSVClass.PiNGFileSave(GSVClass.GetCurPathName+
                            PNGThumPath+'\'+
                            GSVClass.GetCurPNGFileName);
    rc:=WinPostMsg(GSVClass.hwndPane,WM_EndThread,0,0);
END;

constructor GraphRounderClass.Create;
BEGIN
    inherited Create;
    xEdge:=0;yEdge:=0;
    hwndPane:=NullHandle;
    DlgParam.isMakeRound:=TRUE;
    isAuto:=FALSE;
    isSave:=FALSE;
    ParamList:=TList.Create;
    DlgParam.isChangeSize:=FALSE;
    pChangeSizeBMP:=NIL;
END;

FUNCTION GraphRounderClass.GetBgColorText:string;
BEGIN
    result:='#'+IntToHex(RGBToUColor(DlgParam.BkCol),6);
END;

PROCEDURE GraphRounderClass.SetPaneSize(x,y:INTEGER);
BEGIN
    cx:=x;
    cy:=y;
END;

PROCEDURE GraphRounderClass.CalcFitScale;
VAR
    rect:RectL;
BEGIN
    IF isFitWindow=FALSE THEN
        EXIT;
    IF hwndPane=NullHandle THEN BEGIN
        rect.xLeft:=0;rect.yTop:=480;
        rect.xRight:=640;rect.yBottom:=0;
    END
    ELSE
        WinQueryWindowRect(hwndPane,rect);
    xEdge:=0;
    yEdge:=0;
    FitWindow(rect);
END;

PROCEDURE GraphRounderClass.CreateScroll(window:hwnd);
BEGIN
    HwndVScrol:=WinWindowFromID(WinQueryWindow(Window,QW_PARENT),
                                FID_VERTSCROLL);
    HwndHScrol:=WinWindowFromID(WinQueryWindow(Window, QW_PARENT),
                                FID_HORZSCROLL);
END;

PROCEDURE GraphRounderClass.SetScroll;
BEGIN
    IF pBMPBody^.sCy<=Cy THEN BEGIN
        WinEnableWindow( hwndVScrol, FALSE );
        yEdge:=0;
    END
    ELSE BEGIN
        WinEnableWindow( hwndVScrol, TRUE);
        WinSendMsg( hwndVScrol,
                    SBM_SETSCROLLBAR,
                    MPFROM2SHORT(0, 0),
                    MPFROM2SHORT(0, pBMPBody^.sCy-Cy) );
        WinSendMsg( hwndVScrol,
                    SBM_SETTHUMBSIZE,
                    MPFROM2SHORT(Cy,pBMPBody^.sCy),
                    MPFROM2SHORT(0, 0) );
        WinSendMsg( hwndVScrol,
                    SBM_SETPOS,
                    MPFROMSHORT((pBMPBody^.sCy-Cy) div 2 +yEdge),
                    0);
    END;
    IF pBMPBody^.sCx<=Cx THEN BEGIN
        WinEnableWindow( hwndHScrol, FALSE );
        xEdge:=0;
    END
    ELSE BEGIN
        WinEnableWindow( hwndHScrol, true);
        WinSendMsg( hwndHScrol,
                    SBM_SETSCROLLBAR,
                    MPFROM2SHORT(0, 0),
                    MPFROM2SHORT(0, pBMPBody^.sCx-Cx) );
        WinSendMsg( hwndHScrol,
                    SBM_SETTHUMBSIZE,
                    MPFROM2SHORT(Cx,pBMPBody^.sCx),
                    MPFROM2SHORT(0, 0) );
        WinSendMsg( hwndHScrol,
                    SBM_SETPOS,
                    MPFROMSHORT((pBMPBody^.sCx-Cx) div 2+xEdge),
                    0);
    END;
END;

FUNCTION GraphRounderClass.CalcEdge:RectL;
VAR
    xDif,yDif:INTEGER;
    DrawRect:RectL;
BEGIN
    DrawRect:=GetDrawRect;
    xDif:=(Cx-DrawRect.xRight) div 2+xEdge;
    Inc(DrawRect.xRight,xDif);
    inc(DrawRect.xLeft,xDif);
    yDif:=(Cy-DrawRect.yTop) div 2+yEdge;
    Inc(DrawRect.yTop,yDif);
    Inc(DrawRect.yBottom,yDif);
    CalcEdge:=DrawRect;
END;

PROCEDURE GraphRounderClass.RedrawMsg;
BEGIN
    WinInvalidateRect(hwndPane,NIL,FALSE);
END;

FUNCTION GraphRounderClass.isArgEmpty:BOOLEAN;
BEGIN
    IF GetCount>0 THEN isArgEmpty:=FALSE ELSE isArgEmpty:=TRUE
END;

FUNCTION GraphRounderClass.GetStatusStr:string;
BEGIN
    GetStatusStr:='GSV:'+FileName+'   '+
                  IntToStr(NameIndex+1)+'/'+IntToStr(GetCount)+
                  ' scale('+IntToStr(Scale)+'%)'+#0;
END;

PROCEDURE GraphRounderClass.CopyToOrg;
VAR
    TargSize:INTEGER;
BEGIN
    TargSize:=GetBMPSize(pBMPBody^.bmpCx,pBMPBody^.bmpCy);
    GetMem(pOrgBitmap,TargSize);
    Move(pBMPBody^,pOrgBitmap^,TargSize);
END;

FUNCTION GraphRounderClass.GetOrgWidth:INTEGER;
BEGIN
    IF DlgParam.isChangeSize THEN
        result:=DlgParam.ChangeSizeWidth
    ELSE
        result:=OrgWidth;
END;

FUNCTION GraphRounderClass.GetOrgHeight:INTEGER;
BEGIN
    IF DlgParam.isChangeSize THEN
        result:=DlgParam.ChangeSizeHeight
    ELSE
        result:=pOrgBitmap^.bmpCy;
END;

PROCEDURE GraphRounderClass.SetChangeSizeHeader(x,y:INTEGER);
VAR
    TargetSize:INTEGER;
BEGIN
    DlgParam.ChangeSizeWidth:=((DlgParam.ChangeSizeWidth+3)div 4)*4;
    DlgParam.ChangeSizeHeight:=((DlgParam.ChangeSizeHeight+3)div 4)*4;
    TargetSize:=GetBMPSize(x,y);

    IF pChangeSizeBMP=NIL THEN
        GetMem(pChangeSizeBMP,TargetSize)
    ELSE
        ReAllocMem(pChangeSizeBMP,TargetSize);
    FillChar(pChangeSizeBMP^,TargetSize,0);
    WITH pChangeSizeBMP^.InfoHeader2 DO BEGIN
        cbFix:=sizeof( BITMAPINFOHEADER2 );
        cx:=x;
        cy:=y;
        cPlanes:=1;
        cBitCount:=24;
        cbImage:=(x*y)*3;
        cclrused:=0;
        cclrImportant:=0;
    END;
    pChangeSizeBMP^.bmpCx:=x;
    pChangeSizeBMP^.bmpCy:=y;
    pChangeSizeBMP.cbSize:=TargetSize;
END;

PROCEDURE GraphRounderClass.CopyFromChangeSize(x,y,r:INTEGER);
VAR
    xScale,yScale:INTEGER;
    cx,cy,cc,d:INTEGER;
    RY,RX:INTEGER;
    OY,OX:INTEGER;
    OrgWidth,OrgHeight,CurWidth,CurHeight:INTEGER;
    FUNCTION GetRoundX(R,Y:INTEGER):INTEGER;
    BEGIN
        result:=TRUNC(SQRT(R*R-Y*Y));
    END;
BEGIN
    OrgWidth:=pOrgBitmap^.bmpCx;
    OrgHeight:=pOrgBitmap^.bmpCy;

    CurWidth:=pBMPBody^.bmpCx;
    CurHeight:=pBMPBody^.bmpCy;

    xScale:=(OrgWidth  *10) div DlgParam.ChangeSizeWidth;
    yScale:=(OrgHeight *10) div DlgParam.ChangeSizeHeight;

    FOR cy:=0 TO r-1 DO BEGIN
        RY:=(cy+y)*CurWidth*3;
        OY:=(cy*yScale div 10 )*OrgWidth*3;
        d:=R-GetRoundX(R,R-cy);
        FOR cx:=d TO DlgParam.ChangeSizeWidth-1-d DO BEGIN
            OX:=(cx*xScale div 10)*3;
            FOR cc:=0 TO 2 DO BEGIN
                pBMPBody^.rg[RY+(cx+x)*3+cc]:=pOrgBitmap^.rg[OY+OX+cc];
            END;
        END;
    END;

    FOR cy:=r TO DlgParam.ChangeSizeHeight-r DO BEGIN
        RY:=(cy+y)*CurWidth*3;
        OY:=(cy*yScale div 10 )*OrgWidth*3;
        FOR cx:=0 TO DlgParam.ChangeSizeWidth -1  DO BEGIN
            OX:=(cx*xScale div 10)*3;
            FOR cc:=0 TO 2 DO BEGIN
                pBMPBody^.rg[RY+(cx+x)*3+cc]:=pOrgBitmap^.rg[OY+OX+cc];
            END;
        END;
    END;

    FOR cy:=DlgParam.ChangeSizeHeight-r+1 TO DlgParam.ChangeSizeHeight DO BEGIN
        RY:=(cy+y)*CurWidth*3;
        OY:=(cy*yScale div 10)*OrgWidth*3;
        d:=R-GetRoundX(R,cy-DlgParam.ChangeSizeHeight+r-1);
        FOR cx:=d TO DlgParam.ChangeSizeWidth-1-d DO BEGIN
            OX:=(cx*xScale div 10)*3;
            FOR cc:=0 TO 2 DO BEGIN
                pBMPBody^.rg[RY+(cx+x)*3+cc]:=pOrgBitmap^.rg[OY+OX+cc];
            END;
        END;
    END;

END;


PROCEDURE GraphRounderClass.MakePaneLarge(enLargeSize:INTEGER);
VAR
    cx,cy,ox,oy,px,py:INTEGER;
BEGIN
    enLargeSize:=((enLargeSize+3) div 4)*4;
    ox:=pBMPBody^.bmpCx;
    oy:=pBMPBody^.bmpCy;
    cx:=pBMPBody^.bmpCx+enLargeSize;
    cy:=pBMPBody^.bmpCy+enLargeSize;
    ReAlloc(cx,cy+1); //Defensive . too large but neccesary!
    pBMPBody^.bmpCx:=cx;
    pBMPBody^.bmpCy:=cy;
    pBMPBody^.InfoHeader2.cx:=cx;
    pBMPBody^.InfoHeader2.cy:=cy;

    FOR py:=0 TO cy*3 DO BEGIN
        FOR px:=0 TO cx-1 DO BEGIN
            pBMPBody^.rg[py*cx+px*3+0]:=DlgParam.BkCol.B;
            pBMPBody^.rg[py*cx+px*3+1]:=DlgParam.BkCol.G;
            pBMPBody^.rg[py*cx+px*3+2]:=DlgParam.BkCol.R;
        END;
   END;

END;

PROCEDURE GraphRounderClass.CopyFromOrg;
VAR
    TargSize:INTEGER;
BEGIN
    TargSize:=GetBMPSize(pOrgBitmap^.bmpCx,pOrgBitmap^.bmpCy);
    Move(pOrgBitmap^,pBMPBody^,TargSize);
END;


PROCEDURE GraphRounderClass.MakeRender(DropL,RoundR:INTEGER);
VAR
    wRect:RectL;
    OrgHeight:INTEGER;
    Width,Height:INTEGER;
    ix,iy:INTEGER;
    ShCol:ColorRecord;
    Suffix:INTEGER;

    FUNCTION GetRoundX(R,Y:INTEGER):INTEGER;
    BEGIN
        result:=TRUNC(SQRT(R*R-Y*Y));
    END;
    PROCEDURE MoveFromOrg(xDif,yDif:INTEGER);
    VAR
        ow,cw:INTEGER;
        iy:INTEGER;
    BEGIN
        ow:=pOrgBitmap^.bmpCx;
        cw:=pBMPBody^.bmpCx;
        FOR iy:=0 TO OrgHeight-1 DO BEGIN
            Move(pOrgBitmap^.rg[iy*ow*3],
                 pBMPBody^.rg[((iy+yDif)*cw+xDif)*3],
                 ow*3);
        END;
    END;
    PROCEDURE RoundMoveFromOrg(xDif,yDif:INTEGER);
    VAR
        ow,cw:INTEGER;
        iy:INTEGER;
        r:INTEGER;
    BEGIN
        ow:=pOrgBitmap^.bmpCx;
        cw:=pBMPBody^.bmpCx;
        FOR iy:=0 TO RoundR-1 DO BEGIN
            r:=RoundR-GetRoundX(RoundR,RoundR-iy-1);
            move(pOrgBitmap^.rg[(iy*ow+r)*3],
                 pBMPBody^.rg[((iy+yDif)*cw+r+xDif)*3],
                 (ow-r*2)*3);
        END;
        FOR iy:=RoundR TO OrgHeight-RoundR-1 DO BEGIN
            Move(pOrgBitmap^.rg[iy*ow*3],
                 pBMPBody^.rg[((iy+yDif)*cw+xDif)*3],
                 ow*3);
        END;
        FOR iy:=0 TO RoundR-1 DO BEGIN
            r:=RoundR-GetRoundX(RoundR,iy);
            move(pOrgBitmap^.rg[((OrgHeight-RoundR+iy)*ow+r)*3],
                 pBMPBody^.rg[((OrgHeight-RoundR+iy+yDif)*cw+r+xDif)*3],
                 (ow-r*2)*3);
        END;
    END;
    PROCEDURE SetRGB(Suffix:INTEGER;ColRec:ColorRecord);
    BEGIN
        pBMPBody^.rg[Suffix*3  ]:=ColRec.B;
        pBMPBody^.rg[Suffix*3+1]:=ColRec.G;
        pBMPBOdy^.rg[Suffix*3+2]:=ColRec.R;
    END;

    FUNCTION GetGradient(FgColR,BkColR:ColorRecord;FgCoE:INTEGER):ColorRecord;
    VAR
        fc,bc:INTEGER;
    BEGIN
        IF RoundR>DropL THEN BEGIN
            IF FgCoE <(RoundR-DropL ) THEN BEGIN
                Fc:=RoundR;
                bc:=0;
            END
            ELSE BEGIN
                Fc:=RoundR*RoundR div DropL -(FgCoE*RoundR) div DropL;
                Bc:=RoundR-fc;
            END;
        END
        ELSE BEGIN
            Fc:=RoundR-FgCoE;
            Bc:=RoundR-fc;
        END;
        result.r:=(FgColR.R*Fc+BkColR.R*(bc)) div RoundR;
        result.G:=(FgColR.G*Fc+BkColR.G*(bc)) div RoundR;
        result.B:=(FgColR.B*Fc+BkColR.B*(bc)) div RoundR;
    END;

    PROCEDURE DrawShadow(CoreRect:RectL);
    VAR
        ix,iy:INTEGER;
        distance:INTEGER;
    BEGIN

        FOR iy:=CoreRect.yBottom TO CoreRect.yTop DO BEGIN
            Suffix:=Width*iy;
            FOR ix:=CoreRect.xLeft TO CoreRect.xRight DO BEGIN
                SetRGB((Suffix+ix),DlgParam.DropBkCol);
            END;
        END;

        FOR iy:=0 TO RoundR-1 DO BEGIN
            ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,RoundR-iy-1);
            Suffix:=iy*Width;
            FOR ix:=CoreRect.xLeft TO CoreRect.xRight DO BEGIN
                SetRGB((Suffix+ix),ShCol);
            END;
            Suffix:=(OrgHeight-iy)*Width;
            FOR ix:=CoreRect.xLeft TO CoreRect.xRight DO BEGIN
                SetRGB((Suffix+ix),ShCol);
            END;
        END;
        FOR ix:=0 TO RoundR-1 DO BEGIN
            ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,RoundR-ix-1);
            Suffix:=ix+CoreRect.xLeft-RoundR;
            FOR iy:=CoreRect.yBottom TO CoreRect.yTop DO BEGIN
                SetRGB((Suffix+iy*Width),ShCol);
            END;
            Suffix:=CoreRect.xRight+RoundR-ix;
            FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
                SetRGB((Suffix+iy*Width),ShCol);
            END;
        END;

        FOR ix:=0 TO RoundR-1 DO BEGIN
            FOR iy:=0 TO RoundR-1 DO BEGIN
                distance:=Round(sqrt(ix*ix+iy*iy));
                IF distance+1>RoundR THEN
                    distance:=RoundR-1;
                ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,distance);

                SetRGB(((iy+CoreRect.yTop+1)*Width+CoreRect.xRight+ix+1),ShCol);
                SetRGB(((iy+CoreRect.yTop+1)*Width+CoreRect.xLeft-ix-1),ShCol);
                SetRGB(((CoreRect.yBottom-iy-1)*Width+CoreRect.xLeft-ix-1),ShCol);
                SetRGB(((CoreRect.yBottom-iy-1)*Width+CoreRect.xRight+ix+1),ShCol);
            END;
        END;
    END;
BEGIN
    IF DlgParam.isChangeSize THEN BEGIN
        DlgParam.ChangeSizeHeight:=pOrgBitmap^.bmpCy*DlgParam.ChangeSizeWidth div pOrgBitmap^.bmpCx;
        SetChangeSizeHeader(0,0);
        pBMPBody^.bmpCx:=DlgParam.ChangeSizeWidth;
        pBMPBody^.bmpCy:=DlgParam.ChangeSizeHeight;
    END
    ELSE
        CopyFromOrg;

    IF pBMPBody^.bmpcy div 4<RoundR THEN RoundR:=pBMPBody^.bmpCy div 4;
    IF pBMPBody^.bmpcx div 4<RoundR THEN RoundR:=pBMPBody^.bmpCx div 4;

    MakePaneLarge(abs(DropL));

    Width:= pBMPBody^.bmpCx;
    Height:=pBMPBody^.bmpCy;
    OrgHeight:=GetOrgHeight;


    wRect.xLeft :=DropL+RoundR;
    wRect.xRight:=GetOrgWidth+DropL-RoundR;
    wRect.yTop  :=OrgHeight-RoundR;
    wRect.yBottom:=RoundR;

    FOR iy:=0 TO Height-1 DO BEGIN
        FOR ix:=0 TO Width-1 DO BEGIN
            SetRGB((iy*width+ix),DlgParam.BkCol);
        END;
    END;
    DrawShadow(wRect);


    IF DlgParam.isChangeSize THEN BEGIN
        CopyFromChangeSize(0,DropL,RoundR);
    END
    ELSE BEGIN
        IF DlgParam.isMakeRound THEN
            RoundMoveFromOrg(0,DropL)
        ELSE
            MoveFromOrg(0,DropL);
    END;

END;


PROCEDURE GraphRounderClass.LoadFile;
VAR
    w,h:INTEGER;
BEGIN
    inherited LoadFile;
    CopyToOrg;
    w:=pBMPBody^.bmpCx;
    h:=pBMPBody^.bmpCy;
    SetChangeSizeHeader(w,h);
    DlgParam.XYRatio:=w*1000 div h;
END;


PROCEDURE GraphRounderClass.PushParamList;
VAR
    ParamListCount:INTEGER;
    pRoundParam:^RoundParamRecord;
BEGIN
    NEW(pRoundParam);
    pRoundParam^:=DlgParam;

    ParamListCount:=ParamList.Count;
    IF ParamListCount<1 THEN BEGIN
        ParamList.Add(pRoundParam);
    END
    ELSE IF ParamListCount>=1 THEN BEGIN
        ParamList.Add(pRoundParam);
    END;
END;

FUNCTION GraphRounderClass.GetAnotherParamIndex:INTEGER;
VAR
    CurIndex:INTEGER;
    FUNCTION isParamSame(i:INTEGER):BOOLEAN;
    VAR
      pRoundParam:^RoundParamRecord;
    BEGIN
        pRoundParam:=ParamList[i];
        IF pRoundParam^.isMakeRound<>DlgParam.isMakeRound THEN BEGIN
            result:=FALSE;EXIT;
        END;
        IF isRGBSame(DlgParam.DropBkCol,pRoundParam^.DropBkCol)=FALSE THEN BEGIN
            result:=FALSE;
            EXIT;
        END;
        IF isRGBSame(DlgParam.BkCol,pRoundParam^.BkCol)=FALSE THEN BEGIN
            result:=FALSE;
            EXIT;
        END;
        IF DlgParam.DropLength<>pRoundParam^.DropLength THEN BEGIN
            result:=FALSE;
            EXIT;
        END;
        IF DlgParam.RoundRadian<>pRoundParam^.RoundRadian THEN BEGIN
            result:=FALSE;
            EXIT;
        END;
        IF DlgParam.isChangeSize<>pRoundParam^.isChangeSize THEN BEGIN
            result:=FALSE;
            EXIT;
        END;
        IF DlgParam.ChangeSizeWidth<>pRoundParam^.ChangeSizeWidth THEN BEGIN
            result:=FALSE;
            EXIT;
        END;

        result:=TRUE;
    END;
BEGIN
    CurIndex:=ParamList.Count-1;
    WHILE (CurIndex>=0)AND ( isParamSame(CurIndex)=FALSE) DO Dec(CurIndex);
    result:=CurIndex;
END;

FUNCTION GraphRounderClass.isPrevParam:BOOLEAN;
BEGIN
    IF ParamList.Count>0 THEN BEGIN
        isPrevParam:=TRUE
    END
    ELSE
        isPrevParam:=FALSE;
END;

FUNCTION GraphRounderClass.GetPrevParam:RoundParamRecord;
VAR
    pRoundParam:^RoundParamRecord;
BEGIN
    ParamList.Delete(ParamList.Count-1);
    IF ParamList.Count>0 THEN BEGIN
        pRoundParam:=ParamList[ParamList.Count-1];
        result:=pRoundParam^;
    END;
END;


PROCEDURE GraphRounderClass.DrawScreen(window:hwnd);
VAR
    ps :HPS;
    rect ,DrawRect,CurRect:RectL;
    rc:bool;
    st:string;
BEGIN
    WinQueryWindowRect(Window, rect);
    CurRect:=rect;
    ps:= WinBeginPaint(Window,0,@@rect);
    GpiCreateLogColorTable(ps,
                           lCol_Reset,
                           lColF_RGB,
                           0,
                           0,
                           NIL);
    IF isArgEmpty=FALSE THEN BEGIN
        st:=GetStatusStr;
        WinSetWindowText(hwndFrame,@@st[1]);
        DrawRect:=CalcEdge;
        DrawBitmap(DrawRect,ps);
    END
    ELSE BEGIN
        DrawRect.xLeft:=(CurRect.xRight-CurRect.xLeft) div 8;
        DrawRect.xRight:=DrawRect.xLeft*7;
        DrawRect.yBottom:=(CurRect.yTop-CurRect.yBottom) div 2 ;
        DrawRect.yTop:=DrawRect.yBottom+20;
        WinDrawText(ps,
                    -1,
                    'Drop Picture File or Foloder',
                    DrawRect,
                    CLR_RED,
                    CLR_WHITE,
                    DT_CENTER OR DT_VCenter OR DT_ERASERECT)
    END;
    CurRect:=rect;
    CurRect.yBottom:=DrawRect.yTop-1;
    rc:=WinFillRect(ps, CurRect, RGBToUColor(DlgParam.BkCol));

    CurRect:=rect;
    CurRect.yTop:=DrawRect.yBottom+1;
    rc:=WinFillRect(ps, CurRect, RGBToUColor(DlgParam.BkCol));

    CurRect:=rect;
    CurRect.xLeft:=DrawRect.xRight-1;
    rc:=WinFillRect(ps, CurRect, RGBToUColor(DlgParam.BkCol));

    CurRect:=rect;
    CurRect.xRight:=DrawRect.xLeft+1;
    rc:=WinFillRect(ps, CurRect, RGBToUColor(DlgParam.BkCol));
    WinEndPaint(ps);
END;

VAR
    OldColorProc:FNWP;
FUNCTION DropColorProc( hwndAny : HWnd;
                          ulMsg     : ULong;
                          mp1: MParam;
                          mp2: MParam ) : mResult; cdecl;
VAR
    AttrFound:ULong;
    DropBkCol:ULong;
BEGIN
    IF ulMsg=WM_PRESPARAMCHANGED THEN BEGIN
        result:=OldColorProc(hwndAny,ulMsg,mp1,mp2);
        IF mp1=PP_BackGroundColor THEN BEGIN
            WinQueryPresParam(hwndAny,
                              PP_BackGroundColor,
                              0,
                              @@AttrFound,
                              SizeOf(ULong),
                              @@DropBkCol,
                              qpf_NoInherit);

            GSVClass.DlgParam.DropBkCol:=uColorToRGB(DropBkCol);
        END;
    END
    ELSE
        result:=OldColorProc(hwndAny,ulMsg,mp1,mp2);
END;

VAR
    hwndButton:hwnd;
    hwndUseRoundCheck:hwnd;
    hwndRoundSpin,hwndDropSpin:hwnd;
    hwndChangeSizeYSpin:hwnd;
    hwndChangeSizeCheck:hwnd;

FUNCTION SettingDlgProc( hwndDlg: HWND ;
                            ulMsg  : ULONG;
                            mp1    : MPARAM;
                            mp2    : MPARAM ) : mResult; cdecl;
VAR
    BtBkCol:ULong;
    i:LONGINT;
    UndoParam:RoundParamRecord;
    pCh:ARRAY[0..255] OF CHAR;
    usID          : UShort;
    usNotifyCode  : UShort;
    PROCEDURE GetDlgStatus;
    BEGIN
        GSVClass.DlgParam.isChangeSize:=BOOLEAN(WinSendMsg(hwndChangeSizeCheck,
                                                  BM_QUERYCHECK,
                                                  0,
                                                  0));
        GSVClass.DlgParam.isMakeRound:=BOOLEAN(WinSendMsg(hwndUseRoundCheck,
                                                 BM_QUERYCHECK,
                                                 0,
                                                 0));
        WinSendMsg(hwndRoundSpin,
                   SPBM_QUERYVALUE,
                   MParam(@@i),
                   MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
        GSVClass.DlgParam.RoundRadian:=i;
        WinSendMsg(hwndDropSpin,
                   SPBM_QUERYVALUE,
                   MParam(@@i),
                   MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
        GSVClass.DlgParam.DropLength:=i;

        WinSendMsg(hwndChangeSizeYSpin,
                   SPBM_QUERYVALUE,
                   MParam(@@i),
                   MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
        GSVClass.DlgParam.ChangeSizeWidth:=i;
        WITH GSVClass.DlgParam DO
            ChangeSizeHeight:=ChangeSizeWidth*1000 div XYRatio;

        GSVClass.MakeRender(GSVClass.DlgParam.DropLength,
                            GSVClass.DlgParam.RoundRadian);
        IF GSVClass.DlgParam.isChangeSize THEN BEGIN
            GSVClass.isFitWindow:=FALSE;
            GSVClass.JustScale;
        END;
    END;
    PROCEDURE SetDlgStatus;
    BEGIN
        WinSendMsg( hwndDropSpin,
                    SPBM_SETCURRENTVALUE,
                    MParam(GSVClass.DlgParam.DropLength),
                    MParam(0) );
        WinSendMsg( hwndRoundSpin,
                    SPBM_SETCURRENTVALUE,
                    MParam(GSVClass.DlgParam.RoundRadian),
                    MParam(0) );
        WinSendMsg(hwndChangeSizeCheck,
                   BM_SETCHECK,
                   Ord(GSVClass.DlgParam.isChangeSize),
                   0);
        WinSendMsg(hwndUseRoundCheck,
                   BM_SETCHECK,
                   Ord(GSVClass.DlgParam.isMakeRound),
                   0);
        BtBkCol:=RGBToUColor(GSVClass.DlgParam.DropBkCol);
        WinSetPresParam(hwndButton,PP_BACKGROUNDCOLOR,4,@@BtBkCol);
    END;
BEGIN
    result:=0;
    CASE(ulMsg) OF
        WM_InitDlg:BEGIN
            hwndChangeSizeYSpin:=WinWindowFromID(hwndDlg,IDChangeSizeYSpin);
            hwndChangeSizeCheck:=WinWindowFromID(hwndDlg,IDChangeSizeCheck);
            hwndButton:=WinWindowFromID(hwndDlg,IDColorButton);
            hwndUseRoundCheck:=WinWindowFromID(hwndDlg,IDRoundCheck);
            hwndDropSpin:=WinWindowFromID(hwndDlg,IDDropSpin);
            hwndRoundSpin:=WinWindowFromID(hwndDlg,IDRoundSpin);
            hwndRoundSpin:=WinWindowFromID(hwndDlg,IDRoundSpin);
            IF GSVClass.FileList.Count>0 THEN BEGIN
                WinPostMsg(hwndDlg,WM_InitChangeSpin,0,0);
            END;
            @@OldColorProc:=WinSubClassWindow(hwndButton,DropColorProc);

            WinSendMsg( hwndRoundSpin,SPBM_SETLIMITS,120,0);
            WinSendMsg( hwndDropSpin,SPBM_SETLIMITS,120,0);
            SetDlgStatus;
            WinEnableControl(hwndDlg,IDUndo,FALSE);
        END;
        WM_COMMAND:BEGIN
            CASE Short1FromMP( mp1) OF
                IDRender:BEGIN
                    IF GSVClass.FileList.Count<1 THEN EXIT;
                    GetDlgStatus;
                    GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                    GSVCLass.PushParamList;
                    IF GSVClass.isPrevParam THEN BEGIN
                        WinEnableControl(hwndDlg,IDUndo,true);
                    END;
(*****
                    WinSendDlgItemMsg(hwndDlg,
                                      IDDropOptSpin,
                                      SPBM_QUERYVALUE,
                                      MPFROMP(@@pCh),
                                      MPFROM2SHORT(255,SPBQ_DONOTUPDATE));
********)

                END;
                IDSaveRender:BEGIN
                    GetDlgStatus;
                    GSVClass.isSave:=TRUE;
                    WinSendMsg(GSVClass.hwndPane,WM_SAVESTART,0,0);
                END;
                IDUndo:BEGIN
                    IF GSVClass.isPrevParam =FALSE THEN BEGIN
                        EXIT;
                    END;
                    UndoParam:=GSVClass.GetPrevParam;

                    IF GSVClass.isPrevParam=FALSE THEN BEGIN
                        GSVClass.CopyFromOrg;
                    END
                    ELSE BEGIN
                        GSVClass.DlgParam:=UndoParam;

                        SetDlgStatus;
                        GSVClass.MakeRender(GSVClass.DlgParam.DropLength,
                                            GSVClass.DlgParam.RoundRadian);
                    END;
                    IF GSVClass.DlgParam.isChangeSize THEN BEGIN
                        GSVClass.isFitWindow:=FALSE;
                        GSVClass.JustScale;
                    END;
                    GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                    IF GSVClass.isPrevParam =FALSE THEN
                        WinEnableControl(hwndDlg,IDUndo,FALSE);
                END;
            END;
        END;(**WM_COMMNAD**)
        wm_InitChangeSpin:BEGIN

            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETLIMITS,
                        GSVClass.pOrgBitmap^.bmpCy,
                        1);
            WITH GSVCLass DO BEGIN
                i:=pOrgBitmap^.bmpCy*
                        DlgParam.ChangeSizeWidth div pOrgBitmap^.bmpCx;
                DlgParam.ChangeSizeHeight:=i;
            END;
            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.DlgParam.ChangeSizeWidth),
                        MParam(0) );
        END;
        ELSE BEGIN
           result:=WinDefDlgProc(hwndDlg,ulMsg,mp1,mp2);
        END;
    END;(**case**)
END;

FUNCTION MainClientProc(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
VAR
    St:String;
BEGIN
    result   :=0;
    CASE msg OF
        WM_COMMAND:BEGIN
            CASE SHORT1FROMMP(mp1) OF
                IDB_FIT:BEGIN
                    IF GSVClass.isArgEmpty THEN EXIT;
                    GSVClass.isFitWindow:=TRUE;
                    GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                END;
                IDB_UP:BEGIN
                    IF GSVClass.isArgEmpty THEN
                        EXIT;
                    GSVClass.isFitWindow:=FALSE;
                    GSVClass.UpScale;
                    GSVClass.RedrawMsg;
                    st:=GSVClass.GetStatusStr;
                    WinSetWindowText(hwndFrame,@@st[1]);
                END;
                IDB_DOWN:BEGIN
                    IF GSVClass.isArgEmpty THEN EXIT;
                    GSVClass.isFitWindow:=FALSE;
                    GSVClass.DownScale;
                    GSVClass.RedrawMsg;
                    st:=GSVClass.GetStatusStr;
                    WinSetWindowText(hwndFrame,@@st[1]);
                END;
                IDB_EXIT:BEGIN
                    SaveCfg;
                    WinPostMsg(Window, WM_QUIT, 0, 0);
                END;
                IDB_SHOWDLG  :BEGIN
                    WinSetActiveWindow(HWND_DESKTOP,GSVClass.hwndDlg);
                END;
            END;
        END;
        WM_CLOSE:BEGIN
            SaveCfg;
            WinPostMsg(GSVClass.FrameWindow, WM_QUIT, 0, 0);
        END;
        ELSE BEGIN
            result:=WinDefWindowProc(Window, msg, mp1, mp2);
        END;
    END;
END;


FUNCTION PaneClientProc(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
VAR
    xScroll,yScroll:INTEGER;
BEGIN
    result   :=0;
    CASE msg OF
        wm_vscroll:BEGIN
            IF (GSVClass.pBMPBody^.sCy-GSVCLass.Cy) <=0 THEN
                EXIT;
            CASE SHORT2FROMMP(mp2) OF
                SB_LINEUP:BEGIN
                    Dec(GSVClass.yEdge,5);
                    yScroll:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2
                            + GSVClass.yEdge;
                END;
                SB_LINEDOWN:BEGIN
                    Inc(GSVClass.yEdge,5);
                    yScroll:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2
                            + GSVClass.yEdge;
                END;
                SB_PAGEUP:BEGIN
                    Dec(GSVClass.yEdge,GSVClass.Cy);
                    yScroll:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2
                            + GSVClass.yEdge;

                END;
                SB_PAGEDOWN:BEGIN
                    inc(GSVClass.yEdge,GSVClass.Cy);
                    yScroll:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2
                            + GSVClass.yEdge;
                END;
                SB_SLIDERTRACK,SB_SLIDERPOSITION:BEGIN
                    yScroll:=SHORT1FROMMP(mp2);
                    GSVClass.yEdge:=yScroll-
                                    (GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2;
                END;
            END;
            IF yScroll<0 THEN BEGIN
                yScroll:=0;
                GSVClass.yEdge:=-(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2;
            END;
            IF yScroll>GSVClass.pBMPBody^.sCy-GSVClass.Cy THEN BEGIN
                yScroll:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy);
                GSVClass.yEdge:=(GSVClass.pBMPBody^.sCy-GSVCLass.Cy) div 2;
            END;

            WinSendMsg( GSVClass.HwndVScrol,
                        SBM_SETPOS,
                        MPFROMSHORT(yScroll),
                        0);
            GSVClass.RedrawMsg;
        END;
        wm_hscroll:BEGIN
            IF (GSVClass.pBMPBody^.sCx-GSVCLass.cy) <0 THEN
                EXIT;
            CASE SHORT2FROMMP(mp2) OF
                SB_LINELEFT:BEGIN
                    Dec(GSVClass.xEdge,5);
                END;
                SB_LINERIGHT:BEGIN
                    Inc(GSVClass.xEdge,5);
                END;
                SB_PAGELEFT:BEGIN
                    Dec(GSVClass.xEdge,GSVClass.cy);
                END;
                SB_PAGERIGHT:BEGIN
                    Inc(GSVClass.xEdge,GSVClass.Cx);
                END;
                SB_SLIDERTRACK,SB_SLIDERPOSITION:BEGIN
                    xScroll:=SHORT1FROMMP(mp2);
                    GSVClass.xEdge:=xScroll-
                                    (GSVClass.pBMPBody^.sCx-GSVCLass.Cx) div 2;
                END;
            END;
            xScroll:=(GSVClass.pBMPBody^.sCx-GSVCLass.Cx) div 2 + GSVClass.xEdge;
            IF xScroll<0 THEN BEGIN
                xScroll:=0;
                GSVClass.xEdge:=-(GSVClass.pBMPBody^.sCx-GSVCLass.Cx) div 2;
            END;
            IF xScroll>GSVClass.pBMPBody^.sCx-GSVClass.Cx THEN BEGIN
                xScroll:=(GSVClass.pBMPBody^.sCx-GSVCLass.Cx);
                GSVClass.xEdge:=(GSVClass.pBMPBody^.sCx-GSVCLass.Cx) div 2;
            END;

            WinSendMsg( GSVClass.HwndHScrol,
                        SBM_SETPOS,
                        MPFROMSHORT(xScroll),
                        0);
            GSVClass.RedrawMsg;
        END;
        ELSE
            result:=WinDefWindowProc(Window, msg, mp1, mp2);

    END;
END;


FUNCTION DropToString(mp1,mp2:MParam):string;
VAR
    pChFile,achFile,achPath : ARRAY[0..CCHMAXPATH-1] OF CHAR;
    pdiDrag : PDRAGINFO;
    pdiItem : PDRAGITEM;
BEGIN
    pdiDrag := PVOIDFROMMP(mp1);
    DrgAccessDraginfo( pdiDrag^ );

    pdiItem := DrgQueryDragitemPtr(pdiDrag^, 0);
    DrgQueryStrName(pdiItem^.hstrContainerName,sizeof(achPath),achPath);
    DosQueryPathInfo(achPath,FIL_QUERYFULLNAME,achPath,sizeof(achPath));

    IF (achPath[strlen(achPath)-1] <> '\') THEN strcat(achPath, '\');
    DrgQueryStrName(pdiItem^.hstrSourceName,sizeof(achFile),achFile);
    strcopy( pchFile, achPath );
    strcat( pchFile, achFile );
    result:=StrPas(PchFile);
    WinSendMsg( pdiDrag^.hwndSource,
            DM_ENDCONVERSATION,
            MPFROMLONG(pdiItem^.ulItemID),
            MPFROMLONG(DMFL_TARGETSUCCESSFUL) );

    DrgFreeDraginfo(pdiDrag^);
END;

FUNCTION DrawPaneClientProc(Window:HWnd;Msg:ULong;Mp1,Mp2:MParam):MResult;
VAR
    i:INTEGER;
    st:string;
    AttrFound:ULong;
    ps:hps;
    BkCol:ULong;
    ColTable:ARRAY[0..15]OF ULong;
    PROCEDURE FirstPNGAction;
    BEGIN
        GSVClass.isFitWindow:=FALSE;
                GSVClass.Scale:=100;
                GSVClass.DrawScreen(window);
                GSVClass.MakeRender(GSVClass.DlgParam.DropLength,
                                    GSVClass.DlgParam.RoundRadian);
                CreateDir(GSVClass.GetCurPathName+PNGThumPath);
                GSVClass.PiNGFileSave(GSVClass.GetCurPathName+
                                        PNGThumPath+'\'+
                                        GSVClass.GetCurPNGFileName);
      END;
BEGIN
    result:=0;
    CASE msg OF
        WM_CREATE:BEGIN
            IF GSVClass.isArgEmpty=FALSE THEN BEGIN
                GSVClass.SetFirst;
                GSVClass.LoadFile;
                GSVClass.CalcFitScale;
                IF GSVClass.isAuto THEN BEGIN
                    FirstPNGAction;
                END;
            END;
            GSVClass.CreateScroll(window);
            GSVClass.DrawScreen(window);
            IF GSVClass.isAuto THEN
                WinSendMsg(Window,WM_ENDTHREAD,0,0);
        END;
        WM_PAINT:BEGIN
            GSVClass.DrawScreen(window);
            GSVClass.SetScroll;
        END;
        WM_SIZE:BEGIN
            GSVClass.SetPaneSize(SHORT1FROMMP(mp2),SHORT2FROMMP(mp2));
            IF GSVClass.isArgEmpty=FALSE THEN BEGIN
                GSVClass.CalcFitScale;
                GSVClass.SetScroll;
            END;
        END;
        DM_DRAGOVER:BEGIN
            result:=MRFROM2SHORT(DOR_DROP, DO_MOVE);
        END;
        DM_DROP:BEGIN
            IF GSVClass.isArgEmpty=FALSE THEN BEGIN
                GSVClass.FlushList;
            END;
            St:=DropToString(mp1,mp2);

            GSVClass.EvalArg(St);
            IF GSVClass.isArgEmpty=FALSE THEN BEGIN
                GSVClass.xEdge:=0;
                GSVClass.yEdge:=0;
                GSVClass.SetFirst;
                GSVClass.LoadFile;
                WinSendMsg(GSVClass.hwndDlg,WM_InitChangeSpin,0,0);
                GSVClass.CalcFitScale;
                GSVClass.SetScroll;
            END;
            GSVClass.RedrawMsg;
        END;
        WM_TIMER:BEGIN
            WinStopTimer(GetAnchor,Window,MainTimerID);
            IF GSVClass.isLast=TRUE THEN BEGIN
                SaveCfg;
                IF GSVClass.isSave=FALSE THEN
                    WinSendMsg(GSVClass.FrameWindow,WM_CLOSE,0,0)
                ELSE BEGIN
                    GSVClass.isSave:=FALSE;
                    GSVClass.isAuto:=FALSE;
                END;
            END
            ELSE BEGIN
                GSVClass.SetNext;
                GSVClass.ThreadID:=VPBeginThread(LoadToDraw,20480000,GSVClass);
            END;
        END;
        WM_ENDTHREAD:BEGIN
            DosKillThread(GSVClass.ThreadID);
            IF GSVClass.isFitWindow THEN
                GSVClass.CalcFitScale;
            GSVClass.RedrawMsg;

            IF GSVClass.isAuto THEN BEGIN
                WinStartTimer(GetAnchor,
                              Window,
                              MainTimerID,
                              GSVClass.TimerSec);
            END;
        END;
        WM_SAVESTART:BEGIN
              GSVClass.SetFirst;
              GSVClass.isAuto:=TRUE;
              FirstPNGAction;
              WinSendMsg(Window,WM_ENDTHREAD,0,0);
        END;
        WM_PRESPARAMCHANGED:BEGIN
            IF mp1=PP_BackGroundColor THEN BEGIN
                WinQueryPresParam(Window,
                                  PP_BackGroundColor,
                                  0,
                                  @@AttrFound,
                                  SizeOf(ULong),
                                  @@BkCol,
                                  qpf_NoInherit);
                GSVClass.DlgParam.BkCol:=uColorToRGB(BkCol);
            END;
            GSVClass.RedrawMsg;
        END;
        ELSE
            result:=WinDefWindowProc(Window, msg, mp1, mp2);
    END;
END;

VAR
    mq       :HMQ;
    msg      :QMSG;
    swp      :os2pmapi.SWP;
    St:string;
    Anchor:HAB;
    GetOpt:GetOptClass;

BEGIN
//HALT;
    Anchor:=WinInitialize(0);
    IF Anchor=0 THEN HALT(-1);

    mq:=WinCreateMsgQueue(Anchor, 0);

    IF mq=0 THEN BEGIN
        WinTerminate(Anchor);
        HALT(-2);
    END;

    ToolkitInit(Anchor);

    WinRegisterClass(Anchor,
                     'BitmapPane',
                     DrawPaneClientProc,
                     CS_SIZEREDRAW,
                     sizeof(ULONG));

    WinQueryWindowPos(HWND_DESKTOP, swp);

    GSVClass:=GraphRounderClass.Create;
    LoadCfg;
    GetOpt:=GetOptClass.Create('ac','');
    WHILE GetOpt.isOptEnd=FALSE DO BEGIN
        CASE GetOpt.GetOptCh OF
            'c':BEGIN
                IF GetOpt.isEnd=FALSE THEN BEGIN
                    St:=GetOpt.GetNextArg;
                    TRY
                        DefaultColum:=StrToInt(St);
                    EXCEPT
                        DefaultColum:=5;
                    END;
                END;
            END;
            'a':BEGIN
                IF GetOpt.isEnd =FALSE THEN BEGIN
                    GSVClass.isAuto:=TRUE;
                    GSVClass.EvalArg(GetOpt.GetNextArg);
                END;
            END;
        END;
    END;
    WHILE GetOpt.isEnd=FALSE DO BEGIN
        GSVClass.EvalArg(GetOpt.GetNextArg);
    END;

    hwndFrame:=CreateCell(mainClient, HWND_DESKTOP, 0);
    GSVClass.FrameWindow:=hwndFrame;
    IF hwndFrame<>0 THEN BEGIN
        WinSetWindowPos(hwndFrame,
                        NULLHANDLE,
                        swp.x ,
                        swp.y + swp.cy div 2,
                        (swp.cx div 2),
                        (swp.cy div 2),
                        SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE OR SWP_SHOW);

        hwndTB:=CreateToolbar(hwndFrame,mainTb);

        GSVClass.hwndPane:=CellWindowFromID(hwndFrame, ID_DRAWPANE);
        GSVClass.hwndTitle:=WinWindowFromID(hwndFrame,FID_TITLEBAR);
        GSVClass.hwndSysMenu:=WinWindowFromID(hwndFrame,FID_SYSMENU);
        GSVClass.hwndMinMax:=WinWindowFromID(hwndFrame,FID_MINMAX);
        WinSetWindowPos(hwndFrame,
                        NULLHANDLE,
                        xPos,yPos,xWidth,yHeight,
                        SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE OR SWP_SHOW);
        GSVClass.hwndDlg:=WinLoadDlg( hWND_DESKTOP,
                                      HWND_OBJECT,
                                      SettingDlgProc,
                                      0,
                                      DLGPanel,
                                      NIL);

        // -------------------------------
        WHILE WinGetMsg(Anchor,msg,0,0,0) DO WinDispatchMsg(Anchor,msg);
        // -------------------------------
        WinDestroyWindow(hwndFrame);
    END;

    WinDestroyMsgQueue(mq);
    WinTerminate(Anchor);
END.


VM

{
$Log: GROUND.PAS $
Revision 5.12  2007/07/14 16:22:47  Average
OfBG[VωB

Revision 5.11  2007/07/11 15:18:49  Average
 ꕔt@@N^

Revision 5.10  2007/07/07 15:55:15  Average
Ƃ肠ƏC

Revision 5.9  2007/07/07 15:20:21  Average
BMP̃TCY߂֐ǉ

Revision 5.8  2007/07/07 15:14:36  Average
UndõoO
ŏ肭Ă̂???

Revision 5.7  2007/07/07 14:46:15  Average
UndõoOC

Revision 5.6  2007/07/07 14:42:18  Average
Oɖ߂

Revision 5.4  2007/07/05 14:07:46  Average
 t@@N^ꍆ

Revision 5.3  2007/07/04 16:12:06  Average
p[^̃Z[u/[hꍞ݂͂߂

Revision 5.2  2007/07/04 16:02:43  Average
Ƃ肠ARender&Save悤

Revision 5.1  2007/07/04 12:44:23  Average
ӂڂASYȂĂڂ

Revision 4.8  2007/07/02 15:50:33  Average
ݒt@@Cǂݏ̏CB

Revision 4.7  2007/07/01 13:16:23  Average
_CAÕfUC

Revision 4.6  2007/07/01 12:59:41  Average
_CAǑ`ς

Revision 4.5  2007/06/27 14:32:59  Average
 ΂΂Weby[W쐬

Revision 4.4  2007/06/26 14:45:58  Average
c̐m߂

Revision 4.3  2007/06/26 14:03:08  Average
 ꉞWeby[W\ł悤

Revision 4.2  2007/06/25 15:49:58  Average
Ƃ肠makeroudȂ̉{͑vɂȂ܂B
ꂩWeby[W̍\z

Revision 4.1  2007/06/25 12:37:11  Average
 WebAo

Revision 3.16  2007/06/23 14:30:59  Average
hbv̋}V

Revision 3.15  2007/06/21 15:23:37  Average
Ƃ肠k肭悤

Revision 3.13  2007/06/20 14:11:33  Average
Ƃ肠TCY̕𓱓

Revision 3.12  2007/06/20 13:41:21  Average
TCYOt@@N^

Revision 3.11  2007/06/19 16:12:12  Average
Ƃ肠Undo莩R?

Revision 3.10  2007/06/19 16:07:42  Average
傱ƃ_CAO𑝂₵܂

Revision 3.9  2007/06/19 14:23:47  Average
PNGt@@C݂̏\

Revision 3.8  2007/06/18 14:08:54  Average
Ƃ蒼

Revision 3.7  2007/06/18 13:59:33  Average
UndoƐm

Revision 3.6  2007/06/17 14:35:06  Average
t@@CɃ_[Ȃl

Revision 3.5  2007/06/17 14:33:38  Average
UndoCvgBǒr[ȂB

Revision 3.4  2007/06/17 14:19:41  Average
ƃt@@N^

Revision 3.3  2007/06/17 14:10:09  Average
_CAOfUCAyUndo
(͂܂)

Revision 3.2  2007/06/17 13:12:39  Average
Ƃ肠t@@N^O

Revision 3.1  2007/06/17 12:40:01  Average
e̕FXɕύXo悤
so[W(ύX͂)

Revision 2.9  2007/06/16 14:36:41  Average
Undo{^񊈐

Revision 2.8  2007/06/16 14:29:41  Average
eƂ̃oOC

Revision 2.7  2007/06/16 13:09:05  Average
傱ƃt@@N^

Revision 2.6  2007/06/16 13:01:52  Average
MakeRoundǂo悤ɂȂ܂

Revision 2.5  2007/06/15 15:42:10  Average
ʎqƂ

Revision 2.4  2007/06/15 15:38:49  Average
܂͉e̊S`

Revision 2.3  2007/06/14 13:33:13  Average
UndõKt܂B

Revision 2.2  2007/06/14 12:38:49  Average
Ƃ肠e𖵏ȂƂ悤

Revision 2.1  2007/06/14 12:29:35  Average
Ɠr

Revision 2.0  2007/06/13 16:06:57  Average
BMPǂݍ݃[`폜

Revision 1.11  2007/06/13 15:28:36  Average
Fۑł悤

Revision 1.10  2007/06/13 15:05:31  Average
J[pbge̐FRg[ł悤

Revision 1.9  2007/06/12 15:44:57  Average
_[_CAO̓oB

Revision 1.8  2007/06/12 15:22:03  Average
Ƃ肠_CAOoB

Revision 1.7  2007/06/09 19:01:04  Average
Ƃ肠bmp4̔{łȂ̏ǉ

Revision 1.6  2007/06/09 15:32:20  Average
lOC

Revision 1.5  2007/06/09 15:00:58  Average
Of[V~ʈȊO

Revision 1.4  2007/06/09 13:36:04  Average
Ehet

Revision 1.3  2007/06/09 05:06:59  Average
t@@Cɏ߂悤

Revision 1.2  2007/06/07 15:56:48  Average
pۂ߂

Revision 1.1  2007/06/06 15:39:17  Average
Initial revision

HWND_OBJECT
@


5.12
log
@OfBG[VωB
@
text
@d1 1
a1 1
(**$Revision: 5.11 $**)
d620 2
a621 8
            IF FgCoE<(DropL-RoundR) THEN BEGIN
                Fc:=RoundR;
                bc:=0;
            END
            ELSE BEGIN
                Fc:=DropL*DropL div RoundR-(FgCoE*DropL) div RoundR;
                Bc:=DropL-fc;
            END;
d1465 4
a1468 1
$Log: ground.pas $
@


5.11
log
@ ꕔt@@N^
@
text
@d1 1
a1 1
(**$Revision: 5.10 $**)
d154 1
a154 1
        PROCEDURE MakeRound2(DropL,RoundR:INTEGER);
d269 2
a270 1
    GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,GSVClass.DlgParam.RoundRadian);
d546 1
a546 1
PROCEDURE GraphRounderClass.MakeRound2(DropL,RoundR:INTEGER);
d604 1
a605 2
    CONST
        sc=5;
d609 9
a617 3
        IF FgCoE >(DropL ) THEN BEGIN
            Fc:=RoundR;
            bc:=0;
d620 8
a627 2
            Fc:=(FgCoE*RoundR) div DropL;
            Bc:=RoundR-fc;
d648 1
a648 1
            ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,iy);
d659 1
a659 1
            ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,ix);
d673 8
a680 14
                IF distance+1>RoundR THEN distance:=RoundR-1;
                ShCol:=GetGradient(DlgParam.DropBkCol,DlgParam.BkCol,RoundR-distance-1);

                SetRGB(((iy+CoreRect.yTop+1)*Width+CoreRect.xRight+ix+1),
                        ShCol);

                SetRGB(((iy+CoreRect.yTop+1)*Width+CoreRect.xLeft-ix-1),
                        ShCol);

                SetRGB(((CoreRect.yBottom-iy-1)*Width+CoreRect.xLeft-ix-1),
                        ShCol);

                SetRGB(((CoreRect.yBottom-iy-1)*Width+CoreRect.xRight+ix+1),
                        ShCol);
d953 1
a953 1
        GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,
d1040 1
a1040 1
                        GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,
d1263 1
a1263 1
                GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,
d1471 4
a1474 1
$Log: GROUND.PAS $
@


5.10
log
@Ƃ肠ƏC
@
text
@d1 1
a1 1
(**$Revision: 5.9 $**)
a187 1
    GetOpt:GetOptClass;
a276 3
VAR
    TargetSize:INTEGER;
    cx,cy:INTEGER;
a513 1
    OrgSize:INTEGER;
a514 1
    OrgSize:=enLargeSize;
d726 1
a726 2
    cx,cy:INTEGER;
    TargetSize:INTEGER;
d730 4
a733 4
    cx:=pBMPBody^.bmpCx;
    cy:=pBMPBody^.bmpCy;
    SetChangeSizeHeader(cx,cy);
    DlgParam.XYRatio:=cx*1000 div cy;
a798 2
VAR
    cIndex:INTEGER;
d954 21
d981 5
a988 2
            hwndButton:=WinWindowFromID(hwndDlg,IDColorButton);
            hwndUseRoundCheck:=WinWindowFromID(hwndDlg,IDRoundCheck);
a989 10
            WinSendMsg(hwndChangeSizeCheck,
                       BM_SETCHECK,
                       Ord(GSVClass.DlgParam.isChangeSize),
                       0);
            WinSendMsg(hwndUseRoundCheck,
                       BM_SETCHECK,
                       Ord(GSVClass.DlgParam.isMakeRound),
                       0);
            BtBkCol:=RGBToUColor(GSVClass.DlgParam.DropBkCol);
            WinSetPresParam(hwndButton,PP_BACKGROUNDCOLOR,4,@@BtBkCol);
a990 1
            hwndRoundSpin:=WinWindowFromID(hwndDlg,IDRoundSpin);
a991 5
            WinSendMsg( hwndRoundSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.DlgParam.RoundRadian),
                        MParam(0) );
            hwndDropSpin:=WinWindowFromID(hwndDlg,IDDropSpin);
d993 1
a993 4
            WinSendMsg( hwndDropSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.DlgParam.DropLength),
                        MParam(0) );
d1032 2
a1033 22
                        WinSendMsg( hwndChangeSizeCheck,
                                    BM_SETCHECK,
                                    Ord(GSVClass.DlgParam.isChangeSize),
                                    0);
                        WinSendMsg(hwndUseRoundCheck,
                                   BM_SETCHECK,
                                   Ord(GSVClass.DlgParam.isMakeRound),
                                   0);
                        BtBkCol:=RGBToUColor(UndoParam.DropBkCol);
                        WinSetPresParam(hwndButton,
                                        PP_BACKGROUNDCOLOR,
                                        4,@@BtBkCol);

                        WinSendMsg( hwndRoundSpin,
                                    SPBM_SETCURRENTVALUE,
                                    MParam(GSVClass.DlgParam.RoundRadian),
                                    MParam(0) );

                        WinSendMsg( hwndDropSpin,
                                    SPBM_SETCURRENTVALUE,
                                    MParam(GSVClass.DlgParam.DropLength),
                                    MParam(0) );
a1071 1
    i:INTEGER;
a1072 4
    aSWP:SWP;
    border:ULong;
    FrameFlag:ULong;
    OldGanmma:extended;
d1252 12
d1273 1
a1273 10
                    GSVClass.isFitWindow:=FALSE;
                    GSVClass.Scale:=100;
                    GSVClass.DrawScreen(window);
                    GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,
                                        GSVClass.DlgParam.RoundRadian);
                    CreateDir(GSVClass.GetCurPathName+PNGThumPath);
                    GSVClass.PiNGFileSave(GSVClass.GetCurPathName+
                                            PNGThumPath+'\'+
                                            GSVClass.GetCurPNGFileName);
//                    GSVClass.PingFileSave(GetCurFileName);
a1342 2
              GSVClass.isFitWindow:=FALSE;
              GSVClass.Scale:=100;
d1345 1
a1345 7
              GSVClass.DrawScreen(window);
              GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,
                                  GSVClass.DlgParam.RoundRadian);
              CreateDir(GSVClass.GetCurPathName+PNGThumPath);
              GSVClass.PiNGFileSave(GSVClass.GetCurPathName+
                                      PNGThumPath+'\'+
                                      GSVClass.GetCurPNGFileName);
d1372 2
a1373 3
    GenericDlgProc : FnWp; // dialog process
    Info:TSearchRec;
    rc:INTEGER;
d1466 3
@


5.9
log
@BMP̃TCY߂֐ǉ
@
text
@d1 1
a1 1
(**$Revision: 5.8 $**)
a114 3
    ColorRecord=RECORD
        R,G,B:BYTE;
    END;
d117 1
a117 1
        DropBkCol,BkCol:ULong;
a131 1
        isRGBColor:BOOLEAN;
a141 1
        FUNCTION UColorToRGB(uCol:ULong):ColorRecord;
a190 1
    BgCol,SdCol:ColorRecord;
d208 6
a213 12
    GSVClass.isRGBColor:=cfg.GetValueBool(isColorDefine,FALSE);
    IF GSVClass.isRGBColor THEN BEGIN
        St:=cfg.GetValue(ColorValue,IntToStr(CLR_WHITE));
        TRY
            GSVClass.DlgParam.BkCol:=StrToInt(St);
        EXCEPT
            GSVClass.DlgParam.BkCol:=CLR_WHITE;
            GSVClass.isRGBColor:=FALSE;
        END;
    END
    ELSE
        GSVClass.DlgParam.BkCol:=CLR_WHITE;
d218 2
a219 9
    IF GSVClass.isRGBColor THEN BEGIN
        BgCol:=GSVClass.uColorToRGB(GSVClass.DlgParam.BkCol);
    END
    ELSE BEGIN
        BgCol.R:=$FF;
        BgCol.G:=$FF;
        BgCol.B:=$FF;
    END;
    GSVClass.DlgParam.DropBkCol:=cfg.GetValueInteger(ShadowValue,$808080);
a225 1
    SdCol:=GSVClass.uColorToRGB(GSVClass.DlgParam.DropBkCol);
d245 4
a248 3
    cfg.SetValueBool(isColorDefine, GSVClass.isRGBColor);
    cfg.SetValue(ColorValue, '$'+IntToHex(GSVClass.DlgParam.BkCol,8) );
    cfg.SetValue(ShadowValue,'$'+IntToHex(GSVClass.DlgParam.DropBkCol,8));
a284 1
    isRGBColor:=FALSE;
d295 1
a295 8
    result:='#'+IntToHex(DlgParam.BkCol,6);
END;

FUNCTION GraphRounderClass.UColorToRGB(uCol:ULong):ColorRecord;
BEGIN
    result.R:=((uCol div 256) div 256)mod 256;
    result.G:=(uCol div 256) mod 256;
    result.B:=uCol mod 256;
d435 1
a435 1
    
d534 3
a536 3
            pBMPBody^.rg[py*cx+px*3+0]:=BgCol.B;
            pBMPBody^.rg[py*cx+px*3+1]:=BgCol.G;
            pBMPBody^.rg[py*cx+px*3+2]:=BgCol.R;
d637 1
a637 1
                SetRGB((Suffix+ix),SdCol);
d642 1
a642 1
            ShCol:=GetGradient(SdCol,BgCol,iy);
d653 1
a653 1
            ShCol:=GetGradient(SdCol,BgCol,ix);
d668 1
a668 1
                ShCol:=GetGradient(SdCol,BgCol,RoundR-distance-1);
d711 1
a711 1
            SetRGB((iy*width+ix),BgCol);
d772 1
a772 1
        IF DlgParam.DropBkCol<>pRoundParam^.DropBkCol THEN BEGIN
d776 1
a776 1
        IF DlgParam.BkCol<>pRoundParam^.BkCol THEN BEGIN
d838 6
a843 8
    IF isRGBColor THEN BEGIN
        GpiCreateLogColorTable(ps,
                               lCol_Reset,
                               lColF_RGB,
                               0,
                               0,
                               NIL);
    END;
d865 1
a865 1
    rc:=WinFillRect(ps, CurRect, DlgParam.BkCol);
d869 1
a869 1
    rc:=WinFillRect(ps, CurRect, DlgParam.BkCol);
d873 1
a873 1
    rc:=WinFillRect(ps, CurRect, DlgParam.BkCol);
d877 1
a877 1
    rc:=WinFillRect(ps, CurRect, DlgParam.BkCol);
d902 1
a902 2
            SdCol:=GSVClass.uColorToRGB(DropBkCol);
            GSVClass.DlgParam.DropBkCol:=DropBkCol;
d983 1
a983 1
            BtBkCol:=SdCol.R*256*256+SdCol.G*256+SdCol.B;
d1044 1
a1044 1
                        SdCol:=GSVClass.uColorToRGB(UndoParam.DropBkCol);
d1047 1
a1047 2
                                        4,@@
                                        UndoParam.DropBkCol);
d1391 1
a1391 2
                GSVClass.isRGBColor:=TRUE;
                GSVClass.DlgParam.BkCol:=BkCol;
d1501 3
@


5.8
log
@UndõoO
ŏ肭Ă̂???
@
text
@d1 1
a1 1
(**$Revision: 5.7 $**)
d434 1
a434 2
    TargSize:=pBMPBody^.bmpCx*pBMPBody^.bmpCy*3+
                SizeOf(bitmapInfoHeader2)+2048+5000;
a436 1

d461 2
a462 1
    TargetSize:=x*y*3+SizeOf(bitmapInfoHeader2)+2048+5000;
d573 1
a573 2
    TargSize:=pOrgBitmap^.bmpCx*pOrgBitmap^.bmpCy*3+
                SizeOf(bitmapInfoHeader2)+2048+5000;
d1533 4
@


5.7
log
@UndõoOC
@
text
@d1 1
a1 1
(**$Revision: 5.6 $**)
d275 2
a276 1
    cfg.SetValueInteger(ChangeSizeWidthValue,GSVClass.DlgParam.ChangeSizeWidth);
a558 1
    pBMPBody^.cbSize:=cx*(cy+1)*3+SizeOf(bitmapInfoHeader2)+2048+5000;
a958 1
    OrgBool:BOOLEAN;
a1000 2
            OrgBool:=GSVClass.DlgParam.isChangeSize;
            GSVClass.DlgParam.isChangeSize:=FALSE;
a1003 1
            GSVClass.DlgParam.isChangeSize:=OrgBool;
d1535 3
@


5.6
log
@Oɖ߂
@
text
@d1 1
a1 1
(**$Revision: 5.4 $**)
a946 1
    isSync:BOOLEAN;
d986 2
a987 2
        WITH GSVClass DO
            DlgParam.ChangeSizeHeight:=DlgParam.ChangeSizeWidth*1000 div DlgParam.XYRatio;
d989 2
a990 1
        GSVClass.MakeRound2(GSVClass.DlgParam.DropLength,GSVClass.DlgParam.RoundRadian);
d995 1
a995 1
         END;
a999 1
            isSync:=FALSE;
a1034 1
            isSync:=TRUE;
d1065 1
a1070 1
                        UndoParam:=GSVClass.GetPrevParam;
a1109 1
            isSync:=FALSE;
d1116 2
a1117 1
                i:=pOrgBitmap^.bmpCy*DlgParam.ChangeSizeWidth div pOrgBitmap^.bmpCx;
a1123 1
            isSync:=TRUE;
d1538 4
a1541 1
$Log: ground.pas $
@


5.5
log
@ UndõObVoOC
@
text
@d947 1
d1000 1
d1005 2
a1006 7
            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETLIMITS,
                        GSVClass.pOrgBitmap^.bmpCy,
                        1);
            WITH GSVCLass DO BEGIN
                i:=pOrgBitmap^.bmpCy*DlgParam.ChangeSizeWidth div pOrgBitmap^.bmpCx;
                DlgParam.ChangeSizeHeight:=i;
a1007 4
            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.DlgParam.ChangeSizeWidth),
                        MParam(0) );
d1036 1
d1067 1
a1067 1
                    UndoParam:=GSVClass.GetPrevParam;
d1072 1
d1111 17
d1541 1
a1541 1
$Log: GROUND.PAS $
@


5.4
log
@ t@@N^ꍆ
@
text
@d1 1
a1 1
(**$Revision: 5.3 $**)
a946 1
    isSync:BOOLEAN;
a998 1
            isSync:=FALSE;
d1003 7
a1009 2
            IF GSVClass.FileList.Count>0 THEN BEGIN
                WinPostMsg(hwndDlg,WM_InitChangeSpin,0,0);
d1011 4
a1042 1
            isSync:=TRUE;
d1073 1
a1073 1

a1077 1
                        UndoParam:=GSVClass.GetPrevParam;
a1115 17
        wm_InitChangeSpin:BEGIN
            isSync:=FALSE;

            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETLIMITS,
                        GSVClass.pOrgBitmap^.bmpCy,
                        1);
            WITH GSVCLass DO BEGIN
                i:=pOrgBitmap^.bmpCy*DlgParam.ChangeSizeWidth div pOrgBitmap^.bmpCx;
                DlgParam.ChangeSizeHeight:=i;
            END;
            WinSendMsg( hwndChangeSizeYSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.DlgParam.ChangeSizeWidth),
                        MParam(0) );
            isSync:=TRUE;
        END;
d1530 3
@


5.3
log
@p[^̃Z[u/[hꍞ݂͂߂
@
text
@d1 1
a1 1
(**$Revision: 5.2 $**)
d124 1
a124 1
        XYRation:LONGINT;
d139 1
a139 6
        isMakeRound:BOOLEAN;
        DropBkCol,BkCol:ULong;
        RoundRadian,DropLength:INTEGER;
        isChangeSize:BOOLEAN;
        ChangeSizeWidth,ChangeSizeHeight:LONGINT;
        XYRatio:LONGINT;
d218 1
a218 1
            GSVClass.BkCol:=StrToInt(St);
d220 1
a220 1
            GSVClass.BkCol:=CLR_WHITE;
d225 1
a225 1
        GSVClass.BkCol:=CLR_WHITE;
d231 1
a231 1
        BgCol:=GSVClass.uColorToRGB(GSVClass.BkCol);
d238 5
a242 5
    GSVClass.DropBkCol:=cfg.GetValueInteger(ShadowValue,$808080);
    GSVClass.RoundRadian:=cfg.GetValueInteger(RoundValue,20);
    GSVClass.DropLength:=cfg.GetValueInteger(DropLengthValue,20);
    GSVClass.isChangeSize:=cfg.GetValueBool(isChangeSizeDefine,FALSE);
    GSVClass.ChangeSizeWidth:=cfg.GetValueInteger(ChangeSizeWidthValue,120);
d245 1
a245 1
    SdCol:=GSVClass.uColorToRGB(GSVClass.DropBkCol);
d266 4
a269 4
    cfg.SetValue(ColorValue, '$'+IntToHex(GSVClass.BkCol,8) );
    cfg.SetValue(ShadowValue,'$'+IntToHex(GSVClass.DropBkCol,8));
    cfg.SetValueInteger(RoundValue,GSVClass.RoundRadian);
    cfg.SetValueInteger(DropLengthValue,GSVClass.DropLength);
d274 2
a275 2
    cfg.SetValueBool(isChangeSizeDefine,GSVClass.isChangeSize);
    cfg.SetValueInteger(ChangeSizeWidthValue,GSVClass.ChangeSizeWidth);
d288 1
a288 1
    GSVClass.MakeRound2(GSVClass.DropLength,GSVClass.RoundRadian);
d304 1
a304 1
    isMakeRound:=TRUE;
d308 1
a308 1
    isChangeSize:=FALSE;
d314 1
a314 1
    result:='#'+IntToHex(BkCol,6);
d442 2
a443 2
    IF isChangeSize THEN
        result:=ChangeSizeWidth
d450 2
a451 2
    IF isChangeSize THEN
        result:=ChangeSizeHeight
d460 2
a461 2
    ChangeSizeWidth:=((ChangeSizeWidth+3)div 4)*4;
    ChangeSizeHeight:=((ChangeSizeHeight+3)div 4)*4;
d501 2
a502 2
    xScale:=(OrgWidth  *10) div ChangeSizeWidth;
    yScale:=(OrgHeight *10) div ChangeSizeHeight;
d508 1
a508 1
        FOR cx:=d TO ChangeSizeWidth-1-d DO BEGIN
d516 1
a516 1
    FOR cy:=r TO ChangeSizeHeight-r DO BEGIN
d519 1
a519 1
        FOR cx:=0 TO ChangeSizeWidth -1  DO BEGIN
d527 1
a527 1
    FOR cy:=ChangeSizeHeight-r+1 TO ChangeSizeHeight DO BEGIN
d530 2
a531 2
        d:=R-GetRoundX(R,cy-ChangeSizeHeight+r-1);
        FOR cx:=d TO ChangeSizeWidth-1-d DO BEGIN
d714 2
a715 2
    IF isChangeSize THEN BEGIN
        ChangeSizeHeight:=pOrgBitmap^.bmpCy*ChangeSizeWidth div pOrgBitmap^.bmpCx;
d717 2
a718 2
        pBMPBody^.bmpCx:=ChangeSizeWidth;
        pBMPBody^.bmpCy:=ChangeSizeHeight;
d746 1
a746 1
    IF isChangeSize THEN BEGIN
d750 1
a750 1
        IF isMakeRound THEN
d769 1
a769 1
    XYRatio:=cx*1000 div cy;
d779 1
a779 5
    pRoundParam^.isMakeRound:=isMakeRound;
    pRoundParam^.DropBkCol:=DropBkCol;
    pRoundParam^.BkCol:=BkCol;
    pRoundParam^.DropLength:=DropLength;
    pRoundParam^.RoundRadian:=RoundRadian;
d798 1
a798 1
        IF isMakeRound<>pRoundParam^.isMakeRound THEN BEGIN
d801 9
a809 1
        IF DropBkCol<>pRoundParam^.DropBkCol THEN BEGIN
d813 1
a813 1
        IF BkCol<>pRoundParam^.BkCol THEN BEGIN
d817 1
a817 1
        IF DropLength<>pRoundParam^.DropLength THEN BEGIN
d821 1
a821 1
        IF RoundRadian<>pRoundParam^.RoundRadian THEN BEGIN
d825 1
d852 1
a852 5
        result.isMakeRound:=pRoundParam^.isMakeRound;
        result.DropBkCol:=pRoundParam^.DropBkCol;
        result.BkCol:=pRoundParam^.BkCol;
        result.DropLength:=pRoundParam^.DropLength;
        result.RoundRadian:=pRoundParam^.RoundRadian;
d896 1
a896 1
    rc:=WinFillRect(ps, CurRect, BkCol);
d900 1
a900 1
    rc:=WinFillRect(ps, CurRect, BkCol);
d904 1
a904 1
    rc:=WinFillRect(ps, CurRect, BkCOl);
d908 1
a908 1
    rc:=WinFillRect(ps, CurRect, BkCOl);
d934 1
a934 1
            GSVClass.DropBkCol:=DropBkCol;
d963 1
a963 1
        GSVClass.isChangeSize:=BOOLEAN(WinSendMsg(hwndChangeSizeCheck,
d967 1
a967 1
        GSVClass.isMakeRound:=BOOLEAN(WinSendMsg(hwndUseRoundCheck,
d975 1
a975 1
        GSVClass.RoundRadian:=i;
d980 1
a980 1
        GSVClass.DropLength:=i;
d986 1
a986 1
        GSVClass.ChangeSizeWidth:=i;
d988 1
a988 1
            ChangeSizeHeight:=ChangeSizeWidth*1000 div XYRatio;
d990 2
a991 2
        GSVClass.MakeRound2(GSVClass.DropLength,GSVClass.RoundRadian);
        IF GSVClass.isChangeSize THEN BEGIN
d1003 2
a1004 2
            OrgBool:=GSVClass.isChangeSize;
            GSVClass.isChangeSize:=FALSE;
d1008 1
a1008 1
            GSVClass.isChangeSize:=OrgBool;
d1014 1
a1014 1
                       Ord(GSVClass.isChangeSize),
d1018 1
a1018 1
                       Ord(GSVClass.isMakeRound),
d1027 1
a1027 1
                        MParam(GSVClass.RoundRadian),
d1033 1
a1033 1
                        MParam(GSVClass.DropLength),
d1072 2
a1073 1
                        GSVClass.isChangeSize:=UndoParam.isChangeSize;
d1076 1
a1076 1
                                    Ord(GSVClass.isChangeSize),
a1077 2

                        GSVClass.isMakeRound:=UndoParam.isMakeRound;
d1080 1
a1080 1
                                   Ord(GSVClass.isMakeRound),
a1081 2

                        GSVClass.DropBkCol:=UndoParam.DropBkCol;
a1087 1
                        GSVClass.RoundRadian:=UndoParam.RoundRadian;
d1090 1
a1090 1
                                    MParam(GSVClass.RoundRadian),
a1092 1
                        GSVClass.DropLength:=UndoParam.DropLength;
d1095 1
a1095 1
                                    MParam(GSVClass.DropLength),
d1097 2
a1098 2
                        GSVClass.MakeRound2(GSVClass.DropLength,
                                            GSVClass.RoundRadian);
d1100 1
a1100 1
                    IF GSVClass.isChangeSize THEN BEGIN
d1119 2
a1120 2
                i:=pOrgBitmap^.bmpCy*ChangeSizeWidth div pOrgBitmap^.bmpCx;
                ChangeSizeHeight:=i;
d1124 1
a1124 1
                        MParam(GSVClass.ChangeSizeWidth),
d1333 2
a1334 2
                    GSVClass.MakeRound2(GSVClass.DropLength,
                                        GSVClass.RoundRadian);
d1414 2
a1415 2
              GSVClass.MakeRound2(GSVClass.DropLength,
                                  GSVClass.RoundRadian);
d1432 1
a1432 1
                GSVClass.BkCol:=BkCol;
d1542 3
@


5.2
log
@Ƃ肠ARender&Save悤
@
text
@d1 1
a1 1
(**$Revision: 5.1 $**)
d107 3
a109 3
      mainTb:TbDef = (lType:TB_VERTICAL OR TB_ATTACHED_BT OR TB_BUBBLE ;
                      ulID:ID_TOOLBAR;
                      tbItems:@@mainItems);
d122 2
a123 1
        isChangeSize,ChangeSizeWidth:INTEGER;
a1071 1
                    UndoParam:=GSVClass.GetPrevParam;
d1076 6
d1551 3
@


5.1
log
@ӂڂASYȂĂڂ
@
text
@d1 1
a1 1
(**$Revision: 4.8 $**)
d17 1
d47 1
d146 1
a256 5
    IF (GSVClass.FileList.Count>0) AND
       (GSVClass.isPrevParam) AND
       (GSVClass.isAuto=FALSE)
    THEN
        GSVClass.PingFileSave(PNGWriteName);
d310 1
d644 1
a644 1
        sc=1;
d648 1
a648 1
        IF FgCoE >(RoundR div sc ) THEN BEGIN
d653 1
a653 1
            Fc:=FgCoE*SC;
d699 3
a701 3
                distance:=Round(sqrt(sqr(ix)+sqr(iy)));
                IF distance>RoundR THEN distance:=RoundR;
                ShCol:=GetGradient(SdCol,BgCol,RoundR-distance);
d964 35
d1045 1
a1045 35
                    GSVClass.isChangeSize:=
                        BOOLEAN(WinSendMsg(hwndChangeSizeCheck,
                                           BM_QUERYCHECK,
                                           0,
                                           0));
                    GSVClass.isMakeRound:=
                        BOOLEAN(WinSendMsg(hwndUseRoundCheck,
                                           BM_QUERYCHECK,
                                           0,
                                           0));
                    WinSendMsg(hwndRoundSpin,
                               SPBM_QUERYVALUE,
                               MParam(@@i),
                               MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                    GSVClass.RoundRadian:=i;
                    WinSendMsg(hwndDropSpin,
                               SPBM_QUERYVALUE,
                               MParam(@@i),
                               MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                    GSVClass.DropLength:=i;

                    WinSendMsg(hwndChangeSizeYSpin,
                               SPBM_QUERYVALUE,
                               MParam(@@i),
                               MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                    GSVClass.ChangeSizeWidth:=i;
                    GSVClass.ChangeSizeHeight:=
                        GSVClass.ChangeSizeWidth*1000 div GSVClass.XYRatio;

                    GSVClass.MakeRound2(GSVClass.DropLength,
                                        GSVClass.RoundRadian);
                    IF GSVClass.isChangeSize THEN BEGIN
                        GSVClass.isFitWindow:=FALSE;
                        GSVClass.JustScale;
                    END;
d1061 5
a1065 1

d1383 2
a1384 2
           WinStopTimer(GetAnchor,Window,MainTimerID);
           IF GSVClass.isLast=TRUE THEN BEGIN
d1386 11
a1396 4
                WinSendMsg(GSVClass.FrameWindow,WM_CLOSE,0,0);
           END;
           GSVClass.SetNext;
           GSVClass.ThreadID := VPBeginThread(LoadToDraw,20480000,GSVClass);
d1411 14
d1545 3
@


4.8
log
@ݒt@@Cǂݏ̏CB
@
text
@d1 1
a1 1
(**$Revision: 4.7 $**)
d1520 3
@


4.7
log
@_CAÕfUC
@
text
@d1 1
a1 1
(**$Revision: 4.6 $**)
a243 1
    GSVClass.ChangeSizeHeight:=cfg.GetValueInteger(ChangeSizeHeightValue,88);
a281 1
    cfg.SetValueInteger(ChangeSizeHeightValue,GSVClass.ChangeSizeHeight);
d644 4
d649 11
a659 3
        result.r:=(FgColR.R*FgCoE+BkColR.R*(RoundR-FgCoe)) div RoundR;
        result.G:=(FgColR.G*FgCoE+BkColR.G*(RoundR-FgCoe)) div RoundR;
        result.B:=(FgColR.B*FgCoE+BkColR.B*(RoundR-FgCoe)) div RoundR;
d700 1
a700 1
                distance:=trunc(sqrt(sqr(ix)+sqr(iy)));
d702 1
a702 1
                ShCol:=GetGradient(BgCol,SdCol,distance);
d1123 1
a1123 1
                        MParam(i),
d1520 3
@


4.6
log
@_CAǑ`ς
@
text
@d1 1
a1 1
(**$Revision: 4.5 $**)
d41 1
a41 1
    IDChangeSizeXSpin   =10010;
d120 2
d939 1
a939 1
    hwndChangeSizeXSpin,hwndChangeSizeYSpin:hwnd;
a959 1
            hwndChangeSizeXSpin:=WinWindowFromID(hwndDlg,IDChangeSizeXSpin);
a994 8
(*******
            WinSendDlgItemMsg(hwndDlg,
                              IDDropOptSpin,
                              SPBM_SETARRAY,
                              MPFROMP(@@achDirection),
                              MPFROMSHORT(3));
**********)

a996 42
        WM_CONTROL : BEGIN
            usID := SHORT1FROMMP(mp1);
            usNotifyCode := SHORT2FROMMP(mp1);
            IF isSync=FALSE THEN EXIT;

            IF (( usID=IDChangeSizeYSpin) OR ( usID=IDChangeSizeXSpin) ) THEN
                IF ( usNotifyCode = SPBN_UpArrow) OR
                   ( usNotifyCode = SPBN_DownArrow) OR
                   ( usNotifyCode = SPBN_Change) THEN
                BEGIN
                    isSync:=FALSE;
                    IF usID=IDChangeSizeYSpin THEN BEGIN
                        WinSendMsg(hwndChangeSizeYSpin,
                                   SPBM_QUERYVALUE,
                                   MParam(@@i),
                                   MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                        GSVClass.ChangeSizeHeight:=i;
                        GSVClass.ChangeSizeWidth:=
                            GSVClass.ChangeSizeHeight*GSVClass.XYRatio div 1000;

                        WinSendMsg(hwndChangeSizeXSpin,
                                   SPBM_SETCURRENTVALUE,
                                   MParam(GSVClass.ChangeSizeWidth),
                                   MParam(0));
                    END
                    ELSE BEGIN
                        WinSendMsg(hwndChangeSizeXSpin,
                                   SPBM_QUERYVALUE,
                                   MParam(@@i),
                                   MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                        GSVClass.ChangeSizeWidth:=i;
                        GSVClass.ChangeSizeHeight:=
                            GSVClass.ChangeSizeWidth*1000 div GSVClass.XYRatio;

                        WinSendMsg(hwndChangeSizeYSpin,
                                   SPBM_SETCURRENTVALUE,
                                   MParam(GSVClass.ChangeSizeHeight),
                                   MParam(0));
                    END;
                    isSync:=TRUE;
                END
        END;
d1021 2
a1022 1
                    WinSendMsg(hwndChangeSizeXSpin,
d1027 2
a1028 5
                    WinSendMsg(hwndChangeSizeYSpin,
                               SPBM_QUERYVALUE,
                               MParam(@@i),
                               MPFROM2SHORT(0,SPBQ_DONOTUPDATE));
                    GSVClass.ChangeSizeHeight:=i;
a1101 8
            WinSendMsg( hwndChangeSizeXSpin,
                        SPBM_SETLIMITS,
                        GSVClass.GetOrgWidth,
                        1);
            WinSendMsg( hwndChangeSizeXSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.ChangeSizeWidth),
                        MParam(0) );
d1105 1
a1105 1
                        GSVClass.GetOrgHeight,
d1510 3
@


4.5
log
@ ΂΂Weby[W쐬
@
text
@d1 1
a1 1
(**$Revision: 4.4 $**)
d14 1
a14 1
    DefaultColum:INTEGER=5;
d170 1
d259 1
a259 1
        GSVClass.MakeWebPage(4)
d286 1
d317 5
a1505 1
                    GSVClass.isRGBColor:=TRUE;
d1508 1
a1508 1
                        GSVClass.BkCol:=StrToInt(St);
d1510 1
a1510 2
                        GSVClass.BkCol:=CLR_WHITE;
                        GSVClass.isRGBColor:=FALSE;
d1517 1
d1569 3
@


4.4
log
@c̐m߂
@
text
@d1 1
a1 1
(**$Revision: 4.3 $**)
d551 1
a551 1
    ReAlloc(cx,cy);
d556 1
a556 1
    pBMPBody^.cbSize:=cx*cy*3+SizeOf(bitmapInfoHeader2)+2048+5000;
d558 1
a558 1
    FOR py:=0 TO (cy-1)*3 DO BEGIN
d1563 3
@


4.3
log
@ ꉞWeby[W\ł悤
@
text
@d1 1
a1 1
(**$Revision: 4.2 $**)
d138 1
a138 1
        ChangeSizeWidth,ChangeSizeHeight:INTEGER;
d701 1
d718 1
d1159 4
a1162 2
            WITH GSVClass DO
                i:=GetOrgHeight*GetOrgWidth div ChangeSizeWidth;
d1563 3
@


4.2
log
@Ƃ肠makeroudȂ̉{͑vɂȂ܂B
ꂩWeby[W̍\z
@
text
@d1 1
a1 1
(**$Revision: 4.1 $**)
d14 1
d143 1
d177 1
d242 1
d252 4
a255 1
    IF (GSVClass.FileList.Count>0) AND (GSVClass.isPrevParam) THEN
d257 3
d281 1
d285 1
a285 1
FUNCTION  LoadCalc(GsvCls:POINTER ):LONGINT;
d293 3
d1147 1
a1147 1
                        44);
d1156 3
a1158 1
                        60);
d1161 1
a1161 1
                        MParam(GSVClass.ChangeSizeHeight),
d1372 4
d1423 1
a1423 1
           GSVClass.ThreadID := VPBeginThread(LoadCalc,20480000,GSVClass);
d1435 1
a1435 1
                              500);
d1559 4
@


4.1
log
@ WebAo
@
text
@d1 1
a1 1
(**$Revision: 3.16 $**)
d15 4
a18 1
    wm_InitChangeSpin=WM_USER+1;
d121 1
a121 1
    GraphScreenClass=CLASS(GraphDataClass)
d141 1
d189 1
a189 1
    GSVClass:GraphScreenClass;
d274 10
d285 1
a285 1
constructor GraphScreenClass.Create;
d301 1
a301 1
FUNCTION GraphScreenClass.UColorToRGB(uCol:ULong):ColorRecord;
d308 1
a308 1
PROCEDURE GraphScreenClass.SetPaneSize(x,y:INTEGER);
d314 1
a314 1
PROCEDURE GraphScreenClass.CalcFitScale;
d331 1
a331 1
PROCEDURE GraphScreenClass.CreateScroll(window:hwnd);
d339 1
a339 1
PROCEDURE GraphScreenClass.SetScroll;
d381 1
a381 1
FUNCTION GraphScreenClass.CalcEdge:RectL;
d396 1
a396 1
PROCEDURE GraphScreenClass.RedrawMsg;
d401 1
a401 1
FUNCTION GraphScreenClass.isArgEmpty:BOOLEAN;
d406 1
a406 1
FUNCTION GraphScreenClass.GetStatusStr:string;
d413 1
a413 1
PROCEDURE GraphScreenClass.CopyToOrg;
d424 1
a424 1
FUNCTION GraphScreenClass.GetOrgWidth:INTEGER;
d432 1
a432 1
FUNCTION GraphScreenClass.GetOrgHeight:INTEGER;
d440 1
a440 1
PROCEDURE GraphScreenClass.SetChangeSizeHeader(x,y:INTEGER);
d467 1
a467 1
PROCEDURE GraphScreenClass.CopyFromChangeSize(x,y,r:INTEGER);
d526 1
a526 1
PROCEDURE GraphScreenClass.MakePaneLarge(enLargeSize:INTEGER);
d554 1
a554 1
PROCEDURE GraphScreenClass.CopyFromOrg;
d564 1
a564 1
PROCEDURE GraphScreenClass.MakeRound2(DropL,RoundR:INTEGER);
d729 1
a729 1
PROCEDURE GraphScreenClass.LoadFile;
d743 1
a743 1
PROCEDURE GraphScreenClass.PushParamList;
d764 1
a764 1
FUNCTION GraphScreenClass.GetAnotherParamIndex:INTEGER;
d799 1
a799 1
FUNCTION GraphScreenClass.isPrevParam:BOOLEAN;
d810 1
a810 1
FUNCTION GraphScreenClass.GetPrevParam:RoundParamRecord;
d826 1
a826 1
PROCEDURE GraphScreenClass.DrawScreen(window:hwnd);
d943 1
d1351 2
d1356 1
a1356 2
                    GSVClass.PingFileSave(PNGWriteName);
                    WinSendMsg(window,WM_CLOSE,0,0);
d1361 2
d1396 22
d1444 2
a1445 1

d1468 1
a1468 1
    GSVClass:=GraphScreenClass.Create;
d1486 3
a1488 1
                GSVClass.isAuto:=TRUE;
d1539 3
@


3.16
log
@hbv̋}V
@
text
@d1 1
a1 1
(**$Revision: 3.15 $**)
d244 3
a246 1
    GSVClass.PingFileSave(PNGWriteName);
d1496 3
@


3.15
log
@Ƃ肠k肭悤
@
text
@d1 1
a1 1
(**$Revision: 3.13 $**)
d15 1
d37 3
a39 3
    IDResizeXSpin   =10010;
    IDResizeYSpin   =10011;
    IDResizeCheck   =10012;
d128 1
a128 1
        pResizeBMP:pBitmapRecord;
d133 3
a135 2
        isResize:BOOLEAN;
        ResizeWidth,ResizeHeight:INTEGER;
d160 2
a161 2
        PROCEDURE SetResizeHeader(x,y:INTEGER);
        PROCEDURE CopyFromResize(x,y,r:INTEGER);
d167 1
a167 1
    XMLConfName:string='grconf.xml';
d172 3
a174 3
    isResizeDefine='PiNGround/Resize/isResize';
    ResizeWidthValue='PiNGround/Resize/Width';
    ResizeHeightValue='PiNGround/Resize/Height';
d232 3
a234 3
    GSVClass.isResize:=cfg.GetValueBool(isResizeDefine,FALSE);
    GSVClass.ResizeWidth:=cfg.GetValueInteger(ResizeWidthValue,120);
    GSVClass.ResizeHeight:=cfg.GetValueInteger(ResizeHeightValue,88);
d262 3
a264 3
    cfg.SetValueBool(isResizeDefine,GSVClass.isResize);
    cfg.SetValueInteger(ResizeWidthValue,GSVClass.ResizeWidth);
    cfg.SetValueInteger(ResizeHeightValue,GSVClass.ResizeHeight);
d281 2
a282 2
    isResize:=FALSE;
    pResizeBMP:=NIL;
d410 2
a411 2
    IF isResize THEN
        result:=ResizeWidth
d418 2
a419 2
    IF isResize THEN
        result:=ResizeHeight
d424 1
a424 1
PROCEDURE GraphScreenClass.SetResizeHeader(x,y:INTEGER);
d428 2
a429 2
    ResizeWidth:=((ResizeWidth+3)div 4)*4;
    ResizeHeight:=((ResizeHeight+3)div 4)*4;
d431 2
a432 2
    IF pResizeBMP=NIL THEN
        GetMem(pResizeBMP,TargetSize)
d434 3
a436 3
        ReAllocMem(pResizeBMP,TargetSize);
    FillChar(pResizeBMP^,TargetSize,0);
    WITH pResizeBMP^.InfoHeader2 DO BEGIN
d446 3
a448 3
    pResizeBMP^.bmpCx:=x;
    pResizeBMP^.bmpCy:=y;
    pResizeBMP.cbSize:=TargetSize;
d451 1
a451 1
PROCEDURE GraphScreenClass.CopyFromResize(x,y,r:INTEGER);
d469 2
a470 2
    xScale:=(OrgWidth  *10) div ResizeWidth;
    yScale:=(OrgHeight *10) div ResizeHeight;
d476 1
a476 1
        FOR cx:=d TO ResizeWidth-1-d DO BEGIN
d484 1
a484 1
    FOR cy:=r TO ResizeHeight-r DO BEGIN
d487 1
a487 1
        FOR cx:=0 TO ResizeWidth -1  DO BEGIN
d495 1
a495 1
    FOR cy:=ResizeHeight-r+1 TO ResizeHeight DO BEGIN
d498 2
a499 2
        d:=R-GetRoundX(R,cy-ResizeHeight+r-1);
        FOR cx:=d TO ResizeWidth-1-d DO BEGIN
d670 4
a673 4
    IF isResize THEN BEGIN
        SetResizeHeader(0,0);
        pBMPBody^.bmpCx:=ResizeWidth;
        pBMPBody^.bmpCy:=ResizeHeight;
d700 2
a701 2
    IF isResize THEN BEGIN
        CopyFromResize(0,DropL,RoundR);
d722 2
a723 1
    SetResizeHeader(cx,cy);
d898 3
a900 2
    hwndResizeXSpin,hwndResizeYSpin:hwnd;
    hwndResizeCheck:hwnd;
d911 3
d918 9
a926 21
            hwndResizeXSpin:=WinWindowFromID(hwndDlg,IDResizeXSpin);
            hwndResizeYSpin:=WinWindowFromID(hwndDlg,IDResizeYSpin);
            hwndResizeCheck:=WinWindowFromID(hwndDlg,IDResizeCheck);
            WinSendMsg( hwndResizeXSpin,
                        SPBM_SETLIMITS,
                        GSVClass.GetOrgWidth,
                        44);
            WinSendMsg( hwndResizeXSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.GetOrgWidth),
                        MParam(0) );

            WinSendMsg( hwndResizeYSpin,
                        SPBM_SETLIMITS,
                        GSVClass.GetOrgHeight,
                        60);
            WinSendMsg( hwndResizeYSpin,
                        SPBM_SETCURRENTVALUE,
                        MParam(GSVClass.GetOrgHeight),
                        MParam(0) );

d930 1
a930 1
            WinSendMsg(hwndResizeCheck,
d932 1
a932 1
                       Ord(GSVClass.isResize),
d962 43
d1010 2
a1011 2
                    GSVClass.isResize:=
                        BOOLEAN(WinSendMsg(hwndResizeCheck,
d1030 1
a1030 1
                    WinSendMsg(hwndResizeXSpin,
d1034 2
a1035 2
                    GSVClass.ResizeWidth:=i;
                    WinSendMsg(hwndResizeYSpin,
d1039 1
a1039 1
                    GSVClass.ResizeHeight:=i;
d1043 1
a1043 1
                    IF GSVClass.isResize THEN BEGIN
d1100 1
a1100 1
                    IF GSVClass.isResize THEN BEGIN
d1111 21
d1370 1
d1494 3
@


3.14
log
@ TƎ蒼
@
text
@a150 1
        FUNCTION WriteBitmap:BOOLEAN;
d158 2
a159 1
        PROCEDURE CopyToResize;
d280 1
d300 2
d405 103
d668 7
a674 1
    CopyFromOrg;
d697 10
a706 4
    IF GSVClass.isMakeRound THEN
        RoundMoveFromOrg(0,DropL)
    ELSE
        MoveFromOrg(0,DropL);
d718 3
a720 20

    cx:=pBMPBody^.bmpCx;cy:=pBMPBody^.bmpCy;
    TargetSize:=cx*cy*3+SizeOf(bitmapInfoHeader2)+2048+5000;
    GetMem(pResizeBMP,TargetSize);
    pResizeBMP.cbSize:=TargetSize;
    FillChar(pResizeBMP^,TargetSize,0);

    WITH pResizeBMP^.InfoHeader2 DO BEGIN
        cbFix:=sizeof( BITMAPINFOHEADER2 );
        cx:=cx;
        cy:=cy;
        cPlanes:=1;
        cBitCount:=24;
        cbImage:=(cx*cy)*3;
        cclrused:=0;
        cclrImportant:=0;
    END;
    pResizeBMP^.bmpCx:=cx;
    pResizeBMP^.bmpCy:=cy;

a722 24
FUNCTION GraphScreenClass.WriteBitmap;
VAR
    B:File;
    BMPSize:INTEGER;
    BFINFO2:BitmapFileHeader2;
    size:INTEGER;
BEGIN
    BFInfo2.usType:=BFT_BMAP;
    BFInfo2.cbSize:=SizeOf(BitmapFileHeader2);
    BFInfo2.Offbits:=SizeOf(BitmapFileHeader2);
    BFInfo2.xHotSpot:=0;
    BFInfo2.yHotSpot:=0;
    BFInfo2.bmp2:=pBMPBody^.Infoheader2;
    size:=SizeOf(BitmapFileHeader2);
    size:=SizeOf(BitmapInfoHeader2);
    Assign(B,'Round.BMP');rewrite(B,1);
    BMPSize:=(pBMPBody^.bmpCx*pBMPBody^.bmpCy)*3;
    IF pBMPBody^.cbSize>BMPSize THEN  BEGIN
        BlockWrite(B,BFInfo2,SizeOf(BitmapFileHeader2));
//        BlockWrite(B,pBMPBody^.PalAry,1023);
        BlockWrite(B,pBMPBody^.rg,BMPSize);
    END;
    Close(b);
END;
a805 20
FUNCTION GraphScreenClass.GetOrgWidth:INTEGER;
BEGIN
    result:=OrgWidth;
END;

FUNCTION GraphScreenClass.GetOrgHeight:INTEGER;
BEGIN
    result:=pOrgBitmap^.bmpCy;
END;

PROCEDURE GraphScreenClass.CopyToResize;
VAR
    xScale,yScale:INTEGER;
    cx,cy:INTEGER;
BEGIN
    ResizeWidth:=((ResizeWidth+3)div 4)*4;
    ResizeHeight:=((ResizeHeight+3)div 4)*4;
    xScale:=GetOrgWidth / ResizeWidth;
    yScale:=GetOrgHeight / ResizeHeight;
END;
d916 1
a916 1
                        GSVClass.ResizeWidth,
d920 1
a920 1
                        MParam(GSVClass.ResizeHeight),
d925 1
a925 1
                        GSVClass.pBMPBody^.bmpCy,
d929 1
a929 1
                        MParam(GSVClass.pBMPBody^.bmpCy),
d1001 1
a1001 1
                    GSVClass.ResizeWidth:=i;
d1005 4
d1062 4
d1273 1
a1273 3
                IF GSVClass.isFitWindow THEN BEGIN
                    GSVClass.CalcFitScale;
                END;
d1292 1
a1292 3
                IF GSVClass.isFitWindow THEN BEGIN
                    GSVClass.CalcFitScale;
                END;
d1311 1
a1311 3
                IF GSVClass.isFitWindow THEN BEGIN
                        GSVClass.CalcFitScale;
                END;
@


3.13
log
@Ƃ肠TCY̕𓱓
@
text
@d1 1
a1 1
(**$Revision: 3.12 $**)
d127 1
d159 1
d268 3
d594 3
d600 20
d621 1
d739 10
d859 2
a860 2
                        GSVClass.pBMPBody^.bmpCx,
                        60);
d863 1
a863 1
                        MParam(GSVClass.pBMPBody^.bmpCx),
d1375 3
@


3.12
log
@TCYOt@@N^
@
text
@d1 1
a1 1
(**$Revision: 3.11 $**)
d131 2
d168 3
d228 3
d258 3
d274 1
d800 1
d817 1
d839 4
d876 5
d896 11
d1336 3
@


3.11
log
@Ƃ肠Undo莩R?
@
text
@d1 1
a1 1
(**$Revision: 3.10 $**)
d154 2
d425 1
a425 1
    RTop,RBottom,LTop,LBottom:PointL;
d431 1
a431 1
    distance:INTEGER;
d488 1
a488 1
    PROCEDURE DrawShadow;
d491 1
a492 4
        LBottom.x:=DropL+RoundR;    LBottom.y:=RoundR;
        LTop:=LBottom;              LTop.y:=OrgHeight-RoundR;
        RBottom:=LBottom;           RBottom.x:=OrgWidth+DropL-RoundR;
        RTop.x:=RBottom.x;          RTop.y:=LTop.y;
d494 1
a494 1
        FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
d496 1
a496 1
            FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
d504 1
a504 1
            FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
d508 1
a508 1
            FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
d514 2
a515 2
            Suffix:=ix+DropL;
            FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
d518 1
a518 1
            Suffix:=OrgWidth+DropL-ix;
d530 2
a531 1
                SetRGB(((iy+RTop.y+1)*Width+RTop.x+ix+1),ShCol);
d533 2
a534 1
                SetRGB(((iy+LTop.y+1)*Width+LTop.x-ix-1),ShCol);
d536 2
a537 1
                SetRGB(((LBottom.y-iy-1)*Width+LBottom.x-ix-1),ShCol);
d539 2
a540 1
                SetRGB(((RBottom.y-iy-1)*Width+RBottom.x+ix+1),ShCol);
d554 6
a559 1
    OrgHeight:=pOrgBitmap^.bmpCy;
d566 1
a566 1
    DrawShadow;
d688 11
d1302 3
@


3.10
log
@傱ƃ_CAO𑝂₵܂
@
text
@d1 1
a1 1
(**$Revision: 3.9 $**)
d658 1
a658 1
    IF ParamList.Count>1 THEN BEGIN
d670 8
a677 6
    pRoundParam:=ParamList[ParamList.Count-1];
    result.isMakeRound:=pRoundParam^.isMakeRound;
    result.DropBkCol:=pRoundParam^.DropBkCol;
    result.BkCol:=pRoundParam^.BkCol;
    result.DropLength:=pRoundParam^.DropLength;
    result.RoundRadian:=pRoundParam^.RoundRadian;
d878 31
a908 26
                    GSVClass.isMakeRound:=UndoParam.isMakeRound;
                    WinSendMsg(hwndUseRoundCheck,
                               BM_SETCHECK,
                               Ord(GSVClass.isMakeRound),
                               0);

                    GSVClass.DropBkCol:=UndoParam.DropBkCol;
                    SdCol:=GSVClass.uColorToRGB(UndoParam.DropBkCol);
                    WinSetPresParam(hwndButton,
                                    PP_BACKGROUNDCOLOR,
                                    4,@@
                                    UndoParam.DropBkCol);

                    GSVClass.RoundRadian:=UndoParam.RoundRadian;
                    WinSendMsg( hwndRoundSpin,
                                SPBM_SETCURRENTVALUE,
                                MParam(GSVClass.RoundRadian),
                                MParam(0) );

                    GSVClass.DropLength:=UndoParam.DropLength;
                    WinSendMsg( hwndDropSpin,
                                SPBM_SETCURRENTVALUE,
                                MParam(GSVClass.DropLength),
                                MParam(0) );
                    GSVClass.MakeRound2(GSVClass.DropLength,
                                        GSVClass.RoundRadian);
d1283 3
@


3.9
log
@PNGt@@C݂̏\
@
text
@d1 1
a1 1
(**$Revision: 3.8 $**)
d36 3
d766 1
d781 20
d824 1
d830 1
a841 6
                    WinSendDlgItemMsg(hwndDlg,
                                      IDDropOptSpin,
                                      SPBM_QUERYVALUE,
                                      MPFROMP(@@pCh),
                                      MPFROM2SHORT(255,SPBQ_DONOTUPDATE));

d860 8
d869 1
d1276 3
@


3.8
log
@Ƃ蒼
@
text
@d1 1
a1 2
{$M 120000000}
(**$Revision: 3.7 $**)
d14 2
d31 7
a37 6
    IDColorButton   =10001;
    IDDropSpin      =10002;
    IDRoundCheck    =10003;
    IDRoundSpin     =10004;
    IDRender        =10100;
    IDUndo          =10101;
d102 1
d119 1
d227 1
a227 1
    GSVClass.WriteBitmap;
d483 1
a483 1
    PROCEDURE DrawShadow(xDif:INTEGER);
d772 1
d800 6
d812 9
a820 1
                        BOOLEAN(WinSendMsg(hwndUseRoundCheck,BM_QUERYCHECK,0,0));
d926 3
d1087 1
a1087 1
                    GSVClass.WriteBitmap;
d1225 6
a1230 6
        WinLoadDlg( hWND_DESKTOP,
                    HWND_OBJECT,
                    SettingDlgProc,
                    0,
                    DLGPanel,
                    NIL);
d1247 3
@


3.7
log
@UndoƐm
@
text
@d2 1
a2 1
(**$Revision: 3.6 $**)
d427 1
a427 1
    PROCEDURE MoveFromOrg(xOffset,yOffset:INTEGER);
d436 1
a436 1
                 pBMPBody^.rg[((iy+yOffset)*cw+xOffset)*3],
d440 1
a440 1
    PROCEDURE RoundMoveFromOrg(xOffset,yOffset:INTEGER);
d451 1
a451 1
                 pBMPBody^.rg[((iy+yOffset)*cw+r+xOffset)*3],
d456 1
a456 1
                 pBMPBody^.rg[((iy+yOffset)*cw+xOffset)*3],
d462 1
a462 1
                 pBMPBody^.rg[((OrgHeight-RoundR+iy+yOffset)*cw+r+xOffset)*3],
d479 1
a479 1
    PROCEDURE DrawShadow;
d1225 3
@


3.6
log
@t@@CɃ_[Ȃl
@
text
@d1 2
a2 1
(**$Revision: 3.5 $**)
d102 3
d127 1
a127 1
        PROCEDURE UColorToRGB(uCol:ULong;VAR r,g,b:BYTE);
d144 1
d169 1
a169 2
    BkColR,BkColG,BkColB:BYTE;
    SdColR,SdColG,SdColB:BYTE;
d204 1
a204 1
        GSVClass.uColorToRGB(GSVClass.BkCol,BkColR,BkColG,BkColB);
d207 3
a209 1
        BkColR:=$FF;BkColG:=$FF;BkColB:=$FF;
d215 1
a215 1
    GSVClass.uColorToRGB(GSVClass.DropBkCol,SdColR,SdColG,SdColB);
d256 1
a256 1
PROCEDURE GraphScreenClass.UColorToRGB(uCol:ULong;VAR r,g,b:BYTE);
d258 3
a260 3
    R:=((uCol div 256) div 256)mod 256;
    G:=(uCol div 256) mod 256;
    B:=uCol mod 256;
d396 3
a398 3
            pBMPBody^.rg[py*cx+px*3+0]:=BkColB;
            pBMPBody^.rg[py*cx+px*3+1]:=BkColG;
            pBMPBody^.rg[py*cx+px*3+2]:=BkColR;
d420 1
a420 1
    ShColR,ShColB,ShColG:BYTE;
d427 1
a427 1
    PROCEDURE MoveFromOrg;
d436 1
a436 1
                 pBMPBody^.rg[(iy+RoundR)*cw*3],
d440 1
a440 1
    PROCEDURE RoundMoveFromOrg;
d451 1
a451 1
                 pBMPBody^.rg[((iy+DropL)*cw+r)*3],
d456 1
a456 1
                 pBMPBody^.rg[(iy+DropL)*cw*3],
d462 1
a462 1
                 pBMPBody^.rg[((OrgHeight+DropL-RoundR+iy)*cw+r)*3],
d466 7
a472 1
    PROCEDURE SetRGB(Suffix:INTEGER;R,G,B:BYTE);
d474 59
a532 3
        pBMPBody^.rg[Suffix*3  ]:=B;
        pBMPBody^.rg[Suffix*3+1]:=G;
        pBMPBOdy^.rg[Suffix*3+2]:=R;
d540 1
a540 1
    MakePaneLarge(DropL);
d548 1
a548 63
            SetRGB((iy*width+ix),BkColR,BkColG,BkColB);
        END;
    END;
    LBottom.x:=DropL+RoundR;    LBottom.y:=RoundR;
    LTop:=LBottom;              LTop.y:=OrgHeight-RoundR;
    RBottom:=LBottom;           RBottom.x:=OrgWidth+DropL-RoundR;
    RTop.x:=RBottom.x;          RTop.y:=LTop.y;

    FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
        Suffix:=Width*iy;
        FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            SetRGB((Suffix+ix),SdColR,SdColG,SdColB);
        END;
    END;

    FOR iy:=0 TO RoundR-1 DO BEGIN
        ShColR:=(BkColR*(RoundR-iy)+SdColR*iy) div RoundR;
        ShColG:=(BkColG*(RoundR-iy)+SdColG*iy) div RoundR;
        ShColB:=(BkColB*(RoundR-iy)+SdColB*iy) div RoundR;
        Suffix:=iy*Width;
        FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            SetRGB((Suffix+ix),ShColR,ShColG,ShColB);
        END;
        Suffix:=(OrgHeight-iy)*Width;
        FOR ix:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            SetRGB((Suffix+ix),ShColR,ShColG,ShColB);
        END;
    END;
    FOR ix:=0 TO RoundR-1 DO BEGIN
        ShColR:=(BkColR*(RoundR-ix)+SdColR*ix) div RoundR;
        ShColG:=(BkColG*(RoundR-ix)+SdColG*ix) div RoundR;
        ShColB:=(BkColB*(RoundR-ix)+SdColB*ix) div RoundR;
        Suffix:=ix+DropL;
        FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
            SetRGB((Suffix+iy*Width),ShColR,ShColG,ShColB);
        END;
        Suffix:=OrgWidth+DropL-ix;
        FOR iy:=RoundR TO OrgHeight-RoundR DO BEGIN
            SetRGB((Suffix+iy*Width),ShColR,ShColG,ShColB);
        END;
    END;

    FOR ix:=0 TO RoundR-1 DO BEGIN
        FOR iy:=0 TO RoundR-1 DO BEGIN
            distance:=trunc(sqrt(sqr(ix)+sqr(iy)));
            IF distance>RoundR THEN distance:=RoundR;
            ShColR:=(BkColR*distance+SdColR*(RoundR-distance) ) div RoundR;
            ShColG:=(BkColG*distance+SdColG*(RoundR-distance) ) div RoundR;
            ShColB:=(BkColB*distance+SdColB*(RoundR-distance) ) div RoundR;

            SetRGB(((iy+RTop.y+1)*Width+RTop.x+ix+1),ShColR,ShColG,ShColB);

            SetRGB(((iy+LTop.y+1)*Width+LTop.x-ix-1),ShColR,ShColG,ShColB);

            SetRGB(((LBottom.y-iy-1)*Width+LBottom.x-ix-1),
                   ShColR,
                   ShColG,
                   ShColB);

            SetRGB(((RBottom.y-iy-1)*Width+RBottom.x+ix+1),
                   ShColR,
                   ShColG,
                   ShColB);
d551 1
d554 1
a554 1
        RoundMoveFromOrg
d556 1
a556 1
        MoveFromOrg;
d612 35
d648 2
d651 1
a651 1
    IF ParamList.Count>0 THEN
d653 1
d662 1
a668 1
    ParamList.Delete(ParamList.Count-1);
d747 1
a747 1
            GSVClass.uColorToRGB(DropBkCol,SdColR,SdColG,SdColB);
d779 1
a779 1
            BtBkCol:=SdColR*256*256+SdColG*256+SdColB;
d823 3
a825 2
                    IF GSVClass.isPrevParam =FALSE THEN
                        WinEnableControl(hwndDlg,IDUndo,FALSE);
d835 1
a835 4
                    GSVClass.uColorToRGB(UndoParam.DropBkCol,
                                         SdColR,
                                         SdColG,
                                         SdColB);
d856 2
d1225 3
@


3.5
log
@UndoCvgBǒr[ȂB
@
text
@d1 1
a1 1
(**$Revision: 3.4 $**)
d754 1
d1180 3
@


3.4
log
@ƃt@@N^
@
text
@d1 1
a1 1
(**$Revision: 3.3 $**)
d601 1
a601 2
        ParamList.Add(ParamList[0]);
        ParamList[0]:=pRoundParam;
d607 1
a607 1
    IF ParamList.Count>1 THEN
d617 1
a617 1
    pRoundParam:=ParamList[2];
d623 1
d722 1
d776 37
d1179 3
@


3.3
log
@_CAOfUCAyUndo
(͂܂)
@
text
@d1 1
a1 1
(**$Revision: 3.2 $**)
d530 13
a542 19
            Suffix:=((iy+RTop.y+1)*Width+RTop.x+ix+1)*3;
            pBMPBody^.rg[Suffix+0]:=ShColB;
            pBMPBody^.rg[Suffix+1]:=ShColG;
            pBMPBody^.rg[Suffix+2]:=SHColR;

            Suffix:=((iy+LTop.y+1)*Width+LTop.x-ix-1)*3;
            pBMPBody^.rg[Suffix+0]:=ShColB;
            pBMPBody^.rg[Suffix+1]:=ShColG;
            pBMPBody^.rg[Suffix+2]:=SHColR;

            Suffix:=((LBottom.y-iy-1)*Width+LBottom.x-ix-1)*3;
            pBMPBody^.rg[Suffix+0]:=ShColB;
            pBMPBody^.rg[Suffix+1]:=ShColG;
            pBMPBody^.rg[Suffix+2]:=SHColR;

            Suffix:=((RBottom.y-iy-1)*Width+RBottom.x+ix+1)*3;
            pBMPBody^.rg[Suffix+0]:=ShColB;
            pBMPBody^.rg[Suffix+1]:=ShColG;
            pBMPBody^.rg[Suffix+2]:=SHColR;
d1141 4
@


3.2
log
@Ƃ肠t@@N^O
@
text
@d1 1
a1 1
(**$Revision: 3.1 $**)
d106 1
a106 1
    
a138 2
    PROTECTED
        ParamList:TList;
d142 2
d601 1
a601 1
    
d607 2
a608 2
        ParamList.Add(ParamList[1]);
        ParamList[1]:=pRoundParam;
d776 1
d1147 3
@


3.1
log
@e̕FXɕύXo悤
so[W(ύX͂)
@
text
@d1 1
a1 1
(**$Revision: 2.9 $**)
d104 1
a104 1
        RaoundRadian,DropLength:INTEGER;
d106 1
d123 1
d141 1
a141 1
        PROCEDURE PushParamList(R,DL:INTEGER;DrCol:ULong;isRound:BOOLEAN);
d143 1
a143 1
        PROCEDURE GetPrevParam(VAR R,DL:INTEGER;VAR DrCol:ULong;VAR isRound:BOOLEAN);
d200 1
a200 3
        BkColR:=((GSVClass.BkCol div 256) div 256)mod 256;
        BkColG:=(GSVClass.BkCol div 256) mod 256;
        BkColB:=GSVClass.BkCol mod 256;
d209 1
a209 3
    SdColR:=((GSVClass.DropBkCol div 256) div 256)mod 256;
    SdColG:=(GSVClass.DropBkCol div 256) mod 256;
    SdColB:=GSVClass.DropBkCol mod 256;
d250 7
a381 1
    CopyFromOrg;
a395 5
    FOR py:=0 TO oy-1 DO BEGIN
        Move(pOrgBitmap^.rg[py*ox*3],
             pBMPBody^.rg[(py+OrgSize)*cx*3],
             OrgWidth*3);
    END;
d590 41
d708 1
a708 3
            SdColR:=((DropBkCol div 256) div 256)mod 256;
            SdColG:=(DropBkCol div 256) mod 256;
            SdColB:=DropBkCol mod 256;
d1146 4
@


2.9
log
@Undo{^񊈐
@
text
@d1 1
a1 1
(**$Revision: 2.8 $**)
d26 1
d83 1
a83 1
      mainItems:ARRAY [0..5] OF TBItemData=(
d89 2
d101 5
a110 2
        OrgSWP:SWP;
        OrgFrameFlag,OrgBorder:ULong;
a113 1
        isFullScreen:BOOLEAN;
d115 1
a117 1
        isAuto:BOOLEAN;
d119 2
a120 1
        CountMakeRound:INTEGER;
d137 5
a246 1
    isFullScreen:=FALSE;
d249 1
a249 1
    CountMakeRound:=0;
d738 1
a738 2
                    Inc(GSVClass.CountMakeRound);
                    IF GSVClass.CountMakeRound>1 THEN BEGIN
d1108 3
@


2.8
log
@eƂ̃oOC
@
text
@d1 1
a1 1
(**$Revision: 2.7 $**)
d114 1
d239 1
d706 1
d728 4
d1099 3
@


2.7
log
@傱ƃt@@N^
@
text
@d1 1
a1 1
(**$Revision: 2.6 $**)
d434 1
a434 1
                 pBMPBody^.rg[((iy+RoundR)*cw+r)*3],
d439 1
a439 1
                 pBMPBody^.rg[(iy+RoundR)*cw*3],
d444 2
a445 2
            move(pOrgBitmap^.rg[((iy+OrgHeight-RoundR)*ow+r)*3],
                 pBMPBody^.rg[((iy+OrgHeight)*cw+r)*3],
d483 1
d540 1
d545 1
d1002 1
a1002 1
// HALT;
d1092 3
@


2.6
log
@MakeRoundǂo悤ɂȂ܂
@
text
@d1 1
a1 1
(**$Revision: 2.5 $**)
d448 6
a453 1

d469 1
a469 3
            pBMPBody^.rg[(iy*width+ix)*3+0]:=BkColB;
            pBMPBody^.rg[(iy*width+ix)*3+1]:=BkColG;
            pBMPBody^.rg[(iy*width+ix)*3+2]:=BkColR;
d480 1
a480 3
            pBMPBody^.rg[(Suffix+ix)*3+0]:=SdColB;
            pBMPBody^.rg[(Suffix+ix)*3+1]:=SdColG;
            pBMPBody^.rg[(Suffix+ix)*3+2]:=SdColR;
d489 1
a489 3
            pBMPBody^.rg[(Suffix+ix)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+ix)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+ix)*3+2]:=ShColR;
d493 1
a493 3
            pBMPBody^.rg[(Suffix+ix)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+ix)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+ix)*3+2]:=ShColR;
d502 1
a502 3
            pBMPBody^.rg[(Suffix+iy*Width)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+iy*Width)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+iy*Width)*3+2]:=ShColR;
d506 1
a506 3
            pBMPBody^.rg[(Suffix+iy*Width)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+iy*Width)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+iy*Width)*3+2]:=ShColR;
d1089 3
@


2.5
log
@ʎqƂ
@
text
@d1 1
a1 1
(**$Revision: 2.4 $**)
d410 40
d462 7
d546 4
a724 1
//                    GSVClass.MakeRound(GSVClass.RoundRadian);
d1095 4
a1098 1
$Log: ground.pas $
@


2.4
log
@܂͉e̊S`
@
text
@d1 1
a1 1
(**$Revision: 2.3 $**)
d402 1
a402 1
    cx,cy:INTEGER;
d427 6
a432 6
    FOR cy:=RoundR TO OrgHeight-RoundR DO BEGIN
        Suffix:=Width*Cy;
        FOR cx:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            pBMPBody^.rg[(Suffix+cx)*3+0]:=SdColB;
            pBMPBody^.rg[(Suffix+cx)*3+1]:=SdColG;
            pBMPBody^.rg[(Suffix+cx)*3+2]:=SdColR;
d435 15
a449 15
    FOR cy:=0 TO RoundR-1 DO BEGIN
        ShColR:=(BkColR*(RoundR-cy)+SdColR*cy) div RoundR;
        ShColG:=(BkColG*(RoundR-cy)+SdColG*cy) div RoundR;
        ShColB:=(BkColB*(RoundR-cy)+SdColB*cy) div RoundR;
        Suffix:=cy*Width;
        FOR cx:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            pBMPBody^.rg[(Suffix+cx)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+cx)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+cx)*3+2]:=ShColR;
        END;
        Suffix:=(OrgHeight-cy)*Width;
        FOR cx:=DropL+RoundR TO OrgWidth+DropL-RoundR DO BEGIN
            pBMPBody^.rg[(Suffix+cx)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+cx)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+cx)*3+2]:=ShColR;
d452 15
a466 15
    FOR cx:=0 TO RoundR-1 DO BEGIN
        ShColR:=(BkColR*(RoundR-cx)+SdColR*cx) div RoundR;
        ShColG:=(BkColG*(RoundR-cx)+SdColG*cx) div RoundR;
        ShColB:=(BkColB*(RoundR-cx)+SdColB*cx) div RoundR;
        Suffix:=cx+DropL;
        FOR cy:=RoundR TO OrgHeight-RoundR DO BEGIN
            pBMPBody^.rg[(Suffix+cy*Width)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+cy*Width)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+cy*Width)*3+2]:=ShColR;
        END;
        Suffix:=OrgWidth+DropL-cx;
        FOR cy:=RoundR TO OrgHeight-RoundR DO BEGIN
            pBMPBody^.rg[(Suffix+cy*Width)*3+0]:=ShColB;
            pBMPBody^.rg[(Suffix+cy*Width)*3+1]:=ShColG;
            pBMPBody^.rg[(Suffix+cy*Width)*3+2]:=ShColR;
d470 3
a472 3
    FOR cx:=0 TO RoundR-1 DO BEGIN
        FOR cy:=0 TO RoundR-1 DO BEGIN
            distance:=trunc(sqrt(sqr(cx)+sqr(cy)));
d478 1
a478 1
            Suffix:=((cy+RTop.y+1)*Width+RTop.x+cx+1)*3;
d483 1
a483 1
            Suffix:=((cy+LTop.y+1)*Width+LTop.x-cx-1)*3;
d488 1
a488 1
            Suffix:=((LBottom.y-cy-1)*Width+LBottom.x-cx-1)*3;
d493 1
a493 1
            Suffix:=((RBottom.y-cy-1)*Width+RBottom.x+cx+1)*3;
d794 1
a794 1
            IF (GSVClass.pBMPBody^.sCx-GSVCLass.Cx) <0 THEN
d804 1
a804 1
                    Dec(GSVClass.xEdge,GSVClass.Cx);
d1046 3
@


2.3
log
@UndõKt܂B
@
text
@d1 1
a1 1
(**$Revision: 2.2 $**)
d71 1
a71 1
                         pszName:'GSV:';
d127 1
a127 1
        PROCEDURE MakeRound(RoundR:INTEGER);
d396 2
a397 1
PROCEDURE GraphScreenClass.MakeRound(RoundR:INTEGER);
d399 7
a405 10
    TopRight,TopLeft,BottomRight,BottomLeft:PointL;
    RTopRight,RTopLeft,RBottomRight,RBottomLeft:PointL;
    xStart,xEnd:INTEGER;
    yStart,yEnd:INTEGER;
    yc,xc,xs,ys:INTEGER;
    Suffix,distance:INTEGER;
    xWidth,yHeight,xDif:INTEGER;
    DropShadowR,DropShadowG,DropShadowB:BYTE;
    fl:extended;

d410 2
d413 2
a414 15
    PROCEDURE RoundCorner;
    VAR
        yc,xc:INTEGER;
    BEGIN
        yStart:=0;yEnd:=RoundR;
        xStart:=0;xEnd:=RoundR;
        FOR yc:=yStart TO yEnd-1 DO BEGIN
            xs:=GetRoundX(RoundR,RoundR-yc);
            FOR xc:=xStart TO xEnd-1 DO BEGIN
                IF RoundR-xs > xc THEN BEGIN
                    Suffix:=(xWidth*(yc+RoundR)+xc)*3;
                    pBMPBody^.rg[Suffix+0]:=BkColB;
                    pBMPBody^.rg[Suffix+1]:=BkColG;
                    pBMPBody^.rg[Suffix+2]:=BkColR;
                END;
d416 1
a416 13
                IF RoundR-xs > xc THEN BEGIN
                    Suffix:=(xWidth*(RoundR-yc+RTopLeft.y+RoundR)+xc)*3;
                    pBMPBody^.rg[Suffix+0]:=BkColB;
                    pBMPBody^.rg[Suffix+1]:=BkColG;
                    pBMPBody^.rg[Suffix+2]:=BkColR;
                END;

                IF xs < xc THEN BEGIN
                    Suffix:=(xWidth*(yc+RoundR)+RBottomRight.x+xc)*3;
                    pBMPBody^.rg[Suffix+0]:=SdColB;
                    pBMPBody^.rg[Suffix+1]:=SdColG;
                    pBMPBody^.rg[Suffix+2]:=SdColR;
                END;
d418 15
a432 7
                IF xs < xc THEN BEGIN
                    Suffix:=(xWidth*(TopRight.y-yc+RoundR)+xc+RTopRight.x)*3;
                    pBMPBody^.rg[Suffix+0]:=BkColB;
                    pBMPBody^.rg[Suffix+1]:=BkColG;
                    pBMPBody^.rg[Suffix+2]:=BkColR;
                END;
            END;
d435 15
a449 47
BEGIN
    IF pBMPBody^.bmpcy div 4<RoundR THEN RoundR:=pBMPBody^.bmpCy div 4;
    IF pBMPBody^.bmpcx div 4<RoundR THEN RoundR:=pBMPBody^.bmpCx div 4;

    CopyFromOrg;
    BottomLeft.x:=0;
    BottomLeft.y:=0;
    RBottomLeft:=BottomLeft;
    Inc(RBottomLeft.x,RoundR);
    Inc(RBottomLeft.y,RoundR);


    BottomRight.x:=OrgWidth;
    BottomRight.y:=0;
    RBottomRight:=BottomRight;
    Dec(RBottomRight.x,RoundR);
    Inc(RBottomRight.y,RoundR);

    TopLeft.x:=0;
    TopLeft.y:=pBMPBody^.bmpCy;
    RTopLeft:=TopLeft;
    Inc(RTopLeft.x,RoundR);
    Dec(RTopLeft.y,RoundR);

    TopRight.x:=OrgWidth;
    TopRight.y:=pBMPBody^.bmpCy;
    RTopRight:=TopRight;
    Dec(RTopRight.x,RoundR);
    Dec(RTopRight.y,RoundR);

    MakePaneLarge(RoundR);

    xWidth:=pBMPBody^.bmpCx;
    yHeight:=pBMPBody^.bmpCy;
    xDif:=pBMPBody^.bmpCx-OrgWidth-RoundR;

    IF isMakeRound THEN RoundCorner;

    FOR yc:=0 TO RoundR-1 DO BEGIN
        DropShadowR:=(BkColR*(RoundR-yc)+SdColR*yc) div RoundR;
        DropShadowG:=(BkColG*(RoundR-yc)+SdColG*yc) div RoundR;
        DropShadowB:=(BkColB*(RoundR-yc)+SdColB*yc) div RoundR;
        Suffix:=yc*xWidth*3;
        FOR xc:=RoundR*2 TO OrgWidth-1 DO BEGIN
            pBMPBody^.rg[Suffix+xc*3+0]:=DropShadowB;
            pBMPBody^.rg[Suffix+xc*3+1]:=DropShadowG;
            pBMPBody^.rg[Suffix+xc*3+2]:=DropShadowR;
d452 15
a466 9
    FOR xc:=0 TO RoundR-1 DO BEGIN
        DropShadowR:=(BkColR*xc+SdColR*(RoundR-xc) ) div RoundR;
        DropShadowG:=(BkColG*xc+SdColG*(RoundR-xc)) div RoundR;
        DropShadowB:=(BkColB*xc+SdColB*(RoundR-xc)) div RoundR;
        Suffix:=(OrgWidth+xc)*3;
        FOR yc:=RoundR TO pOrgBitmap^.bmpCy-RoundR DO BEGIN
            pBMPBody^.rg[Suffix+yc*xWidth*3+0]:=DropShadowB;
            pBMPBody^.rg[Suffix+yc*xWidth*3+1]:=DropShadowG;
            pBMPBody^.rg[Suffix+yc*xWidth*3+2]:=DropShadowR;
d469 4
a472 3
    FOR xc:=0 TO RoundR-1 DO BEGIN
        FOR yc:=0 TO RoundR-1 DO BEGIN
            distance:=trunc(sqrt(sqr(xc)+sqr(yc)));
d474 23
a496 18
            DropShadowR:=(BkColR*distance+SdColR*(RoundR-distance) ) div RoundR;
            DropShadowG:=(BkColG*distance+SdColG*(RoundR-distance) ) div RoundR;
            DropShadowB:=(BkColB*distance+SdColB*(RoundR-distance) ) div RoundR;

            Suffix:=((yHeight-RoundR*2+yc-xDif)*xWidth+xWidth-RoundR+xc-xDif)*3;
            pBMPBody^.rg[Suffix+0]:=DropShadowB;
            pBMPBody^.rg[Suffix+1]:=DropShadowG;
            pBMPBody^.rg[Suffix+2]:=DropShadowR;

            Suffix:=((RoundR-yc-1)*xWidth+(RoundR*2-xc))*3;
            pBMPBody^.rg[Suffix+0]:=DropShadowB;
            pBMPBody^.rg[Suffix+1]:=DropShadowG;
            pBMPBody^.rg[Suffix+2]:=DropShadowR;

            Suffix:=((RoundR-yc)*xWidth+(xWidth-RoundR+xc-xDif))*3;
            pBMPBody^.rg[Suffix+0]:=DropShadowB;
            pBMPBody^.rg[Suffix+1]:=DropShadowG;
            pBMPBody^.rg[Suffix+2]:=DropShadowR;
d499 1
a500 1
END;
d674 3
a676 1
                    GSVClass.MakeRound(GSVClass.RoundRadian);
d884 2
a885 1
                    GSVClass.MakeRound(GSVClass.RoundRadian);
d1046 3
@


2.2
log
@Ƃ肠e𖵏ȂƂ悤
@
text
@d1 1
a1 1
(**$Revision: 2.1 $**)
d27 7
d113 1
a113 1
        RoundRadian:INTEGER;
d137 1
d195 1
d220 1
d659 2
a660 1
    hwndSpin:hwnd;
d672 2
a673 2
            hwndButton:=WinWindowFromID(hwndDlg,110);
            hwndUseRoundCheck:=WinWindowFromID(hwndDlg,101);
d681 4
a684 3
            hwndSpin:=WinWindowFromID(hwndDlg,102);
            WinSendMsg( hwndSpin,SPBM_SETLIMITS,120,0);
            WinSendMsg( hwndSpin,
d688 6
d697 1
a697 1
                DID_OK:BEGIN
d701 1
a701 1
                    WinSendMsg(hwndSpin,
d706 5
d1062 1
a1062 1
                    100,
d1080 3
@


2.1
log
@Ɠr
@
text
@d1 1
a1 1
(**$Revision: 2.0 $**)
d476 1
d485 1
a485 1
        FOR xc:=RoundR*2 TO pOrgBitmap^.bmpCx-1 DO BEGIN
d491 1
a491 1
    FOR xc:=0 TO RoundR DO BEGIN
d496 1
a496 1
        FOR yc:=RoundR TO pOrgBitmap^.bmpCy-RoundR-1 DO BEGIN
d510 1
a510 1
            Suffix:=((yHeight-RoundR*2+yc)*xWidth+xWidth-RoundR+xc)*3;
d520 1
a520 1
            Suffix:=((RoundR-yc)*xWidth+(xWidth-RoundR+xc))*3;
d1057 3
@


2.0
log
@BMPǂݍ݃[`폜
@
text
@d1 1
a1 1
(**$Revision: 1.11 $**)
a26 3
CONST
    RoundR:INTEGER=20;

d92 1
d104 3
a106 2
        DropBkCol:ULong;
        isReColor:BOOLEAN;
d118 1
a118 1
        PROCEDURE MakePaneLarg;
d120 1
a120 1
        PROCEDURE MakeRound;
d130 1
a136 4
    isSubDir:BOOLEAN;
    isSort:BOOLEAN;
    isRun:BOOLEAN;
    isRGBColor:BOOLEAN;
a141 2
    BkCol:ULong;
    ShadowCol:ULong;
d161 2
a162 2
    isRGBColor:=cfg.GetValueBool(isColorDefine,FALSE);
    IF isRGBColor THEN BEGIN
d165 1
a165 1
            BkCol:=StrToInt(St);
d167 2
a168 2
            BkCol:=CLR_WHITE;
            isRGBColor:=FALSE;
d172 1
a172 1
        BkCol:=CLR_WHITE;
d177 4
a180 4
    IF isRGBColor THEN BEGIN
        BkColR:=((BkCol div 256) div 256)mod 256;
        BkColG:=(BkCol div 256) mod 256;
        BkColB:=BkCol mod 256;
d185 2
a186 1
    ShadowCol:=cfg.GetValueInteger(ShadowValue,$808080);
d188 3
a190 3
    SdColR:=((ShadowCol div 256) div 256)mod 256;
    SdColG:=(ShadowCol div 256) mod 256;
    SdColB:=ShadowCol mod 256;
d208 1
a208 1
    cfg.SetValue(ColorValue, '$'+IntToHex(BkCol,8) );
d210 1
d227 1
a227 2
    DropBkCol:=ShadowCol;
    isReColor:=TRUE;
d343 1
a343 1
PROCEDURE GraphScreenClass.MakePaneLarg;
d346 1
d348 2
d352 2
a353 2
    cx:=pBMPBody^.bmpCx+RoundR;
    cy:=pBMPBody^.bmpCy+RoundR;
d372 1
a372 1
             pBMPBody^.rg[(py+RoundR)*cx*3],
d386 1
a386 1
PROCEDURE GraphScreenClass.MakeRound;
d443 3
d454 1
a454 1
    BottomRight.x:=pBMPBody^.bmpCx;
d466 2
a467 2
    TopRight.x:=pBMPBody.bmpCx;
    TopRight.y:=pBMPBody.bmpCy;
a470 1
    xDif:=pBMPBody^.bmpCx-OrgWidth;
d472 1
a472 1
    MakePaneLarg;
d509 1
a509 1
            Suffix:=((yHeight-RoundR*2+yc)*xWidth+xWidth-RoundR+xc-xDif)*3;
a562 1
    yDif,xDif:INTEGER;
a620 2
    hptrIcon:hPointer;
    st:string;
a621 2
    Rect:RectL;
    ps:HPS;
d648 1
a653 5
    i:INTEGER;
    rc:UShort;
    st:string;
    hwndSlider:hwnd;
    ulRC:ULong;
d655 1
d669 6
d681 7
a687 1
                    GSVClass.MakeRound;
d743 1
a743 1
            WinPostMsg(Window, WM_QUIT, 0, 0);
d881 1
d893 6
d948 1
a948 1

d989 1
a989 3
    GetOpt:=GetOptClass.Create('rpcgs','');
    isSort:=FALSE;
    isSubDir:=FALSE;
a991 6
            'r':BEGIN
                isSubDir:=TRUE;
            END;
            'p':BEGIN
                isRun:=TRUE;
            END;
d994 1
a994 1
                    isRGBColor:=TRUE;
d997 1
a997 1
                        BkCol:=StrToInt(St);
d999 2
a1000 2
                        BkCol:=CLR_WHITE;
                        isRGBColor:=FALSE;
d1004 2
a1005 14
            'g':BEGIN
                IF GetOpt.isEnd=FALSE THEN BEGIN
                    St:=GetOpt.GetNextArg;
                    TRY
                        GSVClass.Ganmma:=StrToFloat(st);
                    EXCEPT
                        GSVClass.Ganmma:=1;
                    END;
                    GSVClass.MakeGanmmaPalette;
                    GSVClass.SetPngPalette;
                END;
            END;
            's':BEGIN
                isSort:=TRUE;
a1008 4
    GSVClass.isSubDir:=isSubDir;
    GSVClass.isSort:=isSort;
    GSVClass.isRun:=isRun;
    GSVClass.isRGBColor:=isRGBColor;
d1014 1
d1056 3
@


1.11
log
@Fۑł悤
@
text
@d1 1
a1 1
(**$Revision: 1.10 $**)
d214 1
d364 1
a364 1
    FOR py:=1 TO cy*3-1 DO BEGIN
d1068 3
@


1.10
log
@J[pbge̐FRg[ł悤
@
text
@d1 1
a1 1
(**$Revision: 1.9 $**)
d128 7
a134 6
    isColorDefine='gsv/BkColor/isDefine';
    ColorValue='gsv/BkColor/Value';
    xPosPath='gsv/window/x';
    yPosPath='gsv/window/y';
    xWidthPath='gsv/window/width';
    yHeightPath='gsv/window/height';
d147 1
a182 1
    cfg.Free;
d191 5
a195 1
    SdColR:=$80;SdColG:=$80;SdColB:=$80;
d230 1
a230 1
    DropBkCol:=$808080;
d662 1
d674 2
d1067 3
@


1.9
log
@_[_CAO̓oB
@
text
@d1 1
a1 1
(**$Revision: 1.8 $**)
a23 2
    IDB_RUN      =  12006;
    IDB_STOP     =  12007;
a24 3
    IDB_UPTIME   =  12009;
    IDB_DOWNTIME =  12010;
    IDB_FULLSCR  =  12011;
d28 1
a28 1
    RoundR=20;
d105 3
d216 1
d224 3
d439 1
a439 1

d471 1
a471 1
    RoundCorner;
d609 34
d644 3
d660 9
d672 2
a1032 5
        IF GSVClass.isRun THEN
            WinSendMsg(WinWindowFromID(hwndFrame,FID_CLIENT),
                       WM_COMMAND,
                       IDB_RUN,
                       0);
d1055 1
a1055 1

d1059 3
@


1.8
log
@Ƃ肠_CAOoB
@
text
@d1 1
a1 1
(**$Revision: 1.7 $**)
d83 1
a83 1
      mainItems:ARRAY [0..7] OF TBItemData=(
a87 2
            (NuID:IDB_SETTING   ;cText:' Setting'),
            (NuID:TB_SEPARATOR  ;cText:''),
d624 3
a626 1

a648 13
                IDB_LEFT:BEGIN
                    GSVClass.CopyFromOrg;
                    GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                END;
                IDB_RIGHT:BEGIN
                    IF GSVClass.isArgEmpty THEN EXIT;
                    GSVClass.SetNext;
                    GSVClass.LoadFile;
                    IF GSVClass.isFitWindow THEN
                        GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                END;
a675 24
                IDB_SETTING:BEGIN
                    GSVClass.MakeRound;
                    GSVClass.CalcFitScale;
                    GSVClass.RedrawMsg;
                {
                    OldGanmma:=GSVClass.Ganmma;
                    IF WinDlgBox(HWND_DESKTOP,
                                 Window,
                                 SettingDlgProc,
                                 NullHandle,
                                 ID_GSVSetting,
                                 NIL) =Ord(TRUE) THEN BEGIN
                        st:=GSVClass.GetStatusStr;
                        WinSetWindowText(hwndFrame,@@st[1]);
                        GSVClass.MakeGanmmaPalette;
                        GSVClass.SetPngPalette;
                        IF OldGanmma<>GSVClass.Ganmma THEN BEGIN
                            IF GSVClass.FileCount>0 THEN
                                GSVClass.LoadFile;
                        END;
                        GSVClass.RedrawMsg;
                    END;
                    }
                END;
d994 1
a994 1
                    GenericDlgProc,
d1014 3
@


1.7
log
@Ƃ肠bmp4̔{łȂ̏ǉ
@
text
@d1 1
a1 1
(**$Revision: 1.6 $**)
a31 9
    ID_GSVSetting   =13000;
    ID_RADIO1       =13001;
    ID_RADIO2       =13002;
    ID_RADIO5       =13003;
    ID_RADIO10      =13004;
    ID_SPINTEXT     =13005;
    ID_SLIDER       =13006;
    ID_SLIDERTEXT   =13007;

d83 1
a83 4
      mainItems:ARRAY [0..10] OF TBItemData=(
            (NuID:IDB_LEFT      ;cText:' previous picture '),
            (NuID:IDB_RIGHT     ;cText:' next picture '),
            (NuID:TB_SEPARATOR),
d123 1
d127 1
d161 5
a165 4
    xPos:=(aSWP.x+aSWP.cx div 8) ;
    yPos:=(aSWP.y+aSWP.cy div 8) ;
    xWidth:=(aSWP.cx div 4) *3 ;
    yHeight:=(aSWP.cy div 4) *3;
a334 1
    cx,cy,ox,oy,px,py:INTEGER;
d340 6
d367 3
a369 1
        Move(pOrgBitmap^.rg[py*ox*3],pBMPBody^.rg[(py+RoundR)*cx*3],ox*3);
a370 1

a372 1

d390 1
a390 1
    xWidth,yHeight:INTEGER;
d464 1
d466 1
a466 1
    CopyToOrg;
d488 1
a488 1
        Suffix:=(pOrgBitmap^.bmpCx+xc)*3;
d503 1
a503 1
            Suffix:=((yHeight-RoundR*2+yc)*xWidth+xWidth-RoundR+xc)*3;
d522 5
a609 3
VAR
    ScaleLength:INTEGER;

a622 34
        WM_INITDLG:BEGIN
            hwndSlider:=WinWindowFromID(hwndDlg,ID_SLIDER);
            WinSendMsg(hwndSlider,
                       SLM_SETTICKSIZE,
                       MPFROM2SHORT(SMA_SETALLTICKS,7),
                       0);
            FOR i := 0 TO 11 DO BEGIN
                IF ((i mod 3)=2) OR (i=0) THEN BEGIN
                    St:=FloatToStr(i*0.2);
                    St := St+ #0;

                    WinSendMsg(hwndSlider,
                               SLM_SETSCALETEXT,
                               MPFROMSHORT(i),
                               MPFROMP(@@St[1]));
                END;
            END;
            WinSendMsg(hwndSlider,
                       SLM_SETSLIDERINFO,
                       MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_INCREMENTVALUE),
                       5);
            ulRC:=WinSendMsg(hwndSlider,
                            SLM_QUERYSLIDERINFO,
                            MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE),
                            0);
            ulRC:=SHORT1FROMMP(ulRC);
            ScaleLength:=ulRC;
            ulRc:=TRUNC(ulRC*GSVClass.Ganmma);
            WinSendMsg(hwndSlider,
                       SLM_SETSLIDERINFO,
                       MPFROM2SHORT(SMA_SLIDERARMPOSITION,SMA_RANGEVALUE),
                       ulRC);

        END;
d626 1
a626 9
                    hwndSlider:=WinWindowFromID(hwndDlg,ID_SLIDER);
                    ulRC:=WinSendMsg(   hwndSlider,
                                        SLM_QUERYSLIDERINFO,
                                        MPFROM2SHORT( SMA_SLIDERARMPOSITION,
                                                      SMA_RANGEVALUE),
                                        0);
                    ulRC:=SHORT1FROMMP(ulRC);
                    GSVClass.Ganmma:=ulRC/ScaleLength;
                    WinDismissDlg(hwndDlg,Ord(TRUE));
a627 2
                DID_CANCEL:
                    WinDismissDlg(hwndDlg,Ord(FALSE));
a712 66
                IDB_FULLSCR:BEGIN
                    IF GSVClass.isFullScreen THEN BEGIN
                        WinSetParent(GSVClass.hwndTitle,hwndFrame,  FALSE );
                        WinSetParent(GSVClass.hwndSysMenu,hwndFrame,FALSE  );
                        WinSetParent(GSVClass.hwndMinMax,hwndFrame, FALSE);
                        WinSetParent(GSVClass.hwndVScrol,hwndFrame,FALSE);
                        WinSetParent(GSVClass.hwndHScrol,hwndFrame,FALSE);
                        GSVClass.isFullScreen:=FALSE;

                        WinSetWindowULong(hwndFrame,
                                          QWL_STYLE,
                                          GSVClass.OrgFrameFlag);
                        WinSendMsg( hwndFrame ,
                                    WM_UPDATEFRAME ,
                                    MPFROMLONG(GSVClass.OrgBorder) ,
                                    0 );
                        WinSetWindowPos(hwndFrame,NullHandle,
                                        GSVClass.OrgSWP.x,GSVClass.OrgSWP.y,
                                        GSVClass.OrgSWP.cx,GSVClass.OrgSWP.cy,
                                        SWP_ACTIVATE OR
                                        SWP_MOVE OR
                                        SWP_SIZE OR SWP_SHOW);
                    END
                    ELSE BEGIN
                        IF (MainTB.lType AND TB_FLOATING)=0 THEN BEGIN
                            SetToolbarState(hwndTB,TB_FLOATING);
                            WinDestroyWindow(hwndTB);
                            mainTB.lType:=TB_BUBBLE OR TB_FLOATING ;
                            hwndTB:=CreateToolbar(hwndFrame,mainTB);
                        END;
                        WinQueryWindowPos(hwndFrame,GSVClass.OrgSWP);
                        WinQueryWindowPos(hwnd_DESKTOP,aSWP);
                        WinSetWindowPos(hwndFrame,NullHandle,
                                        aSWP.x, aSWP.y,
                                        aSWP.cx,aSWP.cy,
                                        SWP_ACTIVATE OR
                                        SWP_MOVE OR
                                        SWP_SIZE OR SWP_SHOW);
                        WinSetParent(GSVClass.hwndMinMax, HWND_OBJECT,FALSE);
                        WinSetParent(GSVClass.hwndTitle,  HWND_OBJECT,FALSE);
                        WinSetParent(GSVClass.hwndSysMenu,HWND_OBJECT,FALSE);
                        WinSetParent(GSVClass.hwndVScrol, HWND_OBJECT,FALSE);
                        WinSetParent(GSVClass.hwndHScrol, HWND_OBJECT,FALSE);
                        FrameFlag:=WinQueryWindowULong(hwndFrame,QWL_STYLE );
                        GSVClass.OrgFrameFlag:=FrameFlag;

                        border:= FrameFlag
                                    AND (FS_BORDER OR
                                         FS_DLGBORDER OR
                                         FS_SIZEBORDER);
                        GSVClass.OrgBorder:=border;
                        WinSetWindowULong(hwndFrame,
                                          QWL_STYLE,
                                          FrameFlag-border);
                        WinSendMsg( hwndFrame ,
                                    WM_UPDATEFRAME ,
                                    MPFROMLONG(border) ,
                                    0 );

                        GSVClass.isFullScreen:=TRUE;
                        WinSendMsg( hwndFrame ,
                                    WM_UPDATEFRAME ,
                                    MPFROMLONG(border) ,
                                    0 );
                    END;
                END;
d930 1
d1008 4
a1011 4
                        swp.x + swp.cx div 8,
                        swp.y + swp.cy div 8,
                        (swp.cx div 4) * 3,
                        (swp.cy div 4) * 3,
a1019 1

d1025 10
a1034 4
            WinSetWindowPos(hwndFrame,
                            NULLHANDLE,
                            xPos,yPos,xWidth,yHeight,
                            SWP_ACTIVATE OR SWP_MOVE OR SWP_SIZE OR SWP_SHOW);
d1051 3
d1072 1
a1072 136
Revision 1.83  2007/06/02 22:34:21  Average
PNGɂpbg

Revision 1.82  2007/06/02 21:49:17  Average
K}l̐ݒMă_CAOƏCB

Revision 1.81  2007/04/17 13:45:08  Average
SetScrollœK

Revision 1.80  2007/04/14 16:16:26  Average
ŃXN[͍ĂƎv

Revision 1.79  2007/04/11 15:16:57  Average
XN[C(?)

Revision 1.78  2007/04/11 15:00:18  Average
XN[̂C

Revision 1.77  2007/03/24 14:27:29  Average
\[gĂ݂܂B

Revision 1.76  2007/02/25 16:16:43  Average
y[Wւ̃V[gJbg쐬

Revision 1.75  2006/12/16 15:29:36  Average
K}ϊ̃_CAO

Revision 1.74  2006/12/09 16:28:36  Average
XC_[

Revision 1.73  2006/12/09 15:06:54  Average
Ƃ肠ݒ_CAO玞ԊԊu悤

Revision 1.72  2006/12/09 14:41:43  Average
_CAÕfUCύX

Revision 1.70  2006/12/09 09:19:08  Average
*** empty log message ***

Revision 1.69  2006/12/09 06:13:19  Average
*** empty log message ***

Revision 1.68  2006/12/04 12:39:20  Average
IvV̐܂ςăRgXg𔲂

Revision 1.67  2006/12/04 12:37:03  Average
IvV̌`ςāAK}l̐lw\

Revision 1.65  2006/11/30 15:26:31  Average
XN[̃oOC

Revision 1.64  2006/11/15 12:13:42  Average
[g̉摜sȂ悤

Revision 1.63  2006/11/15 11:52:33  Average
XN[oȂƂ鎖C

Revision 1.62  2006/11/15 11:42:17  Average
IvVcfgɏނ̂ċAAXChV[͏O

Revision 1.61  2006/11/15 11:40:24  Average
XN[̕ψڗʂ̃oOC

Revision 1.60  2006/11/14 15:08:16  Average
XN[|WV̏C

Revision 1.59  2006/11/14 15:02:55  Average
tBbg̃ItZbg

Revision 1.58  2006/11/14 14:08:06  Average
Ƃ肠`FbNCĂ
B

Revision 1.57  2006/11/13 15:09:49  Average
N̈ʒuƏꏊoĂ悤

Revision 1.56  2006/11/13 14:55:49  Average
ԊԊȕC

Revision 1.55  2006/11/10 16:26:29  Average
RtBOt@@C̎

Revision 1.54  2006/11/10 16:02:23  Average
摜]̓hCBJ[IvṼG[̑Ώ

Revision 1.53  2006/11/10 15:50:57  Average
R}hCIvVA-r,-p,-c̓

Revision 1.52  2006/11/09 15:23:05  Average
tXN[[h

Revision 1.51  2006/11/09 13:34:44  Average
pbgɂwiFɑΉ

Revision 1.50  2006/11/09 12:27:54  Average
\啪ς
@@\͑OƕςȂEEE

Revision 1.26  2006/11/09 12:19:31  Average
hbvɃt@@CȂ̃G[C

Revision 1.25  2006/11/08 11:12:16  Average
^C}[ԊuԈႦĂ܂

Revision 1.24  2006/11/07 15:34:48  Average
hbv̖_C

Revision 1.23  2006/11/05 13:23:42  Average
 t@@CP̂̎̃G[C

Revision 1.22  2006/11/04 17:21:32  Average
ANZ[^

Revision 1.21  2006/11/04 16:50:42  Average
XN[삷悤

Revision 1.20  2006/11/04 16:32:42  Average
c悤

Revision 1.19  2006/11/04 16:24:01  Average
Ƃ肠XN[̖͓悤

Revision 1.18  2006/11/04 15:40:37  Average
XC_[̃tbN쐬

Revision 1.17  2006/11/04 14:31:07  Average
XN[̈ʒuӎ悤

Revision 1.16  2006/11/04 14:22:45  Average
`ƕς

Revision 1.15  2006/11/04 14:21:17  Average
ƏC

}
Color
@


1.6
log
@lOC
@
text
@d1 1
a1 1
(**$Revision: 1.5 $**)
d42 1
a42 1
    RoundR=60;
d211 1
d360 1
a360 1

d402 40
a470 2
    yStart:=0;yEnd:=RoundR;
    xStart:=0;xEnd:=RoundR;
a472 9
    FOR yc:=yStart TO yEnd-1 DO BEGIN
        xs:=GetRoundX(RoundR,RoundR-yc);
        FOR xc:=xStart TO xEnd-1 DO BEGIN
            IF RoundR-xs > xc THEN BEGIN
                Suffix:=(xWidth*(yc+RoundR)+xc)*3;
                pBMPBody^.rg[Suffix+0]:=BkColB;
                pBMPBody^.rg[Suffix+1]:=BkColG;
                pBMPBody^.rg[Suffix+2]:=BkColR;
            END;
d474 1
a474 13
            IF RoundR-xs > xc THEN BEGIN
                Suffix:=(xWidth*(RoundR-yc+RTopLeft.y+RoundR)+xc)*3;
                pBMPBody^.rg[Suffix+0]:=BkColB;
                pBMPBody^.rg[Suffix+1]:=BkColG;
                pBMPBody^.rg[Suffix+2]:=BkColR;
            END;

            IF xs < xc THEN BEGIN
                Suffix:=(xWidth*(yc+RoundR)+RBottomRight.x+xc)*3;
                pBMPBody^.rg[Suffix+0]:=SdColB;
                pBMPBody^.rg[Suffix+1]:=SdColG;
                pBMPBody^.rg[Suffix+2]:=SdColR;
            END;
a475 8
            IF xs < xc THEN BEGIN
                Suffix:=(xWidth*(TopRight.y-yc+RoundR)+xc+RTopRight.x)*3;
                pBMPBody^.rg[Suffix+0]:=BkColB;
                pBMPBody^.rg[Suffix+1]:=BkColG;
                pBMPBody^.rg[Suffix+2]:=BkColR;
            END;
        END;
    END;
d487 1
a487 1
    FOR xc:=0 TO RoundR-1 DO BEGIN
d499 1
a499 1
        FOR yc:=0 TO RoundR DO BEGIN
d511 1
a511 1
            Suffix:=((RoundR-yc)*xWidth+(RoundR*2-xc))*3;
d522 1
d695 2
a696 5
                    IF GSVClass.isArgEmpty THEN EXIT;
                    GSVClass.SetPrev;
                    GSVClass.LoadFile;
                    IF GSVClass.isFitWindow THEN
                        GSVClass.CalcFitScale;
a731 1
                    GSVClass.WriteBitmap;
d1156 3
@


1.5
log
@Of[V~ʈȊO
@
text
@d1 1
a1 1
(**$Revision: 1.4 $**)
d392 1
a392 1
    Suffix:INTEGER;
a393 1
    ShVal,BkVal:INTEGER;
d395 1
a485 1

d487 24
a510 1

d1149 3
@


1.4
log
@Ehet
@
text
@d1 1
a1 1
(**$Revision: 1.3 $**)
d161 1
d195 9
d351 2
a352 2
    cx:=pBMPBody^.bmpCx+2*RoundR;
    cy:=pBMPBody^.bmpCy+2*RoundR;
a359 5
    FOR px:=0 TO cx-1 DO BEGIN
        pBMPBody^.rg[px*3+0]:=BkColB;
        pBMPBody^.rg[px*3+1]:=BkColG;
        pBMPBody^.rg[px*3+2]:=BkColR;
    END;
d361 7
a367 4
    FillChar(pBMPBody^.rg,cx*cy*3,0);
    FOR py:=1 TO cy-1 DO BEGIN
        Move(pBMPBody^.rg[0],pBMPBody^.rg[py*cx],cx*3);
    END;
d370 1
a370 1
        Move(pOrgBitmap^.rg[py*ox*3],pBMPBody^.rg[(py+RoundR*2)*cx*3],ox*3);
d372 1
d394 3
a401 8
    IF isRGBColor THEN BEGIN
        BkColR:=((BkCol div 256) div 256)mod 256;
        BkColG:=(BkCol div 256) mod 256;
        BkColB:=BkCol mod 256;
    END
    ELSE BEGIN
        BkColR:=$FF;BkColG:=$FF;BkColB:=$FF;
    END;
d434 1
a434 1
    FOR yc:=yStart TO yEnd DO BEGIN
d436 1
a436 1
        FOR xc:=xStart TO xEnd DO BEGIN
d438 1
a438 1
                Suffix:=(xWidth*(yc+2*RoundR)+xc)*3;
d445 1
a445 1
                Suffix:=(xWidth*(RoundR-yc+RTopLeft.y+2*RoundR)+xc)*3;
d452 4
a455 4
                Suffix:=(xWidth*(yc+2*RoundR)+RBottomRight.x+xc)*3;
                pBMPBody^.rg[Suffix+0]:=BkColB;
                pBMPBody^.rg[Suffix+1]:=BkColG;
                pBMPBody^.rg[Suffix+2]:=BkColR;
d459 1
a459 1
                Suffix:=(xWidth*(TopRight.y-yc+2*RoundR)+xc+RTopRight.x)*3;
d466 24
d1127 3
@


1.3
log
@t@@Cɏ߂悤
@
text
@d1 1
a1 1
(**$Revision: 1.2 $**)
d41 3
d141 1
a141 1
    XMLConfName:string='gsvcfg.xml';
d160 1
d333 1
d339 25
d365 2
a376 2
CONST
    RoundR=60;
a377 1
    BkColR,BkColG,BkColB:BYTE;
d383 1
a388 4
    FUNCTION GetSuffix(x,y:INTEGER):INTEGER;
    BEGIN
        result:=x+y*pBMPBody^.bmpCy;
    END;
d434 4
a437 3
                pBMPBody^.rg[(xWidth*yc+xc)*3+0]:=BkColB;
                pBMPBody^.rg[(xWidth*yc+xc)*3+1]:=BkColG;
                pBMPBody^.rg[(xWidth*yc+xc)*3+2]:=BkColR;
d441 4
a444 3
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopLeft.y)+xc)*3+0]:=BkColB;
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopLeft.y)+xc)*3+1]:=BkColG;
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopLeft.y)+xc)*3+2]:=BkColR;
d448 4
a451 3
                pBMPBody^.rg[(xWidth*yc+RBottomRight.x+xc)*3+0]:=BkColB;
                pBMPBody^.rg[(xWidth*yc+RBottomRight.x+xc)*3+1]:=BkColG;
                pBMPBody^.rg[(xWidth*yc+RBottomRight.x+xc)*3+2]:=BkColR;
d455 4
a458 3
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopRight.y)+xc+RTopRight.x)*3+0]:=BkColB;
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopRight.y)+xc+RTopRight.x)*3+1]:=BkColG;
                pBMPBody^.rg[(xWidth*(RoundR-yc+RTopRight.y)+xc+RTopRight.x)*3+2]:=BkColR;
d679 1
d1099 3
@


1.2
log
@pۂ߂
@
text
@d1 1
a1 1
(**$Revision: 1.1 $**)
d134 1
d434 25
d644 1
d1068 3
@


1.1
log
@Initial revision
@
text
@d1 1
a1 1
(**$Revision: 1.83 $**)
d345 1
a345 1
    RoundR=20;
d350 4
d358 4
d364 3
d369 1
d394 1
a394 1
    Inc(RTopRight.x,RoundR);
d397 20
d418 5
a422 1
    CopyToOrg;
d424 7
d641 1
a641 1
                    {
d1040 4
a1043 1
$Log: GSV.PAS $
d1179 1
@
