/* RXEXIF.CMD */
/* Written by Lone Peak Automation */

/* Load RXEXIF.DLL */
CALL RXFuncAdd 'rxEXIFLoadFuncs', 'RXEXIF', 'rxEXIFLoadFuncs'
CALL rxEXIFLoadFuncs

SAY ''
SAY '--- Sample REXX Program for accessing EXIF information. ---'
SAY ''

rc = rxEXIFDllVersion()
SAY "rxEXIF.DLL version is: " || rc

IF Stream( 'test.jpg', 'C', 'Query Exists' ) = '' THEN    /* image not found */
  DO
    SAY ''
    SAY 'Image TEST.JPG not found.'
    SAY ''
    SAY 'Provide sample image file TEST.JPG or adjust imgfile accodingly.'
    EXIT
  END

imgfile = 'test.jpg'

exifdat.0 = 0
rc = rxEXIFRead(imgfile, 'exifdat')

temp = 'File: ' || imgfile
rc=LINEOUT('exif.txt', temp)
temp = 'exifdat.0 = ' || exifdat.0 || ' rc = ' || rc
rc=LINEOUT('exif.txt', temp)

SAY temp

DO i = 1 TO exifdat.0
  temp = 'exifdat.' || i || ' = ' || exifdat.i
  rc=LINEOUT('exif.txt', temp)
END
rc=LINEOUT('exif.txt') /*close*/

SAY 'rxEXIF test complete. Data saved to exif.txt'
CALL rxEXIFDROPFuncs
SAY 'rxEXIF.DLL dropped.'

EXIT
