/* Install CalydOS/2 
*/

parse upper arg What;

nok = RxFuncAdd("SysLoadFuncs",  "RexxUtil", "SysLoadFuncs") ;rc = SysLoadFuncs();

if What = "UPD" then SIGNAL Set_Installed;

HomePath = directory();

say "Install to "HomePath"? (Y/N)";

if Translate( SysGetKey('NoEcho') ) = "Y" then NOP;
else;do
   say "No installation";
   exit;
end;

ok = SysFileTree("Calydos.exe","files.","F");
if files.0 = 1 then NOP;
else;do
   say "Calydos.exe missing - installation abandoned";
   exit;
end;

/* --------------------------------------  */
/* Create Calydos folder on WPS-desktop:   */
/* --------------------------------------  */

FolderID = "<Calydos Objects>";

ok = SysCreateObject(   "WPFolder",             ,
                        "Calydos",             ,
                        "<WP_DESKTOP>",         ,
                        "OBJECTID="FolderID";ICONFILE=Folder1.ico",  ,
                        "Replace"               ,
                    );

if ok then
   say "Folder-object successfully created";
else;
   say "Error creating Folder-object: Code="ok;

/* --------------------------------------  */
/* Create Calydos program-object:          */
/* --------------------------------------  */

ok = SysCreateObject(   "WpProgram",                                             ,
                        "Calydos"||"0D0A"x||"Image Database", ,
                        FolderID,                                                ,
                        "EXENAME="HomePath"\Calydos.exe;ICONFILE="HomePath"\Calydos.ico;"||       ,
                        "STARTUPDIR="HomePath"\",                        ,
                        "Replace"                                       ,
                    );

if ok then
   say "Program-object successfully created";
else;
   say "Error creating program-object: Code="ok;


URL= "http://os2.zworks.de/Calydos/manual.html";

/* ------------------------------------------------    */
/* Prferenz fr Firefox: wenn gefunden, dann nimm,    */
/* sonst nimm Netscape:                                */
/* ------------------------------------------------    */
Firefox  =SysSearchPath("PATH","Firefox.exe");
Mozilla  =SysSearchPath("PATH","Mozilla.exe");
Netscape =SysSearchPath("PATH","Netscape.exe");
if Mozilla <> "" then         Browser   = Mozilla;
else;do
   if Firefox <> "" then      Browser   = Firefox;
   else;do
      if Netscape <> "" then  Browser   = Netscape;
   end;
end;
Workingdir= filespec("drive",Browser)||filespec("path",Browser);

Setup = "URL="URL";Browser="Browser";Workingdir="Workingdir";";

ok = SysCreateObject( "WpURL",  ,
                      "Calydos User Manual"||"0D0A"x||"(Online)", ,
                      FolderID,  ,
                      Setup,   ,
                      "Replace"  ,
                    );
if ok then
   say "URL-object successfully created";
else;
   say "Error creating URL-object: Code="ok;

Set_Installed:
ok = SysINI("default.ini", "Settings", "Installed", date() time() What );	/* Setze 'Installed'-Zeitstempel	*/

say "CalydOS/2 installation successfully completed";

exit;
