#include <stdio.h>

#include "unterminatedString.h"
#include "compatibility.h"

UnterminatedString :: UnterminatedString()
{
  CHECKED_NEW;
  
#ifdef MRM_DEBUG_STRINGS
  debugf( "STRING:  CTOR 0x%0lx, @ 0x0, 0\n", this );
#endif
  length = 0;
  string = NULL;
}

UnterminatedString :: UnterminatedString( const UnterminatedString *str )
{
  CHECKED_NEW;
  
  if ( str && str->getLength() )
  {
    CHECKED_MALLOC( str->getLength(), string );
    length = str->getLength();
    memcpy( string, str->getString(), length );
  } else {
    length = 0;
    string = NULL;
  }
#ifdef MRM_DEBUG_STRINGS
  debugf( "STRING:  CTOR 0x%0lx, @ 0x%0lx, %u\n", this, string, length );
#endif
}

UnterminatedString :: UnterminatedString( const char *str )
{
  CHECKED_NEW;
  
  if ( str )
  {
    length = strlen( str );
    if ( length )
    {
      CHECKED_MALLOC( length, string );
      memcpy( string, str, length );
    } else {
      string = NULL;
    }
  } else {
    length = 0;
    string = NULL;
  }
  
#ifdef MRM_DEBUG_STRINGS
  debugf( "STRING:  CTOR 0x%0lx, @ 0x%0lx, %u\n", this, string, length );
#endif
}

UnterminatedString :: UnterminatedString( const unsigned char *str,
 unsigned int len )
{
  CHECKED_NEW;
  
  length = len;
  if ( len )
  {
    CHECKED_MALLOC( len, string );
    memcpy( string, str, len );
  } else {
    string = NULL;
  }
#ifdef MRM_DEBUG_STRINGS
  debugf( "STRING:  CTOR 0x%0lx, @ 0x%0lx, %u\n", this, string, length );
#endif
}

void UnterminatedString ::
 setString( const unsigned char *str, unsigned int len )
{
  if ( !len )
  {
    if ( length )
    {
      CHECKED_FREE( string );
#ifdef MRM_DEBUG_STRINGS
      debugf( "STRING:  SET 0x%0lx, FREE @ 0x%0lx, 0\n", this, string );
#endif
      length = 0;
    }
    string = NULL;
  } else {
    if ( length )
    {
      CHECKED_REALLOC( string, len, string );
#ifdef MRM_DEBUG_STRINGS
      debugf( "STRING:  SET 0x%0lx, REALLOC @ 0x%0lx, %u\n", this, string, len );
#endif
    } else {
      CHECKED_MALLOC( len, string );
#ifdef MRM_DEBUG_STRINGS
      debugf( "STRING:  SET 0x%0lx, MALLOC @ 0x%0lx, %u\n", this, string, len );
#endif
    }
    length = len;
    memcpy( string, str, length );
  }
}

void UnterminatedString :: strcat( const unsigned char *str, unsigned int len )
{
  unsigned int newLen = len + length;
  
  if ( newLen )
  {
    if ( !length )
    {
      CHECKED_MALLOC( newLen, string );
#ifdef MRM_DEBUG_STRINGS
      debugf( "STRING:  CAT 0x%0lx, MALLOC @ 0x%0lx, %u\n", this, string, newLen );
#endif
    } else {
#ifdef MRM_DEBUG_STRINGS
      unsigned char *tmp = string;
#endif
      CHECKED_REALLOC( string, newLen, string );
#ifdef MRM_DEBUG_STRINGS
      if ( tmp != string )
      {
        debugf( "STRING:  CAT 0x%0lx, REALLOC 0x%0lx -> 0x%0lx, %u\n", this,
         tmp, string, newLen );
      }
#endif
    }
    memcpy( string + length, str, len );
    length += len;
  }
}

void UnterminatedString :: strcat( const char *str, unsigned int len )
{
  this->strcat( (const unsigned char *)str, len );
}

void UnterminatedString :: strcat( const char *str )
{
  this->strcat( (const unsigned char *)str, strlen( str ) );
}

void UnterminatedString :: catNum( long num )
{
  char numString[20];
  sprintf( numString, "%ld", num );
  this->strcat( numString );
}

UnterminatedString :: ~UnterminatedString()
{
  CHECKED_DELETE;
  
  if ( length )
  {
    CHECKED_FREE( string );
#ifdef MRM_DEBUG_STRINGS
    debugf( "STRING:  DTOR 0x%0lx, FREE @ 0x%0lx, %u\n", this, string, length );
#endif
  }
  length = 0;
  string = NULL;
}

const unsigned char *UnterminatedString :: getString( void ) const
{
  return string;
}

unsigned int UnterminatedString :: getLength( void ) const
{
  return length;
}
