/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef SINGLEMSGSHISTORY_H
#define SINGLEMSGSHISTORY_H

#include <QObject>
#include <QList>
#include <QMap>

#include "message.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class SingleMsgsHistory : public QObject
{
  Q_OBJECT
  private:
    QList<Message*> m_messagesIn;
    QList<Message*> m_messagesOut;

  public:
    SingleMsgsHistory(QObject *parent = 0);
    ~SingleMsgsHistory();

   void addMessage(Message* msg);
   Message* messageIn(int n){if(m_messagesIn.size()) return m_messagesIn[n]; else return NULL;}
   Message* messageOut(int n){if(m_messagesOut.size()) return m_messagesOut[n]; else return NULL;}

   QList<Message*> messagesIn () const {return m_messagesIn;}
   QList<Message*> messagesOut() const {return m_messagesOut;}
};

#endif
