/*******************************************************************
*                                                                  *
*  MODULE : broadcast.c                                            *
*                                                                  *
*  Function: Realization of Broadcast Operations                   *
*                                                                  *
*                                                                  *
*   THIS MODULE IS A  PVM  VERSION, based on PVM 3.1               *
*                                                                  *
*      equal for Alliant, Sun4, IBM AIX                            *
*                                                                  *
*******************************************************************/

#include "system.h"
#include "pvm3.h"

#define WITH_HOST 1
#define NO_HOST   0 

/*******************************************************************
*                                                                  *
*  IMPORT :                                                        *
*                                                                  *
*      asend, areceive from MAILBOX                                *
*                                                                  *
*******************************************************************/

void general_broadcast (data,size,j,host_opt)

char *data;   /* pointer to the data element */
int j, size;  /* process j sends data of size bytes */
int host_opt; /* indicates participation of host    */

/* using broadcast possibility of pvm

    if host_opt == NO_HOST, host gets no copy     */

{ int i, n;

  i = pcb.i;  /* number of the calling process */
  n = pcb.p;  /* number of processors */

  /* printf ("broadcast, here %d(%d), gets from %d, size = %d\n",i,n,j,size); */

  if (i == j)  /* I am sending */
    { pvm_initsend(PvmDataRaw);
      pvm_pkbyte (data, size, 1);
      if ((i != 0) && (host_opt == WITH_HOST) && (target_model == 0))
         pvm_mcast (tids, n+1, j);   /* also send to host */
       else
         pvm_mcast (tids+1, n, j);     /* not to host = process 0 */
    }
   else if ((i != 0) || (host_opt == WITH_HOST))
    { pvm_recv (tids[j], j);
      pvm_upkbyte (data, size, 1);
    }
}

process_broadcast (data,size,j)
char *data;  /* pointer to the data element */
int j, size;  /* process j sends data of size bytes */
{ general_broadcast (data,size,j,WITH_HOST); }

/*******************************************************************
*                                                                  *
*  FORTRAN - Interface                                             *
*                                                                  *
*    dalib_broadcast (data, size, j)                               *
*      - broadcast to host and all node from process j             *
*                                                                  *
*******************************************************************/

void dalib_broadcast__ (data,size,j)
int *data, *size, *j;
{ int pos;
  general_broadcast (data, *size, *j, WITH_HOST);
}

void dalib_node_broadcast__ (data,size,j)
int *data, *size, *j;
{ int pos;
  general_broadcast (data, *size, *j, NO_HOST);
}
