/*************************************************************************
*                                                                        *
*  Name : global.h                                                       *
*                                                                        *
*  Purpose : declaration of global data for ADAPTOR translation          *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, I1.HR                               *
*                                                                        *
*  Last Update : April 1993                                              *
*                                                                        *
**************************************************************************

          /*************************************************
          *                                                *
          *  TARGET MACHINE                                *
          *                                                *
          *************************************************/

extern int no_machine;            /* number of entries of machine_items */
extern char *machine_items [];
extern int target_machine;        /* value of target_machine */

/* possible values for target_machine */

#define IPSC_860     0
#define CM5          1
#define PARSYTEC_GC  2
#define MEIKO_CS1    3
#define MEIKO_CS2    4
#define SUPRENUM     5
#define ALLIANT      6
#define SGI          7
#define KSR1         8
#define SUN4_PVM     9
#define RIOS_PVM    10
#define ALL_PVM     11
#define OS2_PVM     12
#define KSR1_PVM    13

          /*************************************************
          *                                                *
          *  TARGET LANGUAGE                               *
          *                                                *
          *************************************************/

extern int no_language;
extern char *language_items [];
extern int target_language;

/* possible values for target_language */

#define FORTRAN_77 0
#define FORTRAN_90 1

          /*************************************************
          *                                                *
          *  TARGET MODEL                                  *
          *                                                *
          *************************************************/

extern int no_model;
extern char *model_items [];
extern int target_model;

/* possible values for target_model */

#define HOST_NODE  0
#define ONLY_NODE  1
#define UNI_PROC   2

          /*************************************************
          *                                                *
          *  ARRAY  KIND                                   *
          *                                                *
          *************************************************/

extern int no_array;
extern char *array_items [];
extern int array_kind;

/* possible values for array_kind */

#define DYNAMIC_ARRAYS  0
#define STATIC_ARRAYS   1

          /*************************************************
          *                                                *
          *  DEFAULT DISTRIBUTION                          *
          *                                                *
          *************************************************/

extern int no_ddefault;
extern char *ddefault_items [];
extern int ddefault_kind;

/* possible values for ddefault_kind */

#define DDEFAULT_REPLICATED    0
#define DDEFAULT_DISTRIBUTED   1
#define DDEFAULT_CM            2

          /*************************************************
          *                                                *
          *  SPLIT OPTION (flag)                           *
          *                                                *
          *************************************************/

/* Split options */

extern char * split_items [];
extern int  no_split;
extern int split_flag;          /* value for splitting */

          /*************************************************
          *                                                *
          *  MINIMAL NUMBER OF PROCESSORS                  *
          *                                                *
          *    MinProc : integer value                     *
          *                                                *
          *   (needed to compute static array sizes)       *
          *                                                *
          *************************************************/

extern char * minproc_items [];
extern int  no_minproc;
extern int MinProc;

/* machine parameters for SUN4 PVM */

#define SUN4_PVM_OPTIONS "-O -w"
#define OS2_PVM_OPTIONS  "-O2 -w"
#define RIOS_PVM_OPTIONS "-O -w"

          /*************************************************
          *                                                *
          *  PREDEFINED VALUES for VARIABLES               *
          *                                                *
          *    (machine-, installation-dependent)          *
          *                                                *
          *************************************************/

#define predefined_target_machine  OS2_PVM
#define predefined_target_language FORTRAN_77
#define predefined_target_model    HOST_NODE
#define predefined_array_kind      STATIC_ARRAYS
#define predefined_ddefault_kind   DDEFAULT_DISTRIBUTED
#define predefined_MinProc         1
#define predefined_StaticArraySize 25000
#define predefined_split_flag      0

#define predefined_PHOME "/adaptor"

#define PHOME_envvar     "PHOME"

          /*************************************************
          *                                                *
          *  Variables for makefiles.c so that adapt       *
          *  can adapt target with same arguments          *
          *                                                *
          *  filename: name of the full source file        *
          *                                                *
          *  fad_argv, fad_argc: command line arguments    *
          *                                                *
          *************************************************/

extern char ** fad_argv;
extern int     fad_argc;
extern char  * filename;
extern int     interactive;

extern int StaticArraySize;

#define unparse_file "unparse.f"

/* internal compiler sizes */

#define MAXID_LENGTH    50
#define MAX_DIMENSIONS   4

extern char last_message [160];   /* last error/hints message  */
extern char PHOME [160];          /* home directory of ADAPTOR */

/* internal flags used during compilation */

extern int IsHost;      /* translation of host program      */
extern int IsPure;      /* current subroutine is a pure one */

