# include "TempVars.h"
# include "yyTVars.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 27 "TempVars.puma"

# include "Idents.h"
# include "StringMe.h"
# include "protocol.h"


# include "Transfor.h"  /* AppendDECLS, CombineACF */
# include "Shapes.h"     /* IsWholeVar              */

typedef int *pint;

tTree new_decls;          /* global used for new declarations */
int new_allocates;        /* counts globally new necessary allocates */

tTree new_assigns;        /* global used when creating the local */
int TopLevel;             /* expression with movements           */



static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempVars, routine %s failed\n", yyFunction);
 exit (1);
}

void TempVarsInitBody ARGS((tTree t));
void TempVarsDoneBody ARGS((tTree t));
tTree MakeLocalExpression ARGS((tTree exp, tTree var, int no, bool simple, int * needed, tTree * assigns));
static void MakeTempStmt ARGS((tTree exp, tTree var, int no));
static tTree NewTempExp ARGS((tTree exp, tTree var, int no, pint needed));
static tTree NewTempCShift ARGS((tTree exp, tTree var, int no, pint needed));
static tTree GetMajorityVar ARGS((tTree e));
static tTree NewTempVar ARGS((tTree var, int no));
static tTree NewTempVarObj ARGS((tDefinitions Obj, int no));
static tDefinitions CopyObject ARGS((tDefinitions Obj, tIdent newname));
static tDefinitions CopyDistribution ARGS((tDefinitions d));
static void NewTempAllocates ARGS((tTree t));
static tTree ExtendTempAllocates ARGS((tTree t));
static int NoOfTemporaries ARGS((tTree t));

void TempVarsInitBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBODY_NODE) {
# line 54 "TempVars.puma"
  {
# line 55 "TempVars.puma"
   new_decls = mDECL_EMPTY ();
# line 56 "TempVars.puma"
   new_allocates = 0;
  }
   return;

  }
# line 59 "TempVars.puma"
  {
# line 60 "TempVars.puma"
   printf ("Illegal Call of TempVarsInitBody");
# line 61 "TempVars.puma"
   kill_in_protocol ();
  }
   return;

;
}

void TempVarsDoneBody
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return;
  if (t->Kind == kBODY_NODE) {
# line 72 "TempVars.puma"
  {
# line 74 "TempVars.puma"
   tree_protocol ("This are the new temporaries : \n", new_decls);
# line 75 "TempVars.puma"
 t->BODY_NODE.DECLS = AppendDECLS (t->BODY_NODE.DECLS, new_decls);
     if (new_allocates > 0)
        NewTempAllocates (t->BODY_NODE.STATS);

  }
   return;

  }
# line 81 "TempVars.puma"
  {
# line 82 "TempVars.puma"
   printf ("Illegal Call of TempVarsDoneBody");
# line 83 "TempVars.puma"
   kill_in_protocol ();
  }
   return;

;
}

tTree MakeLocalExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree var, register int no, register bool simple, register int * needed, register tTree * assigns)
# else
(exp, var, no, simple, needed, assigns)
 register tTree exp;
 register tTree var;
 register int no;
 register bool simple;
 register int * needed;
 register tTree * assigns;
# endif
{
# line 119 "TempVars.puma"
 {
  tTree newexp;
  tTree newass;
  int n;
  {
# line 121 "TempVars.puma"

# line 122 "TempVars.puma"

# line 123 "TempVars.puma"

# line 125 "TempVars.puma"
 new_assigns = NoTree;
      if (simple)
          TopLevel = 0;
        else
          TopLevel = 1;
      n = 0;
      newexp = NewTempExp (exp, var, no, &n);
      newass = new_assigns;

  }
   * needed = n;
   * assigns = newass;
  {
   return newexp;
  }
 }

}

static void MakeTempStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree var, register int no)
# else
(exp, var, no)
 register tTree exp;
 register tTree var;
 register int no;
# endif
{
# line 147 "TempVars.puma"

tTree newvar, stmt;

  if (exp == NoTree) return;
  if (var == NoTree) return;
# line 151 "TempVars.puma"
  {
# line 152 "TempVars.puma"
 stmt = mASSIGN_STMT (NewTempVar(var, no), exp);
    stmt = mACF_BASIC (stmt);
    new_assigns = CombineACF (new_assigns, mACF_LIST (stmt, NoTree));

  }
   return;

;
}

static tTree NewTempExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree var, register int no, pint needed)
# else
(exp, var, no, needed)
 register tTree exp;
 register tTree var;
 register int no;
 pint needed;
# endif
{
# line 169 "TempVars.puma"

int count1;
int count2;
tTree newexp, majvar;
int hneeded;
int htop;

  if (exp->Kind == kOP_EXP) {
# line 183 "TempVars.puma"
  {
# line 184 "TempVars.puma"
 TopLevel = 0;
      count1 = CountMovements (var, exp->OP_EXP.OPND1);
      count2 = CountMovements (var, exp->OP_EXP.OPND2);
      if (count1 == 0)
        { if (count2 != 0)
            {
              exp->OP_EXP.OPND2 = NewTempExp (exp->OP_EXP.OPND2, var, no, needed);
            }
        }
      else
        { if (count2 == 0)
            {
              exp->OP_EXP.OPND1 = NewTempExp (exp->OP_EXP.OPND1, var, no, needed);
            }
           else
            {
              hneeded = 0;
              newexp = NewTempExp (exp->OP_EXP.OPND1, var, no, &hneeded);
              if (hneeded > 1)
                {
                  MakeTempStmt (newexp, var, no);
                  exp->OP_EXP.OPND1 = mVAR_EXP (NewTempVar (var, no));
                }
               else
                  exp->OP_EXP.OPND1 = newexp;
              *needed = 1;
              exp->OP_EXP.OPND2 = NewTempExp (exp->OP_EXP.OPND2, var, no+1, needed);
            }
        }

  }
   return exp;

  }
  if (exp->Kind == kOP1_EXP) {
# line 217 "TempVars.puma"
  {
# line 218 "TempVars.puma"
 TopLevel = 0;

      exp->OP1_EXP.OPND = NewTempExp (exp->OP1_EXP.OPND, var, no, needed);

  }
   return exp;

  }
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (Definitions_IsType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object, kObject)) {
# line 225 "TempVars.puma"
  {
# line 226 "TempVars.puma"
 newexp = exp;
      if (IsIntrFunc (exp))
        { if (IntrFuncKind1 (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)
             || IntrFuncKindn (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)
             || IntrFuncKind2 (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
            {
              TopLevel = 0;
              count1 = CountMovements (var, exp->FUNC_CALL_EXP.FUNC_PARAMS);
              if (count1 > 0)
                exp->FUNC_CALL_EXP.FUNC_PARAMS = NewTempExp (exp->FUNC_CALL_EXP.FUNC_PARAMS, var, no, needed);
            }
           else if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("CSHIFT", 6))
            {
              if (!IsWholeVar (var))
                {
                  majvar = GetMajorityVar (exp);
                  if (!IsWholeVar (majvar))
                     { error_protocol ("CSHIFT, no full arrays");
                     }
                  hneeded = 0;
                  htop = TopLevel;
                  TopLevel = 0;
                  newexp = NewTempCShift (exp, majvar, 1, &hneeded);
                  TopLevel = htop;

                  if (TopLevel != 1)
                   { MakeTempStmt (newexp, var, no);
                     newexp = mVAR_EXP (NewTempVar (var, no));
                     *needed = *needed + 1;
                   }
                }
               else
                {
                  newexp = NewTempCShift (exp, var, no, needed);
                }
            }
           else if (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == MakeIdent ("SPREAD", 6))
            { error_protocol ("SPREAD not handled for temporaries");
              newexp = exp;
            }
           else if (IntrFuncRed (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
            {
              if (TopLevel != 1)
                { MakeTempStmt (exp, var, no);
                  newexp = mVAR_EXP (NewTempVar (var, no));
                  *needed = *needed + 1;
                }
            }
        }

  }
   return newexp;

  }
  }
  if (exp->Kind == kVAR_EXP) {
# line 277 "TempVars.puma"
  {
# line 279 "TempVars.puma"
 if ( (CountMovements (var, exp) != 0) && (TopLevel != 1))
       {
         MakeTempStmt (exp, var, no);
         newexp = mVAR_EXP (NewTempVar (var, no));
         *needed = *needed + 1;
       }
      else
         newexp = exp;

  }
   return newexp;

  }
  if (exp->Kind == kBTP_LIST) {
  if (exp->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
# line 291 "TempVars.puma"
  {
# line 292 "TempVars.puma"
 count1 = CountMovements (var, exp->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E);
      if (count1 != 0)
       {
         exp->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E = NewTempExp (exp->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E,var,no,needed);
         exp->BTP_LIST.Next = NewTempExp (exp->BTP_LIST.Next, var, no+1, needed);
       }
      else
         exp->BTP_LIST.Next = NewTempExp (exp->BTP_LIST.Next, var, no, needed);

  }
   return exp;

  }
# line 304 "TempVars.puma"
  {
# line 305 "TempVars.puma"
 count1 = CountMovements (var, exp->BTP_LIST.Elem->VAR_PARAM.V);
      if (count1 != 0)
       {
         newexp = mVAR_EXP (exp->BTP_LIST.Elem->VAR_PARAM.V);
         newexp = NewTempExp (newexp, var, no, needed);
         if (newexp->Kind != kVAR_EXP)
           { printf ("Unknown Parameter Error in NewTempExp\n");
             WriteTree (stdout, newexp);
             exit (-1);
           }
         exp->BTP_LIST.Elem->VAR_PARAM.V = newexp->VAR_EXP.V;
         exp->BTP_LIST.Next = NewTempExp (exp->BTP_LIST.Next, var, no+1, needed);
       }
      else
         exp->BTP_LIST.Next = NewTempExp (exp->BTP_LIST.Next, var, no, needed);

  }
   return exp;

  }
  }
  if (exp->Kind == kBTP_EMPTY) {
# line 325 "TempVars.puma"
   return exp;

  }
# line 329 "TempVars.puma"
  {
# line 330 "TempVars.puma"
   printf ("NewTempExp failed, no = %d\n", no);
# line 331 "TempVars.puma"
   printf ("exp = ");
# line 331 "TempVars.puma"
   FileUnparse (stdout, exp);
# line 331 "TempVars.puma"
   printf ("\n");
# line 332 "TempVars.puma"
   exit (- 1);
  }
   return exp;

}

static tTree NewTempCShift
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree var, register int no, pint needed)
# else
(exp, var, no, needed)
 register tTree exp;
 register tTree var;
 register int no;
 pint needed;
# endif
{
# line 340 "TempVars.puma"

tTree newexp;
int htop;

  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
# line 349 "TempVars.puma"
  {
# line 352 "TempVars.puma"

      htop = TopLevel;
      TopLevel = 0;
      exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E = NewTempExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E, var, no, needed);
      TopLevel = htop;
      if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->Kind == kVAR_EXP)
         exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V = exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E->VAR_EXP.V;
      if (TopLevel != 1)
        { MakeTempStmt (exp, var, no);
          newexp = mVAR_EXP (NewTempVar (var, no));
          *needed = *needed + 1;
        }
       else
          newexp = exp;

  }
   return newexp;

  }
# line 374 "TempVars.puma"
  {
# line 376 "TempVars.puma"
 if (!IsWholeVar  (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V))
        {
          MakeTempStmt (mVAR_EXP(exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V), var, no);
          exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V = NewTempVar (var, no);

        }

      if (TopLevel != 1)
       { MakeTempStmt (exp, var, no);
         newexp = mVAR_EXP (NewTempVar (var, no));
         *needed = *needed + 1;
       }
       else
          newexp = exp;

  }
   return newexp;

  }
  }
  }
 yyAbort ("NewTempCShift");
}

static tTree GetMajorityVar
# if defined __STDC__ | defined __cplusplus
(register tTree e)
# else
(e)
 register tTree e;
# endif
{
  if (e->Kind == kVAR_PARAM) {
  if (e->VAR_PARAM.V->Kind == kADDR) {
# line 402 "TempVars.puma"
   return GetMajorityVar (e->VAR_PARAM.V->ADDR.E);

  }
# line 406 "TempVars.puma"
   return e->VAR_PARAM.V;

  }
  if (e->Kind == kFUNC_CALL_EXP) {
  if (equaltIdent (e->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, MakeIdent ("CSHIFT", 6))) {
  if (e->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
# line 410 "TempVars.puma"
   return GetMajorityVar (e->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);

  }
  }
  }
# line 415 "TempVars.puma"
  {
# line 416 "TempVars.puma"
   printf ("GetMajorityVar failes\n");
# line 417 "TempVars.puma"
   FileUnparse (stdout, e);
# line 417 "TempVars.puma"
   printf ("\n");
# line 418 "TempVars.puma"
   WriteTree (stdout, e);
# line 419 "TempVars.puma"
   exit (- 1);
  }
   return NoTree;

}

static tTree NewTempVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int no)
# else
(var, no)
 register tTree var;
 register int no;
# endif
{
# line 433 "TempVars.puma"

tTree newvar;

  if (equalint (no, 0)) {
# line 437 "TempVars.puma"
   return (CopyTree (var));

  }
  if (var->Kind == kUSED_VAR) {
# line 441 "TempVars.puma"
  {
# line 442 "TempVars.puma"

     newvar = NewTempVarObj (var->USED_VAR.VARNAME->VAR_OBJ.Object, no);
     newvar = mUSED_VAR (newvar);

  }
   return (newvar);

  }
  if (var->Kind == kINDEXED_VAR) {
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 449 "TempVars.puma"
  {
# line 450 "TempVars.puma"

     newvar = NewTempVarObj (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object, no);
     newvar = mUSED_VAR (newvar);
     newvar = mINDEXED_VAR (newvar, CopyTree (var->INDEXED_VAR.IND_EXPS));

  }
   return (newvar);

  }
  }
 yyAbort ("NewTempVar");
}

static tTree NewTempVarObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register int no)
# else
(Obj, no)
 register tDefinitions Obj;
 register int no;
# endif
{
# line 468 "TempVars.puma"

char string1[100], string2[100];
tIdent newname;
tTree t;
tObject newobj;

  if (Obj->Kind == kVarObject) {
# line 475 "TempVars.puma"
  {
# line 476 "TempVars.puma"
 GetString (Obj->VarObject.ident, string1);
     sprintf (string2, "%s_TMP%d", string1, no);
     newname = MakeIdent (string2, strlen (string2));
     if (no <= Obj->VarObject.Dist->Distribution.helpvars)
       {
         newobj = GetLocalDecl (newname);
         if (newobj == NoObject)
           { printf ("New Object %s not found \n", string2);
             exit (-1);
           }
         t = mVAR_OBJ (0, newname);
         t->VAR_OBJ.Object = newobj;
       }
     else
       {
         if (no != Obj->VarObject.Dist->Distribution.helpvars + 1)
           { printf ("ERROR: no = %d, helps = %d\n", no, Obj->VarObject.Dist->Distribution.helpvars);
             exit (-1);
           }
         Obj->VarObject.Dist->Distribution.helpvars = no;
         newobj = CopyObject (Obj, newname);
         t = mVAR_OBJ (0, newname);
         t->VAR_OBJ.Object = newobj;
       }

  }
   return t;

  }
 yyAbort ("NewTempVarObj");
}

static tDefinitions CopyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register tIdent newname)
# else
(Obj, newname)
 register tDefinitions Obj;
 register tIdent newname;
# endif
{
# line 514 "TempVars.puma"

tObject newobj;
tTree newdecl;
char string[100];

  if (Obj->Kind == kVarObject) {
  if (Obj->VarObject.decl->Kind == kVAR_DECL) {
  if (Obj->VarObject.Kind->Kind == kVarLocal) {
# line 520 "TempVars.puma"
  {
# line 522 "TempVars.puma"
   if (! (Obj->VarObject.ident == Obj->VarObject.decl->VAR_DECL.Name)) goto yyL1;
  {
# line 523 "TempVars.puma"
 newdecl = mVAR_DECL (newname, Obj->VarObject.decl->VAR_DECL.Pos, CopyTree (Obj->VarObject.decl->VAR_DECL.VAL));
     new_decls = mDECL_LIST (newdecl, new_decls);
     newobj = mVarObject (newname, newdecl,
              mVarLocal (0,Obj->VarObject.Kind->VarLocal.dynamic), 0, CopyDistribution (Obj->VarObject.Dist));
     InsertEntry (newobj);
     if (IsVarAllocatable (newobj))
       {
         new_allocates += 1;
       }

  }
  }
   return newobj;
yyL1:;

  }
  if (Obj->VarObject.Kind->Kind == kVarCommon) {
# line 536 "TempVars.puma"
  {
# line 538 "TempVars.puma"
   if (! (Obj->VarObject.ident == Obj->VarObject.decl->VAR_DECL.Name)) goto yyL2;
  {
# line 539 "TempVars.puma"
 newdecl = mVAR_DECL (newname, Obj->VarObject.decl->VAR_DECL.Pos, CopyTree (Obj->VarObject.decl->VAR_DECL.VAL));
     new_decls = mDECL_LIST (newdecl, new_decls);
     newobj = mVarObject (newname, newdecl,
              mVarLocal (0,0), 0, CopyDistribution (Obj->VarObject.Dist));
     InsertEntry (newobj);
     if (IsVarAllocatable (newobj))
       {
         new_allocates += 1;
       }

  }
  }
   return newobj;
yyL2:;

  }
  }
  if (Obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (Obj->VarObject.Kind->Kind == kVarDummy) {
# line 552 "TempVars.puma"
  {
# line 555 "TempVars.puma"
   if (! (Obj->VarObject.decl->VAR_PARAM_DECL.Name == Obj->VarObject.ident)) goto yyL3;
  {
# line 556 "TempVars.puma"
 newdecl = mVAR_DECL (newname, Obj->VarObject.decl->VAR_PARAM_DECL.Pos, CopyTree (Obj->VarObject.decl->VAR_PARAM_DECL.VAL));
     new_decls = mDECL_LIST (newdecl, new_decls);
     newobj = mVarObject (newname, newdecl,
              mVarLocal (0,Obj->VarObject.Kind->VarDummy.dynamic), 0, CopyDistribution (Obj->VarObject.Dist));
     InsertEntry (newobj);
     if (IsVarAllocatable (newobj))
       {
         new_allocates += 1;
       }

  }
  }
   return newobj;
yyL3:;

  }
  }
# line 569 "TempVars.puma"
  {
# line 571 "TempVars.puma"
   GetString (Obj->VarObject.ident, string);
# line 572 "TempVars.puma"
   obj_error_protocol ("Copy object fails for VarObject", Obj);
  }
   return Obj;

  }
# line 576 "TempVars.puma"
  {
# line 577 "TempVars.puma"
   obj_error_protocol ("Copy Object fails, unknown reasons", Obj);
  }
   return Obj;

}

static tDefinitions CopyDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
  if (d->Kind == kHostDistribution) {
# line 583 "TempVars.puma"
   return mHostDistribution (d->HostDistribution.size, d->HostDistribution.helpvars, d->HostDistribution.hostdist_id);

  }
  if (d->Kind == kNodeDistribution) {
# line 587 "TempVars.puma"
   return mNodeDistribution (d->NodeDistribution.size, d->NodeDistribution.helpvars, d->NodeDistribution.nodedist_id, d->NodeDistribution.dims);

  }
  if (d->Kind == kSerialDistribution) {
# line 591 "TempVars.puma"
   return mSerialDistribution (d->SerialDistribution.size, d->SerialDistribution.helpvars);

  }
  if (d->Kind == kAlignDistribution) {
# line 595 "TempVars.puma"
  {
# line 596 "TempVars.puma"
   printf ("AdaptTemporary: Copy Distribution\n");
# line 597 "TempVars.puma"
   printf ("Align Distribution should no longer exist here\n");
# line 598 "TempVars.puma"
   kill_in_protocol ();
  }
   return d;

  }
 yyAbort ("CopyDistribution");
}

static void NewTempAllocates
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 610 "TempVars.puma"

tObject Obj;

  if (t == NoTree) return;
  if (t->Kind == kACF_LIST) {
# line 614 "TempVars.puma"
  {
# line 615 "TempVars.puma"
   NewTempAllocates (t->ACF_LIST.Elem);
# line 616 "TempVars.puma"
   NewTempAllocates (t->ACF_LIST.Next);
  }
   return;

  }
  if (t->Kind == kACF_EMPTY) {
# line 619 "TempVars.puma"
   return;

  }
  if (t->Kind == kACF_BASIC) {

  switch (t->ACF_BASIC.BASIC_STMT->Kind) {
  case kIO_STMT:
# line 622 "TempVars.puma"
   return;

  case kALLOCATE_STMT:
# line 625 "TempVars.puma"
  {
# line 626 "TempVars.puma"
 t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS = ExtendTempAllocates (t->ACF_BASIC.BASIC_STMT->ALLOCATE_STMT.PARAMS);
  }
   return;

  case kDEALLOCATE_STMT:
# line 629 "TempVars.puma"
  {
# line 630 "TempVars.puma"
 t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS = ExtendTempAllocates (t->ACF_BASIC.BASIC_STMT->DEALLOCATE_STMT.PARAMS);
  }
   return;

  case kCALL_STMT:
# line 633 "TempVars.puma"
   return;

  case kSTOP_STMT:
# line 636 "TempVars.puma"
   return;

  case kGOTO_STMT:
# line 639 "TempVars.puma"
   return;

  case kCOMP_IF_STMT:
# line 642 "TempVars.puma"
   return;

  case kASSIGN_STMT:
# line 645 "TempVars.puma"
   return;

  }

# line 648 "TempVars.puma"
   return;

  }

  switch (t->Kind) {
  case kACF_DUMMY:
# line 651 "TempVars.puma"
   return;

  case kACF_WHILE:
# line 654 "TempVars.puma"
  {
# line 655 "TempVars.puma"
   NewTempAllocates (t->ACF_WHILE.WHILE_BODY);
  }
   return;

  case kACF_DO:
# line 658 "TempVars.puma"
  {
# line 659 "TempVars.puma"
   NewTempAllocates (t->ACF_DO.DO_BODY);
  }
   return;

  case kACF_DOLOCAL:
# line 662 "TempVars.puma"
  {
# line 663 "TempVars.puma"
   NewTempAllocates (t->ACF_DOLOCAL.DOLOCAL_BODY);
  }
   return;

  case kACF_IF:
# line 666 "TempVars.puma"
  {
# line 667 "TempVars.puma"
   NewTempAllocates (t->ACF_IF.THEN_PART);
# line 668 "TempVars.puma"
   NewTempAllocates (t->ACF_IF.ELSE_PART);
  }
   return;

  case kACF_WHERE:
# line 671 "TempVars.puma"
  {
# line 672 "TempVars.puma"
   NewTempAllocates (t->ACF_WHERE.TRUE_PART);
# line 673 "TempVars.puma"
   NewTempAllocates (t->ACF_WHERE.FALSE_PART);
  }
   return;

  case kACF_NODE:
  case kACF_BASIC:
  case kACF_SWITCH:
  case kACF_ALTER:
  case kACF_CASE:
  case kACF_REPEAT:
  case kACF_WITH:
  case kACF_LOOP:
  case kACF_DOVEC:
  case kACF_DOALL:
  case kACF_FORALL:
  case kACF_ON:
  case kACF_BODY:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
# line 676 "TempVars.puma"
   return;

  }

# line 679 "TempVars.puma"
  {
# line 680 "TempVars.puma"
   printf ("NewTempAllocates failed\n");
# line 681 "TempVars.puma"
   WriteTree (stdout, t);
# line 682 "TempVars.puma"
   exit (- 1);
  }
   return;

;
}

static tTree ExtendTempAllocates
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 687 "TempVars.puma"

tTree newp, liste;
int count, i;
tIdent name, newname;
char string1[100], string2[100];

  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kUSED_VAR) {
# line 700 "TempVars.puma"
  {
# line 701 "TempVars.puma"
 t->BTP_LIST.Next = ExtendTempAllocates (t->BTP_LIST.Next);
       liste = t;
       name = TreeVarName (t->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME);
       GetString (name, string1);
       count = NoOfTemporaries (t->BTP_LIST.Elem->VAR_PARAM.V->USED_VAR.VARNAME);
       for (i=1;i<=count;i++)
          { sprintf (string2, "%s_TMP%d", string1, i);
            newname = MakeIdent (string2, strlen (string2));
            newp = mVAR_OBJ (0, newname);
            newp->VAR_OBJ.Object = GetLocalDecl (newname);
            newp = mVAR_PARAM (mUSED_VAR (newp));
            liste = mBTP_LIST (newp, liste);
          }

  }
   return liste;

  }
  if (t->BTP_LIST.Elem->VAR_PARAM.V->Kind == kINDEXED_VAR) {
  if (t->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
# line 724 "TempVars.puma"
  {
# line 725 "TempVars.puma"
 liste = ExtendTempAllocates (t->BTP_LIST.Next);
       name = TreeVarName (t->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME);
       GetString (name, string1);
       count = NoOfTemporaries (t->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME);
       for (i=count;i>0;i--)
          { sprintf (string2, "%s_TMP%d", string1, i);
            newname = MakeIdent (string2, strlen (string2));
            newp = mVAR_OBJ (0, newname);
            newp->VAR_OBJ.Object = GetLocalDecl (newname);
            newp = mINDEXED_VAR (mUSED_VAR(newp), CopyTree (t->BTP_LIST.Elem->VAR_PARAM.V->INDEXED_VAR.IND_EXPS));
            liste = mBTP_LIST (mVAR_PARAM (newp), liste);
          }
       t->BTP_LIST.Next = liste;

  }
   return t;

  }
  }
  }
  }
  if (t->Kind == kBTP_EMPTY) {
# line 742 "TempVars.puma"
   return t;

  }
 yyAbort ("ExtendTempAllocates");
}

static int NoOfTemporaries
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_OBJ) {
  if (t->VAR_OBJ.Object->Kind == kVarObject) {
# line 748 "TempVars.puma"
   return t->VAR_OBJ.Object->VarObject.Dist->Distribution.helpvars;

  }
  }
 yyAbort ("NoOfTemporaries");
}

void BeginTempVars ()
{
}

void CloseTempVars ()
{
}
