/* Installationsskript zur Bankleitzahlen-Datenbank  */
SIGNAL ON ERROR NAME Fehler

SAY " "

/* REXXUTIL laden */
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs

/* Abfrage, in welchem Pfad wir sind */
CALL SysFileTree 'blz.*', datei, 'FO'
IF datei.0 < 3 THEN
DO
   SAY "Anscheinend haben sie das Archiv BLZ*.* noch nicht entpackt."
   SAY "Bitte erledigen Sie dies und beginnen Sie dann nochmal."
   EXIT
END

/* Den Pfad und die Platte extrahieren */
pfad = FILESPEC("path",datei.1)
disk = FILESPEC("drive",datei.1)
path = OVERLAY(pfad,disk,3)

SAY "Installationsscript zu Bankleitzahlen/2  (c) 1996 Uwe Schlenther Software"
SAY "========================================================================="
SAY " "

/* Ansonsten Daten erfragen */
Abfrage:
SAY "In welchem Pfad soll die Bankleitzahlen-Datenbank installiert werden ?"
SAY "(z.B. C:\BLZ)  "
PARSE PULL pfad
IF pfad = "" THEN pfad="C:\BLZ"
SAY " "
SAY "Die Bankleitzahlen-Datenbank wird im Pfad " pfad " installiert."
SAY " "
SAY "Geben sie <return> fr weiter ein, <K> fr Korrektur oder <A> fr Abbruch!"
PULL antwort

/* Auswerten */
IF antwort = "A" THEN SIGNAL Abbruch
IF antwort = "K" THEN SIGNAL Abfrage

SAY "Danke...."

weiter:
/* Jetzt ggf. das Verzeichnis erzeugen */
rc = SysMkDir(pfad)

/* und die dort ntigen Dateien hinverschieben */
INTERPRET "'COPY BLZ.EX? 'pfad'\*.*'"
INTERPRET "'COPY BLZ.DBX 'pfad'\*.*'"
INTERPRET "'COPY BLZ.ID? 'pfad'\*.*'"
INTERPRET "'COPY BLZ.INF 'pfad'\*.*'"

/* Anlegen des Ordners auf der WPS */
SAY " "
SAY "Soll ein Programmobjekt fr die Bankleitzahlen-Datenbank erstellt werden?"
SAY "Geben sie <J> oder <N> ein!"
PULL antwort

/* Auswerten */
IF antwort = "N" THEN SIGNAL Ende
SAY " "
SAY "WPS-Objekte werden erzeugt..."

/* Den Ordner anlegen */
klasse='WPFolder'
titel='Bankleitzahlen-Datenbank'
ort='<WP_DESKTOP>'
param='OBJECTID=<BLZ_ORDNER>;'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Programmobjekt anlegen */
klasse='WPProgram'
titel='Bankleitzahlen-Datenbank'
ort='<BLZ_ORDNER>'
param='PROGTYPE=PM;EXENAME='pfad'\BLZ.EXE;STARTUPDIR='pfad';'
mode='fail'
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Das Hilfeobjekt anlegen */
klasse='WPProgram'
titel='Hilfe zur Bankleitzahlen-Datenbank'
ort='<BLZ_ORDNER>'
param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='pfad';PARAMETERS='pfad'\BLZ.INF;'
mode='fail'
Location = "<WP_TEMPS>"
Title = "Hilfedatei"
rc = SysCreateObject(klasse,titel,ort,param,mode)

/* Ende-Meldung */
Ende:
SAY "Die Bankleitzahlen-Datenbank ist jetzt installiert!"
EXIT

/* Standard-Fehlerhandler */
Fehler:
SAY "Es ist ein Fehler aufgetreten. Bitte versuchen Sie's nochmal!"
EXIT

/* Abbruch des scripts */
Abbruch:
SAY "Schade, da Sie das Installationsprogramm abgebrochen haben!"
EXIT

