/* Ebaybot.cmd */
/* This program will allow a user running REXX or OREXX that can load the socket library
     to bid automatically on eBay auctions at the designated time and price.
     I looked around for a solution for bidding on auctions at the last possible moment I found
     a nice little perl program being developed on Soureforge by, Andrew Wansink.  I'm a big
     fan of REXX so I decided to write my own.  I borrowed some of the socket code from the
     IBM sample code that comes with the socket library.  I also borrowed some date conversion
     code from datergf.cmd.  The HTTP POST was the most difficult and I have no idea if it is 
     in the "correct" format, but it does work.

     Please note to change the hour modifier for your timezone.  Also, if anyone has a way of
     automating that task please let me know.

     I have a web page at http://www.disisit.com/disissnipe/index.html that will run this code
     to manage auctions if you want to use that.

     BTW, use this code completely at your own risk.  I take no liability for missing bids, placing 
     wrong bids, or acne.


     Thanks,
      Tom Dodge
      dodge@qlynk.com
      http://www.disisit.com
      http://www.ethersplit.com
________________________________________________________________
    MTU/MDU delivery, use existing cabling and standard ethernet jacks
without the cost and trouble of DSL.  http://www.ethersplit.com
    The absolute best firefighter & paramedic training software available,
http://www.disisit.com/rapid.html
    Cable modem vs ADSL shootout: http://www.disisit.com/nettest.html


*/

Parse Arg item maxbid user pass bidtime quantity

IF item='' THEN CALL CHECKERROR('item')
IF maxbid='' | user ='' | pass = '' THEN DO
	CALL CHECKERROR('pass')
	maxbid=0
END
IF bidtime='' THEN DO
	bidtime=20	
	CALL CHECKERROR('bidtime')
END
IF quantity='' THEN DO
	quantity=1
	CALL CHECKERROR('quantity')
END
monthdays.1 = 31            
monthdays.2 = 28            
monthdays.3 = 31            
monthdays.4 = 30            
monthdays.5 = 31            
monthdays.6 = 30            
monthdays.7 = 31            
monthdays.8 = 31            
monthdays.9 = 30            
monthdays.10 = 31           
monthdays.11 = 30           
monthdays.12 = 31  
months='JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC' 
numeric digits 12
    /* Load REXX Socket library if not already loaded       */
    If RxFuncQuery("SockLoadFuncs") Then
     Do
       Call RxFuncAdd "SockLoadFuncs","rxsock","SockLoadFuncs"
       Call SockLoadFuncs
     End

    /* retrieve the header of the document specified by URL */


router='cgi.ebay.com'

command='GET /aw-cgi/eBayISAPI.dll?ViewItem&item='item' HTTP/1.0'
Header = GetHeader(router, command)

/* Call Lineout "tomtest",Header
Call Lineout "tomtest" */

IF Header='' THEN DO
	say 'Error connecting to cgi.ebay.com'
	exit
END
IF POS('Please check the number and try again',Header) = '0' THEN DO
	PARSE VAR Header . '(Ends'  tmp ')' '-' tmptitle '</title>' 'Currently' '<b>' money '</b>'  .
	tmptitle=STRIP(TRANSLATE(tmptitle,'  ','0D0A'x))
	tmp=STRIP(TRANSLATE(tmp,'  ','0D0A'x))
	PARSE VAR tmp  m '-' d '-' y t zone .
	IF zone \= 'PDT' THEN SAY 'NO PDT HERE!!'
	d=d*1
	m=TRANSLATE(m)
	m=WORDPOS(m,months)
	PARSE VAR t h ':' n ':' s
	y=y+2000
	IF y > 1582 THEN                 /* Gregorian calender */                
		leap_year = (((y // 4) = 0) & \((y // 100) = 0)) | ((y // 400)=0)
	ELSE leap_year = (y // 4) = 0    /* Julian calender    */                
	monthdays.2 = 28 + leap_year                                                

	/* h+2 is VERY important as this is the timezone modifier between PDT and CST */
	/* you will have to modify for your timezone accordingly unless someone can */
	/* tell me a good way to determine local timezone  */
	h=h+2
	IF h>23 THEN DO
		h=h-24
		d=d+1
		IF d > monthdays.m THEN DO
			d=d-monthdays.m
			m=m+1
			IF m>12  THEN DO
				m=1
				y=y+1
			END

		END
	END
	t=h':'n':'s

	say tmptitle
	say 'money='money
	say m'/'d'/'y'   't

end
ELSE DO
	say 'Please check the number and try again'
	exit
END

/* END */

IF maxbid \= 0 THEN DO
           ending=DATE2DAYS(y m d)
	tmp=DATE('S')
	y1=LEFT(tmp,4)
	mn1=SUBSTR(tmp,5,2)
	d1=SUBSTR(tmp,7,2)
	starting=DATE2DAYS(y1 mn1 d1)
	daystime=(ending-starting)*86400
	b=TIME('N')
	say 'Current time: ' b
	parse var b h1 ':' m1 ':' s1
	tmp=0
	tmp=((h-h1)*3600)+tmp
	tmp=((n-m1)*60)+tmp
	tmp=s-s1+tmp-bidtime+daystime

	say 'Delay time will be 'tmp' seconds till bid is placed.'
	say 'Do not close this session, shutdown your computer, or disconnect from the internet.'
	Call SysSleep tmp

	tmx='MfcISAPICommand=MakeBid&item='item'&maxbid='maxbid||'00'x
	command='POST /aw-cgi/eBayISAPI.dll HTTP/1.0'||'0D0A'x||'Content Type: application/x-www-form-urlencoded'||'0D0A'x||'Content-Length: 'length(tmx)||'0D0A'x||tmx

	Header = GetHeader(router, command)
	/* say "Header="Header */
	PARSE VAR Header 'key' 'value="' key '"' .
	IF key \= '' THEN DO
		say key
/*		Call Lineout "tomtest",Header
		Call Lineout "tomtest" */
		tmx='MfcISAPICommand=AcceptBid&item='item'&key='key'&maxbid='maxbid'&quant='quantity'&userid='user'&pass='pass||'00'x
		command='POST /aw-cgi/eBayISAPI.dll HTTP/1.0'||'0D0A'x||'Content Type: application/x-www-form-urlencoded'||'0D0A'x||'Content-Length: 'length(tmx)||'0D0A'x||tmx

		Header = GetHeader(router, command)
/*		Call Lineout "tomtest",Header
		Call Lineout "tomtest" */
	END
	ELSE SAY 'No $KEY received, there is something wrong.'
END


ELSE return y||RIGHT('00'm,2)||RIGHT('00'd,2)' 't'^^'tmptitle

Exit


Connect: Procedure
      Parse Arg Server

      /* if the servername has a port address specified     */
      /* then use this one, otherwise use the default http  */
      /* port 80                                            */
        Port = 80
      /* resolve server name alias to dotted IP address     */
      rc = SockGetHostByName(Server, "Host.!")
      If rc = 0 Then
       Do
         Say "Unable to resolve server:" Server
         Return -1
       End

      /* create a TCP socket                                */
      Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")
      If Socket < 0 Then
       Do
         Say "Unable to create socket"
         Return -1
       End

      /* connect the new socket to the specified server     */
      Host.!family = "AF_INET"
      Host.!port = Port
      rc = SockConnect(Socket, "Host.!")
      If rc < 0 Then
       Do
         Say "Unable to connect to server:" Server
         Call Close Socket
         Return -1
       End

Return Socket



SendCommand: Procedure
      Parse Arg Socket, Command

      /* append two pairs of CRLF to end the command string */
      Command = Command || "0D0A0D0A"x

      BytesSent = SockSend(Socket, Command)
      Response = ""
      Do Forever
        BytesRcvd = SockRecv(Socket, "RcvData", 1024)
        If BytesRcvd <= 0 Then
          Leave
        Response = Response || RcvData
      End

Return Response



Close: Procedure
      Parse Arg Socket
      Call SockShutDown Socket, 2
      Call SockClose Socket
Return



GetHeader: Procedure
      Parse Arg Server, Command

      /* Isolate server name and document name, document    */
      /* name is always preceded with a slash               */

      Socket = Connect(Server)
      If Socket = -1 Then
	Return ""

  /*    Command ="GET /bank/try.html HTTP/1.0" */
      Header = SendCommand(Socket, Command)
      Call Close Socket
Return Header


/*
The following modules borrowed from datergf.cmd


program: datergf.cmd
type:    REXXSAA-OS/2
version: 1.6
date:    1991-05-20
author:  Rony G. Flatscher,
           Wirtschaftsuniversitt/Vienna
           Rony.Flatscher@wu-wien.ac.at
*/
/* calculate days based on 0000/01/01 (= 1. day == 1) */
DATE2DAYS: PROCEDURE  EXPOSE monthdays.
    PARSE ARG year month day

    days_1    = year * 365
    leap_days = year % 4

    IF year > 0 THEN
    DO
       leap_days = leap_days + 1        /* account for leap year in 0000 */

       IF year > 1582 THEN days_1 = days_1 - 10 /* account for 1582, which had 10 days less */

       IF year > 1600 THEN         /* account for Gregorian calender */
       DO
           diff = year - 1600
           leap_days = leap_days - (diff % 100 - diff % 400)
           leap_year = (((diff // 4) = 0) & \((diff // 100) = 0)) | ((diff // 400)=0) /* leap year in hand ? */
       END
       ELSE leap_year = ((year // 4) = 0)       /* leap year in hand ? */

       leap_days = leap_days - leap_year
    END
    days_2 = SUBSTR(date2julian(ARG(1)), 5, 3)

    RETURN (days_1 + leap_days + days_2)
/* end of DATE2DAYS */

/* build Julian date from sorted date, result: yyyyddd */
DATE2JULIAN: PROCEDURE EXPOSE monthdays.
    PARSE ARG year month day

    /* is year a leap year ? */
    IF year > 1582 THEN                 /* Gregorian calender */
       leap_year = (((year // 4) = 0) & \((year // 100) = 0)) | ((year // 400)=0)
    ELSE leap_year = (year // 4) = 0    /* Julian calender    */

    monthdays.2 = 28 + leap_year
    IF year = 1582 THEN monthdays.10 = 21       /* 1582: October just had 21 days */

    result_function = 0
    DO i = 1 TO month - 1
       result_function = result_function + monthdays.i
    END

    IF year = 1582 & month = 10 & day > 4 THEN day = day - 10       /* Gregorian: 10 days too many */
    result_function = result_function + day

    RETURN year||RIGHT(result_function,3,'0')
/* end of DATE2JULIAN */


CHECKERROR: PROCEDURE 
	PARSE ARG tmp
	IF tmp='pass' THEN DO
		say 'Options are:   ebaybot item [maxbid user pass bidtime quantity]'
	END
	IF tmp='bidtime' THEN DO
		say 'No bidtime entered, default 20 seconds is assumed'
	END
	IF tmp='quantity' THEN DO
		say 'No quantity entered, default quantity of 1 is assumed'
	END
	IF tmp='item' THEN DO
		say 'Options are:   ebaybot item [maxbid user pass bidtime quantity]'
		exit
	END
return 0