/* RTrack2.CMD */
/* Sample REXX Program to access AIMS RadioTrack (newer version) using RXRTCTRL.DLL */

/* To run this program, the file RXRTCTRL.DLL must be in */
/* the same directory as this file or in a directory */
/* listed in your LIBPATH. */

/* Prerequisites for RXRTCTRL to work properly:

The following two statements must be in your CONFIG.SYS

IOPL=YES,FXPRINT  (or just IOPL=YES)
DEVICE=D:\OS2\BOOT\TESTCFG.SYS

These statements are added by default by Warp 3 and Warp 4.

*/

/*======================*/
/* Load RXRTCTRL.DLL    */
/*======================*/
CALL RXFuncAdd 'RTLoadFuncs', 'RXRTCTRL', 'RTLoadFuncs'
CALL RTLoadFuncs

SAY ''
SAY '--- Sample REXX Program to access newer RadioTrack FM card.---'
SAY ''

SAY 'CAUTION: This program is capable of writing to I/O directly.'
SAY '         Make sure the rt_Address is set to the same'
SAY '         address as your RadioTrack card.'
SAY '         rt_Address is set to 20C hex by default.'
SAY ''

rt_Address = X2D('20C')   /* enter rt_address in hex. rt_address variable is converted from hex to decimal */

keyhit = ""
DO FOREVER
   SAY "---------------------------------------------------"
   SAY "Type 'x' to eXit..."
   SAY "Commands below are for newer RadioTrack only"
   SAY "(type commands without the quotes):"
   SAY "Type 'on' for radio On; 'off' for radio Off;"
   SAY "'90' to set radio to 90.1 MHz;"
   SAY "'99' to set radio to 99.5 MHz; "
   SAY "'101' to set radio to 101.1 MHz; "
   SAY "'tu' fine tune 90.1 MHz up; 'td' to fine tune 90.1 MHz down;"
   SAY "'t' to check if station is tuned; 'p' to check if radio card is present;"
   SAY "'v' for DLL version."
   SAY "--------------------------------------------------"
   SAY 'Enter selection: '
   PARSE PULL keyhit
   keyhit = Translate(keyhit)
   SELECT

      when keyhit = "90" then    /* set frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = 0       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                              /* No range check takes place and fine_tune should be kept inside this range: */
                              /* -8, -6, -4, -2, 0, 2, 4, 6, 8 since this corresponds to +/-0.1MHz */

          return_data = RT2Freq( rt_Address, freq_value, fine_tune )
          SAY "Set Freq, to 90.1 MHz: " || return_data
          keyhit = ""
        end

      when keyhit = "99" then    /* set frequency  */
        do
          freq_value = 995     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = 0       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                              /* No range check takes place and fine_tune should be kept inside this range: */
                              /* -8, -6, -4, -2, 0, 2, 4, 6, 8 since this corresponds to +/-0.1MHz */

          return_data = RT2Freq( rt_Address, freq_value, fine_tune )
          SAY "Set Freq. to 99.5 MHz: " || return_data
          keyhit = ""
        end

      when keyhit = "101" then    /* set frequency  */
        do
          freq_value = 1011     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                                /* there is no range check, so that must be done in the REXX program */

          fine_tune = 0       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                              /* No range check takes place and fine_tune should be kept inside this range: */
                              /* -8, -6, -4, -2, 0, 2, 4, 6, 8 since this corresponds to +/-0.1MHz */

          return_data = RT2Freq( rt_Address, freq_value, fine_tune )
          SAY "Set Freq. 101.1 MHz: " || return_data
          keyhit = ""
        end

      when keyhit = "TU" then    /* tune frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = fine_tune + 2       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                                          /* No range check takes place and fine_tune should be kept inside this range: */
                                          /* -8, -6, -4, -2, 0, 2, 4, 6, 8 since this corresponds to +/-0.1MHz */
          IF fine_tune > 8 THEN
            fine_tune = 0

          return_data = RT2Freq( rt_Address, freq_value, fine_tune )
          SAY "Tune freq (90.1 MHz+) up: " || return_data

          keyhit = ""
        end

      when  keyhit = "TD" then    /* tune frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = fine_tune - 2       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                                          /* No range check takes place and fine_tune should be kept inside this range: */
                                          /* -8, -6, -4, -2, 0, 2, 4, 6, 8 since this corresponds to +/-0.1MHz */
          IF fine_tune < -8 THEN
            fine_tune = 0

          return_data = RT2Freq( rt_Address, freq_value, fine_tune )
          SAY "Tune freq (90.1 MHz-) down: " || return_data

          keyhit = ""
        end

      when keyhit = "OFF" then    /* Radio Off / mute */
        do
          return_data = RT2Off( rt_Address )    /* rt_address must be decimal */
          SAY "Turn radio off or mute: " || return_data
          keyhit = ""
        end

      when keyhit = "ON" then    /* Radio On / unmute  */
        do
          return_data = RT2On( rt_Address )    /* rt_address must be decimal */
          SAY "Turn radio on or unmute: " || return_data
          keyhit = ""
        end

      when keyhit = "T" then    /* Radio tuned */
        do
          return_data = RT2Tuned( rt_Address, '250' )    /* rt_address must be decimal */
          SAY "Radio is (1=tuned, 0=not tuned): " || return_data
          keyhit = ""
        end

      when keyhit = "P" then    /* New RadioTrack card present */
        do
          return_data = RT2Present( rt_Address )    /* rt_address must be decimal */
          SAY "New RadioTrack is (1=present, 0=not present): " || return_data
          keyhit = ""
        end

      when keyhit = "V" then    /* rxRTCtrl.DLL version */
        do
          return_data = RTDLLVersion()    /* no parameters passed on */
          SAY "DLL version is: " || return_data
          keyhit = ""
        end

   otherwise
     DO
       IF keyhit = "X" THEN
         DO
            CALL RTDropFuncs
            SAY 'RXRTCTRL dropped.'
            EXIT
         END
       ELSE
         SAY "Invalid Input."
     END
   end  /* select */
end /* do */

EXIT

