/* example REXX script to test PMsndX syntax...no errors should be returned */

pmsndx test_mode no
PMSNDX IGNORE_SYNTAX_ERRORS YES

pmsndx test_mode yes
display tools yes
display toolpage format
display toolpage channels
display toolpage average
display toolpage dupe
display toolpage sample
display toolpage rate
display toolpage speed
display toolpage filter
display toolpage bandpass
display toolpage lowpass
display toolpage effect
display toolpage echo
display toolpage invert
display toolpage reverse
display toolpage vibro
display toolpage volume
display toolpage fade
display toolpage limit
display toolpage balance
display toolpage info
display tools no
pmsndx test_mode no


pmsndx test_mode yes
display properties yes
display proppage audio
display proppage memory
display proppage misc
display proppage rexx
display proppage startup
display properties no
pmsndx test_mode no

PMSNDX TEST_MODE YES
display editor yes
display audio yes
display properties yes
display open yes
display save yes
PMSNDX TEST_MODE NO

pmsndx test_mode yes
data=message(ask,ok,text,"test text 1",title,"ok noicon application moveable",icon,noicon,mode,application,moveable,yes)
say "message result:" data
data=message(ask,okcancel,text,"test text 2",title,"okcancel iconhand systemmodal moveable",icon,iconhand,mode,system,moveable,yes)
say "message result:" data
data=message(ask,cancel,text,"test text 3",title,"cancel question notmodal notmoveable",icon,question,moveable,yes)
say "message result:" data
data=message(ask,enter,text,"test text 4",title,"enter exclamation notmodal notmoveable",icon,exclamation,moveable,yes)
say "message result:" data
data=message(ask,entercancel,text,"test text 5",title,"entercancel asterisk notmodal notmoveable",icon,asterisk,moveable,yes)
say "message result:" data
data=message(ask,retrycancel,text,"test text 6",title,"retrycancel information notmodal notmoveable",icon,information,moveable,yes)
say "message result:" data
data=message(ask,abortretryignore,text,"test text 7",title,"abortretryignore query notmodal notmoveable",icon,query,moveable,yes)
say "message result:" data
data=message(ask,yesno,text,"test text 8",title,"yesno warning notmodal notmoveable",icon,warning,moveable,yes)
say "message result:" data
data=message(ask,yesnocancel,text,"test text 9",title,"yesnocancel error notmodal notmoveable",icon,error,moveable,yes)
say "message result:" data
pmsndx test_mode no

data=file(openpath,'d:\WSH\samples')
say "fully qualified path: " data
data=file(savepath,'d:\WSH')
say "fully qualified path: " data

data=file(open,'brettapp.wav')
say "fully qualified path: " data
pmsndx test_mode yes
EDIT MANIPULATE 1
EDIT AREA ENTIRE_SAMPLE
EDIT OPERATION COPY
pmsndx test_mode no

pmsndx test_mode yes
audio volume 80
audio play SYNC
pmsndx test_mode no

pmsndx output NO
data=query("file","openpath");
say "FILE OPENPATH:" data
data=query("file","savepath");
say "FILE SAVEPATH:" data
data=query("file","filename");
say "FILE FILENAME:" data
data=query("info","format");
say "INFO FORMAT:" data
data=query("info","datastyle");
say "INFO DATASTYLE:" data
data=query("info","channels");
say "INFO CHANNELS:" data
data=query("info","rate");
say "INFO RATE:" data
data=query("info","datasize");
say "INFO DATASIZE:" data
data=query("info","samples");
say "INFO SAMPLES:" data
data=query("info","time");
say "INFO TIME:" data
data=query("info","memory");
say "INFO MEMORY:" data
data=query("info","comment");
say "INFO COMMENT:" data
data=query("info","byteorder");
say "AUDIO BYTEORDER:" data
data=query("audio","repeat");
say "AUDIO REPEAT:" data
data=query("audio","channel_selection");
say "AUDIO CHANNEL_SELECTION:" data
data=query("audio","range_selection");
say "AUDIO RANGE_SELECTION:" data
data=query("audio","time");
say "AUDIO TIME:" data
data=query("audio","count");
say "AUDIO COUNT:" data
data=query("audio","memory");
say "AUDIO MEMORY:" data
data=query("audio","input");
say "AUDIO INPUT:" data
data=query("audio","quality");
say "AUDIO QUALITY:" data
data=query("audio","channels");
say "AUDIO CHANNELS:" data
data=query("audio","rate");
say "AUDIO RATE:" data
data=query("audio","overwrite");
say "AUDIO OVERWRITE:" data
data=query("audio","monitor");
say "AUDIO MONITOR:" data
data=query("properties","save_positions");
say "PROPERTIES SAVE_POSITIONS:" data
data=query("properties","save_openpath");
say "PROPERTIES SAVE_OPENPATH:" data
data=query("properties","save_savepath");
say "PROPERTIES SAVE_SAVEPATH:" data
data=query("properties","footnotes");
say "PROPERTIES FOOTNOTES:" dtaa
data=query("properties","memory");
say "PROPERTIES MEMORY:" data
data=query("properties","enable_mmpm");
say "PROPERTIES ENABLE_MMPM:" data
data=query("properties","share_audio");
say "PROPERTIES SHARE_AUDIO:" data
data=query("properties","play_from_commandline");
say "PROPERTIES_PLAY_FROM_CL:" data
data=query("properties","play_on_load");
say "PROPERTIES PLAY_ON_LOAD:" data
data=query("properties","exit_after_commandline_play");
say "PROPERTIES EXIT_AFTER_CL_PLAY:" data
data=query("properties","play_16on8");
say "PROPERTIES PLAY_16ON8:" data
data=query("properties","device");
say "PROPERTIES DEVICE:" data
data=query("properties","undo");
say "PROPERTIES UNDO:" data
data=query("properties","ignore_header_style");
say "PROPERTIES IGNORE_HEADER_STYLE:" data
data=query("properties","require_au_header");
say "PROPERTIES REQUIRE_AU_HEADER:" data
data=query("properties","force_ulaw");
say "PROPERTIES FORCE_ULAW:" data
data=query("properties","rexx_display_history");
say "PROPERTIES REXX_DISPLAY_HISTORY:" data
data=query("properties","ini_path");
say "PROPERTIES INI_PATH:" data
data=query("pmsndx","registered");
say "PMSNDX REGISTERED:" data
data=query(pmsndx,ignore_syntax_errors)
say "PMSNDX IGNORE_SYNTAX_ERRORS:" data
data=query(pmsndx,error_occurred)
say "PMSNDX ERROR_OCCURRED:" data
data=query(pmsndx,test_mode)
say "PMSNDX TEST_MODE:" data
data=query(pmsndx,output)
say "PMSNDX OUTPUT:" data
data=query(pmsndx,close)
say "PMSNDX CLOSE:" data
pmsndx output yes

pmsndx test_mode yes
audio volume 70
audio record sync monitor yes input mic quality 8 channels 1 rate 11025 overwrite yes count 10000
pmsndx test_mode no

say "testing pull capability...type anything and then press ENTER"
pull data
say "pull result: " data

pmsndx test_mode yes
data=file(open,'d:\wsh\samples\applause.au')
say "fully qualified path: " data
data=file(open,'d:\wsh\samples\applause.au',format,au)
say "fully qualified path: " data
audio play SYNC
data=file(open,'\wsh\samples\brettapp.au')
say "fully qualified path: " data
audio play ASYNC
pmsndx test_mode no

pmsndx test_mode yes
properties save_positions no
properties save_openpath no
properties save_savepath no
properties memory auto
properties enable_mmpm yes
properties play_on_load no
properties play_from_commandline yes
properties exit_after_commandline_play yes
properties play_16on8 no
properties device waveaudio01
properties undo yes
properties ignore_header_style yes
properties require_au_header no
properties rexx_display_history 256
properties ini_path 'd:\wsh\pmsndx'
PMSNDX TEST_MODE NO

PMSNDX TEST_MODE no
display editor no
display audio no
display tools no
display properties no
display open no
display save no
PMSNDX TEST_MODE NO

pmsndx test_mode yes
data=file(open,'applause.au')
data=file(open,'applause.au',format,au)
data=file(open,'applause.au',format,aif)
data=file(open,'applause.au',format,hcm)
data=file(open,'applause.au',format,sf)
data=file(open,'applause.au',format,voc)
data=file(open,'applause.au',format,smp)
data=file(open,'applause.au',format,wav)
data=file(open,'applause.au',format,iff)
data=file(open,'applause.au',format,UB,rate,1,channels,1)
data=file(open,'applause.au',format,SB,rate,1,channels,2)
data=file(open,'applause.au',format,UL,rate,1,channels,2)
data=file(open,'applause.au',format,UW,rate,1,channels,2,endian,little)
data=file(open,'applause.au',format,UW,rate,1,channels,2,endian,big)
data=file(open,'applause.au',format,SW,rate,1,channels,2,endian,little)
pmsndx test_mode no

pmsndx test_mode yes
say "Starting AUDIO section>"
audio record sync memory 1 monitor yes input mic quality 8 channels 1 rate 1 overwrite yes
audio record sync time '1:2.3' input mic quality 8 channels 1 rate 1
audio record async time '1:2.3' input mic quality 8 channels 1 rate 1
audio record sync time '1:2.3' input line quality 8 channels 1 rate 1
audio record sync time '1:2.3' input mic quality 16 channels 1 rate 1
audio record sync time '1:2.3' input mic quality 8 channels 2 rate 1
audio record sync time '1:2.3' input mic quality 8 channels 2 rate 1
audio record sync time '1:2.3' input mic quality 8 channels 1 rate 1 overwrite yes
audio record sync time '1:2.3' input mic quality 8 channels 2 rate 1 overwrite no
audio record sync time '1:2.3' input mic quality 8 channels 2 rate 1 monitor yes
audio record sync time '1:2.3' input mic quality 8 channels 2 rate 1 monitor no
audio record sync time '1:2.3' input mic quality 8 channels 1 rate 1 overwrite yes monitor yes
audio record sync time '1:2.3' quality 8 channels 1 rate 1 overwrite yes monitor yes input mic
audio record sync time '1:2.3' channels 1 rate 1 overwrite yes monitor yes input mic quality 8
audio record sync time '1:2.3' rate 1 overwrite yes monitor yes input mic quality 8 channels 1
audio record sync time '1:2.3' overwrite yes monitor yes input mic quality 8 channels 1 rate 1
audio record sync time '1:2.3' monitor yes input mic quality 8 channels 1 rate 1 overwrite yes
audio record sync count 1 monitor yes input mic quality 8 channels 1 rate 1 overwrite yes
pmsndx test_mode no

pmsndx test_mode yes
audio repeat yes
audio repeat no
audio channel_selection yes
audio channel_selection no
audio range_selection yes
audio range_selection no
pmsndx test_mode no

pmsndx test_mode yes
properties save_positions yes                                   /* correct */
properties save_positions no                                    /* correct */
properties save_openpath yes                                    /* correct */
properties save_openpath no                                     /* correct */
properties save_savepath yes                                    /* correct */
properties save_savepath no                                     /* correct */
properties memory auto                                          /* correct */
properties memory 1                                             /* correct */
properties enable_mmpm no                                       /* correct */
properties enable_mmpm yes                                      /* correct */
properties share_audio yes                                      /* correct */
properties share_audio no                                       /* correct */
properties play_on_load yes                                     /* correct */
properties play_on_load no                                      /* correct */
properties exit_after_commandline_play yes                      /* correct */
properties exit_after_commandline_play no                       /* correct */
properties play_16on8 yes                                       /* correct */
properties play_16on8 no                                        /* correct */
properties device waveaudio01                                   /* correct */
properties undo yes                                             /* correct */
properties undo no                                              /* correct */
properties ignore_header_style yes                              /* correct */
properties ignore_header_style no                               /* correct */
properties require_au_header yes                                /* correct */
properties require_au_header no                                 /* correct */
properties force_ulaw yes                                       /* correct */
properties force_ulaw no                                        /* correct */
properties force_ulaw maybe                                     /* correct */
properties rexx_display_history 64                              /* correct */
properties rexx_display_history 32767                           /* correct */
properties ini_path 'd:\wsh\pmsndx'                             /* correct */
properties footnotes yes                                        /* correct */
properties footnotes no                                         /* correct */

edit manipulate all
edit manipulate 1
edit manipulate 2
edit manipulate 3
edit manipulate 4
edit area entire_sample
edit area part start '1:1.1' end '1:1.1'
edit operation copy
edit operation cut
edit operation paste
edit operation zero
edit operation remove
edit operation clear
edit operation merge
edit undo
pmsndx test_mode no

pmsndx test_mode yes
tools format au
tools format aif
tools format hcm
tools format sf
tools format voc
tools format smp
tools format wav
tools format iff
tools format ub
tools format sb
tools format ul
tools format uw
tools format sw
tools format sw

tools average 2_to_1 from left
tools average 2_to_1 from center
tools average 2_to_1 from right

tools average 4_to_1 from fl from fr from rl from rr

tools average 4_to_2 from fl to l
tools average 4_to_2 from fr to l
tools average 4_to_2 from rl to l
tools average 4_to_2 from rr to l
tools average 4_to_2 from fl to r
tools average 4_to_2 from fr to r
tools average 4_to_2 from rl to r
tools average 4_to_2 from rr to r
tools average 4_to_2 from fl to l from fr to l from rl to l from rr to l from fl to r from fr to r from rl to r from rr to r

tools dupe 1_to_2
tools dupe 1_to_4
tools dupe 2_to_4 from l to fl
tools dupe 2_to_4 from l to fr
tools dupe 2_to_4 from l to rl
tools dupe 2_to_4 from l to rr
tools dupe 2_to_4 from r to fl
tools dupe 2_to_4 from r to fr
tools dupe 2_to_4 from r to rl
tools dupe 2_to_4 from r to rr
tools dupe 2_to_4 from l to fl from l to fr from l to rl from l to rr from r to fl from r to fr from r to rl from r to rr

tools rate 1
tools speed 1
tools speed double
tools speed half

tools filter bandpass start 1 cutoff 1
tools filter bandpass start 1 cutoff 1 add_noise no
tools filter bandpass center 1 width 1
tools filter bandpass center 1 width 1 add_noise yes
tools filter lowpass center 1 gain 0.8

tools effect echo mark '1:1.1' volume 0.4 mark '2:2.2' volume 0.4
tools effect invert
tools effect reverse
tools effect vibro speed 15 depth 0.5
tools effect fade direction in method linear
tools effect fade direction out method linear
tools effect fade direction in method slow
tools effect fade direction in method fast
tools effect limit max 80
tools effect limit multiple 1.0
tools effect balance2 l 80 r 80 direction in method linear
tools effect balance2 l 80 r 80 direction out method linear
tools effect balance2 l 80 r 80 direction in method slow
tools effect balance2 l 80 r 80 direction in method fast
tools effect balance2 l 80 r 80 direction in method step
tools effect balance4 fl 80 fr 80 rl 80 rr 80 direction in method linear
tools effect balance4 fl 80 fr 80 rl 80 rr 80 direction out method linear
tools effect balance4 fl 80 fr 80 rl 80 rr 80 direction in method slow
tools effect balance4 fl 80 fr 80 rl 80 rr 80 direction in method fast
tools effect balance4 fl 80 fr 80 rl 80 rr 80 direction in method step
pmsndx test_mode no

pmsndx close no
return 'rexx done'

