/** Read information from a music file and pass it back to the main program
 * This file is part of Plogg, the Ogg Vorbis/mp3 player.
 * Copyright (C)2003 Jeff Robinson
 */


#define INCL_DOSMODULEMGR
#include <os2.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <string.h>
#include <io.h>

#include "plogg.h"

#define IGNORE_ORDINAL_NUMBER   0

/* Prototypes */
char *removespaces(char*, int);

void mp3Data(char *passedName, struct songInfo *currentSong) {

    FILE *mp3File;
    // char buf[31];
    // char buf[128];
    struct ID3 {
        char tag[3];
        char songTitle[30];
        char songArtist[30];
        char songAlbum[30];
        char songYear[4];
        char songMisc[30];
        unsigned char genre;
    } id3Info;

    // First thing we do is set the title of the song to the passed name
    // incase we don't find anything else suitable to fill it with
    strcpy(currentSong->songTitle, passedName);
    strcpy(currentSong->songArtist, "");

    /* Check to see if we can access the file we've been passed */
    if (access(passedName, R_OK) != 0) {
        return;
    }

    // fprintf(stderr, "Opening our file.\n");
    mp3File = fopen(passedName, "r");
    if ( mp3File == NULL ) return;

    _fsetmode(mp3File, "b");

    // (void)fread(&buf, 4, 1, mp3File);
    (void)fseek(mp3File, -128, SEEK_END);
    (void)fread((void*)&id3Info, 128, 1, mp3File);
    (void)fclose(mp3File);

    // if ( !strncmp(id3Info.tag, "TAG", 3) ) {
    if (strncmp(id3Info.tag, "TAG", 3) == 0) {
        strcpy(currentSong->songTitle, removespaces(id3Info.songTitle, 30));
        strcpy(currentSong->songArtist, removespaces(id3Info.songArtist, 30));
        strcpy(currentSong->songAlbum, removespaces(id3Info.songAlbum, 30));
        strcpy(currentSong->songYear, removespaces(id3Info.songYear, 4));
    } else {
        fprintf(stderr, "Not an ID3 TAG\n");
    }

    return;
}

char *removespaces(char *tempString, int maxpos) {
   int i;
   static char buf[256];
   strcpy(buf, tempString);
   buf[maxpos] = 0;
   for (i=maxpos-1;i>-1;i--)
       if ( buf[i] == '\r' ) buf[i] = (int)NULL;
   for(i=maxpos-1;i>-1;i--)
       if (tempString[i] == ' ') buf[i] = (int)NULL; else return buf;
   return buf;
}


