/* $Id: QMInit.c,v 1.21 1998/03/04 21:37:39 hatrack Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "dataStruct.h"
#include "globals.h"
#include "states.h"
#include "quant.h"
#include "QMUtils.h" 
#include "QMInit.h" 


Int ztqQListInit()
{
  Int err, i;

  err=0;

  /* allocatate memory for prevQList */
  for (i = 0; i < mzte_codec.colors; ++i)
    if ((prevQList[i] = (Int *)calloc(mzte_codec.spatial_scalability_levels,
				      sizeof(Int)))==NULL)
    {
      noteError("Can't allocate memory for prevQList.");
      err = -1;
      goto ERR;
    }

  /* allocatate memory for prevQList2 */
  for (i = 0; i < mzte_codec.colors; ++i)
    if ((prevQList2[i] = (Int *)calloc(mzte_codec.spatial_scalability_levels,
				      sizeof(Int)))==NULL)
    {
      noteError("Can't allocate memory for prevQList.");
      err = -1;
      goto ERR;
    }

  /* allocatate memory for prevQList */
  for (i = 0; i < mzte_codec.colors; ++i)
    if ((scaleLev[i] = (Int *)calloc(mzte_codec.spatial_scalability_levels, 
				     sizeof(Int)))==NULL)
    {
      noteError("Can't allocate memory for scaleLev.");
      err = -1;
      goto ERR;
    }

ERR:
  return err;
}


Void ztqQListExit()
{
  Int i;

  for (i = 0; i < mzte_codec.colors; ++i)
  {
    if (prevQList[i] != NULL)
    {
      free(prevQList[i]);
      prevQList[i] = NULL;
    }
    if (prevQList2[i] != NULL)
    {
      free(prevQList2[i]);
      prevQList2[i] = NULL;
    }
    if (scaleLev[i] != NULL)
    {
      free(scaleLev[i]);
      scaleLev[i] = NULL;
    }
  }
}


/* 
   Function Name
   -------------
   int ztqInitDC()

   Arguments 
   ---------
   int decode - 0, if called for encoding. !0, if called for decoding.

   Description
   -----------
   Initialize all information for all DC wavelet coefficients. This must be
   called once before calling the encQuantizeDC function and once before
   calling the decIQuantizeDC function.

   Functions Called
   ----------------
   initQuantSingleStage
   initInvQuantSingleStage

   Return Value
   ------------
   0, if ok. !0, if error.

   Source File
   -----------
   QMInit.c
*/

Int ztqInitDC(Int decode, Int c)
{
  Int err;
  Int x, y;
  Int dummyPrevQ;

  err = 0;

  noteDetail("Initializing DC coefficient information....");
  noteDebug("DC Dimensions: Width=%d, Height=%d", 
	    mzte_codec.dcWidth, mzte_codec.dcHeight);

  for (y = 0; y < mzte_codec.dcHeight; ++y)
    for (x = 0; x < mzte_codec.dcWidth; ++x)
    {
      if (decode)
	initInvQuantSingleStage(&COEFF_QSTATE(x, y, c), &dummyPrevQ);
      else
	initQuantSingleStage(&COEFF_QSTATE(x, y, c), &dummyPrevQ,
			     COEFF_ORGVAL(x,y,c));

      COEFF_TYPE(x, y, c)  = UNTYPED;
      COEFF_STATE(x, y, c) = S_DC;
    }

  noteDetail("Completed initializing of DC coefficient information.");

  return err;
}

/* 
   Function Name
   -------------
   int ztqInitAC()

   Arguments 
   ---------
   int decode - 0, if called for encoding. !0, if called for decoding.

   Description
   -----------
   Initialize all information for all AC wavelet coefficients. This must be
   called once before calling any ztq enc/AC functions and once before calling
   any ztq dec/AC functions.

   Functions Called
   ----------------
   initQuantSingleStage
   initInvQuantSingleStage
   findChild
   isIndexInRootBands

   Return Value
   ------------
   0, if ok. !0, if error.

   Source File
   -----------
   QMInit.c
*/

Int ztqInitAC(Int decode, Int c)
{
  Int err;
  Int x, y, xc[4], yc[4];
  Int height, width;
  Int dummyPrevQ;

  err = 0;

  noteDetail("Initializing AC coefficient information for col %d....",c);

  height = mzte_codec.height >> (c!=0);
  width = mzte_codec.width >> (c!=0);

  noteDebug("Image: Width=%d, Height=%d", width, height);

  for (y = 0; y < height; ++y)
    for (x = 0; x < width; ++x)
    {
      if (x >= mzte_codec.dcWidth || y >= mzte_codec.dcHeight)
      {
	if (decode)
	  initInvQuantSingleStage(&COEFF_QSTATE(x, y, c), &dummyPrevQ);
	else
	{
	  
#ifdef _FORCE_ALL_ZERO_
	  COEFF_ORGVAL(x,y,c)=0;
#endif /*_FORCE_ALL_ZERO_*/
	  
	  initQuantSingleStage(&COEFF_QSTATE(x, y, c), &dummyPrevQ,
			       COEFF_ORGVAL(x,y,c));
	}

	COEFF_TYPE(x, y, c) = UNTYPED;

	/* AC Bands */
	if (findChild(x, y, xc, yc, c)==0 || 
	    x >= mzte_codec.SPlayer[c].width ||
	    y >= mzte_codec.SPlayer[c].height) /* leaf */
	  COEFF_STATE(x, y, c) = S_LEAF;
	else if (isIndexInRootBands(x,y,c)) /* root */
	  COEFF_STATE(x, y, c) = S_ROOT;
	else
	  COEFF_STATE(x, y,c) = S_NZ;
      }
    }

  noteDetail("Completed Initializing of AC coefficient information.");

  return err;
}
