/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Robert Danielsen (Telenor / ACTS-MoMuSyS)
 *   Noel O'Connor (Teltec DCU / ACTS-MoMuSyS)
 *   Aasmund Sandvand (Telenor / ACTS-MoMuSyS)
 *   Regis J. Crinon (Sharp Laboratories of America Inc.)
 *   Frederic Dufaux (Digital Equipment Corp.)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	mom_access.c
 *
 * Author:	Michael Wollborn
 * Created:	19-Feb-96
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	21.04.96 Robert Danielsen: Reformatted. New headers.
 *		31.07.96 Noel O'Connor: Functions for Vol structure.
 *		15.08.96 M.Wollborn: Functions for new VOP elements.
 *		23.09.96 Noel O'Connor: Functions for VO structure
 *		02.02.92 Aasmund Sandvand: Functions for new VOP element.
 *		04.02.97 Noel O'Connor: functions for new VOP/VOL element.
 *		20.02.97 Cecile Dufour: functions for sprite parameters access.
 *					(from inputs of R. Crinon + F. Dufaux)
 *		26.02.97 Noel O'Connor: functions for new VOL elements
 *		22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *              26.04.97 Luis Ducla-Soares: added new access functions for
 *                                          data partioning
 *		12.05.97 Minhua Zhou: added GetVolOBMCDisable
 *              26.05.97 Minhua Zhou: added GetVopAuv() and PutVopAuv(); 
 *              15.07.97 Ulrike Pestel-Schiller: added GetVolConfigScalType(),
 *                           GetVolScalType(),PutVolConfigScalTupe(),PutVolScalType(); 
 *              24.07.97 Minhua Zhou: added GetVopPrevTemp(),PutVopPrevTemp()
 *              04.08.97 Minhua Zhou: added GetVopSearchRangeFor(),PutVopSearchRangeFor()
 *                                          GetVopSearchRangeBack(),PutVopSearchRangeBack()
  *                                  removed PutVolFCodeFor(), PutVolFCodeBack() 
 *              12.08.97 Minhua Zhou: added GetVopTimeIncrementResolution()
 *					    PutVopTimeIncrementResolution()
 *					    GetVolTimeIncrementResolution()
 *					    PutVolTimeIncrementResolution()
 *              09.10.97 Minhua Zhou: added GetVopCoded(), PutVopCoded()
 *              17.04.97 Minhua Zhou: added GetVopShapeMode(), PutVopShapeMode()
 *
 * 
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include "mom_access.h"

/***********************************************************CommentBegin******
 *
 * -- GetImage{xxx} -- Access components of intermediate formats
 *
 *	Char *GetImageData(Image *image)
 *      UInt GetImageSize(Image *image)
 *      UInt GetImageSizeX(Image *image)
 *      UInt GetImageSizeY(Image *image)
 *      Int GetImageVersion(Image *image)
 *      ImageType GetImageType(Image *image)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the common data structures which are used for the
 *      intermediate formats.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of generic image structure
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Char *
GetImageData(Image *image)
{
  switch(GetImageType(image))
    {
    case SHORT_TYPE:
      return((Char *)image->data->s);
      break;
    case FLOAT_TYPE:
      return((Char *)image->data->f);
      break;
    case UCHAR_TYPE:
      return((Char *)image->data->u);
      break;
    default:
      printf("Image type >>%d<< not supported\n",image->type);
      return(NULL);
    }
}

UInt
GetImageSize(Image *image)
{
  return(image->x * image->y);
}

UInt
GetImageSizeX(Image *image)
{
  return(image->x);
}

UInt
GetImageSizeY(Image *image)
{
  return(image->y);
}
  
Int
GetImageVersion(Image *image)
{
  return(image->version);
}

ImageType
GetImageType(Image *image)
{
  return(image->type);
}


/***********************************************************CommentBegin******
 *
 * -- GetImage{xxx} -- Access components of old intermediate formats
 *
 *	SInt *GetImageIData(ImageI *image)
 *      UInt GetImageISize(ImageI *image)
 *      UInt GetImageISizeX(ImageI *image)
 *      UInt GetImageISizeY(ImageI *image)
 *      Float *GetImageFData(ImageF *image)
 *      UInt GetImageFSize(ImageF *image)
 *      UInt GetImageFSizeX(ImageF *image)
 *      UInt GetImageFSizeY(ImageF *image)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the common data structures which are used for the
 *      intermediate formats.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of an "ImageI" and "ImageF"
 *      (for compatibility reasons with old source code)
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

SInt *
GetImageIData(ImageI *image)		/* ImageI */
{
  return(image->data->s);
}

UInt
GetImageISize(ImageI *image)
{
  return(image->x * image->y);
}

UInt
GetImageISizeX(ImageI *image)
{
  return(image->x);
}

UInt
GetImageISizeY(ImageI *image)
{
  return(image->y);
}

Float *
GetImageFData(ImageF *image)		/* Image F */
{
  return(image->data->f);
}

UInt
GetImageFSize(ImageF *image)
{
  return(image->x * image->y);
}

UInt
GetImageFSizeX(ImageF *image)
{
  return(image->x);
}

UInt
GetImageFSizeY(ImageF *image)
{
  return(image->y);
}



/***********************************************************CommentBegin******
 *
 * -- GetVop{xxx} -- Functions to access components of the Vop structure
 *
 *	Int GetVopModTimeBase(Vop *vop)
 *	Int GetVopTimeInc(Vop *vop)
 *      Int GetVopPredictionType(Vop *vop)
 *      Int GetVopWidth(Vop *vop)
 *      Int GetVopHeight(Vop *vop)
 *      Int GetVopHorSpatRef(Vop *vop)
 *      Int GetVopVerSpatRef(Vop *vop)
 *	Int GetVopBackComp(Vop *vop)
 *      Int GetVopQuantizer(Vop *vop)
 *
 *	Int GetVopLoadBackShape(Vop *vop)
 *	Int GetVopLoadForShape(Vop *vop)
 *	Int GetVopRefSelCode(Vop *vop)
 *	Int GetVopForTempRef(Vop *vop)
 *	Int GetVopBackTempRef(Vop *vop)
 *
 *	Int GetVopId(Vop *vop)
 *	Int GetVopVOId(Vop *vop)
 *      Int GetVopArbitraryShape(Vop *vop)
 *      Int GetVopShape(Vop *vop) (== GetVopArbitraryShape())
 *	Int GetVopQuantType(Vop *vop)
 *	Int GetVopLoadIntraQuantMat(Vop *vop)
 *	Int *GetVopIntraQuantMat(Vop *vop)
 *	Int GetVopLoadNonintraQuantMat(Vop *vop)
 *	Int *GetVopNonintraQuantMat(Vop *vop)
 *	Int GetVopLoadGrayIntraQuantMat(Vop *vop)
 *	Int *GetVopGrayIntraQuantMat(Vop *vop)
 *	Int GetVopLoadGrayNonintraQuantMat(Vop *vop)
 *	Int *GetVopGrayNonintraQuantMat(Vop *vop)
 *	Int GetVopIntraACDCPredDisable(Vop *vop)
 *	Int GetVopFCodeFor(Vop *vop)
 *      Int GetVopFCodeBack(Vop *vop)
 *	Int GetVopScalability(Vop *vop)
 *
 *	Int GetVopRefId(Vop *vop)
 *	Int GetVopSampDir(Vop *vop)
 *	Int GetVopHorSampN(Vop *vop)
 *	Int GetVopHorSampM(Vop *vop)
 *	Int GetVopVerSampN(Vop *vop)
 *	Int GetVopVerSampM(Vop *vop)
 *	Int GetVopEnhanceType(Vop *vop)
 *
 *      Int GetVopScaling(Vop *vop)
 *      Int GetVopVisibility(Vop *vop)
 *      Int GetVopBinaryShape(Vop *vop)
 *      Int GetVopCompOrder(Vop *vop)
 *
 *	Int GetVopSpriteUsage(Vop *vop)
 *	Int GetVopNoOfSpritePoints (Vop *vop)
 *	TrajPoint * GetVopRefPointCoord(Vop *vop)
 *	TrajPoint * GetVopTrajPointCoord(Vop *vop)
 *	TrajPoint * GetVopDiffTrajPointCoord(Vop *vop)
 *	Int GetVopBrightnessChangeInSprite(Vop *vop)
 *	Int GetVopLowLatencySpriteEnable(Vop *vop)
 *	Int GetVopBlendFact(Vop *vop)
 *	Int GetVopSpriteHdim(Vop *vop)
 *	Int GetVopSpriteVdim(Vop *vop)
 *      Int GetVopSpriteLeftEdge(Vop *vop)
 *	Int GetVopSpriteTopEdge(Vop *vop)
 *	Int GetVopWarpingAccuracy(Vop *vop)
 *	Vop * GetVopSprite(Vop *vop);
 *	Sprite_motion * GetVopWarpParam(Vop *vop);
 *	Float GetVopBrightnessChangeFactor(Vop *vop)
 *	Int GetVopSpriteTransmitMode(Vop *vop)
 *	Int * GetVopSpriteTabTransmit(Vop *vop)
 *	Int * GetVopSpriteTabAmbType(Vop *vop)
 *	Int * GetVopSpriteTabMvda(Vop *vop)
 *	SInt * GetVopSpriteTabQPStore(Vop *vop)
 *	Int * GetVopSpriteTabDQUANTStore(Vop *vop)
 *	Int *** GetVopSpriteTabDCStore(Vop *vop)
 *
 *      Image *GetVopA(Vop *vop)
 *      Image *GetVopY(Vop *vop)
 *      Image *GetVopU(Vop *vop)
 *      Image *GetVopV(Vop *vop)
 *      Image *GetVopQP(Vop *vop)
 *      Vop *GetVopNextSpat(Vop *vop)
 *      Vop *GetVopNextTemp(Vop *vop)
 *      VopExtend *GetVopExtend(Vop *vop)
 *      Vop *GetVopById(Vop *vop, Int vop_id)
 *	Vop *GetVopByCompOrder(Vop *list, Int comp_order)
 *           Int GetVopShapeEffects(Vop *vop)
 *           Int GetVopReverseVlc(Vop *vop)
 *           Int GetVopDataPartEnable(Vop *vop)
 *
 * Author :		
 *	Michael Wollborn 
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Vop data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vop"
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor: added GetVopSADCTDisable(), GetVopIntraQuantizer()
 *      26.02.97 Noel O'Connor: added GetVopReverseVlc() & GetVopShapeEffects()
 *     	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added GetVopDataPartEnable().
 *			07.05.97 Noel Brady: Added GetVopChangeCrDisable()	
 *      09.07.97 Aasmund Sandvand: added GetVopVOId()
 *      04.08.97 Minhua Zhou : added GetVopOBMCDisable()
 *      04.08.97 Minhua Zhou : added GetVopIntraDCVlcThr()	
 *
 ***********************************************************CommentEnd********/
Int GetVopIsObjectLayerIdentifier(Vop *vop) {
  return (vop->is_object_layer_identifier);
}

 

Int GetVopVisualObjectLayerVerid(Vop *vop) {
  return (vop->visual_object_layer_verid);
}



Int GetVopVisualObjectLayerPriority(Vop *vop) {
  return (vop->visual_object_layer_priority);
}


Int GetVopVolControlParameters(Vop *vop) {
  return (vop->vol_control_parameters);
}

Int GetVopFixedVopRate(Vop *vop) {
  return (vop->fixed_vop_rate);
}

Int GetVopNot8Bit(Vop *vop) {
  return (vop->bits_per_pixel != 8);
}

Int GetVopQuantPrecision(Vop *vop) {
  return (vop->quant_precision);
}

Int GetVopBitsPerPixel(Vop *vop) {
  return (vop->bits_per_pixel);
}

Int GetVopMidGrey(Vop *vop) {
  return (1 << (vop->bits_per_pixel - 1));
}
Int GetVopBrightWhite(Vop *vop) {
  return ((1 << vop->bits_per_pixel) - 1);
}

Int GetVopComplexityEstimationDisable(Vop *vop) {
  return (vop->complexity_estimation_disable);
}



Int GetVopRandomAccessibleVol(Vop *vop) {
  return (vop->random_accessible_vol);
}


Int GetVopConstantAlpha(Vop *vop) {
  return (vop->constant_alpha);
}



Int GetVopConstantAlphaValue(Vop *vop) {
  return (vop->constant_alpha_value);
}


Int GetVopInterlaced(Vop *vop) {
  return (vop->interlaced);
}


Int GetVopTopFieldFirst(Vop *vop) {
  return (vop->top_field_first);
}


Int GetVopAlternateScan(Vop *vop) {
  return (vop->alternate_scan);
}


Int GetVopTimeIncrementResolution(Vop *vop) {
 return (vop->time_increment_resolution);
 }

Int GetVopCoded(Vop *vop) {
  return(vop->vop_coded);
} 

Int
GetVopModTimeBase(Vop *vop)
{
  return(vop->mod_time_base);
}

Int 
GetVopTimeInc(Vop *vop)
{
  return(vop->time_inc);
}

Int
GetVopPredictionType(Vop *vop)
{
  return(vop->prediction_type);
}

Int GetVopIntraDCVlcThr(Vop *vop) 
 {
  return (vop->intra_dc_vlc_thr);
 } 

Int
GetVopRoundingType(Vop *vop)
{
  return(vop->rounding_type);
}

Int
GetVopWidth(Vop *vop)
{
  return(vop->width);
}

Int
GetVopHeight(Vop *vop)
{
  return(vop->height);
}

Int
GetVopHorSpatRef(Vop *vop)
{
  return(vop->hor_spat_ref);
}

Int
GetVopVerSpatRef(Vop *vop)
{
  return(vop->ver_spat_ref);
}

Int
GetVopBackComp(Vop *vop)
{
  return(vop->back_comp);
}


Int
GetVopQuantizer(Vop *vop)
{
  return(vop->quantizer);
}

Int
GetVopBQuantizer(Vop *vop)
{
  return(vop->B_quantizer);
}

Int
GetVopGLQuantizer(Vop *vop)
{
	return(vop->gl_quantizer);
}

Int
GetVopLoadBackShape(Vop *vop)
{
  return(vop->load_back_shape);
}

Int
GetVopLoadForShape(Vop *vop)
{
  return(vop->load_for_shape);
}

Int
GetVopRefSelCode(Vop *vop)
{
  return(vop->ref_sel_code);
}

Int
GetVopForTempRef(Vop *vop)
{
  return(vop->for_temp_ref);
}

Int
GetVopBackTempRef(Vop *vop)
{
  return(vop->back_temp_ref);
}

Int
GetVopId(Vop *vop)
{
  return(vop->ident);
}

Int
GetVopVOId(Vop *vop)
{
  return(vop->vo_id);
}

Int
GetVopArbitraryShape(Vop *vop)
{
  return(vop->arbitrary_shape);
}

Int
GetVopShape(Vop *vop)
{
  return(vop->arbitrary_shape);
}

Int
GetVopShapeEffects(Vop *vop)
{
  return(vop->shape_effects);
}

Int GetVopChangeCRDisable(Vop *vop)
{
	return (vop->change_CR_disable);
}


Int
GetVopQuantType(Vop *vop)
{
  return(vop->quant_type);
}

Int
GetVopLoadIntraQuantMat(Vop *vop)
{
  return(vop->load_intra_quant_mat);
}

Int *
GetVopIntraQuantMat(Vop *vop)
{
  return(vop->intra_quant_mat);
}

Int
GetVopLoadNonintraQuantMat(Vop *vop)
{
  return(vop->load_nonintra_quant_mat);
}

Int *
GetVopNonintraQuantMat(Vop *vop)
{
  return(vop->nonintra_quant_mat);
}

Int
GetVopDisableGrayQuantUpdate(Vop *vop)
{
  return(vop->disable_gray_quant_update);
}

Int
GetVopLoadGrayIntraQuantMat(Vop *vop)
{
  return(vop->load_gray_intra_quant_mat);
}

Int *
GetVopGrayIntraQuantMat(Vop *vop)
{
  return(vop->gray_intra_quant_mat);
}

Int
GetVopLoadGrayNonintraQuantMat(Vop *vop)
{
  return(vop->load_gray_nonintra_quant_mat);
}

Int *
GetVopGrayNonintraQuantMat(Vop *vop)
{
  return(vop->gray_nonintra_quant_mat);
}

Int 
GetVopIntraQuantizer(Vop *vop)
{
	return(vop->intra_quantizer);
}

Int
GetVopErrorResDisable(Vop *vop)
{
	return(vop->error_res_disable);
}

Int
GetVopDataPartEnable(Vop *vop)
{
        return(vop->data_partitioning);
}

Int
GetVopReverseVlc(Vop *vop)
{
	return(vop->reverse_vlc);
}

Int
GetVopIntraACDCPredDisable(Vop *vop)
{
  return(vop->intra_acdc_pred_disable);
}

Int
GetVopSADCTDisable(Vop *vop)
{
	return(vop->sadct_disable);
}
Int 
GetVopOBMCDisable(Vop *vop)
{
      return(vop->obmc_disable);
} 

Int
GetVopFCodeFor(Vop *vop)
{
  return(vop->fcode_for);
}

Int
GetVopFCodeBack(Vop *vop)
{
  return(vop->fcode_back);
}

Int
GetVopSearchRangeFor(Vop *vop)
{
  return(vop->sr_for);
}

Int
GetVopSearchRangeBack(Vop *vop)
{
  return(vop->sr_back);
}

Int GetVopShapeCodingType(Vop *vop)
{
	return(vop->shape_coding_type);
}



Int
GetVopScalability(Vop *vop)
{
  return(vop->scalability);
}

Int
GetVopRefId(Vop *vop)
{
  return(vop->ref_ident);
}

Int
GetVopRefSampDir(Vop *vop)
{
  return(vop->ref_samp_dir);
}

Int
GetVopHorSampN(Vop *vop)
{
  return(vop->hor_samp_n);
}

Int
GetVopHorSampM(Vop *vop)
{
  return(vop->hor_samp_m);
}

Int
GetVopVerSampN(Vop *vop)
{
  return(vop->ver_samp_n);
}

Int
GetVopVerSampM(Vop *vop)
{
  return(vop->ver_samp_m);
}

Int
GetVopEnhanceType(Vop *vop)
{
  return(vop->enhancement_type);
}

Int
GetVopScaling(Vop *vop)
{
  return(vop->scaling);
}

Int
GetVopVisibility(Vop *vop)
{
  return(vop->visibility);
}

Int
GetVopBinaryShape(Vop *vop)
{
  return(vop->binary_shape);
}

Int
GetVopCompOrder(Vop *vop)
{
  return(vop->comp_order);
}

Int     
GetVopSpriteUsage(Vop *vop)
{
  return(vop->sprite_usage);
}

Int     
GetVopNoOfSpritePoints(Vop *vop)
{
  return(vop->no_of_sprite_points);
}

TrajPoint *    
GetVopRefPointCoord(Vop *vop)
{
  return(vop->ref_point_coord);
}

TrajPoint *    
GetVopTrajPointCoord(Vop *vop)
{
  return(vop->traj_point_coord);
}

TrajPoint *    
GetVopDiffTrajPointCoord(Vop *vop)
{
  return(vop->difftraj_point_coord);
}

Int     
GetVopBrightnessChangeInSprite(Vop *vop)
{
  return(vop->brightness_change_in_sprite);
}

Int     
GetVopLowLatencySpriteEnable(Vop *vop)
{
  return(vop->low_latency_sprite_enable);
}

Int    
GetVopBlendFact(Vop *vop)
{
  return(vop->blend_fact);
}

Int    
GetVopSpriteHdim(Vop *vop)
{
  return(vop->sprite_hdim);
}

Int    
GetVopSpriteVdim(Vop *vop)
{
  return(vop->sprite_vdim);
}

Int    
GetVopSpriteLeftEdge(Vop *vop)
{
  return(vop->sprite_left_edge);
}

Int    
GetVopSpriteTopEdge(Vop *vop)
{
  return(vop->sprite_top_edge);
}

Int    
GetVopWarpingAccuracy(Vop *vop)
{
  return(vop->warping_accuracy);
}

Vop *
GetVopSprite(Vop *vop)
{
  return(vop->rec_sprite);
}

Sprite_motion *
GetVopWarpParam(Vop *vop)
{
  return(vop->warp_param);
}

Float
GetVopBrightnessChangeFactor(Vop *vop)
{
  return(vop->brightness_change_factor);
}

Int
GetVopSpriteTransmitMode(Vop *vop)
{
	return(vop->sprite_transmit_mode);
}

Int *
GetVopSpriteTabTransmit(Vop *vop)
{
	return(vop->tab_transmit);
}

Int *
GetVopSpriteTabAmbType(Vop *vop)
{
	return(vop->tab_amb_type);
}

Int *
GetVopSpriteTabMvda(Vop *vop)
{
	return(vop->tab_mvda);
}

SInt *
GetVopSpriteTabQPStore(Vop *vop)
{
	return(vop->tab_QP_store);
}

Int *
GetVopSpriteTabDQUANTStore(Vop *vop)
{
	return(vop->tab_DQUANT_store);
}

Int ***
GetVopSpriteTabDCStore(Vop *vop)
{
	return(vop->tab_DC_store);
}

Image *
GetVopA(Vop *vop)
{
  return(vop->a_chan);
}

Image *
GetVopAuv(Vop *vop)
{
  return(vop->a_uv_chan);
}

Image *
GetVopShapeMode(Vop *vop)
{
  return(vop->shape_mode);
}


Image *
GetVopY(Vop *vop)
{
  return(vop->y_chan);
}

Image *
GetVopU(Vop *vop)
{
  return(vop->u_chan);
}

Image *
GetVopV(Vop *vop)
{
  return(vop->v_chan);
}

Image *
GetVopQP(Vop *vop)
{
  return(vop->QP_chan);
}

Vop *
GetVopNextSpat(Vop *vop)
{
  return(vop->pnext_spat);
}

Vop *
GetVopNextTemp(Vop *vop)
{
  return(vop->pnext_temp);
}

Vop *
GetVopPrevTemp(Vop *vop)
{
  return(vop->pprev_temp);
}

/* 1197-3 SONY */
Vop *
GetVopBvopTemp(Vop *vop)
{
  return(vop->pbvop_temp);
}
/* 1197-3 */


VopExtend *
GetVopExtend(Vop *vop)
{
  return(vop->pextend);
}

Vop *
GetVopById(Vop *vop, Int vop_id)
{
  Vop *locvop;
  Int id;
  
  locvop = vop;
  
  while(locvop != NULL)
    {
      id = GetVopId(locvop);
      if(id != vop_id)
	locvop = GetVopNextSpat(locvop);
      else
	break;
    }
  
  return(locvop);
}


Vop *
GetVopByCompOrder(Vop *list, Int comp_order)
{
  Vop          *curr_vop;

  Int          vop_comp_order;

  curr_vop = list;

  while(curr_vop != NULL) 
    {   
   
      vop_comp_order = GetVopCompOrder(curr_vop);
   
      if(vop_comp_order == comp_order)
	{
	  return(curr_vop);
	}
      else
	{
	  curr_vop = GetVopNextSpat(curr_vop);
	}
    }

  return NULL;
}


/***********************************************************CommentBegin******
 *
 * -- PutVop{xxx} -- Functions to write to components of the Vop structure
 *	
 *	Void PutVopModTimeBase(Int mod_time_base, Vop *vop)
 *	Void PutVopTimeInc(Int time_inc, Vop *vop)
 *      Void PutVopPredictionType(Int prediction_type, Vop *vop)
 *      Void PutVopWidth(Int width, Vop *vop)
 *      Void PutVopHeight(Int height, Vop *vop)
 *      Void PutVopHorSpatRef(Int hor_spat_ref, Vop *vop)
 *      Void PutVopVerSpatRef(Int ver_spat_ref, Vop *vop)
 *	Void PutVopBackComp(Int back_comp, Vop *vop)
 *      Void PutVopQuantizer(Int quantizer, Vop *vop)
 *
 *	Void PutVopLoadBackShape(Int load_back_shape, Vop *vop)
 *	Void PutVopLoadForShape(Int load_for_shape, Vop *vop)
 *	Void PutVopRefSelCode(Int ref_sel_code, Vop *vop)
 *	Void PutVopForTempRef(Int for_temp_ref, Vop *vop)
 *	Void PutVopBackTempRef(Int back_temp_ref, Vop *vop)
 *
 *	Void PutVopId(Int ident, Vop *vop)
 *	Void PutVopVOId(Int vo_id, Vop *vop)
 *      Void PutVopArbitraryShape(Int arbitrary_shape, Vop *vop)
 *      Void PutVopShape(Int arbitrary_shape, Vop *vop) (==...ArbitraryShape())
 *      Void PutVopQuantType(Int quant_type, Vop *vop)
 *      Void PutVopLoadIntraQuantMat(Int load_intra_quant_mat, Vop *vop)
 *      Void PutVopIntraQuantMat(Int *intra_quant_mat, Vop *vop)
 *      Void PutVopLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vop *vop)
 *      Void PutVopNonintraQuantMat(Int *nonintra_quant_mat, Vop *vop)
 *      Void PutVopLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vop *vop)
 *      Void PutVopGrayIntraQuantMat(Int *gray_intra_quant_mat, Vop *vop)
 *      Void PutVopLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vop *vop)
 *      Void PutVopGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vop *vop)
 *	Void PutVopIntraACDCPredDisable(Int intra_dcpred_disable, Vop *vop)
 *	Void PutVopFCodeFor(Int fcode_for, Vop *vop);
 *      Void PutVopFCodeBack(Int fcode_back, Vop *vop);
 *      Void PutVopSepMotShapeText(Int sep_mot_text, Vop *vop) (==..SepMot..())
 *      Void PutVopScalability(Int scalability, Vop *vop)
 *
 *	Void PutVopRefId(Int ref_ident, Vop *vop)
 *	Void PutVopRefSampDir(Int ref_samp_dir, Vop *vop)
 *	Void PutVopHorSampN(Int hor_samp_n, Vop *vop)
 *	Void PutVopHorSampM(Int hor_samp_m, Vop *vop)
 *	Void PutVopVerSampN(Int ver_samp_n, Vop *vop)
 *	Void PutVopVerSampM(Int ver_samp_m, Vop *vop)
 *	Void PutVopEnhanceType(Int enhancement_type, Vop *vop)
 *
 *      Void PutVopScaling(Int scaling, Vop *vop)
 *      Void PutVopVisibility(Int visibility, Vop *vop)
 *      Void PutVopBinaryShape(Int binary_shape, Vop *vop)
 *      Void PutVopCompOrder(Int comp_order, Vop *vop)
 *
 *	Void PutVopSpriteUsage(Int sprite_usage, Vop *vop)
 *	Void PutVopNoOfSpritePoints(Int no_of_sprite_points, Vop *vop)
 *	Void PutVopRefPointCoord(TrajPoint *ref_point_coord, Vop *vop)
 * 	Void PutVopTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
 * 	Void PutVopDiffTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
 *	Void PutVopBrightnessChangeInSprite(Int brightness_change_in_sprite, Vop *vop)
 *	Void PutVopLowLatencySpriteEnable(Int low_latency_sprite_enable, Vop *vop)
 *	Void PutVopBlendFact(Int blend_fact, Vop *vop)
 *	Void PutVopSpriteHdim(Int sprite_hdim, Vop *vop)
 *	Void PutVopSpriteVdim(Int sprite_vdim, Vop *vop)
 *      Void PutVopSpriteLeftEdge(Int sprite_left_edge, Vop *vop)
 *	Void PutVopSpriteTopEdge(Int sprite_top_edge, Vop *vop)
 *	Void PutVopWarpingAccuracy(Int warping_accuracy, Vop *vop)
 *	Void PutVopSprite(Vop *rec_sprite, Vop *vop)
 *	Void PutVopWarpParam(Sprite_motion *warp_param, Vop *vop)
 *	Void PutVopBrightnessChangeFactor(Float lighintg_change_factor, Vop *vop)
 *	Void PutVopSpriteTransmitMode(Int sprite_transmit_mode, Vop *vop);
 *	Void PutVopSpriteTabTransmit(Int *tab_transmit, Vop *vop);
 *	Void PutVopSpriteTabAmbType(Int *tab_amb_type, Vop *vop);
 *	Void PutVopSpriteTabMvda(Int *tab_mvda, Vop *vop);
 *	Void PutVopSpriteTabQPStore(SInt *tab_QP_store, Vop *vop);
 *	Void PutVopSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vop *vop);
 *	Void PutVopSpriteTabDCStore(Int ***tab_DC_store, Vop *vop);
 *
 *      Void PutVopA(Image *a_chan, Vop *vop)
 *      Void PutVopY(Image *y_chan, Vop *vop)
 *      Void PutVopU(Image *u_chan, Vop *vop)
 *      Void PutVopV(Image *v_chan, Vop *vop)
 *      Void PutVopQP(Image *QP_chan, Vop *vop)
 *      Void PutVopNextSpat(Vop *pnext_spat, Vop *vop)
 *      Void PutVopNextTemp(Vop *pnext_temp, Vop *vop)
 *      Void PutVopExtend(VopExtend *pextend, Vop *vop)
 *		  Void PutVopShapeEffects(Int shape_effects, Vop *vop)
 *		  Void PutVopReverseVlc(Int reverse_vlc, Vop *vop)
 *                Void PutVopDataPartEnable(Int data_partitioning, Vop *vop)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vop structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vop" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor: added PutVopSADCTDisable(), PutVopIntraQuantizer()
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added PutVopDataPartEnable().
 *	07.07.97 Noel Brady: Add PutVopChangeCRDisable().   	
 *      09.07.97 Aasmund Sandvand: added PutVopVOId()
 *      04.08.97 Minhua Zhou : added PutVopOBMCDisable()
 *                             PutVopIntraDCVlcThr()	
 *
 ***********************************************************CommentEnd********/


Void PutVopVolControlParameters(Int vol_control_parameters,Vop *vop) {
   vop->vol_control_parameters = vol_control_parameters;
} 


Void PutVopQuantPrecision(Int quant_precision,Vop *vop) {
   vop->quant_precision = quant_precision;
} 

Void PutVopComplexityEstimationDisable(Int complexity_estimation_disable,Vop *vop) {
   vop->complexity_estimation_disable = complexity_estimation_disable;
} 

Void PutVopRandomAccessibleVol(Int random_accessible_vol,Vop *vop) {
   vop->random_accessible_vol = random_accessible_vol;
}


Void PutVopIsObjectLayerIdentifier(Int is_object_layer_identifier,Vop *vop) {
   vop->is_object_layer_identifier = is_object_layer_identifier;
}

Void PutVopVisualObjectLayerVerid(Int visual_object_layer_verid,Vop *vop) {
   vop->visual_object_layer_verid = visual_object_layer_verid;
} 

Void PutVopVisualObjectLayerPriority(Int visual_object_layer_priority,Vop *vop) {
   vop->visual_object_layer_priority = visual_object_layer_priority;
} 

Void PutVopFixedVopRate(Int fixed_vop_rate,Vop *vop) {
   vop->fixed_vop_rate = fixed_vop_rate;
} 

Void PutVopBitsPerPixel(Int bits_per_pixel,Vop *vop) {
   vop->bits_per_pixel = bits_per_pixel;
} 

Void PutVopConstantAlpha(Int constant_alpha,Vop *vop) {
   vop->constant_alpha = constant_alpha;
}

Void PutVopConstantAlphaValue(Int constant_alpha_value,Vop *vop) {
   vop->constant_alpha_value = constant_alpha_value;
}

Void PutVopInterlaced(Int interlaced,Vop *vop) {
   vop->interlaced = interlaced;
}

Void PutVopTopFieldFirst(Int top_field_first,Vop *vop) {
   vop->top_field_first = top_field_first;
}

Void PutVopAlternateScan(Int alternate_scan,Vop *vop) {
   vop->alternate_scan = alternate_scan;
}

Void PutVopTimeIncrementResolution(Int time_incre_res, Vop *vop) {
  vop->time_increment_resolution=time_incre_res;
 }

Void 
PutVopCoded(Int vop_coded, Vop *vop) {
  vop->vop_coded = vop_coded;
}

Void
PutVopModTimeBase(Int mod_time_base, Vop *vop)
{
  vop->mod_time_base = mod_time_base;
}

Void
PutVopTimeInc(Int time_inc, Vop *vop)
{
  vop->time_inc = time_inc;
}

Void
PutVopPredictionType(Int prediction_type, Vop *vop)
{
  vop->prediction_type = prediction_type;
}

Void PutVopIntraDCVlcThr(Int intra_dc_vlc_thr,Vop *vop) 
 {
  vop->intra_dc_vlc_thr=intra_dc_vlc_thr;
 } 

Void
PutVopRoundingType(Int rounding_type, Vop *vop)
{
  vop->rounding_type = rounding_type;
}

Void
PutVopWidth(Int width, Vop *vop)
{
  vop->width = width;
}

Void
PutVopHeight(Int height, Vop *vop)
{
  vop->height = height;
}

Void
PutVopHorSpatRef(Int hor_spat_ref, Vop *vop)
{
  vop->hor_spat_ref = hor_spat_ref;
}

Void
PutVopVerSpatRef(Int ver_spat_ref, Vop *vop)
{
  vop->ver_spat_ref = ver_spat_ref;
}

Void
PutVopBackComp(Int back_comp, Vop *vop)
{
  vop->back_comp = back_comp;
}


Void
PutVopQuantizer(Int quantizer, Vop *vop)
{
  vop->quantizer = quantizer;
}

Void
PutVopBQuantizer(Int B_quantizer, Vop *vop)
{
  vop->B_quantizer = B_quantizer;
}

Void
PutVopGLQuantizer(Int gl_quant, Vop *vop)
{
	vop->gl_quantizer = gl_quant;
}

Void
PutVopLoadBackShape(Int load_back_shape, Vop *vop)
{
  vop->load_back_shape = load_back_shape;
}

Void
PutVopLoadForShape(Int load_for_shape, Vop *vop)
{
  vop->load_for_shape = load_for_shape;
}

Void
PutVopRefSelCode(Int ref_sel_code, Vop *vop)
{
  vop->ref_sel_code = ref_sel_code;
}

Void
PutVopForTempRef(Int for_temp_ref, Vop *vop)
{
  vop->for_temp_ref = for_temp_ref;
}

Void
PutVopBackTempRef(Int back_temp_ref, Vop *vop)
{
  vop->back_temp_ref = back_temp_ref;
}

Void
PutVopId(Int ident, Vop *vop)
{
  vop->ident = ident;
}

Void
PutVopVOId(Int vo_id, Vop *vop)
{
  vop->vo_id = vo_id;
}

Void
PutVopArbitraryShape(Int arbitrary_shape, Vop *vop)
{
  vop->arbitrary_shape = arbitrary_shape;
}

Void
PutVopShape(Int arbitrary_shape, Vop *vop)
{
  vop->arbitrary_shape = arbitrary_shape;
}

Void
PutVopShapeEffects(Int shape_effects, Vop *vop)
{
	vop->shape_effects = shape_effects;
}

Void
PutVopChangeCRDisable(Int change_CR_disable, Vop *vop)
{
	vop->change_CR_disable = change_CR_disable;
}


Void
PutVopQuantType(Int quant_type, Vop *vop)
{
  vop->quant_type = quant_type;
}

Void
PutVopLoadIntraQuantMat(Int load_intra_quant_mat, Vop *vop)
{
  vop->load_intra_quant_mat = load_intra_quant_mat;
}

#if 0
Void
PutVopIntraQuantMat(Int *intra_quant_mat, Vop *vop)
{
  vop->intra_quant_mat = intra_quant_mat;
}
#endif

Void
PutVopLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vop *vop)
{
  vop->load_nonintra_quant_mat = load_nonintra_quant_mat;
}

#if 0
Void
PutVopNonintraQuantMat(Int *nonintra_quant_mat, Vop *vop)
{
  vop->nonintra_quant_mat = nonintra_quant_mat;
}
#endif

Void
PutVopDisableGrayQuantUpdate(Int disable_gray_quant_update, Vop *vop)
{
  vop->disable_gray_quant_update = disable_gray_quant_update;
}

Void
PutVopLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vop *vop)
{
  vop->load_gray_intra_quant_mat = load_gray_intra_quant_mat;
}

#if 0
Void
PutVopGrayIntraQuantMat(Int *gray_intra_quant_mat, Vop *vop)
{
  vop->gray_intra_quant_mat = gray_intra_quant_mat;
}
#endif

Void
PutVopLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vop *vop)
{
  vop->load_gray_nonintra_quant_mat = load_gray_nonintra_quant_mat;
}

#if 0
Void
PutVopGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vop *vop)
{
  vop->gray_nonintra_quant_mat = gray_nonintra_quant_mat;
}
#endif

Void
PutVopErrorResDisable(Int flag,Vop *vop)
{
	vop->error_res_disable = flag;
}

Void
PutVopDataPartEnable(Int flag, Vop *vop)
{
        vop->data_partitioning = flag;
}

Void
PutVopOBMCDisable(Int flag, Vop *vop)
{
        vop->obmc_disable = flag;
}

Void
PutVopReverseVlc(Int reverse_vlc,Vop *vop)
{
	vop->reverse_vlc = reverse_vlc;
}

Void
PutVopIntraACDCPredDisable(Int intra_acdc_pred_disable, Vop *vop)
{
  vop->intra_acdc_pred_disable = intra_acdc_pred_disable;
}

Void
PutVopSADCTDisable(Int sadct_disable, Vop *vop)
{
	vop->sadct_disable = sadct_disable;
}

Void
PutVopFCodeFor(Int fcode_for, Vop *vop)
{
  vop->fcode_for = fcode_for;
}

Void
PutVopFCodeBack(Int fcode_back, Vop *vop)
{
  vop->fcode_back = fcode_back;
}


Void
PutVopSearchRangeFor(Int sr_for, Vop *vop)
{
  vop->sr_for = sr_for;
}

Void
PutVopSearchRangeBack(Int sr_back, Vop *vop)
{
  vop->sr_back = sr_back;
}

Void
PutVopShapeCodingType(Int shape_coding_type, Vop *vop)
{
  vop->shape_coding_type = shape_coding_type;
}




Void
PutVopScalability(Int scalability, Vop *vop)
{
  vop->scalability = scalability;
}

Void
PutVopRefId(Int id,Vop *vop)
{
  vop->ref_ident = id;
}

Void
PutVopRefSampDir(Int dir,Vop *vop)
{
  vop->ref_samp_dir = dir;
}

Void
PutVopHorSampN(Int n,Vop *vop)
{
  vop->hor_samp_n = n;
}

Void
PutVopHorSampM(Int m,Vop *vop)
{
  vop->hor_samp_m = m;
}

Void
PutVopVerSampN(Int n,Vop *vop)
{
  vop->ver_samp_n = n;
}

Void
PutVopVerSampM(Int m,Vop *vop)
{
  vop->ver_samp_m = m;
}

Void
PutVopEnhanceType(Int type,Vop *vop)
{
  vop->enhancement_type = type;
}

Void
PutVopScaling(Int scaling, Vop *vop)
{
  vop->scaling = scaling;
}

Void
PutVopVisibility(Int visibility, Vop *vop)
{
  vop->visibility = visibility;
}

Void
PutVopBinaryShape(Int binary_shape, Vop *vop)
{
  vop->binary_shape = binary_shape;
}

Void
PutVopCompOrder(Int comp_order, Vop *vop)
{
  vop->comp_order = comp_order;
}

Void
PutVopSpriteUsage(Int sprite_usage, Vop *vop)
{
  vop->sprite_usage = sprite_usage;
}

Void
PutVopNoOfSpritePoints(Int no_of_sprite_points, Vop *vop)
{
  vop->no_of_sprite_points = no_of_sprite_points;
}

Void
PutVopRefPointCoord(TrajPoint *ref_point_coord, Vop *vop)
{
  vop->ref_point_coord = ref_point_coord;
}

Void
PutVopTrajPointCoord(TrajPoint *traj_point_coord, Vop *vop)
{
  vop->traj_point_coord = traj_point_coord;
}

Void
PutVopDiffTrajPointCoord(TrajPoint *difftraj_point_coord, Vop *vop)
{
  vop->difftraj_point_coord = difftraj_point_coord;
}

Void
PutVopBrightnessChangeInSprite(Int brightness_change_in_sprite, Vop *vop)
{
  vop->brightness_change_in_sprite = brightness_change_in_sprite;
}

Void
PutVopBlendFact(Int blend_fact, Vop *vop)
{
  vop->blend_fact = blend_fact;
}

Void
PutVopLowLatencySpriteEnable(Int low_latency_sprite_enable, Vop *vop)
{
  vop->low_latency_sprite_enable = low_latency_sprite_enable;
}

Void
PutVopSpriteHdim(Int sprite_hdim, Vop *vop)
{
  vop->sprite_hdim = sprite_hdim;
}

Void
PutVopSpriteVdim(Int sprite_vdim, Vop *vop)
{
  vop->sprite_vdim = sprite_vdim;
}

Void
PutVopSpriteLeftEdge(Int sprite_left_edge, Vop *vop)
{
  vop->sprite_left_edge = sprite_left_edge;
}

Void
PutVopSpriteTopEdge(Int sprite_top_edge, Vop *vop)
{
  vop->sprite_top_edge = sprite_top_edge;
}

Void
PutVopWarpingAccuracy(Int warping_accuracy, Vop *vop)
{
  vop->warping_accuracy = warping_accuracy;
}

Void
PutVopSprite(Vop *rec_sprite, Vop *vop)
{
  vop->rec_sprite = rec_sprite;
}

Void
PutVopWarpParam(Sprite_motion *warp_param, Vop *vop)
{
  vop->warp_param = warp_param;
}

Void
PutVopBrightnessChangeFactor(Float brightness_change_factor, Vop *vop)
{
  vop->brightness_change_factor = brightness_change_factor;
}

Void
PutVopSpriteTransmitMode(Int sprite_transmit_mode, Vop *vop)
{
  vop->sprite_transmit_mode = sprite_transmit_mode;
}

Void
PutVopSpriteTabTransmit(Int *tab_transmit, Vop *vop)
{
	vop->tab_transmit = tab_transmit;
}

Void
PutVopSpriteTabAmbType(Int *tab_amb_type, Vop *vop)
{
	vop->tab_amb_type = tab_amb_type;
}

Void
PutVopSpriteTabMvda(Int *tab_mvda, Vop *vop)
{
	vop->tab_mvda = tab_mvda;
}

Void
PutVopSpriteTabQPStore(SInt *tab_QP_store, Vop *vop)
{
	vop->tab_QP_store = tab_QP_store;
}

Void
PutVopSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vop *vop)
{
	vop->tab_DQUANT_store = tab_DQUANT_store;
}

Void
PutVopSpriteTabDCStore(Int ***tab_DC_store, Vop *vop)
{
	vop->tab_DC_store = tab_DC_store;
}

Void
PutVopA(Image *a_chan, Vop *vop)
{
  FreeImage(vop->a_chan);
  vop->a_chan = a_chan;
}

Void 
PutVopAuv(Image *a_uv_chan, Vop *vop)
{
  FreeImage(vop->a_uv_chan);
  vop->a_uv_chan = a_uv_chan;
}

Void 
PutVopShapeMode(Image *shape_mode, Vop *vop)
{
  FreeImage(vop->shape_mode);
  vop->shape_mode = shape_mode;
}


Void
PutVopY(Image *y_chan, Vop *vop)
{
  FreeImage(vop->y_chan);
  vop->y_chan = y_chan;
}

Void
PutVopU(Image *u_chan, Vop *vop)
{
  FreeImage(vop->u_chan);
  vop->u_chan = u_chan;
}

Void
PutVopV(Image *v_chan, Vop *vop)
{
  FreeImage(vop->v_chan);
  vop->v_chan = v_chan;
}

Void
PutVopQP(Image *QP_chan, Vop *vop)
{
  FreeImage(vop->QP_chan);
  vop->QP_chan = QP_chan;
}

Void
PutVopNextSpat(Vop *pnext_spat, Vop *vop)
{
  vop->pnext_spat = pnext_spat;
}

Void
PutVopNextTemp(Vop *pnext_temp, Vop *vop)
{
  vop->pnext_temp = pnext_temp;
}

Void
PutVopPrevTemp(Vop *pprev_temp, Vop *vop)
{
  vop->pprev_temp = pprev_temp;
}

/* 1197-3 SONY*/
Void
PutVopBvopTemp(Vop *pbvop_temp, Vop *vop)
{
  vop->pbvop_temp = pbvop_temp;
}
/* 1197-3 */

Void
PutVopExtend(VopExtend *pextend, Vop *vop)
{
  vop->pextend = pextend;
}

Void
PutVopIntraQuantizer(Int Q,Vop *vop)
{
	vop->intra_quantizer = Q;
}

/***********************************************************CommentBegin******
 *
 * -- GetMotion{xxx} -- Access components of a "Motion" structure
 *
 *	Int GetMotionId(Motion *motion)
 *      Float *GetMotionAffine(Motion *motion)
 *      Image *GetMotionVectorFieldX(Motion *motion, Int num)
 *      Image *GetMotionVectorFieldY(Motion *motion, Int num)
 *      Int GetMotionUnderX(Motion *motion, Int num)
 *      Int GetMotionUnderY(Motion *motion, Int num)
 *      Int GetMotionResX(Motion *motion, Int num)
 *      Int GetMotionResY(Motion *motion, Int num)
 *
 * Author :		
 *	Michael Wollborn
 *
 * Created :		
 *	19-Feb-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Motion structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Motion" structure.
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Int
GetMotionId(Motion *motion)
{
  return(motion->ident);
}

Float *
GetMotionAffine(Motion *motion)
{
  return(motion->affine_pars);
}

Image *
GetMotionVectorFieldX(Motion *motion, Int num)
{
  return(motion->dvf_x[num]);
}

Image *
GetMotionVectorFieldY(Motion *motion, Int num)
{
  return(motion->dvf_y[num]);
}

Int
GetMotionUnderX(Motion *motion, Int num)
{
  return(motion->under_x[num]);
}

Int
GetMotionUnderY(Motion *motion, Int num)
{
  return(motion->under_y[num]);
}

Int
GetMotionResX(Motion *motion, Int num)
{
  return(motion->resolution_x[num]);
}

Int
GetMotionResY(Motion *motion, Int num)
{
  return(motion->resolution_y[num]);
}


/***********************************************************CommentBegin******
 *
 * -- GetVol{xxx} -- Functions to access components of the Vol structure
 *
 *	Int GetVolId(Vol *vol)
 *	Int GetVolVOId(Vol *vol)
 *      Int GetVolShape(Vol *vol)
 *      Int GetVolWidth(Vol *vol)
 *      Int GetVolHeight(Vol *vol)
 *      Int GetVolQuantType(Vol *vol)
 *	Int GetVolLoadIntraQuantMat(Vol *vol)
 *	Int *GetVolIntraQuantMat(Vol *vol)
 *	Int GetVolLoadNonintraQuantMat(Vol *vol)
 *	Int *GetVolNonintraQuantMat(Vol *vol)
 *	Int GetVolLoadGrayIntraQuantMat(Vol *vol)
 *	Int *GetVolGrayIntraQuantMat(Vol *vol)
 *	Int GetVolLoadGrayNonintraQuantMat(Vol *vol)
 *	Int *GetVolGrayNonintraQuantMat(Vol *vol)
 *	Int GetVolErrorResDisable(vol *vol)
 *	Int GetVolBlockFilterDisable(vol *vol)
 *      Int GetVolACDCPredDisable(Vol *vol)
 *	Int GetVolFCodeFor(Vol *vol);
 *      Int GetVolFCodeBack(Vol *vol);
 *      Int GetVolSepMotShapeText(Vol *vol)
 *	Int GetVolScalability(Vol *vol)
 *	Int GetVolScalType(Vol *vol)
 *	Int GetVolRefId(Vol *vol)
 *	Int GetVolSampDir(Vol *vol)
 *	Int GetVolHorSampN(Vol *vol)
 *	Int GetVolHorSampM(Vol *vol)
 *	Int GetVolVerSampN(Vol *vol)
 *	Int GetVolVerSampM(Vol *vol)
 *	Int GetVolEnhanceType(Vol *vol)
 *	Int GetVolSpriteHdim(Vol *vol)
 *	Int GetVolSpriteVdim(Vol *vol)
 *	Int GetVolSpriteInitPieceWidth(Vol *vol)
 *	Int GetVolSpriteInitPieceHeight(Vol *vol)
 *	Int GetVolSpriteInitPieceHorRef(Vol *vol)
 *	Int GetVolSpriteInitPieceVerRef(Vol *vol)
 *      Int GetVolSpriteLeftEdge(Vol *vol)
 *	Int GetVolSpriteTopEdge(Vol *vol)
 *	Int GetVolWarpingAccuracy(Vol *vol)
 *	Int GetVolBlendFact(Vol *vol)
 *	Int GetVolSpriteUsage( Vol *vol)
 *	Int GetVolBrightnessChangeInSprite( Vol *vol )
 *	Int GetVolLowLatencySpriteEnable( Vol *vol )
 *	Int GetVolNoOfSpritePoints( Vol *vol )
 *	TrajPoint * GetVolRefPointCoord( Vol *vol )
 *	TrajPoint * GetVolTrajPointCoord( Vol *vol )
 *	Sprite_motion * GetVolPrevWarpParam( Vol *vol)
 *	Vop * GetVolSprite(Vol *vol)
 *	Int GetVolSpriteTransmitMode(Vol *vol)
 *	Int * GetVolSpriteTabTransmit(Vol *vol)
 *	Int * GetVolSpriteTabAmbType(Vol *vol)
 *	Int * GetVolSpriteTabMvda(Vol *vol)
 *	SInt * GetVolSpriteTabQPStore(Vol *vol)
 *	Int * GetVolSpriteTabDQUANTStore(Vol *vol)
 *	Int *** GetVolSpriteTabDCStore(Vol *vol)
 *      Vol *GetVolNext(Vol *vol)
 *      Vol *GetVolById(Vol *vol, Int vol_id)
 *      Int GetVolReverseVlc(Vol *vol)
 *      Int GetVolDataPartEnable(Vol *vol)
 *
 *
 * Author :		
 *	Noel O'Connor 
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the Vol data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vol"
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor : added GetVolSADCTDisable()
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: Added GetVolDataPartEnable().
 *      09.07.97 Aasmund Sandvand: added GetVolVOId()
 *
 ***********************************************************CommentEnd********/
Int GetVolIsObjectLayerIdentifier(Vol *vol) {
  return (vol->is_object_layer_identifier);
}



Int GetVolVisualObjectLayerVerid(Vol *vol) {
  return (vol->visual_object_layer_verid);
}



Int GetVolVisualObjectLayerPriority(Vol *vol) {
  return (vol->visual_object_layer_priority);
}


Int GetVolVolControlParameters(Vol *vol) {
  return (vol->vol_control_parameters);
}



Int GetVolFixedVopRate(Vol *vol) {
  return (vol->fixed_vop_rate);
}


Int GetVolNot8Bit(Vol *vol) {
  return (vol->bits_per_pixel != 8);
}

Int GetVolQuantPrecision(Vol *vol) {
  return (vol->quant_precision);
}

Int GetVolBitsPerPixel(Vol *vol) {
  return (vol->bits_per_pixel);
}

 


Int GetVolComplexityEstimationDisable(Vol *vol) {
  return (vol->complexity_estimation_disable);
}



Int GetVolRandomAccessibleVol(Vol *vol) {
  return (vol->random_accessible_vol);
}





Int GetVolTimeIncrementResolution(Vol *vol) {
  return vol->time_increment_resolution;
 }

Int
GetVolId(Vol *vol)
{
	return(vol->ident);
}

Int
GetVolVOId(Vol *vol)
{
	return(vol->vo_id);
}

Int
GetVolShape(Vol *vol)
{
	return(vol->shape);
}

Int
GetVolShapeEffects(Vol *vol)
{
	return(vol->shape_effects);
}

Int
GetVolOBMCDisable(Vol *vol)
{
	return(vol->obmc_disable);
}


Int
GetVolWidth(Vol *vol)
{
	return(vol->width);
}

Int
GetVolHeight(Vol *vol)
{
	return(vol->height);
}

Int
GetVolQuantType(Vol *vol)
{
	return(vol->quant_type);
}

Int
GetVolLoadIntraQuantMat(Vol *vol)
{
  return(vol->load_intra_quant_mat);
}

Int *
GetVolIntraQuantMat(Vol *vol)
{
  return(vol->intra_quant_mat);
}

Int
GetVolLoadNonintraQuantMat(Vol *vol)
{
  return(vol->load_nonintra_quant_mat);
}

Int *
GetVolNonintraQuantMat(Vol *vol)
{
  return(vol->nonintra_quant_mat);
}

Int
GetVolDisableGrayQuantUpdate(Vol *vol)
{
  return(vol->disable_gray_quant_update);
}

Int
GetVolLoadGrayIntraQuantMat(Vol *vol)
{
  return(vol->load_gray_intra_quant_mat);
}

Int *
GetVolGrayIntraQuantMat(Vol *vol)
{
  return(vol->gray_intra_quant_mat);
}

Int
GetVolLoadGrayNonintraQuantMat(Vol *vol)
{
  return(vol->load_gray_nonintra_quant_mat);
}

Int *
GetVolGrayNonintraQuantMat(Vol *vol)
{
  return(vol->gray_nonintra_quant_mat);
}

Int
GetVolErrorResDisable(Vol *vol)
{
	return(vol->error_res_disable);
}

Int
GetVolDataPartEnable(Vol *vol)
{
        return(vol->data_partitioning);
}

Int
GetVolReverseVlc(Vol *vol)
{
	return(vol->reverse_vlc);
}

Int
GetVolACDCPredDisable(Vol *vol)
{
	return(vol->intra_acdc_pred_disable);
}

Int 
GetVolSADCTDisable(Vol *vol)
{
	return(vol->sadct_disable);
}



Int
GetVolScalability(Vol *vol)
{
	return(vol->scalability);
}

Int
GetVolScalType(Vol *vol)
{
	return(vol->scal_type);
}

Int
GetVolRefId(Vol *vol)
{
	return(vol->ref_ident);
}

Int
GetVolRefSampDir(Vol *vol)
{
	return(vol->ref_samp_dir);
}

Int
GetVolHorSampN(Vol *vol)
{
	return(vol->hor_samp_n);
}

Int
GetVolHorSampM(Vol *vol)
{
	return(vol->hor_samp_m);
}

Int
GetVolVerSampN(Vol *vol)
{
	return(vol->ver_samp_n);
}

Int
GetVolVerSampM(Vol *vol)
{
	return(vol->ver_samp_m);
}

Int
GetVolEnhanceType(Vol *vol)
{
	return(vol->enhancement_type);
}

Int 
GetVolSpriteHdim(Vol *vol)
{
	return(vol->sprite_hdim);
}

Int
GetVolSpriteVdim(Vol *vol)
{
	return(vol->sprite_vdim);
}

Int
GetVolSpriteLeftEdge(Vol *vol)
{
	return(vol->sprite_left_edge);
}

Int
GetVolSpriteTopEdge(Vol *vol)
{
	return(vol->sprite_top_edge);
}

Int
GetVolSpriteInitPieceWidth(Vol *vol)
{
	return(vol->init_piece_width);
}

Int
GetVolSpriteInitPieceHeight(Vol *vol)
{
	return(vol->init_piece_height);
}

Int
GetVolSpriteInitPieceHorRef(Vol *vol)
{
	return(vol->init_piece_hor_ref);
}

Int
GetVolSpriteInitPieceVerRef(Vol *vol)
{
	return(vol->init_piece_ver_ref);
}

Int 
GetVolBlendFact(Vol *vol)
{
	return(vol->blend_fact);
}

Int 
GetVolSpriteUsage(Vol *vol)
{
	return(vol->sprite_usage);
}

Int 
GetVolWarpingAccuracy(Vol *vol)
{
	return(vol->warping_accuracy);
}

Int 
GetVolBrightnessChangeInSprite(Vol *vol)
{
	return(vol->brightness_change_in_sprite);
}

Int 
GetVolLowLatencySpriteEnable(Vol *vol)
{
	return(vol->low_latency_sprite_enable);
}

Int 
GetVolNoOfSpritePoints(Vol *vol)
{
	return(vol->no_of_sprite_points );
}

TrajPoint *
GetVolRefPointCoord(Vol *vol)
{
	return(vol->ref_point_coord );
}

TrajPoint *
GetVolTrajPointCoord(Vol *vol)
{
	return(vol->traj_point_coord );
}

Sprite_motion *
GetVolPrevWarpParam(Vol *vol)
{
	return(vol->prev_warp_param);
}

Vop *
GetVolSprite(Vol *vol)
{
	return(vol->psprite);
}

Int
GetVolSpriteTransmitMode(Vol *vol)
{
	return(vol->sprite_transmit_mode);
}

Int *
GetVolSpriteTabTransmit(Vol *vol)
{
	return(vol->tab_transmit);
}

Int *
GetVolSpriteTabAmbType(Vol *vol)
{
	return(vol->tab_amb_type);
}

Int *
GetVolSpriteTabMvda(Vol *vol)
{
	return(vol->tab_mvda);
}

SInt *
GetVolSpriteTabQPStore(Vol *vol)
{
	return(vol->tab_QP_store);
}

Int *
GetVolSpriteTabDQUANTStore(Vol *vol)
{
	return(vol->tab_DQUANT_store);
}

Int ***
GetVolSpriteTabDCStore(Vol *vol)
{
	return(vol->tab_DC_store);
}

Vop *
GetVolVop(Vol *vol)
{
	return(vol->pvop);
}

Vol *
GetVolNext(Vol *vol)
{
	return(vol->pnext);
}


/***********************************************************CommentBegin******
 *
 * -- PutVol{xxx} -- Functions to write to components of the Vol structure
 *	
 *	Void PutVolId(Int ident, Vol *vol)
 *	Void PutVolVOId(Int vo_id, Vol *vol)
 *	Void PutVolShape(Int shape, Vol *vol)
 * 	Void PutVolShapeEffects(Int shape_effects,Vol *vol)
 *      Void PutVolWidth(Int width, Vol *vol)
 *      Void PutVolHeight(Int height, Vol *vol)
 *      Void PutVolQuantType(Int quant_type, Vol *vol)
 *      Void PutVolLoadIntraQuantMat(Int load_intra_quant_mat, Vol *vol)
 *      Void PutVolIntraQuantMat(Int *intra_quant_mat, Vol *vol)
 *      Void PutVolLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vol *vol)
 *      Void PutVolNonintraQuantMat(Int *nonintra_quant_mat, Vol *vol)
 *      Void PutVolLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vol *vol)
 *      Void PutVolGrayIntraQuantMat(Int *gray_intra_quant_mat, Vol *vol)
 *      Void PutVolLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vol *vol)
 *      Void PutVolGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vol *vol)
 *	Void PutVolErrorResDisable(Int disable,Vol *vol)
 *      Void PutVolDataPartEnable(Int data_partitioning, Vol *vol)
 * 	Void PutVolReverseVLC(Int reverse_vlc,Vol *vol)
 *	Void PutVolBlockFilterDisable(Int disable,Vol *vol)
 *      Void PutVolNonintraQmatEl(Int nonintra_qmat_el, Int num, Vol *vol)
 *	Void PutVolACDCPredDisable(Int intra_dcpred_disable, Vol *vol)
 *      Void PutVolSepMotShapeText(Int sep_mot_shape_text, Vol *vol)
 *	Void PutVolScalability(Int scalability, Vol *vol)
 *	Void PutVolScal(Int scal_type, Vol *vol)
 *	Void PutVolRefId(Int ref_ident, Vol *vol)
 *	Void PutVolRefSampDir(Int ref_samp_dir, Vol *vol)
 *	Void PutVolHorSampN(Int hor_samp_n, Vol *vol)
 *	Void PutVolHorSampM(Int hor_samp_m, Vol *vol)
 *	Void PutVolVerSampN(Int ver_samp_n, Vol *vol)
 *	Void PutVolVerSampM(Int ver_samp_m, Vol *vol)
 *	Void PutVolEnhanceType(Int enhancement_type, Vol *vol)
 *	Void PutVolSpriteHdim(Int sprite_hdim,Vol *vol)
 *	Void PutVolSpriteVdim(Int sprite_vdim,Vol *vol)
 *      Void PutVolSpriteLeftEdge(Int sprite_left_edge,Vol *vol)
 *	Void PutVolSpriteTopEdge(Int sprite_top_edge,Vol *vol)
 *	Void PutVolSpriteInitPieceWidth(Int init_piece_width, Vol *vol)
 *	Void PutVolSpriteInitPieceHeight(Int init_piece_height, Vol *vol)
 *	Void PutVolSpriteInitPieceHorRef(Int init_piece_ver_ref, Vol *vol)
 *	Void PutVolSpriteInitPieceVerRef(Int init_piece_ver_ref, Vol *vol)
 *	Void PutVolBlendFact(Int blend_fact,Vol *vol)
 *	Void PutVolSpriteUsage(Int sprite_usage, Vol *vol )
 *	Void PutVolWarpingAccuracy(Int warping_accuracy, Vol *vol )
 *	Void PutVolNoOfSpritePoints(Int no_of_sprite_points, Vol *vol )
 *	Void PutVolRefPointCoord(TrajPoint *ref_point_coord, Vol *vol )
 *	Void PutVolTrajPointCoord(TrajPoint *traj_point_coord, Vol *vol )
 *	Void PutVolPrevWarpParam(Sprite_motion *prev_warp_param, Vol *vol)
 *	Void PutVolBrightnessChangeInSprite( Int brightness_change_in_sprite, Vol *vol )
 *	Void PutVolLowLatencySpriteEnable( Int low_latency_sprite_enable, Vol *vol )
 *	Void PutVolSprite(Vop *sprite,Vol *vol)
 *	Void PutVolSpriteTransmitMode(Int sprite_transmit_mode, Vol *vol)
 *	Void PutVolSpriteTabTransmit(Int *tab_transmit, Vol *vol)
 *	Void PutVolSpriteTabAmbType(Int *tab_amb_type, Vol *vol)
 *	Void PutVolSpriteTabMvda(Int *tab_mvda, Vol *vol)
 *	Void PutVolSpriteTabQPStore(SInt *tab_QP_store, Vol *vol)
 *	Void PutVolSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vol *vol)
 *	Void PutVolSpriteTabDCStore(Int ***tab_DC_store, Vol *vol)
 *      Void PutVolVop(Vop *vop, Vol *vol)
 *      Void PutVolNext(Vol *pnext, Vol *vol)
 *
 * Author :		
 *	Noel O'Connor
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vol structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vol" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor : added PutVolSADCTDisable()
 *	22.04.97 Michael Wollborn: Added new access functions for 
 *					   MPEG quantizer matrices
 *      26.04.97 Luis Ducla-Soares: added PutVolDataPartEnable()
 *      09.07.97 Aasmund Sandvand: added PutVolVOId()
 *      04.08.97 Minhua Zhou: added  PutVolOBMCDisable()
 *
 ***********************************************************CommentEnd********/

Void PutVolIsObjectLayerIdentifier(Int is_object_layer_identifier,Vol *vol) {
   vol->is_object_layer_identifier = is_object_layer_identifier;
} 

Void PutVolVisualObjectLayerVerid(Int visual_object_layer_verid,Vol *vol) {
   vol->visual_object_layer_verid = visual_object_layer_verid;
} 

Void PutVolVisualObjectLayerPriority(Int visual_object_layer_priority,Vol *vol) {
   vol->visual_object_layer_priority = visual_object_layer_priority;
} 


Void PutVolVolControlParameters(Int vol_control_parameters,Vol *vol) {
   vol->vol_control_parameters = vol_control_parameters;
} 

Void PutVolFixedVopRate(Int fixed_vop_rate,Vol *vol) {
   vol->fixed_vop_rate = fixed_vop_rate;
} 

Void PutVolQuantPrecision(Int quant_precision,Vol *vol) {
   vol->quant_precision = quant_precision;
} 

Void PutVolBitsPerPixel(Int bits_per_pixel,Vol *vol) {
   vol->bits_per_pixel = bits_per_pixel;
}

Void PutVolComplexityEstimationDisable(Int complexity_estimation_disable,Vol *vol) {
   vol->complexity_estimation_disable = complexity_estimation_disable;
} 

Void PutVolRandomAccessibleVol(Int random_accessible_vol,Vol *vol) {
   vol->random_accessible_vol = random_accessible_vol;
}


Void PutVolTimeIncrementResolution(Int time_incre_res, Vol *vol) {
  vol->time_increment_resolution=time_incre_res;
 }

Void
PutVolId(Int id,Vol *vol)
{
	vol->ident = id;
}

Void
PutVolVOId(Int vo_id,Vol *vol)
{
	vol->vo_id = vo_id;
}

Void
PutVolShape(Int shape,Vol *vol)
{
	vol->shape = shape;
}

Void
PutVolShapeEffects(Int shape_effects,Vol *vol)
{
	vol->shape_effects = shape_effects;
}

Void
PutVolOBMCDisable(Int OBMCDisable,Vol *vol)
{
	vol->obmc_disable = OBMCDisable;
}


Void
PutVolWidth(Int width,Vol *vol)
{
	vol->width = width;
}

Void
PutVolHeight(Int height, Vol *vol)
{
	vol->height = height;
}

Void
PutVolQuantType(Int quant_type, Vol *vol)
{
  vol->quant_type = quant_type;
}

Void
PutVolLoadIntraQuantMat(Int load_intra_quant_mat, Vol *vol)
{
  vol->load_intra_quant_mat = load_intra_quant_mat;
}

#if 0
Void
PutVolIntraQuantMat(Int *intra_quant_mat, Vol *vol)
{
  vol->intra_quant_mat = intra_quant_mat;
}
#endif

Void
PutVolLoadNonintraQuantMat(Int load_nonintra_quant_mat, Vol *vol)
{
  vol->load_nonintra_quant_mat = load_nonintra_quant_mat;
}

#if 0
Void
PutVolNonintraQuantMat(Int *nonintra_quant_mat, Vol *vol)
{
  vol->nonintra_quant_mat = nonintra_quant_mat;
}
#endif

Void
PutVolDisableGrayQuantUpdate(Int disable_gray_quant_update, Vol *vol)
{
  vol->disable_gray_quant_update = disable_gray_quant_update;
}

Void
PutVolLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, Vol *vol)
{
  vol->load_gray_intra_quant_mat = load_gray_intra_quant_mat;
}

#if 0
Void
PutVolGrayIntraQuantMat(Int *gray_intra_quant_mat, Vol *vol)
{
  vol->gray_intra_quant_mat = gray_intra_quant_mat;
}
#endif

Void
PutVolLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, Vol *vol)
{
  vol->load_gray_nonintra_quant_mat = load_gray_nonintra_quant_mat;
}

#if 0
Void
PutVolGrayNonintraQuantMat(Int *gray_nonintra_quant_mat, Vol *vol)
{
  vol->gray_nonintra_quant_mat = gray_nonintra_quant_mat;
}
#endif

Void
PutVolErrorResDisable(Int flag,Vol *vol)
{
	vol->error_res_disable = flag;
}

Void
PutVolDataPartEnable(Int flag,Vol *vol)
{
        vol->data_partitioning = flag;
}

Void
PutVolReverseVlc(Int reverse_vlc,Vol *vol)
{
	vol->reverse_vlc = reverse_vlc;
}

Void
PutVolACDCPredDisable(Int flag,Vol *vol)
{
	vol->intra_acdc_pred_disable = flag;
}

Void
PutVolSADCTDisable(Int flag,Vol *vol)
{
	vol->sadct_disable = flag;
}


Void
PutVolScalability(Int scale,Vol *vol)
{
	vol->scalability = scale;
}
Void
PutVolScalType(Int scale,Vol *vol)
{
	vol->scal_type = scale;
}

Void
PutVolRefId(Int id,Vol *vol)
{
	vol->ref_ident = id;
}

Void
PutVolRefSampDir(Int dir,Vol *vol)
{
	vol->ref_samp_dir = dir;
}

Void
PutVolHorSampN(Int n,Vol *vol)
{
	vol->hor_samp_n = n;
}

Void
PutVolHorSampM(Int m,Vol *vol)
{
	vol->hor_samp_m = m;
}

Void
PutVolVerSampN(Int n,Vol *vol)
{
	vol->ver_samp_n = n;
}

Void
PutVolVerSampM(Int m,Vol *vol)
{
	vol->ver_samp_m = m;
}

Void
PutVolEnhanceType(Int type,Vol *vol)
{
	vol->enhancement_type = type;
}

Void
PutVolSpriteHdim(Int sprite_hdim,Vol *vol)
{
	vol->sprite_hdim = sprite_hdim;
}

Void
PutVolSpriteVdim(Int sprite_vdim,Vol *vol)
{
	vol->sprite_vdim = sprite_vdim;
}

Void
PutVolSpriteLeftEdge(Int sprite_left_edge, Vol *vol)
{
	vol->sprite_left_edge = sprite_left_edge;
}

Void
PutVolSpriteTopEdge(Int sprite_top_edge, Vol *vol)
{
	vol->sprite_top_edge = sprite_top_edge;
}

Void
PutVolSpriteInitPieceWidth( Int init_piece_width, Vol *vol)
{
	vol->init_piece_width = init_piece_width;
}

Void
PutVolSpriteInitPieceHeight( Int init_piece_height, Vol *vol)
{
	vol->init_piece_height = init_piece_height;
}

Void
PutVolSpriteInitPieceHorRef( Int init_piece_hor_ref, Vol *vol)
{
	vol->init_piece_hor_ref = init_piece_hor_ref;
}

Void
PutVolSpriteInitPieceVerRef( Int init_piece_ver_ref, Vol *vol)
{
	vol->init_piece_ver_ref = init_piece_ver_ref;
}

Void
PutVolBlendFact(Int blend_fact,Vol *vol)
{
	vol->blend_fact = blend_fact;
}

Void
PutVolSpriteUsage(Int sprite_usage, Vol *vol )
{
	vol->sprite_usage = sprite_usage;
}

Void
PutVolWarpingAccuracy(Int warping_accuracy, Vol *vol )
{
	vol->warping_accuracy = warping_accuracy;
}

Void
PutVolNoOfSpritePoints(Int no_of_sprite_points, Vol *vol )
{
	vol->no_of_sprite_points = no_of_sprite_points ;
}

Void
PutVolRefPointCoord(TrajPoint *ref_point_coord, Vol *vol )
{
	vol->ref_point_coord = ref_point_coord ;
}

Void
PutVolTrajPointCoord(TrajPoint *traj_point_coord, Vol *vol )
{
	vol->traj_point_coord = traj_point_coord ;
}

Void
PutVolPrevWarpParam(Sprite_motion *prev_warp_param, Vol *vol)
{
	vol->prev_warp_param = prev_warp_param;
}

Void
PutVolBrightnessChangeInSprite( Int brightness_change_in_sprite, Vol *vol )
{
	vol->brightness_change_in_sprite = brightness_change_in_sprite;
}

Void
PutVolLowLatencySpriteEnable( Int low_latency_sprite_enable, Vol *vol )
{
	vol->low_latency_sprite_enable = low_latency_sprite_enable;
}

Void
PutVolSprite(Vop *sprite,Vol *vol)
{
	vol->psprite = sprite;
}

Void
PutVolSpriteTransmitMode(Int sprite_transmit_mode, Vol *vol)
{
	vol->sprite_transmit_mode = sprite_transmit_mode;
}

Void
PutVolSpriteTabTransmit(Int *tab_transmit, Vol *vol)
{
	vol->tab_transmit = tab_transmit;
}

Void
PutVolSpriteTabAmbType(Int *tab_amb_type, Vol *vol)
{
	vol->tab_amb_type = tab_amb_type;
}

Void
PutVolSpriteTabMvda(Int *tab_mvda, Vol *vol)
{
	vol->tab_mvda = tab_mvda;
}

Void
PutVolSpriteTabQPStore(SInt *tab_QP_store, Vol *vol)
{
	vol->tab_QP_store = tab_QP_store;
}

Void
PutVolSpriteTabDQUANTStore(Int *tab_DQUANT_store, Vol *vol)
{
	vol->tab_DQUANT_store = tab_DQUANT_store;
}

Void
PutVolSpriteTabDCStore(Int ***tab_DC_store, Vol *vol)
{
	vol->tab_DC_store = tab_DC_store;
}

Void
PutVolVop(Vop *vop,Vol *vol)
{
	vol->pvop = vop;
}

Void
PutVolNext(Vol *next,Vol *vol)
{
	vol->pnext = next;
}


/***********************************************************CommentBegin******
 *
 * -- PutVO{xxx} -- Functions to write to components of the VO structure
 *	
 *	Void PutVOId(Int id,VO *vo)
 *	Void PutVOLayers(Vol *layers,VO *vo)
 *	Void PutVONext(VO *next,VO *vo)
 *
 * Author :		
 *	Noel O'Connor
 *
 * Created :		
 *	23-Sep-96
 *
 * Purpose :		
 *	These are common functions to write to specific components
 *      of the Vol structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Write access to the components of a "Vol" 
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/
Void
PutVOId(Int id,VO *vo)
{
	vo->id = id;
}

Void
PutVOLayers(Vol *layers,VO *vo)
{
	vo->layers = layers;
}

Void
PutVONext(VO *next,VO *vo)
{
	vo->pnext = next;
}

/***********************************************************CommentBegin******
 *
 * -- GetVO{xxx} -- Functions to access components of the VO structure
 *
 *	Int GetVOId(VO *vo)
 *	Vol *GetVOLayers(VO *vo)
 *	VO *GetVONext(VO *vo)
 *
 * Author :		
 *	Noel O'Connor 
 *
 * Created :		
 *	31-Aug-96
 *
 * Purpose :		
 *	These are common functions to access specific components
 *      of the VO data structure.
 * 
 * Arguments in : 	
 *	xxx
 *
 * Arguments in/out :	
 *	xxx
 *
 * Arguments out :	
 *	xxx
 *
 * Return values :	
 *	xxx
 *
 * Side effects :	
 *	xxx
 *
 * Description :	
 *	Access components of a "Vol"
 *
 * See also :
 *	
 *
 * Modified :		
 *	
 *
 ***********************************************************CommentEnd********/

Int
GetVOId(VO *vo)
{
	return(vo->id);
}

Vol *
GetVOLayers(VO *vo)
{
	return(vo->layers);
}

VO *
GetVONext(VO *vo)
{
	return(vo->pnext);
}

