/*****************************************************************************
 *
 * This software module was originally developed by
 *
 *   Michael Wollborn (TUH / ACTS-MoMuSyS)
 *
 * and edited by
 * 
 *   Paulo Nunes (IST / ACTS-MoMuSyS)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC
 * 14496-2) standard.
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original
 * developer of this software module and his/her company, the subsequent
 * editors and their companies, and ISO/IEC have no liability for use of this
 * software module or modifications thereof in an implementation. Copyright is
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) Standard conforming
 * products.
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own
 * purpose, assign or donate the code to a third party and to inhibit third
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) Standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works.
 *
 * Copyright (c) 1996
 *
 *****************************************************************************/

/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_dec_defs.h
 *
 * Author:	Michael Wollborn
 * Created:	27-Feb-96
 *                                                                         
 * Description: Common MoMuSys WP2.4 definitions to be used whenever possible.
 *
 * Notes: 	
 *
 * Modified:	9-May-96 Paulo Nunes: Reformatted. New headers.
 *              30.04.97 Luis Ducla-Soares: added definition of HeaderInfo.
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#ifndef _VM_DEC_DEFS_H_
#define _VM_DEC_DEFS_H_

   #   ifdef __cplusplus
       extern "C" {
   #   endif /* __cplusplus */

#define VERSION		1		/* image structure version */


   #   ifdef __cplusplus
       }
   #   endif /* __cplusplus  */ 


#include "vm_common_defs.h"

#define INTRA_VOP  0			/* Syntax fields  of vops */
#define P_VOP      1                    
#define SPRITE_VOP 3                   

typedef struct {

  Int NO_DCT_flag;
  Int coded;
  Int skipped_flag;
  Int mode;
  Int  DQUANT;
  Int CBP;
  Int ACpred_flag;
  Int IntraDC[6];
	Int MB_transp_pattern[4];	
} HeaderInfo;


#endif /* _VM_DEC_DEFS_H_ */
