/* header file for TM-5 rate control */

struct tm5rc {
    int     Xi;         /* I-picture complexity */
    int     Xp;         /* P-picture complexity */
    int     Xb;         /* B-picture complexity */
    int     r_tm5;      /* Reaction parameter */
    int     d0i;        /* I-pic virtual buffer occupancy */
    int     d0p;        /* P-pic virtual buffer occupancy */
    int     d0b;        /* B-pic virtual buffer occupancy */
    double  avg_act;    /* Ave activity (of last picture) */
    double  *mbact;     /* Activity of each macroblock */
    int     R_tm5;      
    int     T_tm5;
    int     d_tm5;      /* buffer occupancy accumulator */
    double  actsum;     /* Cumulative sum of activities */
    int     Ni;         /* Nbr I-pics reamining in GOP */
    int     Np;         /* Nbr P-pics remaining in GOP */
    int     Nb;         /* Nbr B-pics remaining in GOP */
    int     S_tm5;
    int     Q_tm5;      /* Sum of quantizer value (for activity calc) */
    int     prev_mquant;/* Previous quantizer */
    int     mb_width;   /* Nbr MBs in horiz direction */
    int     mb_height;  /* Nbr MBs in vert direction */
    int     mquant;     /* running quantizer value */
    int     bitrate;    /* Bit rate (bits/second) */
    double  pic_rate;   /* Pictures per second */

    int     rc_type;    /* Rate control type code */
    FILE    *Qfile;     /* Quantizer file */
    int     linectr;    /* numbers on current Qfile line */
};

typedef struct tm5rc    Tm5Rc;

#include "tm5rc.p"