/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Noel O'Connor (TELTEC IRELAND / ACTS-MoMuSys).                   	
 *
 * and edited by 
 *
 * Cecile Dufour (LEP / ACTS-MoMuSys).     		              	
 * Minhua Zhou (HHI / ACTS-MoMuSys).   	  	 	              	
 * Luis Ducla-Soares (IST / ACTS-MoMuSys).     	           	   	
 * Ulrike Pestel (TUH / ACTS-MoMuSys).  
 * Bob Eifrig (NextLevel Systems)
 * Michael Frater (UNSW)
 * Martina Eckert (UPM)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/


/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_config.h
 *
 * Author:	Noel O'Connor 08/05/96
 * Created:	
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	04.06.96 - Noel O'Connor : Extra parameters in config
 *	structure.
 *						23.07.96 - Noel O'Connor : complete change of data structures
 *	needed for VM 3.0
 *						20.09.96 - Noel O'Connor : change of data structures to
 *	allow for coding of multiple VOs.
 *	29.11.96 - Noel O'Connor : new "next_coding_time" field in the VolConfig
 *	structure. Also the FINISHED value is defined here (used in main coding
 * loop).
 *	    20.02.97 Cecile Dufour : added sprite accesses
 *      26.02.97 Noel O'Connor : added shape_effects, reverse_vlc fields, gl_quant, gl_quant_update
 *      10.03.97 Minhua Zhou: added M in VolConfig for B-VOPs
 *      26.04.97 Luis Ducla-Soares: added the data_partitioning field to VolConfig.
 *	    09.05.97 Minhua Zhou      : changed the single  modulo_time_base
 *				    to double  modulo_time_base[2]
 *      13.05.97 Minhua zhou      : added advanced_prediction_disable 
 * 				    and GOV_period
 *      18.07.97 Ulrike Pestel-Schiller: Added scal_type 
 *      04.08.97 Minhua Zhou      : renamed advanced_prediction_disable
 *      04.08.97 Minhua Zhou      : renamed fcode_for,fcode_back in 
 *                                  object_layer_cfg as sr_for,sr_back
 *      29.08.97 Osamu Sunohara(Sony): added ss_enh_pred_type.
 *      04.01.98 Michael Frater: support for non-8-bit video
 *      14.10.97 Hung-Ju Lee (Sarnoff) & Jie Liang (TI)   : 
 *             added "SOLconfig" type for the wavelet texture coding mode
 *             added field "SOLlayers" in the definition of VOConfig
 *              added field "num_SOLlayers" in the definiton of VOConfig
 ***********************************************************HeaderEnd*********/

#ifndef _VM_CONFIG_H_
#define _VM_CONFIG_H_

#include "momusys.h"
#include "vm_enc_defs.h"

#include "dataStruct.h"   /* VTC */

#define BASE_LAYER 0

/* Background comp. flag NOT USED in non-scalable coding */
#define DEFAULT_BCKGND_COMP 0

#define FINISHED -1

/* Definitions for rate control options */
#define NO_RATE_CONTROL 0
#define VM4_RATE_CONTROL 1
#define VM5_RATE_CONTROL 2
#define TM5_RATE_CONTROL 3      /* codes 4 & 5 used to read & write quantizer file */


struct object_layer_cfg
{
	/* IO and control fields */
	Int	    ident;				/* VOL Id */
	Char 	bitstream[100];	    /* Name of bitstream file on disk */
	Float	frame_rate;			/* VOL frame rate */
    Int 	M;				    /* M-1 number of B-VOPs between consecutive P-VOPs*/
	Int	    disk_seq_x;			/* X size of source seq on disk */
	Int	    disk_seq_y;			/* Y size of source seq on disk */
	Float	disk_seq_frame_rate;		/* Frame rate of source seq on disk */
	Int	    shape;				/* Type of alpha map */
	Char 	disk_y_file[100];	/* Name of Y comp of source seq on disk */
	Char 	disk_u_file[100];	/* Name of U comp of source seq on disk */
	Char 	disk_v_file[100];	/* Name of V comp of source seq on disk */
	Char 	disk_a_file[100];	/* Name of A comp of source seq on disk */
	Int	    write_coded;		/* Flag: 1-Write coded seq to disk, 0-No write */
	Char 	coded_y_file[100];	/* Name of Y comp of coded seq on disk */
	Char 	coded_u_file[100];	/* Name of U comp of coded seq on disk */
	Char 	coded_v_file[100];	/* Name of V comp of coded seq on disk */
	Char 	coded_a_file[100];	/* Name of A comp of coded seq on disk */
	Int	start_frame;			/* Frame at which to start coding */
	Int	end_frame;			    /* Frame at which to end coding */
	/* for TPS */
	Float 	start_time;
	/**/
	Int	bit_rate;			    /* Target bitrate */

       /* UPM - New values for Multi Vop Rate Control: */
        Char    rc_parameter_string[50];  /* RC parameter string */
	Int	shape_effects;		    /* type of shape effects to be used */

/* Automatically calculated control fields */
	Int	frame;				    /* "Next" frame to be coded. */
	Int 	frame_skip;			/* Number of frames to skip between codings */
	Float 	end_time;			/* End time for this VOL */
	Float 	time_inc;			/* Time increment for this VOL */
	Float 	next_coding_time;

/* User defined coding fields */
	Int	quant_type;			    /* Type of quantization: H.263/MPEG-2 */

  /* Added stuff for complete MPEG quantization, 23-APR-1997 MW */
  Int load_intra_quant_mat;	         /* load special quant.mat flag */
  Int intra_quant_mat[64];	         /* special quant.mat */
  Char intra_quant_mat_file[100];        /* filename for user defined matrix */
  Int load_nonintra_quant_mat;	         /* load special quant.mat flag */
  Int nonintra_quant_mat[64];	         /* special quant.mat */
  Char nonintra_quant_mat_file[100];     /* filename for user defined matrix */
  Int load_gray_intra_quant_mat;	 /* load special quant.mat flag */
  Int gray_intra_quant_mat[64];	         /* special quant.mat */
  Char gray_intra_quant_mat_file[100];   /* filename for user defined matrix */
  Int load_gray_nonintra_quant_mat;	 /* load special quant.mat flag */
  Int gray_nonintra_quant_mat[64];	 /* special quant.mat */
  Char gray_nonintra_quant_mat_file[100];/* filename for user defined matrix */

	Int	quantizer;			/* Initial value for H.263 INTRA quantizer */
	Int	B_quantizer;			/* Initial value for H.263 B_VOP quantizer */
	Int	intra_quantizer;		/* Initial value for H.263 INTER quantizer */
	Int 	error_res_disable;		/* Flag to disable error resilence mode */
	Int     data_partitioning;              /* Flag to enable the data partitioning mode */
        Int	reverse_vlc;				/* Flag to indicate reversible VLCs */
    Int packet_size;
	Int	intra_acdc_pred_disable;	/* Flag to disable intra AC/DC prediction */
	Int	sr_for;							
	Int	sr_back;
	Int 	alpha_th;			/* Alpha coding threshold */
	Int 	change_CR_disable; /* exactly as it says */
	Int 	sadct_disable;			/* Flag to disable SADCT 0-ENABLED, 1-DISABLED */

	Int 	scalability;			/* Flag: 0 - BASE layer, 1 - ENHANCEMENT layer */
	Int 	scal_type;			/* Flag: 0 - temporal, 1 - spatial */

        Int     ss_enh_pred_type;               /* Enhancement Layer Prediction Type of Spatial Scalable:
                                                   0 - PBBB.., 1 - PPPP.. */
                                                /* this flag is added by Sony 290897 */
	
	Int	ref_ident;			/* 	Reference 	*/
	Int	ref_samp_dir;			/* 	layer data 	*/
	Int 	hor_samp_n;			/* 	needed for 	*/
	Int	hor_samp_m;			/* 	scalable 	*/
	Int 	ver_samp_n;			/* 	coding. 	*/
	Int	ver_samp_m;
        Int     quant_precision;   /* number of bits used to transmit QP */
        Int     bits_per_pixel;    /* pixel depth */
	Int 	enhancement_type;
        Int     obmc_disable;
	Int	intra_period;	/* Regular rate of INTRA VOP */
        Int     GOV_period;     /* Regular rate of GOV */
	Int	gl_quant;			/* Quantizer for GL alpha maps */
	Int	disable_gray_quant_update;	/* Flag to update GL quantizer */

    Int     interlaced;         /* Non-zero for interlace */
    Int     top_field_first;    /* Non-zero if the top field is first */
    Int     alternate_scan;     /* Use the alternate scan for interlaced blocks */
    Int     sr_direct;          /* Search radius for direct mode (half-pels) */
    Int     mvfileusage;        /* MV file usage: 0=notused, 1=read, 2=write */
    Char    mvfilename[100];    /* Motion vector file name */
    FILE    *mvfile;            /* Open stdio MV file */
    Int     mvlineno;           /* Line number in motion vector file */
    void    *rcdata;            /* Place for rate control to attach state */

  /* Included user_data() due to N2171, Clause 2.1.9 MW 23-MAR-1998 */
  Int is_user_data_in_vol;
  Char user_data_in_vol_file[100];
  Int is_user_data_in_gov;
  Char user_data_in_gov_file[100];

/* Fields for sprite */
	Int     sprite_hdim;	
	Int     sprite_vdim;
	Int	sprite_left_edge;
	Int	sprite_top_edge;
	Int     blend_fact;			/* blending factor for updating the sprite (ON-LINE MODE */
	Int	write_sprite;			/* Flag: 1-Write mosaic to disk, 0-No write */
	Char 	sprite_y_file[100];		/* Name of Y comp of mosaic on disk */
	Char 	sprite_u_file[100];		/* Name of U comp of mosaic on disk */
	Char 	sprite_v_file[100];		/* Name of V comp of mosaic on disk */
	Char 	sprite_a_file[100];		/* Name of A comp of mosaic on disk */
	Char    warp_param_file[100];		/* Filename containing the warping parameters (OFF-LINE MODE) */
	Int 	sprite_usage;
	Int	no_of_sprite_points;
  TrajPoint	*ref_point_coord; 	/* Position of the reference points in the sprite */
	Int 	brightness_change_in_sprite;
	Vop 	*psprite, *p_orisprite;
	Int	sprite_transmit_mode;
	Int	warp_param_counter;		/* counter to read in the warping param file */
	Sprite_motion *prev_warp_param;
	Int	sprite_shape;
	Int	warping_accuracy;
	Int	check_staticsprite_prediction;
	Int	*tab_transmit;
	SInt	*tab_QP_store;
	Int	*tab_DQUANT_store;
	Float	SNR_threshold;
	Int	init_piece_width;
	Int	init_piece_height;
	Int	init_piece_hor_ref;
	Int	init_piece_ver_ref;
	Int	low_latency_sprite_enable;
/* End of fields for sprite */

	Int 		intra_shape_period;
	Int     time_increment_resolution;

/* Automatically calculated coding fields */
	Int	modulo_time_base[2];				/* Modulo time base must be maintained for VOL */

	/* Linked list pointer */
	struct object_layer_cfg *pnext;

};
typedef struct object_layer_cfg VolConfig;


/* Structure for storing configuration information for each VO */
struct vo_cfg
{
	Int						id;						/* Id of this VO */
	Int						num_layers;		/* number of VOLs for this VO */
	VolConfig 		*layers;				/* pointer to VOL config. info */
	struct vo_cfg	*pnext;				/* pointer to next VO in list */
};
typedef struct vo_cfg VOConfig;



/* Structure for storing configuration information for each VTC */
/* VTC Begin ------------------------------------------ */
struct vtc_cfg
{
        Int            id;     /* Id of this VO */
        Char           bitstream[100];
        Int            width;
        Int            height;
        Char           image_file[100];
        Char           shape_file[100];
        Char           rec_file[100];
        Int            bit_depth;
        Int            colors;
        Int            alphaTH;
        Int            change_CR_disable;
        Int            sa_dwt;
        Int            wvtType;
        Int            wvtDecompLev;
        Int            QdcY;
        Int            QdcUV;
        Int            spatial_scalability_levels;
        Int            quantization_type;
        Int            SNR_start_code_enable;
        SNR_PARAM     *SPlayer[3];
        Int            target_bitrate;
        Int            target_spatial_levels;
        Int            target_snr_levels;
        Int            deringWindowSize;
        Int            deringThreshold;
        struct vtc_cfg  *pnext; /* pointer to next VO in list */
};
typedef struct vtc_cfg VTCConfig;
/* VTC End   ------------------------------------------ */


/* Structure for storing i/p user data for controling the encoder */
struct encoder_ctl
{
	/* user defined fields */
	Int		num_vos;										/* Number of VOs */
	Char	*vo_cfg_files[MAX_NUM_VOS];	/* Config. file names */

/* VTC Begin ------------------------------------------ */
        Int             num_vtcs;                                      
        Char    *vtc_cfg_files[MAX_NUM_VOS];
/* VTC End   ------------------------------------------ */



	Char	display_y_file[100];		/* Y comp. od composited o/p image */
	Char	display_u_file[100];		/* U comp. od composited o/p image */
	Char	display_v_file[100];		/* V comp. od composited o/p image */
	Int		dim_x;		/* X dimension of display */
	Int		dim_y;		/* Y dimension of display */
        Int     post_filter_type;      /* type of post filter */
	Int     bits_per_pixel;         /* pixel depth of display */

        /* UPM Global RC */
	Int	rc_type;		  /* Type of Rate Control */
        Char    rc_parameter_string[50];  /* RC parameter string */

	/* Automatically calculated fields */
	Float		start_time;				/* session start time */
	Float		end_time;					/* session end time */
	Float		time_inc;					/* session time incrment */
};
typedef struct encoder_ctl EncodeControl;







#include "vm_config.p"

#endif /* _VM_CONFIG_H_ */

