/******************************************************************************
 *                                                                          
 * This software module was originally developed by 
 *
 * Noel O'Connor (TELTEC IRELAND / ACTS-MoMuSys).                   	
 *
 * and edited by 
 *
 * Aasmund Sandvand (Telenor / ACTS-MoMuSys). 	    	              	
 * J. Ignacio Ronda (UPM / ACTS-MoMuSys).   	  	              	
 * Cecile Dufour (LEP / ACTS-MoMuSys).     		              	
 * Minhua Zhou (HHI / ACTS-MoMuSys).   	  	 	              	
 * Fernando Jaureguizar (UPM / ACTS-MoMuSys).   	              	
 * Luis Ducla-Soares (IST / ACTS-MoMuSys).     	           	   	
 * Martina Eckert (UPM / ACTS-MoMuSys).   	  	              	
 * Noel Brady (TELTEC IRELAND / ACTS-MoMuSys).                   	
 * Michael Wollborn (TUH / ACTS-MoMuSys).   
 * Bob Eifrig (NextLevel Systems)
 * Michael Frater (UNSW)
 *
 * in the course of development of the MPEG-4 Video (ISO/IEC 14496-2) standard.
 * This software module is an implementation of a part of one or more MPEG-4 
 * Video (ISO/IEC 14496-2) tools as specified by the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * ISO/IEC gives users of the MPEG-4 Video (ISO/IEC 14496-2) standard free 
 * license to this software module or modifications thereof for use in hardware
 * or software products claiming conformance to the MPEG-4 Video (ISO/IEC 
 * 14496-2) standard. 
 *
 * Those intending to use this software module in hardware or software products
 * are advised that its use may infringe existing patents. The original 
 * developer of this software module and his/her company, the subsequent 
 * editors and their companies, and ISO/IEC have no liability for use of this 
 * software module or modifications thereof in an implementation. Copyright is 
 * not released for non MPEG-4 Video (ISO/IEC 14496-2) standard conforming 
 * products. 
 *
 * ACTS-MoMuSys partners retain full right to use the code for his/her own 
 * purpose, assign or donate the code to a third party and to inhibit third 
 * parties from using the code for non MPEG-4 Video (ISO/IEC 14496-2) standard
 * conforming products. This copyright notice must be included in all copies or
 * derivative works. 
 *
 * Copyright (c) 1997
 *
 *****************************************************************************/



/***********************************************************HeaderBegin*******
 *                                                                         
 * File:	vm_config.c
 *
 * Author:	Noel O'Connor Teltec Irl.
 * Created:	08-05-96
 *                                                                         
 * Description: 
 *
 * Notes: 	
 *
 * Modified:	04.06.96 - Noel O'Connor : Extra parameters in config file
 *	and associated access functions.
 *						30.06.96 - Noel O'Connor : New structures for reading in
 *	control and configuration information (VOControl & VOLConfig).
 *						20.09.96 - Noel O'Connor : New structures to facilitate
 *	the coding of multiple VOs. New functions are supplied for reading 
 *	control and configuration information.
 *	29.11.96 - Noel O'Connor : New access function (and related software) for
 *	the new "next_coding_time" field of the VolConfig structure. Also new
 *	function for rounding time values.
 * 31.1.97 - Aasmund Sandvand : Moved control of deblock filter to encoder 
 *          control file
 * 04.02.97 Noel O'Connor : New functions for new .cfg file fields
 * 11.02.97 J. Ignacio Ronda: modified UpdateVolConfigNextCodingTime() to
 *          skip frames due to buffer fullness in the VM5 rate control
 * 20.02.97 Cecile Dufour : added accesses to sprite parameters (from F. Dufaux & R. Crinon)
 * 11.03.97 Minhua Zhou : added M to  UpdateVolConfigNextCodingTime() due to B-VOPs
 * 20.03.97 Fernando Jaureguizar: UpdateVolConfigNextCodingTime() modified
 *          to solve some problems with last skipped frames of the sequence.
 * 23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 * 26.04.97 Luis Ducla-Soares: Enabled the use of reversible VLCs and added 
 *                             data partitioning stuff
 * 07.05.97 Noel Brady: Enabled use of change_CR_disable.
 * 13.05.97 Minhua Zhou: added obmc_disable and GOV_period
 * 07.07.97 Martina Eckert: 
 *          Introduction of new Get and Put functions for Control File:
 *          - Int GetEncodeControlRCType(EncodeControl *enc_ctl)
 *          - Void PutEncodeControlRCType(Int rc_type, EncodeControl *enc_ctl)
 *          - GetEncodeControlRCAlgorithm(Int rc_algorithm, EncodeControl *enc_ctl)
 *          - Void PutEncodeControlRCAlgorithm(Int rc_algorithm, EncodeControl *enc_ctl)
 *          - Int GetEncodeControlRCRateModel(Int rc_rate_model, EncodeControl *enc_ctl)
 *          - Void PutEncodeControlRCRateModel(Int rc_rate_model, EncodeControl *enc_ctl)
 *          - Int GetEncodeControlRCDistModel(Int rc_dist_model, EncodeControl *enc_ctl)
 *          - Void PutEncodeControlRCDistModel(Int rc_dist_model, EncodeControl *enc_ctl)
 *          - Int GetEncodeControlGlobalBitrate(EncodeControl *enc_ctl)
 *          - Void PutEncodeControlGlobalBitrate(Int R_target, EncodeControl *enc_ctl)
 *          - Int GetEncodeControlGlobalBufferSize(EncodeControl *enc_ctl)
 *          - Void PutEncodeControlGlobalBufferSize(Int glob_buffer_size, EncodeControl *enc_ctl)
 *          > Read new parameters for Global RC in ReadEncoderControlFile:
 *            rc_type, rc_algorithm, rc_rate_model, rc_dist_model, R_target,
 *            glob_buffer_size
 *          Introduction of new Get and Put functions for Config File:
 *          - Void PutVolConfigRCParam1(Float rc_param_1, VolConfig *cfg)
 *          - Void PutVolConfigRCParam2(Float rc_param_2, VolConfig *cfg)
 *          - Float GetVolConfigRCParam1(VolConfig *cfg)
 *          - Float GetVolConfigRCParam2(VolConfig *cfg)
 *          > Read new parameters for Global RC in ReadEncoderControlFile:
 *            rc_param_1, rc_param_2
 * 15.07.97 UPS:added scalability_type
 * 30.07.97 Fernando Jaureguizar: fixing in UpdateVolConfigNextCodingTime()
 * 04.08.97 Minhua Zhou: rename advanced_prediction_disable
 * 04.08.97 Minhua Zhou: modifications for f_codes
 * 29.08.97 Osamu Sunohara(Sony): added functions to select spatial scalable
 *                                enhancement type.
 * 08.09.97 Cecile Dufour(Philips LEP): added functions for static sprites 
*  23.10.97 Minhua Zhou  : changed deblock_filter_disable to post_filter
 *                             _type
 * 04.01.98 Michael Frater: support for non-8-bit video
 * 08.01.98 Martina Eckert: Change of method to read RC parameters from .ctl 
 *          and .cfg files. Now only one parameter string is read from each 
 *          file.
 *          (Change of functions ReadEncoderControlFile and ReadVOLConfigData, 
 *           remove functions Getxxx and Putxxx, introduce functions Get- and 
 *           Put..RCParam)
 *
 * 01210.98 Hung-Ju Lee (Sarnoff) & Jie Liang (TI): 
 *        added the following functions for wavelet texture coding
 *                             PutSOLconfigLayers ();
 *                             ReadSOLConfigData();
 *                             PutSOLconfigNumVOLs();
 *                             AllocSOLconfig();
 *                             FreeSOLconfig();
 *                             GetSOLconfigNext();
 *                             and modified the following functions:
 *                             SallocVOConfig ();
 *
 ***********************************************************HeaderEnd*********/

/************************    INCLUDE FILES    ********************************/

#include <stdio.h>
#include <limits.h>
#include <string.h>
#include "vm_config.h"
#include "mom_vol.h"
#include "mom_vo.h"
#include "rc.h"
#include "text_quant_mat_def.h"
#include "text_quant_mat_spec.h"
#include "io_generic.h"
#include "vm_vop_bound.h"
#include "sprite_enc_piece.h"



/***********************************************************CommentBegin******
 *
 * -- SallocEncodeControl -- allocates memory for an EncodeControl structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Allocates memory for an EncodeControl structure (but not the file
 *	name fields).
 *
 * Arguments in : 	
 *	none
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	EncodeControl *enc_ctl - pointer to allocated structure
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

EncodeControl *SallocEncodeControl()
{
	EncodeControl *enc_ctl;

	enc_ctl = (EncodeControl *)malloc(sizeof(EncodeControl));

	return(enc_ctl);
}

/***********************************************************CommentBegin******
 *
 * -- AllocEncodeControl -- Allocates memory for an EncodeControl structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Allocates memory for an EncodeControl structure (incl. the file name
 *	fields).
 *
 * Arguments in : 	
 *	Int num_vos - number of VOs
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	EncodeControl *enc_ctl - pointer to allocated structure
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	15.01.97 Robert Danielsen: Corrected exit(0) to exit(1) in one case.
 *			Solution from Paulo Nunes.
 *
 ***********************************************************CommentEnd********/
/* VTC Begin ------------------------------------------ */
EncodeControl *AllocEncodeControl(Int num_vos, Int num_vtcs /* VTC */)
/* VTC End   ------------------------------------------ */

{
	EncodeControl *enc_ctl;

	Int	vo;

/* 	Char	*string; */

	if(num_vos > MAX_NUM_VOS)
	{
		fprintf(stderr,"ERROR(AllocEncodeControl): Maximum number of VOs exceeded. See vm_config.h\n");
		exit(1);
	}

	enc_ctl = SallocEncodeControl();

	PutEncodeControlNumVOs(num_vos,enc_ctl);
/* VTC Begin ------------------------------------------ */
        PutEncodeControlNumVTCs(num_vtcs, enc_ctl);   /* VTC */
/* VTC End ------------------------------------------ */

	
	for(vo = 0; vo < num_vos; vo++)
		enc_ctl->vo_cfg_files[vo] = (Char*)malloc(sizeof(Char) * 100);
		
/* VTC Begin ------------------------------------------ */
        for(vo = 0; vo < num_vtcs; vo++)
                enc_ctl->vtc_cfg_files[vo] = (Char*)malloc(sizeof(Char) * 100);
/* VTC End ------------------------------------------ */

	return(enc_ctl);
}

/***********************************************************CommentBegin******
 *
 * -- FreeEncodeControl -- Deallocates all memory associated with a 
 *	EncodeControl structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Deallocates all memory associated with a EncodeControl structure
 *
 * Arguments in : 	
 *	EncodeControl *enc_ctl - pointer to EncodeControl structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	-
 *	
 *
 ***********************************************************CommentEnd********/

Void
FreeEncodeControl(EncodeControl *enc_ctl)
{
	Int	num_vos,
			vo;

/* VTC Begin ------------------------------------------ */
        Int     num_vtcs;
/* VTC End  ------------------------------------------ */

	Char *string;

	num_vos = GetEncodeControlNumVOs(enc_ctl);
	
	for(vo = 0; vo < num_vos; vo++)
	{
		string = GetEncodeControlCfgFile(vo,enc_ctl);
		free((Char*)string);
	}

/* VTC Begin ------------------------------------------ */
	num_vtcs = GetEncodeControlNumVTCs(enc_ctl);
        for(vo = 0; vo < num_vtcs; vo++)
        {
                string = GetEncodeControlVTCCfgFile(vo,enc_ctl);
                free((Char*)string);
        }
/* VTC End  ------------------------------------------ */

	free((Char*)enc_ctl);

	return;
}

/***********************************************************CommentBegin******
 *
 * -- GetEncodeControlXXXX -- Access functions for an EncodeControl structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Access functions for an EncodeControl structure. These functions retrieve
 *	the value of specific fields of the EncodeControl structure.
 *
 * Arguments in : 	
 *	EncodeControl *enc_ctl - pointer to structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	Value of specified field in structure.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	mom_access.c
 *
 * Modified :		
 *      16.01.98 Martina Eckert: Replace functions Getxxx for RC by one 
 *                               function GetEncodeControlRCParam.
 *
 *	
 *
 ***********************************************************CommentEnd********/
Int
GetEncodeControlNumVOs(EncodeControl *enc_ctl)
{
	return(enc_ctl->num_vos);
}

Char *
GetEncodeControlCfgFile(Int id, EncodeControl *enc_ctl)
{
	return(enc_ctl->vo_cfg_files[id]);
}

Float
GetEncodeControlStartTime(EncodeControl *enc_ctl)
{
	return(enc_ctl->start_time);
}

Float
GetEncodeControlEndTime(EncodeControl *enc_ctl)
{
	return(enc_ctl->end_time);
}

Float
GetEncodeControlTimeInc(EncodeControl *enc_ctl)
{
	return(enc_ctl->time_inc);
}

Char *
GetEncodeControlDispYFile(EncodeControl *enc_ctl)
{
	return(enc_ctl->display_y_file);
}

Char *
GetEncodeControlDispUFile(EncodeControl *enc_ctl)
{
	return(enc_ctl->display_u_file);
}

Char *
GetEncodeControlDispVFile(EncodeControl *enc_ctl)
{
	return(enc_ctl->display_v_file);
}

Int
GetEncodeControlDispSizeX(EncodeControl *enc_ctl)
{
	return(enc_ctl->dim_x);
}

Int
GetEncodeControlDispSizeY(EncodeControl *enc_ctl)
{
	return(enc_ctl->dim_y);
}
Int
GetEncodeControlPostFilterType(EncodeControl *enc_ctl)
{
	return(enc_ctl->post_filter_type);
}

/* UPM Global RC: */


Int
GetEncodeControlRCType(EncodeControl *enc_ctl)
{
        return(enc_ctl->rc_type);
}

Char *
GetEncodeControlRCParam(EncodeControl *enc_ctl)
{
        return(enc_ctl->rc_parameter_string);
}

Int
GetEncodeControlDispBitsPerPixel(EncodeControl *enc_ctl)
{
	return(enc_ctl->bits_per_pixel);
}

/***********************************************************CommentBegin******
 *
 * -- PutEncodeControlXXXX  -- Access functions for an EncodeControl structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Access functions for an EncodeControl structure. These functions set a 
 *	specific field in the structure to a specified value.
 *
 * Arguments in : 	
 *	EncodeControl *enc_ctl - pointer to structure
 *	Value fo field to be filled.
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	mom_access.c
 *
 * Modified :		
 *      16.01.98 Martina Eckert: Replace functions Putxxx for RC by one 
 *                               function PutEncodeControlRCParam.
 *
 *	
 *
 ***********************************************************CommentEnd********/

Void
PutEncodeControlNumVOs(Int num_vos,EncodeControl *enc_ctl)
{
	enc_ctl->num_vos = num_vos;
}

Void
PutEncodeControlCfgFile(Char *string,Int id,EncodeControl *enc_ctl)
{
	strcpy(enc_ctl->vo_cfg_files[id],string);
}

Void
PutEncodeControlStartTime(Int time,EncodeControl *enc_ctl)
{
	enc_ctl->start_time = time;
}

Void
PutEncodeControlEndTime(Float time,EncodeControl *enc_ctl)
{
	enc_ctl->end_time = time;
}

Void
PutEncodeControlTimeInc(Float time,EncodeControl *enc_ctl)
{
	enc_ctl->time_inc = time;
}

Void
PutEncodeControlDispYFile(Char *string,EncodeControl *enc_ctl)
{
	strcpy(enc_ctl->display_y_file,string);
}

Void
PutEncodeControlDispUFile(Char *string,EncodeControl *enc_ctl)
{
	strcpy(enc_ctl->display_u_file,string);
}

Void
PutEncodeControlDispVFile(Char *string,EncodeControl *enc_ctl)
{
	strcpy(enc_ctl->display_v_file,string);
}

Void
PutEncodeControlDispSizeX(Int dim,EncodeControl *enc_ctl)
{
	enc_ctl->dim_x = dim;
}

Void
PutEncodeControlDispSizeY(Int dim,EncodeControl *enc_ctl)
{
	enc_ctl->dim_y = dim;
}

Void
PutEncodeControlPostFilterType(Int value,EncodeControl *enc_ctl)
{
	enc_ctl->post_filter_type = value;
}

/* UPM Global RC */

Void
PutEncodeControlRCType(Int rc_type, EncodeControl *enc_ctl)
{
  enc_ctl->rc_type = rc_type;
}

Void
PutEncodeControlRCParam(Char *rc_parameter_string, EncodeControl *enc_ctl)
{
	strcpy(enc_ctl->rc_parameter_string, rc_parameter_string);
}

Void
PutEncodeControlDispBitsPerPixel(Int value,EncodeControl *enc_ctl)
{
	enc_ctl->bits_per_pixel = value;
}

/***********************************************************CommentBegin******
 *
 * -- ReadEncoderControlFile -- Reads the data in the encoder control file
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Reads the data in the encoder control file and it in an allocated
 *	EncodeControl structure.
 *
 * Arguments in : 	
 *	Char *control_file - Name of control file
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	EncodeControl *enc_ctl - pointer to allocated, filled EncodeControl
 *	structure.
 *
 * Side effects :	
 *	Memory is allocated in this function for an EncodeControl structure.
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	15.01.97 Robert Danielsen: Corrected exit(0) to exit(1) in one case.
 *			Solution from Paulo Nunes.
 *      16.01.98 Martina Eckert: Read one parameter string instead of six 
 *                      different parameters for rate control
 *
 ***********************************************************CommentEnd********/
EncodeControl *
ReadEncoderControlFile(Char *control_file)
{
	File	*fpcontrol_file;

	EncodeControl *enc_ctl;

	Int		num_vos,
				dim_x,
				dim_y,
                                post_filter_type,
	                        bits_per_pixel,
    /* UPM Global RC */         rc_type,
				vo;

	Char	garbage[201],
                                rc_parameter_string[50],
				vo_cfg_file[100],
				display_comp_file[100];

 /* VTC Begin ------------------------------------------ */
        Char    vtc_cfg_file[100];  /* VTC */
        Int     num_vtcs;  /* VTC */
 /* VTC End   ------------------------------------------ */

	if((fpcontrol_file = fopen(control_file,"r")) == NULL)
	{
		fprintf(stderr,"ERROR(ReadEncodeControl): unable to open %s\n",control_file);
		exit(1);
	}

	/* Read from file */

	/* Number of VOs first */
	fscanf(fpcontrol_file,"%d",&num_vos);
	fgets(garbage,201,fpcontrol_file);

 /* VTC Begin ------------------------------------------ */
        /* Number of VTCs first */
        fscanf(fpcontrol_file,"%d",&num_vtcs);
        fgets(garbage,201,fpcontrol_file);

        enc_ctl = AllocEncodeControl(num_vos, num_vtcs);  /* VTC */
 /* VTC End   ------------------------------------------ */

	/* enc_ctl = AllocEncodeControl(num_vos); */

	/* display YUV component file names */
	fscanf(fpcontrol_file,"%s",display_comp_file);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlDispYFile(display_comp_file,enc_ctl);

	fscanf(fpcontrol_file,"%s",display_comp_file);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlDispUFile(display_comp_file,enc_ctl);

	fscanf(fpcontrol_file,"%s",display_comp_file);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlDispVFile(display_comp_file,enc_ctl);

	/* Display size X */
	fscanf(fpcontrol_file,"%d",&dim_x);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlDispSizeX(dim_x,enc_ctl);

	/* Display size Y */
	fscanf(fpcontrol_file,"%d",&dim_y);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlDispSizeY(dim_y,enc_ctl);

	/* flag to disable deblock filter */
	fscanf(fpcontrol_file,"%d",&post_filter_type);
	fgets(garbage,201,fpcontrol_file);
	PutEncodeControlPostFilterType(post_filter_type,enc_ctl);

	/* pixel depth of display */
	fscanf(fpcontrol_file,"%d",&bits_per_pixel);
	fgets(garbage,80,fpcontrol_file);
	PutEncodeControlDispBitsPerPixel(bits_per_pixel,enc_ctl);

	for(vo = 0; vo < num_vos; vo++)
	{
		/* Config. file names */
		fscanf(fpcontrol_file,"%s",vo_cfg_file);
		fgets(garbage,201,fpcontrol_file);
	
		PutEncodeControlCfgFile(vo_cfg_file,vo,enc_ctl);
	}

 /* VTC Begin   ------------------------------------------ */
        for(vo = 0; vo < num_vtcs; vo++)  /* VTC */
        {
                /* Config. file names */
                fscanf(fpcontrol_file,"%s",vtc_cfg_file);
                fgets(garbage,201,fpcontrol_file);
                fprintf(stderr,"hjlee: vtc_cfg_file: %s\n",vtc_cfg_file);
                PutEncodeControlVTCCfgFile(vtc_cfg_file,vo,enc_ctl);
        }
 /* VTC End   ------------------------------------------ */

	/* UPM Global RC */

        /* Rate Control Type */
        fscanf(fpcontrol_file,"%d",&rc_type);
        fgets(garbage,201,fpcontrol_file);
        PutEncodeControlRCType(rc_type, enc_ctl);
        
        /* Rate Control Parameter String */
	fscanf(fpcontrol_file,"%s",rc_parameter_string);
        fgets(garbage,201,fpcontrol_file);
        PutEncodeControlRCParam(rc_parameter_string, enc_ctl);


       

	return(enc_ctl);
}

/***********************************************************CommentBegin******
 *
 * -- PrintEncodeControl -- Prints the contents of an EncodeControl structure
 *		to a file
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Prints the contents of an EncodeControl structure to a file. This data
 *	can also be printed to the screen if one of the input arguments is
 *	stdout.
 *
 * Arguments in : 	
 *	EncodeControl *enc_ctl - pointer to EncodeControl structure
 *	File *file - file pointer to where to print data
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Void
PrintEncodeControl(EncodeControl *enc_ctl, File *file)
{
	Int		vo;

	fprintf(file,"\n\n\n");
	fprintf(file,"***************************************************\n");
	fprintf(file,"*         MPEG4 Video Verification Model          *\n");
	fprintf(file,"*                                                 *\n");
	fprintf(file,"*             MoMuSys Implementation              *\n");
	fprintf(file,"*                                                 *\n");
	fprintf(file,"***************************************************\n\n\n");

	fprintf(file,"# VOs : %d\n", (Int)GetEncodeControlNumVOs(enc_ctl));
	fprintf(file,"Configuration files :\n");
	for(vo = 0; vo < GetEncodeControlNumVOs(enc_ctl); vo++)
		fprintf(file,"%s\n",GetEncodeControlCfgFile(vo,enc_ctl));
	fprintf(file,"\nSession start time : %f\n",
		(Float)GetEncodeControlStartTime(enc_ctl));
	fprintf(file,"Session end time : %f\n",
		(Float)GetEncodeControlEndTime(enc_ctl));

	fprintf(file,"\nDisplay files : \n");
	fprintf(file,"%s\n",GetEncodeControlDispYFile(enc_ctl));
	fprintf(file,"%s\n",GetEncodeControlDispUFile(enc_ctl));
	fprintf(file,"%s\n",GetEncodeControlDispVFile(enc_ctl));
	fprintf(file,"Display size : %d x %d\n\n",
		(Int)GetEncodeControlDispSizeX(enc_ctl),
		(Int)GetEncodeControlDispSizeY(enc_ctl));
	if(!GetEncodeControlPostFilterType(enc_ctl))
		fprintf(file,"Deblocking Filter is DISABLED\n");
	else
		fprintf(file,"Deblocking Filter for composited image is ENABLED\n");

        /* UPM Global RC */
        if(GetEncodeControlRCType(enc_ctl) == NO_RATE_CONTROL)
          fprintf(file,"No rate control\n");
        else if(GetEncodeControlRCType(enc_ctl) == VM4_RATE_CONTROL)
          fprintf(file,"VM 4 rate control will be used\n");
        else if(GetEncodeControlRCType(enc_ctl) == VM5_RATE_CONTROL)
          fprintf(file,"VM 5 rate control will be used\n");

#if 0
	/* This has to be resolved otherwise... MEB */
          if(GetEncodeControlRCAlgorithm(enc_ctl) == RC_ALGORITHM_Q2)
            fprintf(file,"with Q2 Control, ");
          else if(GetEncodeControlRCAlgorithm(enc_ctl) == RC_ALGORITHM_UPM1)
            fprintf(file,"with UPM 1 Control, ");
          else if(GetEncodeControlRCAlgorithm(enc_ctl) == RC_ALGORITHM_UPM2)
            fprintf(file,"with UPM 2 Control, ");

          if(GetEncodeControlRCRateModel(enc_ctl) == RC_MODEL_Q2)
            fprintf(file,"Q2 rate model and \n ");
          else if(GetEncodeControlRCRateModel(enc_ctl) == RC_MODEL_UPM1)
          {
	     fprintf(file,"UPM1 rate model and \n ");
	  }
          else if(GetEncodeControlRCRateModel(enc_ctl) == RC_MODEL_UPM2)
          {
	     fprintf(file,"UPM2 rate model and \n ");
	  }

          if(GetEncodeControlRCDistModel(enc_ctl) == RC_MODEL_Q2)
            fprintf(file,"Q2 distortion model \n ");
          else if(GetEncodeControlRCDistModel(enc_ctl) == RC_MODEL_UPM1)
          {
	     fprintf(file,"UPM1 distortion model \n ");
	  }
          else if(GetEncodeControlRCDistModel(enc_ctl) == RC_MODEL_UPM2)
          {
	     fprintf(file,"UPM2 distortion model \n ");
	  }


	  fprintf(file,"Global target bit rate: %d \n ",
		  GetEncodeControlGlobalBitrate(enc_ctl));
	  fprintf(file,"Global buffer size: %d \n ",
		  GetEncodeControlGlobalBufferSize(enc_ctl));
#endif

	fprintf(file,"\n\n");

	return;
}


/***********************************************************CommentBegin******
 *
 * -- SallocVOConfig -- Allocate memory for a VOConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Allocates memory for a VOConfig structure (but not for associated
 *	linked list of VolConfig structures).
 *
 * Arguments in : 	
 *	none
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VOConfig *vo_cfg - pointer to allocated structure.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *     Hung-Ju Lee & Jie Liang 20.01.98: added PutSOLconfigLayers (NULL, vo_cfg)
 *	
 *
 ***********************************************************CommentEnd********/

VOConfig *
SallocVOConfig()
{
	VOConfig *vo_cfg;

	vo_cfg = (VOConfig *)malloc(sizeof(VOConfig));
	
	PutVOConfigLayers(NULL,vo_cfg);
	PutVOConfigNext(NULL,vo_cfg);

	return(vo_cfg);
}

/***********************************************************CommentBegin******
 *
 * -- FreeVOConfigList -- Deallocate all memory associated with a linked
 *	list of VOConfig structures
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Deallocate all memory associated with a linked list of VOConfig structures.
 *
 * Arguments in : 	
 *	VOConfig *vo_cfg_list - pointer to linked list
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Void
FreeVOConfigList(VOConfig *vo_cfg_list)
{
	VOConfig	*curr,
						*next;

	curr = vo_cfg_list;
	
	while(curr != NULL)
	{
		next = GetVOConfigNext(curr);

		FreeVolConfigList(GetVOConfigLayers(curr));

		free((Char*)curr);

		curr = next;
	}

	return;
}

/***********************************************************CommentBegin******
 *
 * -- PutVOConfigXXX -- Access functions for VOConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Sets a particular field of a VOConfig structure to a specified value.
 *
 * Arguments in : 	
 *	value field is to be set to
 *	VOConfig *vo_cfg - pointer to VOConfig structure.
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Void
PutVOConfigId(Int id,VOConfig *vo_cfg)
{
	vo_cfg->id = id;
}

Void
PutVOConfigNumVOLs(Int num,VOConfig *vo_cfg)
{
	vo_cfg->num_layers = num;
}

Void
PutVOConfigLayers(VolConfig *layers,VOConfig *vo_cfg)
{
	vo_cfg->layers = layers;
}

Void
PutVOConfigNext(VOConfig *next,VOConfig *vo_cfg)
{
	vo_cfg->pnext = next;
}

/***********************************************************CommentBegin******
 *
 * -- GetVOConfigXXX -- access functions for a VOConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Returns the value of a particular field in a VOConfig structure.
 *
 * Arguments in : 	
 *	VOConfig *vo_cfg - pointer to VOConfig structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	Value of specified field.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Int
GetVOConfigId(VOConfig *vo_cfg)
{
	return(vo_cfg->id);
}

Int
GetVOConfigNumVOLs(VOConfig *vo_cfg)
{
	return(vo_cfg->num_layers);
}

VolConfig *
GetVOConfigLayers(VOConfig *vo_cfg)
{
	return(vo_cfg->layers);
}

VOConfig *
GetVOConfigNext(VOConfig *vo_cfg)
{
	return(vo_cfg->pnext);
}

/***********************************************************CommentBegin******
 *
 * -- AddVOConfigToList -- Adds a VOConfig structure to the end of a linked
 *	list of VOConfigs.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Adds a VOConfig structure to the end of a linked list of VOConfigs. This
 *	function assumes that the list is not empty to begin with.
 *
 * Arguments in : 	
 *	VOConfig *vo_cfg - pointer to VOConfig to be added
 *
 * Arguments in/out :	
 *	VOConfig *list - pointer to linked list of VOConfigs.
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Void
AddVOConfigToList(VOConfig *vo_cfg,VOConfig *list)
{
	VOConfig 	*curr,
						*prev;

	prev = list;

	curr = GetVOConfigNext(prev);

	while(curr != NULL)
	{
		prev = curr;

		curr = GetVOConfigNext(prev);
	}

	PutVOConfigNext(vo_cfg,prev);
}

/***********************************************************CommentBegin******
 *
 * -- GetVOConfigId -- Returns a pointer to a VOConfig in a linked list of VOs,
 *						identified by it's Id.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-11-96
 *
 * Purpose :		
 * 	Returns a pointer to a VOConfig in a linked list of VOConfig,
 *		identified by it's Id.
 *
 * Arguments in : 	
 *	VOConfig  *list - linked list of VOConfigs
 * Int vo_cfg_id - VOConfig Id
 *
 * Arguments in/out :	
 *	-
 *
 * Arguments out :	
 *	-
 *
 * Return values :	
 *	-
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
VOConfig *
GetVOConfigById(VOConfig *list,Int vo_cfg_id)
{
	VOConfig *curr;

	Int	id;

	curr = list;

	while(curr != NULL)
	{
		id = GetVOConfigId(curr);
		if(id != vo_cfg_id)
			curr = GetVOConfigNext(curr);
		else
			break;
	}

	return(curr);
}



/***********************************************************CommentBegin******
 *
 * -- ReadConfigFiles -- Read the data contained in the various configuration
 *	files on disk.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Read the data contained in the various configuration
 *	files on disk. This data is placed in a linked list of VOConfig
 *	structures.
 *
 * Arguments in : 	
 *	EncodeControl *enc_ctl - pointer to an EncodeControl structure (holds
 *	the name of the configuration files).
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VOConfig *list - pointer to linked list of VOConfigs
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
VOConfig *
ReadConfigFiles(EncodeControl *enc_ctl)
{
	Int				num_vos,
						vo;

	VOConfig 	*list = NULL,
						*curr;

	Char			*string;

	num_vos = GetEncodeControlNumVOs(enc_ctl);

	for(vo = 0; vo < num_vos; vo++)
	{
		string = GetEncodeControlCfgFile(vo,enc_ctl);

		curr = ReadVOConfigFile(string);

		if(vo == 0)
			list = curr;
		else
			AddVOConfigToList(curr,list);
	}

	return(list);
}


/***********************************************************CommentBegin******
 *
 * -- ReadVOLConfigData -- Reads the VOL config information from the VO config
 *	file
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Reads the VOL config information from the VO config
 *	file and places this in a linked list of VolConfig structures
 *	(one node for each layer, with BASE layer as first node).
 *
 * Arguments in : 	
 *	Int num_layer - number of coding layers
 *	File *fpfile - pointer to file to read from
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VolConfig *vol_config_list - pointer to linked list of VolConfig
 *	structures
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	28.01.97 Robert Danielsen: Added fix from Noel O'Connor: added
 *			PutVolConfigEnhanceType().
 * 04.02.97 Noel O'Connor: Enabled error res. mode (based on changes sent by
 *			Luis Ducla-Soares)
 * 26.02.97 Noel O'Connor: Added reverse_vlc and shape_effects fields
 * 10.03.97 Minhua Zhou  : Added M for B-VOPs 
 * 23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 * 26.04.97 Luis Ducla-Soares: Enabled the use of reversible VLCs and added
 *                             data_partitioning field.
 * 12.08.97 Minhua Zhou : added the calculation of vop_time_increment_resolution 
 * 29.08.97 Osamu Sunohara: added PutVolConfigEnhPredType(). 
 * 08.09.97 Cecile Dufour: added reading parameters for Static Sprites   
 * 19.11.97 Noel Brady: added packet size  
 * 11,12.97 Bob Eifrig: added interlaced, top field first, alternate
 *                      scan, MV file, direct search radius
 * 16.01.98 Martina Eckert: Read one parameter string instead of two
 *                      different parameters for rate control
 * 23.03.98 Michael Wollborn: included user_data() due to N2171, Clause 2.1.9
 *
 ***********************************************************CommentEnd********/ 
VolConfig *
ReadVOLConfigData(Int num_layers,File *fpfile)
{
  Int				layer;
  
  Char
    /*	  *cfg_file, */
    garbage[201];
  
  VolConfig	*vol_config_list = NULL,
                *curr;

  /* Data to be read from config files */
  
  Int id,M,time_incre_res,
    disk_seq_x,
    disk_seq_y,
    shape,
    write_coded,
    start_frame,
    end_frame,
    bit_rate,
    alpha_th,
    change_CR_disable,
    obmc_disable,
    quant_precision,
    bits_per_pixel,
    quant_type,
    load_intra_quant_mat, load_nonintra_quant_mat,
    load_gray_intra_quant_mat, load_gray_nonintra_quant_mat,
    intra_quantizer,
    quantizer,
    error_res_disable,
    intra_acdc_pred_disable,
    sadct_disable,
    sr_for,
    scalability,
    scalability_type,
    enh_pred_type,    /* <-added by Sony 290897 */
    ref_ident,
    ref_samp_dir,
    hor_samp_n,
    hor_samp_m,
    ver_samp_n,
    ver_samp_m,
    enhancement_type,
    intra_period,
    GOV_period,
    sprite_hdim,
    sprite_vdim,
    sprite_left_edge,
    sprite_top_edge,
    write_sprite,
    sprite_usage,
    sprite_shape,
    brightness_change_in_sprite,
    low_latency_sprite_enable,
    no_of_sprite_points,
    warping_accuracy,
    reverse_vlc,
    shape_effects,
    gl_quant,
    disable_gray_quant_update,
    data_partitioning,
		packet_size;
  
  Float				tmp_blend_fact;
  Int				blend_fact;
  Int				intra_shape_period;
  Float				SNR_threshold;
  
  Char coded_y_file[100],
    coded_u_file[100],
    coded_v_file[100],
    coded_a_file[100],
    bitstream[100],
    disk_y_file[100],
    disk_u_file[100],
    disk_v_file[100],
    disk_a_file[100],
    sprite_y_file[100], 
    sprite_u_file[100],
    sprite_v_file[100],
    sprite_a_file[100],
    warp_param_file[100],
    intra_quant_mat_file[100], 
    nonintra_quant_mat_file[100],
    gray_intra_quant_mat_file[100], 
    gray_nonintra_quant_mat_file[100],
    user_data_in_vol_file[100], /* Included due to N2171, Clause 2.1.9 MW 23-MAR-1998 */
    user_data_in_gov_file[100]; /* Included due to N2171, Clause 2.1.9 MW 23-MAR-1998 */

  /* Included due to N2171, Clause 2.1.9 MW 23-MAR-1998 */
  Int is_user_data_in_vol=0, is_user_data_in_gov=0;

  Float frame_rate,
    disk_seq_frame_rate,
    start_time;
   Char
    rc_parameter_string[50];   /* UPM Global RC */
  
  for(layer = 0; layer < num_layers; layer++)
    {
      curr = AllocVolConfig();
      
      /* ReadFromFile */
      
      /* VOL Id */
      fscanf(fpfile,"%d",&id);
      fgets(garbage,201,fpfile);
      PutVolConfigId(id,curr);
      
      /* VOL Frame Rate */
      fscanf(fpfile,"%f",&frame_rate);
      fgets(garbage,201,fpfile);
      PutVolConfigFrameRate(frame_rate,curr);

      /* VOL Time Increment Resolution */
      for (time_incre_res=1;time_incre_res<32768;time_incre_res++) {
        Double unit;
        unit = (Double)time_incre_res/frame_rate;
        if (fabs(unit-(Double)((Int)(unit+0.0001)))<0.0001)
          break;
         
      }  
      if (time_incre_res==32768) time_incre_res=37267;
      PutVolConfigTimeIncrementResolution(time_incre_res,curr);
      
      /* VOL value of M (>=1)  */
      fscanf(fpfile,"%d",&M);
      fgets(garbage,201,fpfile);
      PutVolConfigM(M,curr);
      
      /* X dim of source sequence */
      fscanf(fpfile,"%d",&disk_seq_x);
      fgets(garbage,201,fpfile);
      PutVolConfigDiskSeqX(disk_seq_x,curr);
      
      /* Y dim of source sequence */
      fscanf(fpfile,"%d",&disk_seq_y);
      fgets(garbage,201,fpfile);
      PutVolConfigDiskSeqY(disk_seq_y,curr);
      
      /* Disk seq. frame rate */
      fscanf(fpfile,"%f",&disk_seq_frame_rate);
      fgets(garbage,201,fpfile);
      PutVolConfigDiskSeqFrameRate(disk_seq_frame_rate,curr);
      
      /* Type of alpha channel */
      fscanf(fpfile,"%d",&shape);
      fgets(garbage,201,fpfile);
      PutVolConfigShape(shape,curr);
    
      /* obmc_disable */
       fscanf(fpfile,"%d",&obmc_disable);
       fgets(garbage,201,fpfile);
       PutVolConfigOBMCDisable(obmc_disable,curr);
     
      /* quant_precision */
       fscanf(fpfile,"%d",&quant_precision);
       fgets(garbage,80,fpfile);
       PutVolConfigQuantPrecision(quant_precision,curr);
     
      /* bits_per_pixel */
       fscanf(fpfile,"%d",&bits_per_pixel);
       fgets(garbage,80,fpfile);
       PutVolConfigBitsPerPixel(bits_per_pixel,curr);
      
      /* Type of shape effects to be used */
      fscanf(fpfile,"%d",&shape_effects);
      fgets(garbage,201,fpfile);
      PutVolConfigShapeEffects(shape_effects,curr);
      /* Ensure correct default  value for the time being - NOC */
      if(shape_effects != NO_SHAPE_EFFECTS)
	{
	  fprintf(stderr,"Shape effects flag in .cfg file must be set to 0\n");
	  fprintf(stderr,"Shape effects are not currently supported.\n");
	  exit(1);
	}

      /* Source seq file names */
      fscanf(fpfile,"%s",disk_y_file);
      fgets(garbage,201,fpfile);
      PutVolConfigY(disk_y_file,curr);
      
      fscanf(fpfile,"%s",disk_u_file);
      fgets(garbage,201,fpfile);
      PutVolConfigU(disk_u_file,curr);
      
      fscanf(fpfile,"%s",disk_v_file);
      fgets(garbage,201,fpfile);
      PutVolConfigV(disk_v_file,curr);
      
      fscanf(fpfile,"%s",disk_a_file);
      fgets(garbage,201,fpfile);
      PutVolConfigA(disk_a_file,curr);
      
      /* Write/No-write coded flag */
      fscanf(fpfile,"%d",&write_coded);
      fgets(garbage,201,fpfile);
      PutVolConfigWriteCoded(write_coded,curr);
      
      /* Coded seq file names */
      fscanf(fpfile,"%s",coded_y_file);
      fgets(garbage,201,fpfile);
      PutVolConfigCodedY(coded_y_file,curr);
      
      fscanf(fpfile,"%s",coded_u_file);
      fgets(garbage,201,fpfile);
      PutVolConfigCodedU(coded_u_file,curr);
		
      fscanf(fpfile,"%s",coded_v_file);
      fgets(garbage,201,fpfile);
      PutVolConfigCodedV(coded_v_file,curr);
      
      fscanf(fpfile,"%s",coded_a_file);
      fgets(garbage,201,fpfile);
      PutVolConfigCodedA(coded_a_file,curr);
      
      /* Bitstream file name */
      fscanf(fpfile,"%s",bitstream);
      fgets(garbage,201,fpfile);
      PutVolConfigBitstream(bitstream,curr);
      
      /* Start frame */
      fscanf(fpfile,"%d",&start_frame);
      fgets(garbage,201,fpfile);
      PutVolConfigStartFrame(start_frame,curr);
      
      /* End frame */
      fscanf(fpfile,"%d",&end_frame);
      fgets(garbage,201,fpfile);
      PutVolConfigEndFrame(end_frame,curr);
      
      /* Start time */
      fscanf(fpfile,"%f",&start_time);
      fgets(garbage,201,fpfile);
      PutVolConfigStartTime(start_time,curr);

      /* Target bitrate */
      fscanf(fpfile,"%d",&bit_rate);
      fgets(garbage,201,fpfile);
      PutVolConfigBitrate(bit_rate,curr);
      
      /* Type of Rate control -> ctl-file! 
      fscanf(fpfile,"%d",&rate_control);
      fgets(garbage,201,fpfile);
      PutVolConfigRateControl(rate_control,curr);
      */

       /* UPM: Global RC parameter string */
      fscanf(fpfile,"%s",rc_parameter_string);
      fgets(garbage,201,fpfile);
      PutVolConfigRCParam(rc_parameter_string, curr);

      
       /* Threshold for shape coding */
      fscanf(fpfile,"%d",&alpha_th);
      fgets(garbage,201,fpfile);
      PutVolConfigAlphaTh(alpha_th,curr);
      
			/* change_CR_disable */
			fscanf(fpfile,"%d",&change_CR_disable);
			fgets(garbage,201,fpfile);
			PutVolConfigChangeCRDisable(change_CR_disable,curr);

      /* Quantizer type */
      fscanf(fpfile,"%d",&quant_type);
      fgets(garbage,201,fpfile);
      PutVolConfigQuantType(quant_type,curr);

      /* Added stuff for MPEG quantization 23-APR-1997 MW */

      /* load_intra_quant_mat flag (0-no, 1-userdef, >1-predef) */
      fscanf(fpfile,"%d",&load_intra_quant_mat);
      fgets(garbage,201,fpfile);
      PutVolConfigLoadIntraQuantMat(load_intra_quant_mat,curr);
      
      /* intra quant. mat. filename (if userdef.) */
      fscanf(fpfile,"%s",intra_quant_mat_file);
      fgets(garbage,201,fpfile);
      PutVolConfigIntraQuantMatFile(intra_quant_mat_file,curr);
      
      /* load_nonintra_quant_mat flag (0-no, 1-userdef, >1-predef) */
      fscanf(fpfile,"%d",&load_nonintra_quant_mat);
      fgets(garbage,201,fpfile);
      PutVolConfigLoadNonintraQuantMat(load_nonintra_quant_mat,curr);
      
      /* nonintra quant. mat. filename (if userdef.) */
      fscanf(fpfile,"%s",nonintra_quant_mat_file);
      fgets(garbage,201,fpfile);
      PutVolConfigNonintraQuantMatFile(nonintra_quant_mat_file,curr);
	  
      /* load_gray_intra_quant_mat flag (0-no, 1-userdef, >1-predef) */
      fscanf(fpfile,"%d",&load_gray_intra_quant_mat);
      fgets(garbage,201,fpfile);
      PutVolConfigLoadGrayIntraQuantMat(load_gray_intra_quant_mat,curr);
	  
      /* gray intra quant. mat. filename (if userdef.) */
      fscanf(fpfile,"%s",gray_intra_quant_mat_file);
      fgets(garbage,201,fpfile);
      PutVolConfigGrayIntraQuantMatFile(gray_intra_quant_mat_file,curr);

      /* load_gray_nonintra_quant_mat flag (0-no, 1-userdef, >1-predef) */
      fscanf(fpfile,"%d",&load_gray_nonintra_quant_mat);
      fgets(garbage,201,fpfile);
      PutVolConfigLoadGrayNonintraQuantMat(load_gray_nonintra_quant_mat,curr);

      /* gray nonintra quant. mat. filename (if userdef.) */
      fscanf(fpfile,"%s",gray_nonintra_quant_mat_file);
      fgets(garbage,201,fpfile);
      PutVolConfigGrayNonintraQuantMatFile(gray_nonintra_quant_mat_file,curr);
      /* End of MPEG-like quantization stuff */
      
      /* INTRA Quantizer */
      fscanf(fpfile,"%d",&intra_quantizer);
      fgets(garbage,201,fpfile);
      PutVolConfigIntraQuantizer(intra_quantizer,curr);
      
      /* Quantizer */
      fscanf(fpfile,"%d",&quantizer);
      fgets(garbage,201,fpfile);
      PutVolConfigQuantizer(quantizer,curr);

      /* B_Quantizer */
      fscanf(fpfile,"%d",&quantizer);
      fgets(garbage,201,fpfile);
      PutVolConfigBQuantizer(quantizer,curr);


      /* quantizer for GL alpha maps */
      fscanf(fpfile,"%d",&gl_quant);
      fgets(garbage,201,fpfile);
      PutVolConfigGLQuant(gl_quant,curr);
      
      /* quantizer update flag for GL quantization of alpha maps */
      fscanf(fpfile,"%d",&disable_gray_quant_update);
      fgets(garbage,201,fpfile);
      PutVolConfigDisableGrayQuantUpdate(disable_gray_quant_update,curr);
      
      /* Error Resilience disable flag */
      fscanf(fpfile,"%d",&error_res_disable);
      fgets(garbage,201,fpfile);
      PutVolConfigErrorResDisable(error_res_disable,curr);
      
      /* Data Partitioning Enable Flag */
      fscanf(fpfile,"%d",&data_partitioning);
      fgets(garbage,201,fpfile);
      if (error_res_disable) data_partitioning=0;
      PutVolConfigDataPartEnable(data_partitioning,curr);


      /* Flag to indicate whether or not to use reversible VLCs */
    
      fscanf(fpfile,"%d",&reverse_vlc);
      fgets(garbage,201,fpfile);
      if (error_res_disable || (data_partitioning==0)) reverse_vlc=0;
      PutVolConfigReverseVlc(reverse_vlc,curr);

			/* size of video packet in bits */
			fscanf(fpfile,"%d",&packet_size);
      fgets(garbage,201,fpfile);
      PutVolConfigPacketSize(packet_size,curr);

      /* for error resil. mode: specifies the period in frame for INTRA shape */
      fscanf(fpfile,"%d",&intra_shape_period);
      fgets(garbage,201,fpfile);
      PutVolConfigIntraShapePeriod(intra_shape_period,curr);
			          
      /* Intra ac/dc pred. disable flag */
      fscanf(fpfile,"%d",&intra_acdc_pred_disable);
      fgets(garbage,201,fpfile);
      PutVolConfigACDCPredDisable(intra_acdc_pred_disable,curr);
#ifdef _WD_MODE_
      PutVolConfigACDCPredDisable(0,curr);
#endif

      
      /* SADCT disable flag */
      fscanf(fpfile,"%d",&sadct_disable);
      fgets(garbage,201,fpfile);
      PutVolConfigSADCTDisable(sadct_disable,curr);
#ifdef _WD_MODE_
      PutVolConfigSADCTDisable(1,curr);
#endif      
      /* sr_per_coded_frame */
      fscanf(fpfile,"%d",&sr_for);
      fgets(garbage,201,fpfile);
      PutVolConfigSearchRange(sr_for,curr);
      
        
     							     
     /*  if ((GetVolConfigM(curr)!=1)&&(GetVolConfigShape(curr)!=0)) {
         fprintf(stdout,"Sorry: B-VOP is not implemented for Binary shape yet!!!\n");
         exit(-1);
      } */
     
        /* Scalability flag */
      fscanf(fpfile,"%d",&scalability);
      fgets(garbage,201,fpfile);
      PutVolConfigScalability(scalability,curr);	

/*** 8/18 TPS */
/********************* comment out 
			if (scalability && shape!=0)
				{
        	fprintf(stdout,"Scalability is not implemented for arbitrary shape yet!!!\n");
        	exit(-1);
      	}
 comment out *********************/
/* 8/18 TPS ***/
     
      /* Scalability type for ssp (UPS)*/
      fscanf(fpfile,"%d",&scalability_type);
      fgets(garbage,201,fpfile);
      PutVolConfigScalType(scalability_type,curr);		
      
      /* added by Sony 290897 */
      /* put spatial scalable enhancement layer prediction type */
      fscanf(fpfile,"%d",&enh_pred_type);
      fgets(garbage,201,fpfile);
      PutVolConfigEnhPredType(enh_pred_type,curr);              
      /* 290897 */

      /* Ref. layer Id */
      fscanf(fpfile,"%d",&ref_ident);
      fgets(garbage,201,fpfile);
      PutVolConfigRefId(ref_ident,curr);
      
      /* Ref. layer sampling direction */
      fscanf(fpfile,"%d",&ref_samp_dir);
      fgets(garbage,201,fpfile);
      PutVolConfigRefSampDir(ref_samp_dir,curr);
      
      /* Sampling factors (hor and ver n/m) */
      fscanf(fpfile,"%d",&hor_samp_n);
      fgets(garbage,201,fpfile);
      PutVolConfigHorSampN(hor_samp_n,curr);
      
      fscanf(fpfile,"%d",&hor_samp_m);
      fgets(garbage,201,fpfile);
      PutVolConfigHorSampM(hor_samp_m,curr);
      
      fscanf(fpfile,"%d",&ver_samp_n);
      fgets(garbage,201,fpfile);
      PutVolConfigVerSampN(ver_samp_n,curr);
      
      fscanf(fpfile,"%d",&ver_samp_m);
      fgets(garbage,201,fpfile);
      PutVolConfigVerSampM(ver_samp_m,curr);
      
      /* Enhancement type */
      fscanf(fpfile,"%d",&enhancement_type);
      fgets(garbage,201,fpfile);
      PutVolConfigEnhanceType(enhancement_type,curr);
                
      /* intra_period: Number of periods between two INTRAs */
      fscanf(fpfile,"%d",&intra_period);
      fgets(garbage,201,fpfile);
      PutVolConfigIntraPeriod(intra_period,curr);

    /* GOV_period: Number of VOPs between two GOVs */
      fscanf(fpfile,"%d",&GOV_period);
      fgets(garbage,201,fpfile);
      PutVolConfigGOVPeriod(GOV_period,curr);

      fscanf(fpfile,"%d",&curr->interlaced);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%d",&curr->top_field_first);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%d",&curr->alternate_scan);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%d",&curr->sr_direct);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%d",&curr->mvfileusage);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%s",curr->mvfilename);
      fgets(garbage,201,fpfile);

      if (curr->mvfileusage &&
          ((curr->mvfile = fopen(curr->mvfilename, (curr->mvfileusage==2) ? "w" : "r")) == NULL)) {
		  fprintf(stderr, "Cannot open %s\n", curr->mvfilename);
		  exit(1);
      }
      curr->mvlineno = 0;

      /* start: Included due to N2171, Clause 2.1.9 MW 23-MAR-1998 */
      /* User data in VOL? */
      fscanf(fpfile,"%d",&is_user_data_in_vol);
      fgets(garbage,201,fpfile);
      PutVolConfigIsUserDataInVol(is_user_data_in_vol,curr);

      fscanf(fpfile,"%s",user_data_in_vol_file);
      fgets(garbage,201,fpfile);
      PutVolConfigUserDataInVolFile(user_data_in_vol_file,curr);


      /* User data in GOV? */
      fscanf(fpfile,"%d",&is_user_data_in_gov);
      fgets(garbage,201,fpfile);
      PutVolConfigIsUserDataInGov(is_user_data_in_gov,curr);

      fscanf(fpfile,"%s",user_data_in_gov_file);
      fgets(garbage,201,fpfile);
      PutVolConfigUserDataInGovFile(user_data_in_gov_file,curr);
      /* end: Included due to N2171, Clause 2.1.9 MW 23-MAR-1998 */

      /* Reading sprite usage (0:no, 1:static, 2:dynamic, 3:GMC) */
      fscanf(fpfile,"%d",&sprite_usage);
      fgets(garbage,201,fpfile);
      PutVolConfigSpriteUsage(sprite_usage,curr);
      
      if (GetVolConfigGOVPeriod(curr)>0&&
      		GetVolConfigSpriteUsage(curr)==STATIC_SPRITE)
		{
		printf("No GOV for STATIC SPRITE\n");
		exit(-1);
		}
       if (GetVolConfigScalability(curr)>0&&
      		GetVolConfigSpriteUsage(curr)==STATIC_SPRITE)
 		{
		printf("No SCALABILITY for STATIC SPRITE\n");
		exit(-1);
		}
           
      if (sprite_usage != SPRITE_NOT_USED) 
	{
 	  fscanf(fpfile,"%d",&sprite_hdim);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteHdim(sprite_hdim,curr);

	  fscanf(fpfile,"%d",&sprite_vdim);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteVdim(sprite_vdim,curr);
			
	  fscanf(fpfile,"%d",&sprite_left_edge);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteLeftEdge(sprite_left_edge,curr);

	  fscanf(fpfile,"%d",&sprite_top_edge);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteTopEdge(sprite_top_edge,curr);

	  if (sprite_usage == GMC_SPRITE) 
	    {
	      sprite_hdim = 16;
	      sprite_vdim = 16;
	      PutVolConfigSpriteHdim(sprite_hdim,curr);
	      PutVolConfigSpriteVdim(sprite_vdim,curr);
	    }
	
	  fscanf(fpfile,"%d",&no_of_sprite_points);
	  fgets(garbage,201,fpfile);
	  PutVolConfigNoOfSpritePoints(no_of_sprite_points,curr);

	  if (no_of_sprite_points>0) 
	      {
	      fscanf(fpfile,"%s",warp_param_file);
	      fgets(garbage,201,fpfile);
	      PutVolConfigWarpParamFile(warp_param_file,curr);
	      }
	  
	  fscanf(fpfile,"%d",&warping_accuracy);
	  fgets(garbage,201,fpfile);
	  PutVolConfigWarpingAccuracy(warping_accuracy,curr);
	
	  fscanf(fpfile,"%d",&brightness_change_in_sprite);
	  fgets(garbage,201,fpfile);
	  PutVolConfigBrightnessChangeInSprite(brightness_change_in_sprite,curr);
	  
	  fscanf(fpfile,"%f",&tmp_blend_fact);
	  blend_fact = tmp_blend_fact * 254;
	  fgets(garbage,201,fpfile);
	  PutVolConfigBlendFact(blend_fact,curr);
	  
	  /* Write/No-write sprite flag */
	  fscanf(fpfile,"%d",&write_sprite);
	  fgets(garbage,201,fpfile);
	  if (write_sprite&&(sprite_usage!=ONLINE_SPRITE) )
	  write_sprite=0;
	  PutVolConfigWriteSprite(write_sprite,curr);
				
	  /* sprite file names used for the three cases: 
	     STATIC (READ) and ON-LINE (WRITE)*/
	  fscanf(fpfile,"%s",sprite_y_file);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteY(sprite_y_file,curr);
	  
	  fscanf(fpfile,"%s",sprite_u_file);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteU(sprite_u_file,curr);
	  
	  fscanf(fpfile,"%s",sprite_v_file);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteV(sprite_v_file,curr);
	  
	  fscanf(fpfile,"%s",sprite_a_file);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteA(sprite_a_file,curr);
	  
	  fscanf(fpfile,"%d",&sprite_shape);
	  fgets(garbage,201,fpfile);
	  PutVolConfigSpriteShape(sprite_shape,curr);

	  if (sprite_usage==1) /* STATIC BASIC OR LOW LATENCY SPRITE */
	  {
/* Reading static sprite usage (0:basic, 1:low latency) */
	  fscanf(fpfile,"%d",&low_latency_sprite_enable);
	  fgets(garbage,201,fpfile);
	  PutVolConfigLowLatencySpriteEnable(low_latency_sprite_enable,curr);
 	  }
			
	  if (sprite_usage == STATIC_SPRITE && low_latency_sprite_enable)
	  	{
		fscanf(fpfile,"%f",&SNR_threshold);
	  	fgets(garbage,201,fpfile);
		PutVolConfigSpriteSNRthreshold(SNR_threshold, curr);
		}
	
	InitForEncodeSprite(curr);
	if (GetVolConfigLowLatencySpriteEnable(curr))
		InitForEncodeLowLatencyStaticSprite(curr);
	  
	}/* end of case SPRITE_USED */		
      
      if(layer == 0)
      vol_config_list = curr;
      else
      AddVolConfigToList(curr,vol_config_list);
      
    }
  
  return(vol_config_list);
}



/***********************************************************CommentBegin******
 *
 * -- ReadVOConfigFile -- Reads the VO config information from the VO config
 *	file
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	20-09-96
 *
 * Purpose :		
 * 	Reads the VO config information (not VOL config info.) from the VO config
 *	file and places this in a VOConfig structure. Also calls a function to
 *	read the VOL information in the config file.
 *
 * Arguments in : 	
 *	Char *file_name - name of file to read from
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VOConfig *vo_cfg - pointer to filled VOConfig structure.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
VOConfig *
ReadVOConfigFile(Char *file_name)
{
	FILE	*fpfile;

	Int		id,
				num_layers;
/* 				layer; */

	Char	garbage[201];

	VOConfig		*vo_cfg;

	VolConfig		*vol_list = NULL;
/* 							*vol; */

	if((fpfile = fopen(file_name,"r")) == NULL)
	{
		fprintf(stderr,"ERROR(ReadVOConfigFile): Can't open %s\n",file_name);
		exit(1);
	}

	vo_cfg = SallocVOConfig();

	fscanf(fpfile,"%d",(Int *)(&id));
	fgets(garbage,201,fpfile);
	PutVOConfigId(id,vo_cfg);

	fscanf(fpfile,"%d,", (Int *)(&num_layers));
	fgets(garbage,201,fpfile);
	PutVOConfigNumVOLs(num_layers,vo_cfg);

        vol_list = ReadVOLConfigData(num_layers,fpfile);

	fclose(fpfile);

	PutVOConfigLayers(vol_list,vo_cfg);


	return(vo_cfg);
}





/***********************************************************CommentBegin******
 *
 * -- AllocVolConfig -- Allocates memory for VolConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 * 	Allocates memory for a VolConfig structure
 *
 * Arguments in : 	
 *	none
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VolConfig *vol_config - pointer to allocated structure
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
 

VolConfig *
AllocVolConfig()
{
	VolConfig	*vol_config;

	vol_config = (VolConfig *)malloc(sizeof(VolConfig));
	vol_config->pnext = NULL;
	vol_config->p_orisprite = NULL;
	vol_config->psprite = NULL;
	vol_config->tab_transmit = NULL;
	vol_config->tab_QP_store = NULL;
	vol_config->tab_DQUANT_store = NULL;
	vol_config->prev_warp_param = NULL;

	return(vol_config);
}


/***********************************************************CommentBegin******
 *
 * -- FreeVolConfig -- deallocates memory for a VolConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 * 	Deallocates all memory for a VolConfig structure
 *
 * Arguments in : 	
 *	VolConfig *vol_cfg - pointer to VolConfig structure to be freed
 *
 * Arguments in/out :	
 *	none	
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
FreeVolConfig(VolConfig *vol_cfg)
{
Vop *vop;
Int *tab;
SInt *stab;
Sprite_motion *prev_warp_param;

	if(vol_cfg != NULL)
		{
		vop = GetVolConfigOriSprite(vol_cfg);
		if (vop!=NULL)
			FreeVop(vop); 
		prev_warp_param = GetVolConfigPrevWarpParam(vol_cfg);
    		if (prev_warp_param!=NULL)
    			free((Char*)prev_warp_param); 
		tab = GetVolConfigSpriteTabTransmit(vol_cfg);
    		if (tab!=NULL)
    			free((Char*)tab); 
		tab = GetVolConfigSpriteTabDQUANTStore(vol_cfg);
    		if (tab!=NULL)
    			free((Char*)tab); 
		stab = GetVolConfigSpriteTabQPStore(vol_cfg);
    		if (stab!=NULL)
    			free((Char*)stab); 
		free((Char*)vol_cfg);
		}

	return;
}


/***********************************************************CommentBegin******
 *
 * -- FreeVolConfigList -- deallocates a linked list of VolConfigs 
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 * 	Deallocates all memory for a linked list of VolConfigs
 *
 * Arguments in : 	
 *	VolConfig *vol_cfg_list - linked list of VolConfigs
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
FreeVolConfigList(VolConfig *vol_cfg_list)
{
	VolConfig	*curr,
						*next;

	curr = vol_cfg_list;

	while(curr != NULL)
	{
		next = GetVolConfigNext(curr);

		FreeVolConfig(curr);

		curr = next;
	}

	return;
}


/***********************************************************CommentBegin******
 *
 * -- AddVolConfigToList -- Adds a VolConfig to a linked list of VolConfigs
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	This function adds a VolConfig to the end of a linked list of VolConfigs
 *	**n.b.** the function assumes that the list is not empty (i.e. it has at
 *	least one node).
 *
 * Arguments in : 	
 *	VolConfig *vol_cfg - VolConfig to be added
 *
 * Arguments in/out :	
 *	VolConfig *list - linked list of VolConfigs
 *
 * Arguments out :	
 *	
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
AddVolConfigToList(VolConfig *vol_cfg, VolConfig *list)
{
	VolConfig	*curr,
						*prev;

	prev = list;
	curr = GetVolConfigNext(prev);

	while(curr != NULL)
	{
		prev = curr;
		curr = GetVolConfigNext(prev);
	}
	
	PutVolConfigNext(vol_cfg,prev);
}



/***********************************************************CommentBegin******
 *
 * -- PutVolConfigXXXX -- Access functions for VolConfig
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	To set particular fields in a VolConfig strcuture
 *
 * Arguments in : 	
 *	Value for field to be set
 *
 * Arguments in/out :	
 *	VolConfig *cfg - pointer to VolConfig structure
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *	04.02.97 Noel O'Connor : Added PutVolConfigSADCTDisable(),
 *		PutVolConfigRateControl(), PutVolConfigIntraQuantizer()
 *	26.02.97 Noel O'Connor : added PutVolConfigReverseVlc() & 
 *		PutVolConfigShapeEffects() & GL quantizer access functions
 *	10.03.97 Minhua Zhou   : Added PutVolConfigM()
 *      23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 *      26.04.97 Luis Ducla-Soares: added PutVolConfigDataPartEnable().
 *	07.05.97 Noel Brady: Add PutVolConfigChangeCRDisable().
 *	09.05.97 Minhua Zhou: Modified PutVolConfigModTimeBase
 *      13.05.97 Minhua Zhou: Added PutVolConfigOBMCDisable()
 *      13.05.97 Minhua Zhou: added PutVolConfigGOVPeriod() 
 *      12.08.97 Minhua Zhou: added  PutVolConfigTimeIncrementResolution()
 *      29.08.97 Osamu Sunohara: added PutVolConfigEnhPredType()
 *	08.09.97 Cecile Dufour: added PutVolConfigOriSprite(),
 *				PutVolConfigSpriteTransmitMode(),
 *				PutVolConfigCheckStaticSpritePrediction()
 *				PutVolConfigSpriteTabTransmit()
 *				PutVolConfigSpriteInitPieceWidth()
 *				PutVolConfigSpriteInitPieceHeight()
 *				PutVolConfigSpriteInitPieceHorRef()
 *				PutVolConfigSpriteInitPieceVerRef()
 *				PutVolConfigSpriteSNRthreshold()
 *	23.10.97 Cecile Dufour: add PutVolConfigSpriteTabQPStore()
 *				PutVolConfigSpriteTabDQUANTStore()
 *	14.04.98 Cecile Dufour: add PutVolConfigLowLatencySpriteEnable()
 *	23.03.98 M. Wollborn add PutVolConfigIsUserDataInVol()
 *				 PutVolConfigUserDataInVolFile()
 *				 PutVolConfigIsUserDataInGov()
 *				 PutVolConfigUserDataInGovFile() due to N2171, Cl. 2.1.9
 *
 ***********************************************************CommentEnd********/

Void PutVolConfigTimeIncrementResolution(Int value,VolConfig *cfg) {
   cfg->time_increment_resolution=value;
 }

Void
PutVolConfigId(Int id,VolConfig *cfg)
{
	cfg->ident = id;
}

Void
PutVolConfigFrameRate(Float fr, VolConfig *cfg)
{
	cfg->frame_rate = fr;
}

Void
PutVolConfigM(Int M, VolConfig *cfg)
{
	cfg->M = M;
}

Void
PutVolConfigDiskSeqX(Int x, VolConfig *cfg)
{
	cfg->disk_seq_x = x;
}

Void
PutVolConfigDiskSeqY(Int y, VolConfig *cfg)
{
	cfg->disk_seq_y = y;
}

Void
PutVolConfigDiskSeqFrameRate(Float fr, VolConfig *cfg)
{
	cfg->disk_seq_frame_rate = fr;
}

Void
PutVolConfigQuantPrecision(Int QuantPrecision,VolConfig *cfg)
{
   	cfg->quant_precision = QuantPrecision;
}
Void
PutVolConfigBitsPerPixel(Int BitsPerPixel,VolConfig *cfg)
{
   	cfg->bits_per_pixel = BitsPerPixel;
}

Void
PutVolConfigShape(Int shape, VolConfig *cfg)
{
	cfg->shape = shape;
}

Void
PutVolConfigShapeEffects(Int shape_effects,VolConfig *cfg)
{
	cfg->shape_effects = shape_effects;
}
Void
PutVolConfigOBMCDisable(Int OBMCDisable,VolConfig *cfg)
{
   	cfg->obmc_disable = OBMCDisable;
}
Void
PutVolConfigY(Char *name, VolConfig *cfg)
{
	strcpy(cfg->disk_y_file,name);
}

Void
PutVolConfigU(Char *name, VolConfig *cfg)
{
	strcpy(cfg->disk_u_file,name);
}

Void
PutVolConfigV(Char *name, VolConfig *cfg)
{
	strcpy(cfg->disk_v_file,name);
}

Void
PutVolConfigA(Char *name, VolConfig *cfg)
{
	strcpy(cfg->disk_a_file,name);
}


Void
PutVolConfigWriteCoded(Int write, VolConfig *cfg)
{
	cfg->write_coded = write;
}

Void
PutVolConfigCodedY(Char *name, VolConfig *cfg)
{
	strcpy(cfg->coded_y_file,name);
}

Void
PutVolConfigCodedU(Char *name, VolConfig *cfg)
{
	strcpy(cfg->coded_u_file,name);
}

Void
PutVolConfigCodedV(Char *name, VolConfig *cfg)
{
	strcpy(cfg->coded_v_file,name);
}

Void
PutVolConfigCodedA(Char *name, VolConfig *cfg)
{
	strcpy(cfg->coded_a_file,name);
}

Void
PutVolConfigBitstream(Char *name, VolConfig *cfg)
{
	strcpy(cfg->bitstream,name);
}

Void
PutVolConfigStartFrame(Int frame, VolConfig *cfg)
{
	cfg->start_frame = frame;
}

Void
PutVolConfigEndFrame(Int frame, VolConfig *cfg)
{
	cfg->end_frame = frame;
}

Void
PutVolConfigBitrate(Int bit_rate,VolConfig *cfg)
{
	cfg->bit_rate = bit_rate;
}

Void
PutVolConfigQuantType(Int type,VolConfig *cfg)
{
	cfg->quant_type = type;
}

/* Added MPEG-like quantization stuff, 23-APR-1997 MW */

Void
PutVolConfigLoadIntraQuantMat(Int load_intra_quant_mat, 
			      VolConfig *cfg)
{
	cfg->load_intra_quant_mat = load_intra_quant_mat;
}

Void
PutVolConfigIntraQuantMatFile(Char *intra_quant_mat_file, 
			      VolConfig *cfg)
{
	strcpy(cfg->intra_quant_mat_file,intra_quant_mat_file);
}

Void
PutVolConfigLoadNonintraQuantMat(Int load_nonintra_quant_mat, 
				 VolConfig *cfg)
{
	cfg->load_nonintra_quant_mat = load_nonintra_quant_mat;
}

Void
PutVolConfigNonintraQuantMatFile(Char *nonintra_quant_mat_file, 
				 VolConfig *cfg)
{
	strcpy(cfg->nonintra_quant_mat_file,nonintra_quant_mat_file);
}

Void
PutVolConfigLoadGrayIntraQuantMat(Int load_gray_intra_quant_mat, 
				  VolConfig *cfg)
{
	cfg->load_gray_intra_quant_mat = load_gray_intra_quant_mat;
}

Void
PutVolConfigGrayIntraQuantMatFile(Char *gray_intra_quant_mat_file, 
				  VolConfig *cfg)
{
	strcpy(cfg->gray_intra_quant_mat_file,gray_intra_quant_mat_file);
}

Void
PutVolConfigLoadGrayNonintraQuantMat(Int load_gray_nonintra_quant_mat, 
				     VolConfig *cfg)
{
	cfg->load_gray_nonintra_quant_mat = load_gray_nonintra_quant_mat;
}

Void
PutVolConfigGrayNonintraQuantMatFile(Char *gray_nonintra_quant_mat_file, 
				     VolConfig *cfg)
{
	strcpy(cfg->gray_nonintra_quant_mat_file,gray_nonintra_quant_mat_file);
}

/* End of MPEG-like quantization stuff, 23-APR-1997 MW */

Void
PutVolConfigErrorResDisable(Int disable,VolConfig *cfg)
{
	cfg->error_res_disable = disable;
}

Void
PutVolConfigDataPartEnable(Int enable, VolConfig *cfg)
{
        cfg->data_partitioning = enable;
}

Void
PutVolConfigReverseVlc(Int reverse_vlc,VolConfig *cfg)
{
	cfg->reverse_vlc = reverse_vlc;
}

Void
PutVolConfigPacketSize(Int packet_size,VolConfig *cfg)
{
	cfg->packet_size = packet_size;
}

Void
PutVolConfigACDCPredDisable(Int disable,VolConfig *cfg)
{
	cfg->intra_acdc_pred_disable = disable;
}

Void
PutVolConfigSearchRange(Int sr,VolConfig *cfg)
{
	cfg->sr_for = sr;
}



Void
PutVolConfigAlphaTh(Int alpha_th,VolConfig *cfg)
{
	cfg->alpha_th = alpha_th;
}

Void PutVolConfigChangeCRDisable( Int change_CR_disable, VolConfig *cfg)
{
	cfg->change_CR_disable = change_CR_disable;
}

Void
PutVolConfigScalability(Int scale,VolConfig *cfg)
{
	cfg->scalability = scale;
}

/*for ssp (UPS)*/
Void
PutVolConfigScalType(Int scalability_type,VolConfig *cfg)
{
	cfg->scal_type = scalability_type;
}/*end of ssp (UPS)*/
		
/* added by Sony 290897 */
Void
PutVolConfigEnhPredType(Int enh_pred_type,VolConfig *cfg)
{
        cfg->ss_enh_pred_type = enh_pred_type;
}
/* 290897 */

Void
PutVolConfigRefId(Int id, VolConfig *cfg)
{
	cfg->ref_ident = id;
}

Void
PutVolConfigRefSampDir(Int dir,VolConfig *cfg)
{
	cfg->ref_samp_dir = dir;
}

Void
PutVolConfigHorSampN(Int value, VolConfig *cfg)
{
	cfg->hor_samp_n = value;
}

Void
PutVolConfigHorSampM(Int value, VolConfig *cfg)
{
	cfg->hor_samp_m = value;
}

Void
PutVolConfigVerSampN(Int value, VolConfig *cfg)
{
	cfg->ver_samp_n = value;
}

Void
PutVolConfigVerSampM(Int value, VolConfig *cfg)
{
	cfg->ver_samp_m = value;
}

Void
PutVolConfigEnhanceType(Int type,VolConfig *cfg)
{
	cfg->enhancement_type = type;
}

Void
PutVolConfigIntraPeriod(Int ir,VolConfig *cfg)
{
        cfg->intra_period = ir;
}

Void
PutVolConfigGOVPeriod(Int ir,VolConfig *cfg)
{
        cfg->GOV_period = ir;
}

/* start: Included for user_data() due to N2171, Cl. 2.1.9 MW 23-MAR-1998 */
Void
PutVolConfigIsUserDataInVol(Int value, VolConfig *cfg)
{
        cfg->is_user_data_in_vol = value;
}

Void
PutVolConfigUserDataInVolFile(Char *file, VolConfig *cfg)
{
	strcpy(cfg->user_data_in_vol_file, file);
}

Void
PutVolConfigIsUserDataInGov(Int value, VolConfig *cfg)
{
        cfg->is_user_data_in_gov = value;
}

Void
PutVolConfigUserDataInGovFile(Char *file, VolConfig *cfg)
{
	strcpy(cfg->user_data_in_gov_file, file);
}
/* end: Included for user_data() due to N2171, Cl. 2.1.9 MW 23-MAR-1998 */


Void 
PutVolConfigSpriteHdim(Int sprite_hdim,VolConfig *cfg)
{
	cfg->sprite_hdim = sprite_hdim;
}

Void 
PutVolConfigSpriteVdim(Int sprite_vdim,VolConfig *cfg)
{
	cfg->sprite_vdim = sprite_vdim;
}

Void 
PutVolConfigSpriteLeftEdge(Int sprite_left_edge,VolConfig *cfg)
{
	cfg->sprite_left_edge = sprite_left_edge;
}

Void 
PutVolConfigSpriteTopEdge(Int sprite_top_edge,VolConfig *cfg)
{
	cfg->sprite_top_edge = sprite_top_edge;
}

Void
PutVolConfigBlendFact(Int blend_fact,VolConfig *cfg)
{
	cfg->blend_fact = blend_fact;
}

Void
PutVolConfigWarpParamFile(Char *name, VolConfig *cfg)
{
	strcpy(cfg->warp_param_file,name);
}

Void
PutVolConfigPrevWarpParam(Sprite_motion *prev_warp_param, VolConfig *cfg)
{
	cfg->prev_warp_param = prev_warp_param;
}

Void
PutVolConfigWarpParamCounter(Int counter, VolConfig *cfg)
{
	cfg->warp_param_counter = counter;
}

Void
PutVolConfigSpriteUsage( Int sprite_usage, VolConfig *cfg)
{
	cfg->sprite_usage = sprite_usage;
}

Void
PutVolConfigWarpingAccuracy( Int warping_accuracy, VolConfig *cfg)
{
	cfg->warping_accuracy = warping_accuracy;
}

Void
PutVolConfigSpriteShape( Int shape, VolConfig *cfg)
{
	cfg->sprite_shape = shape;
}

Void
PutVolConfigNoOfSpritePoints( Int no_of_sprite_points , VolConfig *cfg )
{
	cfg->no_of_sprite_points = no_of_sprite_points;
}

Void
PutVolConfigRefPointCoord( TrajPoint *ref_point_coord , VolConfig *cfg )
{
	cfg->ref_point_coord = ref_point_coord;
}

Void
PutVolConfigBrightnessChangeInSprite( Int brightness_change_in_sprite , VolConfig *cfg )
{
	cfg->brightness_change_in_sprite = brightness_change_in_sprite;
}

Void
PutVolConfigWriteSprite(Int write, VolConfig *cfg)
{
	cfg->write_sprite = write;
}

Void
PutVolConfigSpriteY(Char *name, VolConfig *cfg)
{
	strcpy(cfg->sprite_y_file,name);
}

Void
PutVolConfigSpriteU(Char *name, VolConfig *cfg)
{
	strcpy(cfg->sprite_u_file,name);
}

Void
PutVolConfigSpriteV(Char *name, VolConfig *cfg)
{
	strcpy(cfg->sprite_v_file,name);
}

Void
PutVolConfigSpriteA(Char *name, VolConfig *cfg)
{
	strcpy(cfg->sprite_a_file,name);
}
Void
PutVolConfigSprite(Vop *sprite, VolConfig *cfg)
{
	cfg->psprite = sprite;
}

Void
PutVolConfigOriSprite(Vop *orisprite, VolConfig *cfg)
{
	cfg->p_orisprite = orisprite;
}

Void
PutVolConfigSpriteTransmitMode(Int sprite_transmit_mode, VolConfig *cfg)
{
	cfg->sprite_transmit_mode = sprite_transmit_mode;
}

Void
PutVolConfigCheckStaticSpritePrediction(Int check_staticsprite_prediction, VolConfig *cfg)
{
	cfg->check_staticsprite_prediction = check_staticsprite_prediction; 
}

Void
PutVolConfigSpriteTabTransmit(Int *tab_transmit, VolConfig *cfg)
{
	cfg->tab_transmit = tab_transmit;
}

Void
PutVolConfigSpriteTabQPStore(SInt *tab_QP_store, VolConfig *cfg)
{
	cfg->tab_QP_store = tab_QP_store;
}

Void
PutVolConfigSpriteTabDQUANTStore(Int *tab_DQUANT_store, VolConfig *cfg)
{
	cfg->tab_DQUANT_store = tab_DQUANT_store;
}

Void
PutVolConfigSpriteInitPieceWidth( Int init_piece_width, VolConfig *cfg)
{
	cfg->init_piece_width = init_piece_width;
}

Void
PutVolConfigSpriteInitPieceHeight( Int init_piece_height, VolConfig *cfg)
{
	cfg->init_piece_height = init_piece_height;
}

Void
PutVolConfigSpriteInitPieceHorRef( Int init_piece_hor_ref, VolConfig *cfg)
{
	cfg->init_piece_hor_ref = init_piece_hor_ref;
}

Void
PutVolConfigSpriteInitPieceVerRef( Int init_piece_ver_ref, VolConfig *cfg)
{
	cfg->init_piece_ver_ref = init_piece_ver_ref;
}

Void
PutVolConfigSpriteSNRthreshold( Float SNR_threshold, VolConfig *cfg)
{
	cfg->SNR_threshold = SNR_threshold;
}

Void
PutVolConfigLowLatencySpriteEnable( Int low_latency_sprite_enable, 
							VolConfig *cfg)
{
	cfg->low_latency_sprite_enable = low_latency_sprite_enable;
}

Void
PutVolConfigNext(VolConfig *next, VolConfig *cfg)
{
	cfg->pnext = next;
}

Void
PutVolConfigQuantizer(Int Q,VolConfig *cfg)
{
	cfg->quantizer = Q;
}

Void
PutVolConfigBQuantizer(Int Q,VolConfig *cfg)
{
	cfg->B_quantizer = Q;
}


Void
PutVolConfigIntraQuantizer(Int Q,VolConfig *cfg)
{
	cfg->intra_quantizer = Q;
}

Void
PutVolConfigStartTime(Float time,VolConfig *cfg)
{
	cfg->start_time = time;
}

Void
PutVolConfigFrame(Int frame,VolConfig *cfg)
{
	cfg->frame = frame;
}

Void
PutVolConfigFrameSkip(Int frame_skip,VolConfig *cfg)
{
	cfg->frame_skip = frame_skip;
}

Void
PutVolConfigEndTime(Float time,VolConfig *cfg)
{
	cfg->end_time = time;
}

Void
PutVolConfigTimeInc(Float time,VolConfig *cfg)
{
	cfg->time_inc = time;
}

Void
PutVolConfigModTimeBase(Int time,VolConfig *cfg)
{
	cfg->modulo_time_base[0] = cfg->modulo_time_base[1];
	cfg->modulo_time_base[1] = time;
}

Void
PutVolConfigNextCodingTime(Float time,VolConfig *cfg)
{
	cfg->next_coding_time = time;
}

Void
PutVolConfigSADCTDisable(Int flag,VolConfig *cfg)
{
	cfg->sadct_disable = flag;
}


Void
PutVolConfigGLQuant(Int gl_quant,VolConfig *cfg)
{
	cfg->gl_quant = gl_quant;
}

Void
PutVolConfigDisableGrayQuantUpdate(Int disable_gray_quant_update,
				   VolConfig *cfg)
{
	cfg->disable_gray_quant_update = disable_gray_quant_update;
}

/* UPM: Parameter string for Multi Rate Control */


Void
PutVolConfigRCParam(Char *rc_parameter_string, VolConfig *cfg)
{
        strcpy(cfg->rc_parameter_string, rc_parameter_string);
}



Void
PutVolConfigIntraShapePeriod(Int period, VolConfig *cfg)
{
	cfg->intra_shape_period = period;
}

/***********************************************************CommentBegin******
 *
 * -- GetVolConfigBase -- Returns the base VolConfig structure from a list
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	Given a linked list of VolConfig structures, this function returns the
 *	BASE Volconfig structure (recognisable by its scalability flag)
 *
 * Arguments in : 	
 *	VolConfig *list - linked list of VolConfigs
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VolConfig *cfg - pointer to BASE VolConfig
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

VolConfig *
GetVolConfigBase(VolConfig *list)
{
	VolConfig *cfg;

	cfg = list;

	while(cfg != NULL)
	{
		if(GetVolConfigScalability(cfg) == BASE_LAYER)
			return(cfg);
		else
			cfg = GetVolConfigNext(cfg);
	}

	return(cfg);
}


/***********************************************************CommentBegin******
 *
 * -- GetVolConfigById -- returns a particular VolConfig from a list
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	Given a linked list of VolConfigs this function returns a particular
 *	VolConfig identified by its Id.
 *
 * Arguments in : 	
 *	VolConfig *list - linked list of VolConfigs
 *	Int vol_cfg_id - Id of require VolConfig	
 *
 * Arguments in/out :	
 *	none	
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VolConfig *curr - pointer to required VolConfig structure
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
VolConfig *
GetVolConfigById(VolConfig *list,Int vol_cfg_id)
{
	VolConfig	*curr;
	Int id;

	curr = list;

	while(curr != NULL)
	{
		id = GetVolConfigId(curr);
		if(id != vol_cfg_id)
			curr = GetVolConfigNext(curr);
		else
			break;
	}

	return(curr);
}

/***********************************************************CommentBegin******
 *
 * -- GetVolConfigXXXX -- Access functions for VolConfig
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	To obtain the value of particular fields in a VolConfig structure
 *
 * Arguments in : 	
 *	VolConfig *cfg - pointer to VolConfig structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	Value of required field
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	mom_access.c for similar functions for other structures
 *
 * Modified :		
 *	04.02.97 Noel O'Connor : added GetVolConfigSADCTDisable(),
 *					GetVolConfigRateControl(), GetVolConfigIntraQuantizer()
 *	11.02.97 J. Ignacio Ronda: modified UpdateVolConfigNextCodingTime() to
 *          skip frames due to buffer fullness in the VM5 rate control
 * 14.02.97 J. Ignacio Ronda: modified UpdateVolConfigNextCodingTime() to
 *          skip frames to read from disk due to buffer fullness.
 *	26.02.97 Noel O'Connor: Added GetVolConfigReverseVlc() &
 *					GetVolConfigShapeEffects() and GL quantizer access functions
 *
 *       10.03.97 Minhua Zhou: added GetVolConfigM()
 *       23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 *       26.04.97 Luis Ducla-Soares: added GetVolConfigDataPartEnable().
 *	 09.05.97 Minhua Zhou : modified GetVolConfigModTimeBase
 *       13.05.97 Minhua Zhou : added GetVolConfigOBMCDisable()
 *				and GetVolConfigGOVPeriod()
 *       12.08.97 Minhua Zhou : added GetVolConfigTimeIncrementResolution()
 *       29.08.97 Osamu Sunohara: added GetVolConfigEnhPredType()
 *	 08.09.97 Cecile Dufour: added static sprites func. (see PutVolConfig)
 *       27.11.97 M. Eckert: Changes for independent frame type rate control
 *                           frame_type -> UpdateVolConfigNextCodingTime()
 *	23.03.98 M. Wollborn add GetVolConfigIsUserDataInVol()
 *				 GetVolConfigUserDataInVolFile()
 *				 GetVolConfigIsUserDataInGov()
 *				 GetVolConfigUserDataInGovFile() due to N2171, Cl. 2.1.9
 *	14.04.98 Cecile Dufour: add GetVolConfigLowLatencySpriteEnable
 *
 ***********************************************************CommentEnd********/


Int GetVolConfigTimeIncrementResolution(VolConfig *cfg) {
   return cfg->time_increment_resolution;
 }
	
Int
GetVolConfigId(VolConfig *cfg)
{
	return(cfg->ident);
}

Float
GetVolConfigFrameRate(VolConfig *cfg)
{
	return(cfg->frame_rate);
}

Int 
GetVolConfigM(VolConfig *cfg)
{
	return(cfg->M);
}


Int
GetVolConfigDiskSeqX(VolConfig *cfg)
{
	return(cfg->disk_seq_x);
}

Int
GetVolConfigDiskSeqY(VolConfig *cfg)
{
	return(cfg->disk_seq_y);
}

Float
GetVolConfigDiskSeqFrameRate(VolConfig *cfg)
{
	return(cfg->disk_seq_frame_rate);
}

Int
GetVolConfigShape(VolConfig *cfg)
{
	return(cfg->shape);
}

Int
GetVolConfigShapeEffects(VolConfig *cfg)
{
	return(cfg->shape_effects);
}

Char *
GetVolConfigY(VolConfig *cfg)
{
	return(cfg->disk_y_file);
}

Char *
GetVolConfigU(VolConfig *cfg)
{
	return(cfg->disk_u_file);
}

Char *
GetVolConfigV(VolConfig *cfg)
{
	return(cfg->disk_v_file);
}

Char *
GetVolConfigA(VolConfig *cfg)
{
	return(cfg->disk_a_file);
}


Int
GetVolConfigWriteCoded(VolConfig *cfg)
{
	return(cfg->write_coded);
}

Char *
GetVolConfigCodedY(VolConfig *cfg)
{
	return(cfg->coded_y_file);
}

Char *
GetVolConfigCodedU(VolConfig *cfg)
{
	return(cfg->coded_u_file);
}

Char *
GetVolConfigCodedV(VolConfig *cfg)
{
	return(cfg->coded_v_file);
}

Char *
GetVolConfigCodedA(VolConfig *cfg)
{
	return(cfg->coded_a_file);
}

Char *
GetVolConfigBitstream(VolConfig *cfg)
{
	return(cfg->bitstream);
}

Int
GetVolConfigStartFrame(VolConfig *cfg)
{
	return(cfg->start_frame);
}

Int
GetVolConfigEndFrame(VolConfig *cfg)
{
	return(cfg->end_frame);
}

Int
GetVolConfigBitrate(VolConfig *cfg)
{
	return(cfg->bit_rate);
}

Int
GetVolConfigQuantType(VolConfig *cfg)
{
	return(cfg->quant_type);
}

/* Added MPEG-like quantization stuff, 23-APR-1997 MW */

Int
GetVolConfigLoadIntraQuantMat(VolConfig *cfg)
{
	return(cfg->load_intra_quant_mat);
}

Int *
GetVolConfigIntraQuantMat(VolConfig *cfg)
{
	return(cfg->intra_quant_mat);
}

Char *
GetVolConfigIntraQuantMatFile(VolConfig *cfg)
{
	return(cfg->intra_quant_mat_file);
}

Int
GetVolConfigLoadNonintraQuantMat(VolConfig *cfg)
{
	return(cfg->load_nonintra_quant_mat);
}

Int *
GetVolConfigNonintraQuantMat(VolConfig *cfg)
{
	return(cfg->nonintra_quant_mat);
}

Char *
GetVolConfigNonintraQuantMatFile(VolConfig *cfg)
{
	return(cfg->nonintra_quant_mat_file);
}

Int
GetVolConfigLoadGrayIntraQuantMat(VolConfig *cfg)
{
	return(cfg->load_gray_intra_quant_mat);
}

Int *
GetVolConfigGrayIntraQuantMat(VolConfig *cfg)
{
	return(cfg->gray_intra_quant_mat);
}

Char *
GetVolConfigGrayIntraQuantMatFile(VolConfig *cfg)
{
	return(cfg->gray_intra_quant_mat_file);
}

Int
GetVolConfigLoadGrayNonintraQuantMat(VolConfig *cfg)
{
	return(cfg->load_gray_nonintra_quant_mat);
}

Int *
GetVolConfigGrayNonintraQuantMat(VolConfig *cfg)
{
	return(cfg->gray_nonintra_quant_mat);
}

Char *
GetVolConfigGrayNonintraQuantMatFile(VolConfig *cfg)
{
	return(cfg->gray_nonintra_quant_mat_file);
}

/* End of MPEG-like quantization stuff, 23-APR-1997 MW */

Int
GetVolConfigErrorResDisable(VolConfig *cfg)
{
	return(cfg->error_res_disable);
}

Int
GetVolConfigDataPartEnable(VolConfig *cfg)
{
        return(cfg->data_partitioning);
}
Int
GetVolConfigOBMCDisable(VolConfig *cfg)
{
   	return(cfg->obmc_disable);
}
Int
GetVolConfigQuantPrecision(VolConfig *cfg)
{
	return(cfg->quant_precision);
}

Int
GetVolConfigBitsPerPixel(VolConfig *cfg)
{
	return(cfg->bits_per_pixel);
}
Int
GetVolConfigReverseVlc(VolConfig *cfg)
{
	return(cfg->reverse_vlc);
}

Int
GetVolConfigPacketSize(VolConfig *cfg)
{
	return(cfg->packet_size);
}

Int
GetVolConfigACDCPredDisable(VolConfig *cfg)
{
	return(cfg->intra_acdc_pred_disable);
}

Int
GetVolConfigSearchRange(VolConfig *cfg)
{
	return(cfg->sr_for);
}



Int
GetVolConfigAlphaTh(VolConfig *cfg)
{
	return(cfg->alpha_th);
}

Int
GetVolConfigChangeCRDisable(VolConfig *cfg)
{
	return(cfg->change_CR_disable);
}

Int
GetVolConfigScalability(VolConfig *cfg)
{
	return(cfg->scalability);
}
Int
GetVolConfigScalType(VolConfig *cfg)
{
	return(cfg->scal_type);
}

/* added by Sony 290897 */
Int
GetVolConfigEnhPredType(VolConfig *cfg)
{
        return(cfg->ss_enh_pred_type);
}
/* 290897 */

Int
GetVolConfigRefId(VolConfig *cfg)
{
	return(cfg->ref_ident);
}

Int
GetVolConfigRefSampDir(VolConfig *cfg)
{
	return(cfg->ref_samp_dir);
}

Int
GetVolConfigHorSampN(VolConfig *cfg)
{
	return(cfg->hor_samp_n);
}

Int
GetVolConfigHorSampM(VolConfig *cfg)
{
	return(cfg->hor_samp_m);
}

Int
GetVolConfigVerSampN(VolConfig *cfg)
{
	return(cfg->ver_samp_n);
}

Int
GetVolConfigVerSampM(VolConfig *cfg)
{
	return(cfg->ver_samp_m);
}

Int
GetVolConfigEnhanceType(VolConfig *cfg)
{
	return(cfg->enhancement_type);
}

Int
GetVolConfigIntraPeriod(VolConfig *cfg)
{
        return(cfg->intra_period);
}

Int
GetVolConfigGOVPeriod(VolConfig *cfg)
{
        return(cfg->GOV_period);
}

/* start: Included for user_data() due to N2171, Cl. 2.1.9 MW 23-MAR-1998 */
Int
GetVolConfigIsUserDataInVol(VolConfig *cfg)
{
	return(cfg->is_user_data_in_vol);
}

Char *
GetVolConfigUserDataInVolFile(VolConfig *cfg)
{
	return(cfg->user_data_in_vol_file);
}

Int
GetVolConfigIsUserDataInGov(VolConfig *cfg)
{
	return(cfg->is_user_data_in_gov);
}

Char *
GetVolConfigUserDataInGovFile(VolConfig *cfg)
{
	return(cfg->user_data_in_gov_file);
}
/* end: Included for user_data() due to N2171, Cl. 2.1.9 MW 23-MAR-1998 */


Int
GetVolConfigSpriteHdim(VolConfig *cfg)
{
	return(cfg->sprite_hdim);
}

Int
GetVolConfigSpriteVdim(VolConfig *cfg)
{
	return(cfg->sprite_vdim);
}

Int
GetVolConfigSpriteLeftEdge(VolConfig *cfg)
{
	return(cfg->sprite_left_edge);
}

Int
GetVolConfigSpriteTopEdge(VolConfig *cfg)
{
	return(cfg->sprite_top_edge);
}

Int
GetVolConfigBlendFact(VolConfig *cfg)
{
	return(cfg->blend_fact);
}

Char *
GetVolConfigWarpParamFile(VolConfig *cfg)
{
	return(cfg->warp_param_file);
}

Sprite_motion *
GetVolConfigPrevWarpParam(VolConfig *cfg)
{
	return(cfg->prev_warp_param);
}

Int
GetVolConfigWarpParamCounter(VolConfig *cfg)
{
	return(cfg->warp_param_counter);
}

Int
GetVolConfigSpriteUsage(VolConfig *cfg)
{
	return( cfg->sprite_usage );
}

Int
GetVolConfigWarpingAccuracy(VolConfig *cfg)
{
	return( cfg->warping_accuracy );
}

Int
GetVolConfigSpriteShape(VolConfig *cfg)
{
	return( cfg->sprite_shape );
}

Int 
GetVolConfigNoOfSpritePoints( VolConfig *cfg )
{
	return( cfg->no_of_sprite_points );
}

TrajPoint *
GetVolConfigRefPointCoord( VolConfig *cfg )
{
	return( cfg->ref_point_coord );
}

Int
GetVolConfigBrightnessChangeInSprite( VolConfig *cfg )
{
	return( cfg->brightness_change_in_sprite );
}

Int
GetVolConfigWriteSprite(VolConfig *cfg)
{
	return(cfg->write_sprite);
}

Char *
GetVolConfigSpriteY(VolConfig *cfg)
{
	return(cfg->sprite_y_file);
}

Char *
GetVolConfigSpriteU(VolConfig *cfg)
{
	return(cfg->sprite_u_file);
}

Char *
GetVolConfigSpriteV(VolConfig *cfg)
{
	return(cfg->sprite_v_file);
}

Char *
GetVolConfigSpriteA(VolConfig *cfg)
{
	return(cfg->sprite_a_file);
}

Vop *
GetVolConfigSprite(VolConfig *cfg)
{
	return(cfg->psprite);
}

Vop *
GetVolConfigOriSprite(VolConfig *cfg)
{
	return(cfg->p_orisprite);
}

Int
GetVolConfigSpriteTransmitMode(VolConfig *cfg)
{
	return(cfg->sprite_transmit_mode);
}

Int
GetVolConfigCheckStaticSpritePrediction(VolConfig *cfg)
{
	return(cfg->check_staticsprite_prediction);
}

Int *
GetVolConfigSpriteTabTransmit(VolConfig *cfg)
{
	return(cfg->tab_transmit);
}

SInt *
GetVolConfigSpriteTabQPStore(VolConfig *cfg)
{
	return(cfg->tab_QP_store);
}

Int *
GetVolConfigSpriteTabDQUANTStore(VolConfig *cfg)
{
	return(cfg->tab_DQUANT_store);
}

Int
GetVolConfigSpriteInitPieceWidth(VolConfig *cfg)
{
	return(cfg->init_piece_width);
}

Int
GetVolConfigSpriteInitPieceHeight(VolConfig *cfg)
{
	return(cfg->init_piece_height);
}

Int
GetVolConfigSpriteInitPieceHorRef(VolConfig *cfg)
{
	return(cfg->init_piece_hor_ref);
}

Int
GetVolConfigSpriteInitPieceVerRef(VolConfig *cfg)
{
	return(cfg->init_piece_ver_ref);
}

Float
GetVolConfigSpriteSNRthreshold(VolConfig *cfg)
{
	return(cfg->SNR_threshold);
}

Int
GetVolConfigLowLatencySpriteEnable(VolConfig *cfg)
{
	return(cfg->low_latency_sprite_enable);
}

VolConfig *
GetVolConfigNext(VolConfig *cfg)
{
	return(cfg->pnext);
}

Int
GetVolConfigQuantizer(VolConfig *cfg)
{
	return(cfg->quantizer);
}

Int
GetVolConfigIntraQuantizer(VolConfig *cfg)
{
	return(cfg->intra_quantizer);
}

Int
GetVolConfigBQuantizer(VolConfig *cfg)
{
	return(cfg->B_quantizer);
}

Float
GetVolConfigStartTime(VolConfig *cfg)
{
	return(cfg->start_time);
}

Int
GetVolConfigFrameSkip(VolConfig *cfg)
{
	return(cfg->frame_skip);
}

Float
GetVolConfigEndTime(VolConfig *cfg)
{
	return(cfg->end_time);
}

Float
GetVolConfigTimeInc(VolConfig *cfg)
{
	return(cfg->time_inc);
}

Int
GetVolConfigModTimeBase(VolConfig *cfg,Int i)
{
	return(cfg->modulo_time_base[i]);
}

Float
GetVolConfigNextCodingTime(VolConfig *cfg)
{
	return(cfg->next_coding_time);
}

Int
GetVolConfigSADCTDisable(VolConfig *cfg)
{
	return(cfg->sadct_disable);
}

/* UPM: New parameters for Multi Rate Control */

/* -> GetEncodeControlRCType
Int
GetVolConfigRateControl(VolConfig *cfg)
{
	return(cfg->rate_control);
}
*/

Char *
GetVolConfigRCParam(VolConfig *cfg)
{
        return(cfg->rc_parameter_string);
}

Int
GetVolConfigGLQuant(VolConfig *cfg)
{
	return(cfg->gl_quant);
}

Int
GetVolConfigDisableGrayQuantUpdate(VolConfig *cfg)
{
	return(cfg->disable_gray_quant_update);
}

Void
UpdateVolConfigNextCodingTime(VolConfig *cfg, 
			      Int vo_id, 
			      Int vol_id, 
			      Int rc_type,
			      Int rc_algorithm,
			      Int frame_type)
{
	Float	time_inc,
	        new_time;

	Int	skip_frame = 0;

	/* RC2 */
	Int	frame;

	time_inc = GetVolConfigTimeInc(cfg);
	new_time = cfg->next_coding_time;
      
	do
		{
		new_time += time_inc*(Float)GetVolConfigM(cfg);

		if (new_time > cfg->end_time)
			break;
#ifndef _RC_NO_SKIPPING_

              if (rc_type == VM5_RATE_CONTROL && 
                    rc_algorithm == RC_ALGORITHM_Q2)
                        {
                        skip_frame = RC_FrameSkipping(vo_id, vol_id);
                        if (skip_frame)
                                {
                                RC_UpdateAfterSkipping(vo_id, vol_id, frame_type);
                                /* RC2: update the frame number and put in VolConfigFrame */
                                frame = GetVolConfigFrame(cfg) + GetVolConfigFrameSkip(cfg);
                                fprintf(stdout,
                   "....................Frame Skipping: newframe =%d\n",frame);
            PutVolConfigFrame(frame, cfg);

                                /* RC2 */
                                }
                        }
#endif /* _RC_NO_SKIPPING_ */

		}while(skip_frame);

	new_time = RoundTime(new_time);

	cfg->next_coding_time = new_time;

	return;
}

Int GetVolConfigIntraShapePeriod(VolConfig *cfg)
{
	return cfg->intra_shape_period;
}

/***********************************************************CommentBegin******
 *
 * -- GetVolConfigFrame -- Special access function for te "next" frame
 *		to code of a VolConfig.
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	24-09-96
 *
 * Purpose :		
 *	This is a special access function for the "next" P-frame to be coded
 *	field of the VolConfig structure. The current value of the field is 
 *	returned and the value of the field is incremented by the value of 
 *	the frame skip field. THIS FUNCTION SHOULD ONLY BE CALLED ONCE PER
 *	CODING INSTANT.
 *
 * Arguments in : 	
 *	VolConfig *cfg - pointer to VolConfig structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	next frame to be coded
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	mom_access.c for similar functions for other structures
 *
 * Modified :		
 *
 * 11.03.97  Minhua Zhou:  added M to frame number 	
 *
 ***********************************************************CommentEnd********/	

Int
GetVolConfigFrame(VolConfig *cfg)
{
	Int	frame;

	frame = cfg->frame;

	/* Inc. value in structure to next frame to be coded */
	cfg->frame  = cfg->frame + GetVolConfigM(cfg)*cfg->frame_skip;

#ifdef _RC_DEBUG_
	fprintf(stdout,"Coding frame =%d\n",frame);
#endif
	return(frame);
}

/***********************************************************CommentBegin******
 *
 * -- PrintVolConfig -- Prints the contents of a VolConfig structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	This function prints the contents of a VolConfig structure. This
 *	is printed either to a file or to the display.
 * 
 * Arguments in : 	
 *	VolConfig *cfg - pointer to VolConfig structure
 *	File *file - file pointer (where to write to)
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 * 23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 * 26.04.97 Luis Ducla-Soares: Added Data Partitioning stuff.
 *	
 *
 ***********************************************************CommentEnd********/
 
Void
PrintVolConfig(VolConfig *cfg,File *file)
{


	fprintf(file,"\n*** Control Configuration ***\n\n");
	fprintf(file,"Layer Id : %d\n", (Int)GetVolConfigId(cfg));
	fprintf(file,"Frame rate : %f\n",GetVolConfigFrameRate(cfg));
	fprintf(file,"Source Y seq. : %s\n",GetVolConfigY(cfg));
	fprintf(file,"Source U seq. : %s\n",GetVolConfigU(cfg));
	fprintf(file,"Source V seq. : %s\n",GetVolConfigV(cfg));
	if(GetVolConfigShape(cfg) == RECTANGULAR)
		fprintf(file,"No shape coding\n");
	else if(GetVolConfigShape(cfg) == BINARY)
		fprintf(file,"Binary shape coding - Source seq. : %s\n",GetVolConfigA(cfg));
	else
		fprintf(file,"Grey Level shape coding - Source seq. : %s\n",GetVolConfigA(cfg));
	if(GetVolConfigShapeEffects(cfg) == NO_SHAPE_EFFECTS)
		fprintf(file,"NO_SHAPE_EFFECTS mode selected\n");
	fprintf(file,"Source seq. resolution : %d x %d\n",
		(Int)GetVolConfigDiskSeqX(cfg),
		(Int)GetVolConfigDiskSeqY(cfg));
	fprintf(file,"Source seq. frame rate : %f\n",GetVolConfigDiskSeqFrameRate(cfg));
	fprintf(file,"Start frame : %d\n", (Int)GetVolConfigStartFrame(cfg));
	fprintf(file,"End frame : %d\n", (Int)GetVolConfigEndFrame(cfg));
	fprintf(file,"Start time : %f\n", (Float)GetVolConfigStartTime(cfg));
	fprintf(file,"End time : %f\n", (Float)GetVolConfigEndTime(cfg));
	if(GetVolConfigWriteCoded(cfg))
	{
		fprintf(file,"Coded VOPs will be written to disk\n");
		fprintf(file,"Coded Y seq. : %s\n",GetVolConfigCodedY(cfg));
		fprintf(file,"Coded U seq. : %s\n",GetVolConfigCodedU(cfg));
		fprintf(file,"Coded V seq. : %s\n",GetVolConfigCodedV(cfg));
		if(GetVolConfigShape(cfg) != RECTANGULAR)
			fprintf(file,"Coded A seq. : %s\n",GetVolConfigCodedA(cfg));
	}
	else
		fprintf(file,"Coded VOPs will NOT be written to disk\n");

	fprintf(file,"\n");
	fprintf(file,"Bitstream file for this layer : %s\n",
		GetVolConfigBitstream(cfg));
	fprintf(file,"Target Bitrate : %d\n", (Int)GetVolConfigBitrate(cfg));
	/* UPM: this is now printed in PrintEncodeControl: 
	if(GetVolConfigRateControl(cfg) == NO_RATE_CONTROL)
		fprintf(file,"No rate control\n");
	else if(GetVolConfigRateControl(cfg) == VM4_RATE_CONTROL)
		fprintf(file,"VM 4 rate control will be used\n");
	else if(GetVolConfigRateControl(cfg) == VM5_RATE_CONTROL)
		fprintf(file,"VM 5 rate control will be used\n");
	*/
	fprintf(file,"\n");

	fprintf(file,"\n*** Coding Configuration ***\n\n");
	if(GetVolConfigQuantType(cfg))
	  {
	  fprintf(file,"MPEG2 Quantization mode selected - \n");
	  fprintf(file,"\tinitial INTRA value : %d\n",GetVolConfigIntraQuantizer(cfg));
	  fprintf(file,"\tinitial INTER value in P-VOPs: %d\n",GetVolConfigQuantizer(cfg));
	  fprintf(file,"\tinitial INTER value in B-VOPs: %d\n",GetVolConfigBQuantizer(cfg));
	
	  if(GetVolConfigLoadIntraQuantMat(cfg)==0)
	    fprintf(file,"Default INTRA matrix used\n");
	  else if(GetVolConfigLoadIntraQuantMat(cfg)==1)
	    fprintf(file,"User defined INTRA matrix >>%s<< used\n",
		    GetVolConfigIntraQuantMatFile(cfg));
	  else
	    fprintf(file,"Predefined special INTRA matrix number %d used\n",
		    GetVolConfigLoadIntraQuantMat(cfg));

	  if(GetVolConfigLoadNonintraQuantMat(cfg)==0)
	    fprintf(file,"Default NONINTRA matrix used\n");
	  else if(GetVolConfigLoadNonintraQuantMat(cfg)==1)
	    fprintf(file,"User defined NONINTRA matrix >>%s<< used\n",
		    GetVolConfigNonintraQuantMatFile(cfg));
	  else
	    fprintf(file,"Predefined special NONINTRA matrix number %d used\n",
		    GetVolConfigLoadNonintraQuantMat(cfg));
	  }
	else
	  {
	  fprintf(file,"H.263 quantization mode selected - \n");
	  fprintf(file,"\tinitial INTRA value : %d\n",
		  GetVolConfigIntraQuantizer(cfg));
	  fprintf(file,"\tinitial INTER value in P-VOPs: %d\n",GetVolConfigQuantizer(cfg));
	  fprintf(file,"\tinitial INTER value in B-VOPs: %d\n",GetVolConfigBQuantizer(cfg));
	  }

	if(GetVolConfigShape(cfg) == GREY_SCALE)
	  {
	    fprintf(file,"Gray level alpha map quantizer : %d\n",
		    GetVolConfigGLQuant(cfg));
	    if(GetVolConfigDisableGrayQuantUpdate(cfg))
	      fprintf(file,"Gray level alpha map quantizer WILL be updated\n");
	    else
	      fprintf(file,"Gray level alpha map quantizer WILL NOT be updated\n");

	    if(GetVolConfigQuantType(cfg))
	      {
		if(GetVolConfigLoadGrayIntraQuantMat(cfg)==0)
		  fprintf(file,"Default gray INTRA matrix used\n");
		else if(GetVolConfigLoadGrayIntraQuantMat(cfg)==1)
		  fprintf(file,"User defined gray INTRA matrix >>%s<< used\n",
			  GetVolConfigGrayIntraQuantMatFile(cfg));
		else
		  fprintf(file,"Predefined special gray INTRA matrix number %d used\n",
			  GetVolConfigLoadGrayIntraQuantMat(cfg));
		
		if(GetVolConfigLoadGrayNonintraQuantMat(cfg)==0)
		  fprintf(file,"Default gray NONINTRA matrix used\n");
		else if(GetVolConfigLoadGrayNonintraQuantMat(cfg)==1)
		  fprintf(file,"User defined gray NONINTRA matrix >>%s<< used\n",
			  GetVolConfigGrayNonintraQuantMatFile(cfg));
		else
		  fprintf(file,"Predefined special gray NONINTRA matrix number %d used\n",
			  GetVolConfigLoadGrayNonintraQuantMat(cfg));
	      }
	  }
	if(GetVolConfigErrorResDisable(cfg))
		fprintf(file,"Error Resilience mode is DISABLED\n");
	else
	{
		fprintf(file,"Error Resilience mode is ENABLED\n");
	if(GetVolConfigReverseVlc(cfg))
		fprintf(file,"Reversible VLCs will be used\n");
	else
	  {
	    fprintf(file,"Regular VLCs will be used!\n");
	        /* fprintf(file,"Reversible VLCs will NOT be used\n");
	        fprintf(file,"\nNormal VLCs temporarily disabled!\n");
      	        fprintf(file,"Please use RVLCs when using the error resilient mode.\n");
		exit(1);*/
	  }

	          if (GetVolConfigDataPartEnable(cfg))
		      fprintf(file,"Data Partitioning will be used\n");
		    else
		      fprintf(file,"NO Data Partitioning will be used\n");
		  
	}
	if(GetVolConfigACDCPredDisable(cfg))
		fprintf(file,"AC/DC prediction of Intra macroblocks is DISABLED\n");
	else
		fprintf(file,"AC/DC prediction of Intra macroblocks is ENABLED\n");
	if(GetVolConfigSADCTDisable(cfg))
		fprintf(file,"SADCT coding is DISABLED\n");
	else
		fprintf(file,"SADCT coding is ENABLED\n");
		fprintf(file,"COMBINED motion/shape/texture coding will be used\n");
	fprintf(file,"search_range_per_coded_frame : %d\n", (Int)GetVolConfigSearchRange(cfg));
	fprintf(file,"alpha threshold : %d\n", (Int)GetVolConfigAlphaTh(cfg));

	fprintf(file,"\n");
	if(GetVolConfigScalability(cfg))
	{
		fprintf(file,"Scalability Type : %d\n",
			(Int)GetVolConfigScalType(cfg));	
		fprintf(file,"Reference layer Id : %d\n",
			(Int)GetVolConfigRefId(cfg));
		fprintf(file,"Reference layer sampling direction : %d\n",
			(Int)GetVolConfigRefSampDir(cfg));
		fprintf(file,"Hor. sampling factor n : %d\n",
			(Int)GetVolConfigHorSampN(cfg));
		fprintf(file,"Hor. sampling factor m : %d\n",
			(Int)GetVolConfigHorSampM(cfg));
		fprintf(file,"Ver. sampling factor n : %d\n",
			(Int)GetVolConfigVerSampN(cfg));
		fprintf(file,"Ver. sampling factor m : %d\n",
			(Int)GetVolConfigVerSampM(cfg));
		if(GetVolConfigEnhanceType(cfg))
			fprintf(file,"PARTIAL region enhancment of base layer\n");
		else
			fprintf(file,"FULL region enhancement of base layer\n");
	}

	if (GetVolConfigSpriteUsage(cfg) == SPRITE_NOT_USED)
		fprintf(file,"NO SPRITE USAGE\n"); 
	else
	if (GetVolConfigSpriteUsage(cfg) != SPRITE_NOT_USED) 
		{
		if (GetVolConfigSpriteUsage(cfg) == STATIC_SPRITE) 
				{
				fprintf(file,"OFF-LINE STATIC SPRITE ");
				if (GetVolConfigLowLatencySpriteEnable(cfg)==0)
					fprintf(file," (BASIC SPRITE)\n");
				else
					fprintf(file," (LOW LATENCY SPRITE)\n");
				}
		if (GetVolConfigSpriteUsage(cfg) == GMC_SPRITE) fprintf(file,"GMC SPRITE\n");
		if (GetVolConfigSpriteUsage(cfg) == ONLINE_SPRITE) fprintf(file,"ON-LINE SPRITE\n");
		
		fprintf(file,"Sprite horiz. size : %d\n",GetVolConfigSpriteHdim(cfg));
		fprintf(file,"Sprite vert. size : %d\n",GetVolConfigSpriteVdim(cfg));
		fprintf(file,"Sprite left edge :  %d\n",GetVolConfigSpriteLeftEdge(cfg));
		fprintf(file,"Sprite top  edge :  %d\n",GetVolConfigSpriteTopEdge(cfg));
		fprintf(file,"No of sprite points : %d\n", GetVolConfigNoOfSpritePoints(cfg));
		fprintf(file,"Warping Accuracy : %d\n", GetVolConfigWarpingAccuracy(cfg));
		fprintf(file,"Brightness_change_in_sprite : %d\n", GetVolConfigBrightnessChangeInSprite(cfg));

		if (GetVolConfigSpriteUsage(cfg) != STATIC_SPRITE)
	  		{
			if (GetVolConfigSpriteUsage(cfg) != GMC_SPRITE)
			  fprintf(file,"Sprite blending factor : %.2f\n",GetVolConfigBlendFact(cfg) / 254.0);

			if(GetVolConfigWriteSprite(cfg))
				{
				fprintf(file,"Sprite will be written to disk\n");
				fprintf(file,"Sprite Y seq. : %s\n",GetVolConfigSpriteY(cfg));
				fprintf(file,"Sprite U seq. : %s\n",GetVolConfigSpriteU(cfg));
				fprintf(file,"Sprite V seq. : %s\n",GetVolConfigSpriteV(cfg));
				fprintf(file,"Sprite A seq. : %s\n",GetVolConfigSpriteA(cfg));
				}
			else
				fprintf(file,"Sprite will NOT be written to disk\n");

			}
		if (GetVolConfigSpriteUsage(cfg) == STATIC_SPRITE)
	  		{
			fprintf(file,"Sprite will be read from disk\n");
			fprintf(file,"Sprite Y seq. : %s\n",GetVolConfigSpriteY(cfg));
			fprintf(file,"Sprite U seq. : %s\n",GetVolConfigSpriteU(cfg));
			fprintf(file,"Sprite V seq. : %s\n",GetVolConfigSpriteV(cfg));
			fprintf(file,"Sprite A seq. : %s\n",GetVolConfigSpriteA(cfg));
			if (GetVolConfigNoOfSpritePoints(cfg))
				fprintf(file,"Warping parameters file : %s\n",
					GetVolConfigWarpParamFile(cfg));
			else
				fprintf(file,"Zero global motion parameters\n");
			if (GetVolConfigLowLatencySpriteEnable(cfg))
				fprintf(file,"Sprite Threshold in SNR : %f\n",
					GetVolConfigSpriteSNRthreshold(cfg));
			}
	} /* case SPRITE_ENABLE */

	fprintf(file,"\n");


	return;
}

/***********************************************************CommentBegin******
 *
 * -- SetUpVOList -- Initialise a linked list of VOs 
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 *	Given the configuration information for a set of VOs, this function
 *	sets up and initialises a linked list of VO structures.
 * 
 * Arguments in : 	
 *	VOConfig *vo_config_list - pointer to linked list containing configuration
 *		information
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VO *vo_list - pointer to linked list of VOs.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
VO *
SetUpVOList(VOConfig *vo_config_list)
{
	VO	*vo_list = NULL,
			*vo;

	VOConfig *vo_config;

	vo_config = vo_config_list;

	while(vo_config != NULL)
	{
		vo = ConfigureVO(vo_config);

		if(vo_list == NULL)
			vo_list = vo;
		else
			AddVOToList(vo,vo_list);

		vo_config = GetVOConfigNext(vo_config);
	}

	return(vo_list);
}


/***********************************************************CommentBegin******
 *
 * -- PrintVolConfigList -- Prints the data contained in a linked list of
 *	VolConfig structures
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	This function prints the data contained in each node of a linked list
 *	of VolConfig structures. The BASE layer is printed first followed by
 *	the other layers in the order they are encountered.
 *
 * Arguments in : 	
 *	VolConfig *list - linked list 
 *	FILE *file - where to print
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
 	
Void
PrintVolConfigList(VolConfig *list,File *file)
{
	VolConfig	*curr;
	
	Int	layer = 0;

			
	fprintf(file,"Video Object Layer\n");
	fprintf(file,"==================\n\n");


	curr = list;

	while(curr != NULL)
	{
		fprintf(file,"Layer %d\n", (Int)layer);
		fprintf(file,"--------\n\n");

		if(!GetVolConfigScalability(curr))
			fprintf(file,"*** This is the BASE layer ***\n\n");
		else
			fprintf(file,"*** This is an ENHANCEMENT layer *** \n\n");

		PrintVolConfig(curr,file);

		curr = GetVolConfigNext(curr);
		layer++;
	}

	return;
}

/***********************************************************CommentBegin******
 *
 * -- PrintVOConfigList -- Prints the data contained in a linked list of
 *	VOConfig structures
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 *	This function prints the data contained in each node of a linked list
 *	of VOConfig structures. 
 *
 * Arguments in : 	
 *	VOConfig *list - linked list 
 *	File *file - where to print
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/
Void
PrintVOConfigList(VOConfig *list,File *file)
{
	VOConfig *curr;

	curr = list;

	while(curr != NULL)
	{
		fprintf(file,"********************\n");
		fprintf(file,"*                  *\n");
		fprintf(file,"*    VIDEO OBJECT  *\n");
		fprintf(file,"*                  *\n");
		fprintf(file,"********************\n\n");
		fprintf(file,"VO Id : %d\n", (Int)GetVOConfigId(curr));
		fprintf(file,"# VOLs : %d\n\n", (Int)GetVOConfigNumVOLs(curr));

		PrintVolConfigList(GetVOConfigLayers(curr),file);

		curr = GetVOConfigNext(curr);
	}

	return;
}



/***********************************************************CommentBegin******
 *
 * -- ConfigureVO -- Configures a single VO based on it's configuration 
 *	infromation
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 *	Given a VOConfig structure this functions sets up a VO structure for
 *	coding based on this config. data.
 * 
 * Arguments in : 	
 *	VOConfig *vo_config - pointer to VOConfig structure
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	VO *vo - pointer to allocated and initialised VO structure.
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	
 *
 * See also :
 *	
 *
 * Modified :		
 *
 *	
 *
 ***********************************************************CommentEnd********/

VO *
ConfigureVO(VOConfig *vo_config)
{
	VO *vo;

	Vol *vol,
			*vol_list = NULL;
	
	VolConfig *vol_config;

	vo = SallocVO();

	PutVOId(GetVOConfigId(vo_config),vo);

	vol_config = GetVOConfigLayers(vo_config);

	while(vol_config != NULL)
	{
		vol = ConfigVol(vol_config);

		if(vol_list == NULL)
			vol_list = vol;
		else
			AddVolToList(vol,vol_list);

		vol_config = GetVolConfigNext(vol_config);
	}

	PutVOLayers(vol_list,vo);

	return(vo);
}



/***********************************************************CommentBegin******
 *
 * -- ConfigVol --  Configure a Vol structure using a VolConfig
 *	structure
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	30-06-96
 *
 * Purpose :		
 * 	A VolConfig structure contains all the information for a Vol
 *	read from the encoder configuration file. This function
 *	allocates a Vol structure and initialises it with the relevant
 *	configuration information. The Vop in the Vol structure is also
 *	allocated. It is set up to have the dimensions of the the 
 *	source seq. on disk. Thus this Vol will act as an input
 *	buffer for Vops being read from disk
 *
 * Arguments in : 	
 *	VolConfig *cfg - pointer to VOlConfig structure (assumed that the
 *	config has been read already).	
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	none	
 *
 * Return values :	
 *	Vol *vol - newly allocated and filled Vol structure
 *
 * Side effects :	
 *	Memory is allocated for the Vol (n.b. and also it's associated
 *	Vop) in this function.
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *	04.02.97 Noel O'Connor: enabled error resilient mode (based on changes
 *				by Luis Ducla-Soares - 30.01.97)
 *	26.02.97 Noel O'Connor: added shape_effects * reverse_vlc
 * 23.04.97 Michael Wollborn: Added MPEG quantization stuff completely
 * 26.04.97 Luis Ducla-Soares: Added data partitioning
 *	13.05.97 Minhua Zhou : added OBMCDisable
 *      12.08.97 Minhua Zhou : added time_increment_resolution
 *
 ***********************************************************CommentEnd********/
 
Vol *
ConfigVol(VolConfig *cfg)
{
	Vol	*vol;

	Vop	*vop;

	Int	dim_x,
			dim_y;

	/* Allocate Vol structure */
	vol = SallocVol();

	/* Do syntax fields first */
	PutVolId(GetVolConfigId(cfg),vol);
	PutVolShape(GetVolConfigShape(cfg),vol);
	PutVolShapeEffects(GetVolConfigShapeEffects(cfg),vol);
  	PutVolOBMCDisable(GetVolConfigOBMCDisable(cfg),vol);  
        PutVolTimeIncrementResolution(GetVolConfigTimeIncrementResolution(cfg),vol);   
	if(GetVolConfigShape(cfg) == RECTANGULAR)
	{
		PutVolWidth(GetVolConfigDiskSeqX(cfg),vol);
		PutVolHeight(GetVolConfigDiskSeqY(cfg),vol);
	}
	PutVolQuantType(GetVolConfigQuantType(cfg),vol);

	/* Added MPEG-like quantization completely, 23-APR-1997 MW */
	if(GetVolConfigQuantType(cfg))
	  ConfigVolMPEGQuant(cfg,vol);

	PutVolDisableGrayQuantUpdate(GetVolConfigDisableGrayQuantUpdate(cfg),
				     vol);
	PutVolErrorResDisable(GetVolConfigErrorResDisable(cfg),vol); /* Error Resilience is now supported */
	PutVolDataPartEnable(GetVolConfigDataPartEnable(cfg),vol);
	PutVolReverseVlc(GetVolConfigReverseVlc(cfg),vol);
	PutVolACDCPredDisable(GetVolConfigACDCPredDisable(cfg),vol);
	PutVolQuantPrecision(GetVolConfigQuantPrecision(cfg),vol);
	PutVolBitsPerPixel(GetVolConfigBitsPerPixel(cfg),vol);
	PutVolSADCTDisable(GetVolConfigSADCTDisable(cfg),vol);
	PutVolScalability(GetVolConfigScalability(cfg),vol);
	if(GetVolScalability(vol))
	{
	   	PutVolScalType(GetVolConfigScalType(cfg),vol);
		PutVolRefId(GetVolConfigRefId(cfg),vol);
		PutVolRefSampDir(GetVolConfigRefSampDir(cfg),vol);
		PutVolHorSampN(GetVolConfigHorSampN(cfg),vol);
		PutVolHorSampM(GetVolConfigHorSampM(cfg),vol);
		PutVolVerSampN(GetVolConfigVerSampN(cfg),vol);
		PutVolVerSampM(GetVolConfigVerSampM(cfg),vol);
		PutVolEnhanceType(GetVolConfigEnhanceType(cfg),vol);
	}

	/* Now attach a vop. This is the vop into which the disk
		 frame will be read */
	dim_x = GetVolConfigDiskSeqX(cfg);
	dim_y = GetVolConfigDiskSeqY(cfg);

	PutVolSpriteUsage(GetVolConfigSpriteUsage(cfg),vol);

        if (cfg->interlaced) {
            /*
             * All of the following "unimplemented" interlaced modes make sense
             * but simply have not been coded or tested.  These should all be
             * version 2 work items.                  Bob Eifrig (7-Nov-97).
             */
            if (GetVolConfigScalability(cfg)) {
                printf("Interlaced scalability is not implemented\n");
                exit(1);
            }
            if (GetVolSpriteUsage(vol) != SPRITE_NOT_USED) {
                printf("Interlaced sprites are not defined\n");
                exit(1);
            }
             if (GetVolConfigSADCTDisable(cfg) == 0) {
                printf("Interlaced shape addaptive DCT is not implemented\n");
                exit(1);
            }
            if (GetVolConfigErrorResDisable(cfg) == 0) {
                printf("Interlaced error resilience coding is not implemented\n");
                exit(1);
            }
        } else
            cfg->alternate_scan = 0;            /* Non-zero only in interlaced mode */

	if (GetVolSpriteUsage(vol) != SPRITE_NOT_USED)
		{
		PutVolSpriteHdim(GetVolConfigSpriteHdim(cfg),vol);
		PutVolSpriteVdim(GetVolConfigSpriteVdim(cfg),vol);
		PutVolSpriteLeftEdge(GetVolConfigSpriteLeftEdge(cfg),vol);
		PutVolSpriteTopEdge(GetVolConfigSpriteTopEdge(cfg),vol);
		PutVolNoOfSpritePoints(GetVolConfigNoOfSpritePoints(cfg),vol);
		PutVolWarpingAccuracy(GetVolConfigWarpingAccuracy(cfg),vol);
		PutVolBrightnessChangeInSprite(GetVolConfigBrightnessChangeInSprite(cfg),vol);
		if (GetVolConfigNoOfSpritePoints(cfg)>0)
	        	PutVolRefPointCoord(GetVolConfigRefPointCoord(cfg),vol);
		if (GetVolSpriteUsage(vol) == STATIC_SPRITE)
			PutVolLowLatencySpriteEnable(GetVolConfigLowLatencySpriteEnable(cfg),vol);

		if (GetVolSpriteUsage(vol) == ONLINE_SPRITE)
		  PutVolBlendFact(GetVolConfigBlendFact(cfg),vol);
		  
		PutVolSprite(GetVolConfigSprite(cfg),vol);
		PutVopId(GetVolId(vol), GetVolSprite(vol));
		}
	
	vop = AllocVop(dim_x,dim_y);
	PutVopId(GetVolId(vol), vop);

	PutVolVop(vop,vol);
	PutVopBitsPerPixel(GetVolBitsPerPixel(vol),vop);
	PutVopQuantPrecision(GetVolQuantPrecision(vol),vop);

	return(vol);
}	

/***********************************************************CommentBegin******
 *
 * -- InitControlParams -- Initialise certain control parameters
 *
 * Author :		
 *	Noel O'Connor Teltec Irl.
 *
 * Created :		
 *	23-09-96
 *
 * Purpose :		
 *	This function initialises some useful control parameters based on
 *	information read form the configuration files. The parameters:
 *		- initialise the "next" frame to be read
 *		- Calculate frame skip field
 *		- Calculate vol time increment
 *		- Calculate vol start & end times
 *		- Calculate session time increment
 *		- Calculate session start & end times
 * 
 * Arguments in : 	
 *	none
 *	
 * Arguments in/out :	
 *	VOConfig *vo_cfg - linked list of VOConfig structures containing the
 *		config data read from the configuration files.
 *	EncodeControl - Pointer to EncodeControl structure containing
 *		control information read from control file.
 *
 * Arguments out :	
 *	none
 *
 * Return values :	
 *	none 
 *
 * Side effects :	
 *	none
 *
 * Description :	
 *	-
 *
 * See also :
 *	
 *
 * Modified :	
 *        10.03.97  Minhua Zhou: Added M to the calculation of END time	
 *
 *	
 *
 ***********************************************************CommentEnd********/


Void
InitControlParams(VOConfig *vo_config_list,EncodeControl *enc_ctl)
{
	VOConfig	*vo_cfg;

	VolConfig	*vol_cfg;

	Int				start_frame, M,
						end_frame,
						frame_skip;

	Float			disk_frame_rate,
						vol_frame_rate,
						start_time,
						min_start_time = MAX_FLOAT_VAL,
						max_end_time = 0,
						min_time_inc = MAX_FLOAT_VAL,
						end_time,
				                time_inc;

	vo_cfg = vo_config_list;
	while(vo_cfg != NULL)
	{
		vol_cfg = GetVOConfigLayers(vo_cfg);
		while(vol_cfg != NULL)
		{
			/* Init. "next" frame to be coded to start frame */
			start_frame = GetVolConfigStartFrame(vol_cfg);
			PutVolConfigFrame(start_frame,vol_cfg);

			/* Calculate frame skip field */
			disk_frame_rate = GetVolConfigDiskSeqFrameRate(vol_cfg);
			vol_frame_rate = GetVolConfigFrameRate(vol_cfg);
                        M     =  GetVolConfigM(vol_cfg);
			frame_skip = (Int)(disk_frame_rate/vol_frame_rate);
			PutVolConfigFrameSkip(frame_skip,vol_cfg);

			/* Calculate time increment */
			time_inc = (Float)1000/vol_frame_rate;
			PutVolConfigTimeInc(time_inc,vol_cfg);

			/* Calculate end time */
			start_time = GetVolConfigStartTime(vol_cfg);
			end_frame = GetVolConfigEndFrame(vol_cfg);
/*** modified ***/
			/* end_time = start_time + (((end_frame - start_frame)/(M*frame_skip)) * M * time_inc); */
			end_time = start_time + (((Float)(end_frame - start_frame)/(Float)(M*frame_skip)) * M * time_inc); 
/*** modified ***/
			end_time = RoundTime(end_time);
			PutVolConfigEndTime(end_time,vol_cfg);

			/* Calculate minimium time increment */
			if(time_inc < min_time_inc)
				min_time_inc = time_inc;

			/* Calculate minimum start time */
			if(start_time < min_start_time)
				min_start_time = start_time;

			/* Calculate maximum end time */
			if(end_time > max_end_time)
				max_end_time = end_time;

			/* Initialise the modulo time base to zero */
 			/* Minhua Zhou 09.05.97: two times of call
 			   to set both time bases to zero */
			vol_cfg->modulo_time_base[0] =0;
			vol_cfg->modulo_time_base[1] =0;
		

			/* Initialise next coding time to start time */
			PutVolConfigNextCodingTime(start_time,vol_cfg);

			vol_cfg = GetVolConfigNext(vol_cfg);
		}
		
		vo_cfg = GetVOConfigNext(vo_cfg);
	}

	/* Record the max and min times */
	PutEncodeControlStartTime(min_start_time,enc_ctl);
	PutEncodeControlEndTime(max_end_time,enc_ctl);
	PutEncodeControlTimeInc(min_time_inc,enc_ctl);

	return;
}

/***********************************************************CommentBegin******
 *
 * -- ConfigVolMPEGQuant --  Configure a Vol structure using a VolConfig
 *	structure, here especially the MPEG quantization stuff
 *
 * Author :		
 *	Michael Wollborn, TUH
 *
 * Created :		
 *	23-APR-1997
 *
 * Purpose :		
 *	The parts for the MPEG quantization stuff are configured in
 *	a separate module due to the length of the source code.
 *
 * Arguments in : 	
 *	VolConfig *cfg - pointer to VOlConfig structure (assumed that the
 *	config has been read already).	
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	Vol *vol - pointer to VOL to be configured	
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
 
Void
ConfigVolMPEGQuant(VolConfig *cfg, Vol *vol)
{
  Int i, type;
  Int *qmat_cfg, *qmat_vol;

  /* IntraQuantMat */
  type = GetVolConfigLoadIntraQuantMat(cfg);

  if(type == 0)		/* default flat matrix */
    {
      PutVolLoadIntraQuantMat(0,vol);
      qmat_vol = GetVolIntraQuantMat(vol);
      qmat_cfg = GetVolConfigIntraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] =qmat_vol[i] = mpeg_iqmat_def[i];
    }
  else if(type == 1)	/* user defined matrix */
    {
      PutVolLoadIntraQuantMat(1,vol);
      qmat_vol = GetVolIntraQuantMat(vol);
      qmat_cfg = GetVolConfigIntraQuantMat(cfg);
      
      LoadUserQuantMat(GetVolConfigIntraQuantMatFile(cfg),qmat_cfg);
      LoadUserQuantMat(GetVolConfigIntraQuantMatFile(cfg),qmat_vol);
    }
  else if(type < 2+NUM_MPEG_QMAT_SPEC)	/* predefined special matrix */
    {
      PutVolLoadIntraQuantMat(1,vol);
      qmat_vol = GetVolIntraQuantMat(vol);
      qmat_cfg = GetVolConfigIntraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] = qmat_vol[i] = mpeg_iqmat_spec[type-2][i];
    }
  else
    {
      printf("ERROR: wrong flag for load_intra_quant_mat: %d\n",type);
      exit(1);
    }

  /* NonintraQuantMat */
  type = GetVolConfigLoadNonintraQuantMat(cfg);

  if(type == 0)		/* default flat matrix */
    {
      PutVolLoadNonintraQuantMat(0,vol);
      qmat_vol = GetVolNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigNonintraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] =qmat_vol[i] = mpeg_nqmat_def[i];
    }
  else if(type == 1)	/* user defined matrix */
    {
      PutVolLoadNonintraQuantMat(1,vol);
      qmat_vol = GetVolNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigNonintraQuantMat(cfg);
      
      LoadUserQuantMat(GetVolConfigNonintraQuantMatFile(cfg),qmat_cfg);
      LoadUserQuantMat(GetVolConfigNonintraQuantMatFile(cfg),qmat_vol);
    }
  else if(type < 2+NUM_MPEG_QMAT_SPEC)	/* predefined special matrix */
    {
      PutVolLoadNonintraQuantMat(1,vol);
      qmat_vol = GetVolNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigNonintraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] = qmat_vol[i] = mpeg_nqmat_spec[type-2][i];
    }
  else
    {
      printf("ERROR: wrong flag for load_intra_quant_mat: %d\n",type);
      exit(1);
    }

  /* GrayIntraQuantMat */
  type = GetVolConfigLoadGrayIntraQuantMat(cfg);

  if(type == 0)		/* default flat matrix */
    {
      PutVolLoadGrayIntraQuantMat(0,vol);
      qmat_vol = GetVolGrayIntraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayIntraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] =qmat_vol[i] = mpeg_giqmat_def[i];
    }
  else if(type == 1)	/* user defined matrix */
    {
      PutVolLoadGrayIntraQuantMat(1,vol);
      qmat_vol = GetVolGrayIntraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayIntraQuantMat(cfg);
      
      LoadUserQuantMat(GetVolConfigGrayIntraQuantMatFile(cfg),qmat_cfg);
      LoadUserQuantMat(GetVolConfigGrayIntraQuantMatFile(cfg),qmat_vol);
    }
  else if(type < 2+NUM_MPEG_QMAT_SPEC)	/* predefined special matrix */
    {
      PutVolLoadGrayIntraQuantMat(1,vol);
      qmat_vol = GetVolGrayIntraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayIntraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] = qmat_vol[i] = mpeg_giqmat_spec[type-2][i];
    }
  else
    {
      printf("ERROR: wrong flag for load_intra_quant_mat: %d\n",type);
      exit(1);
    }

  /* GrayNonintraQuantMat */
  type = GetVolConfigLoadGrayNonintraQuantMat(cfg);

  if(type == 0)		/* default flat matrix */
    {
      PutVolLoadGrayNonintraQuantMat(0,vol);
      qmat_vol = GetVolGrayNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayNonintraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] =qmat_vol[i] = mpeg_gnqmat_def[i];
    }
  else if(type == 1)	/* user defined matrix */
    {
      PutVolLoadGrayNonintraQuantMat(1,vol);
      qmat_vol = GetVolGrayNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayNonintraQuantMat(cfg);
      
      LoadUserQuantMat(GetVolConfigGrayNonintraQuantMatFile(cfg),qmat_cfg);
      LoadUserQuantMat(GetVolConfigGrayNonintraQuantMatFile(cfg),qmat_vol);
    }
  else if(type < 2+NUM_MPEG_QMAT_SPEC)	/* predefined special matrix */
    {
      PutVolLoadGrayNonintraQuantMat(1,vol);
      qmat_vol = GetVolGrayNonintraQuantMat(vol);
      qmat_cfg = GetVolConfigGrayNonintraQuantMat(cfg);
      
      for(i=0; i<64; i++)
        qmat_cfg[i] = qmat_vol[i] = mpeg_gnqmat_spec[type-2][i];
    }
  else
    {
      printf("ERROR: wrong flag for load_intra_quant_mat: %d\n",type);
      exit(1);
    }

  return;
}





/***********************************************************CommentBegin******
 *
 * -- LoadUserQuantMat --  Load a user defined quantization matrix
 *
 * Author :		
 *	Michael Wollborn, TUH
 *
 * Created :		
 *	23-APR-1997
 *
 * Purpose :		
 *	A user defined quantization matrix is loaded from the disk
 *
 * Arguments in : 	
 *	Char *filename - file with the quantization matrix coefficients
 *
 * Arguments in/out :	
 *	none
 *
 * Arguments out :	
 *	Vol *vol - pointer to VOL to be configured	
 *
 * Return values :	
 *	none
 *
 * Side effects :	
 *
 * Description :	
 *	-
 *
 * See also :
 *	-
 *
 * Modified :		
 *
 ***********************************************************CommentEnd********/
 
Void
LoadUserQuantMat(Char *qmat_filename, Int *qmat)
{
  FILE	*qmat_file;

  Int i,coef;

  Char	garbage[201];

  /* Check if file is there */
  if((qmat_file = fopen(qmat_filename,"r")) == NULL)
    {
      fprintf(stderr,"ERROR(LoadUserQuantMat): unable to open %s\n",
	      qmat_filename);
      exit(1);
    }

  /* Load matrix elements, one element in each line */
  for(i=0; i<64; i++)
    {
      fscanf(qmat_file,"%d",&coef);
      fgets(garbage,201,qmat_file);
      qmat[i] = coef;
    }

  /* Close file and return */
  fclose(qmat_file);

  return;
}


/***********************************************************CommentBegin******
 *
 * -- Utilities for manipulation VTCconfig: wavelet texture layer structure
 *
 * Author :             
 *      Hung-Ju Lee  (Sarnoff Corporation)
 *
 * Created :            
 *      02-20-98
 *
 * Purpose :            
 *
 * Arguments in :       
 *
 * Arguments in/out :   
 *      none
 *
 * Arguments out :      
 *      none
 *
 * Return values :      
 *      none
 *
 * Side effects :       
 *      none
 *
 * Description :        
 *      
 *
 * See also :
 *      
 *
 * Modified :           
 *
 *      
 *
 ***********************************************************CommentEnd********/

/****************************************************************************************/
/* The following functions are added by Hung-Ju Lee (Sarnoff) for Visual Texture Coding */
/****************************************************************************************/
/* VTC Begin ------------------------------------------ */

Int
GetEncodeControlNumVTCs(EncodeControl *enc_ctl)
{
        return(enc_ctl->num_vtcs);
}

Char *
GetEncodeControlVTCCfgFile(Int id,EncodeControl *enc_ctl)
{
        return(enc_ctl->vtc_cfg_files[id]);
}

Void
PutEncodeControlNumVTCs(Int num_vtcs,EncodeControl *enc_ctl)  /* VTC */
{
        enc_ctl->num_vtcs = num_vtcs;
}

Void
PutEncodeControlVTCCfgFile(Char *string,Int id,EncodeControl *enc_ctl)  /* VTC */
{
        strcpy(enc_ctl->vtc_cfg_files[id],string);
}

VTCConfig *
SallocVTCConfig()
{
        VTCConfig *vtc_cfg;

        vtc_cfg = (VTCConfig *)malloc(sizeof(VTCConfig));
        PutVTCConfigNext(NULL,vtc_cfg);

        return(vtc_cfg);
}

Void
PutVTCConfigNext(VTCConfig *next,VTCConfig *vtc_cfg)
{
        vtc_cfg->pnext = next;
}

VTCConfig *
ReadVTCConfigFiles(EncodeControl *enc_ctl)
{
        Int                             num_vtcs,
                                                vo;

        VTCConfig       *list = NULL,
                                                *curr;

        Char                    *string;

        num_vtcs = GetEncodeControlNumVTCs(enc_ctl);

        for(vo=0; vo<num_vtcs; vo++)
        {
                string = GetEncodeControlVTCCfgFile(vo,enc_ctl);

                curr = ReadVTCConfigFileData(string);

                if(vo == 0)
                        list = curr;
                else
                        AddVTCConfigToList(curr,list);
        }

        return(list);
}

Void
AddVTCConfigToList(VTCConfig *vtc_cfg, VTCConfig *list)
{
        VTCConfig       *curr,*prev;

        prev = list;
        curr = GetVTCConfigNext(prev);

        while (curr != NULL)
        {
                prev = curr;
                curr = GetVTCConfigNext(prev);
        }
        
        PutVTCConfigNext(vtc_cfg,prev);
}

VTCConfig *
GetVTCConfigNext(VTCConfig *cfg)
{
        return(cfg->pnext);
}

Void
FreeVTCConfig(VTCConfig *vtc_config)
{
        VTCConfig       *curr, *next;

        curr = vtc_config;

        while(curr != NULL)
          {
            next = GetVTCConfigNext(curr);

            free(curr);
            curr = next;
          }
        
        return;
}

VTCConfig *
ReadVTCConfigFileData(Char *string)
{
  Char           garbage[201];
  File           *fpfile;
  VTCConfig      *curr;
  Int            spa_lev, snr_lev, col;
  Int            SNR_scalability_levels;

  if((fpfile = fopen(string,"r")) == NULL)
  {
    fprintf(stderr,"ERROR(ReadVOConfigFile): Can't open %s\n",string);
    exit(1);
  }
                
      /* Data to be read from config files */
      curr = SallocVTCConfig();  

      /* VTC id */
      fscanf(fpfile,"%d",&curr->id);
      fgets(garbage,201,fpfile);
     
      /* bitstream file name */
      fscanf(fpfile,"%s",curr->bitstream);
      fgets(garbage,201,fpfile);
            
      /* horizontal size */
      fscanf(fpfile,"%d",&curr->width);
      fgets(garbage,201,fpfile);

      /* horizontal size */
      fscanf(fpfile,"%d",&curr->height);
      fgets(garbage,201,fpfile);

      /* Type of alpha channel */
      fscanf(fpfile,"%d",&curr->sa_dwt);
      fgets(garbage,201,fpfile);

      /* alphaTH */
      fscanf(fpfile,"%d",&curr->alphaTH);
      fgets(garbage,201,fpfile);

      /* change_CR_disable */
      fscanf(fpfile,"%d",&curr->change_CR_disable);
      fgets(garbage,201,fpfile);

      /* Source VTC file names */
      fscanf(fpfile,"%s",curr->image_file);
      fgets(garbage,201,fpfile);
            
      fscanf(fpfile,"%s",curr->shape_file);
      fgets(garbage,201,fpfile);
      
      /* Coded VTC file names */
      fscanf(fpfile,"%s",curr->rec_file);
      fgets(garbage,201,fpfile);
            
      /* read filter type */
      fscanf(fpfile,"%d",&curr->wvtType);
      fgets(garbage,201,fpfile);
  
      /* read wavelet decomposition levels */
      fscanf(fpfile,"%d",&curr->wvtDecompLev);
      fgets(garbage,201,fpfile);
  
      /* read quantization type: 0-Single Q 1- Multiple Q  2- Bi-level Q */
      fscanf(fpfile,"%d",&curr->quantization_type);
      fgets(garbage,201,fpfile);
  
      /* read  SNR length enable*/
      fscanf(fpfile,"%d",&curr->SNR_start_code_enable);
      fgets(garbage,201,fpfile);
  
  
      fscanf(fpfile,"%d",&curr->target_bitrate);
      fgets(garbage,201,fpfile);
      
      fscanf(fpfile,"%d",&curr->target_spatial_levels);
      fgets(garbage,201,fpfile);
      
      fscanf(fpfile,"%d",&curr->target_snr_levels);
      fgets(garbage,201,fpfile);
      
      /* Read in deringing parameters. If either is zero deringing is disabled */
      fscanf(fpfile,"%d %d",
             &curr->deringWindowSize,&curr->deringThreshold);
      fgets(garbage,201,fpfile);
    
      /* Read in DC Lum Quant */
      fscanf(fpfile,"%d",&curr->QdcY);
      fgets(garbage,201,fpfile);

      fscanf(fpfile,"%d",&curr->QdcUV);
      fgets(garbage,201,fpfile);


      /* only support 4:2:0 color format 8-bits per pixel */
      curr->colors    = 3;
      curr->bit_depth = 8;

      fscanf(fpfile,"%d",&curr->spatial_scalability_levels);
      fgets(garbage,201,fpfile);
      for (col=0; col<curr->colors; col++) {
        if ((curr->SPlayer[col] = (SNR_PARAM *)malloc(sizeof(SNR_PARAM)*
                                  curr->spatial_scalability_levels )) == NULL)
          fprintf(stderr,"error allocating memory \n");
      }

      for (spa_lev=0; spa_lev<curr->spatial_scalability_levels; spa_lev++) {
        fscanf(fpfile,"%d",&SNR_scalability_levels);

        for (col=0; col<curr->colors; col++) {
          curr->SPlayer[col][spa_lev].SNR_scalability_levels = SNR_scalability_levels;
          if ((curr->SPlayer[col][spa_lev].Quant = 
               (int *)malloc(sizeof(int)*SNR_scalability_levels))==NULL)
            fprintf(stderr,"error allocating memory \n");
        }
        
        for (snr_lev=0; snr_lev<SNR_scalability_levels; snr_lev++) {
          fscanf(fpfile,"%d",&curr->SPlayer[0][spa_lev].Quant[snr_lev]);
          fscanf(fpfile,"%d",&curr->SPlayer[1][spa_lev].Quant[snr_lev]);
          curr->SPlayer[2][spa_lev].Quant[snr_lev] =
            curr->SPlayer[1][spa_lev].Quant[snr_lev];
        }
        
        fgets(garbage,201,fpfile);
      }


      /* check parms */
      if (curr->spatial_scalability_levels >= curr->wvtDecompLev)
        {
          fprintf(stderr, "\n\n Parameter Error: \n");
          exit(-1);
        }      

   fclose(fpfile);

  return curr;
}

/* VTC End ------------------------------------------ */


