/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.ComboBoxIndexListener;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.CutPanel;
import net.sourceforge.dvb.projectx.gui.CutView;
import net.sourceforge.dvb.projectx.gui.X_JFileChooser;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Preview;
import net.sourceforge.dvb.projectx.video.PreviewObject;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class CutPanel
extends JPanel {
    private int active_collection = 0;
    private int loadSizeForward = 2560000;
    private long lastPosition = 0L;
    private long divisor = 16L;
    private boolean matchingPoint = false;
    private boolean cut_top = true;
    private boolean cut_bottom = false;
    private boolean cut_match = false;
    private boolean action = false;
    private String file = " ";
    private String[] navigation = new String[]{"leftsteparrow1x.gif", "leftarrow3x.gif", "leftarrow2x.gif", "rightarrow2x.gif", "rightarrow3x.gif", "rightsteparrow1x.gif", "leftarrowstep1x.gif", "rightarrowstep1x.gif"};
    private JComboBox cutIndexList;
    private JComboBox chapterIndexList;
    private JComboBox cutmode_combobox;
    private JTextField includeField;
    private JTextField positionField;
    private JTextField estimatedSizeField;
    private JTextField chapterCountField;
    private JTextField chapterIndexField;
    private JTextField cutCountField;
    private JTextField cutIndexField;
    private JButton cutAdd;
    private JButton cutDelete;
    private JButton chapterAdd;
    private JButton chapterDelete;
    private JButton[] jump;
    private JSlider slider;
    private X_JFileChooser chooser;
    private DNDListener2 dnd2 = new DNDListener2();
    private JumpListener jumpAction = new JumpListener();
    private CutListener cutAction = new CutListener();
    private JobCollection collection;
    private CutView cutview;
    private Preview Preview = new Preview(this.loadSizeForward);
    private List previewList = new ArrayList();
    private ComboBoxIndexListener _ComboBoxIndexListener = new ComboBoxIndexListener();
    private SlideShow cl = new SlideShow();
    private CutMatrix cm = new CutMatrix();
    private boolean slideshow = false;
    private JPanel sliderPanel;

    public CutPanel() {
        this.chooser = CommonGui.getMainFileChooser();
        this.sliderPanel = this.buildSliderPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.buildPointPanel());
        jPanel.add(this.buildNavigationPanel());
        this.cutview = new CutView();
        jPanel.add(this.cutview);
        this.cutview.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                try {
                    if (mouseEvent.getX() < CutPanel.this.cutview.getBottom() - 20 && mouseEvent.getY() < 104) {
                        if (CutPanel.this.cutview.getTopIndex() != null) {
                            CutPanel.this.preview(Long.parseLong(CutPanel.this.cutview.getTopIndex().toString()));
                        }
                    } else if (mouseEvent.getX() > CutPanel.this.cutview.getBottom() && mouseEvent.getY() < 104 && CutPanel.this.cutview.getBottomIndex() != null) {
                        CutPanel.this.preview(Long.parseLong(CutPanel.this.cutview.getBottomIndex().toString()));
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.cutview.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (mouseEvent.getY() > 104) {
                    CutPanel.this.cutview.setSlider(mouseEvent.getX());
                    if (CutPanel.this.collection == null) {
                        return;
                    }
                    CommonGui.getPicturePanel().setMixedPreviewPixel(CutPanel.this.collection.getCutImage(CutPanel.this.cutview.getPreviewPosition()), CutPanel.this.cutview.getTransparencyValue());
                    CommonGui.getPicturePanel().repaint();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.add(jPanel);
        this.setVisible(true);
    }

    private boolean addChapterpoint(String string) {
        int n = 0;
        n = this.getCutIndex(this.collection.getChapterpoints(), string);
        if (n >= 0) {
            return false;
        }
        this.collection.addChapterpoint(-n - 1, string);
        this.reloadChapterpoints();
        this.chapterIndexList.setSelectedItem(string);
        return true;
    }

    private boolean addCutpoint(String string) {
        int n = 0;
        n = this.getCutIndex(this.collection.getCutpoints(), string);
        if (n >= 0) {
            return false;
        }
        this.collection.addCutpoint(-n - 1, string);
        this.reloadCutpoints();
        this.cutIndexList.setSelectedItem(string);
        return true;
    }

    protected JPanel buildChapterPointPanel() {
        this.chapterIndexField = new JTextField();
        this.chapterIndexField.setBackground(new Color(230, 230, 230));
        this.chapterIndexField.setPreferredSize(new Dimension(48, 24));
        this.chapterIndexField.setMaximumSize(new Dimension(48, 24));
        this.chapterIndexField.setEditable(false);
        this.chapterIndexField.setHorizontalAlignment(0);
        JButton jButton = new JButton(CommonGui.loadIcon("leftchap.gif"));
        jButton.setActionCommand("movechapterleft");
        jButton.setPreferredSize(new Dimension(36, 24));
        jButton.setMaximumSize(new Dimension(36, 24));
        jButton.addActionListener(this.cutAction);
        JButton jButton2 = new JButton(CommonGui.loadIcon("rightchap.gif"));
        jButton2.setActionCommand("movechapterright");
        jButton2.setPreferredSize(new Dimension(36, 24));
        jButton2.setMaximumSize(new Dimension(36, 24));
        jButton2.addActionListener(this.cutAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.chapterIndexField);
        this.chapterAdd = new JButton(CommonGui.loadIcon("addchap.gif"));
        this.chapterAdd.setActionCommand("addchapter");
        this.chapterAdd.setPreferredSize(new Dimension(36, 24));
        this.chapterAdd.setMaximumSize(new Dimension(36, 24));
        this.chapterAdd.addActionListener(this.cutAction);
        this.chapterDelete = new JButton(CommonGui.loadIcon("remchap.gif"));
        this.chapterDelete.setActionCommand("delchapter");
        this.chapterDelete.setPreferredSize(new Dimension(36, 24));
        this.chapterDelete.setMaximumSize(new Dimension(36, 24));
        this.chapterDelete.addActionListener(this.cutAction);
        this.chapterCountField = new JTextField();
        this.chapterCountField.setToolTipText(Resource.getString("CollectionPanel.NumberOfChapters.Tip"));
        this.chapterCountField.setBackground(new Color(230, 230, 230));
        this.chapterCountField.setPreferredSize(new Dimension(48, 24));
        this.chapterCountField.setMaximumSize(new Dimension(48, 24));
        this.chapterCountField.setEditable(false);
        this.chapterCountField.setHorizontalAlignment(0);
        this.chapterCountField.addActionListener(this.cutAction);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.chapterAdd);
        jPanel2.add(this.chapterDelete);
        jPanel2.add(this.chapterCountField);
        this.chapterIndexList = new JComboBox();
        this.chapterIndexList.setMaximumRowCount(5);
        this.chapterIndexList.setPreferredSize(new Dimension(120, 24));
        this.chapterIndexList.setMaximumSize(new Dimension(120, 24));
        this.chapterIndexList.setActionCommand("chapterbox");
        this.chapterIndexList.addActionListener(this.cutAction);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.chapterIndexList);
        JButton jButton3 = new JButton(CommonGui.loadIcon("open.gif"));
        jButton3.setPreferredSize(new Dimension(32, 24));
        jButton3.setMaximumSize(new Dimension(32, 24));
        jButton3.setToolTipText(Resource.getString("CollectionPanel.loadCutpointList.Tip"));
        jButton3.setActionCommand("load_chapterlist");
        jButton3.addActionListener(this.jumpAction);
        JButton jButton4 = new JButton(CommonGui.loadIcon("save.gif"));
        jButton4.setPreferredSize(new Dimension(32, 24));
        jButton4.setMaximumSize(new Dimension(32, 24));
        jButton4.setActionCommand("save_chapterlist");
        jButton4.addActionListener(this.jumpAction);
        JButton jButton5 = new JButton(CommonGui.loadIcon("scan2.gif"));
        jButton5.setPreferredSize(new Dimension(50, 24));
        jButton5.setMaximumSize(new Dimension(50, 24));
        jButton5.setActionCommand("chapter_scan");
        jButton5.addActionListener(this.jumpAction);
        jButton5.setEnabled(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        jPanel4.add(Box.createRigidArea(new Dimension(6, 1)));
        jPanel4.add(jButton5);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new ColumnLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("CollectionPanel.NumberOfChapters")));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        Color color = new Color(210, 217, 255);
        this.setComponentColor(jPanel5, color);
        this.setComponentColor(jPanel4, color);
        return jPanel5;
    }

    protected JPanel buildCutPointPanel() {
        this.cutIndexField = new JTextField();
        this.cutIndexField.setBackground(new Color(230, 230, 230));
        this.cutIndexField.setPreferredSize(new Dimension(48, 24));
        this.cutIndexField.setMaximumSize(new Dimension(48, 24));
        this.cutIndexField.setEditable(false);
        this.cutIndexField.setHorizontalAlignment(0);
        JButton jButton = new JButton(CommonGui.loadIcon("leftcut.gif"));
        jButton.setActionCommand("movecutleft");
        jButton.setPreferredSize(new Dimension(36, 24));
        jButton.setMaximumSize(new Dimension(36, 24));
        jButton.addActionListener(this.cutAction);
        JButton jButton2 = new JButton(CommonGui.loadIcon("rightcut.gif"));
        jButton2.setActionCommand("movecutright");
        jButton2.setPreferredSize(new Dimension(36, 24));
        jButton2.setMaximumSize(new Dimension(36, 24));
        jButton2.addActionListener(this.cutAction);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.cutIndexField);
        this.cutAdd = new JButton(CommonGui.loadIcon("addcut.gif"));
        this.cutAdd.setActionCommand("addpoint");
        this.cutAdd.setPreferredSize(new Dimension(36, 24));
        this.cutAdd.setMaximumSize(new Dimension(36, 24));
        this.cutAdd.addActionListener(this.cutAction);
        DropTarget dropTarget = new DropTarget(this.cutAdd, this.dnd2);
        this.cutDelete = new JButton(CommonGui.loadIcon("remcut.gif"));
        this.cutDelete.setActionCommand("delpoint");
        this.cutDelete.setPreferredSize(new Dimension(36, 24));
        this.cutDelete.setMaximumSize(new Dimension(36, 24));
        this.cutDelete.addActionListener(this.cutAction);
        this.cutCountField = new JTextField();
        this.cutCountField.setToolTipText(Resource.getString("CollectionPanel.NumberOfPoints.Tip"));
        this.cutCountField.setBackground(new Color(230, 230, 230));
        this.cutCountField.setPreferredSize(new Dimension(48, 24));
        this.cutCountField.setMaximumSize(new Dimension(48, 24));
        this.cutCountField.setHorizontalAlignment(0);
        this.cutCountField.setEditable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cutAdd);
        jPanel2.add(this.cutDelete);
        jPanel2.add(this.cutCountField);
        this.cutIndexList = new JComboBox();
        this.cutIndexList.setMaximumRowCount(5);
        this.cutIndexList.setPreferredSize(new Dimension(120, 24));
        this.cutIndexList.setMaximumSize(new Dimension(120, 24));
        this.cutIndexList.setActionCommand("cutbox");
        this.cutIndexList.addActionListener(this.cutAction);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.cutIndexList);
        JButton jButton3 = new JButton(CommonGui.loadIcon("open.gif"));
        jButton3.setPreferredSize(new Dimension(32, 24));
        jButton3.setMaximumSize(new Dimension(32, 24));
        jButton3.setToolTipText(Resource.getString("CollectionPanel.loadCutpointList.Tip"));
        jButton3.setActionCommand("load_cutlist");
        jButton3.addActionListener(this.jumpAction);
        JButton jButton4 = new JButton(CommonGui.loadIcon("save.gif"));
        jButton4.setPreferredSize(new Dimension(32, 24));
        jButton4.setMaximumSize(new Dimension(32, 24));
        jButton4.setActionCommand("save_cutlist");
        jButton4.addActionListener(this.jumpAction);
        JButton jButton5 = new JButton(CommonGui.loadIcon("matrix.gif"));
        jButton5.setPreferredSize(new Dimension(50, 24));
        jButton5.setMaximumSize(new Dimension(50, 24));
        jButton5.setActionCommand("cut_scan");
        jButton5.addActionListener(this.jumpAction);
        jButton5.setEnabled(true);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jButton3);
        jPanel4.add(jButton4);
        jPanel4.add(Box.createRigidArea(new Dimension(6, 1)));
        jPanel4.add(jButton5);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new ColumnLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resource.getString("CollectionPanel.NumberOfPoints")));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        Color color = new Color(212, 175, 212);
        this.setComponentColor(jPanel5, color);
        this.setComponentColor(jPanel4, color);
        return jPanel5;
    }

    protected JPanel buildNavigationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.jump = new JButton[this.navigation.length];
        int n = 0;
        while (n < this.jump.length) {
            this.jump[n] = new JButton(CommonGui.loadIcon(this.navigation[n]));
            this.jump[n].setPreferredSize(new Dimension(34, 24));
            this.jump[n].setMaximumSize(new Dimension(34, 24));
            this.jump[n].setActionCommand(this.navigation[n]);
            this.jump[n].addActionListener(this.jumpAction);
            if (n < 6) {
                jPanel.add(this.jump[n]);
            } else {
                jPanel2.add(this.jump[n]);
            }
            ++n;
        }
        this.positionField = new JTextField("");
        this.positionField.setPreferredSize(new Dimension(136, 24));
        this.positionField.setMaximumSize(new Dimension(136, 24));
        this.positionField.setToolTipText(Resource.getString("CollectionPanel.CutPanel.Tip4"));
        this.positionField.setActionCommand("cutnumber");
        this.positionField.addActionListener(this.cutAction);
        jPanel2.add(this.positionField);
        this.cutmode_combobox = new JComboBox<Object>(Keys.ITEMS_CutMode);
        this.cutmode_combobox.setPreferredSize(new Dimension(204, 24));
        this.cutmode_combobox.setMaximumSize(new Dimension(204, 24));
        this.cutmode_combobox.setActionCommand(Keys.KEY_CutMode[0]);
        this.cutmode_combobox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_CutMode));
        this.cutmode_combobox.addActionListener(this._ComboBoxIndexListener);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.estimatedSizeField = new JTextField("");
        this.estimatedSizeField.setBackground(new Color(230, 230, 230));
        this.estimatedSizeField.setEditable(false);
        this.estimatedSizeField.setPreferredSize(new Dimension(150, 24));
        this.estimatedSizeField.setMaximumSize(new Dimension(150, 24));
        this.estimatedSizeField.setMinimumSize(new Dimension(150, 24));
        jPanel3.add(this.estimatedSizeField);
        JButton jButton = new JButton(CommonGui.loadIcon("slidestart.gif"));
        jButton.setToolTipText("start SlideShow");
        jButton.setPreferredSize(new Dimension(27, 24));
        jButton.setMaximumSize(new Dimension(27, 24));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CutPanel.this.slideshow || CutPanel.this.previewList.isEmpty() || Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
                    CutPanel.this.slideshow = false;
                    return;
                }
                CutPanel.this.slideshow = true;
                CutPanel.this.cl.start(CutPanel.this.lastPosition);
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(CommonGui.loadIcon("slidestop.gif"));
        jButton2.setToolTipText("stop SlideShow");
        jButton2.setPreferredSize(new Dimension(27, 24));
        jButton2.setMaximumSize(new Dimension(27, 24));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CutPanel.this.slideshow = false;
            }
        });
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Navigation"));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        jPanel4.add(this.cutmode_combobox);
        return jPanel4;
    }

    protected JPanel buildPointPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.buildChapterPointPanel());
        jPanel.add(this.buildCutPointPanel());
        return jPanel;
    }

    protected JPanel buildSliderPanel() {
        this.slider = new JSlider(0, (int)(10240000L / this.divisor), 0);
        this.slider.setPreferredSize(new Dimension(860, 30));
        this.slider.setMaximumSize(new Dimension(860, 30));
        this.slider.setMaximum(1);
        this.slider.setMajorTickSpacing(1);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintTicks(true);
        this.slider.setValue(0);
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (CutPanel.this.slideshow || CutPanel.this.previewList.isEmpty() || Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
                    CutPanel.this.slideshow = false;
                    return;
                }
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                CutPanel.this.slideshow = true;
                CutPanel.this.cl.start(CutPanel.this.lastPosition);
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (CutPanel.this.collection == null) {
                    return;
                }
                if (!CutPanel.this.action) {
                    return;
                }
                if (CutPanel.this.slider.getValueIsAdjusting() && !Common.getSettings().getBooleanProperty(Keys.KEY_Preview_LiveUpdate)) {
                    return;
                }
                long l = (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 ? CutPanel.this.divisor : 1L) * (long)CutPanel.this.slider.getValue();
                if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && l != (CutPanel.this.lastPosition & 0xFFFFFFFFFFFFFFF0L)) {
                    CutPanel.this.preview(l);
                } else if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
                    Common.getMpvDecoderClass().resetProcessedPosition();
                    Common.getMpvDecoderClass().setPidAndFileInfo(Resource.getString("CollectionPanel.Preview.offline"));
                }
                CutPanel.this.getType();
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (CutPanel.this.collection == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = keyEvent.getKeyCode();
                switch (keyEvent.getKeyChar()) {
                    case 'p': {
                        n2 = CutPanel.this.cutIndexList.getItemCount();
                        if (n2 > 0) {
                            n = n2 - 1;
                            if (CutPanel.this.lastPosition > Long.parseLong(CutPanel.this.cutIndexList.getItemAt(0).toString())) {
                                while (CutPanel.this.lastPosition <= Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n).toString())) {
                                    --n;
                                }
                            }
                            CutPanel.this.cutIndexList.setSelectedIndex(n);
                        }
                        return;
                    }
                    case 'n': {
                        n2 = CutPanel.this.cutIndexList.getItemCount();
                        if (n2 > 0) {
                            if (CutPanel.this.lastPosition < Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n2 - 1).toString())) {
                                while (CutPanel.this.lastPosition >= Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n).toString())) {
                                    ++n;
                                }
                            }
                            CutPanel.this.cutIndexList.setSelectedIndex(n);
                        }
                        return;
                    }
                    case 'a': {
                        CutPanel.this.cutAdd.doClick();
                        return;
                    }
                    case 'd': {
                        CutPanel.this.cutDelete.doClick();
                        return;
                    }
                }
                if (keyEvent.isShiftDown()) {
                    n3 = 62500;
                } else if (keyEvent.isControlDown()) {
                    n3 = 312500;
                } else if (keyEvent.isAltDown()) {
                    n3 = 3125000;
                } else {
                    return;
                }
                switch (n4) {
                    case 39: {
                        CutPanel.this.slider.setValue(CutPanel.this.slider.getValue() + n3);
                        break;
                    }
                    case 37: {
                        CutPanel.this.slider.setValue(CutPanel.this.slider.getValue() - n3);
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        if (!Common.getSettings().getBooleanProperty(Keys.KEY_Preview_SliderWidth)) {
            jPanel.add(Box.createRigidArea(new Dimension(145, 20)), "West");
            jPanel.add((Component)this.slider, "Center");
            jPanel.add(Box.createRigidArea(new Dimension(194, 20)), "East");
        } else {
            jPanel.add((Component)this.slider, "Center");
        }
        return jPanel;
    }

    private boolean checkActiveCollection() {
        if (this.active_collection >= 0) {
            return true;
        }
        this.collection = null;
        this.action = false;
        this.previewList.clear();
        this.reloadCutpoints();
        this.reloadChapterpoints();
        this.showCutInfo(true, null, this.previewList);
        Common.getGuiInterface().showChapterIcon(null, this.previewList);
        this.slider.setMaximum(1);
        Common.setOSDMessage(Resource.getString("CollectionPanel.Preview.offline"));
        this.action = true;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void entry(int var1_1) {
        if (this.active_collection != var1_1) {
            this.cutview.clearViews();
        }
        this.active_collection = var1_1;
        Common.getMpvDecoderClass().clearPreviewPixel();
        Common.getMpvDecoderClass().resetProcessedPosition();
        Common.getMpvDecoderClass().setPidAndFileInfo(Resource.getString("CollectionPanel.Preview.offline"));
        if (!this.checkActiveCollection()) {
            return;
        }
        CommonGui.getPicturePanel().showCollectionNumber(this.active_collection);
        this.cutmode_combobox.setSelectedIndex(Common.getSettings().getIntProperty(Keys.KEY_CutMode));
        this.collection = Common.getCollection(this.active_collection);
        var2_2 = this.collection.getInputFilesAsList();
        this.previewList.clear();
        this.file = var2_2.isEmpty() == false ? var2_2.get(0).toString() : "";
        var3_3 = 0L;
        var5_4 = 0L;
        var9_5 = var2_2.size();
        var10_6 = 1;
        if (Common.getSettings().getBooleanProperty(Keys.KEY_Preview_disable)) {
            var9_5 = 0;
        }
        var11_7 = 0;
        var12_8 = -1;
        var13_9 = -1;
        block3: while (var11_7 < var9_5) {
            var14_10 = ((XInputFile)var2_2.get(var11_7)).getNewInstance();
            if (var14_10 == null) ** GOTO lbl39
            if (var14_10.getStreamInfo() == null) {
                Common.getScanClass().getStreamInfo(var14_10);
            }
            var13_9 = var14_10.getStreamInfo().getStreamType();
            if (var12_8 != -1 && var12_8 != var13_9) {
                var10_6 = var11_7;
                break;
            }
            switch (var13_9) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    var12_8 = var13_9;
                    var3_3 = var5_4;
                    this.previewList.add(new PreviewObject(var3_3, var5_4 += var14_10.length(), var13_9, var14_10));
lbl39:
                    // 2 sources

                    ++var11_7;
                    continue block3;
                }
            }
        }
        this.action = false;
        this.divisor = 16L;
        while ((var7_11 = var5_4 / this.divisor) >= 0x7FFFFFFFL) {
            this.divisor += 16L;
        }
        if (var7_11 > this.divisor) {
            this.slider.setMaximum((int)var7_11);
            this.slider.setMajorTickSpacing((int)(var7_11 / 10L));
            this.slider.setMinorTickSpacing((int)(var7_11 / 100L));
            this.slider.setPaintTicks(true);
        } else {
            this.slider.setMaximum(1);
            this.slider.setMajorTickSpacing(1);
            this.slider.setMinorTickSpacing(1);
            this.slider.setPaintTicks(true);
        }
        this.action = true;
        Common.setLastPreviewBitrate(37500);
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && !this.previewList.isEmpty()) {
            this.preview(0L);
        } else {
            Common.getMpvDecoderClass().clearPreviewPixel();
            Common.setOSDMessage(Resource.getString("CollectionPanel.Preview.offline"));
        }
        this.action = false;
        this.reloadCutpoints();
        this.reloadChapterpoints();
        this.cutIndexList.setSelectedIndex(this.cutIndexList.getItemCount() - 1);
        this.getExpectedSize();
        this.getType();
        this.action = true;
    }

    private int getCutIndex(Object[] objectArray, String string) {
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 && CommonParsing.parseCutValue(string, false) < 0L) {
            return 0;
        }
        class MyComparator
        implements Comparator {
            MyComparator() {
            }

            public int compare(Object object, Object object2) {
                if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 4) {
                    return Long.toString(CommonParsing.parseCutValue(object.toString(), false)).compareTo(Long.toString(CommonParsing.parseCutValue(object2.toString(), false)));
                }
                return Long.valueOf(object.toString()).compareTo(Long.valueOf(object2.toString()));
            }
        }
        return Arrays.binarySearch(objectArray, string, new MyComparator());
    }

    private void getExpectedSize() {
        if (this.previewList.isEmpty()) {
            this.estimatedSizeField.setText(" ");
            return;
        }
        Object[] objectArray = this.collection.getCutpoints();
        long[] lArray = new long[objectArray.length];
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
            int n = 0;
            while (n < lArray.length) {
                lArray[n] = Long.parseLong(objectArray[n].toString());
                ++n;
            }
            l3 = lArray.length == 0 || (lArray.length & 1) == 1 ? ((PreviewObject)this.previewList.get(this.previewList.size() - 1)).getEnd() : lArray[lArray.length - 1];
            int n2 = 0;
            while (n2 < lArray.length) {
                l2 += lArray[n2] - l;
                l = n2 + 1 < lArray.length ? lArray[n2 + 1] : l;
                n2 += 2;
            }
        }
        String string = Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0 ? String.valueOf(Resource.getString("CollectionPanel.expectedSize")) + " " + (l3 - l2) / 0x100000L + "MB" : "";
        this.estimatedSizeField.setText(string);
        this.chapterCountField.setText(String.valueOf(this.chapterIndexList.getItemCount()));
        this.cutCountField.setText(String.valueOf(this.cutIndexList.getItemCount()));
    }

    private int getLoadSize() {
        try {
            int n = Common.getPreviewBufferValue();
            return n;
        }
        catch (Exception exception) {
            Common.setMessage("!> wrong preview_buffer field entry", true);
            return this.loadSizeForward;
        }
    }

    public JPanel getSliderPanel() {
        return this.sliderPanel;
    }

    private void getType() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.collection != null ? this.collection.getCutpoints() : new Object[]{};
        if (objectArray.length > 0) {
            int n = this.getCutIndex(objectArray, String.valueOf(this.lastPosition));
            this.showCutInfo((n & 1) == 0, objectArray, this.previewList);
        } else {
            this.showCutInfo(true, null, this.previewList);
        }
        Object[] objectArray3 = objectArray = this.collection != null ? this.collection.getChapterpoints() : new Object[]{};
        if (objectArray.length > 0) {
            Common.getGuiInterface().showChapterIcon(objectArray, this.previewList);
        } else {
            Common.getGuiInterface().showChapterIcon(null, this.previewList);
        }
    }

    private void loadChapterList() {
        this.loadChapterList("");
    }

    private void loadChapterList(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        if (!new File(string).exists()) {
            this.chooser.rescanCurrentDirectory();
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                object = this.chooser.getSelectedFile();
                if (object != null && !((File)object).isDirectory()) {
                    string = ((File)object).getAbsolutePath();
                }
            } else {
                return;
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                if (string2.startsWith(Keys.KEY_CutMode[0])) {
                    this.cutmode_combobox.setSelectedIndex(Integer.parseInt(string2.substring(string2.indexOf("=") + 1).trim()));
                    continue;
                }
                if (string2.startsWith("(")) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Common.setMessage(String.valueOf(Resource.getString("CollectionPanel.loadCutpointList.Error")) + " " + this.file);
        }
        Object[] objectArray = arrayList.toArray();
        if (objectArray.length > 0) {
            object = new long[objectArray.length];
            int n = 0;
            while (n < ((Object)object).length) {
                object[n] = CommonParsing.parseCutValue(objectArray[n].toString(), false);
                ++n;
            }
            Arrays.sort((long[])object);
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                this.collection.addChapterpoint(CommonParsing.parseCutValue((long)object[n2]));
                ++n2;
            }
            this.action = false;
            this.reloadChapterpoints();
            this.chapterIndexList.setSelectedIndex(this.chapterIndexList.getItemCount() - 1);
        }
        this.getExpectedSize();
        this.getType();
        this.action = true;
    }

    private void loadCutList() {
        this.loadCutList("");
    }

    private void loadCutList(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        if (!new File(string).exists()) {
            this.chooser.rescanCurrentDirectory();
            int n = this.chooser.showOpenDialog(this);
            if (n == 0) {
                object = this.chooser.getSelectedFile();
                if (object != null && !((File)object).isDirectory()) {
                    string = ((File)object).getAbsolutePath();
                }
            } else {
                return;
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                if (string2.startsWith(Keys.KEY_CutMode[0])) {
                    this.cutmode_combobox.setSelectedIndex(Integer.parseInt(string2.substring(string2.indexOf("=") + 1).trim()));
                    continue;
                }
                if (string2.startsWith("(")) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Common.setMessage(String.valueOf(Resource.getString("CollectionPanel.loadCutpointList.Error")) + " " + this.file);
        }
        Object[] objectArray = arrayList.toArray();
        if (objectArray.length > 0) {
            object = new long[objectArray.length];
            int n = 0;
            while (n < ((Object)object).length) {
                object[n] = CommonParsing.parseCutValue(objectArray[n].toString(), false);
                ++n;
            }
            Arrays.sort((long[])object);
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                this.collection.addCutpoint(CommonParsing.parseCutValue((long)object[n2]));
                ++n2;
            }
            this.action = false;
            this.reloadCutpoints();
            this.cutIndexList.setSelectedIndex(this.cutIndexList.getItemCount() - 1);
        }
        this.getExpectedSize();
        this.getType();
        this.action = true;
    }

    public long preview(long l) {
        boolean bl = false;
        try {
            CommonGui.getPicturePanel().disableMatrix();
            if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0 || this.previewList.isEmpty()) {
                Common.getMpvDecoderClass().resetProcessedPosition();
                Common.getMpvDecoderClass().setPidAndFileInfo(Resource.getString("CollectionPanel.Preview.offline"));
                return this.lastPosition;
            }
            this.action = false;
            int n = this.getLoadSize();
            if (l / this.divisor >= (long)this.slider.getMaximum()) {
                l = l > (long)n ? l - (long)n : 0L;
                bl = true;
            } else if (l > 0L && l < this.lastPosition && this.lastPosition / this.divisor - l / this.divisor < 3L) {
                if (this.lastPosition - l < 50L) {
                    l = this.lastPosition;
                }
                l = l > (long)n ? l - (long)n : 0L;
                bl = true;
            }
            l = this.Preview.load(l, bl && l == 0L ? (int)this.lastPosition : n, this.previewList, bl, Common.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops), Common.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode), Common.getSettings().getIntProperty(Keys.KEY_Preview_YGain), this.collection.getPIDs(), this.active_collection);
            String string = this.Preview.getProcessedFile();
            if (string.length() > 32) {
                int n2 = string.indexOf(45);
                String string2 = string.substring(0, n2 + 2);
                string = String.valueOf(string2) + "..." + string.substring(n2 + 2 + (string.length() - 34 - n2), string.length());
            }
            this.lastPosition = l;
            this.slider.setValue((int)(this.lastPosition / this.divisor));
            this.setPositionField(this.lastPosition);
            this.slider.requestFocus();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        this.getExpectedSize();
        this.updateCutView(String.valueOf(this.lastPosition));
        this.action = true;
        return this.lastPosition;
    }

    private long previewMatrix(long l, int n) {
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0 || this.previewList.isEmpty()) {
            return l;
        }
        this.action = false;
        l = this.Preview.silentload(l, this.getLoadSize(), this.previewList, false, Common.getSettings().getBooleanProperty(Keys.KEY_Preview_AllGops), Common.getSettings().getBooleanProperty(Keys.KEY_Preview_fastDecode), Common.getSettings().getIntProperty(Keys.KEY_Preview_YGain), this.collection.getPIDs(), this.active_collection);
        CommonGui.getPicturePanel().setMatrixPreviewPixel(n);
        CommonGui.getPicturePanel().repaint();
        this.action = true;
        return l;
    }

    private void reloadChapterpoints() {
        this.chapterIndexList.removeAllItems();
        Object[] objectArray = this.collection != null ? this.collection.getChapterpoints() : new Object[]{};
        int n = 0;
        while (n < objectArray.length) {
            this.chapterIndexList.addItem(objectArray[n]);
            ++n;
        }
    }

    private void reloadCutpoints() {
        this.cutIndexList.removeAllItems();
        Object[] objectArray = this.collection != null ? this.collection.getCutpoints() : new Object[]{};
        int n = 0;
        while (n < objectArray.length) {
            this.cutIndexList.addItem(objectArray[n]);
            ++n;
        }
    }

    private Object removeChapterpoint(int n) {
        Object object = this.collection.removeChapterpoint(n);
        this.reloadChapterpoints();
        Object[] objectArray = this.collection.getChapterpoints();
        if (objectArray.length > 0) {
            int n2 = -this.getCutIndex(this.collection.getChapterpoints(), object.toString()) - 1;
            if (n2 >= objectArray.length) {
                n2 = objectArray.length - 1;
            }
            this.chapterIndexList.setSelectedIndex(n2);
        }
        return object;
    }

    private Object removeCutpoint(int n) {
        Object object = this.collection.removeCutpoint(n);
        this.reloadCutpoints();
        Object[] objectArray = this.collection.getCutpoints();
        if (objectArray.length > 0) {
            int n2 = -this.getCutIndex(this.collection.getCutpoints(), object.toString()) - 1;
            if (n2 >= objectArray.length) {
                n2 = objectArray.length - 1;
            }
            this.cutIndexList.setSelectedIndex(n2);
        }
        return object;
    }

    public void restartMatrix() {
        this.cm.restart(0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveChapterList() {
        Object[] objectArray = this.collection.getChapterpoints();
        if (objectArray.length == 0) {
            return;
        }
        String string = String.valueOf(this.file) + "[" + this.active_collection + "].Xcp";
        this.chooser.setSelectedFile(new File(string));
        this.chooser.rescanCurrentDirectory();
        int n = this.chooser.showSaveDialog(this);
        if (n != 0) return;
        Object object = this.chooser.getSelectedFile();
        if (object == null || ((File)object).isDirectory()) return;
        string = ((File)object).getAbsolutePath();
        if (((File)object).exists() && !CommonGui.getUserConfirmation(Resource.getString("msg.overwrite", string))) {
            return;
        }
        if (!CommonGui.getUserConfirmation(Resource.getString("msg.overwrite", string))) {
            return;
        }
        try {
            object = new BufferedWriter(new FileWriter(string));
            ((Writer)object).write(String.valueOf(Keys.KEY_CutMode[0]) + "=" + Common.getSettings().getProperty(Keys.KEY_CutMode));
            ((BufferedWriter)object).newLine();
            int n2 = 0;
            while (n2 < objectArray.length) {
                ((Writer)object).write(objectArray[n2].toString());
                ((BufferedWriter)object).newLine();
                ++n2;
            }
            ((BufferedWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            Common.setMessage(String.valueOf(Resource.getString("CollectionPanel.FileAccessError")) + " " + this.file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveCutList() {
        Object[] objectArray = this.collection.getCutpoints();
        if (objectArray.length == 0) {
            return;
        }
        String string = String.valueOf(this.file) + "(" + this.active_collection + ").Xcl";
        this.chooser.setSelectedFile(new File(string));
        this.chooser.rescanCurrentDirectory();
        int n = this.chooser.showSaveDialog(this);
        if (n != 0) return;
        Object object = this.chooser.getSelectedFile();
        if (object == null || ((File)object).isDirectory()) return;
        string = ((File)object).getAbsolutePath();
        if (((File)object).exists() && !CommonGui.getUserConfirmation(Resource.getString("msg.overwrite", string))) {
            return;
        }
        try {
            object = new BufferedWriter(new FileWriter(string));
            ((Writer)object).write(String.valueOf(Keys.KEY_CutMode[0]) + "=" + Common.getSettings().getProperty(Keys.KEY_CutMode));
            ((BufferedWriter)object).newLine();
            int n2 = 0;
            while (n2 < objectArray.length) {
                ((Writer)object).write(objectArray[n2].toString());
                ((BufferedWriter)object).newLine();
                ++n2;
            }
            ((BufferedWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            Common.setMessage(String.valueOf(Resource.getString("CollectionPanel.FileAccessError")) + " " + this.file);
        }
    }

    private void setChapterIndexField(int n) {
        Object[] objectArray = this.collection != null ? this.collection.getChapterpoints() : null;
        this.chapterIndexField.setText(objectArray == null || n < 0 ? "" : String.valueOf(String.valueOf(n)) + "/" + String.valueOf(objectArray.length));
    }

    protected void setComponentColor(JComponent jComponent, Color color) {
        jComponent.setBackground(color);
        jComponent.setForeground(color);
    }

    private void setCutIndexField(int n) {
        Object[] objectArray = this.collection != null ? this.collection.getCutpoints() : null;
        this.cutIndexField.setText(objectArray == null || n < 0 ? "" : String.valueOf(String.valueOf(n)) + "/" + String.valueOf(objectArray.length));
    }

    private void setPositionField(long l) {
        this.updatePositionField(String.valueOf(l));
    }

    private void showCutInfo(boolean bl, Object[] objectArray, Object object) {
        boolean bl2 = false;
        if (!((List)object).isEmpty()) {
            if (this.collection.getSettings().getBooleanProperty(Keys.KEY_OptionDAR) && this.collection.getSettings().getIntProperty(Keys.KEY_ExportDAR) + 1 != Common.getMpvDecoderClass().getAspectRatio()) {
                bl2 = true;
            } else if (this.collection.getSettings().getBooleanProperty(Keys.KEY_OptionHorizontalResolution) && this.collection.getSettings().getIntProperty(Keys.KEY_ExportHorizontalResolution) != Common.getMpvDecoderClass().getWidth()) {
                bl2 = true;
            }
        }
        CommonGui.getPicturePanel().setFilterStatus(bl2);
        Common.getGuiInterface().showCutIcon(bl, objectArray, object);
    }

    public void startMatrix(long l) {
        this.cm.start(l);
    }

    public void stopMatrix() {
        this.cm.breakLoop();
    }

    private void updateCutView(String string) {
        Object[] objectArray;
        if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) != 0) {
            this.cutview.clearViews();
            return;
        }
        Object[] objectArray2 = objectArray = this.collection == null ? null : this.collection.getCutpoints();
        if (objectArray == null || objectArray.length == 0) {
            this.cutview.clearViews();
            return;
        }
        int n = this.getCutIndex(objectArray, string);
        if (n < 0) {
            int n2 = -n - 1;
            this.cutview.setMatchingPoint(false, objectArray, n);
            this.cutview.setImage(n2 < objectArray.length ? this.collection.getCutImage(objectArray[n2]) : null, objectArray, n2, this.cutview.getBottom());
            this.cutview.setImage(n2 - 1 >= 0 && n2 - 1 < objectArray.length ? this.collection.getCutImage(objectArray[n2 - 1]) : null, objectArray, n2 - 1, this.cutview.getTop());
        } else {
            if (this.collection.getCutImage(objectArray[n]) == null) {
                this.collection.setCutImage(string, Common.getMpvDecoderClass().getCutImage());
            }
            this.cutview.setMatchingPoint(true, objectArray, n);
            this.cutview.setImage(n + 1 < objectArray.length ? this.collection.getCutImage(objectArray[n + 1]) : null, objectArray, n + 1, this.cutview.getBottom());
            this.cutview.setImage(n - 1 >= 0 ? this.collection.getCutImage(objectArray[n - 1]) : null, objectArray, n - 1, this.cutview.getTop());
        }
    }

    private void updatePositionField() {
        this.updatePositionField(this.positionField.getText());
    }

    private void updatePositionField(String string) {
        boolean bl = this.action;
        List list = this.collection.getCutpointList();
        List list2 = this.collection.getChapterpointList();
        this.action = false;
        if (list.contains(string)) {
            this.positionField.setBackground(new Color(225, 200, 225));
        } else if (list2.contains(string)) {
            this.positionField.setBackground(new Color(225, 230, 255));
        } else {
            this.positionField.setBackground(Color.white);
        }
        this.positionField.setText(string);
        this.action = bl;
    }

    private class DNDListener2
    implements DropTargetListener {
        DNDListener2() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                int n = dropTargetDropEvent.getDropAction();
                if (n == 0 || n > 2) {
                    dropTargetDropEvent.rejectDrop();
                    return;
                }
                dropTargetDropEvent.acceptDrop(n);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                List list = (List)transferable.getTransferData(dataFlavorArray[0]);
                Object[] objectArray = list.toArray();
                if (objectArray.length > 0) {
                    CutPanel.this.loadCutList(objectArray[0].toString());
                }
                dropTargetDropEvent.dropComplete(true);
            }
            catch (Exception exception) {
                dropTargetDropEvent.dropComplete(false);
                Common.setExceptionMessage(exception);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    private class CutListener
    implements ActionListener {
        CutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (CutPanel.this.collection == null) {
                return;
            }
            if (!CutPanel.this.action) {
                return;
            }
            CutPanel.this.action = false;
            String string = actionEvent.getActionCommand();
            if (string.equals("delpoint")) {
                if (CutPanel.this.cutIndexList.getItemCount() > 0) {
                    CutPanel.this.removeCutpoint(CutPanel.this.cutIndexList.getSelectedIndex());
                }
            } else if (string.equals("cutnumber") || string.equals("addpoint")) {
                String string2 = CutPanel.this.positionField.getText();
                if (!string2.equals("") && CutPanel.this.addCutpoint(string2) && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CutPanel.this.collection.setCutImage(string2, Common.getMpvDecoderClass().getCutImage());
                }
            } else if (string.equals("delchapter")) {
                if (CutPanel.this.chapterIndexList.getItemCount() > 0) {
                    CutPanel.this.removeChapterpoint(CutPanel.this.chapterIndexList.getSelectedIndex());
                }
            } else if (string.equals("addchapter")) {
                String string3 = CutPanel.this.positionField.getText();
                boolean bl = !string3.equals("") && CutPanel.this.addChapterpoint(string3);
            } else if (string.equals("movecutleft")) {
                if (CutPanel.this.cutIndexList.getItemCount() > 0) {
                    int n2 = CutPanel.this.cutIndexList.getSelectedIndex();
                    CutPanel.this.action = true;
                    CutPanel.this.jump[6].doClick();
                    CutPanel.this.action = false;
                    CutPanel.this.removeCutpoint(n2);
                    CutPanel.this.addCutpoint(CutPanel.this.positionField.getText());
                }
            } else if (string.equals("movecutright")) {
                if (CutPanel.this.cutIndexList.getItemCount() > 0) {
                    int n3 = CutPanel.this.cutIndexList.getSelectedIndex();
                    CutPanel.this.action = true;
                    CutPanel.this.jump[7].doClick();
                    CutPanel.this.action = false;
                    CutPanel.this.removeCutpoint(n3);
                    CutPanel.this.addCutpoint(CutPanel.this.positionField.getText());
                }
            } else if (string.equals("movechapterleft")) {
                if (CutPanel.this.chapterIndexList.getItemCount() > 0) {
                    int n4 = CutPanel.this.chapterIndexList.getSelectedIndex();
                    CutPanel.this.action = true;
                    CutPanel.this.jump[6].doClick();
                    CutPanel.this.action = false;
                    CutPanel.this.removeChapterpoint(n4);
                    CutPanel.this.addChapterpoint(CutPanel.this.positionField.getText());
                }
            } else if (string.equals("movechapterright") && CutPanel.this.chapterIndexList.getItemCount() > 0) {
                int n5 = CutPanel.this.chapterIndexList.getSelectedIndex();
                CutPanel.this.action = true;
                CutPanel.this.jump[7].doClick();
                CutPanel.this.action = false;
                CutPanel.this.removeChapterpoint(n5);
                CutPanel.this.addChapterpoint(CutPanel.this.positionField.getText());
            }
            if (CutPanel.this.cutIndexList.getItemCount() > 0) {
                Object[] objectArray = CutPanel.this.collection.getCutpoints();
                n = CutPanel.this.cutIndexList.getSelectedIndex();
                CutPanel.this.setCutIndexField(n + 1);
                CutPanel.this.showCutInfo((n & 1) == 0, objectArray, CutPanel.this.previewList);
                if ((string.equals("cutbox") || string.equals("delpoint")) && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CutPanel.this.preview(Long.parseLong(objectArray[n].toString()));
                }
                if (string.equals("addpoint")) {
                    CutPanel.this.updateCutView(String.valueOf(CutPanel.this.lastPosition));
                }
            } else {
                CutPanel.this.showCutInfo(true, null, CutPanel.this.previewList);
                CutPanel.this.setCutIndexField(-1);
                CutPanel.this.updateCutView(String.valueOf(CutPanel.this.lastPosition));
            }
            if (CutPanel.this.chapterIndexList.getItemCount() > 0) {
                Object[] objectArray = CutPanel.this.collection.getChapterpoints();
                n = CutPanel.this.chapterIndexList.getSelectedIndex();
                CutPanel.this.setChapterIndexField(n + 1);
                Common.getGuiInterface().showChapterIcon(objectArray, CutPanel.this.previewList);
                if (string.equals("chapterbox") && Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                    CutPanel.this.preview(Long.parseLong(objectArray[n].toString()));
                }
            } else {
                Common.getGuiInterface().showChapterIcon(null, CutPanel.this.previewList);
                CutPanel.this.setChapterIndexField(-1);
            }
            if (Common.getSettings().getIntProperty(Keys.KEY_CutMode) == 0) {
                CutPanel.this.slider.requestFocus();
            }
            CutPanel.this.getExpectedSize();
            CutPanel.this.updatePositionField();
            if (string.startsWith("move")) {
                CutPanel.this.updateCutView(String.valueOf(CutPanel.this.lastPosition));
            }
            CutPanel.this.action = true;
        }
    }

    private class JumpListener
    implements ActionListener {
        JumpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CutPanel.this.collection == null) {
                return;
            }
            if (!CutPanel.this.action) {
                return;
            }
            String string = actionEvent.getActionCommand();
            int n = CutPanel.this.slider.getValue();
            if (string.equals(CutPanel.this.navigation[0])) {
                int n2 = 0;
                int n3 = CutPanel.this.cutIndexList.getItemCount();
                if (n3 > 0) {
                    n2 = n3 - 1;
                    if (CutPanel.this.lastPosition > Long.parseLong(CutPanel.this.cutIndexList.getItemAt(0).toString())) {
                        while (CutPanel.this.lastPosition <= Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n2).toString())) {
                            --n2;
                        }
                    }
                    CutPanel.this.cutIndexList.setSelectedIndex(n2);
                }
            } else if (string.equals(CutPanel.this.navigation[1])) {
                CutPanel.this.slider.setValue(n - 3125000);
            } else if (string.equals(CutPanel.this.navigation[2])) {
                CutPanel.this.slider.setValue(n - 312500);
            } else if (string.equals(CutPanel.this.navigation[6])) {
                CutPanel.this.slider.setValue(n - 2);
            } else if (string.equals(CutPanel.this.navigation[7])) {
                CutPanel.this.slider.setValue(n + 2);
            } else if (string.equals(CutPanel.this.navigation[3])) {
                CutPanel.this.slider.setValue(n + 312500);
            } else if (string.equals(CutPanel.this.navigation[4])) {
                CutPanel.this.slider.setValue(n + 3125000);
            } else if (string.equals(CutPanel.this.navigation[5])) {
                int n4 = 0;
                int n5 = CutPanel.this.cutIndexList.getItemCount();
                if (n5 > 0) {
                    if (CutPanel.this.lastPosition < Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n5 - 1).toString())) {
                        while (CutPanel.this.lastPosition >= Long.parseLong(CutPanel.this.cutIndexList.getItemAt(n4).toString())) {
                            ++n4;
                        }
                    }
                    CutPanel.this.cutIndexList.setSelectedIndex(n4);
                }
            } else if (string.equals("load_cutlist")) {
                CutPanel.this.loadCutList();
            } else if (string.equals("save_cutlist")) {
                CutPanel.this.saveCutList();
            } else if (string.equals("load_chapterlist")) {
                CutPanel.this.loadChapterList();
            } else if (string.equals("save_chapterlist")) {
                CutPanel.this.saveChapterList();
            } else if (string.equals("cut_scan")) {
                CutPanel.this.restartMatrix();
            }
        }
    }

    private class SlideShow
    implements Runnable {
        private Thread clockThread = null;
        private long value = 0L;
        private long skip = 50L;
        private Object[] cutpoints = null;

        SlideShow() {
        }

        private void getCutPoints() {
            this.cutpoints = CutPanel.this.collection == null ? null : CutPanel.this.collection.getCutpoints();
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                try {
                    long l;
                    do {
                        l = this.update(this.value);
                        Thread.sleep(5L);
                        CommonGui.getPlayerFrame().repaintPicture(1);
                        if (!CutPanel.this.slideshow || l < this.value) break;
                        this.value = this.skipArea(l);
                    } while (this.value >= l);
                    this.stop();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private long skipArea(long l) {
            if (this.cutpoints == null || this.cutpoints.length == 0) {
                return l + this.skip;
            }
            int n = CutPanel.this.getCutIndex(this.cutpoints, String.valueOf(l));
            if (n < 0) {
                if ((n & 1) == 0) {
                    return l + this.skip;
                }
                if (-n > this.cutpoints.length) {
                    return l - this.skip;
                }
                return Long.parseLong(this.cutpoints[n + 1].toString());
            }
            if ((n & 1) == 0) {
                return l + this.skip;
            }
            if (n + 1 >= this.cutpoints.length) {
                return l - this.skip;
            }
            return Long.parseLong(this.cutpoints[n + 1].toString());
        }

        public void start(long l) {
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "SlideShow");
                this.clockThread.setPriority(5);
                this.value = l;
                this.skip = CutPanel.this.getLoadSize() >>> 6;
                this.getCutPoints();
                this.clockThread.start();
            }
        }

        public void stop() {
            this.clockThread = null;
        }

        private long update(long l) {
            return CutPanel.this.preview(l);
        }
    }

    private class CutMatrix
    implements Runnable {
        private Thread clockThread = null;
        private boolean stopit = false;
        private long tmp = 0L;
        private long value = 0L;
        private long start_value = 0L;
        private int scale = 1;

        CutMatrix() {
        }

        public void breakLoop() {
            this.stopit = true;
        }

        public void restart(long l) {
            this.start(l);
            this.scale = 1;
        }

        public void run() {
            Thread thread = Thread.currentThread();
            while (this.clockThread == thread) {
                try {
                    if (!CutPanel.this.previewList.isEmpty()) {
                        int[][] nArray = CommonGui.getPicturePanel().getMatrixTable();
                        long l = ((PreviewObject)CutPanel.this.previewList.get(CutPanel.this.previewList.size() - 1)).getEnd();
                        long l2 = l / (long)nArray.length;
                        l2 /= (long)this.scale;
                        this.scale <<= 1;
                        CommonGui.getPicturePanel().resetMatrixPositions(l);
                        int n = 0;
                        while (!this.stopit && n < nArray.length) {
                            this.tmp = this.start_value + (long)n * l2;
                            if (this.tmp > l) break;
                            this.value = this.update(this.tmp, n);
                            String string = Common.getMpvDecoderClass().getInfo_2();
                            string = string.substring(0, string.indexOf(","));
                            CommonGui.getPicturePanel().setMatrixIndexPosition(n, this.value, string);
                            Thread.sleep(5L);
                            ++n;
                        }
                    }
                    this.stop();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void start(long l) {
            this.breakLoop();
            if (this.clockThread == null) {
                this.clockThread = new Thread((Runnable)this, "CutMatrix");
                this.clockThread.setPriority(1);
                this.start_value = l;
                this.stopit = false;
                this.clockThread.start();
            }
        }

        public void stop() {
            this.clockThread = null;
        }

        private long update(long l, int n) {
            return CutPanel.this.previewMatrix(l, n);
        }
    }
}

