/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.audio.AudioFormat;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.video.Video;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class Scan {
    private final String msg_1 = Resource.getString("scan.msg1");
    private final String msg_2 = Resource.getString("scan.msg2");
    private final String msg_3 = Resource.getString("scan.msg3");
    private final String msg_4 = Resource.getString("scan.msg4");
    private final String msg_5 = Resource.getString("scan.msg5");
    private final String msg_6 = Resource.getString("scan.msg6");
    private final String msg_7 = Resource.getString("scan.msg7");
    private final String msg_8 = Resource.getString("scan.msg8");
    private final String msg_9 = Resource.getString("scan.msg9");
    private String addInfo = "";
    private String playtime = "";
    private boolean hasVideo = false;
    private byte[] vbasic = new byte[12];
    private int filetype = 0;
    private ArrayList pidlist;
    private ArrayList video_streams;
    private ArrayList audio_streams;
    private ArrayList ttx_streams;
    private ArrayList pic_streams;
    private ArrayList unknown_streams;
    private AudioFormat Audio = new AudioFormat();

    public Scan() {
        this.video_streams = new ArrayList();
        this.audio_streams = new ArrayList();
        this.ttx_streams = new ArrayList();
        this.pic_streams = new ArrayList();
        this.unknown_streams = new ArrayList();
        this.pidlist = new ArrayList();
    }

    private int AC3Audio(byte[] byArray) {
        this.Audio.setNewType(0);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0) {
                int n2 = 0;
                while (n2 < 17) {
                    if (this.Audio.parseNextHeader(byArray, n + this.Audio.getSize() + n2) == 1) {
                        if ((0xFF & byArray[n + this.Audio.getSize()]) > 63 || (0xFF & byArray[n + this.Audio.getSize()]) == 0) break;
                        this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        return 1;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return 0;
    }

    private int DTSAudio(byte[] byArray) {
        this.Audio.setNewType(6);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0) {
                int n2 = 0;
                while (n2 < 15) {
                    if (this.Audio.parseNextHeader(byArray, n + this.Audio.getSize() + n2) == 1) {
                        if ((0xFF & byArray[n + this.Audio.getSize()]) > 127 || (0xFF & byArray[n + this.Audio.getSize()]) == 0) break;
                        this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        return 1;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return 0;
    }

    private int LPCMAudio(byte[] byArray) {
        this.Audio.setNewType(4);
        int n = 0;
        while (n < 1000) {
            if (this.Audio.parseHeader(byArray, n) >= 0) {
                this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                return 1;
            }
            ++n;
        }
        return 0;
    }

    private int MPEGAudio(byte[] byArray) {
        this.Audio.setNewType(2);
        int n = 0;
        while (n < 10000) {
            if (this.Audio.parseHeader(byArray, n) >= 0 && this.Audio.parseNextHeader(byArray, n + this.Audio.getSize()) >= 0) {
                this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                return 1;
            }
            ++n;
        }
        return 0;
    }

    private int YUVtoRGB(int n) {
        int n2 = 0xFF & n >> 16;
        int n3 = 0xFF & n >> 8;
        int n4 = 0xFF & n;
        if (n2 == 0) {
            return 0;
        }
        int n5 = (int)((float)n2 + 1.402f * (float)(n3 - 128));
        int n6 = (int)((double)n2 - 0.34414 * (double)(n4 - 128) - 0.71414 * (double)(n3 - 128));
        int n7 = (int)((double)n2 + 1.722 * (double)(n4 - 128));
        int n8 = n5 < 0 ? 0 : (n5 = n5 > 255 ? 255 : n5);
        int n9 = n6 < 0 ? 0 : (n6 = n6 > 255 ? 255 : n6);
        n7 = n7 < 0 ? 0 : (n7 > 255 ? 255 : n7);
        int n10 = 255;
        return n10 << 24 | n5 << 16 | n6 << 8 | n7;
    }

    private void checkPES(byte[] byArray) {
        this.checkPES(byArray, 0);
    }

    private void checkPES(byte[] byArray, int n) {
        int n2 = n + 8000;
        while (n < n2) {
            int n3;
            int n4 = CommonParsing.validateStartcode(byArray, n);
            if (n4 < 0) {
                n += -n4 - 1;
            } else if (((0xE0 & byArray[n + 3]) == 192 || CommonParsing.getPES_IdField(byArray, n) == 189) && CommonParsing.validateStartcode(byArray, n3 = n + 6 + CommonParsing.getPES_LengthField(byArray, n)) >= 0) {
                if ((0xE0 & byArray[n + 3]) == 192 && (0xE0 & byArray[n + 3]) == (0xE0 & byArray[n3 + 3])) {
                    this.MPEGAudio(this.loadPES(byArray, n));
                    return;
                }
                if (CommonParsing.getPES_IdField(byArray, n) == 189 && CommonParsing.getPES_IdField(byArray, n) == CommonParsing.getPES_IdField(byArray, n3)) {
                    byte[] byArray2 = this.loadPES(byArray, n);
                    if (this.AC3Audio(byArray2) != 0) {
                        return;
                    }
                    if (this.DTSAudio(byArray2) != 0) {
                        return;
                    }
                    this.LPCMAudio(byArray2);
                    return;
                }
            }
            ++n;
        }
    }

    private void checkVid(byte[] byArray) {
        this.checkVid(byArray, byArray.length - 630);
    }

    private boolean checkVid(byte[] byArray, int n) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n3 < n) {
            int n4 = CommonParsing.validateStartcode(byArray, n3);
            if (n4 < 0 || CommonParsing.getPES_IdField(byArray, n3) != 179) {
                n3 += (n4 < 0 ? -n4 : 4) - 1;
            } else {
                int n5 = 7;
                n2 = 1;
                while (n5 < 600) {
                    n4 = CommonParsing.validateStartcode(byArray, n3 + n5);
                    if (n4 < 0) {
                        n5 += -n4 - 1;
                    } else {
                        int n6 = CommonParsing.getPES_IdField(byArray, n3 + n5);
                        if (n6 == 181 && (0xF0 & byArray[4 + n3 + n5]) == 16) {
                            n2 = 2;
                        } else if (n6 == 184 || n6 == 0) {
                            this.hasVideo = true;
                            System.arraycopy(byArray, n3, this.vbasic, 0, 12);
                            byteArrayOutputStream.write(byArray, n3, 20);
                            this.video_streams.add("MPEG-" + n2 + ", " + Video.getVideoformatfromBytes(byteArrayOutputStream.toByteArray()));
                            return true;
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        String[] stringArray = new String[18];
        n2 = Common.getMpvDecoderClass().parseH264(byArray, n, stringArray);
        if (n2 != 0) {
            this.video_streams.add(String.valueOf(stringArray[0]) + "  " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3]);
            return true;
        }
        return false;
    }

    private Object[] getAudio() {
        return this.audio_streams.toArray();
    }

    private String getAudioTime(long l) {
        return Common.formatTime_1(l * 8000L / (long)this.Audio.getBitrate());
    }

    private String getDate(XInputFile xInputFile) {
        return String.valueOf(DateFormat.getDateInstance(1).format(new Date(xInputFile.lastModified()))) + "  " + DateFormat.getTimeInstance(1).format(new Date(xInputFile.lastModified()));
    }

    private void getDescriptor(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = "";
        int n5 = 0;
        try {
            block39: while (n < n2 && n < byArray.length) {
                switch (0xFF & byArray[n]) {
                    case 89: {
                        int n6;
                        int n7;
                        int n8;
                        n4 = 89;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n9 = n + 2;
                        while (n9 < n5) {
                            n8 = n9;
                            while (n8 < n9 + 3) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n8]);
                                ++n8;
                            }
                            n7 = 0xFF & byArray[n9 + 3];
                            n6 = (0xFF & byArray[n9 + 4]) << 16 | 0xFF & byArray[n9 + 5];
                            int n10 = (0xFF & byArray[n9 + 6]) << 16 | 0xFF & byArray[n9 + 7];
                            string = String.valueOf(string) + "_0x" + Integer.toHexString(n7).toUpperCase();
                            string = String.valueOf(string) + "_p" + n6;
                            string = String.valueOf(string) + "_a" + n10 + " ";
                            n9 += 8;
                        }
                        string = String.valueOf(string) + ")";
                        break block39;
                    }
                    case 86: {
                        int n6;
                        int n7;
                        int n8;
                        n4 = 86;
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n9 = n + 2;
                        while (n9 < n5) {
                            n8 = n9;
                            while (n8 < n9 + 3) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n8]);
                                ++n8;
                            }
                            n7 = (0xF8 & byArray[n9 + 3]) >>> 3;
                            n6 = 0xFF & byArray[n9 + 4];
                            string = String.valueOf(string) + "_";
                            switch (n7) {
                                case 1: {
                                    string = String.valueOf(string) + "i";
                                    break;
                                }
                                case 2: {
                                    string = String.valueOf(string) + "s";
                                    break;
                                }
                                case 3: {
                                    string = String.valueOf(string) + "ai";
                                    break;
                                }
                                case 4: {
                                    string = String.valueOf(string) + "ps";
                                    break;
                                }
                                case 5: {
                                    string = String.valueOf(string) + "s.hip";
                                    break;
                                }
                                default: {
                                    string = String.valueOf(string) + "res";
                                }
                            }
                            string = String.valueOf(string) + Integer.toHexString((7 & byArray[n9 + 3]) == 0 ? 8 : 7 & byArray[n9 + 3]).toUpperCase();
                            string = String.valueOf(string) + (n6 < 16 ? "0" : "") + Integer.toHexString(n6).toUpperCase() + " ";
                            n9 += 5;
                        }
                        string = String.valueOf(string) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 10: {
                        string = String.valueOf(string) + "{";
                        int n9 = n + 2;
                        while (n9 < n + 5) {
                            if ((0xFF & byArray[n9]) > 0) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n9]);
                            }
                            ++n9;
                        }
                        string = String.valueOf(string) + "}";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 106: {
                        string = String.valueOf(string) + "(AC-3)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 124: {
                        string = String.valueOf(string) + "(AAC)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 160: {
                        string = String.valueOf(string) + "(FOURCC=";
                        int n9 = n + 2;
                        while (n9 < n + 6) {
                            if ((0xFF & byArray[n9]) > 0) {
                                string = String.valueOf(string) + (char)(0xFF & byArray[n9]);
                            }
                            ++n9;
                        }
                        string = String.valueOf(string) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 195: {
                        switch (0xFF & byArray[++n + 1]) {
                            case 4: {
                                string = String.valueOf(string) + "(VPS)";
                                n4 = 195;
                                break;
                            }
                            case 5: {
                                string = String.valueOf(string) + "(WSS)";
                                break;
                            }
                            case 6: {
                                string = String.valueOf(string) + "(CC)";
                                break;
                            }
                            case 1: {
                                string = String.valueOf(string) + "(EBU-TTX)";
                                break;
                            }
                            case 7: {
                                string = String.valueOf(string) + "(VBI)";
                                break;
                            }
                        }
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 82: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(#" + (0xFF & byArray[n + 2]) + ")";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 107: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(RDS)";
                        ++n;
                        n += 0xFF & byArray[n];
                        break;
                    }
                    case 5: {
                        n5 = n + 2 + (0xFF & byArray[n + 1]);
                        string = String.valueOf(string) + "(";
                        int n9 = n + 2;
                        while (n9 < n5) {
                            string = String.valueOf(string) + (char)(0xFF & byArray[n9]);
                            ++n9;
                        }
                        string = String.valueOf(string) + ")";
                    }
                    default: {
                        ++n;
                        n += 0xFF & byArray[n];
                    }
                }
                ++n;
            }
            String string2 = "PID: 0x" + Common.adaptString(Integer.toHexString(n3).toUpperCase(), 4);
            switch (n4) {
                case 89: {
                    this.pic_streams.add(String.valueOf(string2) + string);
                    break;
                }
                case 86: {
                    this.ttx_streams.add(String.valueOf(string2) + string);
                    break;
                }
                case 27: {
                    this.video_streams.add(String.valueOf(string2) + string + "(H.264)");
                    break;
                }
                case 1: {
                    this.video_streams.add(String.valueOf(string2) + string + "(MPEG-1)");
                    break;
                }
                case 2: {
                    this.video_streams.add(String.valueOf(string2) + string + "(MPEG-2)");
                    break;
                }
                case 195: {
                    this.video_streams.add(String.valueOf(string2) + string);
                    break;
                }
                case 3: {
                    this.audio_streams.add(String.valueOf(string2) + string + "(Mpg1)");
                    break;
                }
                case 4: {
                    this.audio_streams.add(String.valueOf(string2) + string + "(Mpg2)");
                    break;
                }
                case 17: {
                    this.audio_streams.add(String.valueOf(string2) + string + "(Mpg4)");
                    break;
                }
                default: {
                    this.audio_streams.add(String.valueOf(string2) + string + "[PD]");
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.playtime = String.valueOf(this.playtime) + this.msg_6;
        }
    }

    private String getLocation(XInputFile xInputFile) {
        return xInputFile.getParent();
    }

    private String getName(XInputFile xInputFile) {
        return xInputFile.getName();
    }

    private Object[] getPIDs() {
        return this.pidlist.toArray();
    }

    private Object[] getPics() {
        return this.pic_streams.toArray();
    }

    private String getPlaytime() {
        return this.playtime;
    }

    private String getSize(XInputFile xInputFile) {
        long l = xInputFile.length();
        return String.valueOf(String.valueOf(l / 0x100000L)) + " MB (" + Common.formatNumber(l) + " " + Resource.getString("ScanInfo.Bytes") + ")";
    }

    public void getStreamInfo(XInputFile xInputFile) {
        this.getStreamInfo(xInputFile, 0L, -1);
    }

    public void getStreamInfo(XInputFile xInputFile, long l) {
        this.getStreamInfo(xInputFile, l, -1);
    }

    public void getStreamInfo(XInputFile xInputFile, long l, int n) {
        String string = this.getName(xInputFile);
        String string2 = this.getLocation(xInputFile);
        String string3 = this.getDate(xInputFile);
        String string4 = this.getSize(xInputFile);
        StreamInfo streamInfo = xInputFile.getStreamInfo();
        if (xInputFile.exists()) {
            if (streamInfo == null) {
                streamInfo = new StreamInfo();
            }
            streamInfo.setStreamInfo(xInputFile.getFileType().getName(), this.getType(xInputFile, l, n), string, string2, string3, string4, this.getPlaytime(), this.getVideo(), this.getAudio(), this.getText(), this.getPics());
            streamInfo.setStreamType(this.filetype, this.addInfo);
            streamInfo.setPIDs(this.getPIDs());
            streamInfo.setVideoHeader(this.getVBasic());
        } else {
            streamInfo = new StreamInfo("none", Resource.getString("ScanInfo.NotFound"), string, string2, "", "", "");
        }
        xInputFile.setStreamInfo(streamInfo);
    }

    private int getStreamSubType() {
        return 0xFF & this.filetype >>> 8;
    }

    private int getStreamType() {
        return 0xFF & this.filetype;
    }

    private Object[] getText() {
        return this.ttx_streams.toArray();
    }

    private String getType(XInputFile xInputFile, long l, int n) {
        this.filetype = l > 0L ? this.testFile(xInputFile, true, l, n) : this.testFile(xInputFile, true, n);
        return String.valueOf(Keys.ITEMS_FileTypes[this.getStreamType()].toString()) + " [" + this.getStreamSubType() + "] " + this.addInfo;
    }

    private byte[] getVBasic() {
        if (this.hasVideo) {
            return this.vbasic;
        }
        return null;
    }

    private Object[] getVideo() {
        return this.video_streams.toArray();
    }

    private void loadMPG2(byte[] byArray, int n, boolean bl, boolean bl2, boolean bl3, int n2) throws IOException {
        ScanObject scanObject;
        String string;
        int n3;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        int n4 = 1;
        int n5 = byArray.length > 580000 ? 512000 : byArray.length - 65000;
        int n6 = n;
        while (n6 < n5) {
            int n7 = CommonParsing.validateStartcode(byArray, n6);
            if (n7 < 0) {
                n4 = -n7;
            } else {
                class Net_sourceforge_dvb_projectx_parser_Scan$1 {
                    /* synthetic */ Net_sourceforge_dvb_projectx_parser_Scan$1() {
                    }
                }
                n3 = CommonParsing.getPES_IdField(byArray, n6);
                string = String.valueOf(n3);
                if (n3 == 186) {
                    n4 = (0xC0 & byArray[4 + n6]) == 0 ? 12 : ((0xC0 & byArray[4 + n6]) == 64 ? 14 + (7 & byArray[13 + n6]) : 4);
                } else if ((0xF0 & n3) == 224) {
                    int n8 = n4 = bl3 ? 2048 : 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    if (!hashtable.containsKey(string)) {
                        hashtable.put(string, new ScanObject(null, n3));
                    }
                    scanObject = (ScanObject)hashtable.get(string);
                    scanObject.write(byArray, n6 + 6 + (!bl2 ? 3 + CommonParsing.getPES_ExtensionLengthField(byArray, n6) : 0), n4 - (!bl2 ? 3 - CommonParsing.getPES_ExtensionLengthField(byArray, n6) : 0));
                } else if ((0xE0 & n3) == 192) {
                    n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    if (!hashtable.containsKey(string)) {
                        hashtable.put(string, new ScanObject(null, n3));
                    }
                    scanObject = (ScanObject)hashtable.get(string);
                    scanObject.write(byArray, n6, n4);
                } else if (n3 == 189) {
                    n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                    int n9 = CommonParsing.getPES_ExtensionLengthField(byArray, n6);
                    boolean bl4 = (4 & byArray[n6 + 6]) != 0;
                    int n10 = 0xFF & byArray[n6 + 9 + n9];
                    if (n9 == 36 && n10 >>> 4 == 1) {
                        string = "SubID 0x" + Integer.toHexString(n10).toUpperCase();
                        if (this.ttx_streams.indexOf(string) < 0) {
                            this.ttx_streams.add(string);
                        }
                    } else if ((!bl2 && !bl || bl && bl4) && (n10 >>> 4 == 2 || n10 >>> 4 == 3)) {
                        string = "SubID 0x" + Integer.toHexString(n10).toUpperCase();
                        if (this.pic_streams.indexOf(string) < 0) {
                            this.pic_streams.add(string);
                        }
                    } else {
                        if (!bl) {
                            n3 = 0xFF & byArray[n6 + 9 + n9];
                            string = String.valueOf(n3);
                            byArray[n6 + 8] = (byte)((n10 >>> 4 == 10 ? 1 : 4) + n9);
                        }
                        if (!hashtable.containsKey(string)) {
                            hashtable.put(string, new ScanObject(null, n3));
                        }
                        scanObject = (ScanObject)hashtable.get(string);
                        scanObject.write(byArray, n6, n4);
                    }
                } else {
                    switch (n3) {
                        case 187: 
                        case 188: 
                        case 190: 
                        case 191: 
                        case 240: 
                        case 241: 
                        case 242: 
                        case 243: 
                        case 244: 
                        case 245: 
                        case 246: 
                        case 247: 
                        case 248: 
                        case 249: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 253: 
                        case 254: 
                        case 255: {
                            n4 = 6 + CommonParsing.getPES_LengthField(byArray, n6);
                            break;
                        }
                        default: {
                            n4 = 1;
                        }
                    }
                }
            }
            n6 += n4;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            n3 = Integer.parseInt(string);
            scanObject = (ScanObject)hashtable.get(string);
            if ((0xF0 & n3) == 224) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    private byte[] loadPES(byte[] byArray, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (n < byArray.length) {
            int n2;
            int n3;
            boolean bl = (0x80 & byArray[n + 6]) == 0;
            int n4 = n + 6 + (!bl ? 3 + (0xFF & byArray[n + 8]) : 0);
            if (n4 + (n3 = (n2 = (0xFF & byArray[n + 4]) << 8 | 0xFF & byArray[n + 5]) - (!bl ? 3 + (0xFF & byArray[n + 8]) : 0)) > byArray.length) break;
            byteArrayOutputStream.write(byArray, n4, n3);
            n += 6 + n2;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void loadPVA(byte[] byArray, int n) throws IOException {
        ScanObject scanObject;
        String string;
        Hashtable<String, ScanObject> hashtable = new Hashtable<String, ScanObject>();
        int n2 = byArray.length > 580000 ? 512000 : byArray.length - 65000;
        while (n < n2) {
            int n3 = (0xFF & byArray[n + 6]) << 8 | 0xFF & byArray[n + 7];
            if (n + 8 + (1 & byArray[n + 5] >>> 4) * 4 + n3 > byArray.length) break;
            int n4 = 0xFF & byArray[n + 2];
            string = String.valueOf(n4);
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, new ScanObject(null, n4));
            }
            scanObject = (ScanObject)hashtable.get(string);
            switch (n4) {
                case 1: {
                    scanObject.write(byArray, n + 8 + (1 & byArray[n + 5] >>> 4) * 4, n3);
                    break;
                }
                default: {
                    scanObject.write(byArray, n + 8, n3);
                }
            }
            n += 8 + n3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            scanObject = (ScanObject)hashtable.get(string);
            if (string.equals("1")) {
                try {
                    this.checkVid(scanObject.getData());
                }
                catch (Exception exception) {
                    this.video_streams.add(this.msg_8);
                }
                continue;
            }
            try {
                this.checkPES(scanObject.getData());
            }
            catch (Exception exception) {
                this.audio_streams.add(this.msg_8);
            }
        }
        hashtable.clear();
    }

    private void readPMT(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        int n3 = 188;
        while (n < byArray.length - 1000) {
            int n4;
            if (byArray[n] == 71 && byArray[n + n3 + n2] == 71 && byArray[n + (n3 + n2) * 2] == 71 && (0x40 & byArray[n + 1]) != 0 && (0xC0 & byArray[n + 3]) == 0 && ((n4 = (0x30 & byArray[n + 3]) >>> 4) & 1) != 0) {
                int n5;
                int n6 = n5 = n4 == 3 ? 1 + (0xFF & byArray[n + 4]) : 0;
                if (byArray[n + n5 + 4] != 0 || byArray[n + n5 + 5] != 2 || (0xF0 & byArray[n + n5 + 6]) != 176) {
                    n += n3 + n2 - 1;
                } else {
                    int n7;
                    byte[] byArray2;
                    byteArrayOutputStream.write(byArray, n + 4 + n5, n3 - 4 - n5);
                    int n8 = (0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
                    if (byteArrayOutputStream.size() < n3) {
                        n += n3 + n2;
                        while (n < byArray.length - 500) {
                            if (byArray[n] == 71 && byArray[n + n3 + n2] == 71 && byArray[n + (n3 + n2) * 2] == 71 && (0x40 & byArray[n + 1]) == 0 && (0xC0 & byArray[n + 3]) == 0 && ((n4 = (0x30 & byArray[n + 3]) >>> 4) & 1) != 0) {
                                int n9 = n5 = n4 == 3 ? 1 + (0xFF & byArray[n + 4]) : 0;
                                if (((0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2]) != n8) {
                                    n += n3 + n2 - 1;
                                } else {
                                    byteArrayOutputStream.write(byArray, n + 4 + n5, n3 - 4 - n5);
                                    if (byteArrayOutputStream.size() > n3) break;
                                }
                            }
                            ++n;
                        }
                    }
                    if ((byArray2 = byteArrayOutputStream.toByteArray()).length > 5) {
                        n7 = (0xFF & byArray2[4]) << 8 | 0xFF & byArray2[5];
                        this.pidlist.add(String.valueOf(n7));
                        this.pidlist.add(String.valueOf(n8));
                        this.addInfo = " (SID 0x" + Common.adaptString(Integer.toHexString(n7).toUpperCase(), 4) + ", PMT 0x" + Common.adaptString(Integer.toHexString(n8).toUpperCase(), 4) + ")";
                    }
                    n7 = (0xF & byArray2[2]) << 8 | 0xFF & byArray2[3];
                    int n10 = 8;
                    int n11 = 8;
                    while (n10 < n7 - 4 && n10 < byArray2.length - 6) {
                        n11 = n10;
                        if ((0xE0 & byArray2[n10 + 1]) == 224) {
                            int n12 = (0x1F & byArray2[n10 + 1]) << 8 | 0xFF & byArray2[n10 + 2];
                            switch (0xFF & byArray2[n10]) {
                                case 1: {
                                    int n13 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n13, n10, n12, 1);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 2: {
                                    int n14 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n14, n10, n12, 2);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 3: {
                                    int n15 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n15, n10, n12, 3);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 4: {
                                    int n16 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n16, n10, n12, 4);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 17: {
                                    int n17 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n17, n10, n12, 17);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 27: {
                                    int n18 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n18, n10, n12, 27);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                case 6: 
                                case 128: 
                                case 129: 
                                case 130: 
                                case 131: 
                                case 160: {
                                    int n19 = n10 + 5;
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                    this.getDescriptor(byArray2, n19, n10, n12, 6);
                                    this.pidlist.add(String.valueOf(n12));
                                    break;
                                }
                                default: {
                                    n10 += 4 + (0xFF & byArray2[n10 + 4]);
                                }
                            }
                            if (n10 < 0) {
                                n10 = n11;
                            }
                        }
                        ++n10;
                    }
                    return;
                }
            }
            ++n;
        }
    }

    private int scanAc3Audio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(0);
        int n2 = 0;
        boolean bl2 = false;
        while (n2 < n) {
            block9: {
                if (this.Audio.parseHeader(byArray, n2) >= 1) {
                    int n3 = 0;
                    while (n3 < 17) {
                        if (this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize() + n3) == 1) {
                            if ((0xFF & byArray[n2 + this.Audio.getSize()]) <= 63 && (0xFF & byArray[n2 + this.Audio.getSize()]) != 0) {
                                if (bl) {
                                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                                    this.playtime = this.getAudioTime(l);
                                }
                                if (n3 == 0) {
                                    return 10;
                                }
                                return 11;
                            }
                            break block9;
                        }
                        ++n3;
                    }
                    if (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces)) {
                        if (bl) {
                            this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        }
                        this.playtime = this.getAudioTime(l);
                        return 10;
                    }
                }
            }
            ++n2;
        }
        return -1;
    }

    private int scanDtsAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(6);
        int n2 = 0;
        while (n2 < n) {
            block9: {
                if (this.Audio.parseHeader(byArray, n2) >= 1) {
                    int n3 = 0;
                    while (n3 < 15) {
                        if (this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize() + n3) == 1) {
                            if ((0xFF & byArray[n2 + this.Audio.getSize()]) <= 127 && (0xFF & byArray[n2 + this.Audio.getSize()]) != 0) {
                                if (bl) {
                                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                                    this.playtime = this.getAudioTime(l);
                                }
                                if (n3 == 0) {
                                    return 12;
                                }
                                return 13;
                            }
                            break block9;
                        }
                        ++n3;
                    }
                    if (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces)) {
                        if (bl) {
                            this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                        }
                        this.playtime = this.getAudioTime(l);
                        return 12;
                    }
                }
            }
            ++n2;
        }
        return -1;
    }

    private int scanMpg12(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = CommonParsing.validateStartcode(byArray, n3);
            if (n4 < 0 || CommonParsing.getPES_IdField(byArray, n3) != 186) {
                n3 += (n4 < 0 ? -n4 : 4) - 1;
            } else {
                int n5;
                int n6 = 0xC0 & byArray[n3 + 4];
                if (n6 == 0) {
                    n5 = n3 + 12;
                    if (CommonParsing.validateStartcode(byArray, n5) >= 0 && CommonParsing.getPES_IdField(byArray, n5) >= 179) {
                        if (bl) {
                            this.loadMPG2(byArray, n3, false, true, bl2, n2);
                        }
                        return 2;
                    }
                } else if (n6 == 64 && CommonParsing.validateStartcode(byArray, n5 = n3 + 14 + (7 & byArray[n3 + 13])) >= 0 && CommonParsing.getPES_IdField(byArray, n5) >= 179) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, Common.getSettings().getBooleanProperty(Keys.KEY_simpleMPG), false, bl2, n2);
                    }
                    return 3;
                }
            }
            ++n3;
        }
        return -1;
    }

    private int scanMpgAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(2);
        int n2 = 0;
        while (n2 < n) {
            if (this.Audio.parseHeader(byArray, n2) >= 1 && (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces) || this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize()) >= 0) && (Common.getSettings().getBooleanProperty(Keys.KEY_AudioPanel_allowSpaces) || this.Audio.parseNextHeader(byArray, n2 + this.Audio.getSize() + this.Audio.getNextSize()) >= 0)) {
                if (bl) {
                    this.audio_streams.add(this.Audio.saveAndDisplayHeader());
                    this.playtime = this.getAudioTime(l);
                }
                return 9;
            }
            ++n2;
        }
        return -1;
    }

    private int scanMpgVideo(byte[] byArray, int n, boolean bl) throws Exception {
        if (this.checkVid(byArray, n)) {
            return 8;
        }
        return -1;
    }

    private int scanPVA(byte[] byArray, int n, boolean bl) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (byArray[n2] == 65 && byArray[n2 + 1] == 86 && byArray[n2 + 4] == 85 && byArray[n3 = n2 + 8 + ((0xFF & byArray[n2 + 6]) << 8 | 0xFF & byArray[n2 + 7])] == 65 && byArray[n3 + 1] == 86 && byArray[n3 + 4] == 85) {
                if (bl) {
                    this.loadPVA(byArray, n2);
                }
                return 4;
            }
            ++n2;
        }
        return -1;
    }

    private int scanPjxOwn(XInputFile xInputFile, byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n2 < 16) {
            if (byArray[n2] != CommonParsing.PTSVideoHeader[n2]) {
                return -1;
            }
            ++n2;
        }
        int n3 = (int)xInputFile.length();
        byte[] byArray2 = new byte[n3];
        xInputFile.randomAccessSingleRead(byArray2, 0L);
        long l = CommonParsing.readPTS(byArray2, 16, 8, false, false);
        long l2 = CommonParsing.readPTS(byArray2, n3 - 24, 8, false, false);
        long l3 = CommonParsing.readPTS(byArray2, 32, 8, false, false);
        long l4 = CommonParsing.readPTS(byArray2, n3 - 8, 8, false, false);
        this.playtime = "Src  " + Common.formatTime_1(l / 90L) + " -- " + Common.formatTime_1(l2 / 90L);
        this.playtime = String.valueOf(this.playtime) + " /  Out  " + Common.formatTime_1(l3 / 90L) + " -- " + Common.formatTime_1(l4 / 90L);
        return 31;
    }

    private int scanPrimaryPES(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4 = CommonParsing.validateStartcode(byArray, n3);
            if (n4 < 0 || (0xF0 & CommonParsing.getPES_IdField(byArray, n3)) != 224) {
                n3 += (n4 < 0 ? -n4 : 4) - 1;
            } else {
                int n5 = n3 + 6 + CommonParsing.getPES_LengthField(byArray, n3);
                if (n5 == n3 + 6 && (0xC0 & byArray[n3 + 6]) == 128 && (0xC0 & byArray[n3 + 8]) == 0) {
                    this.addInfo = " !!(VPacketLengthField is 0)";
                    n5 = n3;
                    bl2 = true;
                }
                if (CommonParsing.validateStartcode(byArray, n5) >= 0) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, Common.getSettings().getBooleanProperty(Keys.KEY_enhancedPES) ^ true, false, bl2, n2);
                    }
                    return 1;
                }
            }
            ++n3;
        }
        return -1;
    }

    private int scanRiffAudio(byte[] byArray, int n, boolean bl, long l) throws Exception {
        this.Audio.setNewType(7);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.Audio.parseHeader(byArray, n2);
            if (n3 > -1) {
                this.Audio.saveHeader();
                if (bl) {
                    this.audio_streams.add(this.Audio.displayHeader());
                    this.playtime = this.getAudioTime(l);
                }
                if (n3 > 0) {
                    return 14;
                }
                if (this.Audio.getLastModeExtension() > 1) break;
                return 15;
            }
            ++n2;
        }
        return -1;
    }

    private int scanSecondaryPES(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = CommonParsing.validateStartcode(byArray, n3);
            if (n5 < 0) {
                n3 += -n5 - 1;
            } else if (((0xE0 & byArray[n3 + 3]) == 192 || (0xFF & byArray[n3 + 3]) == 189) && CommonParsing.validateStartcode(byArray, n4 = n3 + 6 + CommonParsing.getPES_LengthField(byArray, n3)) >= 0) {
                if ((0xE0 & byArray[n3 + 3]) == 192 && (0xE0 & byArray[n3 + 3]) == (0xE0 & byArray[n4 + 3])) {
                    if (bl) {
                        this.loadMPG2(byArray, n3, true, false, bl2, n2);
                    }
                    return 6;
                }
                if ((0xFF & byArray[n3 + 3]) == 189 && ((0xFF & byArray[n4 + 3]) == 189 || (0xFF & byArray[n4 + 3]) == 190)) {
                    if (bl) {
                        if (byArray[n3 + 8] == 36 && (0xF0 & byArray[n3 + 9 + 36]) >>> 4 == 1) {
                            this.addInfo = " (TTX)";
                            this.ttx_streams.add("SubID 0x" + Integer.toHexString(0xFF & byArray[n3 + 9 + 36]).toUpperCase());
                        } else {
                            this.loadMPG2(byArray, n3, true, false, bl2, n2);
                        }
                    }
                    return 7;
                }
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private int scanSubpicture(byte[] var1_1, int var2_2, boolean var3_3, String var4_4) throws Exception {
        var5_5 = 0;
        while (var5_5 < var2_2) {
            block9: {
                block10: {
                    if (var1_1[var5_5] != 83 || var1_1[var5_5 + 1] != 80) break block9;
                    var6_6 = (255 & var1_1[var5_5 + 10]) << 8 | 255 & var1_1[var5_5 + 11];
                    var7_7 = (255 & var1_1[var5_5 + 12]) << 8 | 255 & var1_1[var5_5 + 13];
                    var8_8 = (255 & var1_1[var5_5 + 12 + var7_7]) << 8 | 255 & var1_1[var5_5 + 13 + var7_7];
                    if ((255 & var1_1[var5_5 + var6_6 + 9]) != 255) break block9;
                    if (!var3_3) break block10;
                    var10_9 = var5_5 + 14 + var7_7;
                    var11_10 = var10_9 + 24;
                    var12_11 = var10_9;
                    block8: while (var12_11 < var11_10) {
                        switch (255 & var1_1[var12_11]) {
                            case 1: {
                                ++var12_11;
                                ** GOTO lbl33
                            }
                            case 2: {
                                var12_11 += 24;
                                ** GOTO lbl33
                            }
                            case 3: 
                            case 4: {
                                var12_11 += 2;
                                ** GOTO lbl33
                            }
                            case 6: {
                                var12_11 += 4;
                                ** GOTO lbl33
                            }
                            case 5: {
                                var13_12 = (255 & var1_1[++var12_11]) << 4 | (240 & var1_1[++var12_11]) >>> 4;
                                var14_13 = (15 & var1_1[var12_11]) << 8 | 255 & var1_1[++var12_11];
                                var15_14 = (255 & var1_1[++var12_11]) << 4 | (240 & var1_1[++var12_11]) >>> 4;
                                var16_15 = (15 & var1_1[var12_11]) << 8 | 255 & var1_1[++var12_11];
                                this.pic_streams.add("up.left x" + var13_12 + ",y" + var15_14 + " @ size " + (var14_13 - var13_12 + 1) + "*" + (var16_15 - var15_14 + 1));
lbl33:
                                // 5 sources

                                ++var12_11;
                                continue block8;
                            }
                        }
                    }
                    var17_16 = new byte[10 + var6_6];
                    System.arraycopy(var1_1, var5_5, var17_16, 0, 10 + var6_6);
                    Common.getSubpictureClass().setColorTable(this.setIFOColorTable(var4_4));
                    Common.getSubpictureClass().decode_picture(var17_16, 10, true, new String[2]);
                }
                return 16;
            }
            ++var5_5;
        }
        return -1;
    }

    private int scanTS(byte[] byArray, int n, boolean bl) throws Exception {
        int n2 = 0;
        int n3 = 188;
        while (n2 < n) {
            if (byArray[n2] == 71 && byArray[n2 + n3] == 71 && byArray[n2 + n3 * 2] == 71 && byArray[n2 + n3 * 3] == 71 && byArray[n2 + n3 * 4] == 71 && byArray[n2 + n3 * 5] == 71 && byArray[n2 + n3 * 6] == 71) {
                this.readPMT(byArray, n2, 0);
                if (this.pidlist.isEmpty()) {
                    this.scanTSPids(byArray, n2, n, 0, bl);
                }
                return this.scanTSSubtype(byArray, n);
            }
            ++n2;
        }
        int n4 = 0;
        int n5 = 192;
        while (n4 < n) {
            if (byArray[n4] == 71 && byArray[n4 + n5] == 71 && byArray[n4 + n5 * 2] == 71 && byArray[n4 + n5 * 3] == 71 && byArray[n4 + n5 * 4] == 71 && byArray[n4 + n5 * 5] == 71 && byArray[n4 + n5 * 6] == 71) {
                this.readPMT(byArray, n4, 4);
                if (this.pidlist.isEmpty()) {
                    this.scanTSPids(byArray, n4, n, 4, bl);
                }
                return 1285;
            }
            ++n4;
        }
        return -1;
    }

    private void scanTSPids(byte[] byArray, int n, int n2, int n3, boolean bl) throws Exception {
        int n4 = 188 + n3;
        while (n < n2) {
            if (byArray[n] == 71 && byArray[n + n4] == 71 && byArray[n + n4 * 2] == 71) {
                int n5 = (0x1F & byArray[n + 1]) << 8 | 0xFF & byArray[n + 2];
                int n6 = (0xC0 & byArray[n + 3]) >>> 6;
                n += n4 - 1;
                String string = "PID 0x" + Integer.toHexString(n5).toUpperCase();
                if (n6 > 0) {
                    string = String.valueOf(string) + "-($)";
                }
                if (!this.video_streams.contains(string)) {
                    this.video_streams.add(string);
                }
            }
            ++n;
        }
        this.addInfo = String.valueOf(this.addInfo) + " (no PMT found)";
    }

    private int scanTSSubtype(byte[] byArray, int n) {
        if (byArray[0] == 84 && byArray[1] == 70 && byArray[2] == 114 && byArray[3] == 99 && byArray[4] == 80 && byArray[5] == 0) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 52;
            byte by = byArray[n5 + 1];
            long l = byArray[n5 + 4] << 24 | byArray[n5 + 5] << 16 | byArray[n5 + 6] << 8 | byArray[n5 + 7];
            int n6 = byArray[n5 + 8] << 8 | byArray[n5 + 9];
            n2 = (by & 0x6F) == 0 ? ++n2 : --n2;
            n2 = n6 > 2000 && n6 < 30000 ? ++n2 : --n2;
            n2 = n6 > 10000 && n6 < 13000 ? ++n2 : --n2;
            byte by2 = byArray[n5 + 2];
            l = byArray[n5 + 4] << 24 | byArray[n5 + 5] << 16 | byArray[n5 + 6] << 8 | byArray[n5 + 7];
            byte by3 = byArray[n5 + 10];
            if (by2 >= 6 && by2 <= 8) {
                ++n3;
            }
            if (l >= 174000L && l <= 230000L || l >= 470000L && l <= 862000L) {
                ++n3;
            }
            if ((by3 & 0xFE) == 0) {
                ++n3;
            }
            l = byArray[n5] << 24 | byArray[n5 + 1] << 16 | byArray[n5 + 2] << 8 | byArray[n5 + 3];
            n6 = byArray[n5 + 4] << 8 | byArray[n5 + 5];
            byte by4 = byArray[n5 + 10];
            if (l >= 47000L && l <= 862000L) {
                ++n4;
            }
            if (n6 > 2000 && n6 < 30000) {
                ++n4;
            }
            if (by4 <= 4) {
                ++n4;
            }
            if (n2 >= n4 && n2 >= n3) {
                return 261;
            }
            if (n3 > n4) {
                return 261;
            }
            return 517;
        }
        if (byArray[0] != 71 && byArray[188] != 71 && byArray[376] != 71 && byArray[564] == 71 && byArray[752] == 71 && byArray[940] == 71) {
            return 773;
        }
        int n7 = 0;
        int n8 = n - 10;
        while (n7 < n8) {
            if (byArray[n7] == 91 && byArray[n7 + 1] == 72 && byArray[n7 + 2] == 79 && byArray[n7 + 3] == 74 && byArray[n7 + 4] == 73 && byArray[n7 + 5] == 78 && byArray[n7 + 6] == 32 && byArray[n7 + 7] == 65) {
                return 1029;
            }
            ++n7;
        }
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 1 && byArray[3] == -70 && byArray[14] == 0 && byArray[15] == 0 && byArray[16] == 1 && byArray[17] == -65) {
            return 1541;
        }
        return 5;
    }

    private int[] setIFOColorTable(String string) {
        try {
            String string2 = String.valueOf(string) + ".IFO";
            File file = new File(string2);
            if (!file.exists() && !(file = new File(String.valueOf(string.substring(0, string.lastIndexOf("."))) + ".IFO")).exists()) {
                return null;
            }
            XInputFile xInputFile = new XInputFile(file);
            byte[] byArray = new byte[64];
            int[] nArray = new int[16];
            xInputFile.randomAccessSingleRead(byArray, 4276L);
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                nArray[n] = this.YUVtoRGB(CommonParsing.getIntValue(byArray, n * 4, 4, false));
                ++n;
            }
            return nArray;
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
    }

    private int testFile(XInputFile xInputFile, boolean bl, int n) {
        long l = xInputFile.length();
        int n2 = this.testFile(xInputFile, bl, 0L, n);
        if (n2 != 0) {
            return n2;
        }
        return this.testFile(xInputFile, bl, l / 10L, n);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int testFile(XInputFile xInputFile, boolean bl, long l, int n) {
        this.video_streams.clear();
        this.audio_streams.clear();
        this.ttx_streams.clear();
        this.pic_streams.clear();
        this.unknown_streams.clear();
        this.pidlist.clear();
        this.addInfo = "";
        this.playtime = "";
        this.hasVideo = false;
        long l2 = 0L;
        int n2 = Integer.parseInt(Common.getSettings().getProperty(Keys.KEY_ScanBuffer));
        if (n2 <= 0) {
            n2 = 1024000;
        }
        int n3 = n2 / 100;
        int n4 = n2 / 50;
        int n5 = n2 / 10;
        int n6 = n2 / 4;
        int n7 = n2 - 65536;
        byte[] byArray = new byte[n2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n8;
            l2 = xInputFile.length();
            XInputFile xInputFile2 = xInputFile.getNewInstance();
            if (xInputFile2 == null) {
                return 0;
            }
            xInputFile2.randomAccessSingleRead(byArray, l);
            int n9 = -1;
            int[] nArray = new int[18];
            nArray[0] = -1;
            nArray[1] = -1;
            nArray[2] = 5;
            nArray[3] = 4;
            nArray[4] = 4;
            nArray[5] = 3;
            nArray[6] = 2;
            nArray[7] = 6;
            nArray[8] = 6;
            nArray[9] = 10;
            nArray[10] = 9;
            nArray[11] = 8;
            nArray[12] = 8;
            nArray[13] = 7;
            nArray[14] = 7;
            nArray[17] = 11;
            int[] nArray2 = nArray;
            int n10 = n8 = nArray2[n + 1];
            block16: while (n9 < 0) {
                n9 = this.scanPjxOwn(xInputFile2, byArray, n3);
                if (n9 != -1) break;
                int n11 = Integer.MIN_VALUE;
                block17: do {
                    switch (n11 == Integer.MIN_VALUE ? n10 : n11) {
                        case 0: {
                            n9 = this.scanRiffAudio(byArray, n3, bl, l2);
                            n11 = -1;
                            continue block17;
                        }
                        case 2: {
                            n9 = this.scanTS(byArray, n7, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 3: {
                            n9 = this.scanPVA(byArray, n4, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 4: {
                            n9 = this.scanMpg12(byArray, n5, n4, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 5: {
                            n9 = this.scanPrimaryPES(byArray, n7, n6, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 6: {
                            n9 = this.scanSecondaryPES(byArray, n5, n6, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 7: {
                            n9 = this.scanDtsAudio(byArray, n4, bl, l2);
                            n11 = -1;
                            continue block17;
                        }
                        case 8: {
                            n9 = this.scanAc3Audio(byArray, n4, bl, l2);
                            n11 = -1;
                            continue block17;
                        }
                        case 9: {
                            n9 = this.scanMpgAudio(byArray, n4, bl, l2);
                            n11 = -1;
                            continue block17;
                        }
                        case 10: {
                            n9 = this.scanMpgVideo(byArray, n6, bl);
                            n11 = -1;
                            continue block17;
                        }
                        case 11: {
                            n9 = this.scanSubpicture(byArray, n3, bl, xInputFile2.toString());
                        }
                        case -1: 
                        case 1: {
                            if (n != -1) {
                                n9 = n;
                            }
                            ++n10;
                            continue block16;
                        }
                    }
                    break block16;
                } while (true);
            }
            byArray = null;
            if (n9 <= 0) return 0;
            return n9;
        }
        catch (Exception exception) {
            this.playtime = this.msg_8;
            Common.setExceptionMessage(exception);
        }
        return 0;
    }

    private class ScanObject {
        private ByteArrayOutputStream buf = new ByteArrayOutputStream();
        private int id;
        private int type;

        private ScanObject() {
            this.id = 0;
        }

        private ScanObject(int n) {
            this.id = n;
        }

        /* synthetic */ ScanObject(1 var2_2, int n) {
            this(n);
        }

        private byte[] getData() throws IOException {
            this.buf.flush();
            return this.buf.toByteArray();
        }

        private int getType() {
            return this.type;
        }

        private void reset() {
            this.buf.reset();
        }

        private void write(byte[] byArray) throws IOException {
            this.buf.write(byArray);
        }

        private void write(byte[] byArray, int n, int n2) throws IOException {
            this.buf.write(byArray, n, n2);
        }
    }
}

