/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StripAudio {
    private byte[] DD_header;
    private byte[] DTS44_header;
    private byte[] DTS48_header;
    private boolean isAC3;
    private boolean isDTS;
    private boolean isDTS48;
    private long val;

    public StripAudio() {
        byte[] byArray = new byte[8];
        byArray[0] = 114;
        byArray[1] = -8;
        byArray[2] = 31;
        byArray[3] = 78;
        byArray[4] = 1;
        this.DD_header = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = 31;
        byArray2[3] = -24;
        this.DTS44_header = byArray2;
        this.DTS48_header = new byte[]{-2, 127, 1, -128};
        this.isAC3 = false;
        this.isDTS = false;
        this.isDTS48 = false;
    }

    private XInputFile finish(String string, String string2) {
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        Common.renameTo(new File(string), file);
        return new XInputFile(file);
    }

    private boolean getAC3(byte[] byArray) {
        int n = 0;
        while (n < 6) {
            if (this.DD_header[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean getDTS(byte[] byArray) {
        if (!this.isDTS) {
            this.isDTS48 = this.getDTS48(byArray);
        }
        if (this.isDTS48) {
            return this.getDTS48(byArray);
        }
        int n = 0;
        while (n < 4) {
            if (this.DTS44_header[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean getDTS48(byte[] byArray) {
        int n = 0;
        while (n < 4) {
            if (this.DTS48_header[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public XInputFile process(XInputFile xInputFile) {
        String string = String.valueOf(xInputFile.toString()) + "[stripped].$es$";
        try {
            int n;
            PushbackInputStream pushbackInputStream = new PushbackInputStream(xInputFile.getInputStream(), 8);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), 5096000);
            int n2 = 0;
            byte[] byArray = new byte[6144];
            pushbackInputStream.skip(44L);
            while ((n = pushbackInputStream.read(byArray, 0, 8)) >= 8) {
                int n3;
                if (!this.verifyHeader(byArray)) {
                    pushbackInputStream.unread(byArray, 1, 7);
                    continue;
                }
                if (this.isAC3) {
                    n3 = (0xFF & byArray[7]) << 8 | 0xFF & byArray[6];
                    n = pushbackInputStream.read(byArray, 8, n3 >>>= 3);
                    ++n2;
                    if (n < n3) {
                        Common.setMessage("!> not enough data in sector " + n2 + ", dropped..", true);
                        continue;
                    }
                    Common.changeByteOrder(byArray, 8, n3 + 8);
                    bufferedOutputStream.write(byArray, 8, n3);
                    pushbackInputStream.skip(6144 - n3 - 8);
                    continue;
                }
                if (!this.isDTS) continue;
                n3 = 4096;
                n = pushbackInputStream.read(byArray, 8, n3 - 8);
                ++n2;
                if (n < n3 - 8) {
                    Common.setMessage("!> not enough data in sector " + n2 + ", dropped..", true);
                    continue;
                }
                int n4 = 0;
                if (!this.isDTS48) {
                    int n5 = 0;
                    while (n5 < n3) {
                        this.val = (0xFFL & (long)byArray[n5]) << 42;
                        this.val |= (0x3FL & (long)byArray[n5 + 1]) << 50;
                        this.val |= (0xFFL & (long)byArray[n5 + 2]) << 28;
                        this.val |= (0x3FL & (long)byArray[n5 + 3]) << 36;
                        this.val |= (0xFFL & (long)byArray[n5 + 4]) << 14;
                        this.val |= (0x3FL & (long)byArray[n5 + 5]) << 22;
                        this.val |= 0xFFL & (long)byArray[n5 + 6];
                        this.val |= (0x3FL & (long)byArray[n5 + 7]) << 8;
                        CommonParsing.setValue(byArray, n4, 7, false, this.val);
                        n5 += 8;
                        n4 += 7;
                    }
                } else {
                    n4 = n3;
                    Common.changeByteOrder(byArray, 0, n3);
                }
                bufferedOutputStream.write(byArray, 0, n4);
            }
            pushbackInputStream.close();
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return null;
        }
        if (this.isAC3) {
            return this.finish(string, String.valueOf(xInputFile.toString()) + "[stripped].ac3");
        }
        if (this.isDTS) {
            return this.finish(string, String.valueOf(xInputFile.toString()) + "[stripped].dts");
        }
        return null;
    }

    private boolean verifyHeader(byte[] byArray) {
        if (!this.isAC3 && !this.isDTS) {
            this.isAC3 = this.getAC3(byArray);
            if (!this.isAC3) {
                this.isDTS = this.getDTS(byArray);
            }
        }
        if (this.isAC3) {
            return this.getAC3(byArray);
        }
        if (this.isDTS) {
            return this.getDTS(byArray);
        }
        return false;
    }
}

