/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.subtitle.Bitmap;
import net.sourceforge.dvb.projectx.subtitle.ColorAreas;
import net.sourceforge.dvb.projectx.subtitle.DVBSubpicture;

public class Subpicture {
    private int w = Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_enableHDSub) ? 1920 : 720;
    private int h = Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_enableHDSub) ? 1088 : 576;
    private int x = 20;
    private int nibble = 0;
    private int val = 0;
    private int default_alpha = 10;
    private int modified_alpha = 0;
    private BufferedImage bimg;
    private Graphics2D big;
    private Font font;
    private Font font_std;
    private FontRenderContext frc;
    private final int[] default_teletext_colors;
    private final int[] default_sup_colors;
    private int[] alternative_sup_colors;
    private Object[] str;
    private byte[] RLEheader;
    private byte[] sections;
    private ByteArrayOutputStream out;
    private byte[] newline;
    private int[] Rect;
    private int[] pos;
    private int[] option;
    private int[] standard_values;
    private int isforced_status;
    private int ismulticolor_status;
    private int line_offset;
    private ArrayList user_color_table;
    private Bitmap bitmap;
    private boolean read_from_Image;
    private boolean global_error;
    private int X_Offset;
    private int Y_Offset;
    private int DisplayMode;
    public DVBSubpicture dvb;
    public ColorAreas s9CA;

    public Subpicture() {
        int[] nArray = new int[66];
        nArray[0] = -10461088;
        nArray[1] = -1351584;
        nArray[2] = -15668464;
        nArray[3] = -1316080;
        nArray[4] = -11513621;
        nArray[5] = -1351445;
        nArray[6] = -15668245;
        nArray[7] = -1315861;
        nArray[8] = -10461088;
        nArray[9] = -2072480;
        nArray[10] = -10428320;
        nArray[11] = -2039712;
        nArray[12] = -10460960;
        nArray[13] = -2072352;
        nArray[14] = -10428192;
        nArray[15] = -2039584;
        nArray[16] = -9408400;
        nArray[17] = -3116944;
        nArray[18] = -9383824;
        nArray[19] = -3092368;
        nArray[20] = -9408304;
        nArray[21] = -3116848;
        nArray[22] = -9383728;
        nArray[23] = -3092272;
        nArray[24] = -8355712;
        nArray[25] = -4161408;
        nArray[26] = -8339328;
        nArray[27] = -4145024;
        nArray[28] = -8355648;
        nArray[29] = -4161344;
        nArray[30] = -8339264;
        nArray[31] = -4144960;
        nArray[32] = -7303024;
        nArray[33] = -4157296;
        nArray[34] = -7290736;
        nArray[35] = -4145008;
        nArray[36] = -7302976;
        nArray[37] = -4157248;
        nArray[38] = -7290688;
        nArray[39] = -5197648;
        nArray[40] = -6250336;
        nArray[41] = -5201760;
        nArray[42] = -6246240;
        nArray[43] = -5197664;
        nArray[44] = -6250320;
        nArray[45] = -5201744;
        nArray[46] = -6246224;
        nArray[47] = -6250336;
        nArray[48] = -5197648;
        nArray[49] = -4153184;
        nArray[50] = -6238048;
        nArray[51] = -4140896;
        nArray[52] = -6250288;
        nArray[53] = -3104560;
        nArray[54] = -6238000;
        nArray[55] = -7303024;
        nArray[56] = -3092272;
        nArray[57] = -2060144;
        nArray[58] = -7282544;
        nArray[59] = -2039664;
        nArray[60] = -7302944;
        nArray[61] = -2060064;
        nArray[62] = -7282464;
        nArray[63] = -8355712;
        nArray[65] = 128;
        this.default_teletext_colors = nArray;
        int[] nArray2 = new int[17];
        nArray2[0] = -15724528;
        nArray2[1] = -6250336;
        nArray2[2] = -1315861;
        nArray2[3] = -10461088;
        nArray2[4] = -1372144;
        nArray2[5] = -15668464;
        nArray2[6] = -1316080;
        nArray2[7] = -15724309;
        nArray2[8] = -1371925;
        nArray2[9] = -15668245;
        nArray2[10] = -1343360;
        nArray2[11] = -8328320;
        nArray2[12] = -1315968;
        nArray2[13] = -8355605;
        nArray2[14] = -1343253;
        nArray2[15] = -8328213;
        this.default_sup_colors = nArray2;
        this.alternative_sup_colors = new int[17];
        this.str = new Object[0];
        byte[] byArray = new byte[14];
        byArray[0] = 83;
        byArray[1] = 80;
        this.RLEheader = byArray;
        byte[] byArray2 = new byte[28];
        byArray2[2] = 3;
        byArray2[3] = 50;
        byArray2[4] = 16;
        byArray2[5] = 4;
        byArray2[6] = -1;
        byArray2[7] = -6;
        byArray2[8] = 5;
        byArray2[15] = 6;
        byArray2[20] = 1;
        byArray2[21] = -1;
        byArray2[22] = 1;
        byArray2[23] = 80;
        byArray2[26] = 2;
        byArray2[27] = -1;
        this.sections = byArray2;
        this.out = new ByteArrayOutputStream();
        this.newline = new byte[2];
        this.Rect = new int[4];
        this.pos = new int[4];
        this.option = new int[11];
        this.standard_values = new int[]{26, 10, 32, 80, 560, 720, 576, -1, 4, 3, 1};
        this.isforced_status = 0;
        this.ismulticolor_status = 0;
        this.line_offset = 28;
        this.user_color_table = new ArrayList();
        this.read_from_Image = false;
        this.global_error = false;
        this.X_Offset = 0;
        this.Y_Offset = 0;
        this.DisplayMode = 0;
        this.dvb = new DVBSubpicture();
        this.s9CA = new ColorAreas();
        this.bimg = new BufferedImage(this.w, this.h, 1);
        this.big = this.bimg.createGraphics();
        this.set("Tahoma", "26;10;32;80;560;720;576;-1;4;3;1");
        this.frc = this.big.getFontRenderContext();
    }

    private void Flush_Bits(int[] nArray, int n) {
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
    }

    private int Get_Bits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[1] >>> 3;
        if (n2 >= byArray.length) {
            this.global_error = true;
            nArray[1] = nArray[1] + n;
            nArray[0] = nArray[1] >>> 3;
            return 0;
        }
        int n3 = (0xFF & byArray[n2++]) << 24;
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 16;
        }
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 8;
        }
        if (n2 < byArray.length) {
            n3 |= 0xFF & byArray[n2];
        }
        n3 <<= nArray[1] & 7;
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
        return n3 >>>= 32 - n;
    }

    private void Set_Bits(byte[] byArray, int[] nArray, int n, int n2) {
        int n3 = nArray[1] >>> 3;
        int n4 = nArray[1] & 7;
        if (n3 >= byArray.length || n4 + n >= (nArray[1] & 0xFFFFFFF8) + 32) {
            this.global_error = true;
        } else {
            int n5 = 1 + (n4 + n - 1 >>> 3);
            int n6 = n5 << 3;
            int n7 = CommonParsing.getIntValue(byArray, n3, n5, false);
            int n8 = -1 >>> 32 - n;
            int n9 = n6 - n - n4;
            n7 &= ~(n8 <<= n9);
            CommonParsing.setValue(byArray, n3, n5, false, n7 |= (n2 <<= n9) & n8);
        }
        nArray[1] = nArray[1] + n;
        nArray[0] = nArray[1] >>> 3;
    }

    private int Show_Bits(byte[] byArray, int[] nArray, int n) {
        int n2 = nArray[1] >>> 3;
        if (n2 >= byArray.length) {
            this.global_error = true;
            return 0;
        }
        int n3 = (0xFF & byArray[n2++]) << 24;
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 16;
        }
        if (n2 < byArray.length) {
            n3 |= (0xFF & byArray[n2++]) << 8;
        }
        if (n2 < byArray.length) {
            n3 |= 0xFF & byArray[n2];
        }
        n3 <<= nArray[1] & 7;
        return n3 >>>= 32 - n;
    }

    private void alignRLE() {
        if (this.nibble == 0) {
            return;
        }
        this.out.write((byte)this.val);
        this.nibble = 0;
        this.val = 0;
    }

    private void align_Bits(int[] nArray) {
        if ((1 & nArray[1] >>> 2) != 0) {
            this.Flush_Bits(nArray, 4);
        }
    }

    private void buildImgTTX(Object object) {
        boolean bl;
        int n;
        int n2;
        int n3 = 6;
        this.Rect[0] = this.option[3];
        this.Rect[3] = 2 * n3 + this.line_offset * this.str.length;
        this.Rect[1] = this.option[6] - this.option[2] - this.Rect[3];
        this.Rect[2] = this.option[4];
        this.pos[0] = this.Rect[0];
        this.pos[1] = this.Rect[1];
        this.pos[2] = this.Rect[0] + this.Rect[2] - 1;
        this.pos[3] = this.Rect[1] + this.Rect[3] - 1;
        this.paintVideoSize(object);
        this.big.setColor(Color.white);
        this.big.drawRect(this.Rect[0] - 1, this.Rect[1] - 1, this.Rect[2] + 1, this.Rect[3] + 1);
        this.big.setFont(this.font_std);
        this.big.drawString("x" + this.pos[0] + ", y" + this.pos[1] + " / " + (this.pos[2] - this.pos[0] + 1) + "*" + (this.pos[3] - this.pos[1] + 1), this.Rect[0] - 1, this.Rect[1] - 5);
        int[] nArray = this.getColorTable(1);
        this.big.setFont(this.font);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (n4 < this.str.length) {
            int[] nArray2 = (int[])this.str[n4];
            n2 = 0;
            while (n2 < nArray2.length) {
                n = (7 & nArray2[n2] >>> 4) << 3;
                int n5 = nArray[n + (7 & nArray2[n2])];
                String string = Integer.toString(n5);
                String string2 = new Character((char)(nArray2[n2] >>> 8)).toString();
                if (arrayList.indexOf(string) < 0 && !string2.equals(" ")) {
                    arrayList.add(string);
                }
                ++n2;
            }
            ++n4;
        }
        if (arrayList.size() < 3 && Common.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_useTextOutline)) {
            this.big.setColor(new Color(nArray[65]));
            this.modified_alpha = 0;
            bl = true;
        } else {
            this.big.setColor(new Color(nArray[64]));
            this.modified_alpha = this.default_alpha;
            bl = false;
        }
        this.big.fillRect(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3]);
        n2 = 0;
        while (bl && n2 < this.str.length) {
            int[] nArray3 = (int[])this.str[n2];
            String string = "";
            this.big.setColor(new Color(nArray[64]));
            int n6 = 0;
            while (n6 < nArray3.length) {
                string = String.valueOf(string) + new Character((char)(nArray3[n6] >>> 8)).toString();
                ++n6;
            }
            this.x = this.option[3];
            int n7 = this.Rect[1] + this.line_offset * (1 + n2);
            int[] nArray4 = new int[this.option[9] * 2 + 1];
            int n8 = this.option[9] - 1;
            nArray4[nArray4.length - 1] = n8;
            nArray4[0] = n8;
            Arrays.fill(nArray4, 1, nArray4.length - 1, this.option[9]);
            int n9 = 0;
            while (n9 < nArray4.length) {
                int n10 = this.x;
                int n11 = n7 - nArray4.length / 2 + n9;
                int n12 = -nArray4[n9];
                while (n12 < nArray4[n9] + 1) {
                    this.big.drawString(string, n10 + n12, n11);
                    ++n12;
                }
                ++n9;
            }
            ++n2;
        }
        n = 0;
        while (n < this.str.length) {
            int[] nArray5 = (int[])this.str[n];
            this.x = this.option[3];
            int n13 = 0;
            while (n13 < nArray5.length) {
                int n14 = (7 & nArray5[n13] >>> 4) << 3;
                this.big.setColor(new Color(nArray[n14 + (7 & nArray5[n13])]));
                this.big.drawString(String.valueOf((char)(nArray5[n13] >>> 8)), this.x, this.Rect[1] + this.line_offset * (1 + n));
                this.x = (int)((double)this.x + this.font.getStringBounds(String.valueOf((char)(nArray5[n13] >>> 8)), this.frc).getWidth());
                ++n13;
            }
            ++n;
        }
    }

    private byte[] buildRLE() {
        byte[] byArray = null;
        try {
            int n;
            if (ColorAreas.active) {
                this.resetUserColorTable();
            }
            this.updateUserColorTable(this.bitmap.getPixel());
            if (ColorAreas.active) {
                this.s9CA.analyse(this.bitmap, this.getUserColorTable());
            }
            int[] nArray = this.bitmap.getPixel();
            this.out.reset();
            this.out.write(this.RLEheader);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n4 < 2) {
                n5 = 0;
                n8 = 0;
                n6 = n4 * this.bitmap.getWidth();
                while (n6 < nArray.length) {
                    n5 = 0;
                    n8 = 0;
                    n7 = 0;
                    while (n7 < this.bitmap.getWidth()) {
                        n3 = ColorAreas.active ? this.s9CA.bp12[n6 + n7] : nArray[n6 + n7];
                        if (ColorAreas.active && ColorAreas.dbgline() == n6 / this.bitmap.getWidth()) {
                            n = this.s9CA.getQuant(this.getUserColorTableIndex(nArray[n6 + n7]));
                            System.out.println("dbg line " + ColorAreas.d(3, n6 / this.bitmap.getWidth()) + "/x " + ColorAreas.d(3, n7) + "/pixel " + ColorAreas.X(8, nArray[n6 + n7]) + "/clr_ndx " + ColorAreas.X(2, n8) + "/pgc_clr " + ColorAreas.X(2, n3) + "/Q " + ColorAreas.X(8, n) + "/run " + ColorAreas.d(3, n5));
                        }
                        if (n3 != n8) {
                            this.updateRLE(n5, n8);
                            n8 = n3;
                            n5 = 0;
                        } else if (n5 > 254) {
                            this.updateRLE(n5, n8);
                            n5 = 0;
                        }
                        ++n7;
                        ++n5;
                    }
                    while (n5 > 255) {
                        this.updateRLE(255, n8);
                        n5 -= 255;
                    }
                    this.updateRLE(n5, n8);
                    this.alignRLE();
                    if (n7 < this.bitmap.getWidth()) {
                        this.out.write(this.newline);
                    }
                    n6 += 2 * this.bitmap.getWidth();
                }
                this.alignRLE();
                if (n2 == 0) {
                    n2 = this.out.size() - 10;
                }
                ++n4;
            }
            if (ColorAreas.active) {
                n = this.out.size() - 10;
                this.out.write(this.s9CA.commands(n, n2, this.bitmap));
                if ((this.out.size() & 1) == 1) {
                    this.out.write(-1);
                }
                this.out.flush();
                byArray = this.out.toByteArray();
                int n9 = byArray.length - 10;
                byArray[10] = (byte)(0xFF & n9 >>> 8);
                byArray[11] = (byte)(0xFF & n9);
                byArray[12] = (byte)(0xFF & n >>> 8);
                byArray[13] = (byte)(0xFF & n);
                int n10 = 0;
                while (n10 < 4) {
                    byArray[n10 + 2] = (byte)(0xFFL & this.bitmap.getInTime() >>> n10 * 8);
                    ++n10;
                }
            } else {
                this.out.write(this.newline);
                n = this.out.size() - 12;
                int n11 = n + 24;
                int n12 = this.out.size() + 22;
                this.setScreenPosition(this.bitmap.getX(), this.bitmap.getY(), this.bitmap.getMaxX() - 1, this.bitmap.getMaxY() - 1);
                this.setControlBlockPosition(n11, n2);
                this.setPGCsection();
                this.out.write(this.sections);
                if ((this.out.size() & 1) == 1) {
                    this.out.write(-1);
                }
                this.out.flush();
                byArray = this.out.toByteArray();
                int n13 = byArray.length - 10;
                byArray[10] = (byte)(0xFF & n13 >>> 8);
                byArray[11] = (byte)(0xFF & n13);
                byArray[12] = (byte)(0xFF & n >>> 8);
                byArray[13] = (byte)(0xFF & n);
                int n14 = 0;
                while (n14 < 4) {
                    byArray[n14 + 2] = (byte)(0xFFL & this.bitmap.getInTime() >>> n14 * 8);
                    ++n14;
                }
                byArray[n12] = (byte)(0xFF & this.bitmap.getPlayTime() >>> 8);
                byArray[n12 + 1] = (byte)(0xFF & this.bitmap.getPlayTime());
            }
            if (ColorAreas.dbgSub(1)) {
                this.s9CA.dumpHdrAndCmd(byArray);
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        this.read_from_Image = false;
        return byArray;
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object) {
        return this.decode_picture(byArray, n, bl, object, 0L, false, true);
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object, long l, boolean bl2, boolean bl3) {
        return this.decode_picture(byArray, n, bl, object, l, bl2, bl3, null, 0);
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object, long l, boolean bl2, boolean bl3, Image image, int n2) {
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        this.read_from_Image = false;
        this.global_error = false;
        boolean bl4 = false;
        int n11 = byArray.length;
        int[] nArray2 = new int[]{n, n << 3};
        int[] nArray3 = new int[4];
        int[] nArray4 = new int[3];
        int n12 = 0;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (nArray2[0] > n11) {
            return -4;
        }
        int n13 = this.Get_Bits(byArray, nArray2, 16);
        if (this.Show_Bits(byArray, nArray2, 24) == 15) {
            this.big.setFont(this.font_std);
            byte[] byArray2 = new byte[n11 + 4];
            System.arraycopy(byArray, 0, byArray2, 0, n11);
            int n14 = this.dvb.decodeDVBSubpicture(byArray2, nArray2, this.big, this.bimg, l, bl2, bl3);
            if (n14 > -2) {
                this.repaint();
            }
            return n14;
        }
        if (nArray2[0] + n13 != n11 + 2) {
            return -5;
        }
        nArray4[2] = this.Get_Bits(byArray, nArray2, 16) - 2;
        this.Flush_Bits(nArray2, nArray4[2] << 3);
        int n15 = this.Get_Bits(byArray, nArray2, 16);
        if (n15 == nArray4[2] + 2) {
            n15 = n13;
            bl4 = true;
            Common.setMessage(Resource.getString("subpicture.msg2"));
        } else {
            nArray4[2] = nArray4[2] + (n + 2);
        }
        int[] nArray5 = this.getColorTable(0);
        block11: while (nArray2[0] < n + n15) {
            n10 = this.Show_Bits(byArray, nArray2, 8);
            block0 : switch (n10) {
                case 0: {
                    int n16 = this.isforced_status = (this.isforced_status & 5) != 5 ? 4 : 5;
                    if (this.DisplayMode == 2) {
                        this.Set_Bits(byArray, nArray2, 8, 1);
                        break;
                    }
                    this.Flush_Bits(nArray2, 8);
                    break;
                }
                case 1: {
                    int n17 = this.isforced_status = (this.isforced_status & 3) != 3 ? 2 : 3;
                    if (this.DisplayMode == 1) {
                        this.Set_Bits(byArray, nArray2, 8, 0);
                        break;
                    }
                    this.Flush_Bits(nArray2, 8);
                    break;
                }
                case 2: {
                    this.Flush_Bits(nArray2, 8);
                    break;
                }
                case 3: {
                    this.Flush_Bits(nArray2, 8);
                    n12 |= 0xFFFF & this.Get_Bits(byArray, nArray2, 16);
                    break;
                }
                case 4: {
                    this.Flush_Bits(nArray2, 8);
                    n12 |= (0xFFFF & this.Get_Bits(byArray, nArray2, 16)) << 16;
                    break;
                }
                case 5: {
                    this.Flush_Bits(nArray2, 8);
                    if (this.X_Offset != 0) {
                        nArray3[0] = this.Show_Bits(byArray, nArray2, 12) + this.X_Offset;
                        this.Set_Bits(byArray, nArray2, 12, nArray3[0]);
                        nArray3[1] = this.Show_Bits(byArray, nArray2, 12) + this.X_Offset;
                        this.Set_Bits(byArray, nArray2, 12, nArray3[1]);
                    } else {
                        nArray3[0] = this.Get_Bits(byArray, nArray2, 12);
                        nArray3[1] = this.Get_Bits(byArray, nArray2, 12);
                    }
                    if (this.Y_Offset != 0) {
                        nArray3[2] = this.Show_Bits(byArray, nArray2, 12) + this.Y_Offset;
                        this.Set_Bits(byArray, nArray2, 12, nArray3[2]);
                        nArray3[3] = this.Show_Bits(byArray, nArray2, 12) + this.Y_Offset;
                        this.Set_Bits(byArray, nArray2, 12, nArray3[3]);
                        break;
                    }
                    nArray3[2] = this.Get_Bits(byArray, nArray2, 12);
                    nArray3[3] = this.Get_Bits(byArray, nArray2, 12);
                    break;
                }
                case 6: {
                    this.Flush_Bits(nArray2, 8);
                    n9 = 0;
                    while (n9 < 2) {
                        nArray4[n9] = this.Get_Bits(byArray, nArray2, 16);
                        ++n9;
                    }
                    continue block11;
                }
                case 7: {
                    this.Flush_Bits(nArray2, 8);
                    n9 = this.Get_Bits(byArray, nArray2, 16);
                    if (this.ismulticolor_status == 0) {
                        this.ismulticolor_status |= 1;
                        Common.setMessage("-> contains extra area definitions!");
                    }
                    n8 = 0;
                    n7 = nArray2[0] + n9;
                    while (nArray2[0] < n7) {
                        n8 = this.Show_Bits(byArray, nArray2, 32);
                        if (n8 == 0xFFFFFFF) {
                            this.Flush_Bits(nArray2, 32);
                            break block0;
                        }
                        if (this.Y_Offset != 0) {
                            n8 = 0xF000 & n8 | (0xFFF & n8 >> 16) + this.Y_Offset << 16 | (0xFFF & n8) + this.Y_Offset;
                            this.Set_Bits(byArray, nArray2, 32, n8);
                        } else {
                            this.Flush_Bits(nArray2, 32);
                        }
                        n6 = 0;
                        n5 = 0xF & n8 >> 12;
                        while (n6 < n5) {
                            nArray = new int[5];
                            nArray[0] = 0xFFF & n8 >> 16;
                            nArray[1] = 0xFFF & n8;
                            if (this.X_Offset != 0) {
                                nArray[2] = this.Show_Bits(byArray, nArray2, 16) + this.X_Offset;
                                this.Set_Bits(byArray, nArray2, 16, nArray[2]);
                            } else {
                                nArray[2] = this.Get_Bits(byArray, nArray2, 16);
                            }
                            nArray[3] = this.Get_Bits(byArray, nArray2, 16);
                            nArray[4] = this.Get_Bits(byArray, nArray2, 16);
                            arrayList.add(nArray);
                            ++n6;
                        }
                    }
                    continue block11;
                }
                case 255: {
                    this.Flush_Bits(nArray2, 8);
                    break;
                }
                default: {
                    Common.setMessage(String.valueOf(Resource.getString("subpicture.msg3")) + ": " + n10);
                    this.Flush_Bits(nArray2, 8);
                }
            }
        }
        if (n + n15 != nArray2[0]) {
            return -6;
        }
        n10 = 0;
        if (!bl4) {
            n10 = this.Get_Bits(byArray, nArray2, 16);
            if (n15 != this.Get_Bits(byArray, nArray2, 16)) {
                return -7;
            }
            if (this.Get_Bits(byArray, nArray2, 8) != 2) {
                return -8;
            }
            this.Flush_Bits(nArray2, (nArray2[0] & 1) != 1 ? 16 : 8);
        }
        if (nArray2[0] != n11) {
            return -9;
        }
        if (this.global_error) {
            return -3;
        }
        if (!bl) {
            return n10 * 1024;
        }
        n9 = 0;
        while (n9 < 2) {
            int n18 = n9++;
            nArray4[n18] = nArray4[n18] + n;
        }
        this.paintVideoSize(object);
        if (image != null) {
            n8 = Common.getMpvDecoderClass().getMpg2AspectRatioOffset();
            this.big.setColor(new Color(-11513776));
            this.big.fillRect(0, 0, this.w, this.h);
            n7 = 0xFFF & n2 >> 20;
            n6 = 0xFFF & n2 >> 8;
            if (n8 != 0) {
                this.big.drawImage(image, 0, 0, n7, n6, 64, 0, 448, 288, null);
            } else if ((n2 & 2) != 0) {
                n5 = (n6 - n6 * 3 / 4) / 2;
                this.big.drawImage(image, 0, n5, n7, n6 * 3 / 4, null);
            } else {
                this.big.drawImage(image, 0, 0, n7, n6, null);
            }
        }
        n8 = nArray3[0];
        n7 = nArray3[2];
        n6 = nArray3[1] - nArray3[0] + 1;
        n5 = nArray3[3] - nArray3[2] + 1;
        this.big.setColor(Color.white);
        this.big.drawRect(n8 - 1, n7 - 1, n6 + 1, n5 + 1);
        this.big.setFont(this.font_std);
        this.big.drawString("x" + n8 + ", y" + n7 + " / " + n6 + "*" + n5 + " , C-" + Common.adaptString(Integer.toHexString(0xFFFF & n12).toUpperCase(), 4) + ", T-" + Common.adaptString(Integer.toHexString(0xFFFF & n12 >> 16).toUpperCase(), 4), n8 + 1, n7 - 5);
        nArray = new int[n6 * n5];
        Arrays.fill(nArray, n12);
        int n19 = 0;
        while ((n2 & 8) == 0 && n19 < arrayList.size()) {
            int[] nArray6 = (int[])arrayList.get(n19);
            n4 = (nArray6[0] - n7) * n6;
            n3 = (nArray6[1] - n7) * n6;
            while (n4 < n3) {
                Arrays.fill(nArray, n4 + nArray6[2] - n8, n4 + n6, nArray6[3] | nArray6[4] << 16);
                n4 += n6;
            }
            ++n19;
        }
        int n20 = 0;
        while (n20 < 2) {
            n4 = 0;
            n3 = n8;
            int n21 = n7 + n20;
            nArray2[0] = nArray4[n20];
            nArray2[1] = nArray2[0] << 3;
            while (nArray2[0] < nArray4[n20 + 1]) {
                n4 = this.Get_Bits(byArray, nArray2, 4);
                if (n4 > 3) {
                    n3 = this.paintPixel(n4, n3, n21, nArray, nArray5, n8, n7, n6, n2);
                } else if ((n4 = n4 << 4 | this.Get_Bits(byArray, nArray2, 4)) > 15) {
                    n3 = this.paintPixel(n4, n3, n21, nArray, nArray5, n8, n7, n6, n2);
                } else if ((n4 = n4 << 4 | this.Get_Bits(byArray, nArray2, 4)) > 63) {
                    n3 = this.paintPixel(n4, n3, n21, nArray, nArray5, n8, n7, n6, n2);
                } else if ((n4 = n4 << 4 | this.Get_Bits(byArray, nArray2, 4)) > 3) {
                    n3 = this.paintPixel(n4, n3, n21, nArray, nArray5, n8, n7, n6, n2);
                } else {
                    if ((n4 & 3) != 0) {
                        n4 |= n6 - n3 << 2;
                        n3 = this.paintPixel(n4, n3, n21, nArray, nArray5, n8, n7, n6, n2);
                    }
                    n3 = n8;
                    n21 += 2;
                    this.align_Bits(nArray2);
                    continue;
                }
                if (n3 <= nArray3[1]) continue;
                n3 = nArray3[0];
                n21 += 2;
                this.align_Bits(nArray2);
            }
            ++n20;
        }
        n4 = arrayList.size() - 1;
        while ((n2 & 4) == 0 && n4 >= 0) {
            int[] nArray7 = (int[])arrayList.get(n4);
            this.big.setColor(Color.magenta);
            this.big.drawRect(nArray7[2] - 1, nArray7[0] - 1, n6 - nArray7[2] + n8 + 1, nArray7[1] - nArray7[0]);
            this.big.setColor(Color.yellow);
            this.big.drawString("area: " + n4 + " - " + nArray7[0] + ", " + nArray7[1] + ", " + nArray7[2] + ", C-" + Common.adaptString(Integer.toHexString(nArray7[3]).toUpperCase(), 4) + ", T-" + Common.adaptString(Integer.toHexString(nArray7[4]).toUpperCase(), 4), nArray3[0], n7 - 22 - n4 * 16);
            --n4;
        }
        this.repaint();
        if (this.global_error) {
            return -3;
        }
        return n10 * 1024;
    }

    public int decode_picture(byte[] byArray, int n, boolean bl, Object object, Image image, int n2) {
        return this.decode_picture(byArray, n, bl, object, 0L, false, true, image, n2);
    }

    public String getArea() {
        String string = "";
        string = String.valueOf(string) + "x " + this.Rect[0];
        string = String.valueOf(string) + " y " + this.Rect[1];
        string = String.valueOf(string) + " w " + this.Rect[2];
        string = String.valueOf(string) + " h " + this.Rect[3];
        string = String.valueOf(string) + " x1 " + this.pos[0];
        string = String.valueOf(string) + " y1 " + this.pos[1];
        string = String.valueOf(string) + " x2 " + this.pos[2];
        string = String.valueOf(string) + " y2 " + this.pos[3];
        return string;
    }

    public int[] getColorTable(int n) {
        if (n == 0) {
            if (this.alternative_sup_colors[0] == 0) {
                return this.default_sup_colors;
            }
            return this.alternative_sup_colors;
        }
        return this.default_teletext_colors;
    }

    public Image getImage() {
        return this.bimg;
    }

    public int getMaximumLines() {
        return this.option[8];
    }

    public Image getScaledImage(int n, int n2) {
        return this.bimg.getScaledInstance(n, n2, 2);
    }

    public ArrayList getUserColorTable() {
        return this.user_color_table;
    }

    public Object[] getUserColorTableArray() {
        return this.user_color_table.toArray();
    }

    private int getUserColorTableIndex(int n) {
        int n2 = this.user_color_table.indexOf(String.valueOf(n));
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    public String isForced_Msg() {
        return this.isForced_Msg(0);
    }

    public String isForced_Msg(int n) {
        String string = null;
        if ((this.isforced_status & 1) == 0 || n == 1) {
            string = (this.isforced_status & 2) > 0 ? Resource.getString("subpicture.msg.forced.no") : Resource.getString("subpicture.msg.forced.yes");
        }
        this.isforced_status |= 1;
        return string;
    }

    public void paintPicture(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        this.big.setColor(Color.gray);
        this.big.fillRect(0, 0, this.w, this.h);
        this.repaint();
    }

    private int paintPixel(int n, int n2, int n3, int[] nArray, int[] nArray2, int n4, int n5, int n6, int n7) {
        int n8 = n & 3;
        int n9 = n >>> 2;
        int n10 = 0;
        int n11 = 0;
        boolean bl = (n7 & 0x10) != 0;
        this.big.setColor(new Color(0));
        int n12 = n2 + n9;
        int n13 = 0;
        while (n2 < n12) {
            int n14 = (n3 - n5) * n6 + n2 - n4;
            if (n14 >= nArray.length) break;
            n10 = 0xF & nArray[n14] >> 16 + n8 * 4;
            n11 = 0xF & nArray[n14] >> n8 * 4;
            int n15 = 17 * (0xF ^ n10) << 24 | nArray2[n11] & 0xFFFFFF;
            if (n15 != n13) {
                this.big.setColor(new Color(n15));
            }
            n13 = n15;
            if (bl || n10 > 0) {
                this.big.drawLine(n2, n3, n2, n3);
            }
            ++n2;
        }
        return n2;
    }

    private int paintVideoSize(Object object) {
        String[] stringArray = (String[])object;
        int n = this.w;
        int n2 = this.h;
        n = stringArray[0] == null ? n : Integer.parseInt(stringArray[0]);
        n2 = stringArray[1] == null ? n2 : Integer.parseInt(stringArray[1]);
        this.big.setColor(new Color(-11206656));
        this.big.fillRect(0, 0, this.w, this.h);
        this.big.setColor(Color.gray);
        this.big.fillRect(0, 0, n, n2);
        return n2;
    }

    public void repaint() {
        if (this.big == null) {
            return;
        }
        Common.getGuiInterface().repaintSubpicture();
    }

    public void reset() {
        this.isforced_status = 0;
        this.ismulticolor_status = 0;
        this.set_XY_Offset(0, 0);
        this.setDisplayMode(0);
    }

    public void resetUserColorTable() {
        this.user_color_table.clear();
    }

    public int[] set(String string, String string2) {
        return this.set(string, string2, false);
    }

    public int[] set(String string, String string2, boolean bl) {
        if (!bl) {
            this.resetUserColorTable();
        }
        System.arraycopy(this.standard_values, 0, this.option, 0, this.standard_values.length);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < this.option.length) {
            this.option[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        this.line_offset = this.option[0] + 2;
        this.default_alpha = 0xF & this.option[1];
        this.font = new Font(string, this.option[10] == 0 ? 0 : 1, this.option[0]);
        this.font_std = new Font("Tahoma", 0, 14);
        int[] nArray = new int[]{this.option[2], this.option[7]};
        return nArray;
    }

    public void set2() {
        this.option[2] = this.option[7];
    }

    private void setArea() {
        this.Rect[0] = this.bitmap.getX();
        this.Rect[1] = this.bitmap.getY();
        this.Rect[2] = this.bitmap.getWidth();
        this.Rect[3] = this.bitmap.getHeight();
        this.pos[0] = this.bitmap.getX();
        this.pos[1] = this.bitmap.getY();
        this.pos[2] = this.bitmap.getMaxX();
        this.pos[3] = this.bitmap.getMaxY();
    }

    public void setColorTable(int[] nArray) {
        if (nArray == null) {
            Arrays.fill(this.alternative_sup_colors, 0);
        } else {
            System.arraycopy(nArray, 0, this.alternative_sup_colors, 0, nArray.length);
        }
    }

    private void setControlBlockPosition(int n, int n2) {
        this.sections[16] = 0;
        this.sections[17] = 4;
        this.sections[18] = (byte)(0xFF & n2 >>> 8);
        this.sections[19] = (byte)(0xFF & n2);
        this.sections[0] = this.sections[24] = (byte)(0xFF & n >>> 8);
        this.sections[1] = this.sections[25] = (byte)(0xFF & n);
    }

    public void setDisplayMode(int n) {
        this.DisplayMode = n;
    }

    public int setPGClinks() {
        Object[] objectArray = this.bitmap.getColorIndices();
        Object[] objectArray2 = this.getUserColorTableArray();
        int n = 65040;
        int n2 = 65529;
        int n3 = 0;
        while (n3 < 4) {
            if (n3 < objectArray.length) {
                int n4 = 0xF & Integer.parseInt(objectArray[n3].toString());
                int n5 = 0xF & Integer.parseInt(objectArray2[n4].toString()) >>> 28;
                n = n & ~(15 << n3 * 4) | n4 << n3 * 4;
                n2 = n2 & ~(15 << n3 * 4) | n5 << n3 * 4;
            }
            ++n3;
        }
        if (this.read_from_Image) {
            n2 &= 0xFFF0 | this.modified_alpha;
        }
        return n2 << 16 | n;
    }

    private void setPGCsection() {
        int n = this.setPGClinks();
        this.sections[3] = (byte)(0xFF & n >>> 8);
        this.sections[4] = (byte)(0xFF & n);
        this.sections[6] = (byte)(0xFF & n >>> 24);
        this.sections[7] = (byte)(0xFF & n >>> 16);
    }

    private void setScreenPosition(int n, int n2, int n3, int n4) {
        this.sections[9] = (byte)(n >>> 4);
        this.sections[10] = (byte)(n << 4 | n3 >>> 8);
        this.sections[11] = (byte)n3;
        this.sections[12] = (byte)(n2 >>> 4);
        this.sections[13] = (byte)(n2 << 4 | n4 >>> 8);
        this.sections[14] = (byte)n4;
    }

    public byte[] setTime(byte[] byArray, long l) {
        long l2 = 0L;
        int n = 0;
        while (n < 4) {
            l2 |= (long)((0xFF & byArray[n + 2]) << n * 8);
            ++n;
        }
        long l3 = 1L + (l - l2) / 1024L;
        int n2 = (0xFF & byArray[12]) << 8 | 0xFF & byArray[13];
        byArray[34 + n2] = (byte)(0xFFL & l3 >>> 8);
        byArray[35 + n2] = (byte)(0xFFL & l3);
        Common.getGuiInterface().setSubpictureTitle(" / " + Resource.getString("subpicture.in_time") + ": " + Common.formatTime_1(l2 / 90L) + " " + Resource.getString("subpicture.duration") + ": " + Common.formatTime_1((l - l2) / 90L));
        return byArray;
    }

    public void set_XY_Offset(int n, int n2) {
        this.X_Offset = n;
        this.Y_Offset = n2;
    }

    public void showPicTTX(Object[] objectArray, Object object) {
        this.str = objectArray;
        this.buildImgTTX(object);
        this.repaint();
    }

    private void updateRLE(int n, int n2) {
        if (n < 1) {
            return;
        }
        int n3 = this.getUserColorTableIndex(n2);
        n3 = ColorAreas.active ? n2 : this.bitmap.getColorIndex(n3);
        n = n << 2 | n3;
        if (this.nibble == 0) {
            if (n > 255) {
                this.out.write((byte)(0xFF & n >>> 8));
                this.out.write((byte)(0xFF & n));
            } else if (n > 63) {
                this.out.write((byte)(0xFF & n >>> 4));
                this.val = 0xF0 & n << 4;
                this.nibble = 4;
            } else if (n > 15) {
                this.out.write((byte)(0xFF & n));
            } else {
                this.val = 0xF0 & n << 4;
                this.nibble = 4;
            }
        } else if (n > 255) {
            this.out.write((byte)(this.val | 0xF & n >>> 12));
            this.out.write((byte)(0xFF & n >>> 4));
            this.val = 0xF0 & n << 4;
        } else if (n > 63) {
            this.out.write((byte)(this.val | 0xF & n >>> 8));
            this.out.write((byte)(0xFF & n));
            this.nibble = 0;
            this.val = 0;
        } else if (n > 15) {
            this.out.write((byte)(this.val | 0xF & n >>> 4));
            this.val = 0xF0 & n << 4;
        } else {
            this.out.write((byte)(this.val | 0xF & n));
            this.nibble = 0;
            this.val = 0;
        }
    }

    public void updateUserColorTable(Bitmap bitmap) {
        this.bitmap = bitmap;
        int[] nArray = this.bitmap.getPixel();
        int n = 0;
        while (n < nArray.length) {
            String string = String.valueOf(nArray[n]);
            if (!this.user_color_table.contains(string)) {
                this.user_color_table.add(string);
            }
            this.bitmap.getColorIndex(this.getUserColorTableIndex(nArray[n]));
            ++n;
        }
    }

    private void updateUserColorTable(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            String string = String.valueOf(nArray[n]);
            if (!this.user_color_table.contains(string)) {
                this.user_color_table.add(string);
            }
            ++n;
        }
    }

    public byte[] writeRLE(long l, int n) throws IOException {
        this.read_from_Image = true;
        this.bitmap = new Bitmap(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], this.bimg.getRGB(this.Rect[0], this.Rect[1], this.Rect[2], this.Rect[3], null, 0, this.Rect[2]), 2, 0, 1, 2, l, n);
        return this.buildRLE();
    }

    public byte[] writeRLE(Bitmap bitmap) throws IOException {
        this.bitmap = bitmap;
        this.setArea();
        return this.buildRLE();
    }
}

