/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.thirdparty;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;

public class TS {
    private static byte[] service_name = null;
    private static byte[] event_name = null;
    private static byte[] event_text = null;
    private static byte[] TF4000header;
    private static byte[] TF5000header;
    private static byte[] TF5200header;
    private static StringBuffer ArionAVFPathname_onPVR;
    private static StringBuffer ArionAVRLocalFilename;
    private static File ArionAVFLocalPathname;
    private static StringBuffer ArionAVFTime;
    private static StringBuffer ArionFilenameRoot;
    private static long ArionCumulativeTime;
    private static long ArionCumulativeStreamSize;
    private static final int ArionAVR_HEADERSIZE = 32768;
    private static byte[] ArionAVR_Header;
    private static final int ArionAVF_HEADERSIZE = 15160;
    private static byte[] ArionAVF_Header;
    private static final int ArionEPG_BLOCKSIZE = 714;
    private static byte[] Arion_EPG_Block;
    private static byte[] pmt1;
    private static int count1;
    private static int count2;
    private static int count3;
    private static byte[] pcr;
    private static byte[] pat;
    private static byte[] pmt;
    private static byte[] pmtHead;
    private static byte[] pmtStart;
    private static byte[] pmtPCR;
    private static byte[] pmtMPV;
    private static byte[] pmtMPA;
    private static byte[] pmtAC3;
    private static byte[] pmtAC3_atsc;
    private static byte[] pmtTTX;
    private static byte[] pmtSUP;
    private static byte[] autopmt;
    private static int firstID;
    private static boolean myTTX;
    private static byte[] pat1;
    private static byte[] pcr1;
    private static byte[] ttx_stream;
    private static long[] ttx_pts_index;
    private static int ttx_index;

    static {
        byte[] byArray = new byte[208];
        byArray[0] = -51;
        byArray[1] = 57;
        byArray[2] = 12;
        byArray[4] = -51;
        byArray[5] = 57;
        byArray[6] = 12;
        byArray[9] = 60;
        byArray[11] = 31;
        byArray[14] = 5;
        byArray[16] = 6;
        byArray[17] = -80;
        byArray[18] = 1;
        byArray[19] = 2;
        byArray[20] = 1;
        byArray[23] = -32;
        byArray[25] = -32;
        byArray[27] = -64;
        byArray[28] = 77;
        byArray[29] = 121;
        byArray[30] = 32;
        byArray[31] = 112;
        byArray[32] = 101;
        byArray[33] = 114;
        byArray[34] = 115;
        byArray[35] = 111;
        byArray[36] = 110;
        byArray[37] = 97;
        byArray[38] = 108;
        byArray[39] = 32;
        byArray[40] = 84;
        byArray[41] = 86;
        byArray[42] = 32;
        byArray[43] = 67;
        byArray[44] = 104;
        byArray[45] = 97;
        byArray[46] = 110;
        byArray[47] = 110;
        byArray[48] = 101;
        byArray[49] = 108;
        byArray[52] = 5;
        byArray[54] = 48;
        byArray[55] = -64;
        byArray[56] = 107;
        byArray[57] = 108;
        byArray[59] = 1;
        byArray[60] = 64;
        byArray[61] = 31;
        byArray[62] = 1;
        byArray[63] = 1;
        byArray[64] = -51;
        byArray[65] = 57;
        byArray[66] = 11;
        byArray[68] = -51;
        byArray[69] = 57;
        byArray[70] = 12;
        byArray[73] = 60;
        byArray[74] = 4;
        byArray[75] = 4;
        byArray[76] = 84;
        byArray[77] = 69;
        byArray[78] = 83;
        byArray[79] = 84;
        byArray[206] = 1;
        byArray[207] = 2;
        TF4000header = byArray;
        byte[] byArray2 = new byte[87];
        byArray2[0] = 84;
        byArray2[1] = 70;
        byArray2[2] = 114;
        byArray2[3] = 99;
        byArray2[4] = 80;
        byArray2[11] = 10;
        byArray2[16] = 1;
        byArray2[17] = 48;
        byArray2[18] = 1;
        byArray2[19] = 2;
        byArray2[20] = 1;
        byArray2[23] = -32;
        byArray2[25] = -32;
        byArray2[27] = -64;
        byArray2[28] = 80;
        byArray2[29] = 114;
        byArray2[30] = 105;
        byArray2[31] = 118;
        byArray2[32] = 97;
        byArray2[33] = 116;
        byArray2[34] = 101;
        byArray2[35] = 32;
        byArray2[36] = 82;
        byArray2[37] = 101;
        byArray2[38] = 99;
        byArray2[39] = 111;
        byArray2[40] = 114;
        byArray2[41] = 100;
        byArray2[42] = 105;
        byArray2[43] = 110;
        byArray2[44] = 103;
        byArray2[53] = 8;
        byArray2[54] = 7;
        byArray2[58] = 47;
        byArray2[59] = -101;
        byArray2[60] = 107;
        byArray2[61] = 108;
        byArray2[62] = 1;
        byArray2[63] = 1;
        byArray2[68] = -128;
        byArray2[69] = 2;
        byArray2[73] = 60;
        byArray2[74] = 4;
        byArray2[75] = 4;
        byArray2[76] = 84;
        byArray2[77] = 69;
        byArray2[78] = 83;
        byArray2[79] = 84;
        byArray2[84] = 4;
        TF5000header = byArray2;
        byte[] byArray3 = new byte[83];
        byArray3[0] = 84;
        byArray3[1] = 70;
        byArray3[2] = 114;
        byArray3[3] = 99;
        byArray3[4] = 80;
        byArray3[11] = 10;
        byArray3[16] = 1;
        byArray3[17] = 48;
        byArray3[18] = 1;
        byArray3[19] = 2;
        byArray3[20] = 1;
        byArray3[23] = -32;
        byArray3[25] = -32;
        byArray3[27] = -64;
        byArray3[28] = 80;
        byArray3[29] = 114;
        byArray3[30] = 105;
        byArray3[31] = 118;
        byArray3[32] = 97;
        byArray3[33] = 116;
        byArray3[34] = 101;
        byArray3[35] = 32;
        byArray3[36] = 82;
        byArray3[37] = 101;
        byArray3[38] = 99;
        byArray3[39] = 111;
        byArray3[40] = 114;
        byArray3[41] = 100;
        byArray3[42] = 105;
        byArray3[43] = 110;
        byArray3[44] = 103;
        byArray3[53] = 6;
        byArray3[54] = 65;
        byArray3[55] = -112;
        byArray3[56] = 26;
        byArray3[57] = -12;
        byArray3[58] = 1;
        byArray3[59] = 1;
        byArray3[61] = 1;
        byArray3[62] = 2;
        byArray3[64] = -128;
        byArray3[65] = 2;
        byArray3[69] = 60;
        byArray3[70] = 4;
        byArray3[71] = 4;
        byArray3[72] = 84;
        byArray3[73] = 69;
        byArray3[74] = 83;
        byArray3[75] = 84;
        byArray3[80] = 4;
        TF5200header = byArray3;
        ArionAVFPathname_onPVR = new StringBuffer(128);
        ArionAVRLocalFilename = new StringBuffer(1024);
        ArionAVFTime = new StringBuffer(128);
        ArionFilenameRoot = new StringBuffer(128);
        ArionCumulativeTime = 0L;
        ArionCumulativeStreamSize = 0L;
        byte[] byArray4 = new byte[20];
        byArray4[0] = 65;
        byArray4[1] = 82;
        byArray4[2] = 65;
        byArray4[3] = 86;
        byArray4[4] = 16;
        byArray4[7] = -122;
        byArray4[8] = -128;
        byArray4[10] = 67;
        byArray4[11] = 58;
        byArray4[12] = 92;
        byArray4[13] = 80;
        byArray4[14] = 86;
        byArray4[15] = 82;
        byArray4[16] = 92;
        byArray4[17] = 65;
        byArray4[18] = 86;
        byArray4[19] = 92;
        ArionAVR_Header = byArray4;
        byte[] byArray5 = new byte[294];
        byArray5[0] = 65;
        byArray5[1] = 82;
        byArray5[2] = 78;
        byArray5[3] = 70;
        byArray5[4] = 17;
        byArray5[7] = 4;
        byArray5[8] = 63;
        byArray5[9] = 4;
        byArray5[11] = 10;
        byArray5[17] = 1;
        byArray5[18] = 7;
        byArray5[21] = 72;
        byArray5[22] = 1;
        byArray5[24] = 1;
        byArray5[25] = 2;
        byArray5[27] = 1;
        byArray5[29] = -64;
        byArray5[30] = 127;
        byArray5[31] = -1;
        byArray5[32] = 17;
        byArray5[33] = 16;
        byArray5[35] = -32;
        byArray5[39] = -112;
        byArray5[40] = 1;
        byArray5[43] = 80;
        byArray5[44] = 114;
        byArray5[45] = 111;
        byArray5[46] = 106;
        byArray5[47] = 101;
        byArray5[48] = 99;
        byArray5[49] = 116;
        byArray5[50] = 45;
        byArray5[51] = 88;
        byArray5[52] = 32;
        byArray5[53] = 99;
        byArray5[54] = 111;
        byArray5[55] = 110;
        byArray5[56] = 118;
        byArray5[57] = 101;
        byArray5[58] = 114;
        byArray5[59] = 116;
        byArray5[60] = 101;
        byArray5[61] = 100;
        byArray5[62] = 10;
        byArray5[68] = 1;
        byArray5[69] = 17;
        byArray5[73] = 1;
        byArray5[92] = 2;
        byArray5[93] = -54;
        byArray5[94] = 7;
        byArray5[95] = -42;
        byArray5[96] = 9;
        byArray5[97] = 8;
        byArray5[98] = 7;
        byArray5[99] = 6;
        byArray5[100] = 3;
        byArray5[101] = 30;
        byArray5[166] = 83;
        byArray5[167] = 117;
        byArray5[168] = 98;
        byArray5[169] = 116;
        byArray5[170] = 105;
        byArray5[171] = 116;
        byArray5[172] = 108;
        byArray5[173] = 101;
        byArray5[174] = 32;
        byArray5[175] = 105;
        byArray5[176] = 110;
        byArray5[177] = 115;
        byArray5[178] = 101;
        byArray5[179] = 114;
        byArray5[180] = 116;
        byArray5[181] = 101;
        byArray5[182] = 100;
        byArray5[183] = 32;
        byArray5[184] = 98;
        byArray5[185] = 121;
        byArray5[186] = 32;
        byArray5[187] = 80;
        byArray5[188] = 114;
        byArray5[189] = 111;
        byArray5[190] = 106;
        byArray5[191] = 101;
        byArray5[192] = 99;
        byArray5[193] = 116;
        byArray5[194] = 45;
        byArray5[195] = 88;
        byArray5[196] = 10;
        ArionAVF_Header = byArray5;
        byte[] byArray6 = new byte[202];
        byArray6[0] = 2;
        byArray6[1] = -54;
        byArray6[2] = 7;
        byArray6[3] = -42;
        byArray6[4] = 9;
        byArray6[5] = 8;
        byArray6[6] = 7;
        byArray6[7] = 6;
        byArray6[8] = 5;
        byArray6[9] = 30;
        byArray6[10] = 112;
        byArray6[11] = 114;
        byArray6[12] = 111;
        byArray6[13] = 103;
        byArray6[14] = 114;
        byArray6[15] = 97;
        byArray6[16] = 109;
        byArray6[17] = 32;
        byArray6[18] = 116;
        byArray6[19] = 105;
        byArray6[20] = 116;
        byArray6[21] = 108;
        byArray6[22] = 101;
        byArray6[74] = 83;
        byArray6[75] = 117;
        byArray6[76] = 98;
        byArray6[77] = 116;
        byArray6[78] = 105;
        byArray6[79] = 116;
        byArray6[80] = 108;
        byArray6[81] = 101;
        byArray6[82] = 32;
        byArray6[83] = 105;
        byArray6[84] = 110;
        byArray6[85] = 115;
        byArray6[86] = 101;
        byArray6[87] = 114;
        byArray6[88] = 116;
        byArray6[89] = 101;
        byArray6[90] = 100;
        byArray6[91] = 32;
        byArray6[92] = 98;
        byArray6[93] = 121;
        byArray6[94] = 32;
        byArray6[95] = 80;
        byArray6[96] = 114;
        byArray6[97] = 111;
        byArray6[98] = 106;
        byArray6[99] = 101;
        byArray6[100] = 99;
        byArray6[101] = 116;
        byArray6[102] = 45;
        byArray6[103] = 88;
        Arion_EPG_Block = byArray6;
        byte[] byArray7 = new byte[157];
        byArray7[0] = 71;
        byArray7[1] = 65;
        byArray7[3] = 16;
        byArray7[5] = 2;
        byArray7[6] = -80;
        byArray7[7] = -107;
        byArray7[8] = 1;
        byArray7[9] = 2;
        byArray7[10] = -63;
        byArray7[13] = -32;
        byArray7[14] = -32;
        byArray7[15] = -16;
        byArray7[17] = 2;
        byArray7[18] = -32;
        byArray7[19] = -32;
        byArray7[20] = -16;
        byArray7[21] = 3;
        byArray7[22] = 82;
        byArray7[23] = 1;
        byArray7[24] = 1;
        byArray7[25] = 3;
        byArray7[26] = -32;
        byArray7[27] = -64;
        byArray7[28] = -16;
        byArray7[29] = 9;
        byArray7[30] = 82;
        byArray7[31] = 1;
        byArray7[32] = 3;
        byArray7[33] = 10;
        byArray7[34] = 4;
        byArray7[35] = 100;
        byArray7[36] = 101;
        byArray7[37] = 117;
        byArray7[38] = 1;
        byArray7[39] = 3;
        byArray7[40] = -32;
        byArray7[41] = -63;
        byArray7[42] = -16;
        byArray7[43] = 9;
        byArray7[44] = 82;
        byArray7[45] = 1;
        byArray7[46] = 4;
        byArray7[47] = 10;
        byArray7[48] = 4;
        byArray7[49] = 100;
        byArray7[50] = 101;
        byArray7[51] = 117;
        byArray7[52] = 1;
        byArray7[53] = 3;
        byArray7[54] = -32;
        byArray7[55] = -62;
        byArray7[56] = -16;
        byArray7[57] = 9;
        byArray7[58] = 82;
        byArray7[59] = 1;
        byArray7[60] = 5;
        byArray7[61] = 10;
        byArray7[62] = 4;
        byArray7[63] = 100;
        byArray7[64] = 101;
        byArray7[65] = 117;
        byArray7[66] = 1;
        byArray7[67] = 3;
        byArray7[68] = -32;
        byArray7[69] = -61;
        byArray7[70] = -16;
        byArray7[71] = 9;
        byArray7[72] = 82;
        byArray7[73] = 1;
        byArray7[74] = 6;
        byArray7[75] = 10;
        byArray7[76] = 4;
        byArray7[77] = 100;
        byArray7[78] = 101;
        byArray7[79] = 117;
        byArray7[80] = 1;
        byArray7[81] = 6;
        byArray7[82] = -32;
        byArray7[83] = -128;
        byArray7[84] = -16;
        byArray7[85] = 12;
        byArray7[86] = 82;
        byArray7[87] = 1;
        byArray7[88] = 17;
        byArray7[89] = 106;
        byArray7[90] = 1;
        byArray7[92] = 10;
        byArray7[93] = 4;
        byArray7[94] = 100;
        byArray7[95] = 101;
        byArray7[96] = 117;
        byArray7[98] = 6;
        byArray7[99] = -32;
        byArray7[100] = -127;
        byArray7[101] = -16;
        byArray7[102] = 12;
        byArray7[103] = 82;
        byArray7[104] = 1;
        byArray7[105] = 18;
        byArray7[106] = 106;
        byArray7[107] = 1;
        byArray7[109] = 10;
        byArray7[110] = 4;
        byArray7[111] = 100;
        byArray7[112] = 101;
        byArray7[113] = 117;
        byArray7[115] = 6;
        byArray7[116] = -32;
        byArray7[117] = -126;
        byArray7[118] = -16;
        byArray7[119] = 12;
        byArray7[120] = 82;
        byArray7[121] = 1;
        byArray7[122] = 19;
        byArray7[123] = 106;
        byArray7[124] = 1;
        byArray7[126] = 10;
        byArray7[127] = 4;
        byArray7[128] = 100;
        byArray7[129] = 101;
        byArray7[130] = 117;
        byArray7[132] = 6;
        byArray7[133] = -32;
        byArray7[134] = -112;
        byArray7[135] = -16;
        byArray7[136] = 16;
        byArray7[137] = 82;
        byArray7[138] = 1;
        byArray7[139] = -62;
        byArray7[140] = 86;
        byArray7[141] = 5;
        byArray7[142] = 101;
        byArray7[143] = 110;
        byArray7[144] = 103;
        byArray7[145] = 9;
        byArray7[147] = 10;
        byArray7[148] = 4;
        byArray7[149] = 100;
        byArray7[150] = 101;
        byArray7[151] = 117;
        byArray7[153] = -123;
        byArray7[154] = 51;
        byArray7[155] = 73;
        byArray7[156] = 126;
        pmt1 = byArray7;
        count1 = 0;
        count2 = 0;
        count3 = 0;
        pcr = new byte[188];
        pat = new byte[188];
        pmt = new byte[188];
        byte[] byArray8 = new byte[4];
        byArray8[0] = 71;
        byArray8[1] = 1;
        byArray8[3] = 16;
        pmtHead = byArray8;
        byte[] byArray9 = new byte[8];
        byArray9[1] = 2;
        byArray9[2] = -80;
        byArray9[4] = 1;
        byArray9[5] = 2;
        byArray9[6] = -63;
        pmtStart = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[1] = -32;
        byArray10[2] = -32;
        byArray10[3] = -16;
        pmtPCR = byArray10;
        pmtMPV = new byte[]{2, -32, -32, -16, 3, 82, 1, 1};
        pmtMPA = new byte[]{3, -32, -64, -16, 9, 82, 1, 3, 10, 4, 100, 101, 117, 1};
        byte[] byArray11 = new byte[17];
        byArray11[0] = 6;
        byArray11[1] = -32;
        byArray11[2] = -128;
        byArray11[3] = -16;
        byArray11[4] = 12;
        byArray11[5] = 82;
        byArray11[6] = 1;
        byArray11[7] = 4;
        byArray11[8] = 106;
        byArray11[9] = 1;
        byArray11[11] = 10;
        byArray11[12] = 4;
        byArray11[13] = 100;
        byArray11[14] = 101;
        byArray11[15] = 117;
        pmtAC3 = byArray11;
        byte[] byArray12 = new byte[20];
        byArray12[0] = -127;
        byArray12[1] = -32;
        byArray12[2] = -128;
        byArray12[3] = -16;
        byArray12[4] = 15;
        byArray12[5] = 82;
        byArray12[6] = 1;
        byArray12[7] = 4;
        byArray12[8] = 10;
        byArray12[9] = 4;
        byArray12[10] = 101;
        byArray12[11] = 110;
        byArray12[12] = 103;
        byArray12[14] = 5;
        byArray12[15] = 4;
        byArray12[16] = 65;
        byArray12[17] = 67;
        byArray12[18] = 45;
        byArray12[19] = 51;
        pmtAC3_atsc = byArray12;
        byte[] byArray13 = new byte[49];
        byArray13[0] = 6;
        byArray13[1] = -32;
        byArray13[2] = -112;
        byArray13[3] = -16;
        byArray13[4] = 44;
        byArray13[5] = 82;
        byArray13[6] = 1;
        byArray13[7] = 5;
        byArray13[8] = 86;
        byArray13[9] = 20;
        byArray13[10] = 101;
        byArray13[11] = 110;
        byArray13[12] = 103;
        byArray13[13] = 9;
        byArray13[15] = 100;
        byArray13[16] = 101;
        byArray13[17] = 117;
        byArray13[18] = 17;
        byArray13[19] = 80;
        byArray13[20] = 103;
        byArray13[21] = 101;
        byArray13[22] = 114;
        byArray13[23] = 23;
        byArray13[24] = 119;
        byArray13[25] = 101;
        byArray13[26] = 110;
        byArray13[27] = 103;
        byArray13[28] = 16;
        byArray13[29] = -120;
        byArray13[30] = 10;
        byArray13[31] = 4;
        byArray13[32] = 100;
        byArray13[33] = 101;
        byArray13[34] = 117;
        byArray13[36] = 69;
        byArray13[37] = 11;
        byArray13[38] = 1;
        byArray13[39] = 6;
        byArray13[40] = -25;
        byArray13[41] = -24;
        byArray13[42] = -23;
        byArray13[43] = -22;
        byArray13[44] = -21;
        byArray13[45] = -20;
        byArray13[46] = 4;
        byArray13[47] = 1;
        byArray13[48] = -16;
        pmtTTX = byArray13;
        byte[] byArray14 = new byte[18];
        byArray14[0] = 6;
        byArray14[1] = -32;
        byArray14[2] = 32;
        byArray14[3] = -16;
        byArray14[4] = 13;
        byArray14[5] = 82;
        byArray14[6] = 1;
        byArray14[7] = 6;
        byArray14[8] = 89;
        byArray14[9] = 8;
        byArray14[10] = 100;
        byArray14[11] = 101;
        byArray14[12] = 117;
        byArray14[13] = 16;
        byArray14[15] = 1;
        byArray14[17] = 1;
        pmtSUP = byArray14;
        autopmt = new byte[0];
        firstID = 224;
        myTTX = false;
        byte[] byArray15 = new byte[21];
        byArray15[0] = 71;
        byArray15[1] = 64;
        byArray15[3] = 16;
        byArray15[6] = -80;
        byArray15[7] = 13;
        byArray15[9] = 1;
        byArray15[10] = 1;
        byArray15[13] = 1;
        byArray15[14] = 2;
        byArray15[15] = -31;
        byArray15[17] = -113;
        byArray15[18] = -91;
        byArray15[19] = 38;
        byArray15[20] = -49;
        pat1 = byArray15;
        byte[] byArray16 = new byte[12];
        byArray16[0] = 71;
        byArray16[2] = -32;
        byArray16[3] = 32;
        byArray16[4] = -73;
        byArray16[5] = 16;
        pcr1 = byArray16;
        ttx_stream = null;
        ttx_pts_index = null;
        ttx_index = 0;
    }

    public static void buildTeletextStream(String string) {
        string = String.valueOf(string.substring(0, string.lastIndexOf("."))) + ".sub";
        File file = new File(string);
        ttx_index = 0;
        if (!file.exists()) {
            return;
        }
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string2 = "";
            String string3 = "";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            int n3 = 0;
            long[] lArray = new long[3];
            byte[] byArray = new byte[5];
            byte[] byArray2 = new byte[8];
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            long l = 90L * (long)Common.getSettings().getIntProperty("TTXInsertion.Delay", 0);
            long[] lArray2 = new long[3];
            Common.setMessage("-> build teletext stream from file: '" + string + "' / delay = " + l / 90L + " ms");
            Common.getTeletextClass().setMappingTable();
            while ((string2 = bufferedReader.readLine()) != null) {
                n2 = string2.indexOf("{") + 1;
                n3 = string2.indexOf("}");
                lArray2[0] = Long.parseLong(string2.substring(n2, n3));
                ++n3;
                n3 = string2.indexOf("}", n3);
                lArray2[1] = Long.parseLong(string2.substring(string2.indexOf("{", ++n2) + 1, n3));
                lArray[0] = l + 3600L * lArray2[0];
                lArray[1] = l + 3600L * lArray2[1];
                StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n3 + 1), "|");
                arrayList.clear();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                n = 0;
                while (n < 2) {
                    Arrays.fill(byArray, (byte)0);
                    CommonParsing.setPES_PTSField(byArray, -9, lArray[n]);
                    byteArrayOutputStream.write(Common.getTeletextClass().getTTX_TSPacket(arrayList, count3, byArray));
                    arrayList2.add(new Long(lArray[n]));
                    count3 += 2;
                    arrayList.clear();
                    ++n;
                    lArray2[2] = lArray2[2] + 1L;
                }
            }
            bufferedReader.close();
            ttx_stream = byteArrayOutputStream.toByteArray();
            ttx_pts_index = new long[arrayList2.size()];
            n = 0;
            int n4 = ttx_pts_index.length;
            while (n < n4) {
                TS.ttx_pts_index[n] = (Long)arrayList2.get(n);
                ++n;
            }
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private static String finishArionheaders(String string, long[] lArray, JobProcessing jobProcessing) throws IOException {
        long l = (lArray[1] - lArray[0]) / 90L;
        long l2 = Math.round((float)l / 1000.0f);
        long l3 = Math.round((float)(ArionCumulativeTime += l2) / 60.0f);
        int n = jobProcessing.getSplitPart();
        File file = new File(new File(string).getParentFile(), ArionAVRLocalFilename.toString());
        if (file.exists()) {
            file.delete();
        }
        Common.renameTo(new File(string), file);
        long l4 = file.length() - 32768L;
        ArionCumulativeStreamSize += l4;
        if (l4 > 2140798976L) {
            Common.setMessage("!> Arion: File is too large " + String.valueOf(file.length()) + " bytes)");
            return new String("noFileCreated");
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(ArionAVFLocalPathname, "rw");
        Common.setMessage("Arion: renamed '" + string + "'");
        Common.setMessage("            to '" + file.getPath() + "'");
        Common.setMessage("    size 0x" + Long.toHexString(l4).toUpperCase() + ", duration " + String.valueOf(l2) + " sec (cumulative: " + String.valueOf(l3) + " min)");
        int n2 = (int)(ArionCumulativeStreamSize / ArionCumulativeTime);
        Common.setMessage("Arion: bitrate = " + String.valueOf(n2) + " bytes/s");
        randomAccessFile.seek(932 + 4 * n);
        randomAccessFile.writeInt((int)l4);
        randomAccessFile.seek(1732L);
        randomAccessFile.writeInt(n2);
        randomAccessFile.writeInt((int)l3);
        randomAccessFile.writeShort(n + 1);
        randomAccessFile.seek(1744L);
        randomAccessFile.writeLong(ArionCumulativeStreamSize);
        Common.setMessage("Arion: Written " + String.valueOf(ArionCumulativeStreamSize) + " bytes");
        randomAccessFile.close();
        return string;
    }

    private static void finishTF4000header(String string, long[] lArray, short s, long[] lArray2, Calendar calendar) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.seek(0L);
            randomAccessFile.writeShort((short)lArray2[2]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            randomAccessFile.writeShort((short)lArray2[2]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            randomAccessFile.writeShort(s);
            randomAccessFile.seek(68L);
            randomAccessFile.writeShort((short)lArray2[2]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            randomAccessFile.writeShort(s);
            calendar.setTime(new Date(lArray2[1]));
            randomAccessFile.seek(64L);
            randomAccessFile.writeShort((short)lArray2[3]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
    }

    private static void finishTF5X00header(String string, long[] lArray, short s, long[] lArray2, Calendar calendar, int n) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.seek(8L);
            randomAccessFile.writeShort(s);
            if (service_name != null) {
                randomAccessFile.seek(28L);
                randomAccessFile.write(service_name);
            }
            randomAccessFile.seek(66 + n);
            randomAccessFile.writeShort(s);
            randomAccessFile.seek(76 + n);
            randomAccessFile.writeShort((short)lArray2[2]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            calendar.setTime(new Date(lArray2[1]));
            randomAccessFile.seek(72 + n);
            randomAccessFile.writeShort((short)lArray2[3]);
            randomAccessFile.writeByte((byte)calendar.get(11));
            randomAccessFile.writeByte((byte)calendar.get(12));
            if (event_name != null) {
                randomAccessFile.seek(81 + n);
                randomAccessFile.write(event_name);
            } else {
                String string2 = new File(string).getName();
                if (string2.length() > 128) {
                    string2 = string2.substring(0, 128);
                }
                randomAccessFile.seek(81 + n);
                randomAccessFile.writeUTF(string2);
                randomAccessFile.seek(82 + n);
                int n2 = randomAccessFile.read();
                randomAccessFile.seek(81 + n);
                randomAccessFile.writeShort(n2 << 8);
            }
            if (event_text != null) {
                randomAccessFile.seek(224 + n);
                randomAccessFile.write(event_text);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
        }
        TS.setEventInfo(null, null, null);
    }

    private static void finishTFHeader(String string, long[] lArray, int n) {
        long[] lArray2 = new long[4];
        long l = (lArray[1] - lArray[0]) / 90L;
        short s = (short)(0xFFFF & Math.round((float)l / 60000.0f));
        lArray2[0] = System.currentTimeMillis();
        lArray2[1] = lArray2[0] - l;
        lArray2[2] = lArray2[0] / 86400000L + 2440588L - 2400001L;
        lArray2[3] = lArray2[1] / 86400000L + 2440588L - 2400001L;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(lArray2[0]));
        switch (n) {
            case 1: {
                TS.finishTF4000header(string, lArray, s, lArray2, calendar);
                break;
            }
            case 2: 
            case 3: {
                TS.finishTF5X00header(string, lArray, s, lArray2, calendar, 4);
                break;
            }
            case 4: {
                TS.finishTF5X00header(string, lArray, s, lArray2, calendar, 0);
            }
        }
    }

    private static byte[] generateCRC32(byte[] byArray, int n) {
        int n2;
        int[] nArray = new int[33];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[16] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[26] = 1;
        nArray[32] = 1;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[32];
        long l = 0L;
        byte[] byArray2 = new byte[4];
        Arrays.fill(nArray3, 1);
        int n3 = (byArray.length - n) * 8;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            int n7 = n6 = (byArray[n] & 128 >>> n5++) != 0 ? 1 : 0;
            if ((n5 &= 7) == 0) {
                ++n;
            }
            n6 ^= nArray3[31];
            n2 = 31;
            while (n2 > 0) {
                nArray3[n2] = nArray2[n2] == 1 ? nArray3[n2 - 1] ^ n6 : nArray3[n2 - 1];
                --n2;
            }
            nArray3[0] = n6;
            ++n4;
        }
        n2 = 0;
        while (n2 < 32) {
            l = l << 1 | (long)nArray3[31 - n2];
            ++n2;
        }
        int n8 = 0;
        while (n8 < 4) {
            byArray2[n8] = (byte)(0xFFL & l >>> (3 - n8) * 8);
            ++n8;
        }
        return byArray2;
    }

    public static byte[] getAutoPMT() {
        int n = 0;
        while (n < autopmt.length) {
            TS.autopmt[n + 3] = (byte)(0x10 | 0xF & count1++);
            n += 188;
        }
        return autopmt;
    }

    public static byte[] getPAT() {
        TS.pat[3] = (byte)(0x10 | 0xF & count2++);
        return pat;
    }

    public static byte[] getPCR(long l, int n, int n2) {
        TS.pcr[2] = (byte)n2;
        TS.pcr[3] = (byte)(0x20 | 0xF & n);
        TS.pcr[6] = (byte)(0xFFL & l >>> 25);
        TS.pcr[7] = (byte)(0xFFL & l >>> 17);
        TS.pcr[8] = (byte)(0xFFL & l >>> 9);
        TS.pcr[9] = (byte)(0xFFL & l >>> 1);
        TS.pcr[10] = (byte)((1L & l) << 7);
        return pcr;
    }

    public static byte[] getPMT() {
        TS.pmt[3] = (byte)(0x10 | 0xF & count1++);
        return pmt;
    }

    public static byte[] getTeletextStream(long l) {
        if (ttx_pts_index == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = ttx_pts_index.length;
        while (ttx_index < n) {
            if (l < ttx_pts_index[ttx_index]) break;
            l -= (l - ttx_pts_index[ttx_index]) / 3600L * 3600L;
            CommonParsing.setPES_PTSField(ttx_stream, 4 + ttx_index * 376, l);
            CommonParsing.setPES_PTSField(ttx_stream, 192 + ttx_index * 376, l);
            byteArrayOutputStream.write(ttx_stream, ttx_index * 376, 376);
            ++ttx_index;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int getfirstID() {
        return firstID;
    }

    public static byte[] init(JobProcessing jobProcessing, String string, boolean bl, boolean bl2, int n) {
        count3 = 0;
        count2 = 0;
        count1 = 0;
        myTTX = bl2;
        Arrays.fill(pat, (byte)-1);
        Arrays.fill(pmt, (byte)-1);
        Arrays.fill(pcr, (byte)-1);
        System.arraycopy(pmt1, 0, pmt, 0, pmt1.length);
        System.arraycopy(pat1, 0, pat, 0, pat1.length);
        System.arraycopy(pcr1, 0, pcr, 0, pcr1.length);
        switch (n) {
            case 1: {
                return TS.initTFHeader(TF4000header, 564, string, bl, n);
            }
            case 2: {
                return TS.initTFHeader(TF5000header, 1692, string, bl, n);
            }
            case 3: {
                return TS.initTFHeader(TF5000header, 3760, string, bl, n);
            }
            case 4: {
                return TS.initTFHeader(TF5200header, 3760, string, bl, n);
            }
            case 5: {
                return TS.initArionHeader(string, bl, 32768, jobProcessing);
            }
        }
        return new byte[0];
    }

    private static byte[] initArionHeader(String string, boolean bl, int n, JobProcessing jobProcessing) {
        int n2 = jobProcessing.getSplitPart();
        if (n2 == 0) {
            long l = System.currentTimeMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date(l));
            ArionAVFPathname_onPVR.setLength(0);
            ArionAVFTime.setLength(0);
            ArionFilenameRoot.setLength(0);
            ArionCumulativeTime = 0L;
            ArionCumulativeStreamSize = 0L;
            ArionAVFTime.append(Common.formatTime_5(l));
            ArionFilenameRoot.append(new File(string).getName());
            int n3 = ArionFilenameRoot.toString().lastIndexOf("(");
            if (n3 > 0) {
                ArionFilenameRoot.delete(n3, ArionFilenameRoot.length());
            }
            if (ArionFilenameRoot.length() > 93) {
                ArionFilenameRoot.setLength(93);
            }
            String string2 = new String(String.valueOf(ArionFilenameRoot.toString()) + "_#001_" + ArionAVFTime.toString() + ".avf");
            ArionAVFPathname_onPVR.append("C:\\PVR\\AV\\" + string2.toUpperCase());
            StringBuffer stringBuffer = new StringBuffer(ArionAVFPathname_onPVR.toString());
            stringBuffer.setCharAt(stringBuffer.length() - 1, 'R');
            ArionAVFLocalPathname = new File(new File(string).getParentFile(), string2);
            try {
                Common.setMessage("Arion: Creating initial AVF file");
                RandomAccessFile randomAccessFile = new RandomAccessFile(ArionAVFLocalPathname, "rw");
                byte[] byArray = new byte[15160];
                System.arraycopy(ArionAVF_Header, 0, byArray, 0, ArionAVF_Header.length);
                System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, 806, stringBuffer.length());
                byArray[27] = 2;
                byArray[28] = -128;
                byArray[29] = !bl ? -64 : -128;
                byArray[30] = 0;
                byArray[31] = bl ? -64 : -128;
                short s = (short)calendar.get(1);
                byte by = (byte)calendar.get(2);
                byte by2 = (byte)calendar.get(5);
                byte by3 = (byte)calendar.get(11);
                byte by4 = (byte)calendar.get(12);
                byArray[8008] = 27;
                byArray[8009] = -18;
                byArray[8010] = (byte)(s >>> 8);
                byArray[8011] = (byte)(s & 0xFF);
                byArray[8012] = by;
                byArray[8013] = by2;
                byArray[8014] = by3;
                byArray[8015] = by4;
                byArray[8016] = 1;
                byte[] byArray2 = new byte[714];
                System.arraycopy(Arion_EPG_Block, 0, byArray2, 0, Arion_EPG_Block.length);
                byArray2[2] = (byte)(s >>> 8);
                byArray2[3] = (byte)(s & 0xFF);
                byArray2[4] = by;
                byArray2[5] = by2;
                byArray2[6] = by3;
                byArray2[7] = by4;
                System.arraycopy(ArionFilenameRoot.toString().getBytes(), 0, byArray2, 10, ArionFilenameRoot.length());
                System.arraycopy(byArray2, 0, byArray, 92, byArray2.length);
                System.arraycopy(byArray2, 0, byArray, 8018, byArray2.length);
                randomAccessFile.write(byArray);
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        ArionAVRLocalFilename.setLength(0);
        ArionAVRLocalFilename.append(String.valueOf(ArionFilenameRoot.toString()) + "_#" + Common.adaptString(n2 + 1, 3) + "_" + ArionAVFTime.toString() + ".avr");
        byte[] byArray = new byte[n];
        System.arraycopy(ArionAVR_Header, 0, byArray, 0, ArionAVR_Header.length);
        System.arraycopy(ArionAVFPathname_onPVR.toString().getBytes(), 0, byArray, 10, ArionAVFPathname_onPVR.length());
        return byArray;
    }

    private static byte[] initTFHeader(byte[] byArray, int n, String string, boolean bl, int n2) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[26] = 0;
        byArray2[27] = !bl ? -64 : -128;
        return byArray2;
    }

    public static void setEventInfo(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray == null) {
            service_name = null;
        } else {
            service_name = new byte[byArray.length];
            System.arraycopy(byArray, 0, service_name, 0, byArray.length);
        }
        if (byArray2 == null) {
            event_name = null;
        } else {
            event_name = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, event_name, 0, byArray2.length);
        }
        if (byArray3 == null) {
            event_text = null;
        } else {
            event_text = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, event_text, 0, byArray3.length);
        }
    }

    public static void setPmtPids(List list) throws IOException {
        Object[] objectArray;
        if (myTTX) {
            list.add("927");
        }
        if ((objectArray = list.toArray()).length == 0) {
            Common.setMessage(Resource.getString("ts.msg1"));
            autopmt = pmt;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Arrays.sort(objectArray);
        int n = 1;
        byteArrayOutputStream.write(pmtStart);
        firstID = 0xFF & Integer.parseInt(objectArray[0].toString());
        TS.pmtPCR[2] = (byte)firstID;
        TS.updateHeader(23, firstID);
        byteArrayOutputStream.write(pmtPCR);
        int n2 = 0;
        while (n2 < objectArray.length) {
            int n3 = Integer.parseInt(objectArray[n2].toString());
            switch (0xF & n3 >>> 8) {
                case 0: {
                    TS.pmtMPV[2] = (byte)(0xFF & n3);
                    TS.pmtMPV[7] = (byte)n++;
                    byteArrayOutputStream.write(pmtMPV);
                    break;
                }
                case 1: {
                    TS.pmtMPA[2] = (byte)(0xFF & n3);
                    TS.pmtMPA[7] = (byte)n++;
                    byteArrayOutputStream.write(pmtMPA);
                    break;
                }
                case 2: {
                    if ((0xFF & n3) < 64) {
                        TS.pmtSUP[2] = (byte)(0xFF & n3);
                        TS.pmtSUP[7] = (byte)n++;
                        byteArrayOutputStream.write(pmtSUP);
                        break;
                    }
                    TS.pmtAC3[2] = (byte)(0xFF & n3);
                    TS.pmtAC3[7] = (byte)n++;
                    byteArrayOutputStream.write(pmtAC3);
                    TS.pmtAC3_atsc[2] = (byte)(0xFF & n3);
                    TS.pmtAC3_atsc[7] = (byte)(n - 1);
                    byteArrayOutputStream.write(pmtAC3_atsc);
                    break;
                }
                case 3: {
                    TS.pmtTTX[2] = (byte)(0xFF & n3);
                    TS.pmtTTX[7] = (byte)n++;
                    byteArrayOutputStream.write(pmtTTX);
                    break;
                }
            }
            ++n2;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n4 = byArray.length;
        byArray[2] = (byte)(0xB0 | 0xF & n4 >> 8);
        byArray[3] = (byte)(0xFF & n4);
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(TS.generateCRC32(byArray, 1));
        byArray = byteArrayOutputStream.toByteArray();
        int n5 = (byArray.length - 1) / 184 + 1;
        autopmt = new byte[n5 * 188];
        Arrays.fill(autopmt, (byte)-1);
        int n6 = 0;
        int n7 = 0;
        while (n6 < byArray.length) {
            System.arraycopy(pmtHead, 0, autopmt, n7, 4);
            if (byArray.length >= n6 + 184) {
                System.arraycopy(byArray, n6, autopmt, 4 + n7, 184);
                n6 += 184;
                n7 += 188;
                continue;
            }
            System.arraycopy(byArray, n6, autopmt, 4 + n7, byArray.length - n6);
            break;
        }
        TS.autopmt[1] = 65;
        byteArrayOutputStream.close();
    }

    public static void setfirstID() {
        firstID = 224;
        TS.pmtPCR[2] = (byte)firstID;
        TS.updateHeader(23, firstID);
    }

    public static String updateAdditionalHeader(String string, long[] lArray, int n, JobProcessing jobProcessing) throws IOException {
        String string2 = "";
        String[] stringArray = new String[]{"", ".raw", ".rec", ".rec", ".rec", ""};
        switch (n) {
            case 0: {
                return string;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = String.valueOf(string.substring(0, string.length() - 3)) + stringArray[n];
                if (new File(string2).exists()) {
                    new File(string2).delete();
                }
                Common.renameTo(string, string2);
                TS.finishTFHeader(string2, lArray, n);
                break;
            }
            case 5: {
                string2 = TS.finishArionheaders(string, lArray, jobProcessing);
                break;
            }
        }
        return string2;
    }

    private static void updateHeader(int n, int n2) {
        TS.TF4000header[n] = (byte)n2;
        TS.TF5000header[n] = (byte)n2;
        TS.TF5200header[n] = (byte)n2;
    }
}

