/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput.topfield_raw;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import net.sourceforge.dvb.projectx.xinput.FileType;
import net.sourceforge.dvb.projectx.xinput.StreamInfo;
import net.sourceforge.dvb.projectx.xinput.XInputFileIF;
import net.sourceforge.dvb.projectx.xinput.XInputStream;
import net.sourceforge.dvb.projectx.xinput.topfield_raw.RawInterface;

public class XInputFileImpl
implements XInputFileIF {
    private boolean debug = false;
    private FileType fileType = null;
    private boolean isopen = false;
    private PushbackInputStream pbis = null;
    private long randomAccessCurrentPosition = 0L;
    private byte[] buffer = new byte[8];
    private RawInterface rawInterface = null;
    private String fileName = null;
    private Object constructorParameter = null;
    private StreamInfo streamInfo = null;

    private XInputFileImpl() {
        throw new UnsupportedOperationException();
    }

    public XInputFileImpl(String string) {
        if (this.debug) {
            System.out.println("Try to create XInputFile of Type RAW");
        }
        try {
            this.fileName = string;
            this.fileType = FileType.RAW;
            this.rawInterface = new RawInterface(string);
            this.rawInterface.getStream().close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("File is not of type FileType.RAW");
        }
        if (this.debug) {
            System.out.println("Succeeded to create XInputFile of Type RAW");
        }
    }

    public boolean exists() {
        boolean bl = false;
        try {
            this.rawInterface.getStream().close();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public Object getConstructorParameter() {
        return this.constructorParameter;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public InputStream getInputStream() throws FileNotFoundException, MalformedURLException, IOException {
        return this.getInputStream(0L);
    }

    public InputStream getInputStream(long l) throws FileNotFoundException, MalformedURLException, IOException {
        XInputStream xInputStream = new XInputStream(this.rawInterface.getStream());
        xInputStream.skip(l);
        return xInputStream;
    }

    public String getName() {
        return this.fileName;
    }

    public String getParent() {
        return "";
    }

    public StreamInfo getStreamInfo() {
        return this.streamInfo;
    }

    public String getUrl() {
        String string = "raw://" + this.fileName;
        return string;
    }

    public long lastModified() {
        return this.rawInterface.rawRead.lastModified(this.fileName);
    }

    public long length() {
        return this.rawInterface.getFileSize();
    }

    public void randomAccessClose() throws IOException {
        if (!this.isopen) {
            throw new IllegalStateException("XInputFile is already closed!");
        }
        if (this.pbis != null) {
            block5: {
                try {
                    this.pbis.close();
                }
                catch (IOException iOException) {
                    if (this.debug) {
                        System.out.println(iOException.getLocalizedMessage());
                    }
                    if (!this.debug) break block5;
                    iOException.printStackTrace();
                }
            }
            this.pbis = null;
        }
        this.randomAccessCurrentPosition = 0L;
        this.isopen = false;
    }

    public long randomAccessGetFilePointer() throws IOException {
        return this.randomAccessCurrentPosition;
    }

    public void randomAccessOpen(String string) throws IOException {
        if (this.isopen) {
            throw new IllegalStateException("XInputFile is already open!");
        }
        if (string.compareTo("r") != 0) {
            throw new IllegalStateException("Illegal access mode for FileType.RAW");
        }
        this.pbis = new PushbackInputStream(this.getInputStream());
        this.randomAccessCurrentPosition = 0L;
        this.isopen = true;
    }

    public int randomAccessRead() throws IOException {
        this.buffer[0] = -1;
        this.randomAccessRead(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public int randomAccessRead(byte[] byArray) throws IOException {
        return this.randomAccessRead(byArray, 0, byArray.length);
    }

    public int randomAccessRead(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        n3 = this.pbis.read(byArray, n, n2);
        if (n3 != -1) {
            this.randomAccessCurrentPosition += (long)n3;
        }
        return n3;
    }

    public String randomAccessReadLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        do {
            n = this.randomAccessRead();
            stringBuffer.append(n);
        } while (n != 13 && n != 10 && n != -1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (n == 13 && (n = this.randomAccessRead()) != 10 && n != -1) {
            this.pbis.unread(n);
            --this.randomAccessCurrentPosition;
        }
        return stringBuffer.toString();
    }

    public long randomAccessReadLong() throws IOException {
        long l = 0L;
        int n = 0;
        n = this.randomAccessRead(this.buffer, 0, 8);
        if (n < 8) {
            throw new EOFException("Less than 8 bytes read");
        }
        l = ((long)this.buffer[1] << 56) + ((long)this.buffer[2] << 48) + ((long)this.buffer[3] << 40) + ((long)this.buffer[4] << 32) + ((long)this.buffer[5] << 24) + ((long)this.buffer[6] << 16) + ((long)this.buffer[7] << 8) + (long)this.buffer[8];
        return l;
    }

    public void randomAccessSeek(long l) throws IOException {
        if (l > this.randomAccessCurrentPosition) {
            this.randomAccessCurrentPosition += this.pbis.skip(l - this.randomAccessCurrentPosition);
        }
        if (l < this.randomAccessCurrentPosition) {
            this.randomAccessClose();
            this.randomAccessOpen("r");
            this.randomAccessCurrentPosition = this.pbis.skip(l);
        }
    }

    public void randomAccessSingleRead(byte[] byArray, long l) throws IOException {
        this.randomAccessOpen("r");
        this.randomAccessSeek(l);
        this.randomAccessRead(byArray);
        this.randomAccessClose();
    }

    public void randomAccessWrite(byte[] byArray) throws IOException {
        throw new IllegalStateException("Illegal access for FileType.RAW");
    }

    public boolean rename() throws IOException {
        return false;
    }

    public void setConstructorParameter(Object object) {
        this.constructorParameter = object;
    }

    public boolean setLastModified() {
        return true;
    }

    public void setStreamInfo(StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
    }

    public String toString() {
        return this.fileName;
    }
}

