/* PVG: public interface to dither.c */

#ifndef PVGDITH_H
#define PVGDITH_H
#include <os2.h>

/* Possible dithering methods */

#define HYBRID_DITHER 0
#define HYBRID2_DITHER 1
#define FS4_DITHER 2
#define FS2_DITHER 3
#define FS2FAST_DITHER 4

/* PVG: not implemented */
#define Twox2_DITHER 5

#define GRAY_DITHER 6

/* PVG: not implemented */
#define FULL_COLOR_DITHER 7

#define NO_DITHER 8
#define ORDERED_DITHER 9

/* PVG: not implemented */
#define MONO_DITHER 10
#define MONO_THRESHOLD 11

#define ORDERED2_DITHER 12
#define MBORDERED_DITHER 13

/* Call this routine before the first time you dither or when you change the
   type of dither */
/* declared EXPENTRY because exported function from DLL */

VOID EXPENTRY InitDither(int type, int lum_range, int cr_range, int cb_range, PBYTE
                * pPalette, PBYTE *pPal2);

/* Call this routine to free the allocated resources in InitDither */
VOID EXPENTRY TerminateDither (PBYTE pPalette, PBYTE pPal2);

/* Call this routine to dither the three channels l (luminance), Cr and Cb in
   disp an image of weidth w and hight h */

VOID EXPENTRY DoDitherImage(unsigned char *l, unsigned char *Cr, unsigned char *Cb,
unsigned char *disp, int w, int h, char * f);

#endif
