/* compute vacation home purchase scenarios */

/* Note: the fig_mortgage procedure can be used in other rexx
         programs as a mortgage payment calculator */
home2buy:

/* OPSYS: the operating system you are using.
          Valid values are:
               Linux: opsys='LINUX'
               DOS: opsys='DOS'
               Windows 95: opsys='WIN95'
               Windows NT: opsys='NT'
               OS/2: opsys='OS/2'
         Notes:
          * If you are using LINUX, this should be set to LINUX.
          * If you are using OS/2, DOS, WIN95 or WINNT, you can leave
            this blank (HTML_TXT will detect the operating system)  */
opsys='OS/2'




/** User changeable parameters **/

purchase_price=300000    /* the price of the property */

down=60000             /* the downpayment */

house_frac=0.6     /* fraction of property value due to building (not due to land) */
realtor_frac=0.1     /* realtors commision (fraction of recieved rents) */
tax_rate=0.35         /* marginal income tax rate */
interest=6.625        /* mortgate interest rate (eg; 5.25 = 5.25%)  */
loan_years=30         /* length of loan, in years */


dep_years=27.5          /* linear depreciation of building, over this many years */

inflation=0.025         /* inflation rate; for rent and costs. Eg; 0.035 = 3.5%.
                            Does NOT apply house resale value. */

inflation_years=10      /* for intermediate report: report costs etc after 10 years, assuming
                           inflation.  */

bond_rate=0.04          /* risk free interest rate (i.e.; the US Savings Bond Rate)*/
appreciation=0.02       /* house price appreciation. Only applies to house resale value, 
                            not to rental reciepts and expenses */
year_wait=15            /* for intermediate report: report asset value of house, and of
                           house payments if invested at bond_rate, after this many years */

/* the following expenses are effected by the INFLATION variable */
maint=2000              /* yearly maintenance */
assoc=500               /* year association, and other miscellaneous, fees */
prop_taxes=2000         /* yearly property taxes   */
util_week=60            /* weekly utilities (applied to rental weeks only) */

peak_weeks=5            /* number of "peak weeks" (i.e.; july 4 to august 10 */
swing_weeks=4           /* number of "swing weeks" (i.e.; end of june, end of august */
early_weeks=3           /* transition weeks (i.e.; beginning june, beginning september */
off_season_weeks=8      /* off season weeks you can rent for (i.e; mid-september to november */

peak_rent=2000          /* rent during peak weeks */
swing_rent=1300         /* rent during swing weeks */
early_rent=600          /* rent during transition weeks */
off_season_rent=300     /* off-season weekly rent */

unusable_weeks=0        /* weeks house is unusuable for either rental or personal use. 
                           Minimum of 0, max of 52 - 4+peak+swing+early+off_season weeks */

scenario_description='Default scenario'  /* a descriptive name of this scenario */


/********* End of user changeable parameters *****/


call init

printer_friendly=0      /* set to 1 for "printer friendly" output */
alert_printer_friendly=1  /* if 1, popup alert if printer friendly output to seperate window */

view_mortgage=0
summaries_action=0
seperate_window=0
save_info=0

nargs=arg()
IS_SRE2002=0
if nargs<2  then do
   parse arg infile
   is_sre2002=-1
end /* do */
else do
  IF MACROQUERY("SRE_VALUE")<>'' then DO
     GOO=SRE_VALUE('SRE2002_INI',,'SRESYS')
     IF GOO<>'' then IS_SRE2002=1
  end
end
IF IS_SRE2002=0 THEN DO
  parse arg  ddir, tempfile, reqstrg,list,verb ,uri,user, ,
          basedir ,workdir,privset,enmadd,transaction,verbose, ,
         servername,host_nickname,homedir,aparam,semqueue,prog_file,reqnum
         tempdir=strip(filespec('d',tempfile)||filespec('p',tempfile),,'\')
END
if is_sre2002=1 then DO
  parse arg list,servername,verb,tempfile,,
          prog_file,reqnum,verbose,client_ip,privset,,
          uri,host_nickname,id_info,aiter
         workdir=sre_value('H2_TEMP_DIR',,'sre')
         tempdir=strip(filespec('d',tempfile)||filespec('p',tempfile),,'\')
end 
if is_sre2002=-1 then do
     workdir=value('TEMP',,'OS2environment')
     tempdir=directory()
     tempfile=tempdir||'\_OME2BUY.HTM'
     printer_friendly=1
end /* do */


if abbrev(translate(list),'HELP=')=1 then do
 call show_help
 goo=send_File(outfile,'text/html',1)
end 

if is_sre2002=-1 then
  call file_list
else
  call parse_list

if summaries_action<>0 then do
  w1=translate(strip(summaries_action))
  if w1='VIEW' | w1='RAW' then do
     ff=tempdir||'\HOME2BUY.LST'
     if stream(ff,'c','query exists')='' then do
          goo=send_message('Currently, there are no saved scenarios available.')
          return goo
     end 
     else do
         if w1='RAW' then
            goo=send_File(ff,'text/plain')
         else
           call view_summary
     end 
  end

  if w1='RESET' then do
     ff=tempdir||'\HOME2BUY.LST'
     arest=summaries_text1
     if arest='' then 
        arest='Summary of several scenarios'
     else
        arest='Summary of several scenarios: 'arest
     arf=append_File(ff,'Title: '||arest||'0d0a'x,2,,1)
     goo=send_message('Summary database has been reset.')
  end 

  if w1='TITLE' | w1='SUBTITLE' then do
      arest=summaries_text2
     if arest='' then arest=' ----------------- '
     ff=tempdir||'\HOME2BUY.LST'
     arf=append_File(ff,'0d0a'x||'SubTitle: '||arest||'0d0a'x,2)
     goo=send_message('New section added to summary database.<br><a href="/home2buy?SUMMARIES_ACTION=VIEW" target="help">View summaries of saved scenarios</a>')
  end

  return goo
end

/* get monthpay yearpay yearprin yearint yearprin_inflation */


call fig_details 0
if result=-1 then return goo


if printer_friendly<>1 then do
  atitle='Vacation home purchase scenario'
  if seperate_window=1 then atitle=atitle||' (results window)'
  call lineout outfile,'<html><head><title>'||atitle||'</title>'

  call lineout outfile,'<script language="javascript">'
  call lineout outfile,' var to_help=0 ; '
  call lineout outfile,'// zero out summary if something changes'
  call lineout outfile,'function zero_sum()'

  /* sum_expenses sum_gain sum_yearly sum_monthly sum_gain2 
     sum_yearly2 sum_monthly2 sum_Hvalue sum_cvalue sum_cvalue2
  */

  call lineout outfile,'{document.buy.sum_expenses.value="..." ;'
  call lineout outfile,'document.buy.sum_gain.value="..." ;'
  call lineout outfile,'document.buy.sum_monthly.value="..." ;'
  call lineout outfile,'document.buy.sum_yearly.value="..." ;'
  call lineout outfile,'document.buy.sum_hvalue.value="..." ;'
  call lineout outfile,'document.buy.sum_cvalue.value="..." ;'
  call lineout outfile,'document.buy.SCENARIO_DESCRIPTION.value=" " ;'

  call lineout outfile,'document.buy.sum_expenses2.value="..." ;'
  call lineout outfile,'document.buy.sum_gain2.value="..." ;'
  call lineout outfile,'document.buy.sum_monthly2.value="..." ;'
  call lineout outfile,'document.buy.sum_yearly2.value="..." ;'
  call lineout outfile,'document.buy.sum_cvalue2.value="..." ;'
  call lineout outfile,'document.buy.sum_status.value="Please recompute scenario" ;'

  call lineout outfile,'return 1 ;}'

  call lineout outfile,'// alert if printer friendly to seperate window '
  call lineout outfile,'function sub1() {'
  if alert_printer_friendly<>1 then call lineout outfile,'return 1;'
  call lineout outfile,'if (to_help==0) {return 1} ; '
  call lineout outfile,'if (document.buy.printer_friendly.checked==false) {return 1} ;'

  call lineout outfile,'window.alert(''Printer friendly output will be displayed in a seperate window. '');'
  call lineout outfile,' return 1 ;}'

  call lineout outfile,'</script>'
end
else do
     call lineout outfile,'<html><head><title>Vacation home purchase scenario (printer friendly)</title>'
end 

call lineout outfile,'</head> '
call lineout outfile,'<body> '

if is_sre2002<>-1 then
   call lineout outfile,'<form name="buy" action="/home2buy" method="GET" target="" onSubmit="sub1(); return true">'


/* links at top of screen */
  if is_sre2002<>-1 then 
  call lineout outfile,'<font size=-1><a href="/home2buy?SUMMARIES_ACTION=VIEW" target="help" >Summaries of saved scenarios</a>'

if printer_friendly<>1 then do
    call lineout outfile,' || <a href="#summary" >Summary of this scenario</a>'

  if is_sre2002<>-1 then do
    if seperate_window<>1 then do
      call lineout outfile,'|| <input type="checkbox" name="seperate_window" value=1 '
      call lineout outfile,'     onClick=" '
      call lineout outfile,'             if (to_help==0) '
      call lineout outfile,'                  {document.buy.target=''scenarios''; ;to_help=1;} '
      call lineout outfile,'              else '
      call lineout outfile,'                  {document.buy.target=''''; to_help=0  }; '
      call lineout outfile,' return true;">' 
      call lineout outfile,'Display results in seperate window'
    end
    if printer_Friendly=1 then ischecked=' CHECKED '
    call lineout outfile,'|| <input type="checkbox" name="printer_friendly" value=1 'ischecked'> '
    call lineout outfile,'Printer friendly output'

  end
end
else do
  if is_sre2002<>-1 then do
    call lineout outfile,' || <a href="/home2buy?'||xlist_p||'">Screen friendly display</a>'
    call lineout outfile,' || <a href="/" onClick="window.close(); return false ">Close</a>'
  end
end 

ischecked=' '

call lineout outfile,'</font>'

/* end of top of screen links */

if printer_friendly=1 then do
   call printer_friendly
end
else do
   call screen_friendly
   if is_sre2002<>-1 then do
      call lineout outfile,'<input type="submit" value="recompute scenario" > or  '
      call lineout outfile,'<a href="/home2buy?">reset to default values</a>'
      call lineout outfile,'</form>'
   end
end


call lineout outfile,'</body></html>'
call lineout outfile
goo=send_File(outfile,'text/html',1)


/* save summary info? */
if save_info<>1 then return goo

ff=tempdir||'\HOME2BUY.LST'
aad='0d0a'x
if stream(ff,'c','query exists')='' then do
   call lineout ff,'Title: Summary info for vacation home purchase scenarios '
   call lineout ff,' '
   call lineout ff
end 

crlf='0d0a'x
aad=crlf
aad=aad||crlf||'Description: 'scenario_description
aad=aad||crlf||'Link: 'xlist
aad=aad||crlf||'Price: '||trunc(purchase_price)
aad=aad||crlf||'Down: '||trunc(down)
aad=aad||crlf||'Rent: '||trunc(cashrent0)
aad=aad||crlf||'Shortfall: '||trunc(shortfall0)
aad=aad||crlf||'Net_Property: '||trunc(property_cashout0)
aad=aad||crlf||'Net_Cash: '||trunc(bonds_cashout)
aad=aad||crlf||'Remaining_Principal: '||trunc(remaining_principal0)
aad=aad||crlf||'Cash_Needed: '||trunc(cash_to_buy_house)
aad=aad||crlf||'End: '||scenario_description||'0d0a'x

foo=append_file(ff,aad,2)
return goo
  


/* ********************************** */
/* figure details */
fig_details:
parse arg inf
if inf=0 then do
  rent_weeks=peak_weeks+swing_weeks+early_weeks+off_season_weeks
  call do_mortgage
  

  if view_mortgage=1 then do
     crlf='0d0a'x
     ain='Mortgage Schedule '||crlf
     ain=ain||'  Mortgage Amount: $'||addcomma(purchase_price-down)||crlf
     ain=ain||'  Annual Interest: '||strip(format(interest,5,3))||crlf
     ain=ain||'  Number of Months: '||strip(loan_years)||crlf
     ain=ain||'  Monthly Payment: $'||strip(format(monthpay,10,2))||crlf||crlf
     ain=ain||'Month#   Interest    Principal  Remaining-Debt  Total-Interest '||crlf
     ain=ain'---------------------------------------------------------------------------'||crlf
     cum_p=0
     cum_i=0
     do jj=1 to payments.0
        ain=ain||left(jj,5,' ')||format(payments.jj.!interest,8,2)||'  '
        ain=ain||format(payments.jj.!principal,8,2)||'  '
        cum_p=cum_p+payments.jj.!principal
        cum_i=cum_i+payments.jj.!interest
        ain=ain||format(purchase_price-(down+cum_p),8,2)||' '
        ain=ain||format(cum_i,8,2)
        ain=ain||crlf
     end
     goo=send_message('<pre>'ain'</pre>','(mortgage schedule)')
     return -1
  end

  house_price=trunc(house_frac* purchase_price)
  outfile=workdir||'\_home2.htm'
  foo=sysfiledelete(outfile)
end
rent_frac=rent_weeks/(52-unusable_weeks)


ninf=trunc(do_pow(1+inf,inflation_years),3)
call comp_shortfall ninf
use_shortfall=shortfall

vv=purchase_price
do mm=1 to year_wait
  vv=vv*(1+appreciation)
end 
ending_price=vv
property_cashout=ending_price-(purchase_price-(down+cum_prin))
remaining_principal=purchase_price-(down+cum_prin)
vv=down
do mm=1 to year_wait
  ninf=trunc(do_pow(1+inf,mm),3)
  call comp_shortfall ninf
  vv=(vv+shortfall)*(1+bond_rate)
end 
bonds_cashout=vv

shortfall=use_shortfall

return 1

/**** compute shortfall etc */
comp_shortfall:
parse arg netinf

cashrent=(peak_weeks*peak_rent)+(swing_weeks*swing_rent)+(early_weeks*early_rent)+(off_season_weeks*off_season_rent)
cashrent=cashrent*netinf
rexp=realtor_frac*cashrent 
rent_expenses=trunc(rexp+(rent_weeks*util_week*netinf))
net_cashrent=trunc(cashrent-rent_expenses)
depreciation=trunc(house_price/dep_years)
year_expenses=yearint+(netinf*(prop_taxes+maint+assoc))
year_expenses_dep=year_expenses+depreciation
year_expenses_rental=trunc(rent_frac*year_expenses_dep)
non_rent_frac=1-rent_frac
deductions=trunc(non_rent_frac * (yearint+(netinf*prop_taxes)))
reported_rental_income=max(0,trunc(net_cashrent-year_expenses_rental))
net_deductions=deductions-reported_rental_income
deductions_refund=tax_rate * net_deductions
totincome=net_cashrent+deductions_refund
totexpenses=year_expenses+yearprin
shortfall=totexpenses-totincome

shortfall_month=shortfall/12
return 1

/*****/
/* compute mortgage schedule, and   returns monthpay yearpay yearprin yearint cum_prin */
do_mortgage:

/* fig_mortgage does the work */
monthpay=fig_mortgage(purchase_price-down,interest/100,12*loan_years)

monthpay=trunc(monthpay)
yearpay=trunc(12*monthpay)

yearprin=0 ; yearint=0
do mm=1 to 12           /* read first 12 months */
   yearint=yearint+payments.mm.!interest
   yearprin=yearprin+payments.mm.!principal
end
yearint=trunc(yearint)
yearprin=trunc(yearprin)


yearprin_inflation=0
km=inflation_years*12

do mm=km+1 to km+12           /* read first 12 months */
   yearprin_inflation=yearprin_inflation+payments.mm.!principal
end
yearprin_inflation=trunc(yearprin_inflation)


cum_prin=0 
do mm=1 to (year_wait*12)           /* read first year_wait years */
   cum_prin=cum_prin+payments.mm.!principal
end
cum_prin=trunc(cum_prin)


return 1


init:

/* not used 
foo=rxfuncquery('rexxlibregister')
if foo=1 then do
 foo=rxfuncadd( 'rexxlibregister','rexxlib', 'rexxlibregister')
  if foo=1 then do
     say "ERROR: could not find RexxLib.DLL " 
     exit
  end /* do */
 call rexxlibregister
end
*/

foo=rxfuncquery('sysloadfuncs')
if foo=1 then do
  foo=RxFuncAdd( 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
  if foo=1 then do
     say "ERROR: could not find RexxUtil.DLL " 
     exit
  end /* do */
  call SysLoadFuncs
end
return 0




/*  add commas, and truncate decimal portion.

Example of calling:

say " value " 
parse pull aval
say " ndec "
parse pull ndec
oo=addcomma(aval,ndec)
say oo
exit

*/

/************/
/* ADD COMMAS TO A NUMBER */
addcomma:
parse arg aval,ndec
aval=strip(aval)
parse var aval p1 '.' p2

if aval<0 & aval > -1000 then return aval

if ndec='' then do
   p2=''
end
else do
   p2='.'||left(p2,ndec,'0')
end /* do */

plen=length(p1)
p1new=''
do i=1 to 10000 while plen>3
   p1new=','right(p1,3)||p1new
   p1=delstr(p1,plen-2)
   plen=plen-3
end /* do */

return p1||p1new||p2

/********/
/* parse list of arguments */
parse_list:
xlist=''
xlist_p=xlist
do until list=''
    parse var list a1z '&' list
    a10=translate(a1z,' ','+,')
    if a10='' then iterate
    parse var a10 avar '=' avalue
    avar=space(do_packur(avar),0)
    avalue=strip(do_packur(avalue))
    tavar=translate(avar)

    if abbrev(tavar,'SUM_')=1   then iterate
    if  tavar='SCENARIO_DESCRIPTION' | abbrev(tavar,'SUMMARIES_T')=1 then do
         nop
    end 
    else do
       avalue=space(avalue,0)
    end 
   
    if tavar<>'SAVE_INFO' then do
         if xlist='' then 
            xlist=a1z
         else
            xlist=xlist||'&'||a1z
         if abbrev(translate(avar),'PRINTER_F')=0 then do
           if xlist_p='' then 
               xlist_p=a1z
           else
               xlist_p=xlist_p||'&'||a1z
         end
    end 
    foo=value(avar,avalue)
end
/* if scenario_description<>'' then xlist=xlist||'&SCENARIO_DESCRIPTION='||translate(scenario_description,'+',' ') */
return 1



/********/
/* output to screen */
screen_friendly:

call lineout outfile,'<h3 align="center">Vacation home purchase scenario</h3> '
if is_sre2002<>-1 then do
  call lineout outfile,'<em> Compute a variety of financial calculations concerning'
  call lineout outfile,'the purchase of a 2nd (vacation) home</em>.'
end
else do
  call lineout outfile,'<em> Results from: Home2Buy -- Financial calculations concerning he purchase of a 2nd (vacation) home.</em>'
end /* do */

call lineout outfile,'<ul>'
if is_sre2002<>-1 then do
  call lineout outfile,'<li>you can change the various <em>assumptions</em> (in the <tt>text boxes</tt>), and then '
  call lineout outfile,'<input type="submit" value="recompute scenario" >  '
  call lineout outfile,' to see how  your payments et. al. change</em><br>'
end
call lineout outfile,'<li>Note that values in <font color="green">green</font> are intermediate sums. '
call lineout outfile,'If you change an <em>assumption</em>, they may no longer be valid  '
if is_sre2002<>-1 then 
  call lineout outfile,' -- to update these values, just <input type="submit" value="recompute scenario" >!'

if is_sre2002=-1 then  do
   call lineout outfile,'<li> Note that in this <em>standalone</em> mode the <a href="javascript:window.alert(''This is a non-working link!'');">links</a> do <b>not</b> work'
   call lineout outfile,'(run Home2Buy as a web-script to utilize its full power)!'
end
call lineout outfile,'</ul>'

if is_sre2002<>-1 then do
  call lineout outfile,'<table><tr  bgcolor="skyblue"><td><a href="/home2buy?help=SUMMARY" target="help">Scenario description</a></td>'
  call lineout outfile,'<td> <input type="text" size=50 name="SCENARIO_DESCRIPTION" value="'||scenario_description||'">'
  call lineout outfile,'<td bgcolor="lightgrey"> <input type="checkbox"  name="SAVE_INFO" value=1>Save&nbsp;recomputed&nbsp;scenario?'
  call lineout outfile,'</table>'
end

sd=scenario_description
call lineout outfile,'<p><B>Scenario description: </b><tt> '||sd||'</tt>'
call lineout outfile,'<table  border=1 >'

amm='<input type="text"   onChange="zero_sum();" size=7 name="purchase_price" value='||addcomma(purchase_price)||'>'
amm1='<input type="text"   onChange="zero_sum();" size=4 name="house_frac" value='||house_frac||'>'

call lineout outfile,'<tr><td><a href="/home2buy?HELP=PRICE" target="help">Price</a>= <b>'amm '</b><td>'
call lineout outfile,'<tt>if &nbsp;'||amm1||' of price is for the house, <br>&nbsp;the '
call lineout outfile,'<a href="/home2buy?help=VAL_BUILD" target="help">value of the building</a>=<font color="green"> '||addcomma(house_price)'</font></tt>'

amm='<input type="text"  onChange="zero_sum();" size=7 name="down" value='||addcomma(down)||'>'
call lineout outfile,'<tr><td>Down<b> '||amm|| '</b><td>The down payment </td>'
zamm='<input type="text"   onChange="zero_sum();" size=7 name="interest" value='||interest||'>'
call lineout outfile,'<tr><td><a href="/home2buy?help=INTEREST" target="help">Interest</a> = <b>'zamm'</b>'

amm='<input type="text"   onChange="zero_sum();" size=4 name="loan_years" value='||loan_years||'>'
call lineout outfile,'<br>Length of loan = <b>'amm'</b> years'

call lineout outfile,'<td>&nbsp;&nbsp;&nbsp;Monthly payment: <font color="green"> 'monthpay ' </font>'
call lineout outfile,', yearly=  <font color="green">'||addcomma(yearpay)||' </font>'
call lineout outfile,'<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 1st yr: interest=<font color="green">'||addcomma(yearint)||'</font> &amp; principal=<font color="green">'||addcomma(yearprin)||'</font>'

if is_sre2002<>-1 then do
   call lineout outfile,'<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
   call lineout outfile,'<input type="checkbox" name="VIEW_MORTGAGE"'
   call lineout outfile,'     onClick="document.buy.target=''scenarios''; document.buy.submit()'
   call lineout outfile,'              return false;"' 
   call lineout outfile,' value=1>'
   call lineout outfile,'<font color="blue">View a list of monthly mortgage payments?</font>'
end

call lineout outfile,' '
call lineout outfile,'<tr><td>Rental income=<font color="green"><b>'||addcomma(cashrent) '</b></font>'
call lineout outfile,' <p><tt>Total weeks rented= <font color="green">'rent_weeks'</font><br>  yields rental fraction of <font color="green">'||trunc(100*rent_Frac)||'% </font> </tt>'

amm1='<input type="text"   onChange="zero_sum();" size=2 name="peak_weeks" value='||peak_weeks||'>'
amm1a='<input type="text"  onChange="zero_sum();" size=4 name="peak_rent" value='||peak_rent||'>'

amm2='<input type="text"  onChange="zero_sum();" size=2 name="swing_weeks" value='||swing_weeks||'>'
amm2a='<input type="text"  onChange="zero_sum();" size=4 name="swing_rent" value='||swing_rent||'>'

amm3='<input type="text"  onChange="zero_sum();" size=2 name="early_weeks" value='||early_weeks||'>'
amm3a='<input type="text"  onChange="zero_sum();" size=4 name="early_rent" value='||early_rent||'>'

amm4='<input type="text"   onChange="zero_sum();" size=2 name="off_season_weeks" value='||off_season_weeks||'>'
amm4a='<input type="text"  onChange="zero_sum();" size=4 name="off_season_rent" value='||off_season_rent||'>'

amm5='<input type="text"   onChange="zero_sum();" size=2 name="unusable_weeks" value='||unusable_weeks||'>'


  call lineout outfile,'<td><Pre>   Peak weeks: <font color="green"> '||trunc(peak_rent*peak_weeks)||' </font>&nbsp; ('||amm1||' weeks @ '||amm1a||')'
  call lineout outfile,'   Swing weeks:<font color="green"> '||trunc(swing_rent*swing_weeks)||'</font>&nbsp; ('||amm2||' weeks @ '||amm2a||')'
  call lineout outfile,'   End/start weeks: <font color="green">'||trunc(early_rent*early_weeks)||'</font>&nbsp; ('||amm3||' weeks @ '||amm3a||')'
  call lineout outfile,'   Off-season weeks: <font color="green">'||trunc(off_season_weeks*off_season_rent)||'</font>&nbsp; ('||amm4||' weeks @ '||amm4a
  call lineout outfile,'   <a href="/home2buy?help=unusable" target="help">Unusuable weeks</a>: '||amm5||'</pre>'

  call lineout outfile,''

call lineout outfile,'<tr><td>Net cash rent= <b><font color="green"> '||addcomma(net_cashrent) '</font></b>'
  call lineout outfile,'<td><Pre>   Rental income: <font color="green"> '||trunc(cashrent)||'</font>, minus '

amm='<input type="text"  onChange="zero_sum();" size=3 name="realtor_frac" value='||realtor_frac||'>'
  call lineout outfile,'     <a href="/home2buy?help=REALTOR" target="help">Realtor commission</a>: <font color="green">'||trunc(rexp)||'</font>&nbsp; (at 'amm||' of rental income )'

amm='<input type="text"  onChange="zero_sum();" size=3 name="util_week" value='||util_week||'>'
  call lineout outfile,'     <a href="/home2buy?help=UTILITIES" target="help">Utilities</a>: <font color="green">'||trunc(rent_weeks*util_week)||'</font> (@ '||amm||' per week) </pre>'

call lineout outfile,' '


call lineout outfile,'<tr><td>Yearly expenses due to rental=<b> <font color="green">'||addcomma(trunc(year_expenses_rental))'</font></b>'
ff=trunc(100*rent_frac)
call lineout outfile,'<td><Pre>  <a href="/home2buy?help=REPORTABLE_YEARLY" target="help"> Reportable yearly expenses</a> (<font color="green">'||trunc(year_expenses_dep)|| '</font>) * rental_fraction (<font color="green">'||ff||'</font>%)'
call lineout outfile,'     Interest: <font color="green">' yearint ||'</font>'

amm='<input type="text"  onChange="zero_sum();" size=7 name="prop_taxes" value='||addcomma(prop_taxes)||'>'
call lineout outfile,'     Property taxes: ' amm

amm='<input type="text"  onChange="zero_sum();" size=7 name="maint" value='||addcomma(maint)||'>'
call lineout outfile,'     Maintenance: ' amm

amm='<input type="text"  onChange="zero_sum();" size=7 name="assoc" value='||addcomma(assoc)||'>'
call lineout outfile,'  &nbsp;&nbsp; <a href="/home2buy?help=OTHER_FEES" target="help">Other yearly fees </a>: ' amm

amm='<input type="text"  onChange="zero_sum();" size=4 name="dep_years" value='||dep_years||'>'
call lineout outfile,'     <a href="/home2buy?help=depreciation" target="help">Depreciation</a>: over '||amm||' years  =  <font color="green">'|| depreciation||'</font></pre>'

call lineout outfile,'  '
call lineout outfile,'<tr><td><a href="/home2buy?help=REPORTED_RENTAL_INCOME" target="help">Reported rental income</a>= <b><font color="green"> '||addcomma(reported_rental_income)'</font></b>'
call lineout outfile,'<td><tt> Max of 0 and (Net_cash_rent - Yearly_expenses_due_to_rental)</tt> '

call lineout outfile,' '

if deductions_refund<0 then do
   call lineout outfile,'<tr><td><a href="/home2buy?help=REFUND" target="help">Tax on profits</a>:<b><font color="green"> '
   call lineout outfile,addcomma(trunc(-deductions_refund))

end
else do
   call lineout outfile,'<tr><td><a href="/home2buy?help=REFUND" target="help">Extra tax refund</a>:<b><font color="green"> '
   call lineout outfile,addcomma(trunc(deductions_refund))
end 
call lineout outfile,'</font></b>'
call lineout outfile,'<td><pre> Deductions: <font color="green">'||yearint'</font> &amp; <font color="green">'prop_taxes||'</font>;  non-rental fraction (of year): <font color="green">'||trunc(100*non_rent_frac)||'</font>% '
call lineout outfile,'   Pro-rated non-rental deductions:<font color="green"> '||trunc(deductions)||'</font>'
call lineout outfile,'   Non-rental deductions - reported rental income:<font color="green"> '||trunc(net_deductions)||'</font>'

amm='<input type="text"  onChange="zero_sum();" size=4 name="tax_rate" value='||tax_rate||'>'
call lineout outfile,'   <a href="/home2buy?help=MARGINAL_TAX" target="help">Marginal tax rate</a>: '||amm||' </pre>'

call lineout outfile,'</table> '

if is_sre2002<>-1 then 
   call lineout outfile,'<center><input type="submit" value="Recompute scenario"> </center> '

call lineout outfile,' '


call lineout outfile,'<p>'


/* display summary...*/

call lineout outfile,'<table border=0>'
if is_sre2002<>-1 then do
  call lineout outfile,'<Tr  bgcolor="gold"><td colspan=2 ><a name="summary"><b>Summary:</b></a> <input size=60  onChange="zero_sum();" type="text" name="sum_status" '
  call lineout outfile,' value="First year status, with price='purchase_price', interest='interest', etc." >'
  call lineout outfile,'</td>'
end
else do
  call lineout outfile,'<Tr><td colspan=2 ><a name="summary"><b>Summary:</b></a>'
end /* do */

call lineout outfile,'<tr ><td bgcolor="tan">'
call lineout outfile,'<h4 align="center">Net expenses &amp; income</h4>'
call lineout outfile,'<table border=1>'


vv=addcomma(trunc(totexpenses))
imm='<input type="text"  onChange="zero_sum();" name="sum_expenses" size=6 value="'vv'">'
zzimm='<select name="sum_expenses" size=1><option>'||vv||'</select>'

call lineout outfile,'<tr><td>Yearly expenses:</td> <th>'||imm||'</th>'
call lineout outfile,'<td><tt>includes <font color="green">'yearprin'</font> principal, excludes depreciation</tt></td>'

vv=addcomma(trunc(totincome))
imm='<input type="text"  onChange="zero_sum();" name="sum_gain" size=6 value="'vv'">'
call lineout outfile,'<tr><td>Yearly income gain: </td><th> '||imm||'</th>'

if deductions_refund<0 then 
   call lineout outfile,'<td><Tt>net cash rent - tax on profit</tt></td>'
else
   call lineout outfile,'<td><Tt>net cash rent + extra tax refund </tt></td>'

shortfall=totexpenses-totincome
vv=addcomma(shortfall)
imm='<input type="text"  onChange="zero_sum();" name="sum_yearly" size=6 value="'vv'">'
shortfall_month=shortfall/12
vv=addcomma(shortfall_month)
imm2='<input type="text"  onChange="zero_sum();" name="sum_monthly" size=6 value="'vv'">'


call lineout outfile,'<tr><td><a href="/home2buy?help=shortfall" target="help"> Monthly shortfall</a><br>(yearly):'
call lineout outfile,'</td><th> '||imm2||'<br> '||imm
call lineout outfile,'</th><td><tt>(expenses-gain) / 12 <br> &nbsp; </tt></td>'

property_cashout0=property_cashout
remaining_principal0=remaining_principal
shortfall0=shortfall
bonds_cashout0=bonds_cashout
cashrent0=cashrent
ending_price0=ending_price
cash_to_buy_house0=ending_price0-bonds_cashout0

/** Inflation adjustment */

call fig_details inflation


call lineout outfile,'<tr><th colspan=2> <a href="/home2buy?help=INF_ADJ" target="help">Accounting for inflation</a></th> '
call lineout outfile,'<td>'
amm1=' <input type="text"  onChange="zero_sum();" size=5 name="inflation_years" value='||inflation_years||'>'
call lineout outfile,'<em>After &nbsp; 'amm1' years of &nbsp; '
amm2=' <input type="text"  onChange="zero_sum();" size=5 name="inflation" value='||inflation||'> '
call lineout outfile,amm2||' inflation ... </em></td>'

vv=addcomma(trunc(totexpenses))
imm='<input type="text"  onChange="zero_sum();" name="sum_expenses2" size=6 value="'vv'">'
call lineout outfile,'<tr><td>Yearly expenses:</td> <th>'||imm||'</th>'
call lineout outfile,'<td><tt>includes <font color="green">'yearprin_inflation'</font> principal, excludes depreciation</tt></td>'

vv=addcomma(trunc(totincome))
imm='<input type="text"  onChange="zero_sum();" name="sum_gain2" size=6 value="'vv'">'
call lineout outfile,'<tr><td>Yearly income gain: </td><th> '||imm||'</th>'
call lineout outfile,'<td><Tt>net cash rent + extra tax refund </tt></td>'

vv=addcomma(shortfall)
imm='<input type="text"  onChange="zero_sum();" name="sum_yearly2" size=6 value="'vv'">'
shortfall_month=shortfall/12
vv=addcomma(shortfall_month)
imm2='<input type="text"  onChange="zero_sum();" name="sum_monthly2" size=6 value="'vv'">'

call lineout outfile,'<tr><td> Monthly shortfall<br>(yearly):</td>'
call lineout outfile,'<th> '||imm2||'<br> '||imm||'</th>'
call lineout outfile,'<td><tt>(expenses-gain) / 12 <br> &nbsp; </tt></td>'

call lineout outfile,'</table>'

/****** INVESTMENT  */
call lineout outfile,'</td><td  bgcolor="cyan"  valign="top">'

call lineout outfile,'<h4 align="center">Investment comparision</h4>'

amm='<input type="text"  onChange="zero_sum();" size=3 name="year_wait" value='||year_wait||'>'
call lineout outfile,'<em><a href="/home2buy?help=INV_COMP" target="help">Earnings</a> after &nbsp; &nbsp; 'amm' years ...</em>'

call lineout outfile,'<table border=1>'
call lineout outfile,'<tr>'
call lineout outfile,'<td>'
call lineout outfile,'<a href="/home2buy?help=NET_PROPERTY" target="help">Net property value</a>='


vv2=addcomma(trunc(property_cashout0))
imm='<input type="text"  onChange="zero_sum();" name="sum_hvalue" size=7 value="'vv2'">'
call lineout outfile,imm

amm2='<input type="text"  onChange="zero_sum();" size=5 name="appreciation" value='||appreciation||'>'
call lineout outfile,'</td><td> Using yearly <a href="/home2buy?help=appreciation" target="help">appreciation rate</a>: 'amm2
call lineout outfile,'<br> <tt>Remaining principal:<font color="green"> '||addcomma(remaining_principal0)'</font></tt>'

vv=trunc(1000*shortfall0/(purchase_price - down))/10
call lineout outfile,'<br> <em>Effective mortgage interest:<font color="green"> 'vv'</font>%</em>'

call lineout outfile,'</td><tr>'
call lineout outfile,'<td>'
call lineout outfile,'<a href="/home2buy?help=CASH_VALUE" target="help">Cash value</a>='

vv=addcomma(trunc(bonds_cashout0))
imm='<input type="text"  onChange="zero_sum();" name="sum_cvalue" size=7 value="'vv'">'
call lineout outfile,imm

amm2='<input type="text"  onChange="zero_sum();" size=5 name="bond_rate" value='||bond_rate||'>'
call lineout outfile,'</td><td>US saving bond rate: 'amm2

call lineout outfile,'<br> <tt><a href="/home2buy?help=DOLLARS_NEEDED" target="help">$ needed to buy house</a>:<font color="green"> '||addcomma(trunc(cash_to_buy_house0)) '</font></tt>'


call lineout outfile,'</td><tr>'
call lineout outfile,'<td>'
call lineout outfile,'w/inflation='

vv=addcomma(trunc(bonds_cashout))
imm='<input type="text"  onChange="zero_sum();" name="sum_cvalue2" size=7 value="'vv'">'
call lineout outfile,imm

call lineout outfile,'</td><td> As above, accounting for inflation. '
cash_to_buy_house=ending_price0-bonds_cashout
call lineout outfile,'<br> <tt>$ needed to buy house:<font color="green"> '||addcomma(trunc(cash_to_buy_house)) '</font></tt>'


/*** Not implmented 
call lineout outfile,'</td><tr>'
call lineout outfile,'<td>'
call lineout outfile,'&amp; <a href="/home2buy?help=EXTRA_SAVINGS" target="help">w/extra savings</a>='

tvv=0
do mm=1 to year_wait
  tvv=(tvv+extra_savings)*(1+bond_rate)
end 

vv=addcomma(trunc(tvv + bonds_cashout))
imm='<input type="text"  onChange="zero_sum();" name="sum_cvalue2" size=7 value="'vv'">'
call lineout outfile,imm

amm2='<input type="text"  onChange="zero_sum();" size=6 name="extra_savings" value='||extra_savings||'>'

call lineout outfile,'</td><td> As above, saving '||amm2||' per year. '
cash_to_buy_house2=ending_price0-(tvv+bonds_cashout)
call lineout outfile,'<br> <tt>$ needed to buy house:<font color="green"> '||addcomma(trunc(cash_to_buy_house2)) '</font></tt>'
*/

call lineout outfile,'</td></table>'
call lineout outfile,'</td></table>'


return 1


/********/
/* output to printer */
printer_friendly:

call lineout outfile,'<h3 align="center">Vacation home purchase scenario</h3> '

sd=scenario_description

call lineout outfile,'<p><B>Scenario description: </b><tt> '||sd||'</tt>'

call lineout outfile,'<table  border=1 >'

call lineout outfile,'<tr><th colspan=2><u>Assumptions</u> and intermediate results</th> '
call lineout outfile,'<tr><th>Price:'
call lineout outfile,'<td><u>'||addcomma(purchase_price) ||'</u>'
call lineout outfile,', with building value= <u>'||addcomma(house_price)||'</u>'
call lineout outfile,'<tr><th>Down&nbsp;payment:</th><td><u> '||addcomma(down)||'</u>'

call lineout outfile,'<tr><th>Interest rate:</th><td> <u>'||interest||'</u>'
call lineout outfile,' over <u>'||loan_years||'</u> years'
call lineout outfile,'<tr><th>Mortgage Payments:</th> '
call lineout outfile,'<td><ul><li>Monthly & yearly:<tt> '||monthpay||' &amp; '||addcomma(yearpay)||'</tt>'
call lineout outfile,'<li>Yearly interest and principal:<tt> '||addcomma(yearint)||' &amp; '||addcomma(yearprin)||'</tt>'
call lineout outfile,'</ul></td> '
call lineout outfile,' '
call lineout outfile,'<tr><th>Rental income: </th><td><b>'
call lineout outfile,'<table><tr><th rowspan=2>'||addcomma(cashrent)||'</th>'
call lineout outfile,'<td><ul type="circle"><li> over <u>'||rent_weeks||'</u> weeks '
call lineout outfile,' w/ <u> '||unusable_weeks||'</u> unusable weeks (<tt>'
call lineout outfile,trunc(100*rent_Frac)||'% of year)</tt>'
call lineout outfile,'<li><em>... rents range from <u>'||peak_rent||'</u> to <u> '||off_season_rent||'</u></em>'
call lineout outfile,'</ul></td></table>'

call lineout outfile,'<tr><th>Net cash rent:</th><td>'
call lineout outfile,'<table><th colspan=2>'||addcomma(net_cashrent) '</th>'
call lineout outfile,'<td><ul type="circle"><li><em>incorporates <u>'||(trunc(rexp))||'</u> realtor commission and <u>'
call lineout outfile,trunc(rent_weeks*util_week)||'</u> utilities </em></ul></td></table>'


call lineout outfile,'<tr><th>Yearly expenses due to rental:</th>'
call lineout outfile,'<td><table><th>'||addcomma(trunc(year_expenses_rental))'</th>'

call lineout outfile,' <td><ul>'
call lineout outfile,'<li type="square">Sum of total reportable yearly expenses (<tt>'||trunc(year_expenses_dep)||'</tt>)'
call lineout outfile,'<li type="circle">Interest:<tt> '|| yearint||'</tt>'
call lineout outfile,'<li>Property taxes: <u>'||addcomma(prop_taxes)||'</u>'
call lineout outfile,'<li>Maintenance: <u>'||addcomma(maint)||'</u>'
call lineout outfile,'<li>Other yearly (association, etc.) fees: <u>'||addcomma(assoc)||'</u>'
call lineout outfile,'<li>Depreciation over <u>'||dep_years||'</u> years: <tt>'||depreciation||'</tt>'
call lineout outfile,'<li type="square">times rental_fraction (<tt>'||trunc(100*rent_frac)||'%</tt>)'

call lineout outfile,' </ul></td></table> '

call lineout outfile,'<tr><th>Reported rental income:</th><td>'||addcomma(reported_rental_income)'</td>'

call lineout outfile,' '

if deductions_refund<0 then do
   call lineout outfile,'<tr><th>Tax on profits</th>'
   call lineout outfile,'<td><table>'
   call lineout outfile,'<th>'||addcomma(trunc(-deductions_refund))||'</th>'
end
else do
   call lineout outfile,'<tr><th>Extra tax refund</th>'
   call lineout outfile,'<td><table>'
   call lineout outfile,'<th>'||addcomma(trunc(deductions_refund))||'</th>'
end 
call lineout outfile,'<td>'

call lineout outfile,'<ul type="circle"> '

call lineout outfile,'<li> Deductions (interest + property taxes): <tt>'
call lineout outfile, addcomma(yearint+prop_taxes)||' </tt>'

call lineout outfile,'<li> times non-rental fraction (of year):<tt> '||trunc(100*non_rent_frac)||'% '
call lineout outfile,' = '||trunc(deductions)||'</tt>'

call lineout outfile,'<li> minus reported rental income: <tt> '||addcomma(reported_rental_income)||' = '
call lineout outfile,trunc(net_deductions)||'</tt>'

call lineout outfile,'<li> times marginal tax rate: rental income:<tt> '||trunc(100*tax_rate)||'%</tt>'

call lineout outfile,'</ul></td></table>'


call lineout outfile,'</table> '


call lineout outfile,'<p>'


/* display summary...*/


call lineout outfile,'<p><B>Summary: </b>'

call lineout outfile,'<table border=1>'
call lineout outfile,'<th> &nbsp; <th>&nbsp;'
call lineout outfile,'<th><em>After <u>'||inflation_years||'</u> years of <u>'||format(100*inflation,5,2)||'</u>% inflation </em></th>'

totexpenses1=totexpenses
yearprin1=yearprin
deductions_refund1=deductions_refund
sum_gain1=sum_gain
shortfall1=totexpenses-totincome

totincome0=totincome
property_cashout0=property_cashout
remaining_principal0=remaining_principal
shortfall0=shortfall
bonds_cashout0=bonds_cashout
cashrent0=cashrent
ending_price0=ending_price
cash_to_buy_house0=ending_price0-bonds_cashout0

call fig_details inflation      /* get inflation adjusted values */

call lineout outfile,'<tr><th>Yearly cash outlays:</th>'
call lineout outfile,'<td><b>'||addcomma(trunc(totexpenses1))||'</b>'
call lineout outfile,'&nbsp;&nbsp;&nbsp;(includes <tt>'||addcomma(yearprin1)||'</tt> principal) '
call lineout outfile,'</td>'

call lineout outfile,'<td><b>'||addcomma(trunc(totexpenses))||'</b>'
call lineout outfile,' &nbsp;&nbsp;&nbsp;(includes <tt> 'yearprin_inflation' </tt> principal)'
call lineout outfile,'</td>'


call lineout outfile,'<tr><th>Yearly income gain:</th>'
call lineout outfile,'<td><b>'||addcomma(totincome0) ||'</b>'
call lineout outfile,' &nbsp;&nbsp;&nbsp;'
if deductions_refund1<0 then 
   call lineout outfile,'(net cash rent - tax on profit)'
else
   call lineout outfile,'(net cash rent + tax refund) '
call lineout outfile,'</td>'

call lineout outfile,'<td><b>'||addcomma(totincome)||'</b>'
if deductions_refund<0 then 
   call lineout outfile,'(net cash rent - tax on profit)'
else
   call lineout outfile,'(net cash rent + tax refund) '
call lineout outfile,'</td>'


call lineout outfile,'<tr><td><table><th>Shortfall</th>'
call lineout outfile,'<td><ul><li>Monthly:<li>Yearly:</ul></td></table></td>'
call lineout outfile,'<td><ul><li type="circle">'||addcomma(trunc(shortfall1/12))
call lineout outfile,'<li type="circle">'||addcomma(trunc(shortfall1))
call lineout outfile,'</ul></td>'


call lineout outfile,'<td><ul><li type="circle"> '||addcomma(trunc(shortfall/12))
call lineout outfile,'<li type="circle"> '||addcomma(trunc(shortfall))
call lineout outfile,'</ul></td>'



call lineout outfile,'</table>'



/****** INVESTMENT  */
call lineout outfile,'<p><b>Investment comparision after <u>'||year_wait||'</u> years: </b>'

call lineout outfile,'</em>'

call lineout outfile,'<table border=1>'
call lineout outfile,'<tr>'
call lineout outfile,'<th>Net property value: </th>'
call lineout outfile,'<td><b> '||addcomma(trunc(property_cashout0))||'</b>&nbsp;&nbsp;&nbsp;</td>'
call lineout outfile,'<td> remaining principal: <tt>'||addcomma(remaining_principal0)'</tt> &nbsp;&nbsp;</td>'
call lineout outfile,'<td><em>Assumes:&nbsp;'
call lineout outfile,'  <u>'||format(100*appreciation,5,2)||'</u>% appreciation</em></td> '

/*
call lineout outfile,'<tr><th align="left" ><ul><li>Cash value:'
call lineout outfile,'<li>accounting for inflation:</ul></th>'
cash_to_buy_house2=ending_price-bonds_cashout
call lineout outfile,'<td ><ul type="circle"><li><b>'||addcomma(trunc(bonds_cashout0))||'</b>'
call lineout outfile,'<li><b>'||addcomma(trunc(bonds_cashout))||'</b></ul></td>'
call lineout outfile,'<td><ul type="circle"><li> <em>$ to buy house: '||addcomma(trunc(cash_to_buy_house0))||'</em>'
call lineout outfile,'<li><em> $ to buy house: '||addcomma(trunc(cash_to_buy_house2))||'</em></ul></td>'
*/

call lineout outfile,'<tr><th align="left" >Cash value:</th>'
cash_to_buy_house=ending_price-bonds_cashout
call lineout outfile,'<td> <b> '||addcomma(trunc(bonds_cashout))||' </b>&nbsp;&nbsp;&nbsp;</td>'
call lineout outfile,'<td>  $ to buy house: <tt>'||addcomma(trunc(cash_to_buy_house))||'</tt></td>'
call lineout outfile,'<td><em>Assumes <u>'||format(100*bond_rate,5,1)||'</u>% bond rate &amp; '
call lineout outfile,' <u>'||format(100*inflation,5,1)||'</u>% inflation '

call lineout outfile,'</td></table>'


return 1



/***/
/* this displays help */
show_help:
call lineout outfile,'<html><head><title>Vacation home purchase scenario: help</title>'
call lineout outfile,'</head> '
call lineout outfile,'<body> '

call lineout outfile,'<h3>Tips and definitions: Vacation home purchase scenario</h3> '

parse upper var list . '=' awhat .


select
   when  awhat="PRICE" then do
        call lineout outfile,'The price of the house, not including closing costs.'
   end /* do */
   when awhat="DOWN" then do
        call lineout outfile,'The down payment.'
   end
   when awhat="INTEREST" then do
        call lineout outfile,'You can change the:<Ul>'
        call lineout outfile,'<li>the yearly interest rate on the loan'
        call lineout outfile,'<li>the length of the loan (the number of years to pay it off)'
        call lineout outfile,'</ul>'
        call lineout outfile,'Note that the yearly (and monthly payments) are computed using the '
        call lineout outfile,'interest rate, the length of the loan, and the price minus the down_payment.'
   end
   when awhat="INV_COMP" then do
        call lineout outfile,'The <b>Investment Comparison</b> table compares the investment value of the property against '
        call lineout outfile,'what you''ld have <em>in the bank</em> if you had put your money into a safe '
        call lineout outfile,'investment (paying the US Savings Bond Rate) instead.'
        call lineout outfile,'<p>In other words, this compares two asset values (after the selected number of years):<ol type="i">'
        call lineout outfile,'<li>What you would have if you sold the house (after paying of any remaining principal)'
        call lineout outfile,'<li>What you would have if you had saved your down payment, and all the '
        call lineout outfile,'shortfall payments you made'
        call lineout outfile,'</ol>'
        call lineout outfile,'<table><tr><th>Note: &nbsp;</th>'
        call lineout outfile,'<td><em>Accounting for inflation yearly shortfalls</em> refers to'
        call lineout outfile,'actual shortfalls, after accounting for increased costs and increased rents -- '
        call lineout outfile,'with increases due to inflation. <br>It does <b>not</b> mean computing '
        call lineout outfile,'a <em>constant dollar </em> value of payments </td></table>'
        
        call lineout outfile,''
   end
   when awhat="INF_ADJ" then do
        call lineout outfile,'The  <b>Accounting for inflation</b> rows of this table list what  (after the selected number of years) your expenses and net-income will be'
        call lineout outfile,' -- assuming that there is  a steady rate of inflation.'
        call lineout outfile,'<p>Inflation is assumed to have the same impact on  utilities, '
        call lineout outfile,'association fees, property taxes, and on the rents you charge,. That is, all these increase at the <em>inflation</em> percentage rate per year'

     
   end
   when awhat="DEPRECIATION" then do
        call lineout outfile,'<ul><li><b>Depreciation</b> applies only to the building -- not to land'
        call lineout outfile,'<br>(the program could, but does not bother, with depreciating '
        call lineout outfile,'appliances etc.)'
        call lineout outfile,'<li>The depreciation you can deduct, like other costs, is a pro-rated fraction '
        call lineout outfile,'of total depreciation. That is, you can only treat depreciation as an expense'
        call lineout outfile,'only for the time period during which the property is being used as a rental.'
        call lineout outfile,'</ul>'

   end
   when awhat="VAL_BUILD" then do
        call lineout outfile,'The <b>value of the building</b> refers to what the house costs.'
        call lineout outfile,'That is, it is the property value minus the value of the land.<br>'
        call lineout outfile,'<p>Typically, this is determined by using appraised values.'
        call lineout outfile,'For example, if the price is $200,000 and <ul>'
        call lineout outfile,' <li>if the building is appraised at $40,000. and the'
        call lineout outfile,'<li> land is appraised at $60,000,  '
        call lineout outfile,'</ul>then the  <em>value of the building </em> is (40,000/100,000)*200,000= $80,000 '
        
        call lineout outfile,'<p>Note that the value of the building is subject to depreciation, while'
        call lineout outfile,'that value of the land is <b>not</b> subject to depreciation.'
   end
   when awhat="MARGINAL_TAX" then do
       call lineout outfile,'The <b>marginal tax rate</b> is the income tax you pay on'
       call lineout outfile,'the last dollar you earn. This should include your federal, state,'
       call lineout outfile,'and local income taxes.'
       call lineout outfile,'<table><tr><th>Note: &nbsp;'

       call lineout outfile,'<td>If you already have large itemized deductions, only a fraction (about 80%) of your second home mortgage'
       call lineout outfile,'and property tax deductions will be permitted. '
       call lineout outfile,'This can be accounted for by reducing your marginal tax rate.</table>'
       call lineout outfile,''

   end
   when awhat="REFUND" then do
       call lineout outfile,'The <b>extra tax refund</b> is the additional refund you get' 
       call lineout outfile,'from the IRS due to owning this property. It is determined by:'
       call lineout outfile,'<ul><li>computing your <em>non-rental</em> mortgage interest &amp; property taxes'
       call lineout outfile,'(that is, the interest and taxes due to using'
       call lineout outfile,'the house as a second home).'

       call lineout outfile,'<li>subtracting'
       call lineout outfile,'your net rental income from this <em>non-rental</em> mortgage interest'
       call lineout outfile,'&amp; property taxes '
       call lineout outfile,'<li> multiplying this difference by your marginal tax rate'
       call lineout outfile,'</ul>'
       call lineout outfile,'Note that if you are making a profit (if your net rental income is greater'
       call lineout outfile,'then your non-rental interest &amp; taxes), the  taxes you pay on this profit are shown.'
   end
   when awhat="OTHER_FEES" then do
        call lineout outfile,'<b>Other yearly fees</b> refers to expenses that occur on a'
        call lineout outfile,'yearly basis, and then are not effected by whether you rent or not.'
        call lineout outfile,'<br>For example: association fees and home insurance.'
        call lineout outfile,'<p>'
        call lineout outfile,'<table><tr><th>Note: &nbsp;'
        call lineout outfile,'<td>A pro-rated proportion of these fees are counted as rental expenses.</table>'
   end
   when awhat="UTILITIES" then do
        call lineout outfile,'Enter the average weekly <b>utilities</b> <em>only over the weeks you are renting</em>.'
        call lineout outfile,'<br>These are treated as expenses that are fully deducted from your rental income. '
  end
   when awhat="REALTOR" then do
        call lineout outfile,'Enter the average weekly <b>commission you pay a realtor</b> for managing rentals. This should be a fraction of gross rental income (before expenses).'
        call lineout outfile,'<br>These are treated as expenses that are fully deducted from your rental income. '
  end
   when awhat="APPRECIATION" then do
        call lineout outfile,'The <b>yearly appreciation rate</b> is the average percent increase in the price'
        call lineout outfile,'of the property.<br>  Note to capture a complex scenario,'
        call lineout outfile,'with ups and downs, you have to choose a single <em>average</em> value. '

  end
   when awhat="SHORTFALL" then do
        call lineout outfile,'The <b>shortfall</b> is how much <em>extra</em> you have to pay each month (or year) just to keep up with your mortgage and other expenses.'
        call lineout outfile,'<br>This represents reductions in your current income (unless you have positive profits!).'
        call lineout outfile,'<p>Note that a negative shortfall is a windfall -- this is how much <em>more</em> money you have each month (or year)!</em>'
  end
   when awhat="UNUSABLE" then do
        call lineout outfile,'<b>Unusable weeks</b> are weeks that the house can not be used by anyone --'
        call lineout outfile,'it can not be rented, and you can not live in it.'
        call lineout outfile,'For example, winter weeks in an unheated beach house.'
        call lineout outfile,'<p>Unusuable weeks effects your <em>rental fraction</em>. IRS rules suggest'
        call lineout outfile,'that the <em>rental fraction</em> is the <tt>number_of_days_rented/365</tt>.'
        call lineout outfile,'However, tax courts have been interpreting this as '
        call lineout outfile,'<tt>number_of_days_rented/number_of_days_used</tt>; where <tt>number_of_days_used</tt>'
        call lineout outfile,'is the sum of rental and personal use days.'
        call lineout outfile,'<p>For example: <ul>'
        call lineout outfile,'<li>If you rent for 8 weeks'
        call lineout outfile,'<li>You (including family and friends) use it for 12 weeks'
        call lineout outfile,'</ul>'
        call lineout outfile,'Then the rental fraction would be... <ul>'
        call lineout outfile,'<li>using the IRS rule: 8/52= 15% '
        call lineout outfile,'<li>using the tax court rule: 8/(8+12)= 40%'
        call lineout outfile,'</ul>'
        call lineout outfile,'Given that the tax court ruling stands for the forseeable future, and since you can always claim to be using the house (even in the "dead of winter")'
        call lineout outfile,'the choice of <b>unusable weeks</b> is a function of whether expanding'
        call lineout outfile,'your <em>yearly expenses due to rental</em> offsets losses in <em>pro-rated non-rental deductions</em>'

  end
   when awhat="CASH_VALUE" then do
        call lineout outfile,'The <b>Cash Value</b> is how much money you would have '
       call lineout outfile,'if you had invested your down payment, <b>and</b> all the shortfalls, '
        call lineout outfile,'in a savings account that paid the US Savings Bond interest rate.'
       call lineout outfile,'<p>Basically, this is the opportunity cost of buying a house. You can'
       call lineout outfile,'compare it directly to the <b>net property value</b>.'
       call lineout outfile,'<p>Note that the <b>cash value</b> and the <b>net property value</b>'
       call lineout outfile,'do not account for capital gains tax or income tax on interest. '
  end

   when awhat="NET_PROPERTY" then do
        call lineout outfile,'The <b>net property value</b> is the amount of cash you would have '
        call lineout outfile,' if you sold the house (at its appreciated value), and paid the bank'
        call lineout outfile,'the remaining principal.<p>You can compare this to the <b>cash value</b>'
        call lineout outfile,'(with or without inflation) '
       call lineout outfile,'<p>Note that the appreciated house price is the sum of <b>net property value</b> and the <b>remaining principal</b>'

    end
   when awhat="DOLLARS_NEEDED" then do
        call lineout outfile,'The <B>$ needed to buy house</b> is how much cash you would have to come up with,'
        call lineout outfile,'in addition to your <b>cash value</b>, to purchase the house ... given that '
        call lineout outfile,'house has appreciated.'
        call lineout outfile,'<p>You can compare this to the <B>remaining principal</b>'
  end

/* not implmented 
   when awhat="EXTRA_SAVINGS" then do
        call lineout outfile,'The <B>extra savings</b> is an additional amount you save, per year.'
        call lineout outfile,'This is over and above your shortfall (and downpayment).'
        call lineout outfile,'<p>You can use this to help compare houses with different shortfalls --'
        call lineout outfile,'the more expensive house may lead to higher property values, but '
        call lineout outfile,'this may simply be due to higher shortfall payments. By setting the '
        call lineout outfile,'<b>extra payments</b> to be the same as the differences in shortfalls,'
        call lineout outfile,' you get a more honest comparision.'
  end
*/

   when awhat="SUMMARY" then do
        call lineout outfile,'The <b>scenario description</b> is used to help identify this scenario.<br>'
        call lineout outfile,'This is especially useful if  save <b>a summary of your scenario</b>. '
        call lineout outfile,'After running &amp; saving several scenarios, you can then'
        call lineout outfile,'view these summaries in an easy-to-read table.'
        call lineout outfile,'<p>Hints:<ul>'
        call lineout outfile,'<li>To save summary info, check the  <tt>save recomputed scenario</tt> checkbox '
        call lineout outfile,'<li>To view &amp; modify the summary info: click on the <U>Summaries of saved scenarios</u> link (at the top of the page)'
        call lineout outfile,'<li>Hint: if you create a set of two scenarios, and '
        call lineout outfile,'then view the summaries ... a few simple comparisons (between'
        call lineout outfile,'these two scenarios) will be computed.'

        call lineout outfile,''
        call lineout outfile,''
        call lineout outfile,'</ul>'

  end

   when awhat="REPORTABLE_YEARLY" then do
        call lineout outfile,'<b>Reportable yearly expenses</b> are:<ul>'
        call lineout outfile,'<li> expenses that occur regardless of'
        call lineout outfile,'whether you rent or not'
        call lineout outfile,'<li> expenses that you can declare a pro-rated proportion of as <em>rental expenses</em>f'
        call lineout outfile,'</ul>'
        call lineout outfile,'Note that the higher your rental fraction (the more weeks you rent), the'
        call lineout outfile,'greater the pro-rated proportion will be.'
        call lineout outfile,''

  end


  when awhat="REPORTED_RENTAL_INCOME" then do
        call lineout outfile,'The <b>reported rental income</b> is your net profit from renting the house.'
        call lineout outfile,'This is what you <em>report</em> to the IRS.'
        call lineout outfile,'<p>'
        call lineout outfile,'The <b>reported rental income</b> is equal to the maximum of <B>0</b> and:'
        call lineout outfile,'<ul>'
        call lineout outfile,'<li>Your cash rent, <em>minus</em>'
        call lineout outfile,'<li>your rental expenses, <em>minus</em>'
        call lineout outfile,'<li>the fraction of yearly expenses (including depreciation) due to the rental of the house'
        call lineout outfile,'</ul>'
        call lineout outfile,'Thus, you can <b>not</b> report a loss!'
        call lineout outfile,''
        call lineout outfile,'<p>'
        call lineout outfile,'<table>'
        call lineout outfile,'<h3>A note on reporting losses</h3>'
        call lineout outfile,'<b>Home2Buy</b> assumes that you will be using this 2nd house as both a rental and as'
        call lineout outfile,'a <em>vacation</em> house.  Under these circumstances, you are <b>not</b> able to apply a '
        call lineout outfile,'loss in the rental market to offset income from other activities (such as from your'
        call lineout outfile,'everyday job).'
        call lineout outfile,'<P><em>However,</em> there is a special case where you <b>can</b> apply up to $25,000 worth'
        call lineout outfile,'of loss. In such a case, the loss will reduce your income taxes!'
        call lineout outfile,'<p>You can do this by treating your rental property as a business. This means several things:'
        call lineout outfile,'<ol>'
        call lineout outfile,'<li><em>Personal use </em> of the property can <b>not</b> exceed the maximum of 14 days, or 10% of the days'
        call lineout outfile,'you rent it at <em>full market value</em>'
        call lineout outfile,'<li>Your adjusted gross income (AGI) is less then $150,000 (of $80,000 if filing singly).'
        call lineout outfile,'</ol>'
        call lineout outfile,'If these conditions hold, then you can apply a rental loss to offset other income.'
        call lineout outfile,'<p>'
        call lineout outfile,'<table><th>Notes:</th>'
        call lineout outfile,'<td><ul><li>'
        call lineout outfile,'<em>Personal use</em> means any time you, or your family (and family includes parents, children,'
        call lineout outfile,'siblings, etc.) use the house; or anytime you rent it (say, to a friend or neighbor) at less'
        call lineout outfile,'than fair market value.'
        call lineout outfile,'<li>You get the full $25,000 if you (filing jointly) make less then $100,000 AGI.  Between'
        call lineout outfile,'$100,000 and $150,000 of AGI, you can apply a prorated fraction of the up-to-$25,000 loss.'
        call lineout outfile,'<li>The main advantage to treating the 2nd home as a business is to fully capture all'
        call lineout outfile,'yearly expenses, especially depreciation.'
        call lineout outfile,'<blockquote> You can also include mortgage interest'
        call lineout outfile,'and property taxes in computing your losses; however, you can also include mortgage'
        call lineout outfile,'interest and property taxes as deductions (when you do not treat the 2nd home as a business).'
        call lineout outfile,'Hence, the ability to expense a full year''s depreciation is typically the best reason for treating the 2nd home'
        call lineout outfile,'as a business!'
        call lineout outfile,'</blockquote>'
        call lineout outfile,'</ul>'
        call lineout outfile,'</table>'
   end

   otherwise do
        call lineout outfile,'<tt>No help available for 'awhat
   end
end  
call lineout outfile,'<p><a href="/" onClick="window.close(); return false ">Close</a>'
call lineout outfile,'</body></html>'
call lineout outfile
return 1



append_file:
parse arg filename,astring,ntries,addcrlf,overwrite

if ntries='' | ntries=0 then ntries=1
isnew=0

fulln=stream(filename,'c','query exists')

if overwrite=1 then do
  if fulln<>'' then do
    foo=sysfiledelete(fulln)
    if foo<>0 then return -3
    fulln=''
 end
end

if fulln<>'' then do    /* does exist (and not overwrite), get size */



 do ll=1 to ntries               /* sometimes file exists but hasn't been written */
   asize=stream(fulln,'c','query size')
   if asize=''  then do
     if ll=ntries then  return '-1 '||filename' problem reading size '
     call syssleep(1)
     iterate
   end
   leave
 end
end
else do
   fulln=filename               /* create file */
   isnew=1
end

/* now open it */
do jj=1 to ntries
   astat=stream(fulln,'c','open')
   if abbrev(strip(translate(astat)),'READY')=0 then do
     if jj=ntries  then  return '-1 '||fulln' could not be opened'
     call syssleep(1)
     iterate
   end
   leave
end
  
/* if no such file, create it now */
if isnew=1 | asize=0  then do
   if addcrlf=1 then astring=astring||'0d0a'x
   foo=charout(fulln,astring,1)
   foo2=stream(fulln,'c','close')
   if foo<>0 then return '-2 unable to write 'foo' bytes '
   asize=length(astring)
   return asize
end

/* now get last 3 characters  */
iat=asize-2
toget=3
if iat<3 then do 
   toget=1   /* just look for 1a */
   iat=asize
end
aa=charin(fulln,iat,toget)

iwrite=asize+1          /* where to write astring */

checkcrlf=addcrlf
if toget=1 then do      /* just check 1a */
  if aa='1a'x then iwrite=asize
  checkcrlf=0
end 
else do         /* check last char for 1a */
  if right(aa,1)='1a'x then do
     iwrite=asize
     aa=left(aa,2)
  end 
  else do
    aa=right(aa,2)      /* no 1a, so check last two chars for crlf */
  end 
end 

if checkcrlf=1 then do
  if toget=3 then do      /* look for termainating crlf */
    if aa<>'0d0a'x then astring='0d0a'x||astring
  end
end
if addcrlf=1 then astring=astring||'0d0a'x

/* ready to write */

foo=charout(fulln,astring,iwrite)
foo2=stream(fulln,'c','close')
if foo<>0 then return '-2 problem writing 'foo' bytes '
asize=length(astring)+iwrite-1
return asize


/******************/
/* send message */
send_message:procedure expose is_sre2002 id_info
parse arg amess,titlex

if is_sre2002=-1 then do
   say amess
   return 1
end /* do */

if titlex='' then titlex='message'

aa='<html><head><title>Vacation home scenarios: '||titlex||' </title><head>'
aa=aa||'0d0a'x||'<body><hr>'||amess||'<hr>'
aa=aa||'0d0a'x||'<a href="javascript:history.go(-1)">Back.. </a>'
aa=aa||'0d0a'x||'&nbsp;&nbsp;<a href="/" onClick="window.close(); return false ">Close</a>'

aa=aa||'0d0a'x||'</body></html>'
IF IS_SRE2002=0 then DO
    goo=sref_gos('VAR  type  text/html ',aa)
END
ELSE DO
   GOO=SRE_COMMAND('VAR type text/html ',aa,ID_INFO)
end
return goo

/******************/
/* send file */
send_File:procedure expose is_sre2002 id_info
parse arg ff,mtype,doerase
if mtype='' then mtype='text/html'
aerase=''
if doerase=1 then aerase='ERASE'

if is_sre2002=-1 then do
    say "Using netscape to display results ...."
   '@START  "Home2Buy Results" /C /F /WIN NETSCAPE file:///'ff
   return 1
end

IF IS_SRE2002=0 then DO
    goo=sref_gos('FILE '||aerase||'  type  '||mtype||' nocache name 'ff)
END
ELSE DO
   GOO=SRE_COMMAND('FILE '||aerase||' type '||mtype||' nocache name 'ff,,ID_INFO)
end
return goo

/*****************/
/* view summary, formatted as html */
view_summary:

ii=stream(ff,'c','query size')
if ii=0 | ii='' then do
  goo=send_Message('Could not find summary file')
  return 1
end
ain=charin(ff,1,ii)
foo=stream(ff,'c','close')

crlf='0d0a'x
vals.=''
tableon=0
svals.=''
hdrwrote=0
subct=1

call lineout tempfile,'<html><head><title>Vacation home scenarios: summaries </title><head>'
call lineout tempfile,'<body>'
call lineout tempfile,'<font size=-1><a href="#actions">Modify scenarios</a>'
call lineout tempfile,' || <a href="/" onClick="window.close(); return false ">Close</a>'
call lineout tempfile,'</font><br>'

do forever

   if ain='' then leave
   parse var ain a1 '0d0a'x ain
   if a1='' then iterate
   parse var a1 avar ':' aval
   avar=strip(Translate(avar))
   aval=strip(aval)
   mval=aval
   select
      when avar='TITLE' then do
         call lineout tempfile,'<h3>'||aval||"</h3>"
      end 
      when avar='SUBTITLE' then do
         if tableon=1 then  call lineout tempfile,'</table>'  /* close off current table */
         if subct=3 then call comp_scenarios
         call lineout tempfile,'<hr><b>'||mval||"</b><br>"
         hdrwrote=0
         tableon=0
         
         subct=1
         svals.=''
      end 
      when avar='END' then do           /* display the table */
         if hdrwrote=0 then do 
            call write_thdr
            hdrwrote=1  ; tableon=1
         end
         call lineout tempfile,'<tr><td colspan=3>&nbsp;'
         call lineout tempfile,'<tr ><th bgcolor="cyan" rowspan=4><a target="scenarios" href="/home2buy?'||vals.!LINK||'">'||vals.!DESCRIPTION||"</a></th>"
         call lineout tempfile,'<tr bgcolor="tan"><td>'||addcomma(vals.!Price)|| '</td><td>'||addcomma(vals.!down)'</td>'
         call lineout tempfile,'<tr bgcolor="lightgreen"><td>'||addcomma(vals.!rent)||'</td><td>'||addcomma(vals.!shortfall)||'</td>'
         call lineout tempfile,'<tr bgcolor="cyan"><td>'||addcomma(vals.!net_property)||'<br>'||addcomma(vals.!net_Cash)||'</td>'
         call lineout tempfile,'    <td>'||addcomma(vals.!remaining_principal)||' <br>'||addcomma(vals.!cash_needed)||'</td>'
         vals.=''
         subct=subct+1
      end 
      otherwise do
          cvv='!'||avar
          vals.cvv=aval
          svals.cvv.subct=aval
     end
  end
end
if tableon=1 then  call lineout tempfile,'</table>'

if subct=3 then call comp_scenarios

call lineout tempfile,'<hr><a name="actions"><b>Modify the scenarios database</b></a>'
call lineout tempfile,'<form name="hooey" action="/home2buy" method="Get">'
call lineout tempfile,'<ul>'
call lineout tempfile,'<li><input type="radio" name="SUMMARIES_ACTION" value="RAW">View raw data'

call lineout tempfile,'<li><input type="radio" name="SUMMARIES_ACTION" value="RESET">Reset (remove all scenario summaries)'
call lineout tempfile,'<table><tr><td>'
call lineout tempfile,'New title to use for this <br><em>summaries of scenarios</em> dataset:</td>'
call lineout tempfile,'<td><input type="text" name="SUMMARIES_TEXT1" size=50></td></table>'


call lineout tempfile,'<li><input type="radio" name="SUMMARIES_ACTION" value="TITLE">Create a new section'
call lineout tempfile,'<table><tr><td>'
call lineout tempfile,'Title to use for this <br><em>section</em>:</td>'
call lineout tempfile,'<td><input type="text" name="SUMMARIES_TEXT2" size=50></td></table>'
call lineout tempfile,'</ul>'
call lineout tempfile,'<input type="Submit" value="Modify/reset scenarios">'
call lineout tempfile,'</form>'

call lineout tempfile,'</body></html>'
call lineout tempfile
goo=send_File(tempfile,'text/html',1)
return 1

comp_scenarios:
  short_diff=svals.!shortfall.2-svals.!shortfall.1
  netp_diff=svals.!net_property.2-svals.!net_property.1
  netc_diff=svals.!net_cash.2-svals.!net_cash.1

  remp_diff=svals.!remaining_principal.2-svals.!remaining_principal.1
  netcneed_diff=svals.!cash_needed.2-svals.!cash_needed.1

  call lineout tempfile,'<B>Comparisions</b>: differences between <tt> '||svals.!description.2 '</tt> &amp;<tt> '||svals.!description.1||'</tt> <ul>'
  call lineout tempfile,'<li>Shortfall: <Tt>'||short_diff||'</tt>'
  call lineout tempfile,'<li>Net Property: <Tt>'||addcomma(netp_diff) ||'</tt>'
  call lineout tempfile,'<li>Saved Cash: <Tt>'||addcomma(netc_diff) ||'</tt>'

  call lineout tempfile,'<li>Remaining principal: <Tt>'||addcomma(remp_diff) ||'</tt>'
  call lineout tempfile,'<li>Cash needed to buy house: <Tt>'||addcomma(netcneed_diff) ||'</tt>'

  call lineout tempfile,'</ul>'

return 1

/******/
write_thdr:
         call lineout tempfile,'<table border=1><tr ><th  bgcolor="cyan"rowspan=4>Description</th>'
         call lineout tempfile,'<tr bgcolor="tan"><td>Price</td><td>Down Payment</td>'
         call lineout tempfile,'<tr bgcolor="lightgreen"><td>Net-rent</td><td>Shortfall</td>'
         call lineout tempfile,'<tr bgcolor="cyan"><td>Appreciated net-property<br>Invested cash</td>'
         call lineout tempfile,'    <td>Remaining principal <br>Cash needed</td>'
return 1



/*****/
/* power procedure */
do_pow:procedure
parse arg aval,apower
aa=1
do mm=1 to apower
   aa=aa*aval
end 
return aa




/****/
do_packur:procedure

/* decode a string that's been url encoded  (i.e.; %7e becomes ~)
This is the equivalent to goserve's PACKUR function*/
do_packur:
parse arg astring
IF ASTRING=' ' THEN RETURN ASTRING
ipp=pos('%',astring)
if ipp=0 then return astring
if ipp>1 then
  bstring=left(astring,ipp-1)
else
  bstring=''
astring=substr(astring,ipp+1)
do until astring=''
  parse var astring  acode +2  astring
  if verify(acode,'0123456789abcdefABCDEF')>0 then do
     bstring=bstring||'%'||acode
  end
  else do
     bstring=bstring||x2c(acode)
  end
  parse var astring a1 '%' astring
  bstring=bstring||a1
end /* do */
return bstring



/****/
/* read an input file */
file_list:

aesc='1B'x
cy_ye=aesc||'[37;46;m'
normal=aesc||'[0;m'
bold=aesc||'[1;m'
re_wh=aesc||'[31;47;m'
reverse=aesc||'[7;m'

say "      "|| cy_ye||"Home2Buy: compute financial aspects of purchasing a 2nd (vacation) home "||normal
getin:
if infile="" then do
    call lineout,bold " Enter name of parameter file "
    say "    (Enter=HOME2BUY.IN, ? for help, ?DIR for a directory, EXIT to quit) "normal
    call charout,"  "reverse " :" normal
    parse pull infile ; infile=strip(infile)
end
if infile='' then infile='home2buy.in'
if strip(translate(infile))='EXIT' then do
   if addonmode<>1 then say "bye "
   exit
end /* do */


if abbrev(translate(infile),'?DIR')=1 then do
    parse var infile . thisdir
    if thisdir="" then do
      if opsys='OS/2'then
        thisdir=strip(directory(),'t','\')||'\*.*'
      if opsys<>'LINUX' then  thisdir='.\*.*'
      if opsys='LINUX' then thisdir='*.*'
    end
    say
    say reverse ' List of files in: ' normal bold thisdir normal
    do while queued()>0
            pull .
    end /* do */
    toget=thisdir

    select
       when  opsys='OS/2' then '@DIR /b  '||toget||' | rxqueue'
       when  opsys='LINUX' then 'ls '||toget||' | rxqueue '
       otherwise 'DIR /b  '||toget||' | rxqueue'
    end
    foo=show_dir_queue('*')
    say
    infile=''
    signal getin
end



if infile=' ' | strip(infile)='?' then do
   call sayhelp
   infile=''
   signal getin
end /* do */

if abbrev(translate(strip(infile)),'/DIR')=1 then do
    infile=substr(strip(infile),2)
    address cmd infile
    infile=''
    signal getin
end /* do */

/***** not supported 
if abbrev(translate(strip(infile)),'/VAR')=1 then do
  call change_params infile
  infile=''
  signal getin
end
*****/

/* maybe it's actually a file name */

infile=strip(infile)
infile0=infile
if pos('.',infile)=0 then infile=infile||'.in'
param_file=stream(infile,'c','query exists')              
if param_file='' & pos('.',infile0)=0 then param_file=stream(infile0,'c','query exists')
if param_file='' then param_file=stream(infile0||'.html','c','query exists')


if param_file='' then do
    Say "Sorry. could not find: " infile
    exit
end /* do */

htmllen=stream(param_file,'c','query size')
if htmllen=0 then do
   say " Sorry -- " param_file " is empty "
   infile=''
   signal getin
end /* do */
stuff=charin(param_file,1,htmllen)
foo=stream(param_file,'c','close')
Say "Reading " HTMLlen " characters from " param_file

/* now parse it */
nn=0
do until stuff=''
   parse var stuff aline '0d0a'x stuff
   aline=strip(aline)
   if abbrev(aline,';')=1 | aline='' then iterate
   parse var aline avar '=' avalue
   avar=strip(translate(avar))
   avalue=strip(avalue)
   foo=value(avar,avalue)
   nn=nn+1
end 
say nn " parameters were set."
return 1



/*********/
/* show stuff in queue as a list */
show_dir_queue:procedure expose qlist.
parse arg lookfor
    ibs=0 ;mxlen=0
    if lookfor<>1 then
       nq=queued()
     else
        nq=qlist.0
    do ii=1 to nq
       if lookfor=1 then do
          aa=qlist.ii
          ii2=lastpos('\',aa) ; anam=substr(aa,ii2+1)
       end /* do */
       else do
          parse pull aa
          if pos(lookfor,aa)=0 & lookfor<>'*' then iterate
          parse var aa anam (lookfor) .
          if strip(anam)='.' | strip(anam)='..' then iterate
       end
       ibs=ibs+1
       blist.ibs=anam
       mxlen=max(length(anam),mxlen)
    end /* do */
arf=""
do il=1 to ibs
   anam=blist.il
   arf=arf||left(anam,mxlen+2)
   if length(arf)+mxlen+2>75  then do
        say arf
        arf=""
   end /* do */
end /* do */
if length(arf)>1 then say arf
say
return 1


/***/
sayhelp:
say
say cy_ye||'Home2Buy'||normal||' will compute a variety of financial facts concerning '
say 'purchasing a 2nd (vacation) home. '
say ' '

say' Home2Buy has a variety of features, including:'
say ' * accounts for mortgage interest and proprety tax income tax deductions,'
say ' * incorporates rental income and expenses, including depreciation'
say ' * returns from saving your money, rather then buying a property,'
say ' * appreciated value of the property'
say ' '
say 'Thus, in addition to the price of the property, there are a number of'
say 'other parameters that you can adjust -- such as the interest rate,'
say 'the per-week rent, the apprectiation rate, and your marginal tax rate.'
say ' '
say 'These parameters are read from a special Home2Buy parameter file... which'
say 'you need to provide.'
say
say bold'Note:'normal' By default, Home2Buy uses NetScape to display results '
say 
call charout,'Enter to continue, or ? to display (using Netscape) some hints and tips:'
pull goo
if goo='?' then do
    say "Using netscape to display results ...."
   '@START  "Home2Buy Results" /C /F /WIN NETSCAPE file:///'||tempdir||'/Home2BuY.HTM'
end

return 1

/****************************************************************************/
/* Compute payment schedule for a mortgage.
   Return results monthly mortgage payment
   Also sets exposed PAYMENTS.
             PAYMENTS.n.!x, x= interest or principal 
             payments.0 = # months
             payments.0.!interest : total interest paid
             payments.0.!principal : total principal paid (should = amt)

 Arguments:             
    amt: amount of mortgage
    aintr:  interest rate (yearly, but not apr)
    mmonths: length of loan 
*/

fig_mortgage:procedure expose payments.
parse arg amt,aintr,mmonths
mintr=aintr/12

M_P=0.5*AMT/MMONTHS     /* guess at starting monthly principal */

goo=fig_pays(amt,mintr,mmonths,M_P)

step=M_P/100
do forever
  if cum_prin>amt then do
      m_P=m_P-step
      wasmore=1
  end
  else do
      m_P=m_P+step
      wasmore=0
  end
  MPAY =fig_pays(amt,mintr,mmonths,M_P)
  if abs(AMT-CUM_PRIN)/AMT < 0.0000005 then leave

  if CUM_PRIN>AMT then do
      if wasmore=1 then iterate /* same step size */
      step=step/2       /* switched, cut step size in half */
  end
  else do
      if wasmore=0 then iterate /* same step size */
      step=step/2       /* switched, cut step size in half */
  end 
end /* do */
payments.0.!interest=cum_int
payments.0.!principal=cum_prin
payments.0=mmonths
return mpay


/**********/
/* compute mortgage schedule, given 1st month principal */
fig_pays:procedure expose cum_prin cum_int payments.
parse arg newamt,mintr,jmon,m_p
cum_prin=0
cum_int=0
m_i=newamt*mintr
mpay=m_i+m_p
do mm=1 to jmon
    cum_prin=cum_prin+m_p
    cum_int=cum_int+m_i
    newamt=newamt-m_p

    m_i=newamt*mintr    
    m_p=mpay-m_i
    payments.mm.!interest=m_i
    payments.mm.!principal=m_p
end
return MPAY


exit

/******/
/* compute monthly interest rate given yearly rate
   We don't use this, since most calculators assume rate is "monthly" */
fig_mint:procedure
parse arg interest
interest=interest+1
mint=1+((interest-1)/12)
ji=do_pow(mint,12)
step=0.001/12
do forever
  if ji>interest then do
      mint=mint-step
      wasmore=1
  end
  else do
      mint=mint+step
      wasmore=0
  end
  ji=do_pow(mint,12)
  if abs(ji-interest)/interest < 0.000001 then leave

  if ji>interest then do
      if wasmore=1 then iterate /* same step size */
      step=step/2       /* switched, cut step size in half */
  end
  else do
      if wasmore=0 then iterate /* same step size */
      step=step/2       /* switched, cut step size in half */
  end 
end /* do */
return mint-1


