/* $Id: common.h,v 3.0 1992/02/23 21:25:39 davison $
 */
/* The authors make no claims as to the fitness or correctness of this software
 * for any use whatsoever, and it is provided as is. Any use of this software
 * is at the user's own risk. 
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "config.h"	/* generated by installation script */

/*** OS2: to extract the global settings out of the
          rc-files of uupc, we need the header file
          os2patch.h.                      ***/
#include "os2patch.h"

#include <errno.h>
#include <signal.h>
#ifdef I_VFORK
#  include <vfork.h>
#endif

#ifdef I_UNISTD
#include <unistd.h>
#endif
#ifdef I_STDLIB
#include <stdlib.h>
#else
char	*malloc();
char	*realloc();
char	*getenv();
#endif

#ifdef I_STRING
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef I_TIME
#include <time.h>
#endif
#ifdef I_SYS_TIME
#include <sys/time.h>
#endif

#define BITSPERBYTE 8
#define LBUFLEN 1024	/* line buffer length */
#define MAXFILENAME 512

/* some handy defs */

/*** OS2: in os2patch, we also need a bool, but we don't
          want to include common.h   ***/
#ifndef BOOL_DEFINED
#define BOOL_DEFINED
#define bool char
#define bool_int int
#endif

#define char_int int
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#define Null(t) ((t)0)
#define Nullch Null(char *)
#define Nullfp Null(FILE *)

#define Ctl(ch) (ch & 037)

#define strNE(s1,s2) (strcmp(s1,s2))
#define strEQ(s1,s2) (!strcmp(s1,s2))
#define strnNE(s1,s2,l) (strncmp(s1,s2,l))
#define strnEQ(s1,s2,l) (!strncmp(s1,s2,l))

/* Things we can figure out ourselves */

#ifdef EUNICE
#   define LINKART		/* add 1 level of possible indirection */
#   define UNLINK(victim) while (!unlink(victim))
#else
#   define UNLINK(victim) unlink(victim)
#endif

/* *** System Dependent Stuff *** */

#define MAKEDIR		/* use our makedir() instead of shell script */

/* NOTE: many of these are defined in the config.h file */

#ifdef NORMSIG
#   define sigset signal
#endif

/* news library */
#ifndef NEWSLIB		/* ~ and %l only ("~%l" is permissable) */
#ifdef COMPILING_TRN
#   define NEWSLIB uupc_rc_settings.trnlib
#endif
#ifdef COMPILING_MTHREADS
#   define NEWSLIB uupc_rc_settings.mthreadslib
#endif
#endif

/* path to private executables */
#ifndef PRIVLIB		/* ~, %x and %l only */
#ifdef COMPILING_TRN
#   define PRIVLIB uupc_rc_settings.trnlib
#endif
#ifdef COMPILING_MTHREADS
#   define PRIVLIB uupc_rc_settings.mthreadslib
#endif
#endif

/* where to find news files */
#ifndef NEWSSPOOL			/* % and ~ */
#   define NEWSSPOOL uupc_rc_settings.news_dir
#endif

#ifndef NEW_THREAD
#   define NEW_THREAD ".new"
#endif

/* file containing list of active newsgroups and max article numbers */
#ifndef ACTIVE			/* % and ~ */
#   define ACTIVE uupc_rc_settings.active
#endif
#ifdef USE_NNTP
#   ifndef ACTIVE1
#	define ACTIVE1 "%X/active1"
#   endif
#endif
#ifndef ACTIVE2
#   define ACTIVE2 "%X/active2"
/*OS2: see mthreads.c for a patch that is needed under OS/2. We need
       an additional filename for a temporary active2 file. */
#   define ACTIVE2OLD "%X/active2.old"
#endif
#ifndef DBINIT
#   define DBINIT "%W/db.init"
#endif
#ifndef MTPRELOCK
#   define MTPRELOCK "%X/LOCK"
#endif
#ifndef MTLOCK
#   define MTLOCK "%X/LOCKmthreads"
#endif
#ifndef MTDLOCK
#   define MTDLOCK "%X/LOCKmtdaemon"
#endif
#ifndef MTLOG
#   define MTLOG "%P/mt.log"
#endif

/* path to fastest starting shell */
#ifndef SH
#   define SH uupc_rc_settings.prefshell
#endif

#ifndef MAKEDIR
/* shell script to make n-deep subdirectories */
#   ifndef DIRMAKER		/* % and ~ */
#	define DIRMAKER "%X/makedir"
#   endif
#endif

/* how to open binary format files */
#ifndef FOPEN_RB
#   define FOPEN_RB "r"
#endif
#ifndef FOPEN_WB
#   define FOPEN_WB "w"
#endif

/* what to do with ansi prototypes -- '()' == ignore, 'x' == use */
#ifndef _
#   ifdef __STDC__
#	define _(x) x
#   else
#	define _(x) ()
#   endif
#endif

/* some important types */

typedef long		ART_NUM;	/* article number */
typedef unsigned int	MEM_SIZE;	/* for passing to malloc */

/* some slight-of-hand for compatibility issues */

#ifdef HAS_STRCHR
# ifndef index
#   define index strchr
# endif
# ifndef rindex
#   define rindex strrchr
# endif
#endif
#ifdef HAS_MEMCMP
# ifndef bcmp
#   define bcmp(s,d,l) memcmp((s),(d),(l))
# endif
#endif
#ifdef HAS_MEMCPY
# ifndef bcopy
#   define bcopy(s,d,l) memcpy((d),(s),(l))
# endif
#endif
#ifdef HAS_MEMSET
# ifndef bzero
#   define bzero(s,l) memset((s),0,(l))
# endif
#endif

#ifndef HAS_VFORK
#   define vfork fork
#endif

/* *** end of the machine dependent stuff *** */

/* GLOBAL THINGS */

/* file statistics area */

EXT struct stat filestat;

/* various things of type char */

#ifdef SUPPLEMENT_STRING_H
char	*index();
char	*rindex();
char	*strcat();
char	*strcpy();
#endif

EXT char buf[LBUFLEN+1];	/* general purpose line buffer */

/* miscellania */

#ifndef __STDC__
int fseek();
long atol(), ftell();
extern int errno;
#endif

EXT char nullstr[1] INIT("");

/* if subscripting is faster than shifting on your machine, define this */
#undef USESUBSCRIPT
#ifdef USESUBSCRIPT
EXT char powerof2[] INIT({1,2,4,8,16,32,64,128});
#define pow2(x) powerof2[x]
#else
#define pow2(x) (1 << (x))
#endif
#define OFFSET(a) ((a)-absfirst)

#define ctl_set(a) (ctlarea[(OFFSET(a)) / BITSPERBYTE] |= pow2((OFFSET(a)) % BITSPERBYTE))
#define ctl_check(a) ((ctlarea[(OFFSET(a)) / BITSPERBYTE] & pow2((OFFSET(a)) % BITSPERBYTE)) != 0)

#define advise(str)
#define report_error(str) log_entry(str)
