/* Example of the REXX interface to ExCal using PMDPROFS              */
/*                                                                    */
/* This simple REXX command file invokes the "export" function        */
/* of ExCal, runs PMDPROFS, then imports the result.                  */
/*                                                                    */
/* Note: The SysSetObjectData only accepts object IDs for folder      */
/*       objects; paths are not accepted.  As a result, the           */
/*       Calendar must be created with an object ID.  I believe       */
/*       this is a REXX bug, since WinSetObjectData/WinQueryObject    */
/*       together work with either folder or data file objects.       */
/*       The initial ExCal was created with object ID                 */
/*       "<EXCAL_CALENDAR>".                                          */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* NOTE! Update the path below for your PMDIARY.$D$ file              */
/*       for example, "EXPORTTOPMDIARY=C:\OS2\APPS\PMDIARY.$D$"       */
/*       and "IMPORTFROMPMDIARY=C:\OS2\APPS\PMDIARY.$D$"              */

rc = SysSetObjectData("<EXCAL_CALENDAR>", "EXPORTTOPMDIARY=PMDIARY.$D$")
'pmdprofs'
rc = SysSetObjectData("<EXCAL_CALENDAR>", "IMPORTFROMPMDIARY=PMDIARY.$D$")
