/* REXX PROGRAM */
/* This file is for importing ACT! data into OmniFile or CCv2 */
/* This REXX program expects OMNIFILE or CCv2 to be the host environment */
/* If you are attempting to change this file, you will normally only need to change the commands in the CHANGE_REC subroutine and the user variables. */

/*********** USER VARIABLES **************/
/* If useMgrOwner is set to 1 the owner and manager fields of the ACT! records will be stored as a note */
/* By default, we set this variable to 0 to indicate that these fields will not be converted */
/* If separateBusinesses is set to 1, then ACT records with a business name but no contact name will be */
/* added to the Business database, as opposed to the Individual database */
useMgrOwner = 0
separateBusinesses=1
/******************************************/

/*  Define field numbers */
fileType=GetTypeGivenName("File")
fileTypeType=GetTypeGivenName("File Type")
actionType=GetTypeGivenName("Action")
actionTypeType=GetTypeGivenName("Action Type")
codeTypeType=GetTypeGivenName("Code Type")

/* these are field numbers for individuals */
prefixFieldNum = 2
middleFieldNum= 4
suffixFieldNum = 6
IaddressFieldNum = 12
IphoneFieldNum = 13
IcodeFieldNum = 14
InotesFieldNum = 15

/* these are field numbers for businesses */
BaddressFieldNum = 4
BphoneFieldNum = 5
BcodeFieldNum = 6
BnotesFieldNum = 7

addressTypeFieldNum = 1
addressAddressFieldNum = 3
addressCityFieldNum = 4
addressStateFieldNum = 5
addressZipFieldNum = 6
addressNoteFieldNum = 8
phoneTypeFieldNum = 1
phonePhoneFieldNum = 2
phoneNoteFieldNum = 3
fileTypeFieldNum = 1
fileNameFieldNum = 2
codeTypeField = 1
actionTypeField = 1
actionCompletedField = 2
actionDateField = 3
actionTimeField = 4
actionFreqField = 5
actionSummaryField = 7


/* MAIN SUBROUTINE */
szEnvironment = address()
IF ((szEnvironment <> "Omnifile") & (szEnvironment <> "Contacts")) THEN DO
	SAY "This rexx file can only be run by Omnifile or Contact Connection, not directly."
	RETURN 1
	END

/* Load the Rexx variables based on the arguments the user passed in. */
/* FileIn1 has the simple dumped data; FileIn2 has the multiline data like notes */
FileIn1 = ARG(1)
FileIn2 = ARG(2)

/* Make sure the required arguments were given. */
IF FileIn1 = "" THEN DO
	SAY "The following arguments are expected: FILEIN1 FILEIN2"
	SAY "    FILEIN1 is required."
	RETURN 1
	END
IF FileIn2="" THEN DO
	SAY "The notes and activities file was not provided"
	END

/* Set the default delimiter to ',' */
Delimiter = ','
SetDefaultDelimiter(Delimiter)

/* Set the Header Line and pass it to OmniFile in order to initialize the import. */
/* Literals in REXX have a limit of 250 chars; but can concatenate to make a bigger one */
headerLine1 = 'Business Name, FullName, Address1, Address2, Address3, City, State, Zip, BusPhone, Fax, BusPhoneExt, FaxExt, Job Title, Asst, Informal Name, Result, Codeval, Refby,'

headerLine2='u1,u2,u3,u4,u5,u6,u7,u8,u9,u10,u11,u12,u13,u14,u15, HomePhone, HomeExt, HomeAdd1, HomeAdd2, HomeCity, HomeState, HomeZip, Alt1Name, Alt1Title, Alt1Phone, Alt1Ext,'

headerLine3='Alt2Name, Alt2Title, Alt2Phone, Alt2Ext, Letter, Owner, Mgr, CountryPhoneCode, CellPhone, Library, First Name, Last Name, Email, EmailServer'

headerLine=headerLine1||headerLine2||headerLine3

/* For each line in the input file, load the line, load the Rexx variables, modify the Rexx variables, and add the record. */
/* Simultaneously look in the second file to see if there are any notes or activities for this contact */
contactName=''
companyName=''
foundNew=0
IF FileIn2 \='' THEN DO
	DO while LINES(FileIn2)
		line2=LINEIN(FileIn2)
		CALL CHECK_IF_NEW_CONTACT
		IF foundNew=1 THEN LEAVE
		END
	IF (foundNew=0) THEN SAY "No data was found in second file"
	END
DO while LINES(FileIn1)
	line = LINEIN(FileIn1)
	RecType = GetTypeGivenName("Individual")
	SetDefaultType(RecType)
	SetHeaderLine(headerLine)
	SetRexxVariables(line)
	IF separateBusinesses=1 & FullName= "" & BusinessName \= "" THEN DO
		RecType = GetTypeGivenName("Business")
		SetDefaultType(RecType)
		SetHeaderLine(headerLine)
		SetRexxVariables(line)
		inBusiness = 1
		addressFieldNum = BaddressFieldNum
		phoneFieldNum = BphoneFieldNum
		codeFieldNum = BcodeFieldNum
		notesFieldNum = BnotesFieldNum
		END
	ELSE DO
		inBusiness = 0
		addressFieldNum = IaddressFieldNum
		phoneFieldNum = IphoneFieldNum
		codeFieldNum = IcodeFieldNum
		notesFieldNum = InotesFieldNum
		END
	Rec = GetRec(0, RecType)
	SetRecFromRexxVariables()
	CALL CHANGE_REC
	IF (foundNew=1 & contactName=FullName & companyName=BusinessName) THEN CALL GET_REST_OF_INFO
	AddRec()
	END
/* Close all the files. */
result=stream(FileIn1, 'c', 'close')
IF FileIn2 \='' THEN result=stream(FileIn2, 'c', 'close')
RETURN 0


/* SUBROUTINE */
CHECK_IF_NEW_CONTACT:
/* check to see if at the start of new contact info in the Notes and Activities input file */
foundNew=0
PARSE VAR line2 a "CONTACT:=" .
IF line2 \= a THEN DO
	/* get what comes after the = */
	PARSE VAR line2 . '=' contactName
	IF LINES(FileIn2) THEN line2=LINEIN(FileIn2)
	ELSE RETURN
	PARSE VAR line2 a "COMPANY:=" .
	IF line2 \= a THEN PARSE VAR line2 . '=' companyName
	ELSE RETURN
	foundNew=1
	END
RETURN


/* SUBROUTINE */
GET_REST_OF_INFO:
IF notes \="" THEN notes=notes||'A'x
/* find NOTES:=; everything between NOTES:= and HISTORY:= is a note*/
DO while LINES(FileIn2)
	line2=LINEIN(FileIn2)
	IF line2 = "NOTES:=" THEN LEAVE
	END
DO while LINES(FileIn2)
	line2=LINEIN(FileIn2)
	IF line2="HISTORY:=" THEN LEAVE
	IF line2 \= "There are no notes for this contact." THEN DO
		IF line2 \= "" THEN notes=notes||line2||'A'x
		ELSE notes=notes||' '||'A'x
		END
	END
IF notes\="" THEN DO
	notes=STRIP(notes, 'T', 'A'x)
	Result=SetField(notesFieldNum, notes, "String", "cur");
	END
/* now find history items; tabs are delimiter within a history item */
DO while LINES(FileIn2)
	line2=LINEIN(FileIn2)
	IF line2="ACTIVITIES:=" THEN LEAVE
	IF line2 \= "You have no history for this contact." & line2\="" THEN DO
		DO j=1 TO 4
			PARSE VAR line2 act.j '9'x line2
			act.j=STRIP(act.j, 'B')
			END
		/* act.1 is date, .2 is time, .3 is type, .4 is summary */
		ActionRec=GetRec(0, actionType, "Temp")
		/* change type to match type in Activities */
		IF act.3='Meeting Held' THEN act.3='Meet'
		ELSE IF act.3='Last Meet' THEN act.3='Meet'
		ELSE IF act.3='Completed Call' THEN act.3='Call'
		ELSE IF act.3='To-do Done' THEN act.3='To-do'
		ELSE IF act.3='Letter Name' THEN act.3='Letter'
		ActionTypeRecNum=ConvertStringToDefineableComboBox(act.3, actionTypeType, 1)
		Result=SetField(actionTypeField, ActionTypeRecNum, "Int", "Temp")
		/* if in history section then action must be completed */
		Result=SetField(actionCompletedField, 1, "Int", "Temp")
		Result=SetField(actionDateField, act.1, "Date", "Temp")
		IF act.2 \= 'None' THEN Result=SetField(actionTimeField, act.2, "Time", "Temp")
		Result=SetField(actionSummaryField, act.4, "String", "Temp")
		Result=SetField(actionFreqField, 1, "Int", "Temp")
		NewRecNum=AddRec(ActionRec, 0, "Temp")
		Result=AddLink(NewRecNum)
		END
	END
DO while LINES(FileIn2)
	line2=LINEIN(FileIn2)
	CALL CHECK_IF_NEW_CONTACT
	IF foundNew=1 THEN LEAVE
	IF line2 \= "There are no activities for this contact." & line2\="" THEN DO
		DO j=1 TO 4
			PARSE VAR line2 act.j '9'x line2
			act.j=STRIP(act.j, 'B')
			END
		/* act.1 is type, .2 is date, .3 is time, .4 is summary */
		ActionRec=GetRec(0,actionType, "Temp")
		ActionTypeRecNum=ConvertStringToDefineableComboBox(act.1, actionTypeType, 1)
		Result=SetField(actionTypeField, ActionTypeRecNum, "Int", "Temp")
		/* if still in Activites section then action is not completed */
		Result=SetField(actionCompletedField, 0, "Int", "Temp")
		Result=SetField(actionDateField, act.2, "Date", "Temp")
		IF act.3 \= 'None' THEN Result=SetField(actionTimeField, act.3, "Time", "Temp")
		Result=SetField(actionSummaryField, act.4, "String", "Temp")
		Result=SetField(actionFreqField, 1, "Int", "Temp")
		NewRecNum=AddRec(ActionRec, 0, "Temp")
		Result=AddLink(NewRecNum)
		END
	END
RETURN


/* SUBROUTINE */
CHANGE_REC:
/* Need to break FullName into first, middle, last etc.  */
/*Act! only has explicit fields for FirstName and LastName, so we need to get the rest */
IF inBusiness = 0 & FullName \= "" THEN DO
	prefix=""
	middle=""
	suffix=""
	first = 0;
	last = 0;
	/* Parse the full name into words */
	/* Don't alter the FullName value */
	namestr=FullName
	DO j=1 TO 50
		IF namestr='' THEN LEAVE
		PARSE VAR namestr name.j namestr
		name.j=STRIP(name.j, 'B', ',')
		IF name.j = FirstName THEN first=j
		IF name.j = LastName THEN last=j
		END
	numnames=j-1
	IF last=0 THEN last=numnames
	IF first=0 THEN first=1
	DO j=1 TO first-1
		prefix = prefix||name.j||' '
		END
	DO j=(first+1) TO (last-1)
		middle = middle||name.j||' '
		END
	DO j=(last+1) TO numnames
		suffix = suffix||name.j||' '
		END
	prefix=STRIP(prefix, 'B')
	middle=STRIP(middle,'B')
	suffix=STRIP(suffix,'B')
	Result=SetField(prefixFieldNum, prefix, "String", "cur");
	Result=SetField(middleFieldNum, middle, "String", "cur");
	Result=SetField(suffixFieldNum, suffix, "String", "cur");
	END

/* Add in addresses if they're not blank */
/* need to make one string out of all the Address strings */
IF Address2 \= "" THEN Address1 = Address1||'A'x||Address2
IF Address3 \= "" THEN Address1 = Address1||'A'x||Address3
IF Address1 \= "" | City \= "" | State \= "" | Zip \= "" THEN DO
	subRec=GetSubRec(addressFieldNum, 0, "cur")
	Result=SetField(addressTypeFieldNum, 2, "Int", "SubRec")
	Result=SetField(addressAddressFieldNum, Address1, "String", "SubRec")
	Result=SetField(addressCityFieldNum, City, "String", "SubRec")
	Result=SetField(addressStateFieldNum, State, "String", "SubRec")
	Result=SetField(addressZipFieldNum, Zip, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
IF HomeAdd2 \= "" THEN HomeAdd1 = HomeAdd1||'A'x|| HomeAdd2
IF HomeAdd1 \= "" | HomeCity \= "" | HomeState \= "" | HomeZip \= "" THEN DO
	subRec=GetSubRec(addressFieldNum, 0, "cur")
	Result=SetField(addressTypeFieldNum, 1, "Int", "SubRec")
	Result=SetField(addressAddressFieldNum, HomeAdd1, "String", "SubRec")
	Result=SetField(addressCityFieldNum, HomeCity, "String", "SubRec")
	Result=SetField(addressStateFieldNum, HomeState, "String", "SubRec")
	Result=SetField(addressZipFieldNum, HomeZip, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
IF Email \= "" | EmailServer \= "" THEN DO
	subRec=GetSubRec(addressFieldNum, 0, "cur")
	Result=SetField(addressTypeFieldNum, 4, "Int", "SubRec")
	Result=SetField(addressAddressFieldNum, Email, "String", "SubRec")
	Result=SetField(addressNoteFieldNum, EmailServer, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END

/* Add in phones if they're not blank */
/* need to make one string out of all the Address strings */
IF BusPhoneExt \= "" THEN BusPhone = BusPhone||" Ext: "||BusPhoneExt
IF BusPhone \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 2, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, BusPhone, "String", "SubRec")
	/* put country code in note field; no sense putting it in number since typically need a city code */
	IF CountryPhoneCode \='1' & CountryPhoneCode\='' THEN DO
		CountryPhoneCode = "country code = "||CountryPhoneCode
		Result=SetField(phoneNoteFieldNum, CountryPhoneCode, "String", "SubRec")
		END
	Result=AddRec(subRec, 0, "SubRec")
	END
IF faxExt \= "" THEN Fax = Fax||" Ext: "||faxExt
IF Fax \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 6, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, Fax, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
IF HomeExt \= "" THEN HomePhone = HomePhone||" Ext: "||homeExt
IF HomePhone \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 1, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, HomePhone, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
/* for the alternate Phone numbers, need to append the title of the alternate person to the Phone note */
IF Alt1Ext \= "" THEN Alt1Phone = Alt1Phone||" Ext: "||Alt1Ext
IF Alt1Title \= "" THEN Alt1Name = Alt1Name||" "||Alt1Title
IF Alt1Phone \= "" | Alt1Name \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 2, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, Alt1Phone, "String", "SubRec")
	Result=SetField(phoneNoteFieldNum, Alt1Name, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
IF Alt2Ext \= "" THEN Alt2Phone = Alt2Phone||" Ext: "||Alt2Ext
IF Alt2Title \= "" THEN Alt2Name = Alt2Name||" "||Alt2Title
IF Alt2Phone \= "" | Alt2Name \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 2, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, Alt2Phone, "String", "SubRec")
	Result=SetField(phoneNoteFieldNum, Alt2Name, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END
IF CellPhone \= "" THEN DO
	subRec=GetSubRec(phoneFieldNum, 0, "cur")
	Result=SetField(phoneTypeFieldNum, 4, "Int", "SubRec")
	Result=SetField(phonePhoneFieldNum, CellPhone, "String", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END

/* add in 1 code */
IF Codeval \= "" THEN DO
	subRec=GetSubRec(codeFieldNum, 0, "cur")
	CodeRecNum=ConvertStringToDefineableComboBox(Codeval, codeTypeType, 1)
	Result=SetField(codeTypeField, CodeRecNum, "Int", "SubRec")
	Result=AddRec(subRec, 0, "SubRec")
	END

/* add in 2 files; first is a letter, second is a library */
IF Letter \= "" THEN DO
	FileRec=GetRec(0, fileType, "Temp")
	FileTypeRecNum=ConvertStringToDefineableComboBox("Letter", fileTypeType, 1)
	Result=SetField(fileTypeFieldNum, FileTypeRecNum, "Int", "Temp")
	Result=SetField(fileNameFieldNum, Letter, "String", "Temp")
	NewRecNum=AddRec(FileRec, 0, "Temp")
	Result=AddLink(NewRecNum)
	END
IF Library \= "" THEN DO
	FileRec=GetRec(0, fileType, "Temp")
	FileTypeRecNum=ConvertStringToDefineableComboBox("Library", fileTypeType, 1)
	Result=SetField(fileTypeFieldNum, FileTypeRecNum, "Int", "Temp")
	Result=SetField(fileNameFieldNum, Library, "String", "Temp")
	NewRecNum=AddRec(FileRec, 0, "Temp")
	Result=AddLink(NewRecNum)
	END

/* the ACT fields that have no correlation to fields in OmniFile are read into the Notes section so the data is not lost */
notes = ""
IF Asst \= "" THEN notes = notes || "Assistant: " || Asst || 'A'x
IF Refby \= "" THEN notes = notes || "Referred by " || Refby || 'A'x
IF useMgrOwner = 1 THEN DO
	IF Mgr \= "" THEN notes = notes || "Manager: " || Mgr || 'A'x
	IF Owner \= "" THEN notes = notes || "Owner: " || Owner || 'A'x
	END
IF u1 \= "" THEN notes = notes || "User field1: " || u1 || 'A'x
IF u2 \= "" THEN notes = notes || "User field2: " || u2 || 'A'x
IF u3 \= "" THEN notes = notes || "User field3: " || u3 || 'A'x
IF u4 \= "" THEN notes = notes || "User field4: " || u4 || 'A'x
IF u5 \= "" THEN notes = notes || "User field5: " || u5 || 'A'x
IF u6 \= "" THEN notes = notes || "User field6: " || u6 || 'A'x
IF u7 \= "" THEN notes = notes || "User field7: " || u7 || 'A'x
IF u8 \= "" THEN notes = notes || "User field8: " || u8 || 'A'x
IF u9 \= "" THEN notes = notes || "User field9: " || u9 || 'A'x
IF u10 \= "" THEN notes = notes || "User field10: " || u10 || 'A'x
IF u11 \= "" THEN notes = notes || "User field11: " || u11 || 'A'x
IF u12 \= "" THEN notes = notes || "User field12: " || u12 || 'A'x
IF u13 \= "" THEN notes = notes || "User field13: " || u13 || 'A'x
IF u14 \= "" THEN notes = notes || "User field14: " || u14 || 'A'x
IF u15 \= "" THEN notes = notes || "User field15: " || u15 || 'A'x
notes=STRIP(notes, 'T', 'A'x)
IF notes \= "" THEN Result=SetField(notesFieldNum, notes, "String", "cur");
RETURN


