/***************************************************************************
 *   Copyright (C) 2008 by Elad Lahav
 *   elad_lahav@users.sourceforge.net
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ***************************************************************************/

#include <QApplication>
#include "mainwindow.h"

int main(int argc, char** argv)
{
	#ifdef __amigaos4__
	static const char * __attribute__((used)) stackcookie = "$STACK: 2002936";
	#endif

	QApplication app(argc, argv);

	QCoreApplication::setOrganizationName("elad_lahav@users.sourceforge.net");
	QCoreApplication::setApplicationName("Quicky");

	MainWindow mainWnd;

	// Load the "Welcome" page first, so that there is some current document,
	// in case a file name is not specified on the command line, or it fails
	// to load.
	mainWnd.openHelp();

	mainWnd.show();

	// Open a file name specified on the command line.
	if (argc > 1)
		mainWnd.openFile(QApplication::arguments()[1]);

	// Start the application's event loop.
	return app.exec();
}

