/*****************************************************************************/
/* INSTALL.CMD Installation script using REXX, allowing upgrade installation */
/* (c)1997 Uwe Schlenther Software, Bebelstrae 30, 70193 Stuttgart, Germany */
/*****************************************************************************/

SIGNAL ON ERROR NAME Err

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs;

AppName="WarpNote"
ExeFile="WARPNOTE.EXE"
DefaultDir="C:\WarpNote"

Call SysFileTree ExeFile,"dirs","FO"

if dirs.0<>1 then do
  say ""
  say "It seems you haven't unpacked the archive file."
  say "Please do so and try again."
  exit
end

say ""
say "You're about to install "AppName". Welcome !"
say ""
say "Do you want to upgrade a previous installation of "AppName" ? (Y/N)"
pull answer

if answer="Y" then do
  call Upgrade
end
else do
  call Install
end

exit



CopyFiles:
  arg Path

  call SysMkDir Path

  INTERPRET "'COPY WARPNOTE.EX? 'Path'\*.*'"
  INTERPRET "'COPY WNOTEGER.DLL 'Path'\*.*'"
  INTERPRET "'COPY WNOTEFR.DLL 'Path'\*.*'"
  INTERPRET "'COPY WARPNOTE.INF 'Path'\*.*'"
  INTERPRET "'COPY WNCOMM.EXE 'Path'\*.*'"
  INTERPRET "'COPY WNHOOK.DLL 'Path'\*.*'"
  INTERPRET "'COPY BIRTHDAY.* 'Path'\*.*'"

  Call SysFileTree Path"\WARPNOTE.DLL","dllfile","FO"

  if dllfile.0=1 then do
    INTERPRET "'DEL 'Path'\WARPNOTE.DLL'"
    say ""
    say "You might need a new language module for the new version of WarpNote."
    say ""
  end

  say ""
  say "Do you want to use the German language module ?"
  say "Soll die deutsche Sprachuntersttzung aktiviert werden ?"
  say "(Y[es]/N[o])  (J[a]/N[ein])"
  PULL answer

  if (answer="Y") | (answer="J") then signal German

  say ""
  say "Do you want to use the French language module ?"
  say "Voulez-vous utiliser le module en franais ?"
  say "(Y[es]/N[o])  (O[ui]/N[on])"
  PULL answer

  if (answer="Y") | (answer="O") then signal French

  return 0

German:
  INTERPRET "'ren 'Path'\WNOTEGER.DLL WARPNOTE.DLL'"

return 0

French:
  INTERPRET "'ren 'Path'\WNOTEFR.DLL WARPNOTE.DLL'"

return 0

CreateObjects:
  arg Path

  say ""
  say "Do you want to create/update program objects for "AppName" ? (Y/N)"
  pull answer

  if answer="Y" then do
    say ""
    say "Creating WPS objects..."

    /* Folder */
    klasse='WPFolder'
    titel='WarpNote'
    ort='<WP_DESKTOP>'
    param='OBJECTID=<WNOTE_ORDNER>;'
    mode='f'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

    /* Das Programmobjekt anlegen */
    klasse='WPProgram'
    titel='WarpNote'
    ort='<WNOTE_ORDNER>'
    param='PROGTYPE=PM;EXENAME='Path'\WARPNOTE.EXE;STARTUPDIR='Path';'
    mode='r'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

    /* Das Hilfeobjekt anlegen */
    klasse='WPProgram'
    titel='WarpNote Information'
    ort='<WNOTE_ORDNER>'
    param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=VIEW.EXE;NOPRINT=YES;STARTUPDIR='Path';PARAMETERS='Path'\WARPNOTE.INF;'
    mode='r'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

    /* Das Geburtstagsobjekt anlegen */
    klasse='WPProgram'
    titel='Birthday Reminder'
    ort='<WNOTE_ORDNER>'
    param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME='Path'\BIRTHDAY.CMD;NOPRINT=YES;STARTUPDIR='Path';'
    mode='r'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

    klasse='WPProgram'
    titel='Birthday List'
    ort='<WNOTE_ORDNER>'
    param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME=E.EXE;NOPRINT=YES;STARTUPDIR='Path';PARAMETERS='Path'\BIRTHDAY.TXT;'
    mode='r'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

    /* Das Clipboard-Objekt anlegen */
    klasse='WPProgram'
    titel='Create Note from Clipboard'
    ort='<WNOTE_ORDNER>'
    param='PROGTYPE=PM;NOPRINT=YES;HELPPANEL=4083;EXENAME='Path'\WNCOMM.EXE;NOPRINT=YES;STARTUPDIR='Path';PARAMETERS=CLIPBOARD;'
    mode='r'
    rc = SysCreateObject(klasse,titel,ort,param,mode)

  end

return 0


Install:

Question:
  say ""
  say "Where do you want to copy the files for "AppName" ?"
  say "(e.g. "DefaultDir")  "
  PARSE PULL path
  IF path = "" THEN path=DefaultDir
  say ""
  say AppName" files will be copied to "path
  say ""
  say "Press <return> to continue, <E> to enter a new location or"
  say "<C> to cancel."
  pull answer

  if answer="C" then exit
  if answer="E" then signal Question

  call CopyFiles path

  call CreateObjects path

return 0

Upgrade:
  say ""
  say "Please make a backup copy of the birthday list BIRTHDAY.TXT in"
  say "the WarpNote directory if you have made changes."
  say ""
  say "Press RETURN to continue..."
  pull answer

  dirs.0=0

  do until (LENGTH(drive)=1) & (dirs.0>0)
    say ""
    say "On what drive do you expect your installation ? (C,D,...)"
    pull drive
    if LENGTH(drive)=1 then do
      call SysFileTree drive":\"ExeFile,"dirs","FSO"
      if dirs.0=0 then say "The installation was not found on drive "drive"."
    end
  end

  do i=1 to dirs.0
    dirs.i=FILESPEC("D",dirs.i) || FILESPEC("P",dirs.i)
    l=LENGTH(dirs.i)
    if l>3 then if SUBSTR(dirs.i,l,1)="\" then dirs.i=SUBSTR(dirs.i,1,l-1)
    say ""
    say "Do you want to upgrade "AppName" in "dirs.i" ? (Y/N)"
    say ""
    pull answer
    if answer="Y" then do
      call CopyFiles dirs.i
      call CreateObjects dirs.i
    end
  end
return 0

Err:
  say ""
  say "An error has occured. Possible causes are:"
  say ""
  say " - You have interrupted installation by pressing CTRL-BREAK."
  say " - A file is missing in the package. Try to unpack the archive file again."
  say " - A file cannot be replaced because it is in use. Make sure the program"
  say "   you're about to install is not running currently."
  say ""
  say "Please try again later."
exit

